#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Include functionality tests.
#
# $Id: include.py,v 1.6 2003/01/24 11:34:31 andrewm Exp $

import unittest
import albatross
import albatross_test

class IncludeCase(albatross_test.AlbatrossTestCase):
    template_dir = "include"

    def check_name(self):
        self.html_test("name.html", "plain\n")

    def check_expr(self):
        self.ctx.locals.filename = "name.html"
        self.html_test("expr.html", "plain\n")

    def check_nested(self):
        self.html_test("nested.html", "plain\n")

    def check_nxfile(self):
        self.assertRaises(albatross.ApplicationError, self.html_test, "incnxfile.html", "(none)")

class IncludeSuite(unittest.TestSuite):
    test_list = (
        "check_name",
        "check_expr",
        "check_nested",
        "check_nxfile",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(IncludeCase, self.test_list))

def suite():
    return IncludeSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
