/* A Bison parser, made by GNU Bison 1.875c.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     IF = 258,
     PP = 259,
     MM = 260,
     MAX = 261,
     MIN = 262,
     SUP = 263,
     INF = 264,
     SORT = 265,
     RSORT = 266,
     MESS = 267,
     DEF = 268,
     NDEF = 269,
     NUMBER = 270,
     IDENT = 271,
     REGEX = 272
   };
#endif
#define IF 258
#define PP 259
#define MM 260
#define MAX 261
#define MIN 262
#define SUP 263
#define INF 264
#define SORT 265
#define RSORT 266
#define MESS 267
#define DEF 268
#define NDEF 269
#define NUMBER 270
#define IDENT 271
#define REGEX 272




/* Copy the first part of user declarations.  */
#line 1 "../../../src/exp/src/expy.y"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "exp.h"
#include "ht.h"

#define VERBOSE        (int)((htget(dico, "verbose")->VAL.f+EPSILON))
#define EPSILON        0.00001
#define anint(x)       floor((x) + 0.5) 
#define test_init(i)   if (((i)->TYPE==0) && ((pcond==0) || (cond[pcond]>0.))) {\
                         printf(" %-3d %s : <%s> undefined\n", lineno, expfname, (i)->KEY);\
                         exit (1);}\
                       (i)->USED = 1
#define pa(v,e) if (VERBOSE>2) printf("%7.3f -> %s\n",e,v->KEY)
#define pi(e)   if (VERBOSE>2) printf("%7.3f <- %s\n",e->VAL.f,e->KEY)
#define pe(s,n) if (VERBOSE>2) printf("%7.3f %s\n",n,s)
#define PCONDMAX 16 /* profondeur de la pile de conditions */

int lineno=1;
char * expfname;
ht_t * dico;

static int pcond=0;
static double cond[PCONDMAX]; /* pile de conditions : +1:vrai, -1:faux */
static char * string_fmt = "%-65s";
static char * float_fmt = "%7.3f";
static char * integer_fmt = "%4d";
static htelt_t * ele;

double limit (int fun, htelt_t * args)
{
  htelt_t *ele;
  double res;
  for (ele = args; ele && ele->TYPE == 0; ele = ele->NEXT);
  if (ele == NULL)
  {  
    printf(" %-3d %s : none variable defined\n", lineno, expfname);\
    exit (1);
  }
  res = ele->VAL.f;
  for (; ele; ele = ele->NEXT)
    if ((ele->TYPE != 0) && (((fun == MAX) && (res < ele->VAL.f)) || ((fun == MIN) && (res > ele->VAL.f))))
      res = ele->VAL.f;
  eltremove (args);
  return res;
}

htelt_t *bsort (int sens, htelt_t * args)
{
  htelt_t *ele;
  int bubble = 1;
  if (args->NEXT) /* au moins de 2 elements dans la liste */
    while (bubble)
    {
      bubble = 0;
      for (ele = args; ele->NEXT; ele = ele->NEXT)
        if (((sens == SORT) && (((ele->VAL.e)->VAL.f) > (((ele->NEXT)->VAL.e)->VAL.f)))
        || ((sens == RSORT) && (((ele->VAL.e)->VAL.f) < (((ele->NEXT)->VAL.e)->VAL.f)))
        || ((sens == MESS) && (strcmp((ele->VAL.e)->KEY,((ele->NEXT)->VAL.e)->KEY)>0)))
        {
          htelt_t *tmp = ele->VAL.e;
          ele->VAL.e = (ele->NEXT)->VAL.e;
          (ele->NEXT)->VAL.e = tmp;
          bubble = 1;
        }
    }    
  return args;
}

htelt_t *mess (int type, char *fmt, htelt_t * args)
{
  htelt_t *ele;
  if (VERBOSE)
  {
    for (ele = args; ele; ele = ele->NEXT)
    {
      if ((type == MESS) || ((ele->VAL.e)->TYPE == HT_FLOAT))
      {
        printf (string_fmt, (ele->VAL.e)->KEY);
        if ((ele->VAL.e)->TYPE == HT_FLOAT)
        {
          printf (" = ");
          printf (fmt, (ele->VAL.e)->VAL.f);
        }
        printf ("\n");
      }
    }
  }
  eltremove (args);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 95 "../../../src/exp/src/expy.y"
typedef union YYSTYPE {
  htelt_t * e;
  double    f;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 209 "expy.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 221 "expy.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  26
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   254

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  33
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  8
/* YYNRULES -- Number of rules. */
#define YYNRULES  46
/* YYNRULES -- Number of states. */
#define YYNSTATES  121

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   272

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      29,    30,    23,    21,    32,    22,     2,    24,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    31,
      19,    18,    20,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    25,     2,    26,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    27,     2,    28,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     4,     7,    12,    17,    21,    25,    32,
      39,    46,    53,    60,    67,    71,    75,    78,    82,    86,
      88,    90,    93,    96,   100,   104,   108,   112,   116,   120,
     124,   127,   134,   141,   148,   153,   158,   163,   168,   170,
     172,   176,   178,   182,   184,   188,   190
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      34,     0,    -1,    -1,    35,    34,    -1,    25,    36,    37,
      26,    -1,    27,    36,    37,    28,    -1,    25,    37,    26,
      -1,    27,    37,    28,    -1,    25,    10,    29,    39,    30,
      26,    -1,    27,    10,    29,    39,    30,    28,    -1,    25,
      11,    29,    39,    30,    26,    -1,    27,    11,    29,    39,
      30,    28,    -1,    25,    12,    29,    39,    30,    26,    -1,
      27,    12,    29,    39,    30,    28,    -1,    25,    36,    26,
      -1,    27,    36,    28,    -1,    37,    31,    -1,    36,    37,
      31,    -1,    16,    18,    37,    -1,    15,    -1,    16,    -1,
      16,     4,    -1,    16,     5,    -1,    37,    19,    37,    -1,
      37,    20,    37,    -1,    37,    21,    37,    -1,    37,    22,
      37,    -1,    37,    23,    37,    -1,    37,    24,    37,    -1,
      29,    37,    30,    -1,    22,    37,    -1,     3,    29,    38,
      32,    40,    30,    -1,     8,    29,    37,    32,    37,    30,
      -1,     9,    29,    37,    32,    37,    30,    -1,     6,    29,
      40,    30,    -1,     7,    29,    40,    30,    -1,    13,    29,
      16,    30,    -1,    14,    29,    16,    30,    -1,    37,    -1,
      16,    -1,    16,    32,    39,    -1,    17,    -1,    17,    32,
      39,    -1,    37,    -1,    37,    32,    40,    -1,    17,    -1,
      17,    32,    40,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned char yyrline[] =
{
       0,   109,   109,   110,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   125,   126,   128,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   150,   151,   152,   153,   154,   155,   157,   163,
     164,   165,   166,   168,   169,   170,   178
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "IF", "PP", "MM", "MAX", "MIN", "SUP",
  "INF", "SORT", "RSORT", "MESS", "DEF", "NDEF", "NUMBER", "IDENT",
  "REGEX", "'='", "'<'", "'>'", "'+'", "'-'", "'*'", "'/'", "'['", "']'",
  "'{'", "'}'", "'('", "')'", "';'", "','", "$accept", "blocs", "bloc",
  "exps", "exp", "cond", "idents", "args", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,    61,    60,
      62,    43,    45,    42,    47,    91,    93,   123,   125,    40,
      41,    59,    44
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    33,    34,    34,    35,    35,    35,    35,    35,    35,
      35,    35,    35,    35,    35,    35,    36,    36,    37,    37,
      37,    37,    37,    37,    37,    37,    37,    37,    37,    37,
      37,    37,    37,    37,    37,    37,    37,    37,    38,    39,
      39,    39,    39,    40,    40,    40,    40
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     2,     4,     4,     3,     3,     6,     6,
       6,     6,     6,     6,     3,     3,     2,     3,     3,     1,
       1,     2,     2,     3,     3,     3,     3,     3,     3,     3,
       2,     6,     6,     6,     4,     4,     4,     4,     1,     1,
       3,     1,     3,     1,     3,     1,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     0,     0,     2,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    19,    20,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     1,     3,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    21,    22,
       0,    30,     0,    14,     0,     0,     0,     0,     0,     0,
       0,     6,    16,     0,     0,     0,    15,     0,     7,    38,
       0,    45,    43,     0,     0,     0,     0,    39,    41,     0,
       0,     0,     0,     0,    18,    29,     4,    17,    23,    24,
      25,    26,    27,    28,     0,     0,     0,     5,     0,     0,
       0,    34,    35,     0,     0,     0,     0,     0,     0,     0,
      36,    37,     0,     0,     0,     0,    46,    44,     0,     0,
      40,    42,     8,    10,    12,     9,    11,    13,    31,    32,
      33
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     3,     4,    19,    62,    60,    69,    63
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -30
static const short yypact[] =
{
     -17,    62,    91,     7,   -17,   -18,     0,     9,    11,    12,
      13,    14,    22,    29,    34,   -30,    32,   142,   142,     6,
      33,    50,    51,    52,   108,   167,   -30,   -30,   142,   125,
     125,   142,   142,   -13,   -13,   -13,    67,    79,   -30,   -30,
     142,    10,    66,   -30,   180,   142,   142,   142,   142,   142,
     142,   -30,   -30,   -13,   -13,   -13,   -30,   193,   -30,   230,
      76,    77,   146,    80,    82,   153,   160,    86,    87,    95,
      96,    97,    99,   105,   230,   -30,   -30,   -30,   230,   230,
      10,    10,   -30,   -30,   113,   114,   116,   -30,   125,   125,
     125,   -30,   -30,   142,   142,   -13,   -13,    56,   126,   127,
     -30,   -30,   131,   132,   133,   163,   -30,   -30,   206,   218,
     -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,   -30,
     -30
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
     -30,   158,   -30,   161,    -1,   -30,   -29,   -28
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
      20,    25,    64,    67,    68,    70,    71,    26,     1,     5,
       2,    28,     6,     7,     8,     9,    41,    42,    44,    13,
      14,    15,    16,    57,    84,    85,    86,    59,    17,    29,
      65,    66,    43,    49,    50,    18,    38,    39,    30,    74,
      31,    32,    33,    34,    78,    79,    80,    81,    82,    83,
      40,    35,    45,    46,    47,    48,    49,    50,    36,    51,
     105,   106,   107,    37,    52,     5,   110,   111,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    53,
      54,    55,   112,    72,    17,    45,    46,    47,    48,    49,
      50,    18,   108,   109,     5,    73,    75,     6,     7,     8,
       9,    21,    22,    23,    13,    14,    15,    16,    88,    89,
      91,     5,    92,    17,     6,     7,     8,     9,    95,    96,
      18,    13,    14,    15,    16,    97,    98,    99,     5,   100,
      17,     6,     7,     8,     9,   101,    56,    18,    13,    14,
      15,    16,    61,   102,   103,     5,   104,    17,     6,     7,
       8,     9,   113,   114,    18,    13,    14,    15,    16,   115,
     116,   117,    27,    24,    17,    45,    46,    47,    48,    49,
      50,    18,    45,    46,    47,    48,    49,    50,    90,    45,
      46,    47,    48,    49,    50,    93,    45,    46,    47,    48,
      49,    50,    94,   118,     0,    58,     0,     0,    52,    45,
      46,    47,    48,    49,    50,     0,    76,     0,     0,     0,
       0,    77,    45,    46,    47,    48,    49,    50,     0,     0,
       0,    87,     0,     0,    77,    45,    46,    47,    48,    49,
      50,     0,     0,     0,     0,     0,   119,    45,    46,    47,
      48,    49,    50,     0,     0,     0,     0,     0,   120,    45,
      46,    47,    48,    49,    50
};

static const yysigned_char yycheck[] =
{
       1,     2,    30,    16,    17,    34,    35,     0,    25,     3,
      27,    29,     6,     7,     8,     9,    17,    18,    19,    13,
      14,    15,    16,    24,    53,    54,    55,    28,    22,    29,
      31,    32,    26,    23,    24,    29,     4,     5,    29,    40,
      29,    29,    29,    29,    45,    46,    47,    48,    49,    50,
      18,    29,    19,    20,    21,    22,    23,    24,    29,    26,
      88,    89,    90,    29,    31,     3,    95,    96,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    29,
      29,    29,    26,    16,    22,    19,    20,    21,    22,    23,
      24,    29,    93,    94,     3,    16,    30,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    32,    32,
      30,     3,    30,    22,     6,     7,     8,     9,    32,    32,
      29,    13,    14,    15,    16,    30,    30,    30,     3,    30,
      22,     6,     7,     8,     9,    30,    28,    29,    13,    14,
      15,    16,    17,    30,    30,     3,    30,    22,     6,     7,
       8,     9,    26,    26,    29,    13,    14,    15,    16,    28,
      28,    28,     4,     2,    22,    19,    20,    21,    22,    23,
      24,    29,    19,    20,    21,    22,    23,    24,    32,    19,
      20,    21,    22,    23,    24,    32,    19,    20,    21,    22,
      23,    24,    32,    30,    -1,    28,    -1,    -1,    31,    19,
      20,    21,    22,    23,    24,    -1,    26,    -1,    -1,    -1,
      -1,    31,    19,    20,    21,    22,    23,    24,    -1,    -1,
      -1,    28,    -1,    -1,    31,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    19,    20,    21,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    19,
      20,    21,    22,    23,    24
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    25,    27,    34,    35,     3,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    22,    29,    36,
      37,    10,    11,    12,    36,    37,     0,    34,    29,    29,
      29,    29,    29,    29,    29,    29,    29,    29,     4,     5,
      18,    37,    37,    26,    37,    19,    20,    21,    22,    23,
      24,    26,    31,    29,    29,    29,    28,    37,    28,    37,
      38,    17,    37,    40,    40,    37,    37,    16,    17,    39,
      39,    39,    16,    16,    37,    30,    26,    31,    37,    37,
      37,    37,    37,    37,    39,    39,    39,    28,    32,    32,
      32,    30,    30,    32,    32,    32,    32,    30,    30,    30,
      30,    30,    30,    30,    30,    40,    40,    40,    37,    37,
      39,    39,    26,    26,    26,    28,    28,    28,    30,    30,
      30
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 109 "../../../src/exp/src/expy.y"
    { if (VERBOSE>1) htstat(dico); return 1;}
    break;

  case 4:
#line 112 "../../../src/exp/src/expy.y"
    { fprintf (yyout, float_fmt, yyvsp[-1].f);}
    break;

  case 5:
#line 113 "../../../src/exp/src/expy.y"
    { fprintf (yyout, integer_fmt, (int)yyvsp[-1].f);}
    break;

  case 6:
#line 114 "../../../src/exp/src/expy.y"
    { fprintf (yyout, float_fmt, yyvsp[-1].f);}
    break;

  case 7:
#line 115 "../../../src/exp/src/expy.y"
    { fprintf (yyout, integer_fmt, (int)yyvsp[-1].f);}
    break;

  case 8:
#line 116 "../../../src/exp/src/expy.y"
    { mess(SORT,float_fmt, bsort (SORT, yyvsp[-2].e));}
    break;

  case 9:
#line 117 "../../../src/exp/src/expy.y"
    { mess(SORT,integer_fmt, bsort (SORT, yyvsp[-2].e));}
    break;

  case 10:
#line 118 "../../../src/exp/src/expy.y"
    { mess(SORT,float_fmt, bsort (RSORT, yyvsp[-2].e));}
    break;

  case 11:
#line 119 "../../../src/exp/src/expy.y"
    { mess(SORT,integer_fmt, bsort (RSORT, yyvsp[-2].e));}
    break;

  case 12:
#line 120 "../../../src/exp/src/expy.y"
    { mess(MESS,float_fmt, bsort (MESS, yyvsp[-2].e));}
    break;

  case 13:
#line 121 "../../../src/exp/src/expy.y"
    { mess(MESS,integer_fmt, bsort (MESS, yyvsp[-2].e));}
    break;

  case 14:
#line 122 "../../../src/exp/src/expy.y"
    { }
    break;

  case 15:
#line 123 "../../../src/exp/src/expy.y"
    { }
    break;

  case 16:
#line 125 "../../../src/exp/src/expy.y"
    { }
    break;

  case 17:
#line 126 "../../../src/exp/src/expy.y"
    { }
    break;

  case 18:
#line 128 "../../../src/exp/src/expy.y"
    { if ((pcond==0) || (cond[pcond]>0.)) {
                                          yyvsp[-2].e->VAL.f=yyvsp[0].f; yyvsp[-2].e->TYPE=HT_FLOAT; 
                                          yyvsp[-2].e->FNAME=expfname; yyvsp[-2].e->FLINE=lineno; 
                                          yyval.f=yyvsp[0].f; pa(yyvsp[-2].e,yyval.f);
                                        }
                                      }
    break;

  case 19:
#line 134 "../../../src/exp/src/expy.y"
    { yyval.f = yyvsp[0].f;  pe(" ",yyval.f);}
    break;

  case 20:
#line 135 "../../../src/exp/src/expy.y"
    { test_init(yyvsp[0].e); yyval.f = yyvsp[0].e->VAL.f; pi(yyvsp[0].e);}
    break;

  case 21:
#line 136 "../../../src/exp/src/expy.y"
    { test_init(yyvsp[-1].e); yyval.f = yyvsp[-1].e->VAL.f; yyvsp[-1].e->VAL.f += 1.0;}
    break;

  case 22:
#line 137 "../../../src/exp/src/expy.y"
    { test_init(yyvsp[-1].e); yyval.f = yyvsp[-1].e->VAL.f; yyvsp[-1].e->VAL.f -= 1.0;}
    break;

  case 23:
#line 138 "../../../src/exp/src/expy.y"
    { yyval.f = (yyvsp[-2].f < yyvsp[0].f) ? 1. : -1.; pe(" < ",yyval.f);}
    break;

  case 24:
#line 139 "../../../src/exp/src/expy.y"
    { yyval.f = (yyvsp[-2].f > yyvsp[0].f) ? 1. : -1.; pe(" > ",yyval.f);}
    break;

  case 25:
#line 140 "../../../src/exp/src/expy.y"
    { yyval.f = yyvsp[-2].f + yyvsp[0].f; pe(" + ",yyval.f);}
    break;

  case 26:
#line 141 "../../../src/exp/src/expy.y"
    { yyval.f = yyvsp[-2].f - yyvsp[0].f; pe(" - ",yyval.f);}
    break;

  case 27:
#line 142 "../../../src/exp/src/expy.y"
    { yyval.f = yyvsp[-2].f * yyvsp[0].f; pe(" * ",yyval.f);}
    break;

  case 28:
#line 143 "../../../src/exp/src/expy.y"
    { yyval.f = yyvsp[-2].f / yyvsp[0].f; pe(" / ",yyval.f);}
    break;

  case 29:
#line 144 "../../../src/exp/src/expy.y"
    { yyval.f = yyvsp[-1].f;}
    break;

  case 30:
#line 145 "../../../src/exp/src/expy.y"
    { yyval.f = -yyvsp[0].f; pe(" - ",yyval.f);}
    break;

  case 31:
#line 146 "../../../src/exp/src/expy.y"
    { for (ele = yyvsp[-1].e; ele->NEXT; ele = ele->NEXT);
                                        yyval.f = ele->VAL.f;
                                        pcond--; eltremove (yyvsp[-1].e); 
                                      }
    break;

  case 32:
#line 150 "../../../src/exp/src/expy.y"
    { yyval.f = anint((yyvsp[-1].f+(yyvsp[-3].f/2)-EPSILON)/yyvsp[-3].f)*yyvsp[-3].f; pe(" sup ",yyval.f);}
    break;

  case 33:
#line 151 "../../../src/exp/src/expy.y"
    { yyval.f = ((int)(floor((yyvsp[-1].f+EPSILON)/yyvsp[-3].f)))*yyvsp[-3].f; pe(" inf ",yyval.f);}
    break;

  case 34:
#line 152 "../../../src/exp/src/expy.y"
    { yyval.f = limit (MAX, yyvsp[-1].e); pe(" max ",yyval.f);}
    break;

  case 35:
#line 153 "../../../src/exp/src/expy.y"
    { yyval.f = limit (MIN, yyvsp[-1].e); pe(" min ",yyval.f);}
    break;

  case 36:
#line 154 "../../../src/exp/src/expy.y"
    { yyval.f = (yyvsp[-1].e->TYPE==0) ? -1. : +1.; pe(yyvsp[-1].e,yyval.f);}
    break;

  case 37:
#line 155 "../../../src/exp/src/expy.y"
    { yyval.f = (yyvsp[-1].e->TYPE==0) ? +1. : -1.; pe(yyvsp[-1].e,yyval.f);}
    break;

  case 38:
#line 157 "../../../src/exp/src/expy.y"
    { if (pcond < PCONDMAX) 
                                          cond[++pcond] = yyvsp[0].f; 
                                        else
                                          yyerror ("too much conditions");
                                      }
    break;

  case 39:
#line 163 "../../../src/exp/src/expy.y"
    { yyval.e = eltadd (NULL,NULL); yyval.e->VAL.e=yyvsp[0].e;}
    break;

  case 40:
#line 164 "../../../src/exp/src/expy.y"
    { yyval.e = eltadd (yyvsp[0].e,NULL); yyval.e->VAL.e=yyvsp[-2].e;}
    break;

  case 41:
#line 165 "../../../src/exp/src/expy.y"
    { yyval.e = yyvsp[0].e->NEXT; yyvsp[0].e->NEXT=NULL;}
    break;

  case 42:
#line 166 "../../../src/exp/src/expy.y"
    { yyval.e = yyvsp[-2].e->NEXT; yyvsp[-2].e->NEXT=yyvsp[0].e;}
    break;

  case 43:
#line 168 "../../../src/exp/src/expy.y"
    { yyval.e = eltadd (NULL,NULL); yyval.e->VAL.f=yyvsp[0].f; yyval.e->TYPE=HT_FLOAT;pe(" , ",yyvsp[0].f);}
    break;

  case 44:
#line 169 "../../../src/exp/src/expy.y"
    { yyval.e = eltadd (yyvsp[0].e,NULL); yyval.e->VAL.f=yyvsp[-2].f; yyval.e->TYPE=HT_FLOAT;pe(" , ",yyvsp[0].e);}
    break;

  case 45:
#line 170 "../../../src/exp/src/expy.y"
    { yyval.e = yyvsp[0].e->NEXT; yyvsp[0].e->NEXT=NULL; 
                                        for (ele = yyval.e; ele; ele = ele->NEXT)
                                        {  
                                          ele->VAL.e->USED = 1;
                                          ele->TYPE = (ele->VAL.e)->TYPE;
                                          ele->VAL.f = (ele->VAL.e)->VAL.f;
                                        }  
                                      }
    break;

  case 46:
#line 178 "../../../src/exp/src/expy.y"
    { yyval.e = yyvsp[-2].e->NEXT; yyvsp[-2].e->NEXT=yyvsp[0].e;   
                                        for (ele = yyvsp[-2].e; ele; ele = ele->NEXT)
                                        {
                                          ele->VAL.e->USED = 1;
                                          ele->TYPE = (ele->VAL.e)->TYPE;
                                          ele->VAL.f = ele->VAL.e->VAL.f;
                                        }  
                                      }
    break;


    }

/* Line 1000 of yacc.c.  */
#line 1464 "expy.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
		 yydestruct (yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
	  yydestruct (yytoken, &yylval);
	  yychar = YYEMPTY;

	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 187 "../../../src/exp/src/expy.y"

int yyerror(char *s)
{
  printf(" %-3d %s : %s\n", lineno, expfname, s);
  exit (1);
}

