/* $Id: wmaction.c,v 1.7 2000/10/30 21:21:19 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "wmaction.h"
#include "wmmain.h"
#include "wmclient.h"
#include "wmdrag.h"

#define DEFINE_GROUP_FUNC(func) \
void func##_group(GtkWidget *widget, GdkEvent *event, gpointer data) \
{\
    wm_action_for_group(widget, event, data, func);\
}

void wm_action_for_group(GtkWidget *widget, GdkEvent *event, gpointer data,
			 void (* func)(GtkWidget*, GdkEvent*, gpointer))
{
    GList *list;

    for(list = WM_CLIENT_TARGET(data)->list; list; list = list->next) {
	(* func)(widget, event, list->data);
    }
}

void wm_action_raise(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    GList *list;
    /* ˡ, reaise_group 򤹤ȥꥹȹ¤ʤ */
    for(list = WM_CLIENT_GROUP(data); list; list = list->next) { 
	WM_GROUP_LIST(list->data) =
	    g_list_remove(WM_GROUP_LIST(list->data), data);
	WM_GROUP_LIST(list->data) =
	    g_list_append(WM_GROUP_LIST(list->data), data);
    }
    gdk_window_raise(gtk_widget_get_toplevel(data)->window);
}
DEFINE_GROUP_FUNC(wm_action_raise);

void wm_action_lower(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    GList *list;
    for(list = WM_CLIENT_GROUP(data); list; list = list->next) { 
	WM_GROUP_LIST(list->data) =
	    g_list_remove(WM_GROUP_LIST(list->data), data);
	WM_GROUP_LIST(list->data) =
	    g_list_prepend(WM_GROUP_LIST(list->data), data);
    }
    gdk_window_lower(gtk_widget_get_toplevel(data)->window);
}
DEFINE_GROUP_FUNC(wm_action_lower);

void wm_action_iconify(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    wm_client_iconify(WM_CLIENT(data));
}
DEFINE_GROUP_FUNC(wm_action_iconify);

void wm_action_deiconify(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    gtk_widget_show(GTK_WIDGET(data));
}
DEFINE_GROUP_FUNC(wm_action_deiconify);

void wm_action_move(GtkWidget *widget, GdkEventMotion *event, gpointer data)
{
    gint dx, dy;
    wm_drag_get_increase((int)(event->x_root), (int)(event->y_root), &dx, &dy);
    wm_client_move(data, 
		   WM_CLIENT_X_PREV(data) + dx, WM_CLIENT_Y_PREV(data) + dy);
}
DEFINE_GROUP_FUNC(wm_action_move);

void wm_action_resize(GtkWidget *widget, GdkEventMotion *event, gpointer data)
{
    gint dx, dy;
    wm_drag_get_increase((int)(event->x_root), (int)(event->y_root), &dx, &dy);
    wm_client_move_resize(data, 
			  WM_CLIENT_X(data), WM_CLIENT_Y(data),
			  WM_CLIENT_W_PREV(data) + dx,
			  WM_CLIENT_H_PREV(data) + dy);
}
DEFINE_GROUP_FUNC(wm_action_resize);

void wm_action_resize_rx(GtkWidget *widget, GdkEventMotion *event,
			 gpointer data)
{
    gint dx, dy;
    wm_drag_get_increase((int)(event->x_root), (int)(event->y_root), &dx, &dy);
    wm_client_resize_with_gravity(data, 
				  WM_CLIENT_W_PREV(data) - dx,
				  WM_CLIENT_H_PREV(data) + dy,
				  NorthEastGravity);
}
DEFINE_GROUP_FUNC(wm_action_resize_rx);

void wm_action_resize_vertical(GtkWidget *widget, GdkEventMotion *event, 
			       gpointer data)
{
    gint dx, dy;
    wm_drag_get_increase((int)(event->x_root), (int)(event->y_root), &dx, &dy);
    wm_client_move_resize(data, 
			  WM_CLIENT_X(data), WM_CLIENT_Y(data),
			  WM_CLIENT_W_PREV(data),
			  WM_CLIENT_H_PREV(data) + dy);
}
DEFINE_GROUP_FUNC(wm_action_resize_vertical);

void wm_action_resize_horizontal(GtkWidget *widget, GdkEventMotion *event, 
				 gpointer data)
{
    gint dx, dy;
    wm_drag_get_increase((int)(event->x_root), (int)(event->y_root), &dx, &dy);
    wm_client_move_resize(data, 
			  WM_CLIENT_X(data), WM_CLIENT_Y(data),
			  WM_CLIENT_W_PREV(data) + dx,
			  WM_CLIENT_H_PREV(data));
}
DEFINE_GROUP_FUNC(wm_action_resize_horizontal);

void wm_action_close(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    wm_client_delete(WM_CLIENT(data));
}
DEFINE_GROUP_FUNC(wm_action_close);

void wm_action_destroy(GtkWidget *widget, GdkEvent *event, gpointer data)
{
    gtk_widget_destroy(gtk_widget_get_toplevel(data));
}
DEFINE_GROUP_FUNC(wm_action_destroy);
