/* $Id: wmclient.h,v 1.32 2000/10/30 20:25:19 komatsu Exp $ */

#ifndef __WM_CLIENT_H__
#define __WM_CLIENT_H__

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <glib.h>

#include <gtk/gtkwidget.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define WM_CLIENT(obj)          GTK_CHECK_CAST (obj, wm_client_get_type (), WmClient)
#define WM_CLIENT_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, wm_client_get_type (), WmClientClass)
#define IS_WM_CLIENT(obj)       GTK_CHECK_TYPE (obj, wm_client_get_type ())

#define WM_CLIENT_X(obj)      ((gint16)(((WmClient *)obj)->x))
#define WM_CLIENT_Y(obj)      ((gint16)(((WmClient *)obj)->y))
#define WM_CLIENT_X_PREV(obj)  ((guint16)((WmClient *)obj)->priviousX)
#define WM_CLIENT_Y_PREV(obj) ((guint16)((WmClient *)obj)->priviousY)
#define WM_CLIENT_WIDTH(obj)  ((guint16)((WmClient *)obj)->width)
#define WM_CLIENT_HEIGHT(obj) ((guint16)((WmClient *)obj)->height)
#define WM_CLIENT_W_PREV(obj)  ((guint16)((WmClient *)obj)->priviousWidth)
#define WM_CLIENT_H_PREV(obj) ((guint16)((WmClient *)obj)->priviousHeight)
#define WM_CLIENT_SIZE_FLAG(obj) ((guint16)((WmClient *)obj)->size_flags)
#define WM_CLIENT_W_INC(obj)  ((gint16)((WmClient *)obj)->width_inc)
#define WM_CLIENT_H_INC(obj)  ((gint16)((WmClient *)obj)->height_inc)
#define WM_CLIENT_W_BASE(obj)  ((gint16)((WmClient *)obj)->base_width)
#define WM_CLIENT_H_BASE(obj)  ((gint16)((WmClient *)obj)->base_height)
#define WM_CLIENT_W_MIN(obj)  ((gint16)((WmClient *)obj)->min_width)
#define WM_CLIENT_H_MIN(obj)  ((gint16)((WmClient *)obj)->min_height)
#define WM_CLIENT_W_MAX(obj)  ((gint16)((WmClient *)obj)->max_width)
#define WM_CLIENT_H_MAX(obj)  ((gint16)((WmClient *)obj)->max_height)
#define WM_CLIENT_STATE(obj)  ((gint16)((WmClient *)obj)->state)
#define WM_CLIENT_BORDER_WIDTH(obj)  ((guint16)((WmClient *)obj)->border_width)
#define WM_CLIENT_BORDER_FRAME(obj)  ((gchar *)((WmClient *)obj)->border_frame)
#define WM_CLIENT_GROUP(obj)  (((WmClient *)obj)->group)
#define WM_CLIENT_TARGET(obj) (((WmClient *)obj)->target)
#define WM_CLIENT_NAME(obj)   (((WmClient *)obj)->name)
#define WM_CLIENT_CLASS_HINT(obj)  (((WmClient *)obj)->class)
#define WM_CLIENT_TITLE(obj)  (((WmClient *)obj)->title)
#define WM_CLIENT_ICON(obj)   (((WmClient *)obj)->icon)
#define WM_CLIENT_XWINDOW(obj) (WM_CLIENT(obj)->client)
#define WM_CLIENT_WINDOW(obj)  (WM_CLIENT(obj)->widget.window)
#define WM_CLIENT_TITLE_FORMAT(obj)  (((WmClient *)obj)->format)

typedef struct _WmClient        WmClient;
typedef struct _WmClientClass   WmClientClass;

#if 1
struct _WmGroup {
    gchar   *title;
    GList   *list;
    GList   *withdrawns;
    Window   leader;
    gboolean auto_destroy;
};

typedef struct _WmGroup WmGroup;
#define WM_GROUP_TITLE(obj)      (((WmGroup *)obj)->title)
#define WM_GROUP_LIST(obj)       (((WmGroup *)obj)->list)
#define WM_GROUP_WITHDRAWNS(obj) (((WmGroup *)obj)->withdrawns)
#define WM_GROUP_LEADER(obj)     (((WmGroup *)obj)->leader)

#endif

struct _WmClient
{
    GtkWidget widget;

    Window client;
    gint16 x;
    gint16 y;
    guint16 width;
    guint16 height;

    guint16 size_flags;
    gint16 width_inc;
    gint16 height_inc;
    gint16 base_width;
    gint16 base_height;
    gint16 min_width;
    gint16 min_height;
    gint16 max_width;
    gint16 max_height;

    /* WM ǻѤ */
    guint16 priviousX;
    guint16 priviousY;
    guint16 priviousWidth;
    guint16 priviousHeight;
    gint16 state; /* WM_STATE */

    /* ǥ */
    guint16 border_width;
    gchar  *border_frame;

    /* 롼ײȤɲõǽߤʤ */
    GList   *group;
    WmGroup *target;

    gchar *name;
    gchar *class;
    gchar *title;
    gchar *icon; 
    gchar *format;

    guint32  desktop;

#ifdef NEED_GNOME_WM_HINTS
    guint32  win_layer;
    gboolean win_state_shaded;
    gboolean win_state_sticky;
    gboolean win_state_fixed_position;
    gboolean win_state_arrange_ignore;
    gboolean win_hints_skip_taskbar;
    gboolean win_hints_skip_focus;
    gboolean win_hints_skip_winlist;
    gboolean win_hints_focus_on_click;
    gboolean win_hints_do_not_cover;
    guint32  win_expanded_size_x;
    guint32  win_expanded_size_y;
    guint32  win_expanded_size_width;
    guint32  win_expanded_size_height;
#endif /* NEED_GNOME_WM_HINTS */
};

struct _WmClientClass
{
    GtkWidgetClass parent_class;

    void (* title_change)(WmClient *wm_client);
    void (* iconify)     (WmClient *wm_client);
    void (* shape)       (WmClient *wm_client);
    void (* move)        (WmClient *wm_client);
    void (* resize)      (WmClient *wm_client);
};


GtkWidget* wm_client_new(Window client);
guint      wm_client_get_type(void);
void wm_client_resize(WmClient *wm_client, gint width, gint height);
void wm_client_resize_with_gravity(WmClient *wm_client, 
				   gint width, gint height, gint gravity);
void wm_client_move_resize(WmClient *wm_client, 
			   gint x, gint y, gint width, gint height);
void wm_client_move(WmClient *wm_client, gint x, gint y);
void wm_client_iconify(WmClient *wm_client);
void wm_client_delete(WmClient *client);
GtkWidget* wm_client_find(Window xwindow);

GList* wm_client_client_init(void);
GtkWidget *wm_client_list_find(Window xwindow);

void wm_client_set_WMState(GtkWidget *widget, int state);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WM_CLIENT_H__ */
