/* $Id: wmgnome.h,v 1.4 2000/03/26 08:15:59 komatsu Exp $ */

#ifndef __WM_GNOME_H__
#define __WM_GNOME_H__ 1

#include "wmclient.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GA_WIN_SUPPORTING_WM_CHECK	"_WIN_SUPPORTING_WM_CHECK"
#define GA_WIN_WM_NAME			"_WIN_WM_NAME"
#define GA_WIN_WM_VERSION		"_WIN_WM_VERSION"
#define GA_WIN_PROTOCOLS		"_WIN_PROTOCOLS"
#define GA_WIN_LAYER			"_WIN_LAYER"
#define GA_WIN_STATE			"_WIN_STATE"
#define GA_WIN_HINTS			"_WIN_HINTS"
#define GA_WIN_APP_STATE		"_WIN_APP_STATE"
#define GA_WIN_EXPANDED_SIZE		"_WIN_EXPANDED_SIZE"
#define GA_WIN_ICONS			"_WIN_ICONS"
#define GA_WIN_WORKSPACE		"_WIN_WORKSPACE"
#define GA_WIN_WORKSPACE_COUNT		"_WIN_WORKSPACE_COUNT"
#define GA_WIN_WORKSPACE_NAMES		"_WIN_WORKSPACE_NAMES"
#define GA_WIN_CLIENT_LIST		"_WIN_CLIENT_LIST"
#define GA_WIN_AREA			"_WIN_AREA"
#define GA_WIN_AREA_COUNT		"_WIN_AREA_COUNT"
#define GA_WIN_DESKTOP_BUTTON_PROXY	"_WIN_DESKTOP_BUTTON_PROXY"

enum {
    WIN_LAYER_DESKTOP    =  0,
    WIN_LAYER_BELOW      =  2,
    WIN_LAYER_NORMAL     =  4,
    WIN_LAYER_ONTOP      =  6,
    WIN_LAYER_DOCK       =  8,
    WIN_LAYER_ABOVE_DOCK = 10,
    WIN_LAYER_MENU       = 12,
};

#define WIN_STATE_STICKY          (1<<0) /* everyone knows sticky */
#define WIN_STATE_MINIMIZED       (1<<1) /* Reserved - definition is unclear */
#define WIN_STATE_MAXIMIZED_VERT  (1<<2) /* window in maximized V state */
#define WIN_STATE_MAXIMIZED_HORIZ (1<<3) /* window in maximized H state */
#define WIN_STATE_HIDDEN          (1<<4) /* not on taskbar but window visible*/
#define WIN_STATE_SHADED          (1<<5) /* shaded (MacOS / Afterstep style) */
#define WIN_STATE_HID_WORKSPACE   (1<<6) /* not on current desktop */
#define WIN_STATE_HID_TRANSIENT   (1<<7) /* owner of transient is hidden */
#define WIN_STATE_FIXED_POSITION  (1<<8) /* window is fixed in position even */
#define WIN_STATE_ARRANGE_IGNORE  (1<<9) /* ignore for auto arranging */

#define WIN_HINTS_SKIP_FOCUS      (1<<0) /* "alt-tab" skips this win */
#define WIN_HINTS_SKIP_WINLIST    (1<<1) /* do not show in window list */
#define WIN_HINTS_SKIP_TASKBAR    (1<<2) /* do not show on taskbar */
#define WIN_HINTS_GROUP_TRANSIENT (1<<3) /* Reserved - definition is unclear */
#define WIN_HINTS_FOCUS_ON_CLICK  (1<<4) /* app only accepts focus if clicked*/
#define WIN_HINTS_DO_NOT_COVER    (1<<5) /* attempt to not cover this window */

void    wm_gnome_set_win_client_list            (GList *glist);
void    wm_gnome_client_get_win_layer           (WmClient *client);
void    wm_gnome_client_get_win_state           (WmClient *client);
void    wm_gnome_client_set_win_state           (WmClient *client);
void    wm_gnome_client_get_win_hints           (WmClient *client);
void    wm_gnome_client_get_win_app_state       (WmClient *client);
void    wm_gnome_client_get_win_expanded_size   (WmClient *client);
void    wm_gnome_client_get_win_icons           (WmClient *client);
void    wm_gnome_client_get_win_workspace       (WmClient *client);
void    wm_gnome_client_set_win_workspace       (WmClient *client);
void    wm_gnome_client_set_win_area            (WmClient *client);
void    wm_gnome_init                           (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* !__WM_GNOME_H__ */
