/*
 *    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
 *    Copyright (c) 1992 Army High Performance Computing Research Center
 *        (AHPCRC), University of Minnesota
 *    Copyright (c) 1995-1999 Laboratory for Computational Science and
 *        Engineering (LCSE), University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file CONTRIBUTORS for a list of contributors.
 *
 *    Original author(s):
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    This file is maintained by:
 *      Grant Erickson <grant@lcse.umn.edu>
 *
 *    Module name: bob.h
 *
 *    Description:
 *      Macros, definitions, and data structures and function prototypes
 *      for core application.
 */

#ifndef __BOB_H__
#define __BOB_H__

#include <X11/Intrinsic.h>

#include <Xm/Xm.h>

#include <GL/glx.h>

#include "glutil.h"
#include "skip.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Preprocessor Defines */

#define CLASS_NAME	"Bob"
#define MEMFILE 	"/dev/mem/"

/* Type Defintions */

typedef float Trans[3];       /* A translation vector */
typedef float Quat[4];        /* A quaternion vector  */

typedef struct _BobStereo {
    Bool        useSGIStereo;
    Display     *currentDisplay;
    Window      currentWindow;
    GLXContext  currentContext;
    GLenum      currentDrawBuffer;
    int         currentStereoBuffer;
    Bool        enabled;
    char        *stereoCommand;
    char        *restoreCommand;
} BobStereo;

typedef struct _BobFile {
    char		*fname;
    XmString		listEntry;
    int			fd;
    int			shmid;
    unsigned char	*data;
    unsigned		dim[3];
    unsigned		offset;
    unsigned		blockSize;
    unsigned		nframe;
    unsigned		firstFrame;
} BobFile;

typedef struct _BobFrame {
    BobFile		*bobFile;
    unsigned		seek;
} BobFrame;

typedef struct _BobApp {
    Display		*display;
    XtAppContext	app;
    Widget		shell;

    int			running;
    int			help;
    int			debug;
    unsigned		fileSave;

    unsigned		fastRate;
    unsigned		fastStride[3];
    float		polyRate;
    Boolean		singleBuffer;
    int			fieldOfView;
    float		eyeSep;
    float		eyeDist;
    unsigned		blend;

    String		cmapName;
    String		amapName;
    String		defName;
    String		scaleText;
    String		bugAddress;
    String		followName;
    FILE		*followFile;

    Window		vwin;			/* vox window */
    GLXContext		vctx;
    unsigned		vwidth, vheight;
    Trackball		*vball;

    Window		fwin;			/* finder window */
    void		*fctx;
    unsigned		fwidth, fheight;
    Trackball		*fball;
    
    Window		swin;			/* stereo window */
    GLXContext		sctx;
    unsigned		swidth, sheight;
    BobStereo		stereo;

    BobFile		*file;
    unsigned		iframe;
    SkipList		fileList;
    SkipStack		frameList;
    SkipStack		dimList;
    SkipStack		pointList;

    unsigned		useRatio;
    int			parked;
    float		dimRatio[3];
    float		dimScale[3];
    unsigned		stride;
    unsigned		dataDim[3];
    unsigned		dataOffset[3];
    unsigned		voxDim[3][3];
    float		*voxPos[3][3];
    unsigned char	*cdata[3];
    unsigned char	*faces[3];

    float		*allpoint;
    unsigned		nallpoint;
    float		*point;
    unsigned		npoint;
    int			pstride;
    int			poffset;
    int			psize;
    String		pcolorName;
    float		pcolor[3];

    Atom		xaColormap;
    Atom		xaAlphamap;
    Atom		xaInterest;
    Atom		xaBobfile;
    Atom		xaRenderInfo;
    unsigned		ownSelect;
    
    XtWorkProcId	spinWP;       /* Work process for spinning volume */
    XtWorkProcId	animateWP;    /* Work process for animation */
    XtWorkProcId	playWP;       /* Work process for movie playback */

    XtIntervalId	shuttleTimerID;  /* Timeout ID for shuttle control */

    Boolean		anBGR;
    Boolean		anPixmode;
    FILE		*anFile;
    char		*anFileName;
    unsigned		anOffset;
    unsigned		anFrame;
    unsigned		anStep;
    int			anFrameInc;
    unsigned		anWidth;
    unsigned		anHeight;
    unsigned		anImageSize;
    unsigned long	*anImage;
    int			anFollow;

    long		bgColor;		
    String		bgColorName;

    int			fog;
    float		fogDensity;

    float		afact;
    float		ctab[256][4];
    float		atab[256];

    /* Begin Amir's and Grant's modifications */

    Quat		*quat;
    Quat		*quat_inter;
  
    Trans		*trans;
    Trans		*trans_inter;

    int			*recFrame;
    int			*recFrame_inter;

    int			*keyFrameFlags;

    float		*delta;
    float		total_delta;

    int			num_of_pnts;		/* # of points rec'd by user */
    int			num_of_inter_pnts; 
    int			NUMBER_OF_INTER_POINTS;	/* total # interp'd points */

    int			playFrame;
    int			playFrameInc;

    int			play;
    int			animate;

    Boolean		binCoords;

    /* End modifications */

} BobApp;

typedef enum _ButtonEnum {
    ButSkipRev, ButScanRev, ButScanFor, ButSkipFor,
    ButPlay, ButStop, ButRecord,  ButSaveMov, ButSaveCoord, ButStAnimate,
    ButOpen, ButSave, ButStartCmap, ButStartAmap, ButQuit, 
    ButStereo, ButHome, ButFlipX, ButFlipY, ButFlipZ, 
    ButDimActive, ButDimApply, ButDimAdd, ButDimDelete,
    ButAnGo, ButAnDone, ButAxisX, ButAxisY, ButAxisZ,
    ButCoordOK, ButCoordDefault, ButCoordCancel,
    ButPoint, ButRender
} ButtonEnum;

typedef enum _ToggleEnum {
    TogBuffer, TogBright, TogBounds, TogAnnotate, TogSoft, TogFog,
    TogInterpolate, TogColorBar, TogDimActive, TogAnSave, TogMaxVal,
    TogCoordHuman, TogCoordMachine
} ToggleEnum;

typedef enum _FileEnum {
    FileOK, FileCancel
} FileEnum;

typedef enum _ScaleEnum {
    ScaleAlpha, ScaleFrame,
    ScaleCenterX, ScaleCenterY, ScaleCenterZ, ScaleStride,
    ScaleSizeX, ScaleSizeY, ScaleSizeZ, ScaleSizeM
} ScaleEnum;

typedef enum _ListEnum {
    ListFile, ListDim
} ListEnum;

/* External Global Variables */

extern BobApp		*bob;

/* Function Prototypes */

void	GrabSelection(void);
void	CheckDimension (int dim [3], int *maxdim, int center [3], int *stride);
void	GetDimWidgets (int dim [3], int *maxdim, int center [3], int *stride);
void	SetDimWidgets (int dim [3], int *maxdim, int center [3], int *stride);
void	CoordinateDimensions (void);
void	AddDimEntry (char *dimline);
void	SetCurrentFile (BobFile *bfile);
void	SetFirstFile (void);
void	StopAnimation(void);
void	SaveAnimationFrame (void);
void	StartAnimation(Boolean interactive);
void	FollowInput (XtPointer cdata, int *fd, XtInputId *xid);
Boolean	SpinCB (XtPointer closure);
Boolean	AnimateCB (XtPointer closure);
void	VoxExposeCB (Widget w, XtPointer closure, XtPointer callData);
void	VoxInitCB (Widget w, XtPointer closure, XtPointer callData);
void	VoxResizeCB (Widget w, XtPointer closure, XtPointer callData);
void	VoxInputCB (Widget w, XtPointer closure, XtPointer callData);
void	StereoExposeCB (Widget w, XtPointer closure, XtPointer callData);
void	StereoInitCB (Widget w, XtPointer closure, XtPointer callData);
void	StereoResizeCB (Widget w, XtPointer closure, XtPointer callData);
void	StereoInputCB (Widget w, XtPointer closure, XtPointer callData);
void	FinderExposeCB (Widget w, XtPointer closure, XtPointer callData);
void	FinderInitCB (Widget w, XtPointer closure, XtPointer callData);
void	FinderResizeCB (Widget w, XtPointer closure, XtPointer callData);
void	FinderInputCB (Widget w, XtPointer closure, XtPointer callData);
void	ButtonCB (Widget w, XtPointer closure, XtPointer callData);
void	ShuttleMovieCB(Widget w, XtPointer closure, XtPointer callData);
void	CoordToggleCB(Widget w, XtPointer closure, XtPointer callData);
void	ToggleCB (Widget w, XtPointer closure, XtPointer callData);
void	FileCB (Widget w, XtPointer closure, XtPointer callData);
void	ListCB (Widget w, XtPointer closure, XtPointer callData);
void	ScaleCB (Widget w, XtPointer closure, XtPointer callData);
void	BugCB (Widget w, XtPointer closure, XtPointer callData);

#ifdef __cplusplus
}
#endif

#endif /* __BOB_H__ */
