/*
 *    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
 *    Copyright (c) 1992 Army High Performance Computing Research Center
 *        (AHPCRC), University of Minnesota
 *    Copyright (c) 1995-1999 Laboratory for Computational Science and
 *        Engineering (LCSE), University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file CONTRIBUTORS for a list of contributors.
 *
 *    Original author(s):
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    This file is maintained by:
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    Module name: draw.h
 *
 *    Description:
 *      Macros, definitions, and data structures and function prototypes
 *      for voxel screen drawing routines.
 */

#ifndef __DRAW_H__
#define	__DRAW_H__

#include "glutil.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Type Definitons */

typedef enum _FinderEnum {
    FinderSync, FinderDiff, FinderRead, FinderInterp, FinderScan
} FinderEnum;

/* External Global Variables */

extern FinderEnum	finderMode;
extern unsigned		finderPlane;

/* Function Prototypes */

void	DrawVoxel (int ix, int direction,
		   unsigned dim [3], float *pos [3], 
		   unsigned char *cdata, float cmap [256][4],
		   unsigned char *faces, unsigned soft);
void	DrawStrideVoxel (int ix, int direction,
			 unsigned dim [3], float *pos [3], 
			 unsigned char *cdata, float cmap [256][4], 
			 unsigned char *faces,  unsigned stride);
void	DrawMaxVal (int ix, int direction,
		    unsigned dim [3], float *pos [3], 
		    unsigned char *cdata, float cmap [256][4], 
		    unsigned char *faces);
void	DrawStrideMaxVal (int ix, int direction, 
			  unsigned dim [3], float *pos [3], 
			  unsigned char *cdata, float cmap [256][4], 
			  unsigned char *faces, unsigned stride);
void	DrawVoxFace (int ix, int direction, 
		     unsigned dim [3], float *pos [3], 
		     unsigned char *cdata, float cmap [256][4]);
void	DrawVoxFaces (unsigned dim [3][3], float *pos [3][3], 
		      unsigned char *cdata [3], float cmap [256][4]);
void	DrawBounds (float dim [3], unsigned asBox);
void	DrawAnnotatedBox (float dim [3], unsigned lo [3], unsigned hi [3]);
void	DrawColorBar (float ctab [256][4], float atab [256]);
void	DrawAxis (float *axlen);
void	DrawSetupFinder (void);
void	DrawFinderScene (int voxdim [3], int stride, int voxoff [3], 
			 unsigned filedim [3], float dimScale [3], 
			 Trackball *tball);
void	DrawPoint (float *point, unsigned npoint, int psize, float *pcolor);

#ifdef __cplusplus
}
#endif

#endif /* __DRAW_H__ */
