/*
 *    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
 *    Copyright (c) 1992 Army High Performance Computing Research Center
 *        (AHPCRC), University of Minnesota
 *    Copyright (c) 1995-1999 Laboratory for Computational Science and
 *        Engineering (LCSE), University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file CONTRIBUTORS for a list of contributors.
 *
 *    Original author(s):
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    This file is maintained by:
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    Module name: setup.h
 *
 *    Description:
 *      Macros, definitions, and data structures and function prototypes
 *      for application start-up and initalization.
 */

#ifndef __SETUP_H__
#define __SETUP_H__

#include <stdio.h>

#include <X11/Intrinsic.h>

#ifdef __cplusplus
extern "C" {
#endif

void		RemoveHelp (Widget w);
void		RemoveCancel (Widget w);
void		FreeFileEntry (void *entry);
unsigned	ReadDefaults (unsigned dim [3], unsigned *offset,
			      unsigned *blockSize, unsigned *nframe, char *src,
			      FILE *dfile);
void		SaveDefaults (void);
void		RestartFiles (char *cmd, FILE *file);
void		PositionDimDialog (void);
int		SetupBob (int *argc, char *argv []);

#ifdef __cplusplus
}
#endif

#endif /* __SETUP_H__ */
