/*
 *    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
 *    Copyright (c) 1992 Army High Performance Computing Research Center
 *        (AHPCRC), University of Minnesota
 *    Copyright (c) 1995-1999 Laboratory for Computational Science and
 *        Engineering (LCSE), University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file CONTRIBUTORS for a list of contributors.
 *
 *    Original author(s):
 *      Grant Erickson <grant@lcse.umn.edu>
 *
 *    This file is maintained by:
 *      Grant Erickson <grant@lcse.umn.edu>
 *
 *    Module name: config.h
 *
 *    Description:
 *      Customization and configuration header.
 */

#ifndef __CONFIG_H__
#define	__CONFIG_H__

/* Some platforms, namely Silicon Graphics Irix, have support for optional
 * math extensions to the ANSI C Programming Language Specification ISO/IEC
 * 9899:1990 (E). These extensions include functions such as cosf, sinf, tanf,
 * fabsf, sqrtf, etc. If you have these functions on your system, define these.
 */

#undef	HAVE_COSF
#undef	HAVE_SINF
#undef	HAVE_TANF
#undef	HAVE_FABSF
#undef	HAVE_SQRTF

/* Some platforms, namely Silicon Graphics Irix, have support for a coarse-
 * grain parallel programming interface with calls such as m_fork, m_next,
 * m_sync, etc. If you have these functions on your system, define these.
 */

#undef	HAVE_M_FORK
#undef	HAVE_TASK_H
#undef	HAVE_ULOCKS_H

/* Some platforms, namely those running Mesa3D instead of OpenGL, may not
 * have both header files GL/GLwDrawA.h and GL/GLwMDrawA.h as well as
 * both the glwMDrawingAreaWidgetClass and the glwDrawingAreaWidgetClass
 * defined in libGLw. The Motif-aware versions (GLwM/glwM) are preferred,
 * though are not necessary. Define whichever is appropriate for your system.
 */

#define	HAVE_GL_GLWMDRAWA_H
#undef	HAVE_GL_GLWDRAWA_H

/* Some platforms, namely Silicon Graphics Irix, have support for X11 stereo
 * display extensions. If your system support these extensions, define this.
 */

#undef	HAVE_X11_EXTENSIONS_SGISTEREO_H

/************************ DO NOT EDIT BELOW THIS LINE ************************/

#if !defined(HAVE_GL_GLWMDRAWA_H) && !defined(HAVE_GL_GLWDRAWA_H)
#error "One of HAVE_GL_GLWMDRAWA_H or HAVE_GL_GLWDRAWA_H must be defined!"
#endif

#if defined(HAVE_M_FORK) && !defined(HAVE_TASK_H) && !defined(HAVE_ULOCKS_H)
#error "If HAVE_M_FORK is defined, so must be HAVE_TASK_H and HAVE_ULOCKS_H!"
#endif

#endif /* __CONFIG_H__ */
