.\"
.\"    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
.\"    Copyright (c) 1992 Army High Performance Computing Research Center
.\"        (AHPCRC), University of Minnesota
.\"    Copyright (c) 1995-1999 Laboratory for Computational Science and
.\"        Engineering (LCSE), University of Minnesota
.\"
.\"    This is free software released under the GNU General Public License.
.\"    There is no warranty for this software.  See the file COPYING for
.\"    details.
.\"
.\"    See the file CONTRIBUTORS for a list of contributors.
.\"
.\"    Orignal author(s):
.\"      Grant Erickson <grant@lcse.umn.edu>
.\"
.\"    This file is maintained by:
.\"      Grant Erickson <grant@lcse.umn.edu>
.\"
.\"    Module name: animabob.man
.\"
.\"    Description:
.\"      Reference page for animabob
.\"
.TH animabob 1 "1 Nov 1999" "Version 1.3" ""
.SH NAME
animabob - animating brick of bytes volume renderer
.SH SYNOPSIS
.B animabob
[\-\fItoolkitoption\fP ...] [\-option ...] [\-size XxYxZ file ...]
.SH DESCRIPTION
\fIAnimaBob\fR is a tool for browsing three dimensional data sets. The program
was designed to quickly render portions of potentially large time dependent
volumes and to generate interpolated fly-throughs of these volumes.
\fIAnimaBob\fR can also generate a series of images that can be later compiled
into a movie with other post-processing tools.
.SS "File Format"
The "bob" portion of the name \fIAnimaBob\fR stands for "brick of
bytes" and is descriptive of the data format used by
\fIAnimaBob\fR. In order to render quickly, \fIAnimaBob\fR requires
the data to be arranged in a three dimensional array, forming a brick
with right corners. Each element of the array is used to color a
corresponding grid cell in the data volume. In graphics terminology,
each grid cell is called a voxel, the term coming from volume
pixel. By setting some of the voxels to be transparent, and others to
be translucent and colored, an image can be made of the interior.
.PP
The data file should contain one byte per voxel, with the bytes stored
in one continuous array. At present, \fIAnimaBob\fR does not use a file
header. The X direction varies fastest, then Y and lastly Z. In other
words, the data file consists of Z planes, each plane containing Y
rows, each row X bytes long.
.SS "Alpha and Color Maps"
\fIAnimaBob\fR works hand in hand with \fIIcol\fR, a color map editor.
\fIIcol\fR creates tables of color for other applications. \fIAnimaBob\fR
uses these tables to construct color and opacity from a single voxel value.
You will need to be familiar with \fIIcol\fR in order to interactively
specify colors and alpha values. \fIIcol\fR communicates with \fIAnimaBob\fR,
so that when a new color map is created the changes are automatically passed
on to \fIAnimaBob\fR.
.PP
In order to render a volume of data, \fIAnimaBob\fR needs to know how
to map the voxel value to both a color and alpha value. This is done
using two tables, the color map and the alpha map. Unless an alpha
map is specified, \fIAnimaBob\fR constructs the alpha map from the
brightness of the color map. This is often the desired result, with
dark colors being more transparent and bright colors more opaque.
This mode is called "Auto Alpha" in \fIAnimaBob\fR, and can be
interactively toggled on and off.
.PP
Experienced users may want to specify the alpha values separately. If
an alpha map is specified, either on the command line or using the
"Alpha Only" mode in \fIIcol\fR, then \fIAnimaBob\fR will turn off
"Auto Alpha".
.PP
\fIIcol\fR's YUV color space is particularly useful when volume
rendering. YUV space is a linear transform of RGB, such that Y is the
brightness and U and V encode color. In approximate terms, U encodes
the blue channel and V encodes red. The best feature of YUV space is
that brightness can be specified independently from color. This gives
direct control over opacity when using the "Auto Alpha" mode.
.PP
Although YUV space is handy for controlling brightness independently
from hue, it can be hard at first to locate saturated colors. The key
is to remember that blue is the least bright, followed by red, purple,
green, cyan, and yellow. So if your Y value is relatively bright (say
0.70) you won't have much luck finding a deep blue, but you could get
close to yellow. In YUV space, pure blue has a Y value of 0.11, U
equals +0.50, and V equals -0.7 (maximum U, minimum V). Red is Y
equals 0.30, U equals -0.16, and V equals +0.50 (minimum U, maximum
V). Green is Y equals 0.59, U equals -0.32, and V equals -0.41
(minimum U, minimum V).
.PP
Another useful \fIIcol\fR technique is to flip back and forth between
RGB mode and YUV mode, finding pure colors in RGB and modifying the
brightness in YUV. Try also dragging knot points in the color map to
new locations.
.PP
Whenever a new volume is chosen, or the alpha map changes,
\fIAnimaBob\fR scans and marks the volume for blank regions. When
rendering, \fIAnimaBob\fR will skip these blank regions, resulting in
sometimes dramatic increases in rendering speed. Therefore, in the
interest of fast rendering and clearer images, it pays to set the
alpha value of uninteresting regions to zero.
.PP
To specify the alpha value independently from color, use the Alpha
mode of \fIIcol\fR. When an alpha map is modified in \fIIcol\fR, the
changes are automatically passed on to \fIAnimaBob\fR, like the color
map. \fIAnimaBob\fR will turn off Auto Alpha mode when it is given an
alpha map, so that subsequent changes to the color map will not effect
the alpha map.
.PP
Using a separate alpha map is useful for hilighting ranges of values
in the volume. While knot points are usually the best way to specify a
color map, using brushes to sketch the alpha map in \fIIcol\fR can
quickly accentuate or hide volume regions in \fIAnimaBob\fR.
.PP
By default, \fIIcol\fR communicates every change in the color or alpha
map to \fIAnimaBob\fR. For larger volumes this can be tiresome,
because \fIAnimaBob\fR scans the volume for blank regions whenever new
alpha values are specified. By turning off the Auto Set Property
option in \fIIcol\fR (in the Mode menu), \fIIcol\fR keeps changes to
itself. With the "Auto Set Property" feature disable, to explicitly
set the color map, use the Set Colormap Property command (in the File
menu) in \fIIcol\fR.
Main Window

Bob's interface consists of a main window, where the volume rendering takes plac
e, and two dialogs, one for controlling the volume dimensions and the other for 
controlling animation.  The dialogs can be hidden and displayed as needed.

The main window is divided into a rendering area on the left and a control area 
on the right.  The control area has a menu bar, a scale adjustment for the alpha
 values, a scale for the frame number (used for multiple data sets), and two lis
ts.  The top list contains the data files, and the bottom list contains dimensio
ns settings.  You can resize the main window as needed.

The "Alpha Attenuation" slider adjusts the scale factor applied to the alpha val
ues.  This scale is handy for adjusting the overall transparency of a picture, p
articularly when scaling up or down in volume size.  A volume that is twice as l
arge will be approximately twice as opaque, which may not be desired.  The alpha
 attenuation scale can counter this effect.

The frame slider can be used to skip to a new data frame.  If only one data bric
k was specified on the Bob command line, then there will be only one frame.  If 
there is one frame per file, then each increment of the frame slider will open a
 new file.  If there is more than one data brick per file, the frame slider will
 walk through the bricks in each file in order.

The file list contains one entry per data file.  Clicking on a file name causes 
Bob to read in the first data brick in that file.  Use the frame slider to acces
s subsequent bricks if there is more than one brick per file.  The current dimen
sion settings are used to read the new data.  There is currently no way to add o
r delete files from the list without restarting Bob.

The dimension list is a convenient place to remember choice locations in a large
 data file.  The Dimension menu commands add and delete entries in the dimension
 list.  Each entry defines all of the settings from the dimension dialog.  Selec
ting a new entry causes Bob to read a volume from the current data file using th
ose dimension settings.

3D Manipulation

Both the finder and volume cube are rotated and moved using the same mouse techn
iques.  Button 1 of the mouse is used to rotate the volume, button 2 pans the vo
lume in the plane of the screen, and button 3 will zoom the volume towards or aw
ay from the viewer.  In all three cases, start moving the volume by clicking wit
h the button, hold the button down as you move to drag the volume, and let up to
 finish.

The rotation is modeled using a trackball, positioned in the center of the windo
w.  Clicking in the center of the volume window will rotate the image about X an
d Y axes, whereas clicking near the edge rotates around the Z axis.  If you keep
 moving the mouse as the button is released, the volume is kicked and will keep 
rotating in that direction.  To stop unwanted rotation, click and release in the
 same location.

Panning the volume in the plane of the screen is straightforward.  Move the mous
e in the vertical direction to zoom the volume closer or farther away.

Bob will automatically cut the resolution of the volume in order to achieve an i
nteractive frame rate while the volume is being manipulated with the mouse.  Aft
er the mouse button is released the image is drawn at full resolution.


Dimension Dialog

An often used feature of Bob is the ability to render only part of the whole dat
a set.  The dimension dialog controls the portion of the data set that is viewed
 in the main window.

The viewed volume dimensions are specified by its size, the center of the volume
, and the stride at which the volume is read.  The stride value allows a large d
ata set to be subsampled.  For example, a 30 by 30 by 30 volume taken with a str
ide of three will read every third value of a 90 by 90 by 90 volume from the dat
a set.  Because a 30 cubed volume will render much faster than a 90 cubed one, t
he stride setting is useful for browsing a large area.

The finder view next to the dimension sliders shows the viewed volume in relatio
n to the data set.  The cube will change color and position when a new volume is
 read from file and/or analyzed.  As the volume is read, a red plane progresses 
across the cube.  The volume is being transposed and interpolated, if needed, wh
ile the cube is red.  The cube builds face by face in light blue as the volume i
s analyzed for opaque regions, and finally the volume is rendered and the cube r
eturns to a darker shade of blue.

When one of the dimension dialog sliders is changed, the cube responds in size a
nd also turns a yellow color to indicate that it is out of sync with the rendere
d volume in the main window.

The consistency check for dimension settings is always done in the same order.  
The volume size values are never changed.  Next the center of the volume is adju
sted to be within the data set.  Finally the stride is decreased to fit the data
 set.  Therefore, if you want to increase the stride to fill the volume, you fir
st must decrease the volume size.
For reference, the rotation of the finder cube is coupled to the rotation of the
 volume.  The finder cube can be used as a remote method of rotating the volume,
 although the finder cube cannot be kicked.





.PP
To learn how to use \fIAnimaBob\fR, consult the manual "All About Bob". This
document only covers the command line options and resource values.
An on line version of "All About Bob", without figures, is available
as 'man allbob'.
.SH OPTIONS
Bob recognizes the standard X toolkit options, such as
-geometry, -title, -bg, -fg, etc.
Bob also has two sets of options of its own.
The first set define global settings, and should be specified once at most.
The second set define the file format, and can be repeated to 
change the format for multiple files.
.PP
Global options:
.IP "-cmap | -c  file"
Specify the initial color map. If no alpha map is specified, the
alpha will be computed as the brightness of the color map. The colormap
can be in one of two formats: indexed ascii or interleaved binary.
The indexed ascii format consists of ascii integer quadruples, 
as in "index red green blue ...". 
The integers should range from zero to 255.
The interleaved binary format contains 768 bytes, with 256 rgb triples,
as in "rgbrgbrgb...". \fIIcol\fR can interchange between these formats and two
others.
.IP "-amap | -a  file"
Specify the initial alpha map. The alpha file format is the same
color map file format. If the red, green and blue values are different,
the alpha value is computed as the brightness 
(1/8 blue + 5/8 green + 2/8 red). In other words, alpha maps are 
represented using black and white color maps.
.IP "-scale | -x  XxYxZ"
Space the data set using a ratio of X\ :\ Y\ :\ Z. For example,
if a data set needs to be expanded in the Z direction by a factor of
3, use "-x 1x1x3".  Note that high scale factors introduce more
rendering artifacts.  For the best quality images, create an interpolated
data set and avoid using a scale factor.
.IP "-default | -d  file"
Load default settings from file.  
Bob will also check for the file "Bobfile" in the current directory
for default settings.  
See "Defaults File" below.
.IP "-single"
Force using only one rendering buffer (i.e. no double buffering).
Some SGI machines with limited bit planes will allow double buffering
at the expense of image quality (e.g. Elan and Indigo).  
To obtain the best quality images on these machines, use this option.
.IP "-savebgr"
Save animation image files as interlaced bgr bytes, as in bgrbgrbgr....
This is the default because it is the format for xraz.
.IP "-savergb"
Save animation image files as interlaced rgb bytes, as in rgbrgbrgb....
This is the format
that is easiest to convert.  For example, to convert a 512 by 512 image
file produced by Bob, called ras.000, to SGI image format, use:
.br
.sp
frombin ras.000 sgi.000 512 512 3
.IP "-fastrate #"
Set the interactive rendering rate to # frames per second (an integer).
When the volume in Bob is manipulated by the mouse, the resolution is 
cut to achieve a certain number of frames per second rendering rate
on the given hardware.
The default rate is 6 frames per second.  
.IP "-fov"
Field of view, an integer, in tenths of a degree.  The default field
of view is 34 degrees.  Higher values accentuate the sense of
perspective.
.IP "-eye"
Set the eye separation for stereo viewing.  The default value is 0.07.
Higher eye separation increases the sense of depth, but causes more
eye strain.
.IP "-distance"
Set the distance of the volume from the eye.  The default value of
3.0 places the volume to just fill the window for the default
field of view.
.IP "-help | -h"
Print a short command summary.
.IP "-debug #"
Set the debug level.  Currently, "1" will time the rendering loop
for polygon speed.
.PP
The following options control the file format, and 
can be interspersed with file names.  A file size \fBmust\fR be specified
before the first file name.  The files and options are
read in order, with option settings applying to all subsequent files.
File offsets and block sizes can be specified using the letters 'k' and 'm',
with k standing for 1024 and m for 1024*1024.  Thus, a four kilobyte
block size can be specified as "4k" and a one hundred megabyte offset
as "100m" or "100kk".
.IP "-size | -s  XxYxZ"
Specify the dimensions of the file.  For example, a 128 by 128 by 64
brick of data would be specified as "\-s\ 128x128x64".
.IP "-number | -n  #"
Set the number of data bricks per file.  Default is 1.
.IP "-offset | -o  #"
Set the offset, in bytes, to where the brick begins in the file.  
Default is zero.
.IP "-block | -b  #"
Set the block size of the device.  This is only useful for accessing raw
disk partitions, which is done at the AHPCRC to gain speed.  
We keep several large striped disk partitions open
(no file system) for disk based visualization.
.SH RESOURCES
Bob's global options can be specified using X resources.  In all
cases, the resource class is the same as the resource name capitalized.
.IP "cmapName"
The color map file name.
.IP "amapName"
The alpha map file name.
.IP "defaultName"
The defaults file name.
.IP "scaleText"
The scale ratio, specified as in the -scale option.
.IP "saveBGR"
A boolean flag to control the file format for animation image files.
.IP "fastRate"
The integer number of frames per second to render on the given hardware
while the volume is being manipulated.
.IP "singleBuffer"
A boolean flag to force using single buffer rendering at all times,
resulting in better image quality on some machines.
.IP "bugAddress"
The mail address to send bug reports to.
.IP "fieldOfView"
The field of view, in tenths of a degree.
.IP "eyeSeparation"
The eye separation.
.IP "eyeDistance"
The distance of the volume from the eye.
.SH DEFAULTS FILE
The defaults file contains one line entries, in the form of
.br
.sp
target = value
.PP
Lines may be commented out using '#', like shell scripts.  
The targets are:
.IP "color = filename"
Set the file name for the initial color table.
.IP "alpha = filename"
Set the file name for the initial alpha table.
.IP "scale = xscale yscale zscale"
Set the scaling factor for the volume in each direction.
The values may be in floating point, and should be separated by white space.
.IP "size = xdim ydim zdim"
Set the data size in the file, with the dimensions separated by white space.
For example,
.br
.sp
size = 128 128 64
.IP "offset = numBytes"
Set the byte offset into the file for where the first brick begins.
The number may contain 'k' or 'm', as in '120m' for 120 megabytes.
.IP "block = numBytes"
Set the blocksize of the file device.  
This is only useful for accessing data on a raw file partition, 
which often improves I/O for large files.
The number may contain 'k' or 'm', as in '8k' for eight kilobytes.
.IP "number = numBrick"
Set the number of data bricks in the file.
.IP "dim = dimension string"
Add an entry to the dimension list, in the form of
.br
.sp
XxYxZ 'by' stride 'at' X,Y,Z
.IP
For example, a 32 by 32 by 32 volume, taken at a stride of 2, 
centered at x=48, y=100, z=48, would read
.br
.sp
dimension = 32x32x32 by 3  at 48,101,48
.IP "file = filename"
Add a file to the file list.
.PP
If there is no target, then the string is assumed to be a file name
and is added to the file list.  Thus, long sequences can be built
by specifying the correct parameters and appending a listing of
file names.
.SH CAVEATS
The data volume is transposed for all three rendering directions.
Thus, a rough estimate of the memory is used is one megabyte plus
three times the size of the rendered volume.  
.PP
Machines without z-buffers are limited to alpha rendering.
Machines without blending hardware, such as the Personal Iris,
are limited to maximum value rendering.  Machines with no blending
or z-buffer hardware are, in Bob's opinion, no better than a Sun.
.SH BUGS
Stereo mode doesn't work when maximum value rendering.
.PP
For large volumes, it is often possible to exceed the swap space available
by simply moving the size scale to its maximum value.
.SH AUTHOR
Ken Chin-Purcell
.br
Mail to gvlware@ahpcrc.umn.edu.

.SH "EXAMPLES"
To view a brick of bytes file, named "brickfile", containing 50 concatenated
64x32x128 bricks with the default alpha and color maps:
.RS
.nf

animabob -size 64x32x128 -number 50 brickfile
.fi
.RE
.PP
To view a brick of bytes file, named "parietallobe", containing a single,
256x256x300 brick with the color map "tissue.map":
.RS
.nf

animabob -size 256x256x300 -color tissue.map
.fi
.RE
.PP
To view the same file, specifying that 1000 frames be generated for an
interpolated animation:
.RS
.nf

animabob -size 256x256x300 -color tissue.map -inter 1000
.fi
.RE
.SH "HISTORY"
\fIAnimaBob\fR is based on the similarly named \fIBob\fR program,
written by Ken Chin-Purcell. \fIBob\fR was created for the Graphics
and Visualization Lab of the University of Minnesota's Army High
Performance Computing Research Center. \fIBob\fR and its documentation
were written by Ken Chin-Purcell.
.PP
The original development of \fIBob\fR was supported by the Army
Research Office contract number DAALO3-89-C-0038 with the University
of Minnesota Army High Performance Computing Research Center.
.PP
\fIAnimaBob\fR was written by Grant Erickson in 1996 as part of the
Senior Honors Project in the Department of Electrical and Computer
Engineering at the University of Minnesota under the advisement of
Dr. Matthew O'Keefe. The \fIAnimaBob\fR project grew out of some key
frame interpolation routines added by Amir Shinar in fulfilment of his
masters thesis in 1995, also under the advisement of Dr. O'Keefe.
.PP
The original development and testing of \IAnimaBob\fR was performed at
the University of Minnesota's Laboratory for Computational Science and
Engineering.
.SH "SEE ALSO"
.BR bob (1),
.BR icol (1)
.SH AUTHORS
