/*
 *    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
 *    Copyright (c) 1992 Army High Performance Computing Research Center
 *        (AHPCRC), University of Minnesota
 *    Copyright (c) 1995-1999 Laboratory for Computational Science and
 *        Engineering (LCSE), University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file CONTRIBUTORS for a list of contributors.
 *
 *    Original author(s):
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    This file is maintained by:
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    Module name: rgb.h
 *
 *    Description:
 *      
 */

#ifndef __RGB_H__
#define __RGB_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Function Prototypes */

float	max3 (float a, float b, float c);
float	min3 (float a, float b, float c);
void	rgb2hsv (float r, float g, float b, float *h, float *s, float *v);
void	hsv2rgb (float h, float s, float v, float *r, float *g, float *b);
void	TrimYUV (float y, float *u, float *v, float a, float b);
void	yuv2rgb (float y, float u, float v, float *r, float *g, float *b);
void	rgb2yuv (float r, float g, float b, float *y, float *u, float *v);

#ifdef __cplusplus
}
#endif

#endif /* __RGB_H__ */
