/*
 *    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
 *    Copyright (c) 1992 Army High Performance Computing Research Center
 *        (AHPCRC), University of Minnesota
 *    Copyright (c) 1995-1999 Laboratory for Computational Science and
 *        Engineering (LCSE), University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file CONTRIBUTORS for a list of contributors.
 *
 *    Original author(s):
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    This file is maintained by:
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    Module name: skip.h
 *
 *    Description:
 *      Skip list and skip stack library header.
 *
 *      Skip lists are a data structure invented by William Pugh
 *      <pugh@cs.umd.edu> and were introduced in "Skip Lists: A
 *      Probabilistic Alternative to Balanced Trees", Communications
 *      of the ACM, June 1990.
 */

#ifndef	__SKIP_H__
#define	__SKIP_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _SLNode {
    void		*key;
    struct _SLNode	*forward[1];
} SLNode;

typedef struct _SkipListRec {
    SLNode	*header;
    SLNode	*last;
    int		(*compare)(void *, void *);
    int		unique;
    int		level;
    int		size;
} *SkipList;


typedef struct _StackRef {
    struct _StackNode	*node;
    int			distance;
} StackRef;

typedef struct _StackNode {
    void	*value;
    StackRef	forward[1];
} StackNode;

typedef struct _SkipStackRec {
    StackNode	*header;
    StackNode	*last;
    int		level;
    int		size;
} *SkipStack;


#define StackPush(l,v)		StackAppend(l,  0, v)
#define StackAddLast(l,v)	StackAppend(l, l->size, v)
#define StackPop(l)		StackRemove(l, 1)


/* Prototypes */

/* skip.c */
SkipList	SkipNew (int (*compare )(void *,void *), int unique);
void		SkipFreeData (SkipList l, void (*freeitem )(void *));
void		SkipFree (SkipList l, void (*freeitem )(void *));
int		SkipInsert (SkipList l, void *key);
void		*SkipRemove (SkipList l, void *key);
void		*SkipSearch (SkipList l, void *key);
void		*SkipHead (SkipList l);
void		*SkipNext (SkipList l);
int		SkipSize (SkipList l);
SkipStack	StackNew (void);
void		StackFreeData (SkipStack l, void (*freeitem )(void *));
void		StackFree (SkipStack l, void (*freeitem )(void *));
void		*StackSearch (SkipStack l, int k);
void		StackAppend (SkipStack l, int k, void *value);
void		*StackRemove (SkipStack l, int k);
void		*StackHead (SkipStack l);
void		*StackNext (SkipStack l);
int		StackSize (SkipStack l);

#ifdef __cplusplus
}
#endif

#endif /* __SKIP_H__ */
