
/* Copyright (C) 1992  AHPCRC, Univeristy of Minnesota
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file named 'Copying'; if not, write to
 * the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139.
 */

/* Author:
 *	Ken Chin-Purcell (ken@ahpcrc.umn.edu)
 *	Army High Performance Computing Research Center (AHPCRC)
 *	Univeristy of Minnesota
 *
 * $Header: /home/gerickson/cvs/gvl/raz/xraz.h,v 1.1.1.1 1999/10/15 04:44:41 gerickson Exp $
 *
 * $Log: xraz.h,v $
 * Revision 1.1.1.1  1999/10/15 04:44:41  gerickson
 * Import of AHPCRC GVL Suite 1.0.0
 *
 * Revision 2.1  92/10/19  17:05:44  ken
 * *** empty log message ***
 * 
 * Revision 1.1  92/10/19  17:04:44  ken
 * Initial revision
 * 
 */


typedef struct _XrazApp {
    Display		*display;
    XtAppContext	app;
    Widget		shell;
    
    int			running;
    int			help;
    int			debug;
    int			timeout;
    unsigned		fileSave;
    unsigned		needLoad;
    
    unsigned		playing;
    unsigned		frame;
    float		speed;
    XtIntervalId	playTP;
    
    char		*rawName;
    unsigned		numraw;
    unsigned long	offset;
    unsigned long	blocksize;
    unsigned long	chunksize;
    
    unsigned		playRaw;
    unsigned		source;
    unsigned		format;
    unsigned		zoom;
    unsigned		timer;
    unsigned		doublebuf;
    unsigned		reverse;
    
    unsigned		dim[2];
    unsigned		border;
    float		replicate;
    float		zoomReplicate;
    
    String		cmapName;
    String		defName;
    String		bugAddress;
    
    Atom		xaColormap;
    Atom		xaInterest;
    unsigned		ownSelect;
    
    FILE		*razIn;
    FILE		*razOut;
    char		*reply;
    unsigned		replySize;
    int			razPID;
    
    short		cmap[256][3];
} XrazApp;

extern XrazApp		*xraz;

#define	MATCH(strA, strB) (strncasecmp(strA, strB, MAX(1,strlen(strA))) == 0)

#define CLASS_NAME	"XRaz"
#define CMDSIZE		256
#define	REPLYLEN	4000

#define PSEUDO8		0
#define RGBBYTE		1
#define RGBPLANE	2

#define PAINTPLAY	0
#define PAINTBOTH	1

typedef enum _ButtonEnum {
    ButQuit, ButOpen, ButSave,
    ButScript, ButStartIcol, ButRestart,
    ButBack, ButBackStep, ButStop, ButForStep, ButFor,
    ButSendScript, ButFormat, ButRawDisk
    } ButtonEnum;

typedef enum _ToggleEnum {
    TogPlayRaw, TogPlayMem, 
    TogSourceFile, TogSourceRaw, TogSourceTape,
    TogZoom, TogTimer, TogBuffer, TogReverse,
    TogRawName, TogFormat, TogFileSize
    } ToggleEnum;

typedef enum _FileEnum {
    FileOK, FileImageOK
    } FileEnum;

typedef enum _ScaleEnum {
    ScaleChunk,
    ScaleFrame, ScaleSpeed, ScaleSize, ScaleBorder, ScaleZoom
    } ScaleEnum;


/* Prototypes */

/* xraz.c */
void	GetReply (void);
void	SendCmd (char *cmd);
void	KillOffRaz (void);
void	SetFrameMax (void);
void	SetFrameValue (void);
void	SetImageToggle (void);
void	SetModeToggle (void);
void	SetFormatDialog (void);
void	SetDiskDialog (void);
void	SetSliders (void);
void	GetFormatDialog (void);
void	GetDiskDialog (void);
void	SendScript (void);
void	SaveScript (char *fname);
void	ButtonCB (Widget w, XtPointer closure, XtPointer callData);
void	ToggleCB (Widget w, XtPointer closure, XtPointer callData);
void	FileCB (Widget w, XtPointer closure, XtPointer callData);
void	ScaleCB (Widget w, XtPointer closure, XtPointer callData);
void	BugCB (Widget w, XtPointer closure, XtPointer callData);
int	main	(int argc, char *argv []);
