/*
 *    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
 *    Copyright (c) 1992 Army High Performance Computing Research Center
 *        (AHPCRC), University of Minnesota
 *    Copyright (c) 1995-1999 Laboratory for Computational Science and
 *        Engineering (LCSE), University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file CONTRIBUTORS for a list of contributors.
 *
 *    Original author(s):
 *      Amir Shinar <amir@lcse.umn.edu>
 *      Grant Erickson <grant@lcse.umn.edu>
 *
 *    This file is maintained by:
 *      Grant Erickson <grant@lcse.umn.edu>
 *
 *    Module name: movie.h
 *
 *    Description:
 *      Macros, definitions, and data structures and function prototypes
 *      for key-frame interpolation and movie generation.
 */

#ifndef __MOVIE_H__
#define __MOVIE_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Constants */

#define NUMBER_OF_POINTS 40      /* Limit on the number of recorded points */
#define EPSILON          0.00001 /* Limit to prevent divide by zero errors */
#define MINIMUM_DELTA    0.0001  /* Smallest change in views permitted */


/* Function Prototypes */

void	Allocate(void);
void	interpol_trans(Trans left, Trans right, int delta,
		       Trans *inter, int index);
void	interpol_quat(Quat q1, Quat q2, int delta, Quat *inter, int index);
void	interpol_frame(int f1, int f2, int delta, int *inter, int index);
void	MarkKeyFrames(int delta, int *flags, int index);
void	slerp(float *q1, float *q2, float alpha, float *q);
void	DoneRecording(void);
void	total_del(int i);
void	RecordPoint(void);
void	StartMovie(Boolean save);
void	StopMovie(void);
Boolean	PlayMovieCB(XtPointer closure);
void	ChangeShuttleIncr(int incr, int direction, XtIntervalId id);
void	CreateRendVects(GLfloat m[4][4], float cdir[3], 
			float up[3], float eye[3], float trans[3]);
void	SaveCoordCB(int flags);

#ifdef __cplusplus
}
#endif

#endif /* __MOVIE_H__ */
