/*
 *    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
 *    Copyright (c) 1992 Army High Performance Computing Research Center
 *        (AHPCRC), University of Minnesota
 *    Copyright (c) 1995-1999 Laboratory for Computational Science and
 *        Engineering (LCSE), University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file CONTRIBUTORS for a list of contributors.
 *
 *    Original author(s):
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    This file is maintained by:
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    Module name: vox.h
 *
 *    Description:
 *      Macros, definitions, and data structures and function prototypes
 *      for voxel rendering routines.
 */

#ifndef __VOX_H__
#define __VOX_H__

#include "draw.h"

#ifdef __cplusplus
extern "C" {
#endif

void	SetView (int width, int height);
void	SetupGL (void);
void	ReadAllPoint (void);
void	ReadPoint (void);
void	ReadData (void);
void	PackColor (unsigned char *cmap);
void	PackAlpha (unsigned char *amap);
void	DrawVoxelWindow (unsigned fast, unsigned save);
void	DrawStereoWindow (unsigned fast);
void	DrawFinderWindow (void);
void	DrawFinderSpecial (FinderEnum mode, unsigned plane);

#ifdef __cplusplus
}
#endif

#endif /* __VOX_H__ */
