.\"
.\"    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
.\"    Copyright (c) 1992 Army High Performance Computing Research Center
.\"        (AHPCRC), University of Minnesota
.\"    Copyright (c) 1995-1999 Laboratory for Computational Science and
.\"        Engineering (LCSE), University of Minnesota
.\"
.\"    This is free software released under the GNU General Public License.
.\"    There is no warranty for this software.  See the file COPYING for
.\"    details.
.\"
.\"    See the file CONTRIBUTORS for a list of contributors.
.\"
.\"    Orignal author(s):
.\"      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
.\"
.\"    This file is maintained by:
.\"      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
.\"
.\"    Module name: icol.man
.\"
.\"    Description:
.\"      Reference page for icol
.\"
.TH icol 1 "1 Nov 1999" "Version 1.2" "GVL Ware"
.SH NAME
icol - interpolated color map editor
.SH SYNOPSIS
.B icol
[\-\fItoolkitoption\fP ...] [\-option ...] [\fImapfile\fP]
.SH DESCRIPTION
\fIIcol\fP is an interactive tool for creating and modifying color maps that
are interpolated between key points. Color maps are often used to create
images from arrays of scalar data, such as temperature, density or stress.
\fIIcol\fP can assign colors to key values and interpolate in several color
spaces. \fIIcol\fP can also edit maps of different lengths.
.PP
The \fIicol\fR display contains a menu bar and three work areas. The
\fBcontrol\fR menu is used for opening a file, saving the current color
bar to a file, picking a color index in another window, filing bug reports, 
and quitting. The \fBedit\fR menu controls the "snapping" of color channels
between knot points, and undo. To automatically place knot points, try the 
\fBPlace Knots\fR command.
.PP
The \fBmode\fR menu allows editing in either the RGB (red green blue), HSV
(hue saturation value), or YUV (video) color space. The \fBmode\fR menu also
contains toggles for automatically saving the color table and color map usage.
The \fBbrush\fR menu controls sketching in the graph area.
.PP
The top area displays the color bar and a graph of each color channel, in
either RGB, HSV or YUV color space. The graphs can be changed by sketching 
with the pointer, using a brush from the \fBbrush\fR menu.
.PP
The middle area displays all the colors in the above color bar, but
with each color in its own box. Clicking on a box selects that color
and places a knot at that point. Clicking on the selected color
removes the knot. Click and drag a knot to move it to a new cell.
.PP
The bottom area contains three scales for changing the color channels
of the selected knot. When a channel is changed, all the colors
between the selected knot and the neighboring knots will be proportionally
changed.
.PP
By selecting knots and changing channels, it is possible to create
color ramps between cells.
.PP
The \fBsnap\fR menu item in the edit menu linearly interpolates colors between
the selected knot and neighboring knots. The effect is to pull the lines
tight at the selected knot. \fBSnap All\fR snaps all of the knots, and the
remaining menu selections snap individual channels at the selected knot point.
.SS Color Spaces
Our retina is equipped with three kinds of receptors, each with a different
response to light wavelength. Thus we perceive the range of light to be a
color space with three dimensions. The three response curves peak at 
"blue", "green" and "red" wavelengths respectively. The green and red response
is much higher than blue, with green being perceived as brightest.
.PP
The most straightforward system is to specify a color using red, green
and blue coordinates, or RGB. Computer monitors are driven with RGB
voltages, and most color bar formats store colors as a triplet of red, 
green and blue values. Each value has a range from zero to 255,
so that it can be stored in a single byte. Using this method over 16
million colors can be created, more colors than there are pixels on the 
screen, and probably more than the eye can distinguish.
.PP
The hue, saturation and value, or HSV, color space is convenient 
for creating color bars of known saturation or value, while varying the hue. 
Hue corresponds to the angle in a color wheel, and ranges from zero to 360
degrees. Saturation is the purity of the color, with zero saturation
corresponding to levels of  grey. Value is the brightness of a color. For
example, zero hue, full saturation and full value is red. Zero hue, half 
saturation and full value is pink.
.PP
Because green is much brighter to the eye than blue or red, a simple color
bar that ranges at constant saturation and value through all the hues
will have a bright "spike" in the greens. For better control of brightness,
try the YUV color space, which is a color encoding used for video.
YUV is a linear rearrangement of RGB. The Y channel is called luminance, and
is the channel shown on a black and white television. The equation for Y is
about six tenths green, three tenths red and one tenth blue. A color bar
with constant Y should look constantly bright, independent of hue. U and V
encode the color information. U is blue minus luminance and V is red minus
luminance.
.PP
Experiment with the different color spaces by flipping back and forth, using
the \fBmode\fR menu.
.SS Mouse Actions
In the top area, clicking and dragging the mouse sketches the color value.
Clicking above the initial value makes the brush push values down. Clicking
below the initial value makes the brush push values up.
.IP "Left Button"
Edit the red line, which is either the red channel, hue, or luminance (Y),
depending on the color space mode.
.IP "Middle Button"
Edit the green line, which is either green, saturation, or U.
.IP "Left Button"
Edit the blue line, which is either blue, value, or V.
.IP "Shift + Button"
Place a knot, as if the color was selected in the middle area.
.PP
In the middle area, clicking places and removes knots:
.IP "Button"
Select or create a knot.  If the knot is already selected, remove the
knot.  Click and drag to move the knot point.
.IP "Shift + Button"
Snap the knot point, in addition to selecting and moving.
.SH OPTIONS
.PP
.I icol
accepts the following options:
.TP 8
.B \-autosave, \-a
.TP 8
.B \-base, \-b
.TP 8
.B \-help, \-h
This option will cause a brief description of the allowable options and
parameters to be printed.
.TP 8
.B \-colormode, \-m \fImode\fP
.TP 8
.B \-colorguide, \-g
.TP 8
.B \-format, \-f \fIformat\fP
.TP 8
.B \-output, \-o \fIfile\fP
.TP 8
.B \-maxundo, \-u \fInumber\fP
.TP 8
.B \-numcolor, \-n \fInumber\fP
.TP 8
.B \-rootvis, \-r
.TP 8
.B \-stomp, \-s
.TP 8
.B \-x

.SH RESOURCES
The program understands all of the core X Toolkit resource names and classes
as well as the following:
.TP 8
.B autoSave
Specifies whether or not changes should be automatically saved to the output
file. The default is ``false''.
.TP 8
.B colorGuide
.TP 8
.B colorMode
.TP 8
.B expert
.TP 8
.B fileFormat
.TP 8
.B maxUndo
.TP 8
.B numColor
.TP 8
.B output
Specifies the output file name. The default is a dash ``-'', which specifies
standard output.
.TP 8
.B rootVisual
.TP 8
.B slopeDiff
.TP 8
.B stomp
Specifies the number of colors in the system colormap to "stomp" on (i.e.
use for the color map). This works in conjunction with the \fBstompBase\fR
resource. The default is 0.
.IP
This option is useful in conjunction with other raster tools that use
these entries, such as xraster and xvcr. If there are enough color
entries, the lower entries are always stomped on, and icol uses higher
entries for the interface. If there are a limited number of entries
(e.g. a 256 color table on a 256 (8 bit) color system), the lower
colors are stomped on only when the mouse is pressed on the chart
region or a scroll bar. This way the interface can be seen when not
manipulating colors.
.TP 8
.B stompBase
Specifieds the first index in the system colormap to "stomp" on (i.e. use
for the color map). This works in conjunction with the \fBstomp\fR resource.
The default is 0.
.SH "SEE ALSO"
.BR animabob (1)
.SH AUTHORS

.SH NOTES
A workstation with mapped color (PseudoColor) graphics display is required.
.PP
\fIIcol\fR attempts to use the deepest PseudoColor visual available. This 
may cause problems with respect to the Motif toolkit. If your display
supports deeper visuals than the root visual (e.g. 12 plane PseudoColor) and
\fIicol\fR dies on startup  with  a  "Bad  Match"  X error, run \fIicol\fR
with the '-rootvis' option.
