/*
 *    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
 *    Copyright (c) 1992 Army High Performance Computing Research Center
 *        (AHPCRC), University of Minnesota
 *    Copyright (c) 1995-1999 Laboratory for Computational Science and
 *        Engineering (LCSE), University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file CONTRIBUTORS for a list of contributors.
 *
 *    Original author(s):
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    This file is maintained by:
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    Module name: abar.h
 *
 *    Description:
 *      
 */

#ifndef __ABAR_H__
#define __ABAR_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _PerBar {
    Widget	w;
    XColor	*xcolor;
} PerBar;

typedef struct _AxisBar {
    int		valid;
    PerBar	bar[3];
    GC		gc;
} AxisBar;

/* Function Prototypes */

void	AxisBarResize (AxisBar *abar);
void	AxisBarSetColors (AxisBar *abar, float cin [3], ColorMode rgbmode,
			  Colormap cmap);
AxisBar	*AxisBarNew (Widget *wl);

#ifdef __cplusplus
}
#endif

#endif /* __ABAR_H__ */
