/*
 *    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
 *    Copyright (c) 1992 Army High Performance Computing Research Center
 *        (AHPCRC), University of Minnesota
 *    Copyright (c) 1995-1999 Laboratory for Computational Science and
 *        Engineering (LCSE), University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file CONTRIBUTORS for a list of contributors.
 *
 *    Original author(s):
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    This file is maintained by:
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    Module name: parse.h
 *
 *    Description:
 *      Macros, definitions, and data structures and function prototypes
 *      for file parsing routines.
 */

#ifndef	__PARSE_H__
#define	__PARSE_H__

#ifdef __cplusplus
extern "C" {
#endif

#define	MATCH(strA, strB) (strncasecmp(strA, strB, strlen(strB)) == 0)

/* Function Prototypes */

SkipStack	ParseOneLine (FILE *file);
int		ParseLineCount (void);
void		ParseResetLineCount (void);

#ifdef __cplusplus
}
#endif

#endif /* __PARSE_H__ */
