/*
 *    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
 *    Copyright (c) 1992 Army High Performance Computing Research Center
 *        (AHPCRC), University of Minnesota
 *    Copyright (c) 1995-1999 Laboratory for Computational Science and
 *        Engineering (LCSE), University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file CONTRIBUTORS for a list of contributors.
 *
 *    Original author(s):
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    This file is maintained by:
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    Module name: util.h
 *
 *    Description:
 *      Macros, definitions, and data structures and function prototypes
 *      for general utility routines.
 */

#ifndef	__UTIL_H__
#define	__UTIL_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* Floating point math wrappers for optional extensions to the ANSI C
 * Programming Language Specification ISO/IEC 9899:1990 (E).
 */
#ifndef HAVE_COSF
#define	cosf	cos
#endif
#ifndef HAVE_SINF
#define	sinf	sin
#endif
#ifndef HAVE_TANF
#define	tanf	tan
#endif
#ifndef HAVE_FABSF
#define	fabsf	fabs
#endif
#ifndef	HAVE_SQRTF
#define	sqrtf	sqrt
#endif

/* Min & Max macros
 */
#define MIN(i,j)  ((i)<(j) ?  (i) : (j))
#define MAX(i,j)  ((i)>(j) ?  (i) : (j))
#define ABS(i)    ((i)< 0  ? -(i) : (i))

/* Memory macros
 */
#define MallocType(type)	(type *) malloc(sizeof(type))
#define CallocType(type,i)	(type *) calloc(i,sizeof(type))
#define ReallocType(ptr,type,i)	(type *) realloc(ptr,(i)*sizeof(type))
#define ZeroType(ptr,type)	(void) memset(ptr, 0, sizeof(type))
#define Free(ptr)		if (ptr) free(ptr)

/* Error checking macros
 * Use MemCheck after allocationg memory.
 */
#define Verify(expr,estr)	if (!(expr)) BailOut(estr,__FILE__,__LINE__)
#define MemCheck(ptr)	if (!(ptr)) BailOut("Out of memory",__FILE__,__LINE__)

/* Function Prototypes */

void		Error (char *errstr, ...);
void		SetCoreDump (int dumpit);
void		BailOut (char *errstr, char *fname, int lineno);
long		FindFileSize (char *fname);
unsigned char	*ReadColormap (unsigned char *cmap, char *cmapName);
char		*NewString (char *old, int extra);
void		CommaLong (char *s, long i);
long		ScanLong (char *s);
long		RoundUp (long a, long modulo);
long		Factor (long a);
unsigned	MarkTime (void);
int		ppopen (char **argv, int *pInOut);

#ifdef __cplusplus
}
#endif

#endif /* __UTIL_H__ */
