/*
 *    Copyright (c) 1992 Minnesota Supercomputer Center, Inc.
 *    Copyright (c) 1992 Army High Performance Computing Research Center
 *        (AHPCRC), University of Minnesota
 *    Copyright (c) 1995-1999 Laboratory for Computational Science and
 *        Engineering (LCSE), University of Minnesota
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file CONTRIBUTORS for a list of contributors.
 *
 *    Original author(s):
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    This file is maintained by:
 *      Ken Chin-Purcell <ken@ahpcrc.umn.edu>
 *
 *    Module name: xtutil.h
 *
 *    Description:
 *      Macros, definitions, and data structures and function prototypes
 *      for X support routines.
 */

#ifndef __XTUTIL_H__
#define	__XTUTIL_H__

#include <X11/Intrinsic.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Type Definitions */

/*
 * WidgetSpec is used in tables to create widget trees
 * using BuildWidgetTree. 
 */

typedef struct _WidgetSpec {
    unsigned long	flags;
    String		name;
    Widget		(*create)(Widget, String, ArgList, Cardinal);
} WidgetSpec;

#define W_PARENT	0x100
#define W_LAST_CHILD	0x010
#define W_NO_MANAGE	0x001


/* Function Prototypes */

void	GetValue (String resource, void *dest, Widget widget);
void	SetValue (String resource, XtArgVal val, Widget widget);
void	CenterWidget (Widget widget, int x, int y);
void	CenterWidgetOverCursor (Widget widget);
void	PositionDialogCB (Widget w, XtPointer closure, XtPointer callData);
Widget	ShellOfWidget (Widget w);
Widget	TopLevel (Widget w);
XVisualInfo	*FindDeepestPseudoVisual (Display *display, Screen *screen);
XVisualInfo	*FindRootVisual (Display *display, Screen *screen);
void	SwallowCells (Display *display, Colormap cmap, Pixel *holdPix, int *holdNum);
void	CopyColormap (Display *display, Colormap srcmap, Colormap dstmap, int ncolor);
void	MirrorColormap (Display *display, Colormap srcmap, Colormap dstmap, int ncolor);
void	AllocBlack (Display *display, Screen *screen, Colormap cmap);
void	QueryBackground (Widget w, XColor *bgc);
void	GrabUntilClick (Widget w, XEvent *ev);
void	ManageCB (Widget w, XtPointer closure, XtPointer callData);
void	UnmanageCB (Widget w, XtPointer closure, XtPointer callData);
void	SensitizeCB (Widget w, XtPointer closure, XtPointer callData);
void	DesensitizeCB (Widget w, XtPointer closure, XtPointer callData);
void	RemoveKeyCB (Widget w, XtPointer closure, XtPointer callData);
void	BuildWidgetTree (Widget parent, WidgetSpec *ws);
Widget	BuildOneWidget (Widget parent, char *name, Widget (*create )(Widget,String,ArgList,Cardinal ), int unmanaged);
Widget	GetWidget (char *name);
Widget	CheckWidget (char *name);
void	AddWidgetConverter (XtAppContext app);

#ifdef __cplusplus
}
#endif

#endif /* __XTUTIL_H__ */
