#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <unistd.h>

#include "definition.h"
#include "process.h"
#include "socket.h"

/*
 * Parse Token
 * Token = "TOKEN" | Buffer = "<TOKEN>ITEM</TOKEN>" | Result = "ITEM"
 * Return : 0  - success
 *          -1 - token not found
 */
int
ParseToken(char *Token, char *Result, const char *Buffer)
{
	char TokenStart[100];
	char TokenEnd[100];
	char *pstart, *pend;
	
	sprintf(TokenStart,"<%s>",Token);
	sprintf(TokenEnd,"</%s>",Token);
	
	if ((pstart = strstr(Buffer, TokenStart))== NULL) return -1;
	if ((pend = strstr(Buffer, TokenEnd)) == NULL) return -1;

	strncpy(Result, pstart+strlen(TokenStart), pend-pstart-strlen(TokenStart));
	Result[pend-pstart-strlen(TokenStart)] = '\0';

	return 0;
}


/*
 * Read field from raw, format it using display and copy to result
 */
void
ReadResultField(char *Token, char *Display, char *Result, const char *RawResult)
{
	char Temp[MAXBUFSIZE];
	char ParseResult[MAXBUFSIZE];

	if (ParseToken(Token, ParseResult, RawResult) == 0)
	{
		sprintf(Temp, Display, ParseResult);
		strcat(Result, Temp);
	}
}


/*
 * List all items in the raw result
 */
void
ListResult(char *Result, const char *RawResult, int NumResult)
{
	char Token[20];
	char Temp[MAXBUFSIZE];
	char ParseResult[MAXBUFSIZE];
	int i;

	sprintf(Temp,"Found %d resuls or more:\n", NumResult);
	strcat(Result, Temp);

	for (i = 1; i <= NumResult; i++)
	{
		sprintf(Token,"ITEM%d",i);
		ParseToken(Token,ParseResult,RawResult);
		sprintf(Temp,"%s\n",ParseResult);
		strcat(Result, Temp);
	}
}


/*
 * Process Result
 * Raw result from server
 * Return: Formatted result
 */
void
ProcessResult(char *Result)
{
	int NumResult;
	char Buffer[MAXBUFSIZE];
	char RawResult[MAXBUFSIZE];

	strcpy(RawResult, Result);
	Result[0] = '\0';

	/* check if rawresult in <OUTPUT></OUTPUT> */
	if (ParseToken("OUTPUT", Buffer, RawResult) == -1)
	{
		strcpy(Result, "Server returned erroneous result. Please try your query again");
		return;
	}
	
	/* check if there is a detected error <ERROR></ERROR> */
	if (ParseToken("ERROR", Buffer, RawResult) == 0)
	{
		sprintf(Result, "Server returned error #%s, check http://www.animenfo.com for more details", Buffer);
		return;
	}

	/* check number of results returned <RESULT></RESULT> */
	if (ParseToken("RESULT", Buffer, RawResult) == -1)
	{
		strcpy(Result, "Server returned erroneous result. Please try your query again");
		return;
	}
	
	NumResult = atoi(Buffer);

	if (NumResult == 1)
	{
		ReadResultField("TITLE", "Title: %s\n", Result, RawResult);
		ReadResultField("CATEGORY", "Category: %s\n", Result, RawResult);
		ReadResultField("TOTAL", "Total: %s\n", Result, RawResult);
		ReadResultField("GENRE", "Genre: %s\n", Result, RawResult);
		ReadResultField("YEAR", "Year: %s\n", Result, RawResult);
		ReadResultField("STUDIO", "Studio: %s\n", Result, RawResult);
		ReadResultField("USDISTRO", "US Distribution: %s\n", Result, RawResult);
		ReadResultField("RATING", "Rating: %s\n", Result, RawResult);
		ReadResultField("DESCRIPTION", "Description:\n%s\n", Result, RawResult);
		ReadResultField("LINK", "Link: %s\n", Result, RawResult);
		return;
	}
	else
	if (NumResult == 0)
	{
		strcpy(Result, "No results found");
		return;
	}
	else
	{
		ListResult(Result, RawResult, NumResult);
		return;
	}
}


/*
 * To search for an anime title
 */
int
SearchAnime(char *Server, int Port, char *Buffer)
{
	int   sockfd, numbytes, length;
	char  Message[MAXBUFSIZE];

	if ((sockfd = ConnectToServer(Message,Server,Port)) == -1)
	{
		strcpy(Buffer,Message);
		close(sockfd);
		return -1;
	}

	printf("Connected to %s\n", Message);	

	/* Create query */
	sprintf(Message,"<ANIME><TITLE>%s</TITLE><FIELD>TITLE CATEGORY TOTAL GENRE YEAR STUDIO USDISTRO RATING UPDATED DESCRIPTION LINK</FIELD></ANIME>", Buffer);
	
	/* send search query to the server */
	length = strlen(Message);
	if (sendall(sockfd, Message, &length) == -1)
	{
		strcpy(Buffer,Message);
		close(sockfd);
		return -1;
	}

	/* receive reply from the server */
   	if ((numbytes = receiveall(sockfd, Buffer, 5)) == -1)
	{
		strcpy(Buffer,"Cannot receive from server");
		close(sockfd);
		return -1;
	}
	Buffer[numbytes] = '\0';

	/* success! we're done */
	close(sockfd);
	return 1;
}
