#!/bin/sh

[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

  - Support for the F-Prot command-line scanner

tac

rm -f test.log test.out
touch test.log test.out

if [ ! -e /usr/local/bin/f-prot ]; then
    # F-Prot not installed, fake a successful run.
    echo -n "SKIPPED: F-Prot not installed.  " >&2
    cat $TEST_RESULTS/sanitizer.fprotd.ok >test.out
    exit 0
fi

export EICAR='X5O!P%@AP[4\PZX54(P^)7CC)7}$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*'

for ARG in -nofprot -yesfprot; do
  $ANOMY/bin/sanitizer.pl $ARG $SAN_CONF \
    'header_rev = 0' \
    'feat_testing = 1' \
    'feat_log_stderr = 1' \
    'feat_log_inline = 1' \
    'feat_log_trace = 0' <<EOF 2>>test.log >>test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
Subject: Elephant man! $ARG
To: fake@example.com
Content-Type: text/plain
Content-Transfer-Encoding: 8bit

$EICAR

EOF
done

