# Deutsches Language file.
#
# (C) 2003 Anope Team
# Contact us at info@anope.org
#   
# Please read COPYING and README for furhter details.
#     
# Based on the original code of Epona by Lara.
# Based on the original code of Services by Andy Church. 
#
# Translated by chemical <chem@gmx.net>,shine <dh@shinewelt.de>
# - Solltest du irgendwelche Rechtschreibfehler oder sonstige
#   Verbesserungsvorschlge haben, immer her damit!
#
# letzte nderung: 28.02.2003
#
#
# This program is free but copyrighted software; see the file COPYING for
# details.
#
# Based on the original code of Services by Andy Church.
# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, let me know
# (achurch@dragonfire.net) which message is causing a problem and I'll see
# what I can do.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# config.h).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.

###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	Deutsch (German)

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
#	%b %d %H:%M:%S %Y %Z
	%d.%b.%Y, %H:%M:%S %Z

# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a, %d.%B.%Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%d.%b.%Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	Son
	Mon
	Die
	Mit
	Don
	Fre
	Sam
# %A
STRFTIME_DAYS_LONG
	Sonntag
	Montag
	Dienstag
	Mittwoch
	Donnerstag
	Freitag
	Samstag
# %b
STRFTIME_MONTHS_SHORT
	Jan
	Feb
	Mr
	Apr
	Mai
	Jun
	Jul
	Aug
	Sep
	Okt
	Nov
	Dez
# %B
STRFTIME_MONTHS_LONG
	Januar
	Februar
	Mrz
	April
	Mai
	Juni
	Juli
	August
	September
	Oktober
	November
	Dezember


# This is used in ChanServ/NickServ INFO displays.
COMMA_SPACE
	, 


# Various error messages.
USER_RECORD_NOT_FOUND
	Interner Fehler - kann Anfrage nicht verarbeiten.
UNKNOWN_COMMAND
	Unbekannter Befehl %s.
UNKNOWN_COMMAND_HELP
	Unbekannter Befehl %s.  "/msg %s HELP" fr Hilfe.
SYNTAX_ERROR
	Syntax: %s
MORE_INFO
	/msg %s HELP %s fr weitere Informationen.
NO_HELP_AVAILABLE
	Keine Hilfe verfgbar fr %s.
OBSOLETE_COMMAND
	Dieser Befehl ist berholt; benutze stattdessen %s.

BAD_USERHOST_MASK
	Maske sollte in dieser Form sein: user@host.
BAD_EXPIRY_TIME
	Ungltige Auslaufzeit.
USERHOST_MASK_TOO_WIDE
	%s ist zu allgemeingltig; bitte benutze eine genauere Hostmaske.

SERVICE_OFFLINE
	%s sind derzeit nicht verfgbar, bitte versuche es spter noch einmal.
READ_ONLY_MODE
	Achtung: Services sind im Read-Only-Modus; nderungen werden nicht bernommen!

PASSWORD_INCORRECT
	Falsches Passwort.

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	Zugriff verweigert.
PERMISSION_DENIED
	Berechtigung nicht ausreichend.
RAW_DISABLED
	RAW wurde deaktiviert. Um RAW nutzen zu knnen, muss DisableRaw in der Services Config Datei deaktiviert werden.

MORE_OBSCURE_PASSWORD
	Bitte versuche es nochmal mit einem besseren Passwort. 
	Passworte sollten mindestens 5 Zeichen lang sein und nichts mit deinem 
	Nick zu tun haben. Weiterhin kann keine Leer- oder 
	Tabulatortaste enthalten sein.

PASSWORD_TRUNCATED
	Achtung: Dein Passwort wurde auf %d Zeichen gekrzt.

NICK_NOT_REGISTERED
	Dein Nick ist nicht registriert.
NICK_NOT_REGISTERED_HELP
	Dein Nick ist nicht registriert.  Benutze /msg %s HELP fr weitere Hilfe, wie du deinen Nick registrieren kannst.
NICK_X_NOT_REGISTERED
	Nick %s ist nicht registriert.
NICK_X_IN_USE
	Nick %s wird derzeit benutzt.
NICK_X_NOT_IN_USE
	Nick %s wird derzeit nicht benutzt.
NICK_X_NOT_ON_CHAN
	%s ist derzeit nicht im channel %s.
NICK_X_FORBIDDEN
	Nick %s sollte nicht registriert bzw benutzt werden.
NICK_X_FORBIDDEN_OPER
	Nick %s wurde verboten von %s:
	%s
NICK_X_ILLEGAL
	Nick %s ist ein illegaler Nickname und kann nicht benutzt werden.
NICK_X_TRUNCATED
	Nick %s wurde auf %d Zeichen gekrzt.
CHAN_X_NOT_REGISTERED
	Channel %s ist nicht registriert.
CHAN_X_NOT_IN_USE
	Channel %s existiert nicht.
CHAN_X_FORBIDDEN
	Channel %s sollte nicht registriert bzw benutzt werden.
CHAN_X_FORBIDDEN_OPER
	Channel %s wurde verboten von %s:
	%s
CHAN_X_SUSPENDED
	      Suspended: [%s] %s
NICK_IDENTIFY_REQUIRED
	Um diesen Befehl nutzen zu knnen, musst du dich identifizieren.
	Versuch es erneut nach /msg %s IDENTIFY password.
CHAN_IDENTIFY_REQUIRED
	Um diesen Befehl nutzen zu knnen, musst du dich identifizieren.
	Versuch es erneut nach /msg %s IDENTIFY %s password.
	
MAIL_DISABLED
	eMail-Handling der Services wurde deaktiviert.
MAIL_INVALID
	eMail-Adresse fr %s ist ungltig.
MAIL_X_INVALID
	%s ist keine gltige eMail-Adresse.
MAIL_LATER
	Die Services knnen gerade keine Mail verschicken; bitte versuche es spter noch einmal.
MAIL_DELAYED
	Bitte warte noch %d Sekunden und versuche es dann erneut.
	
NO_REASON
	Kein Grund
UNKNOWN
	<unbekannt>

# Duration system
DURATION_DAY
	1 Tag
DURATION_DAYS
	%d Tage
DURATION_HOUR
	1 Stunde
DURATION_HOURS
	%d Stunden
DURATION_MINUTE
	1 Minute
DURATION_MINUTES
	%d Minuten
DURATION_SECOND
	1 Sekunde
DURATION_SECONDS
	%d Sekunden
	
# Human readable expiration
NO_EXPIRE
	luft nicht aus
EXPIRES_SOON
	verfllt beim nchstem Datenbank-Update
EXPIRES_M
	verfllt in %d Minuten
EXPIRES_1M
	verfllt in %d Minute
EXPIRES_HM
	verfllt in %d Stunden, %d Minuten
EXPIRES_H1M
	verfllt in %d Stunden, %d Minute
EXPIRES_1HM
	verfllt in %d Stunde, %d Minuten
EXPIRES_1H1M
	verfllt in %d Stunde, %d Minute
EXPIRES_D
	verfllt in %d Tagen
EXPIRES_1D
	verfllt in %d Tag

# Generic Footer message
END_OF_ANY_LIST
	End of %s list.

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Dieser Nick gehrt schon jemand anderem. Bitte whle einen anderen.
	(Wenn der Nick dir gehrt, tippe /msg %s IDENTIFY password.)
NICK_IS_SECURE
	Dieser Nickname ist registriert und geschtzt.  Wenn es dein Nick
	ist, tippe /msg %s IDENTIFY password. Ansonsten whle bitte
	einen anderen Nick.
NICK_MAY_NOT_BE_USED
	Dieser Nickname kann nicht benutzt werden. Bitte whle einen anderen.
FORCENICKCHANGE_IN_1_MINUTE
	Wenn du ihn nicht innerhalb einer Minute identifizierst, wird er automatisch gendert.
FORCENICKCHANGE_IN_20_SECONDS
	Wenn du ihn nicht innerhalb von 20 Sekunden identifizierst, wird er automatisch gendert.
FORCENICKCHANGE_NOW
	Dieser Nickname ist registriert, du kannst ihn nicht benutzen.
FORCENICKCHANGE_CHANGING
	Dein Nickname wurde gendert in %s

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER password [email]
NICK_REGISTER_SYNTAX_EMAIL
	REGISTER password email
NICK_REGISTRATION_DISABLED
	Sorry, das Registrieren von Nicknames ist derzeit deaktiviert.
NICK_REGISTRATION_FAILED
	Sorry, Registrierung fehlgeschlagen.
NICK_REG_PLEASE_WAIT
	Bitte warte %d Sekunden, bevor der REGISTER Befehl wieder funktioniert.
NICK_CANNOT_BE_REGISTERED
	Nickname %s kann nicht registriert werden.
NICK_ALREADY_REGISTERED
	Nickname %s ist bereits registriert!
NICK_REGISTERED
	Nickname %s ist unter deinem Host registriert worden: %s
NICK_PASSWORD_IS
	Dein Passwort ist %s - behalte es fr sptere Benutzung.

# GROUP responses
NICK_GROUP_SYNTAX
	GROUP Ziel Passwort
NICK_GROUP_DISABLED
	Sorry, das Gruppieren von Nicknames ist derzeit deaktiviert.
NICK_GROUP_FAILED
	Sorry, Gruppieren fehlgeschlagen.
NICK_GROUP_PLEASE_WAIT
	Bitte warte %d Sekunden, bevor der GROUP Befehl wieder funktioniert.
NICK_GROUP_CHANGE_DISABLED
	Dein Nick ist bereits registriert; tippe /msg %s DROP um ihn zu lschen.
NICK_GROUP_SAME
	Du bist bereits Mitglied der Gruppe %s.
NICK_GROUP_TOO_MANY
	Es sind zu viele Nicks in %s's Gruppe; Liste sie auf und lsche einige davon.
	Tippe /msg %s HELP GLIST und /msg %s HELP DROP fr weitere Infos.
NICK_GROUP_JOINED
	Du bist jetzt in der Gruppe %s vertreten.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY Passwort
NICK_IDENTIFY_FAILED
	Sorry, die Identifizierung ist fehlgeschlagen.
NICK_IDENTIFY_SUCCEEDED
	Passwort akzeptiert - du bist nun angemeldet.
NICK_IDENTIFY_EMAIL_REQUIRED
	Du musst eine eMail-Adresse fr deinen Nick angeben.
	NickServ kann dir dann dein Passwort per Mail senden, falls du es
	vergessen solltest.
NICK_IDENTIFY_EMAIL_HOWTO
	Tippe /msg %S SET EMAIL eMail wenn du deine eMail-Adresse einstellen willst.
	Deine Privatsphre wird respektiert; diese eMail-Adresse ist Dritten nicht 
	zugnglich.
	
# LOGOUT responses
NICK_ALREADY_IDENTIFIED
	Du bist bereits angemeldet.

# UPDATE responses
NICK_UPDATE_SUCCESS
	Status aktualisiert (memos, vhost, chmodes, flags).
	
# LOGOUT responses
NICK_LOGOUT_SYNTAX
	LOGOUT
NICK_LOGOUT_SUCCEEDED
	Du wurdest ausgeloggt.
NICK_LOGOUT_X_SUCCEEDED
	Nick %s wurde erfolgreich ausgeloggt.

# DROP responses
NICK_LOGOUT_SERVICESADMIN
	Ausloggen von %s nicht mglich, da es sich um einen Services Administrator handelt.

# DROP responses
NICK_DROP_DISABLED
	Sorry, das Entfernen von Nicknames ist derzeit deaktiviert.
NICK_DROPPED
	Die Registrierung deines Nicknamens wurde gelscht.
NICK_X_DROPPED
	Nickname %s wurde aus der Datenbank entfernt.

# SET responses
NICK_SET_SYNTAX
	SET Option Parameter
NICK_SET_SERVADMIN_SYNTAX
	SET [Nick] Option Parameters
NICK_SET_DISABLED
	Sorry, das ndern der Optionen wurde deaktiviert.
NICK_SET_UNKNOWN_OPTION
	Unbekannte SET Option %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Unbekannte SET Option %s, oder der Nickname ist nicht registriert.
NICK_SET_OPTION_DISABLED
	Option %s kann in diesem Netzwerk nicht benutzt werden.

# SET DISPLAY responses
NICK_SET_DISPLAY_INVALID
	Der neue "Anfhrer" MUSS ein Nick in deiner Nickname-Gruppe sein!
NICK_SET_DISPLAY_CHANGED
	Der neue "Anfhrer" deiner Nickname-Gruppe ist jetzt %s.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	Sorry, konnte dein Passwort nicht ndern.
NICK_SET_PASSWORD_CHANGED
	Passwort gendert.
NICK_SET_PASSWORD_CHANGED_TO
	Passwort gendert in %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE Nummer
NICK_SET_LANGUAGE_UNKNOWN
	Unbekannte Sprachen-Nummer %d.  Tippe /msg %s HELP SET LANGUAGE um eine Liste aller verfgbaren Sprachen zu erhalten.
NICK_SET_LANGUAGE_CHANGED
	Sprache wurde gendert zu Deutsch.

# SET URL responses
NICK_SET_URL_CHANGED
	URL zu %s gendert.
NICK_SET_URL_UNSET
	URL entfernt.

# SET EMAIL responses
NICK_SET_EMAIL_CHANGED
	eMail-Adresse zu %s gendert.
NICK_SET_EMAIL_UNSET
	eMail-Adresse wurde entfernt.
NICK_SET_EMAIL_UNSET_IMPOSSIBLE
	Du kannst in diesem Netzwerk deine eMail-Adresse nicht entfernen.
	
# SET ICQ responses
NICK_SET_ICQ_CHANGED
	ICQ-Nummer auf %s gesetzt.
NICK_SET_ICQ_UNSET
	ICQ-Nummer wurde entfernt.
NICK_SET_ICQ_INVALID
	%s ist keine gltige ICQ-Nummer.
	
# SET GREET responses
NICK_SET_GREET_CHANGED
	Begrssungsnachricht wurde zu %s gendert.
NICK_SET_GREET_UNSET
	Begrssungsnachricht wurde entfernt.

# SET PROTECT responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	Kill-Schutz ist jetzt ON.
NICK_SET_KILL_QUICK
	Kill-Schutz ist jetzt ON, mit einer geringeren Wartezeit.
NICK_SET_KILL_IMMED
	Kill-Schutz ist jetzt ON, ohne Wartezeit.
NICK_SET_KILL_IMMED_DISABLED
	Die IMMED Option ist in diesem Netzwerk nicht verfgbar.
NICK_SET_KILL_OFF
	Kill-Schutz ist nun OFF.

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	Nick-Sicherheit ist jetzt ON.
NICK_SET_SECURE_OFF
	Nick-Sicherheit ist jetzt OFF.

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	Privat-Option ist jetzt ON.
NICK_SET_PRIVATE_OFF
	Privat-Option ist jetzt OFF.

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	Deine eMail-Adresse wird jetzt in der %s INFO Anzeige nicht mehr erscheinen.
NICK_SET_HIDE_EMAIL_OFF
	Deine eMail-Adresse wird jetzt in der %s INFO Anzeige erscheinen.
NICK_SET_HIDE_MASK_ON
	Deine letzte Hostmaske user@host wird jetzt in der %s INFO Anzeige nicht mehr erscheinen.
NICK_SET_HIDE_MASK_OFF
	Deine letzte Hostmaske user@host wird jetzt in der %s INFO erscheinen.
NICK_SET_HIDE_QUIT_ON
	Deine letzte Quit-Message wird jetzt in der %s INFO Anzeige nicht mehr erscheinen.
NICK_SET_HIDE_QUIT_OFF
	Deine letzte Quit-Message wird jetzt in der %s INFO Anzeige erscheinen.
	
# SET MSG responses
NICK_SET_MSG_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_MSG_ON
	Services werden dir jetzt durch messages antworten.
NICK_SET_MSG_OFF
	Services werden dir jetzt durch notices antworten.

# SET NOEXPIRE responses
NICK_SET_NOEXPIRE_SYNTAX
	SET [Nickname] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	Nick %s wird nicht auslaufen.
NICK_SET_NOEXPIRE_OFF
	Nick %s wird auslaufen.

# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [mask]
NICK_ACCESS_ALREADY_PRESENT
	Mask %s ist bereits auf der Access-Liste.
NICK_ACCESS_REACHED_LIMIT
	Sorry, du kannst nur %d Eintrge auf der Access-Liste speichern.
NICK_ACCESS_ADDED
	%s wurde zu deiner Access-Liste hinzugefgt.
NICK_ACCESS_NOT_FOUND
	%s wurde nicht auf deiner Access-Liste gefunden.
NICK_ACCESS_DELETED
	%s wurde von deiner Access-Liste entfernt.
NICK_ACCESS_LIST
	Access-Liste:
NICK_ACCESS_LIST_X
	Access-List von %s:

# INFO responses
NICK_INFO_SYNTAX
	INFO nick [ALL]
NICK_INFO_REALNAME
	%s ist %s
NICK_INFO_SERVICES_OPER
	%s ist ein Services-Operator.
NICK_INFO_SERVICES_ADMIN
	%s ist ein Services-Admin.
NICK_INFO_ADDRESS
	Letzte gesehene Hostmask: %s
NICK_INFO_ADDRESS_ONLINE
	          ist online von: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s ist derzeit online.
NICK_INFO_TIME_REGGED
	        Registriert seit: %s
NICK_INFO_LAST_SEEN
	     Letztes Mal gesehen: %s
NICK_INFO_LAST_QUIT
	   Letzte Quit-Nachricht: %s
NICK_INFO_URL
	                     URL: %s
NICK_INFO_EMAIL
	           eMail-Adresse: %s
NICK_INFO_VHOST
	                   vhost: %s
NICK_INFO_ICQ
	                   ICQ #: %d
NICK_INFO_GREET
	          Grussnachricht: %s
NICK_INFO_OPTIONS
	                Optionen: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Kill-Schutz
NICK_INFO_OPT_SECURE
	Secure-Modus
NICK_INFO_OPT_PRIVATE
	Privat
NICK_INFO_OPT_MSG
	Message Mode
NICK_INFO_OPT_NONE
	Keine
NICK_INFO_NO_EXPIRE
	Dieser Nickname wird nicht auslaufen.
NICK_INFO_FOR_MORE
	Fr weitere Informationen, tippe /msg %s INFO %s ALL.

# LIST responses
NICK_LIST_SYNTAX
	LIST Muster
NICK_LIST_SERVADMIN_SYNTAX
	LIST Muster [FORBIDDEN] [NOEXPIRE] [UNCONFIRMED]
NICK_LIST_HEADER
	Liste der gefundenen Eintrge %s:
NICK_LIST_RESULTS
	Ende der Liste - %d/%d Treffer angezeigt.

# GLIST responses
NICK_ALIST_SYNTAX
	ALIST nickname
NICK_ALIST_HEADER
	Channels auf die du Zugriff hast:
	  Num  Channel              Level    Description 
NICK_ALIST_HEADER_X
	Channels auf die %s Zugriff hat:
	  Num  Channel              Level    Description 
NICK_ALIST_XOP_FORMAT
	  %3d %c%-20s %-8s %s
NICK_ALIST_ACCESS_FORMAT
	  %3d %c%-20s %-8d %s
NICK_ALIST_FOOTER
	Ende der Liste - %d/%d Treffer angezeigt.

# GLIST responses
NICK_GLIST_HEADER
	Liste der Nicks in deiner Gruppe:
NICK_GLIST_HEADER_X
	Liste der Nicknamen in der Gruppe von %s:
NICK_GLIST_FOOTER
	%d Nicks in der Gruppe.

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER Nickname [Passwort]
NICK_NO_RECOVER_SELF
	Du kannst dich nicht selber recovern!
NICK_RECOVERED
	Der User, der mit deinem Nick online gewesen ist, wurde gekillt.
	Tippe /msg %s RELEASE %s ein, um ihn vor dem 1-Minute-Timeout zurckzubekommen.

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE Nickname [Password]
NICK_RELEASE_NOT_HELD
	Nick %s ist nicht gesperrt.
NICK_RELEASED
	Die Services haben den Nick wieder verfgbar gemacht.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST Nickname [Passwort]
NICK_NO_GHOST_SELF
	Du kannst dich doch nicht selber ghosten!
NICK_GHOST_KILLED
	Ghost mit deinem Nick wurde entfernt.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS Nickname
NICK_GETPASS_UNAVAILABLE
	GETPASS nicht verfgbar, da die Verschlsselung aktiviert ist.
NICK_GETPASS_PASSWORD_IS
	Passwort von %s ist %s.
	
# SENDPASS responses
NICK_GETEMAIL_SYNTAX
	GETEMAIL user@email-host Keine WildCards!!
NICK_GETEMAIL_EMAILS_ARE
	Passende Emails %s bis %s.
NICK_GETEMAIL_NOT_USED
	Keine eingetragenen Emails fr %s.
	
# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS Nickname
NICK_SENDPASS_UNAVAILABLE
	SENDPASS Befehl nicht verfgbar, da die Verschlsselung aktiviert ist.
NICK_SENDPASS_SUBJECT
	Nick-Passwort (%s)
NICK_SENDPASS_HEAD
	Hi,
NICK_SENDPASS_LINE_1
	Du wolltest dir dein Passwort von dem Nick %s mailen lassen.
NICK_SENDPASS_LINE_2
	Das Passwort ist %s. Aus Sicherheitsgrnden solltest du das Passwort nach Erhalt dieser eMail ndern.
NICK_SENDPASS_LINE_3
	Wenn du nicht weisst, warum du diese Mail erhalten hast, ignoriere sie bitte.
NICK_SENDPASS_LINE_4
	BITTE NICHT AUF DIESE NACHRICHT ANTWORTEN!
NICK_SENDPASS_LINE_5
	%s Administratoren.
NICK_SENDPASS_OK
	Das Passwort von %s wurde per eMail verschickt.

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID Nickname [Reason]
NICK_FORBID_SYNTAX_REASON
	FORBID Nickname Reason
NICK_FORBID_SUCCEEDED
	Der Nick %s ist nun verboten.
NICK_FORBID_FAILED
	Konnte den Nick %s nicht verbieten!

# Nick Registration responses
NICK_REQUESTED
	Dieser Nick wurde bereits angefordert, bitte prfe deinen Email Account fr das Passwort.
NICK_REG_RESENT
	Dein Passcode wurde noch einmal an %s geschickt.
NICK_REG_UNABLE
	Nick konnte NICHT registriert werden, versuche es spter noch einmal.
NICK_IS_PREREG
	Dieser Nick bentigt das Email Besttigungs Passwort vor Abschlu der Registrierung.
NICK_ENTER_REG_CODE
	Ein Password wurde zu %s gesendet, bitte tippe /msg %s confirm <passcode> um die Registrierung abzuschlieen.
NICK_CONFIRM_NOT_FOUND
	Registrieungs Stufe 1 ist eventuell abgelaufen, bitte nutze zuerst "/msg %s register <password> <email>".
NICK_CONFIRM_INVALID
	Ein ungltiger Passcode wurde eingegeben, prfe bitte deine Email und gib den Code erneut ein.
NICK_REG_MAIL_SUBJECT
	Nickname Registrierung (%s)
NICK_REG_MAIL_HEAD
	Hi,
NICK_REG_MAIL_LINE_1
	Du hast die Registrierung des Nicknamen %s angefordert.
NICK_REG_MAIL_LINE_2
	Bitte tippe " /msg %s confirm %s " zum Abschlu der Registrierung ein.
NICK_REG_MAIL_LINE_3
	Wenn du nicht weisst, warum du diese Mail erhalten hast, ignoriere sie bitte.
NICK_REG_MAIL_LINE_4
	BITTE NICHT AUF DIESE NACHRICHT ANTWORTEN!
NICK_REG_MAIL_LINE_5
	Die %s Administratoren.
NICK_GETPASS_PASSCODE_IS
	Passcode fr %s ist %s.
NICK_FORCE_REG
	Nickname %s besttigt

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Automatischer Channel-Operator Status
CHAN_LEVEL_AUTOVOICE
	Automatischer Voice-Status
CHAN_LEVEL_AUTOHALFOP
	Automatischer Half-Op Status
CHAN_LEVEL_AUTOPROTECT
	Automatischer Founder-Status
CHAN_LEVEL_AUTODEOP
	Channel-Operator-Status nicht erlaubt
CHAN_LEVEL_NOJOIN
	Der Channel kann nicht betreten werden, da er RESTRICTED ist.
CHAN_LEVEL_INVITE
	INVITE-Befehl erlaubt
CHAN_LEVEL_AKICK
	AKICK-Befehl erlaubt
CHAN_LEVEL_SET
	SET-Befehl erlaubt (nicht FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	CLEAR-Befehl erlaubt
CHAN_LEVEL_UNBAN
	UNBAN-Befehl erlaubt
CHAN_LEVEL_OPDEOP
	OP/DEOP-Befehl erlaubt
CHAN_LEVEL_ACCESS_LIST
	Ansicht der Channel-Access-Liste erlaubt
CHAN_LEVEL_ACCESS_CHANGE
	nderungen an der Channel-Access-Liste erlaubt
CHAN_LEVEL_MEMO
	Erlaubnis Channel-Memos zu lesen
CHAN_LEVEL_ASSIGN
	Erlaubnis Bots hinzuzufgen / zu entfernen
CHAN_LEVEL_BADWORDS
	BADWORDS-Befehl erlaubt
CHAN_LEVEL_NOKICK
	Wird nicht durch den Bot-Kicker gekicked
CHAN_LEVEL_FANTASIA
	Darf die Befehle des Fantasia-Mode benutzen
CHAN_LEVEL_SAY
	SAY/ACT-Befehl erlaubt
CHAN_LEVEL_GREET
	Grussmeldung wird angezeigt
CHAN_LEVEL_VOICEME
	Erlaubnis sich selbst zu (de)voicen
CHAN_LEVEL_VOICE
	VOICE/DEVOICE-Befehl erlaubt
CHAN_LEVEL_GETKEY
	GETKEY-Befehl erlaubt
CHAN_LEVEL_OPDEOPME
	Erlaubnis sich selbst zu (de)op'en
CHAN_LEVEL_HALFOPME
	Erlaubnis sich selbst zu (de)halfop'en
CHAN_LEVEL_HALFOP
	HALFOP/DEHALFOP-Befehl erlaubt
CHAN_LEVEL_PROTECTME
	Erlaubnis, selber den Schutz ein/auszuschalten
CHAN_LEVEL_PROTECT
	PROTECT-DEPROTECT-Befehl erlaubt
CHAN_LEVEL_KICKME
	Erlaubnis, sich selbst zu kicken
CHAN_LEVEL_KICK
	KICK-Befehl erlaubt
CHAN_LEVEL_SIGNKICK
	Kein signierter Kick wenn SIGNKICK LEVEL genutzt wird

# Automatic responses
CHAN_LEVEL_BANME
	Erlaubnis, sich selbst zu bannen
CHAN_LEVEL_BAN
	Erlaubnis, BAN zu nutzen
CHAN_LEVEL_TOPIC
	Erlaubnis, TOPIC zu nutzen
CHAN_LEVEL_INFO
	Erlaubnis, INFO mit der ALL Option zu nutzen

# Automatic responses
CHAN_IS_REGISTERED
	Dieser Channel wurde registriert von %s.
CHAN_NOT_ALLOWED_OP
	Du hast keine Erlaubnis, den Operator-Status in %s zu benutzen.
CHAN_MAY_NOT_BE_USED
	Dieser Channel kann nicht benutzt werden.
CHAN_NOT_ALLOWED_TO_JOIN
	Dir ist es nicht erlaubt, diesen Channel zu betreten.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER channel password description
CHAN_REGISTER_DISABLED
	Sorry, die Registrierung von Channels ist derzeit deaktiviert.
CHAN_REGISTER_NOT_LOCAL
	Lokale Channels knnen nicht registriert werden.
CHAN_MUST_REGISTER_NICK
	Du musst erst deinen Nick registrieren.  Tippe /msg %s HELP fr die Hilfe dafr ein.
CHAN_MUST_IDENTIFY_NICK
	Bitte identifiziere dich zuerst durch %s, in dem du diesen Befehl benutzt:
	/msg %s IDENTIFY password
CHAN_MAY_NOT_BE_REGISTERED
	Channel %s kann nicht registriert werden.
CHAN_ALREADY_REGISTERED
	Channel %s ist bereits registriert!
CHAN_MUST_BE_CHANOP
	Du musst Channel-Operator sein um diesen Channel zu registrieren.
CHAN_REACHED_CHANNEL_LIMIT
	Sorry, du hast bereits %d Channels auf deinen Namen registriert.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Sorry, du hast bereits das Limit von %d registrierten Channels erreicht.
CHAN_REGISTRATION_FAILED
	Sorry, Registrierung fehlgeschlagen.
CHAN_REGISTERED
	Channel %s ist registriert unter deinem Nicknamen: %s
CHAN_PASSWORD_IS
	Dein Channel-Passwort ist %s - behalte es fr sptere Benutzung.

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY channel password
CHAN_IDENTIFY_FAILED
	Sorry, Identifizierung ist fehlgeschlagen.
CHAN_IDENTIFY_SUCCEEDED
	Passwort akzeptiert - du hast jetzt Founderlevel-Zugriff auf %s.

# LOGOUT responses
CHAN_LOGOUT_SYNTAX
	LOGOUT channel nickname
CHAN_LOGOUT_SERVADMIN_SYNTAX
	LOGOUT channel [nickname]
CHAN_LOGOUT_SUCCEEDED
	User %s wurde vom Channel %s ausgeloggt.
CHAN_LOGOUT_ALL_SUCCEEDED
	Alle identifizierten User wurden vom Channel ausgeloggt %s.

# DROP responses
CHAN_DROP_SYNTAX
	DROP Channel
CHAN_DROP_DISABLED
	Sorry, das Entfernen von Channel-Registrierungen ist derzeit deaktiviert.
CHAN_DROPPED
	Channel %s wurde aus der Datenbank entfernt.

# SET responses
CHAN_SET_SYNTAX
	SET channel option parameter
CHAN_SET_DISABLED
	Sorry, Channel-Optionen sind derzeit deaktiviert.
CHAN_SET_UNKNOWN_OPTION
	Unbekannte SET-Option %s.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s hat zu viele Channels auf seinen Namen registriert.
CHAN_FOUNDER_CHANGED
	Founder von %s wurde gendert zu %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	Vertreter von %s wurde gendert zu %s.
CHAN_SUCCESSOR_UNSET
	Der Eintrag des Vertreters fr%s wurde entfernt.
CHAN_SUCCESSOR_IS_FOUNDER
	%s kann nicht gleichzeitig Grnder und Vertreter im Channel %s sein.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	Sorry, konnte das Passwort nicht ndern.
CHAN_PASSWORD_CHANGED
	%s Passwort wurde gendert.
CHAN_PASSWORD_CHANGED_TO
	%s Passwort wurde gendert zu %s.

# SET DESC responses
CHAN_DESC_CHANGED
	Beschreibung von %s wurde gendert zu %s.

# SET URL responses
CHAN_URL_CHANGED
	URL von %s wurde gendert zu %s.
CHAN_URL_UNSET
	URL von %s wurde entfernt.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	eMail-Adresse von %s wurde gendert in %s.
CHAN_EMAIL_UNSET
	eMail-Adresse von %s wurde entfernt.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	Eintrittsmeldung von %s wurde gendert.
CHAN_ENTRY_MSG_UNSET
	Eintrittsmeldung von %s wurde entfernt.
	
# SET BANTYPE responses
CHAN_SET_BANTYPE_INVALID
	%s ist kein gltiger Ban-Typ.
CHAN_SET_BANTYPE_CHANGED
	Ban-Typ fr den Channel %s ist jetzt #%d.

# SET MLOCK responses
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Unbekanntes Mode-Zeichen: %c wurde ignoriert.
CHAN_SET_MLOCK_IMPOSSIBLE_CHAR
	Mode %c wurde ignoriert, da du diesen Mode nicht festsetzen kannst.
CHAN_SET_MLOCK_L_REQUIRED
	Lock Mode +L setzt das Festsetzen des Modes +l vorraus.
CHAN_SET_MLOCK_K_REQUIRED
	Du musst auch Mode +i festsetzen um Mode +K festsetzen zu knnen.
CHAN_MLOCK_CHANGED
	Mode lock fr Channel %s gendert zu %s.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET channel KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Topic-Wiederherstellung ist jetzt ON.
CHAN_SET_KEEPTOPIC_OFF
	Topic-Wiederherstellung ist jetzt OFF.

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET channel TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Topic-Sperre ist jetzt ON.
CHAN_SET_TOPICLOCK_OFF
	Topic-Sperre ist jetzt OFF.

# SET PRIVATE responses
CHAN_SET_PEACE_SYNTAX
	SET channel PEACE {ON | OFF}
CHAN_SET_PEACE_ON
	Peace-Modus ist nun ON.
CHAN_SET_PEACE_OFF
	Peace-Modus ist nun OFF.

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET channel PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Privat-Modus ist nun ON.
CHAN_SET_PRIVATE_OFF
	Privat-Modus ist nun OFF.

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET channel SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Op-Sicherheit ist jetzt ON.
CHAN_SET_SECUREOPS_OFF
	Op-Sicherheit ist jetzt OFF.
	
# SET SECUREFOUNDER responses
CHAN_SET_SECUREFOUNDER_SYNTAX
	SET channel SECUREFOUNDER {ON | OFF}
CHAN_SET_SECUREFOUNDER_ON
	Secure-Founder-Option ist jetzt ON.
CHAN_SET_SECUREFOUNDER_OFF
	Secure-Founder-Option ist jetzt OFF.

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET channel RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Beschrnkter Zugriff ist jetzt ON.
CHAN_SET_RESTRICTED_OFF
	Beschrnkter Zugriff ist jetzt OFF.

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET channel SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	Secure-Option ist jetzt ON.
CHAN_SET_SECURE_OFF
	Secure-Option ist jetzt OFF.
	
# SET SIGNKICK responses
CHAN_SET_SIGNKICK_SYNTAX
	SET channel SIGNKICK {ON | LEVEL | OFF}
CHAN_SET_SIGNKICK_ON
	Signierte Kicks sind jetzt ON.
CHAN_SET_SIGNKICK_LEVEL
	Signierte Kicks sind jetzt ON, hngt aber vom Zugriffslevel des Users ab.
CHAN_SET_SIGNKICK_OFF
	Signierte Kicks sind jetzt OFF.

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET channel OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Op-Notice ist jetzt ON.
CHAN_SET_OPNOTICE_OFF
	Op-Notice ist jetzt OFF.

# SET NOEXPIRE responses
CHAN_SET_XOP_SYNTAX
	SET channel XOP {ON | OFF}
CHAN_SET_XOP_ON
	xOP-list-System ist nun ON.
CHAN_SET_XOP_OFF
	xOP-list-System is nun OFF.

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET channel NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	Channel %s wird nicht mehr auslaufen.
CHAN_SET_NOEXPIRE_OFF
	Channel %s wird nach einer bestimmten Zeit auslaufen.

# xOP messages
CHAN_XOP_REACHED_LIMIT
	Sorry, du kannst maximal %d AOP/SOP/VOP Eintrge in einem Channel haben.
CHAN_XOP_LIST_FORMAT
	  %3d  %s
CHAN_XOP_ACCESS
	Du kannst diesen Befehl nicht benutzen. Benutze Stattdessen ACCESS.
	Tippe /msg %s HELP ACCESS fr weitere Informationen.

# AOP messages
CHAN_AOP_SYNTAX
	AOP channel {ADD|DEL|LIST|CLEAR} [nick | entry-list]
CHAN_AOP_DISABLED
	Sorry, die Channel AOP Liste kann derzeit nicht gendert werden.
CHAN_AOP_NICKS_ONLY
	Die Channel AOP Liste darf nur registrierte Nicks enthalten.
CHAN_AOP_ADDED
	%s wurde der %s AOP Liste hinzugefgt.
CHAN_AOP_MOVED
	%s wurde auf die %s AOP Liste verschoben.
CHAN_AOP_NO_SUCH_ENTRY
	Kein solcher Eintrag (#%d) in der %s AOP Liste.
CHAN_AOP_NOT_FOUND
	%s wurde nicht in der %s AOP Liste gefunden.
CHAN_AOP_NO_MATCH
	Keine passenden Eintrge in der %s AOP Liste.
CHAN_AOP_DELETED
	%s gelscht von der %s AOP Liste.
CHAN_AOP_DELETED_ONE
	1 Eintrag wurde von der %s AOP Liste gelscht.
CHAN_AOP_DELETED_SEVERAL
	%d Eintrge wurden von der %s AOP Liste gelscht.
CHAN_AOP_LIST_EMPTY
	Die %s AOP Liste ist leer.
CHAN_AOP_LIST_HEADER
	AOP Liste fr %s:
	  Num  Nick
CHAN_AOP_CLEAR
	Die Channel AOP Liste wurde geleert.

# HOP messages
CHAN_HOP_SYNTAX
	HOP channel {ADD|DEL|LIST|CLEAR} [nick | entry-list]
CHAN_HOP_DISABLED
	Sorry, die Channel HOP kann derzeit nicht gendert werden.
CHAN_HOP_NICKS_ONLY
	Die Channel HOP Liste darf nur registrierte Nicks enthalten.
CHAN_HOP_ADDED
	%s wurde der %s HOP Liste hinzugefgt.
CHAN_HOP_MOVED
	%s wurde auf die %s HOP Liste verschoben.
CHAN_HOP_NO_SUCH_ENTRY
	Kein solcher Eintrag (#%d) in der %s HOP Liste.
CHAN_HOP_NOT_FOUND
	%s wurde nicht gefunden in der %s HOP Liste.
CHAN_HOP_NO_MATCH
	Keine passenden Eintrge in der %s HOP Liste.
CHAN_HOP_DELETED
	%s wurde gelscht von der %s HOP Liste.
CHAN_HOP_DELETED_ONE
	1 Eintrag wurde von der %s HOP Liste gelscht.
CHAN_HOP_DELETED_SEVERAL
	%d Eintrge wurdenvon der %s HOP Liste gelscht.
CHAN_HOP_LIST_EMPTY
	Die %s HOP Liste ist leer.
CHAN_HOP_LIST_HEADER
	HOP Liste fr %s:
	  Num  Nick
CHAN_HOP_CLEAR
	Die Channel HOP Liste wurde geleert.

# SOP messages
CHAN_SOP_SYNTAX
	SOP channel {ADD|DEL|LIST|CLEAR} [nick | entry-list]
CHAN_SOP_DISABLED
	Sorry, die Channel SOP Liste kann derzeit nicht gendert werden.
CHAN_SOP_NICKS_ONLY
	Die Channel SOP Liste darf nur registrierte Nicks enthalten.
CHAN_SOP_ADDED
	%s wurde der %s SOP Liste hinzugefgt.
CHAN_SOP_MOVED
	%s wurde auf %s SOP Liste verschoben.
CHAN_SOP_NO_SUCH_ENTRY
	Kein solcher Eintrag (#%d) in der %s SOP Liste.
CHAN_SOP_NOT_FOUND
	%s wurde nicht gefunden in der %s SOP Liste.
CHAN_SOP_NO_MATCH
	Keine passenden Eintrge in der %s SOP Liste.
CHAN_SOP_DELETED
	%s wurde von der %s SOP Liste gelscht.
CHAN_SOP_DELETED_ONE
	1 Eintrag wurde von der %s SOP Liste gelscht.
CHAN_SOP_DELETED_SEVERAL
	%d Eintrge wurden von der %s SOP Liste gelscht.
CHAN_SOP_LIST_EMPTY
	Die %s SOP Liste ist leer.
CHAN_SOP_LIST_HEADER
	SOP Liste fr %s:
	  Num  Nick
CHAN_SOP_CLEAR
	Die Channel SOP Liste wurde geleert.

# VOP messages
CHAN_VOP_SYNTAX
	VOP channel {ADD|DEL|LIST|CLEAR} [nick | entry-list]
CHAN_VOP_DISABLED
	Sorry, die Channel VOP Liste kann derzeit nicht gendert werden.
CHAN_VOP_NICKS_ONLY
	Die Channel VOP Liste darf nur registrierte Nicks enthalten.
CHAN_VOP_ADDED
	%s wurde der %s VOP Liste hinzugefgt.
CHAN_VOP_MOVED
	%s wurde auf die %s VOP Liste verschoben.
CHAN_VOP_NO_SUCH_ENTRY
	Kein solcher Eintrag (#%d) in der %s VOP Liste.
CHAN_VOP_NOT_FOUND
	%s wurde nicht gefunden in der %s VOP Liste.
CHAN_VOP_NO_MATCH
	Keine passenden Eintrge in der %s VOP Liste.
CHAN_VOP_DELETED
	%s wurde gelscht von der %s VOP Liste.
CHAN_VOP_DELETED_ONE
	1 Eintrag wurde von der %s VOP Liste gelscht.
CHAN_VOP_DELETED_SEVERAL
	%d Eintrge wurden von der %s VOP Liste gelscht.
CHAN_VOP_LIST_EMPTY
	Die %s VOP Liste ist leer.
CHAN_VOP_LIST_HEADER
	VOP Liste fr %s:
	  Num  Nick
CHAN_VOP_CLEAR
	Die Channel VOP Liste wurde geleert.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS channel {ADD|DEL|LIST|CLEAR} [nick [level] | entry-list]
CHAN_ACCESS_XOP
	Du kannst dieses Command nicht nutzen. 
	Nutze stattdessen die AOP, SOP und VOP Commands.
	Tippe /msg %s HELP command fr weitere Informationen.
CHAN_ACCESS_DISABLED
	Sorry, das ndern der Channel-Access-Liste wurde zwischenzeitig deaktiviert.
CHAN_ACCESS_LEVEL_NONZERO
	Access-Level muss grsser 0 sein.
CHAN_ACCESS_LEVEL_RANGE
	Access-Level muss zwischen %d und einschliesslich %d liegen.
CHAN_ACCESS_NICKS_ONLY
	Die Channel Access Liste darf nur registrierte Nicks enthalten.
CHAN_ACCESS_REACHED_LIMIT
	Sorry, aber die Access-Liste ist auf %d Eintrge beschrnkt.
CHAN_ACCESS_LEVEL_UNCHANGED
	Access-Level fr %s in %s ist unverndert auf %d.
CHAN_ACCESS_LEVEL_CHANGED
	Access-Level fr %s in %s wurde gendert auf %d.
CHAN_ACCESS_ADDED
	%s wurde zur Access-Liste von %s hinzugefgt mit Level %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	Kein solcher Eintrag (#%d) auf der Access-Liste von %s.
CHAN_ACCESS_NOT_FOUND
	%s wurde auf der Access-Liste von %s nicht gefunden.
CHAN_ACCESS_NO_MATCH
	Es existieren keine entsprechenden Eintrge in der Access-Liste von %s.
CHAN_ACCESS_DELETED
	%s wurde von der Access-Liste von %s entfernt.
CHAN_ACCESS_DELETED_ONE
	1 Eintrag wurde aus der Access-Liste von %s entfernt.
CHAN_ACCESS_DELETED_SEVERAL
	%d Eintrge wurden aus der Access-Liste von %s entfernt.
CHAN_ACCESS_LIST_EMPTY
	Die Access-Liste von %s ist leer.
CHAN_ACCESS_LIST_HEADER
	Access-Liste fr %s:
	  Num   Lev  Nick
CHAN_ACCESS_LIST_FOOTER
	Ende der Access-liste.
CHAN_ACCESS_LIST_XOP_FORMAT
	  %3d   %s  %s
CHAN_ACCESS_LIST_AXS_FORMAT
	  %3d  %4d  %s
CHAN_ACCESS_CLEAR
	Die Access-Liste wurde geleert.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK channel {ADD | DEL | LIST | VIEW | ENFORCE | CLEAR} [nick-or-usermask]
CHAN_AKICK_DISABLED
	Sorry, das Bearbeiten der AutoKick-Liste wurde zwischenzeitlich deaktiviert.
CHAN_AKICK_ALREADY_EXISTS
	%s existiert bereits auf der AutoKick-Liste von %s.
CHAN_AKICK_REACHED_LIMIT
	Sorry, du kannst nur max. %d Eintrge auf der AutoKick-Liste haben.
CHAN_AKICK_ADDED
	%s wurde der AutoKick-Liste von %s hinzugefgt.
CHAN_AKICK_NO_SUCH_ENTRY
	Kein solcher Eintrag (#%d) auf der Autokick-Liste von %s gefunden.
CHAN_AKICK_NOT_FOUND
	%s wurde nicht auf der AutoKick-Liste von %s gefunden.
CHAN_AKICK_NO_MATCH
	Keine entsprechenden Eintrge auf der AutoKick-Liste von %s gefunden.
CHAN_AKICK_STUCK
	%s ist nun stetig aktiviert im %s.
CHAN_AKICK_UNSTUCK
	%s ist nun nicht mehr stetig aktiviert im %s.
CHAN_AKICK_DELETED
	%s wurde von der Autokick-Liste von %s gefunden.
CHAN_AKICK_DELETED_ONE
	1 Eintrag der AutoKick-Liste von %s entfernt.
CHAN_AKICK_DELETED_SEVERAL
	%d Eintrge wurden aus der AutoKick-Liste von %s entfernt.
CHAN_AKICK_LIST_EMPTY
	Die Autokick-Liste von %s ist leer.
CHAN_AKICK_LIST_HEADER
	Autokick-Liste von %s:
CHAN_AKICK_LIST_FORMAT
	  %3d %s%s
CHAN_AKICK_VIEW_FORMAT
	%3d %s (von %s am %s)
	    %s
CHAN_AKICK_VIEW_FORMAT_STUCK
	%3d %s (stuck) (by %s on %s)
	    %s
CHAN_AKICK_ENFORCE_DONE
	AKICK ENFORCE fr %s erledigt; %d user betroffen.
CHAN_AKICK_CLEAR
	Autokick-Liste wurde geleert.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS channel {SET | DIS[ABLE] | LIST | RESET} [item [level]]
CHAN_LEVELS_XOP
	Das Command ist in diesem Modus nutzlos - Deaktiviere zuerst XOP.
CHAN_LEVELS_RANGE
	Der Level kann nur zwischen %d und einschliesslich %d liegen.
CHAN_LEVELS_CHANGED
	Der Level fr %s fr den Channel %s wurde gendert auf %d.
CHAN_LEVELS_UNKNOWN
	Einstellung %s ist unbekannt.  Tippe /msg %s HELP LEVELS DESC fr eine ausfhrliche Einstellungsliste.
CHAN_LEVELS_DISABLED
	%s wurde deaktiviert im Channel %s.
CHAN_LEVELS_LIST_HEADER
	Zugriffslevel fr Channel %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (deaktiviert)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (nur Grnder)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %d
CHAN_LEVELS_RESET
	Zugriffslevel fr %s wurden auf Standardwerte zurckgesetzt.

# INFO responses
CHAN_INFO_SYNTAX
	INFO channel [ALL]
CHAN_INFO_HEADER
	Informationen ber den Channel %s:
CHAN_INFO_FOUNDER
	           Grnder: %s (%s)
CHAN_INFO_NO_FOUNDER
	           Grnder: %s
CHAN_INFO_SUCCESSOR
	         Vertreter: %s (%s)
CHAN_INFO_NO_SUCCESSOR
	         Vertreter: %s
CHAN_INFO_DESCRIPTION
	      Beschreibung: %s
CHAN_INFO_ENTRYMSG
	Eintrittsnachricht: %s
CHAN_INFO_TIME_REGGED
	       Registriert: %s
CHAN_INFO_LAST_USED
	   Zuletzt benutzt: %s
CHAN_INFO_LAST_TOPIC
	     Letztes Topic: %s
CHAN_INFO_TOPIC_SET_BY
	 Topic gesetzt von: %s
CHAN_INFO_URL
	               URL: %s
CHAN_INFO_EMAIL
	     eMail-Adresse: %s
CHAN_INFO_BANTYPE
	           Ban-Typ: %d
CHAN_INFO_OPTIONS
	          Optionen: %s
CHAN_INFO_OPT_KEEPTOPIC
	Topic-Wiederherstellung
CHAN_INFO_OPT_OPNOTICE
	OP Notice
CHAN_INFO_OPT_PEACE
	Peace
CHAN_INFO_OPT_PRIVATE
	Privat
CHAN_INFO_OPT_RESTRICTED
	Restricted Access
CHAN_INFO_OPT_SECURE
	Secure
CHAN_INFO_OPT_SECUREOPS
	Secure Ops
CHAN_INFO_OPT_SECUREFOUNDER
	Secure Founder
CHAN_INFO_OPT_SIGNKICK
	Signierte kicks
CHAN_INFO_OPT_TOPICLOCK
	Topic-Sperre
CHAN_INFO_OPT_XOP
	xOP lists system
CHAN_INFO_OPT_NONE
	Keine
CHAN_INFO_MODE_LOCK
	        Mode lock: %s
CHAN_INFO_NO_EXPIRE
	Dieser Channel wird nicht auslaufen.

# LIST responses
CHAN_LIST_SYNTAX
	LIST pattern
CHAN_LIST_SERVADMIN_SYNTAX
	LIST pattern [FORBIDDEN] [NOEXPIRE]
CHAN_LIST_HEADER
	Liste passender Eintrge zu %s:
CHAN_LIST_FORMAT
	    %-20s  %s
CHAN_LIST_END
	Ende der Liste - %d/%d Treffer gezeigt.
	
# CLIST responses
CHAN_INVITE_SYNTAX
	INVITE channel

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN channel
CHAN_UNBANNED
	Dein Ban in %s wurde entfernt.

# CLEAR responses
CHAN_TOPIC_SYNTAX
	TOPIC channel [topic]

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR channel what
CHAN_CLEARED_BANS
	Alle Bans in %s wurden entfernt.
CHAN_CLEARED_EXCEPTS
	Alle Excepts in %s wurden entfernt.
CHAN_CLEARED_MODES
	Alle Channel-Modes von %s wurden zurckgesetzt.
CHAN_CLEARED_OPS
	Alle Op-Flags wurden im Channel %s entfernt.
CHAN_CLEARED_VOICES
	Alle Voice-Flatgs wurden im Channel %s entfernt.
CHAN_CLEARED_USERS
	Alle User wurden aus Channel %s gekicked.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS channel
CHAN_GETPASS_UNAVAILABLE
	GETPASS Befehl nicht verfgbar, da die Datenbank verschlsselt ist.
CHAN_GETPASS_PASSWORD_IS
	Passwort fr Channel %s ist %s.
	
# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS channel
CHAN_SENDPASS_UNAVAILABLE
	SENDPASS Befehl nicht verfgbar, da die Datenbank verschlsselt ist.
CHAN_SENDPASS_SUBJECT
	Channel-Passwort (%s)
CHAN_SENDPASS_HEAD
	Hi,
CHAN_SENDPASS_LINE_1
	Du hast das Passwortes fr deinen Channel %s angefordert.
CHAN_SENDPASS_LINE_2
	Das Passwort ist %s. Aus Sicherheitsgrnden solltest du das Passwort bei Erhalt dieser Nachricht ndern.
CHAN_SENDPASS_LINE_3
	Wenn du nicht weisst, warum du diese Mail empfangen hast, ignoriere Sie bitte.
CHAN_SENDPASS_LINE_4
	AUF DIESE MAIL BITTE NICHT ANTWORTEN!
CHAN_SENDPASS_LINE_5
	%s, die Administration.
CHAN_SENDPASS_OK
	Passwort von %s wurde per eMail versandt.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID channel [reason]
CHAN_FORBID_SYNTAX_REASON
	FORBID channel reason
CHAN_FORBID_SUCCEEDED
	Channel %s hat jetzt den Status "verboten".
CHAN_FORBID_FAILED
	Konnte den Status "verboten" bei %s nicht setzen!

# Misc responses
CHAN_FORBID_REASON
	Dieser Channel wurde verboten.

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND channel [reason]
CHAN_SUSPEND_SYNTAX_REASON
	SUSPEND channel reason
CHAN_SUSPEND_SUCCEEDED
	Channel %s ist nun auf SUSPENDED gesetzt.
CHAN_SUSPEND_FAILED
	SUSPEND konnte in Channel %s nicht aktiviert werden!
CHAN_SUSPEND_REASON
	Dieser Channel wurde auf SUSPENDED gesetzt.

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND channel
CHAN_UNSUSPEND_ERROR
	Kein # vor dem Channelnamen gefunden.
CHAN_UNSUSPEND_SUCCEEDED
	Channel %s ist nun nicht mehr auf SUSPENDED gesetzt.
CHAN_UNSUSPEND_FAILED
	Channel %s konnte nicht auf UNSUSPENED gesetzt werden!

# Misc responses
CHAN_EXCEPTED
	%s passt zur Exception von %s und kann nicht gebannt werden, solange die Exception nicht gelscht wird.

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	Du hast eine neue Memo.
MEMO_HAVE_NEW_MEMOS
	Du hast %d neue Memos.
MEMO_TYPE_READ_LAST
	Tippe /msg %s READ LAST um sie zu lesen.
MEMO_TYPE_READ_NUM
	Tippe /msg %s READ %d um sie zu lesen.
MEMO_TYPE_LIST_NEW
	Tippe /msg %s LIST NEW um eine Auflistung deiner neuen Memos zu erhalten.
MEMO_AT_LIMIT
	Warnung: Du hast die maximale Anzahl gespeicherter Memos erreicht (%d). Du kannst keine weiteren Nachrichten empfangen, bis du einige deiner jetzigen Memos gelscht hast.
MEMO_OVER_LIMIT
	Warnung: Du hast die maximale Anzahl gespeicherter Memos berschritten (%d). Du kannst keine weiteren Memos empfangen, bis du einige deiner jetzigen Memos gelscht hast.
MEMO_X_MANY_NOTICE
	Es gibt %d benachrichtigungen fr den Channel %s.
MEMO_X_ONE_NOTICE
	Es gibt %d Benachrichtigung fr Channel %s.
MEMO_NEW_X_MEMO_ARRIVED
	Es gibt eine neue Nachricht fr Channel %s.
	Tippe /msg %s READ %s %d um sie zu lesen.
MEMO_NEW_MEMO_ARRIVED
	Du hast eine neue Nachricht von %s empfangen.
	Tippe /msg %s READ %d um sie zu lesen.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	Du hast keine Memos.
MEMO_X_HAS_NO_MEMOS
	%s hat keine Memos.
MEMO_DOES_NOT_EXIST
	Memo %d existiert nicht!
MEMO_LIST_NOT_FOUND
	Keine entsprechenden Memos gefunden.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {nick | channel} memo-text
MEMO_SEND_DISABLED
	Sorry, der Memo-Versand wurde kurzzeitig deaktiviert.
MEMO_SEND_PLEASE_WAIT
	Bitte warte %d Sekunden bis du den SEND Befehl wieder benutzen kannst.
MEMO_X_GETS_NO_MEMOS
	%s kann keine Memos empfangen.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s hat zu viele Memos gespeichert und kann keine weiteren empfangen.
MEMO_SENT
	Memo wurde an %s versandt.
	
# CANCEL responses
MEMO_MASS_SENT
	Ein Massen-Memo wurde an alle regsitrierte User gesendet.
	
# CANCEL responses
MEMO_CANCEL_SYNTAX
	CANCEL {nick | channel}
MEMO_CANCEL_DISABLED
	Sorry, das Widerrufen von Memos wurde deaktiviert.
MEMO_CANCEL_NONE
	Kein Memo konnte widerrufen werden.
MEMO_CANCELLED
	Die letzte Memo an %s wurde widerrufen.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [channel] [list | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	Du hast keine neuen Memos.
MEMO_X_HAS_NO_NEW_MEMOS
	%s hat keine Memos.
MEMO_LIST_MEMOS
	Memos fr %s.  Um sie zu lesen, tippe /msg %s READ num
MEMO_LIST_NEW_MEMOS
	Neue Memos fr %s.  Um sie zu lesen, tippe /msg %s READ num
MEMO_LIST_CHAN_MEMOS
	Memos fr %s.  Um sie zu lesen, tippe /msg %s READ %s num
MEMO_LIST_CHAN_NEW_MEMOS
	Neue Memos fr %s.  Um sie zu lesen, tippe /msg %s READ %s num
MEMO_LIST_HEADER
	 Num  Sender            Datum/Zeit
MEMO_LIST_FORMAT
	%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [channel] {list | LAST | NEW}
MEMO_HEADER
	Memo %d von %s (%s).  Um sie zu lschen, tippe /msg %s DEL %d
MEMO_CHAN_HEADER
	Memo %d von %s (%s).  Um sie zu lschen, tippe /msg %s DEL %s %d
MEMO_TEXT
	%s

# DEL responses
MEMO_DEL_SYNTAX
	DEL [channel] {num | list | ALL}
MEMO_DELETED_NONE
	Es wurden keine Memos gelscht.
MEMO_DELETED_ONE
	Memo %d wurde gelscht.
MEMO_DELETED_SEVERAL
	Memos %s wurden gelscht.
MEMO_DELETED_ALL
	Alle deine Memos wurden gelscht.
MEMO_CHAN_DELETED_ALL
	Alle Memos fr den Channel %s wurden gelscht.

# SET responses
MEMO_SET_SYNTAX
	SET option parameters
MEMO_SET_DISABLED
	Sorry, MEMO SET Befehl wurde kurzzeitig deaktiviert.
MEMO_SET_UNKNOWN_OPTION
	Unbekannte SET Option %s.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s wird dich beim Einloggen ber eingegangene Memos informieren. 
MEMO_SET_NOTIFY_LOGON
	%s wird dich beim Einloggen oder bei der Rckkehr aus /AWAY ber eingegangene Memos informieren.
MEMO_SET_NOTIFY_NEW
	%s wird dich benachrichtigen, sobald neue Memos fr dich eintreffen.
MEMO_SET_NOTIFY_OFF
	%s wird dich nicht lnger beim Eintreffen neuer Memos benachrichtigen.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [channel] limit
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [user | channel] {limit | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	Du hast keine Berechtigung dein Memo-Limit zu ndern.
MEMO_SET_LIMIT_FORBIDDEN
	Du hast keine Berechtigung das Memo-Limit fr %s zu ndern.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	Du kannst dein Memo-Limit nicht hher als %d setzen.
MEMO_SET_LIMIT_TOO_HIGH
	Du kannst das Memo-Limit fr %s nicht hher als %d setzen.
MEMO_SET_LIMIT_OVERFLOW
	Das Memo-Limit ist zu gross, es wird reduziert auf %d.
MEMO_SET_YOUR_LIMIT
	Dein Memo-Limit wurde auf %d gesetzt.
MEMO_SET_YOUR_LIMIT_ZERO
	Du wirst ab sofort keine Memos mehr empfangen knnen.
MEMO_UNSET_YOUR_LIMIT
	Dein Memo-Limit wurde aufgehoben.
MEMO_SET_LIMIT
	Memo-Limit von %s wurde auf %d gesetzt.
MEMO_SET_LIMIT_ZERO
	Memo-Limit von %s wurde auf 0 gesetzt, kein Memo-Empfang fr ihn mehr mglich.
MEMO_UNSET_LIMIT
	Memo-Limit von %s wurde aufgehoben.

# INFO responses
MEMO_INFO_SYNTAX
	INFO [channel]
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [nick | channel]
MEMO_INFO_NO_MEMOS
	Du hast keine Memos.
MEMO_INFO_MEMO
	Du hast eine neue Memo.
MEMO_INFO_MEMO_UNREAD
	Du hast derzeit eine ungelesene Memo.
MEMO_INFO_MEMOS
	Du hast %d Memos.
MEMO_INFO_MEMOS_ONE_UNREAD
	Du hast insgesamt %d Memos, davon ist eine ungelesen.
MEMO_INFO_MEMOS_SOME_UNREAD
	Du hast insgesamt %d Memos, davon sind %d ungelesen.
MEMO_INFO_MEMOS_ALL_UNREAD
	Du hast insgesamt %d Memos; alle davon sind ungelesen.
MEMO_INFO_LIMIT
	Dein Memo-Limit liegt bei %d.
MEMO_INFO_HARD_LIMIT
	Dein Memo-Limit liegt bei %d, und kann nicht gendert werden.
MEMO_INFO_LIMIT_ZERO
	Dein Memo-Limit liegt bei 0; du kannst keine Memos empfangen.
MEMO_INFO_HARD_LIMIT_ZERO
	Dein Memo-Limit liegt bei 0; du kannst keine Memos empfangen. Das Limit kann von dir nicht verndert werden.
MEMO_INFO_NO_LIMIT
	Du hast kein Limit in der Anzahl deiner Memos.
MEMO_INFO_NOTIFY_OFF
	Du wirst nicht benachrichtigt bei neuen Memos.
MEMO_INFO_NOTIFY_ON
	Du wirst bei neuen Memos benachrichtigt, wenn du dich identifizierst bzw wenn sie eintreffen.
MEMO_INFO_NOTIFY_RECEIVE
	Du wirst bei neuen Memos benachrichtigt, wenn sie eintreffen.
MEMO_INFO_NOTIFY_SIGNON
	Du wirst bei neuen Memos benachrichtigt, wenn du dich identifizierst.
MEMO_INFO_X_NO_MEMOS
	%s hat derzeit keine Memos.
MEMO_INFO_X_MEMO
	%s hat derzeit eine Memo.
MEMO_INFO_X_MEMO_UNREAD
	%s hat derzeit eine ungelesene Memo.
MEMO_INFO_X_MEMOS
	%s hat derzeit %d Memos.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s hat derzeit %d Memos, von denen eine ungelesen ist.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s hat derzeit %d Memos, von denen %d ungelesen sind.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s hat derzeit %d Memos; von denen alle ungelesen sind.
MEMO_INFO_X_LIMIT
	%s's Memo-Limit liegt bei %d.
MEMO_INFO_X_HARD_LIMIT
	%s's Memo-Limit liegt bei %d, und kann nicht gendert werden.
MEMO_INFO_X_NO_LIMIT
	%s hat kein Memo-Limit.
MEMO_INFO_X_NOTIFY_OFF
	%s wird bei neuen Memos nicht benachrichtigt.
MEMO_INFO_X_NOTIFY_ON
	%s wird beim Logon und bei Ankunft neuer Memos benachrichtigt.
MEMO_INFO_X_NOTIFY_RECEIVE
	%s wird bei Ankunft neuer Memos benachrichtigt.
MEMO_INFO_X_NOTIFY_SIGNON
	%s wird beim Logon ber neuer Memos benachrichtigt.
	
###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
BOT_DOES_NOT_EXIST
	Bot %s gibt es nicht.
BOT_NOT_ASSIGNED
	Ein Bot muss dem Channel zugewiesen werden, bevor dieser Befehl funktioniert.
	Tippe /msg %S HELP ASSIGN fr weitere Informationen.
BOT_NOT_ON_CHANNEL
	Der Bot ist nicht im Channel %s.
	
# Kick reasons (must be a single line)
BOT_REASON_BADWORD
	Benutze nicht das Wort %s in diesem Channel!
BOT_REASON_BADWORD_GENTLE
	Pass bitte auf was du sagst!
BOT_REASON_BOLD
	Im Channel ist keine fettgedruckte-Schrift erlaubt!
BOT_REASON_CAPS
	Schalte Caps-Lock aus!
BOT_REASON_COLOR
	Keine Farben im Channel benutzen!
BOT_REASON_FLOOD
	Hr auf zu flooden!
BOT_REASON_REPEAT
	Hr auf dich dauernd zu wiederholen!
BOT_REASON_REVERSE
	Nicht invertiert schreiben!
BOT_REASON_UNDERLINE
	Keine Unterstreichungen in diesem Channel benutzen!
	
# !seen replies
BOT_SEEN_BOT
	Hey, du hast mich gefunden %s!
BOT_SEEN_YOU
	Wieder auf der Suche nach dir selbst, %s?
BOT_SEEN_ON_CHANNEL
	%s ist doch im Channel!
BOT_SEEN_ON_CHANNEL_AS
	%s ist derzeit im Channel (als %s)! 
BOT_SEEN_ON
	%s wurde zuletzt vor %s gesehen.
BOT_SEEN_NEVER
	%s hab ich noch nie gesehen.
BOT_SEEN_UNKNOWN
	Ich kenne %s nicht.
	
# BOT responses
BOT_BOT_SYNTAX
	BOT ADD nick user host real
	BOT CHANGE oldnick newnick [user [host [real]]]
	BOT DEL nick
	BOT LIST
BOT_BOT_ALREADY_EXISTS
	Bot %s existiert bereits.
BOT_BOT_CREATION_FAILED
	Sorry, Erstellung des Bots ist fehlgeschlagen.
BOT_BOT_READONLY
	Sorry, das Verndern von Bot-Einstellungen ist derzeit deaktiviert.
BOT_BOT_ADDED
	%s!%s@%s (%s) wurde zur Bot-Liste hinzugefgt.
BOT_BOT_ANY_CHANGES
	Das alten Informationen stimmen mit den neuen berein.
BOT_BOT_CHANGED
	Bot %s wurde gendert auf %s!%s@%s (%s)
BOT_BOT_DELETED
	Bot %s wurde gelscht.
	
# BOTLIST responses
BOT_BOTLIST_HEADER
	Bot-Liste:
BOT_BOTLIST_PRIVATE_HEADER
	Bots reserved to IRC operators:
BOT_BOTLIST_FOOTER
	%d Bots verfgbar.
BOT_BOTLIST_EMPTY
	Es sind derzeit keine Bots verfgbar.
	Frag einen Services Admin, ob er einen erstellt.
	
# ASSIGN responses
BOT_ASSIGN_SYNTAX
	ASSIGN chan nick
BOT_ASSIGN_READONLY
	Sorry, das Zuweisen von Bots ist derzeit deaktiviert.
BOT_ASSIGN_ALREADY
	Bot %s ist bereits dem Channel %s zugewiesen.
BOT_ASSIGN_ASSIGNED
	Bot %s wurde dem Channel %s zugewiesen.
	
# UNASSIGN responses
BOT_UNASSIGN_SYNTAX
	UNASSIGN chan
BOT_UNASSIGN_UNASSIGNED
	Der Bot von %s wurde entfernt.
	
# INFO responses
BOT_INFO_SYNTAX
	INFO {chan | nick}
BOT_INFO_NOT_FOUND
	%s ist kein gltiger Bot bzw. registrierter Channel.
BOT_INFO_BOT_HEADER
	Information vom Bot %s:
BOT_INFO_BOT_MASK
	     Hostmaske: %s@%s
BOT_INFO_BOT_REALNAME
	   Echter Name: %s
BOT_INFO_BOT_CREATED
	      Erstellt: %s
BOT_INFO_BOT_USAGE
	    benutzt in: %d Channel(s)
BOT_INFO_BOT_OPTIONS
	    Options : %s
BOT_INFO_OPT_PRIVATE
	Private
BOT_INFO_CHAN_HEADER
	Information von Channel %s:
BOT_INFO_CHAN_BOT
	           Bot nick : %s
BOT_INFO_CHAN_BOT_NONE
	           Bot nick : noch nicht zugewiesen.
BOT_INFO_CHAN_KICK_BADWORDS
	   Bad words kicker : %s
BOT_INFO_CHAN_KICK_BADWORDS_BAN
	   Bad words kicker : %s (%d Kick(s) bis zum Ban)
BOT_INFO_CHAN_KICK_BOLDS
	       Bolds kicker : %s
BOT_INFO_CHAN_KICK_BOLDS_BAN
	       Bolds kicker : %s (%d Kick(s) bis zum Ban)
BOT_INFO_CHAN_KICK_CAPS_ON
	        Caps kicker : %s (Minimum %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_BAN
	        Caps kicker : %s (%d Kick(s) bis zum Ban; Minimum %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_OFF
	        Caps kicker : %s
BOT_INFO_CHAN_KICK_COLORS
	      Colors kicker : %s
BOT_INFO_CHAN_KICK_COLORS_BAN
	      Colors kicker : %s (%d Kick(s) bis zum Ban)
BOT_INFO_CHAN_KICK_FLOOD_ON
	       Flood kicker : %s (%d Zeilen in %ds)
BOT_INFO_CHAN_KICK_FLOOD_BAN
	       Flood kicker : %s (%d Kick(s) bis zum Ban; %d Zeilen in %ds)
BOT_INFO_CHAN_KICK_FLOOD_OFF
	       Flood kicker : %s
BOT_INFO_CHAN_KICK_REPEAT_ON
	      Repeat kicker : %s (%d Mal)
BOT_INFO_CHAN_KICK_REPEAT_BAN
	      Repeat kicker : %s (%d Kick(s) bis zum Ban; %d Mal)
BOT_INFO_CHAN_KICK_REPEAT_OFF
	      Repeat kicker : %s
BOT_INFO_CHAN_KICK_REVERSES
	    Reverses kicker : %s
BOT_INFO_CHAN_KICK_REVERSES_BAN
	    Reverses kicker : %s (%d Kick(s) bis zum Ban)
BOT_INFO_CHAN_KICK_UNDERLINES
	  Underlines kicker : %s
BOT_INFO_CHAN_KICK_UNDERLINES_BAN
	  Underlines kicker : %s (%d Kick(s) bis zum Ban)
BOT_INFO_ACTIVE
	aktiv
BOT_INFO_INACTIVE
	nicht aktiv
BOT_INFO_CHAN_OPTIONS
	           Optionen : %s
BOT_INFO_OPT_DONTKICKOPS
	Op-Schutz
BOT_INFO_OPT_DONTKICKVOICES
	Voice-Schutz
BOT_INFO_OPT_FANTASY
	Fantasy-Mode
BOT_INFO_OPT_GREET
	Eintrittsmeldung
BOT_INFO_OPT_NOBOT
	Kein Bot
BOT_INFO_OPT_SYMBIOSIS
	Symbiosis
BOT_INFO_OPT_NONE
	Keine
	
# SET responses
BOT_SET_SYNTAX
	SET channel option settings
BOT_SET_DISABLED
	Sorry, die SET-Optionen sind derzeit deaktiviert.
BOT_SET_UNKNOWN
	Unbekannte Option %s.
	Tippe /msg %S HELP SET fr weitere Informationen.
	
# SET DONTKICKOPS messages
BOT_SET_DONTKICKOPS_SYNTAX
	SET channel DONTKICKOPS {ON|OFF}
BOT_SET_DONTKICKOPS_ON
	Bot wird keine Ops kicken im %s.
BOT_SET_DONTKICKOPS_OFF
	Bot wird Ops kicken im %s.
	
# SET DONTKICKVOICES messages
BOT_SET_DONTKICKVOICES_SYNTAX
	SET channel DONTKICKVOICES {ON|OFF}
BOT_SET_DONTKICKVOICES_ON
	Bot wird keine Voices kicken im %s.
BOT_SET_DONTKICKVOICES_OFF
	Bot wird Voices kicken im %s.

# SET FANTASY messages
BOT_SET_FANTASY_SYNTAX
	SET channel FANTASY {ON|OFF}
BOT_SET_FANTASY_ON
	Fantasy mode ist jetzt ON im %s.
BOT_SET_FANTASY_OFF
	Fantasy mode ist jetzt OFF im %s.
	
# SET GREET messages
BOT_SET_GREET_SYNTAX
	SET channel GREET {ON|OFF}
BOT_SET_GREET_ON
	Eintrittsmeldung ist jetzt ON im %s.
BOT_SET_GREET_OFF
	Eintrittsmeldung ist jetzt OFF im %s.
	
# SET NOBOT
BOT_SET_NOBOT_SYNTAX
	SET botname NOBOT {ON|OFF}
BOT_SET_NOBOT_ON
	No-Bot-Mode ist jetzt ON im Channel %s.
BOT_SET_NOBOT_OFF
	No-Bot-Mode ist jetzt OFF im Channel %s.
	
# SET SYMBIOSIS
BOT_SET_PRIVATE_SYNTAX
	SET botname PRIVATE {ON|OFF}
BOT_SET_PRIVATE_ON
	Private-Mode des Bots im %s ist nun ON.
BOT_SET_PRIVATE_OFF
	Private-Mode des Bots im %s ist nun OFF.

# SET SYMBIOSIS
BOT_SET_SYMBIOSIS_SYNTAX
	SET channel SYMBIOSIS {ON|OFF}
BOT_SET_SYMBIOSIS_ON
	Symbiosis-Mode ist jetzt ON im %s.
BOT_SET_SYMBIOSIS_OFF
	Symbiosis-Mode ist jetzt OFF im %s.
	
# KICK responses
BOT_KICK_SYNTAX
	KICK channel option {ON|OFF} [settings]
BOT_KICK_DISABLED
	Sorry, die Konfiguration des Kickers ist derzeit deaktiviert.
BOT_KICK_UNKNOWN
	Unbekannte Option %s.
	Tippe /msg %S HELP KICK fr weitere Informationen.
BOT_KICK_BAD_TTB
	%s ist eine ungltige Ban-Zeit.

BOT_KICK_BADWORDS_ON
	Bot wird jetzt auf bad words achten und kicken. Benutze den BADWORDS
	Befehl um Wrter zur Liste hinzuzufgen oder zu entfernen.

BOT_KICK_BADWORDS_ON_BAN
	Bot wird jetzt auf bad words achten und einen Ban setzen
	nach %d kicks. Benutze den BADWORDS Befehl um Wrter zur Liste
	hinzuzufgen oder zu entfernen.

BOT_KICK_BADWORDS_OFF
	bad word Kick ist jetzt deaktiviert.
BOT_KICK_BOLDS_ON
	Bot kickt jetzt Leute, die fett schreiben.
BOT_KICK_BOLDS_ON_BAN
	Bot kickt jetzt Leute, die fett schreiben und setzt einen Ban nach
	%d Kicks des Users.
BOT_KICK_BOLDS_OFF
	bold Kick ist jetzt deaktiviert.
BOT_KICK_CAPS_ON
	Bot wird jetzt User mit GROSSSCHRIFT kicken (es mssen allerdings
	%d Zeichen und %d%% der gesamten Nachricht sein).
BOT_KICK_CAPS_ON_BAN
	Bot wird jetzt User mit GROSSSCHRIFT kicken (es mssen allerdings
	%d Zeichen und %d%% der gesamten Nachricht sein), und wird nach %d Kicks
	einen Ban setzen.
BOT_KICK_CAPS_OFF
	Der Bot wird GROSSSCHRIFT ignorieren und nicht kicken.
BOT_KICK_COLORS_ON
	Bot kickt jetzt Leute, die farbig schreiben.
BOT_KICK_COLORS_ON_BAN
	Bot kickt jetzt Leute, die farbig schreiben, und wird einen Ban nach
	%d Kicks setzen.
BOT_KICK_COLORS_OFF
	Bot wird jetzt farbige Schrift ignorieren und nicht kicken.
BOT_KICK_FLOOD_ON
	Bot wird jetzt Flooder kicken (%d Zeilen in %d Sekunden).
BOT_KICK_FLOOD_ON_BAN
	Bot wird jetzt Flooder kicken (%d Zeilen in %d Sekunden), und wird einen
	Ban setzen nach %d Kicks.
BOT_KICK_FLOOD_OFF
	Bot wird jetzt Flooder ignorieren und nicht kicken.
BOT_KICK_REPEAT_ON
	Bot kickt jetzt Leute die sich wiederholen ( %d Mal das Gleiche)
BOT_KICK_REPEAT_ON_BAN
	Bot kickt jetzt Leute die sich wiederholen ( %d Mal das Gleiche), und setzt
	einen Ban nach %d Kicks.
BOT_KICK_REPEAT_OFF
	Bot ignoriert jetzt jetzt Leute die sich wiederholen und wird nicht kicken.
BOT_KICK_REVERSES_ON
	Bot kickt Leute, die invertiert schreiben.
BOT_KICK_REVERSES_ON_BAN
	Bot kickt Leute, die invertiert schreiben, und setzt einen Ban nach %d
	Kicks.
BOT_KICK_REVERSES_OFF
	Bot wird jetzt invertierten Schriftstil ignorieren und nicht kicken.
BOT_KICK_UNDERLINES_ON
	Bot kickt jetzt Leute, die unterstrichen schreiben.
BOT_KICK_UNDERLINES_ON_BAN
	Bot kickt jetzt Leute, die unterstrichen schreiben, und setzt einen Ban 
	nach %d Kicks.
BOT_KICK_UNDERLINES_OFF
	Bot wird jetzt unterstrichenen Text ignorieren und nicht kicken.
	
# BADWORDS messages
BOT_BADWORDS_SYNTAX
	BADWORDS channel {ADD|DEL|LIST|CLEAR} [word | entry-list] [SINGLE|START|END]
BOT_BADWORDS_DISABLED
	Sorry, das ndern der Bad Words-Liste ist derzeit deaktiviert.
BOT_BADWORDS_REACHED_LIMIT
	Sorry, du kannst nur %d Eintrge in der Bad Words-Liste eines Channels haben.
BOT_BADWORDS_ALREADY_EXISTS
	%s existiert bereits in der Bad Words-Liste von %s.
BOT_BADWORDS_ADDED
	%s zur Bad Words-Liste von %s hinzugefgt.
BOT_BADWORDS_NO_SUCH_ENTRY
	Kein solcher Eintrag (#%d) wurde in der Bad Words-Liste von %s gefunden.
BOT_BADWORDS_NOT_FOUND
	%s nicht in der Bad Words-Liste von %s gefunden.
BOT_BADWORDS_NO_MATCH
	Keine entsprechenden Eintrge zu %s in der Bad Words-Liste gefunden.
BOT_BADWORDS_DELETED
	%s wurde aus der Bad Words-Liste von %s entfernt.
BOT_BADWORDS_DELETED_ONE
	1 Eintrag wurde aus der Bad Words-Liste von %s entfernt.
BOT_BADWORDS_DELETED_SEVERAL
	%d Eintrge wurden aus der Bad Words-Liste von %s entfernt.
BOT_BADWORDS_LIST_EMPTY
	Die Bad Words-Liste von %s ist leer.
BOT_BADWORDS_LIST_HEADER
	Bad Words-Liste von %s:
	  Num   Wort                           Typ
BOT_BADWORDS_LIST_FORMAT
	  %3d   %-30s %s
BOT_BADWORDS_CLEAR
	Die Bad Words-Liste ist jetzt leer.

# SAY responses
BOT_SAY_SYNTAX
	SAY channel text

# ACT responses
BOT_ACT_SYNTAX
	ACT channel text

# Errors
BOT_EXCEPT
	User stimmt mit Channel Exception berein.

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
BOT_BAD_NICK
	Bot Nicks drfen nur gltige Zeichen enthalten.
BOT_BAD_HOST
	Bot Hosts drfen nur gltige Zeichen enthalten.
BOT_BAD_IDENT
	Bot Idents drfen nur gltige Zeichen enthalten.
###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	Services knnen die Modes nicht ndern. Ist der Server richtig konfiguriert?
OPER_BOUNCY_MODES_U_LINE
	Services knnen die Modes nicht ndern. Sind die U:lines des
	Servers richtig konfiguriert?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL Nachricht

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Unbekannte STATS Option %s.
OPER_STATS_CURRENT_USERS
	Derzeit eingeloggte User: %d (%d Oper)
OPER_STATS_MAX_USERS
	                 Maximum: %d (%s)

# This is ugly, but at least it's language-portable...
# Note that you can include seconds in any of these--my personal preference
# is to only give resolution to the nearest minute when uptime is one hour
# or more, but just add a %d to get seconds as well.
OPER_STATS_UPTIME_DHMS
	Services laufen seit %d Tagen, %02d:%02d
OPER_STATS_UPTIME_1DHMS
	Services laufen seit %d Tag, %02d:%02d
OPER_STATS_UPTIME_HMS
	Services laufen seit %d Stunden, %d Minuten
OPER_STATS_UPTIME_HM1S
	Services laufen seit %d Stunden, %d Minuten
OPER_STATS_UPTIME_H1MS
	Services laufen seit %d Stunden, %d Minute
OPER_STATS_UPTIME_H1M1S
	Services laufen seit %d Stunden, %d Minute
OPER_STATS_UPTIME_1HMS
	Services laufen seit %d Stunde, %d Minuten
OPER_STATS_UPTIME_1HM1S
	Services laufen seit %d Stunde, %d Minuten
OPER_STATS_UPTIME_1H1MS
	Services laufen seit %d Stunde, %d Minute
OPER_STATS_UPTIME_1H1M1S
	Services laufen seit %d Stunde, %d Minute
OPER_STATS_UPTIME_MS
	Services laufen seit %d Minuten, %d Sekunden
OPER_STATS_UPTIME_M1S
	Services laufen seit %d Minuten, %d Sekunde
OPER_STATS_UPTIME_1MS
	Services laufen seit %d Minute, %d Sekunden
OPER_STATS_UPTIME_1M1S
	Services laufen seit %d Minute, %d Sekunde
OPER_STATS_BYTES_READ
	Bytes gelesen     : %5d kB
OPER_STATS_BYTES_WRITTEN
	Bytes geschrieben : %5d kB
OPER_STATS_USER_MEM
	User              : %6d Eintrge, %5d kB
OPER_STATS_CHANNEL_MEM
	Channel           : %6d Eintrge, %5d kB
OPER_STATS_GROUPS_MEM
	NickServ-Gruppen  : %6d Eintrge, %5d kB
OPER_STATS_ALIASES_MEM
	NickServ-Aliase   : %6d Eintrge, %5d kB
OPER_STATS_CHANSERV_MEM
	ChanServ          : %6d Eintrge, %5d kB
OPER_STATS_BOTSERV_MEM
	BotServ           : %6d Eintrge, %5d kB
OPER_STATS_OPERSERV_MEM
	OperServ          : %6d Eintrge, %5d kB
OPER_STATS_SESSIONS_MEM
	Verbindungen      : %6d Eintrge, %5d kB
OPER_STATS_PROXY_MEM
	Proxies       : %6d records, %5d kB
OPER_STATS_AKILL_COUNT
	Aktuelle Anzahl von AKILLs: %d
OPER_STATS_AKILL_EXPIRE_DAYS
	Standard Auslaufzeit von AKILLs: %d Tage
OPER_STATS_AKILL_EXPIRE_DAY
	Standard Auslaufzeit von AKILLs: 1 Tag
OPER_STATS_AKILL_EXPIRE_HOURS
	Standard Auslaufzeit von AKILLs: %d Stunden
OPER_STATS_AKILL_EXPIRE_HOUR
	Standard Auslaufzeit von AKILLs: 1 Stunde
OPER_STATS_AKILL_EXPIRE_MINS
	Standard Auslaufzeit von AKILLs: %d Minuten
OPER_STATS_AKILL_EXPIRE_MIN
	Standard Auslaufzeit von AKILLs: 1 Minute
OPER_STATS_AKILL_EXPIRE_NONE
	Standard Auslaufzeit von AKILLs: Kein Auslauf, permanent
OPER_STATS_SGLINE_COUNT
	Aktuelle Anzahl von SGLINEs: %d
OPER_STATS_SGLINE_EXPIRE_DAYS
	Standard Auslaufzeit von SGLINEs: %d Tage
OPER_STATS_SGLINE_EXPIRE_DAY
	Standard Auslaufzeit von SGLINEs: 1 Tag
OPER_STATS_SGLINE_EXPIRE_HOURS
	Standard Auslaufzeit von SGLINEs: %d Stunden
OPER_STATS_SGLINE_EXPIRE_HOUR
	Standard Auslaufzeit von SGLINEs: 1 Stunde
OPER_STATS_SGLINE_EXPIRE_MINS
	Standard Auslaufzeit von SGLINEs: %d Minuten
OPER_STATS_SGLINE_EXPIRE_MIN
	Standard Auslaufzeit von SGLINEs: 1 Minute
OPER_STATS_SGLINE_EXPIRE_NONE
	Standard Auslaufzeit von SGLINEs: Kein Auslauf, permanent
OPER_STATS_SQLINE_COUNT
	Aktuelle Anzahl von SQLINEs: %d
OPER_STATS_SQLINE_EXPIRE_DAYS
	Standard Auslaufzeit von SQLINEs: %d days
OPER_STATS_SQLINE_EXPIRE_DAY
	Standard Auslaufzeit von SQLINEs: 1 day
OPER_STATS_SQLINE_EXPIRE_HOURS
	Standard Auslaufzeit von SQLINEs: %d hours
OPER_STATS_SQLINE_EXPIRE_HOUR
	Standard Auslaufzeit von SQLINEs: 1 hour
OPER_STATS_SQLINE_EXPIRE_MINS
	Standard Auslaufzeit von SQLINEs: %d minutes
OPER_STATS_SQLINE_EXPIRE_MIN
	Standard Auslaufzeit von SQLINEs: 1 minute
OPER_STATS_SQLINE_EXPIRE_NONE
	Standard Auslaufzeit von SQLINEs: No expiration
OPER_STATS_SZLINE_COUNT
	Aktuelle Anzahl von SZLINEs: %d
OPER_STATS_SZLINE_EXPIRE_DAYS
	Standard Auslaufzeit von SZLINEs: %d Tage
OPER_STATS_SZLINE_EXPIRE_DAY
	Standard Auslaufzeit von SZLINEs: 1 Tag
OPER_STATS_SZLINE_EXPIRE_HOURS
	Standard Auslaufzeit von SZLINEs: %d Stunden
OPER_STATS_SZLINE_EXPIRE_HOUR
	Standard Auslaufzeit von SZLINEs: 1 Stunde
OPER_STATS_SZLINE_EXPIRE_MINS
	Standard Auslaufzeit von SZLINEs: %d Minuten
OPER_STATS_SZLINE_EXPIRE_MIN
	Standard Auslaufzeit von SZLINEs: 1 Minute
OPER_STATS_SZLINE_EXPIRE_NONE
	Standard Auslaufzeit von SZLINEs: Kein Auslauf, permanent
OPER_STATS_RESET
	Statistiken zurckgesetzt.

# MODE responses
OPER_MODE_SYNTAX
	MODE channel modes

# UMODE respondes
OPER_UMODE_SYNTAX
	UMODE nick modes

# UMODE responses
OPER_UMODE_SUCCESS
	Usermodes von %s gendert.
OPER_UMODE_CHANGED
	%s hat deine Usermodes gendert.

# OLINE responses
OPER_OLINE_SYNTAX
	OLINE nick flags
OPER_OLINE_SUCCESS
	Operflags %s wurden fr %s hinzugefgt. 
OPER_OLINE_IRCOP
	Du bist nun ein IRC Operator.

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES channel [ALL]
OPER_CLEARMODES_DONE
	Alle binren Modes und Bans wurden aus dem Channel %s entfernt.
OPER_CLEARMODES_ALL_DONE
	Alle Modes wurden vom Channel %s zurckgesetzt.


# KICK responses
OPER_KICK_SYNTAX
	KICK channel user reason
	
# ADMIN responses
OPER_SVSNICK_SYNTAX
	SVSNICK nick newnick 
OPER_SVSNICK_NEWNICK
	The nick %s is now being changed to %s.
	
# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD|DEL|LIST|CLEAR} [nick | entry-list]
OPER_ADMIN_SKELETON
	Services sind im Basis-Modus; das ADMIN-Kommando ist nicht verfgbar.	
OPER_ADMIN_EXISTS
	%s existiert bereits auf der Services Admin-Liste.
OPER_ADMIN_REACHED_LIMIT
	Sorry, du kannst nur %d Services Admins haben.
OPER_ADMIN_ADDED
	%s wurde zur Liste der Services Admins hinzugefgt.
OPER_ADMIN_NOT_FOUND
	%s wurde nicht auf der Liste der Services Admins gefunden.
OPER_ADMIN_NO_MATCH
	Keine entsprechenden Eintrge auf der Liste der Services Admins gefunden.
OPER_ADMIN_DELETED
	%s wurde aus der Liste der Services Admins entfernt.
OPER_ADMIN_DELETED_ONE
	Es wurde 1 Eintrag aus der Liste der Services Admins entfernt.
OPER_ADMIN_DELETED_SEVERAL
	Es wurden %d Eintrge aus der Liste der Services Admins entfernt.
OPER_ADMIN_LIST_EMPTY
	Services Admin-Liste ist leer.
OPER_ADMIN_LIST_HEADER
	Services Admin-Liste:
	  Num   Nick
OPER_ADMIN_LIST_FORMAT
	  %3d   %s
OPER_ADMIN_CLEAR
	Die Liste der Services Admins wurde geleert.

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD|DEL|LIST|CLEAR} [nick | entry-list]
OPER_OPER_SKELETON
	Services sind im Basis-Modus; das OPER-Kommando ist nicht verfgbar.
OPER_OPER_EXISTS
	%s existiert bereits auf der Services Operatoren-Liste.
OPER_OPER_REACHED_LIMIT
	Sorry, du kannst nur %d Services Operatoren haben.
OPER_OPER_ADDED
	%s wurde zur Liste der Services Operatoren hinzugefgt.
OPER_OPER_NOT_FOUND
	%s wurde nicht auf der Liste der Services Operatoren gefunden.
OPER_OPER_NO_MATCH
	Keine entsprechenden Eintrge auf der Liste der Services Operatoren gefunden.
OPER_OPER_DELETED
	%s wurde aus der Liste der Services Operatoren entfernt.
OPER_OPER_DELETED_ONE
	Es wurde 1 Eintrag aus der Liste der Services Operatoren entfernt.
OPER_OPER_DELETED_SEVERAL
	Es wurden %d Eintrge aus der Liste der Services Operatoren entfernt.
OPER_OPER_LIST_EMPTY
	Die Services Operatoren-Liste ist leer.
OPER_OPER_LIST_HEADER
	Liste der Services Operatoren:
	  Num   Nick
OPER_OPER_LIST_FORMAT
	  %3d   %s
OPER_OPER_CLEAR
	Die Liste der Services Operatoren wurde geleert.

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | CLEAR} [[+expiry] {mask | entry-list} [reason]]
OPER_AKILL_EXISTS
	%s existiert bereits auf der AKILL-Liste.
OPER_AKILL_ALREADY_COVERED
	%s wird bereits von %s getroffen.
OPER_AKILL_REACHED_LIMIT
	Sorry, du kannst nur %d AKILLs haben.
OPER_AKILL_NO_NICK
	Achtung: AKILL-Masken drfen keine Nicknamen enthalten; stelle sicher, dass du keinen in der Hostmaske eingetragen hast.
OPER_AKILL_ADDED
	%s wurde zur AKILL-Liste hinzugefgt.
OPER_AKILL_CHANGED
	Auslaufzeit von %s gendert.
OPER_AKILL_NOT_FOUND
	%s wurde nicht auf der AKILL-Liste gefunden.
OPER_AKILL_NO_MATCH
	Keine entsprechenden Eintrge auf der AKILL-Liste.
OPER_AKILL_DELETED
	%s wurde von der AKILL-Liste entfernt.
OPER_AKILL_DELETED_ONE
	Es wurde 1 Eintrag von der AKILL-Liste entfernt.
OPER_AKILL_DELETED_SEVERAL
	Es wurden %d Eintrge von der AKILL-Liste entfernt.
OPER_AKILL_LIST_EMPTY
	Die AKILL-Liste ist leer.
OPER_AKILL_LIST_HEADER
	Aktuelle AKILL-Liste:
	  Num   Maske                             Grund
OPER_AKILL_LIST_FORMAT
	  %3d   %-32s  %s
OPER_AKILL_VIEW_HEADER
	Aktuelle AKILL-Liste:
# number, mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_FORMAT
	%3d  %s (von %s am %s; %s)
	      %s
OPER_AKILL_CLEAR
	Die AKILL-Liste wurde geleert.
	
# SGLINE responses
OPER_CHANKILL_SYNTAX
	CHANAKILL [+expiry] {#channel} [reason]
# SGLINE responses
OPER_SGLINE_SYNTAX
	SGLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+expiry] {mask | entry-list}[:reason]]
OPER_SGLINE_UNSUPPORTED
	Sorry, SGLINE ist in diesem Netz nicht verfgbar.
OPER_SGLINE_EXISTS
	%s existiert bereits auf der SGLINE-Liste.
OPER_SGLINE_ALREADY_COVERED
	%s wird bereits durch %s getroffen.
OPER_SGLINE_REACHED_LIMIT
	Sorry, du kannst nur %d SGLINEs haben.
OPER_SGLINE_ADDED
	%s wurde zur SGLINE-Liste hinzugefgt.
OPER_SGLINE_CHANGED
	Auslaufzeit von %s gendert.
OPER_SGLINE_NOT_FOUND
	%s wurde nicht auf der SGLINE-Liste gefunden.
OPER_SGLINE_NO_MATCH
	Keine entsprechenden Eintrge auf der SGLINE-Liste.
OPER_SGLINE_DELETED
	%s wurde von der SGLINE-Liste entfernt.
OPER_SGLINE_DELETED_ONE
	Es wurde 1 Eintrag aus der SGLINE-Liste entfernt.
OPER_SGLINE_DELETED_SEVERAL
	Es wurden %d Eintrge aus der SGLINE-Liste entfernt.
OPER_SGLINE_LIST_EMPTY
	Die SGLINE-Liste ist leer.
OPER_SGLINE_LIST_HEADER
	Aktuelle SGLINE-Liste:
	  Num   Maske                             Grund
OPER_SGLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SGLINE_VIEW_HEADER
	Aktuelle SGLINE-Liste:
# number, mask, set-by, set-time, expires, reason
OPER_SGLINE_VIEW_FORMAT
	%3d  %s (von %s am %s; %s)
	      %s
OPER_SGLINE_CLEAR
	Die SGLINE-Liste wurde geleert.

# SZLINE responses
OPER_SQLINE_SYNTAX
	SQLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+expiry] {mask | entry-list} [reason]]
OPER_SQLINE_CHANNELS_UNSUPPORTED
	Channel SQLINEs werden nicht von deinem IRCd untersttzt, folglich kannst du sie nicht nutzen.
OPER_SQLINE_EXISTS
	%s existiert bereits in der SQLINE Liste.
OPER_SQLINE_ALREADY_COVERED
	%s wird bereits durch %s getroffen.
OPER_SQLINE_REACHED_LIMIT
	Sorry, du kannst nur %d SQLINEs haben.
OPER_SQLINE_ADDED
	%s wurde zur SQLINE-Liste hinzugefgt.
OPER_SQLINE_CHANGED
	Auslaufzeit von %s gendert.
OPER_SQLINE_NOT_FOUND
	%s wurde nicht auf der SQLINE-Liste gefunden.
OPER_SQLINE_NO_MATCH
	Keine entsprechenden Eintrge auf der SQLINE-Liste.
OPER_SQLINE_DELETED
	%s wurde von der SQLINE-Liste entfernt.
OPER_SQLINE_DELETED_ONE
	Es wurde 1 Eintrag aus der SQLINE-Liste entfernt.
OPER_SQLINE_DELETED_SEVERAL
	Es wurden %d Eintrge aus der SQLINE-Liste entfernt.
OPER_SQLINE_LIST_EMPTY
	SQLINE Liste ist leer.
OPER_SQLINE_LIST_HEADER
	Aktuelle SQLINE Liste:
	  Num   Mask                              Reason
OPER_SQLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SQLINE_VIEW_HEADER
	Aktuelle SQLINE Liste:
# number, mask, set-by, set-time, expires, reason
OPER_SQLINE_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_SQLINE_CLEAR
	Die SQLINE-Liste wurde geleert.

# SZLINE responses
OPER_SZLINE_SYNTAX
	SZLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+expiry] {mask | entry-list} [reason]]
OPER_SZLINE_UNSUPPORTED
	Sorry, SZLINE ist in diesem Netz nicht verfgbar.
OPER_SZLINE_EXISTS
	%s existiert bereits auf der SZLINE-Liste.
OPER_SZLINE_ALREADY_COVERED
	%s wird bereits durch %s getroffen.
OPER_SZLINE_REACHED_LIMIT
	Sorry, du kannst nur %d SZLINEs haben.
OPER_SZLINE_ONLY_IPS
	Achtung: Man kann nur IP-Masken zur SZLINE-Liste hinzufgen.
OPER_SZLINE_ADDED
	%s wurde zur SZLINE-Liste hinzugefgt.
OPER_SZLINE_CHANGED
	Auslaufzeit von %s gendert.
OPER_SZLINE_NOT_FOUND
	%s wurde nicht auf der SZLINE-Liste gefunden.
OPER_SZLINE_NO_MATCH
	Kein entsprechender Eintrag in der SZLINE-Liste gefunden.
OPER_SZLINE_DELETED
	%s wurde von der SZLINE-Liste entfernt.
OPER_SZLINE_DELETED_ONE
	Es wurde 1 Eintrag aus der SZLINE-Liste entfernt.
OPER_SZLINE_DELETED_SEVERAL
	Es wurden %d Eintrge aus der SZLINE-Liste entfernt.
OPER_SZLINE_LIST_EMPTY
	Die SZLINE-Liste ist leer.
OPER_SZLINE_LIST_HEADER
	Aktuelle SZLINE-Liste:
	  Num   Maske                             Grund
OPER_SZLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SZLINE_VIEW_HEADER
	Aktuelle SZLINE-Liste:
# number, mask, set-by, set-time, expires, reason
OPER_SZLINE_VIEW_FORMAT
	%3d  %s (von %s am %s; %s)
	      %s
OPER_SZLINE_CLEAR
	Die SZLINE-Liste wurde geleert.

# SET responses
OPER_SET_SYNTAX
	SET option setting
OPER_SET_IGNORE_ON
	Ignore code wird benutzt.
OPER_SET_IGNORE_OFF
	Ignore code wird nicht benutzt.
OPER_SET_IGNORE_ERROR
	Die Einstellung von IGNORE kann nur ON oder OFF sein.
OPER_SET_READONLY_ON
	Services sind jetzt im read-only Modus.
OPER_SET_READONLY_OFF
	Services sind jetzt im read-write Modus.
OPER_SET_READONLY_ERROR
	Der Wert fr READONLY muss entweder ON oder OFF sein.
OPER_SET_LOGCHAN_ON
	Die Services werden nun Logmessages an %s senden.
OPER_SET_LOGCHAN_OFF
	Die Services werden nun nicht mehr lnger Logmessages an einen Channel senden.
OPER_SET_LOGCHAN_ERROR
	Die Logchannel Option muss auf ON oder OFF gesetzt werden und LogChannel muss definiert sein.
OPER_SET_DEBUG_ON
	Die Services sind jetzt im Debug-Modus.
OPER_SET_DEBUG_OFF
	Die Services sind nicht mehr im Debug-Modus.
OPER_SET_DEBUG_LEVEL
	Die Services sind jetzt im Debug-Modus (Level %d).
OPER_SET_DEBUG_ERROR
	Die Einstellung von DEBUG kann nur ON, OFF, oder eine positive Zahl sein.
OPER_SET_NOEXPIRE_ON
	Services sind jetzt im No Expire Modus.
OPER_SET_NOEXPIRE_OFF
	Services sind jetzt im Expire Modus.
OPER_SET_NOEXPIRE_ERROR
	Die Einstellung von NOEXPIRE kann nur ON oder OFF sein.
OPER_SET_UNKNOWN_OPTION
	Unbekannte Option %s.

# NOOP responses
OPER_NOOP_SYNTAX
	NOOP {SET|REVOKE} server
OPER_NOOP_SET
	Alle O:Lines von %s wurden temporr entfernt.
OPER_NOOP_REVOKE
	Alle O:lines von %s wurden wiederhergestellt.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE servername [reason]

# RAW responses
OPER_JUPE_HOST_ERROR
	Benutze bitte einen gltigen hostnamen, wenn du jupiterst
	
# RAW responses
OPER_RAW_SYNTAX
	RAW text

# UPDATE responses
OPER_UPDATING
	Datenbanken wurden aktualisiert.
	
# RELOAD responses
OPER_RELOAD
	Die Konfigurationsdatei wurde neu eingelesen.

# RESTART responses
OPER_CANNOT_RESTART
	SERVICES_BIN wurde nicht definiert; Neustart nicht mglich. Benutze erneut das configure-Skript und kompiliere die Services erneut mit aktiviertem RESTART-Befehl.

# IGNORE respondes
OPER_IGNORE_SYNTAX
	Syntax: IGNORE {ADD|DEL|LIST|CLEAR} [time] [nick]
OPER_IGNORE_VALID_TIME
	Du musst eine zulssige Zahl als Zeit eingeben.
OPER_IGNORE_TIME_DONE
	Nick %s wird nun fr %s ignoriert.
OPER_IGNORE_PERM_DONE
	Nick %s will wird nun permanent ignoriert.
OPER_IGNORE_DEL_DONE
	Nick %s wird nicht lnger ignoriert.
OPER_IGNORE_LIST
	Services Ignore Liste:
OPER_IGNORE_LIST_NOMATCH
	Nick %s wurde nicht in der Ignore Liste gefunden.
OPER_IGNORE_LIST_EMPTY
	Ignore Liste ist leer.
OPER_IGNORE_LIST_CLEARED
	Die Ignore Liste wurde geleert.

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES nick
OPER_KILLCLONES_UNKNOWN_NICK
	Kann User %s nicht finden.
	
# CHANLIST responses
OPER_CHANLIST_HEADER
	Channel-Liste:
	Name                  User Topic
OPER_CHANLIST_HEADER_USER
	%s Channel-Liste:
	Name                  User Topic
OPER_CHANLIST_RECORD
	%-20s  %4d %s
OPER_CHANLIST_END
	Ende der Channel-Liste.
	
# USERLIST responses
OPER_USERLIST_HEADER
	User-Liste:
	Nick                 Maske
OPER_USERLIST_HEADER_CHAN
	%s User-Liste:
	Nick                 Maske
OPER_USERLIST_RECORD
	%-20s %s@%s
OPER_USERLIST_END
	Ende der User-Liste.

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_CACHE_SYNTAX
	CACHE {DEL | LIST} {hostname | pattern} [QUEUED | ALL]
OPER_CACHE_DISABLED
	Proxy Detektor ist deaktiviert.
OPER_CACHE_NOT_FOUND
	%s wurde nicht im Cache gefunden.
OPER_CACHE_REMOVED
	%s wurde aus dem Cache gelscht.
OPER_CACHE_HEADER
	Hostname                                         Status
OPER_CACHE_LIST
	%-48s %s
OPER_CACHE_FOOTER
	Ende der Liste - %d/%d passende Eintrge angezeigt.
OPER_CACHE_QUEUED
	in der Warteschlange
OPER_CACHE_PROGRESS
	in Bearbeitung
OPER_CACHE_NORMAL
	Normal
OPER_CACHE_WINGATE
	Wingate
OPER_CACHE_SOCKS4
	SOCKS 4
OPER_CACHE_SOCKS5
	SOCKS 5
OPER_CACHE_HTTP
	HTTP proxy
OPER_SUPER_ADMIN_ON
	Du bist nun ein Super-Admin.
OPER_SUPER_ADMIN_OFF
	Du bist nun kein Super-Admin mehr.
OPER_SUPER_ADMIN_SYNTAX
	Super-Admin muss ON oder OFF sein.
OPER_SUPER_ADMIN_WALL_ON
	%s ist nun ein Super-Admin.
OPER_SUPER_ADMIN_WALL_OFF
	%s verlsst den Super-Admin Mode. 

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_SUPER_ADMIN_ONLY
	Only Super-Admins can use this command.

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_STAFF_LIST_HEADER
	On Level Nick

# DefCon Messages

OPER_STAFF_FORMAT
	 %c %s  %s
OPER_STAFF_AFORMAT
	 %c %s  %s [%s]

# DefCon Messages

OPER_DEFCON_SYNTAX
	Syntax: DEFCON [1|2|3|4|5]
OPER_DEFCON_DENIED
	Dieser service ist derzeit deaktiviert, bitte versuche es spter nochmal
OPER_DEFCON_NO_CONF
	Das Defcon-System muss in der services.conf aktiviert worden sein
OPER_DEFCON_CHANGED
	Services sind nun beim DEFCON %d
OPER_DEFCON_WALL
	%s hat das DEFCON-Level gendert zu %d
DEFCON_GLOBAL
	Das Defcon-Level ist nun auf Level: %d

# Module strings

OPER_MODULE_LOADED
	Module %s geladen
OPER_MODULE_UNLOADED
	Module %s entfernt
OPER_MODULE_LOAD_FAIL
	Kann Module %s nicht laden
OPER_MODULE_REMOVE_FAIL
	Kann Module %s nicht entfernen
OPER_MODULE_LOAD_SYNTAX
	MODLOAD FileNamee
OPER_MODULE_UNLOAD_SYNTAX
	MODUNLOAD FileName
OPER_MODULE_LIST
	Module: %s
OPER_MODULE_INFO_LIST
	Module: %s Version: %s Author: %s loaded: %s
OPER_MODULE_CMD_LIST
	Untersttzte command: /msg %s %s
OPER_MODULE_MSG_LIST
	Untersttzte IRCD's fr: %s
OPER_MODULE_NO_LIST
	derzeit keine module geladen
OPER_MODULE_NO_INFO
	Es sind keine Informationen fr das Module %s verfgbar
OPER_MODULE_INFO_SYNTAX
	MODINFO FileName

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
MODULE_HELP_HEADER
	Die folgenden Befehle wurden durch ein Module geladen:

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [params]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+expiry] mask limit reason
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {mask | list}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE num position
OPER_EXCEPTION_DISABLED
	Eingeschrnkte Verbindungen sind deaktiviert.
OPER_EXCEPTION_ALREADY_PRESENT
	Die Hostmaske %s ist bereits auf der Liste fr eingeschrnkte Verbindungen.
OPER_EXCEPTION_TOO_MANY
	Die Liste fr eingeschrnkte Verbindungen ist voll! 
OPER_EXCEPTION_ADDED
	Verbindungslimit fr %s gendert auf %d.
OPER_EXCEPTION_MOVED
	Exception for %s (#%d) moved to position %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	Kein solcher Eintrag (#%d) in der Liste der Verbindungs-
	einschrnkungen.
OPER_EXCEPTION_NOT_FOUND
	%s nicht gefunden in der Liste der Verbindungs-
	einschrnkungen.
OPER_EXCEPTION_NO_MATCH
	Keine entsprechenden Eintrge in der Liste der 
	Verbindungseinschrnkungen.
OPER_EXCEPTION_DELETED
	%s wurde von der Liste der Verbindungseinschrnkungen 
	entfernt.
OPER_EXCEPTION_DELETED_ONE
	Es wurde 1 Eintrag von der Liste der Verbindungs-
	einschrnkungen entfernt.
OPER_EXCEPTION_DELETED_SEVERAL
	Es wurden %d Eintrge von der Liste der Verbindungs-
	einschrnkungen entfernt.
OPER_EXCEPTION_LIST_HEADER
	Aktuelle Liste fr eingeschrnkte Verbindungen:
# mask, limit
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
OPER_EXCEPTION_LIST_COLHEAD
	Num  Limit  Host
# mask, set-by, set-time, expires, limit, reason
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (by %s on %s; %s)
	    Limit: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	Ungltige Verbindungseinschrnkung. Es muss eine gltige Integer-Zahl sein, grsser oder gleich
	Null aber kleiner als %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	Ungltige Hostmask. Nur echte Hostmasken sind gltig als Eintrge (ohne Nicks und Idents).

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST limit | VIEW host}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST limit
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW host
OPER_SESSION_DISABLED
	SESSION Kommando ist deaktiviert.
OPER_SESSION_INVALID_THRESHOLD
	Ungltiger Wert. Es muss eine gltige grade Zahl sein, die grsser als 1 ist.
OPER_SESSION_NOT_FOUND
	Es wurde keine Verbindung von %s gefunden.
OPER_SESSION_LIST_HEADER
	Hosts mit mindestens %d Verbindungen:
OPER_SESSION_LIST_COLHEAD
	Verbindungen  Host
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	Der Host %s hat momentan %d Verbindungen und ein Limit von %d.

# EXCEPTION help

OPER_HELP_EXCEPTION
	Syntax: EXCEPTION ADD [+expiry] mask limit reason
	        EXCEPTION DEL {mask | list}
	        EXCEPTION MOVE num position
	        EXCEPTION LIST [mask | list]
	        EXCEPTION VIEW [mask | list]
	
	Erlaubt es Services Admins, die Liste der Verbindungs-
	einschrnkungen zu bearbeiten - dadurch kann man bestimmte
	Hosts, z.b. Shell-Server, auf eine bestimmte Anzahl
	von gleichzeitigen Verbindungen einschrnken. Hat ein
	Host dieses Limit erreicht, werden weitere User von
	die connecten wollen (von dem Host), gekilled. Bevor sie
	gekilled werden, bekommen sie eine Notice vom %S,
	damit sie wissen, warum sie vom Netz getrennt wurden.
	
	EXCEPTION ADD fuegt die angegebene Hostmask zu der
	Liste der Verbindungseinschrnkungen hinzu. 
	Beachte, dass nick!user@host und user@host keine richtigen
	Hostmasken sind!
	Nur echte Hosts, wie z.B. box.host.dom und *.host.dom
	sind zulssig, weil fr eingeschrnkte Verbindungen die Nicks
	oder Idents nicht von Interesse sind.
	limit muss eine Nummer grsser oder gleich 0 sein, und legt
	fest, viele Verbindungen von diesem Host gemacht werden drfen.
	Ein limit von Null bedeutet, dass dieser Host keine ein-
	geschrnkte Verbindung hat. Siehe die AKILL Hilfe fuer
	weitere Informationen ber das Format des optionalen expiry 
	Parameters.
	
	EXCEPTION DEL entfernt den Host von der Liste.
	
	EXCEPTION MOVE verschiebt den Eintrag mit der Nummer num 
	auf die Position position. Die Eintrge dazwischen werden
	hoch bzw runtergeschoben um die Lcken zu fllen.
	
	EXCEPTION LIST und EXCEPTION VIEW zeigt alle
	aktuellen Verbindungseinschrnkungen; wird die optionale
	Maske angegeben, werden nur die entsprechenden Eintrge aus
	der Liste angezeigt. Der Unterschied zwischen den beiden 
	Befehlen liegt darin, dass EXCEPTION VIEW ausfhrlicher ist;
	Es zeigt unter anderem den Namen der Person, die den Eintrag
	erstellt hat, dessen Grund, das Limit, die Hostmaske und
	die Auslaufzeit.
	
	Beachte das ein verbindender Client die erste Beschrnkung
	die auf seinen Host zutrifft, "benutzen" wird. Grosse und
	weit treffende Eintrge in der Liste der Verbindungs-
	einschrnkungen senken die Performance der Services.
	
	Beschrnkt auf Services Admins.

OPER_HELP_SESSION
	Syntax: SESSION LIST threshold
	        SESSION VIEW host
	
	Zeigt Services Admins eine Liste mit Hosts, die eine
	bestimmte Anzahl Verbindungen zum Chat-Netz haben.
	
	SESSION LIST zeigt die Hosts mit mindestens threshold 
	gleichzeitigen Verbindungen.
	Der threshold muss eine Nummer grsser als 1 sein. Dies
	soll verhindern, dass aus Versehen eine riesige Liste
	von Einzelsitzungen ausgegeben wird.
	
	SESSION VIEW ist etwas ausfhrlicher und zeigt mehr
	Informationen ber den bestimmten Host - mit
	Anzahl Verbindungen und dessen Limit. Der Wert bei
	host kann keine Platzhalter (Wildcards) enthalten.
	
	Siehe die Hilfe zu EXCEPTION um weitere Informationen
	ber das Einschrnken von Verbindungen zu erhalten.
	
	Beschrnkt auf Services Admins.

###########################################################################
#
# News system messages
#
###########################################################################

OPER_HELP_STAFF
	Syntax: STAFF

	Zeigt alle Nicks, die Zugriff auf die Services haben samt Level 
	und Online-Status.

OPER_HELP_DEFCON
	Syntax: DEFCON [1|2|3|4|5]

	Das Defcon-System kann benutzt werden, um vordefinierte	Einstellung  
	von einschrnkungen der Services einzubinden - ntzlich whrend 
	versuchter Angriffe auf das Netzerk.

OPER_HELP_DEFCON_NO_NEW_CHANNELS
	* Keine neuen Channel-Registrierungen
OPER_HELP_DEFCON_NO_NEW_NICKS
	* Keine neuen Nick-Registrierungen
OPER_HELP_DEFCON_NO_MLOCK_CHANGE
	* keine MLOCK nderungen
OPER_HELP_DEFCON_FORCE_CHAN_MODES
	* Zwingt alle channels die Modes (%s) zu setzen
OPER_HELP_DEFCON_REDUCE_SESSION
	* Benutzt das reduzierte Session-Limit von %d
OPER_HELP_DEFCON_NO_NEW_CLIENTS
	* Killt jeden NEU verbindenden Clienten
OPER_HELP_DEFCON_OPER_ONLY
	* Ignoriert jeden non-opers mit Nachrichten
OPER_HELP_DEFCON_SILENT_OPER_ONLY
	* Stilles ignorieren von non-opers
OPER_HELP_DEFCON_AKILL_NEW_CLIENTS
	* Setzt einen AKILL auf jeden NEU verbindenden Clienten


###########################################################################
#
# News system messages
#
###########################################################################

OPER_HELP_DEFCON_NO_NEW_MEMOS
	* Es werden keine neuen Memos gesendet
OPER_HELP_CHANKILL
	Syntax: CHANKILL [+expiry] channel reason

	Setzt einen AKILL fr jeden Nick des angegebenen Channels. Es 
	werden die Eintrge und komplette reale ident@host fr jeden Nick
	benutzt, dann wird der AKILL durchgefhrt. 

###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[Logon News - %s] %s
NEWS_OPER_TEXT
	[Oper News - %s] %s

NEWS_RANDOM_TEXT
	[Random News - %s] %s

NEWS_LOGON_SYNTAX
	Syntax: LOGONNEWS {ADD|DEL|LIST} [text|num]
NEWS_LOGON_LIST_HEADER
	Logon News Eintrge:
NEWS_LOGON_LIST_ENTRY
	%5d (%s von %s)
	    %s
NEWS_LOGON_LIST_NONE
	Es gibt keine Logon News.
NEWS_LOGON_ADD_SYNTAX
	Syntax: LOGONNEWS ADD text
NEWS_LOGON_ADD_FULL
	Die News-Liste ist voll!
NEWS_LOGON_ADDED
	Neuer Logon News-Eintrag hinzugefgt (#%d).
NEWS_LOGON_DEL_SYNTAX
	Syntax: LOGONNEWS DEL {num | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Logon News-Eintrag #%d konnte nicht gefunden werden!
NEWS_LOGON_DELETED
	Logon News-Eintrag #%d wurde gelscht.
NEWS_LOGON_DEL_NONE
	Keine zu lschenden Eintrge in der Logon News-Liste gefunden.
NEWS_LOGON_DELETED_ALL
	Alle Logon-News wurden entfernt.

NEWS_OPER_SYNTAX
	Syntax: OPERNEWS {ADD|DEL|LIST} [text|num]
NEWS_OPER_LIST_HEADER
	Oper News Eintrge:
NEWS_OPER_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_OPER_LIST_NONE
	Es gibt keine Oper-News.
NEWS_OPER_ADD_SYNTAX
	Syntax: OPERNEWS ADD text
NEWS_OPER_ADD_FULL
	Die News-Liste ist voll!
NEWS_OPER_ADDED
	Neuer Oper-News-Eintrag hinzugefgt (#%d).
NEWS_OPER_DEL_SYNTAX
	Syntax: OPERNEWS DEL {num | ALL}
NEWS_OPER_DEL_NOT_FOUND
	Oper-News-Eintrag #%d nicht gefunden!
NEWS_OPER_DELETED
	Oper-News-Eintrag #%d wurde entfernt.
NEWS_OPER_DEL_NONE
	Keine Oper-News-Eintrge zu lschen!
NEWS_OPER_DELETED_ALL
	Alle Oper-News-Eintrge wurden entfernt.

NEWS_RANDOM_SYNTAX
	Syntax: RANDOMNEWS {ADD|DEL|LIST} [text|num]
NEWS_RANDOM_LIST_HEADER
	Random news Eintrge:
NEWS_RANDOM_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_RANDOM_LIST_NONE
	Keine random news vorhanden.
NEWS_RANDOM_ADD_SYNTAX
	Syntax: RANDOMNEWS ADD text
NEWS_RANDOM_ADD_FULL
	Die News Liste ist voll!
NEWS_RANDOM_ADDED
	Neuer random news Eintrag hinzugefgt (#%d).
NEWS_RANDOM_DEL_SYNTAX
	Syntax: RANDOMNEWS DEL {num | ALL}
NEWS_RANDOM_DEL_NOT_FOUND
	Random news Eintrag #%d nicht gefunden!
NEWS_RANDOM_DELETED
	Random news Eintrag #%d gelscht.
NEWS_RANDOM_DEL_NONE
	Keine random news Eintrge zu lschen!
NEWS_RANDOM_DELETED_ALL
	Ale random news Eintrge wurden gelscht.

NEWS_HELP_LOGON
	Syntax: LOGONNEWS ADD text
	        LOGONNEWS DEL {num | ALL}
	        LOGONNEWS LIST
	
	Zeigt oder bearbeitet die Liste der Logon News.
	Nach dem Connect des Users werden diese Nachrichten
	angezeigt. (Es werden jedoch nur max. 3 angezeigt, um ein
	Flooding des Users zu verhindern. Wenn mehr als 3 News
	existieren, werden nur die 3 neuesten angezeigt.)
	
	LOGONNEWS LIST kann von jedem IRC Operator benutzt werden
	um die aktuelle Liste der Logon News anzeigen zu lassen.
	ADD oder DEL knnen allerdings nur von Services Admins
	ausgefhrt werden.

NEWS_HELP_OPER
	Syntax: OPERNEWS ADD text
	        OPERNEWS DEL {num | ALL}
	        OPERNEWS LIST
	
	Zeigt oder bearbeitet die Liste der Oper-News.
	Nachdem sich ein User die Oper-Flags gesetzt hat (mit dem
	/OPER Befehl) werden ihm diese Nachrichten angezeigt.
	(Es werden jedoch nur max. 3 Nachrichten angezeigt, um ein
	Flooding des Users zu verhindern. Wenn mehr als 3 News
	existieren, werden nur die 3 nesten angezeigt.)
	
	OPERNEWS LIST kann von jedem IRC Operator benutzt werden
	um die aktuelle Liste der Oper-News anzeigen zu lassen.
	ADD oder DEL knnen allerdings nur von Services Admins
	ausgefhrt werden.

###########################################################################
#
# HelpServ help message
#
###########################################################################

NEWS_HELP_RANDOM
	Syntax: RANDOMNEWS ADD text
	        RANDOMNEWS DEL {num | ALL}
	        RANDOMNEWS LIST
	
	Bearbeitet die Liste der Random News Messages oder zeigt diese an.
	Wenn ein User zum Network connectet, eine (und nur eine!) dieser
	Random News Messages wird zufllig gewhlt und an den User gesendet.
	
	RANDOMNEWS LIST kann von jedem IRC Operator genutzt werden um die
	aktuellen News Messages aufzulisten.  ADD und DEL knnen nur von
	Services Admins genutzt werden.

###########################################################################
#
# HelpServ help message
#
###########################################################################

HELP_HELP
	%S dient dazu, Hilfe und weitere Informationen zu den Services
	auszugeben. Eine Themenbersicht bekommt man mit Hilfe des 
	HELP Befehls der anderen Services:
	
	/msg %s HELP
	     fr Informationen zum Registrieren der Nicknames
	
	/msg %s HELP
	     fr Informationen zum Registrieren und Kontrollieren der
	     Channels
	
	/msg %s HELP
	     fr Informationen zum Senden von Memos an User, die im
	     Moment nicht online sind     

HELP_HELP_BOT

	/msg %s HELP
	     fr Informationen wie man einen Bot in einem Channel
	     einrichtet

HELP_HELP_HOST

	/msg %s HELP
	     for information on setting up nick vHosts

###########################################################################
#
# NickServ help messages
#
###########################################################################

NICK_HELP
	Mit %S kannst du einen Nicknamen "registrieren" und somit
	verhindern, dass andere ihn nutzen. Die folgenden Befehle
	erlauben die Registrierung und das ndern der Einstellungen
	von den Nicknamen; um sie zu benutzen, tippe 
	/msg %S command. Fr weitergehende Infos zu
	einem bestimmten Befehl, tippe /msg %S HELP command.
	
	    REGISTER   Registriert einen Nicknamen
	    GROUP      Verwaltung von Nickname-Gruppierungen
	    IDENTIFY   Identifizierung des Nicknames
	    ACCESS     Liste der autorisierten Adressen
	    SET	       Optionen einstellen, auch Kill-Schutz
	    DROP       Die Registrierung eines Nicks lschen
	    RECOVER    User killen, der deinen Nicknamen
	               verwendet
	    RELEASE    Regain custody of your nick after RECOVER
	    SENDPASS   Passwort vergessen? Versuch das hier..
	
	Weitere Befehle: GHOST, ALIST, INFO, LIST, LOGOUT, STATUS
	
	WARNUNG: Dieser Service soll den Usern einen Weg
	ermglichen, den Missbrauch ihres Nicknames zu verhindern.
	Es ist NICHT dazu gedacht, Nicknames zu stehlen oder
	in Massen zu reservieren. Missbrauch von %S wird
	geahndet und resultiert mindestens im Verlust deiner
	registrierten Nicks.

NICK_HELP_EXPIRES
	
	Nicknames die seit einer lngeren Zeit nicht mehr
	genutzt wurden, werden durch den automatischen Auslauf
	nach %d Tagen aus der Datenbank entfernt.

NICK_HELP_REGISTER
	Syntax: REGISTER password [email]
	
	Registriert deinen Nicknamen in der Datenbank von 
	%S. Nachdem dein Nick registriert ist, kannst du mit den
	SET und ACCESS Befehlen die Einstellungen deines
	Nicks anpassen wie du es mchtest. Stell bitte
	sicher, dass du dir das Passwort bei der Registrierung
	merkst - du wirst es brauchen, wenn du spter
	nderungen an den Einstellungen vornehmen willst!
	
	(Beachte auch, dass Gross/Kleinschreibung unterschieden
	werden! ANOPE, Anope, und anope sind 
	verschiedene Passworte!)
	
	Richtlinien bei der Auswahl eines Passwortes:
	
	Passworte sollten nicht einfach zu erraten sein.
	Zum Beispiel deinen echten Namen als Passwort zu nehmen
	ist eine schlechte Idee. Deinen Nicknamen selbst
	als Passwort zu nehmen, ist eine noch viel schlechtere
	Idee ;) und ausserdem wrde %S es auch nicht erlauben.
	Weiterhin sind kurze Passworte anfllig bei Trial-
	and-Error-Versuchen, also sollte es zumindest 5 Zeichen
	lang sein.
	Zu guter letzt solltest du auch keine Leerzeichen im 
	Passwort verwenden. 
	
	Der Parameter email ist optional und ermglicht
	Nickserv dir dein Passwort per Mail zu senden, falls
	du es vergessen haben solltest. 
	Deine Privatsphre wird respektiert, deine eMail-
	Adresse wird keinem Dritten verfgbar gemacht.
	
	Dieser Befehl (REGISTER) erstellt auch ausserdem
	eine neue Gruppe fr deinen Nick, die dir erlaubt,
	nachher weitere Nicks in diese Gruppe aufzunehmen,
	die dann automatisch die gleiche Konfiguration und
	Channel-Privilegien bekommen. Fr weitere Infos
	ber diese Funktion tippe /msg %S HELP GROUP.
	
NICK_HELP_GROUP
	Syntax: GROUP target password
	
	Dieser Befehl verbindet deinen Nicknamen mit der
	Gruppe von target. password ist das Passwort
	des Target-Nicknamen.
	
	Das Teilnehmen in der Gruppe teilt deine Konfiguration,
	Memos und Channel-Privilegien mit allen Nicknames der 
	Gruppe, und vieles mehr!
	
	Eine Gruppe existiert so lange es sinnvoll ist. Dies
	bedeutet, dass selbst wenn die Gruppe geDROPed wird,
	die geteilten Konfigurationen/Rechte erhalten bleiben,
	so lange mindestens ein Nick der Gruppe verbleibt.
	 
	Dieser Befehl lsst sich sogar verwenden, wenn dein Nick
	(noch) nicht registriert ist. Wenn er jedoch registriert
	ist, musst du dich vorher identifizieren. Tippe
	/msg %S HELP IDENTIFY fr weitere Infos.
	
	Es wird allerdings empfohlen diesen Befehl mit einem
	nicht-registrierten Nick zu verwenden, da der Nick
	automatisch registriert wird, wenn er der Gruppe beitritt.
	Das Beitreten einer Gruppe mit einem bereits registrierten
	Nick kann durch die Netzwerk-Administratoren gesperrt
	sein.
	    
	Du kannst nur in einer Gruppe zur gleichen Zeit sein.
	Das Zusammenfhren verschiedener Gruppen ist nicht
	mglich.
	
	Achtung: Alle Mitglieder einer Gruppe haben dasselbe
	Passwort.

NICK_HELP_IDENTIFY
	Syntax: IDENTIFY password
	
	Beweist %S, dass du wirklich der Besitzer 
	dieses Nicks bist. Viele Befehle erzwingen, dass 
	du dich vorher hiermit autorisierst, bevor du sie 
	benutzen kannst. Das Passwort ist das von deiner 
	Registrierung, die du mit dem REGISTER Befehl 
	gesetzt hast.
	
NICK_HELP_UPDATE
	Syntax: UPDATE

	Updatet deinen derzeiten Status, z.B. prft es auf neue Nachrichten,
	setzt bentigte Channel-Modes (ModeonID), aktualisiert deinen Vhost und
	deine userflags (lastseentime, etc).
	
NICK_HELP_LOGOUT
	Syntax: LOGOUT
	
	Dieses Kommando macht den Effekt des IDENTIFY Befehls
	rckgngig. NickServ erkennt dich also nicht mehr als
	den Besitzer des Nicks. Beachte jedoch, dass du nicht
	mehr gewarnt wirst, dich erneut zu identifizieren.

NICK_HELP_DROP
	Syntax: DROP [nickname]
	
	Entfernt die Registrierung deines Nicknames aus
	der Datenbank von %S. Ein gedroppter Nick kann
	von jedem jederzeit wieder registriert werden.
	
	Du kannst auch einen Nicknamen innerhalb deiner
	Gruppe entfernen lassen, wenn du ihn als Parameter
	bei nickname angibst.
	
	Wenn du dieses Kommando benutzen willst, musst du
	dich vorher mit deinem Passwort identifizieren. 
	(/msg %S HELP IDENTIFY fr weitere Infos).

NICK_HELP_ACCESS
	Syntax: ACCESS ADD mask
	        ACCESS DEL mask
	        ACCESS LIST
	
	Zeit oder bearbeitet die Zugriffsliste fr
	deinen Nick. Durch diese Liste erkennt %S
	dich automatisch als berechtigt, diesen Nick
	zu nutzen. Wenn du den Nick von anderen Adressen
	verwenden willst, musst du dich durch das 
	IDENTIFY Kommando einloggen, damit %S
	dich erkennt.
	
	Beispiele:
	
	    ACCESS ADD anyone@*.bepeg.com
	    Erlaubt zugriff vom User anyone von
	    jedem Host aus der bepeg.com Domain.
	
	    ACCESS DEL anyone@*.bepeg.com
	    Hebt den oben genannten Befehl wieder auf.
	
	    ACCESS LIST
	    Zeigt die aktuelle Zugriffsliste an.

NICK_HELP_SET
	Syntax: SET option parameters
	
	Stellt verschiedene Optionen zu deinem Nicknamen ein.
	option kann eines der folgenden Werte sein:
	
	    DISPLAY    ndert den "Ursprung" deiner Gruppe
	    PASSWORD   Setzt das Passwort deines Nicks neu
	    LANGUAGE   Stellt die Sprache ein, in der dir die 
	               Services antworten sollen.
	    URL        Verbindet eine URL mit deinem Nick
	    EMAIL      Verbindet eine ffentliche eMail-Adresse
	               mit deinem Nicknamen
	    ICQ        Trgt deine ICQ-Nummer unter den Infos
	               zu deinem Nick ein.
	    GREET      Stellt eine Begrssungsmeldung fr deinen
	               Nick ein.
	    KILL       Stellt Kill-Schutz an oder aus.
	    SECURE     Aktiviert/Deaktiviert den Sicherheitsmodus
	               fr deinen Nick
	    PRIVATE    Verhindert das Erscheinen deines Nicks auf
	               der Liste von /msg %S LIST
	    HIDE       Versteckt bestimmte Informationen deines
	               Nicks
	    MSG        ndert die Methode, wie die Services mit
	               dir kommunizieren
	
	Wenn du eines dieser Optionen nutzen willst, musst du dich
	vorher identifizeren. 
	(/msg %S HELP IDENTIFY fr weitere Infos.)
	
	Tippe /msg %S HELP SET option fr Erluterungen
	zu einer bestimmten oben genannten Option.

NICK_HELP_SET_DISPLAY
	Syntax: SET DISPLAY new-display
	
	ndert den virtuellen "Anfhrer" deiner Gruppe in den
	Services. Der wert von new-display MUSS ein Nickname
	in deiner Gruppe sein.
	
	Hinweis: Dieser Befehl ndert keine Zugriffsrechte
	des einzelnen Nicks, er wird nur als "Ursprung" der Gruppe
	in der Liste aufgefhrt.
	
NICK_HELP_SET_PASSWORD
	Syntax: SET PASSWORD new-password
	
	ndert das Passwort, mit dem du dich als Besitzer des
	Nicks identifizierst.

NICK_HELP_SET_LANGUAGE
	Syntax: SET LANGUAGE number
	
	Stellt die Sprache ein, mit der die Services mit dir
	kommunizieren. (Zum Beispiel in einer Antwort auf einen
	Befehl den du gesendet hast.)
	
	number muss von der folgenden Liste der unter-
	sttzten Sprachen ausgewhlt werden: 

NICK_HELP_SET_URL
	Syntax: SET URL url
	
	Verbindet die angegebene URL mit deinem Nicknamen.
	Diese URL wird angezeigt, wenn jemand Informationen
	ber deinen Nick mit dem INFO Befehl anfordert.

NICK_HELP_SET_EMAIL
	Syntax: SET EMAIL address
	
	Verbindet die angegebene eMail-Adresse mit deinem
	Nicknamen. Diese Adresse wird angezeigt, wenn jemand 
	Informationen ber deinen Nick mit dem INFO 
	Befehl anfordert.
	
NICK_HELP_SET_ICQ
	Syntax: SET ICQ number
	
	Verbindet die angegebene ICQ Nummer mit deinem Nick.
	Diese Nummer wird angezeigt, wenn jemand Informationen
	ber deinen Nick mit dem INFO Befehl anfordert.
	
NICK_HELP_SET_GREET
	Syntax: SET GREET message
	
	Die angegebene Message wird als Begrssungsnachricht
	gesendet, wenn du in einen Channel eintrittst, der
	die GREET Option eingeschaltet hat. Vorausgesetzt
	du hast den ntigen Zugriffslevel in der Access-Liste
	des Channels. 	

NICK_HELP_SET_KILL
	Syntax: SET KILL {ON | QUICK | IMMED | OFF}
	
	Stellt den automatischen Schutz des Nicknames durch
	einen Kill an oder aus. Nimmt ein User deinen Nick, 
	hat er eine Minute Zeit sich zu identifizieren,
	danach wird er, bei eingeschaltetem Schutz, durch
	%S umbenannt in einen Zufallsnamen.
	
	Bei der Einstellung QUICK wird Wartezeit zum
	Identifizieren auf 20 Sekunden herabgesenkt. Bei
	IMMED wird der User sofort ohne Warnung
	umbenannt, wenn er nicht auf der Zugriffsliste des
	Nicks steht; bitte benutze diese Option nicht
	unntigerweise.
	Ausserdem ist es mglich, dass die Netz-Admins
	diese Option deaktiviert haben.

NICK_HELP_SET_SECURE
	Syntax: SET SECURE {ON | OFF}
	
	Stellt die Sicherheitsfunktionen von %S fr deinen
	Nick an oder aus. Mit eingeschaltetem SECURE
	musst du dich immer identifizieren, egal ob deine
	Hostmaske auf der Zugriffsliste fr den Nick
	steht oder nicht. Wenn du allerdings auf 
	der Zugriffsliste stehst, wird %S bei 
	fehlender Identifizierung den Nick nicht killen
	(ist von der KILL Option unabhngig).

NICK_HELP_SET_PRIVATE
	Syntax: SET PRIVATE {ON | OFF}
	
	ndert %S's Privat-Modus fr deinen Nick.
	Mit eingeschaltetem PRIVATE wird dein Nickname
	nicht auf Listen erscheinen, die durch %S's LIST 
	Kommando erstellt wurden.
	
	(Jeder der deinen Nick kennt, kann gezielt mit dem 
	INFO Kommando Informationen ber deinen Nick 
	abrufen, unabhngig vom Privat-Modus.)

NICK_HELP_SET_HIDE
	Syntax: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	Erlaubt es dir, bestimmte Informationen in der Ausgabe
	von %S INFO zu verstecken.
	Du kannst deine eMail-Adresse verstecken (EMAIL), die 
	zuletzt gesehene user@host-Maske (USERMASK) und die
	letzte Quit-Nachricht (QUIT).
	Der zweite Parameter bestimmt, ob die Information angezeigt
	werden soll (OFF) oder nicht (ON).
	
NICK_HELP_SET_MSG
	Syntax: SET MSG {ON | OFF}
	
	Bestimmt den Modus, mit dem sich die Services mit dir
	unterhalten. 
	Ist MSG eingeschaltet, benutzen die Services Messages
	(Queries), ansonsten werden dir die Antworten als Notices
	geschickt (Standard).

NICK_HELP_RECOVER
	Syntax: RECOVER nickname [password]
	
	Ermglicht es dir, deinen Nicknamen wieder freizugeben,
	wenn jemand anderes ihn angenommen hat; diese Funktion
	wird auch durch %S genutzt, wenn jemand einen Nick
	mit Kill-Schutz anzunehmen.
	
	Bei Aufruf dieses Kommandos wird %S einen virtuellen
	User mit dem gleichen Nick online schalten den du
	recovern willst. Die Folge davon ist, dass der User,
	der deinen Nick angenommen hatte, vom Server getrennt
	wird. Der virtuelle User von den Services wird noch
	1 Minute online bleiben, um sicherzustellen, dass der
	andere User nicht sofort neu connected; Nach dieser
	Minute wird der Nick wieder freigegeben und du kannst
	ihn annehmen.
	
	Als Alternative gibt es das RELEASE Kommando,
	(/msg %S HELP RELEASE) um deinen Nick 
	schneller zurckzubekommen.
	
	Als Vorraussetzung fr das RECOVER Kommando
	muss deine aktuelle Adresse (siehe Ausgabe von /WHOIS)
	auf der Zugriffsliste des zu recovernden Nicks oder in
	dessen Gruppe sein. Als dritte Mglichkeit kannst du
	das Passwort fr den Nick angeben.

NICK_HELP_RELEASE
	Syntax: RELEASE nickname [password]
	
	Durch %S wird die Nickname-Sperre, ausgelst
	durch z.B. den Automatischen Kill-Schutz oder durch
	Verwendung des RECOVER Kommandos, aufgehoben.
	Standardmssig hlt diese Sperre 1 Minute, dieses
	Kommando setzt den Nick frher wieder frei.
	
	Als Vorraussetzung fr die Verwendung des RELEASE 
	Kommandos fr einen Nick, muss deine aktuelle Hostmaske
	(siehe /WHOIS) in der Zugriffsliste des entsprechenden
	Nicks oder in der Gruppe des Nicks sein. 
	Weiterhin musst du das richtige Passwort fr den Nick
	haben.

NICK_HELP_GHOST
	Syntax: GHOST nickname [password]
	
	Trennt eine "geisternde" IRC Verbindung, die deinen
	Nick besitzt. Eine solche Verbindung ist eine
	die nicht wirklich verbunden ist bzw im Begriff ist,
	getrennt zu werden. Normalerweise passiert dies,
	wenn dein Computer abstrtzt oder deine Internet-
	Verbindung zusammenbricht, wenn du im IRC bist.
	
	Wenn du das GHOST Kommando benutzen willst,
	muss deine aktuelle Hostmaske (siehe /WHOIS) in der
	Zugriffsliste des entsprechenden Nicks oder 
	in der Gruppe des Nicks sein.
	Weiterhin musst du das richtige Passwort fr den Nick
	haben.

NICK_HELP_INFO
	Syntax: INFO nickname [ALL]
	
	Zeigt Informationen ber den angegebenen Nick, zum
	Beispiel den Besitzer des Nicks, die letzte gesehene
	Adresse und dessen Uhrzeit und die Optionen des Nicks.
	Wenn du dich fr den Nick ber den du Infos anzeigen
	willst identifiziert hast, und den Parameter ALL 
	benutzt, werden alle Informationen angezeigt.
	(Egal ob sie versteckt sind oder nicht.)

NICK_HELP_LIST
	Syntax: LIST pattern
	
	Listet alle registrierten Nicknamen auf, die auf das
	Suchmuster (pattern) passen, im Format nick!user@host.
	Nicks mit aktivierter PRIVATE Option werden allerdings 
	nicht angezeigt.
	
	Beispiele:
	
	    LIST *!joeuser@foo.com
	        Zeigt alle Nicks an, deren Besitzer joeuser@foo.com
	        ist.        
	
	    LIST *Bot*!*@*
	        Zeigt alle registrierten Nicks mit Bot in ihrem
	        Ident (Gross/Kleinschreibung wird nicht unterschieden).
	
	    LIST *!*@*.bar.org
	    Listet alle Nicks von Usern in der bar.org
	        Domain.


	NICK_HELP_ALIST
	Syntax: ALIST [level]
	
	Listet dir alle Channels auf, auf die du Zugriff hast. Zustzlich
	kannst du ein Level im XOP oder ACCESS Format angeben. Es werden 
	dann nur Channels aufgelistet, in denen du dieses Level hast.

	Beispiele:
	    ALIST Founder
	        Listet alle Chans auf, in denen du Founder Access hast.

	    ALIST AOP
	        Listet alle Chans auf, in denen dein Zugriffslevel AOP 
	    oder hher betrgt.

	    ALIST 10
	        Listet alle Chans auf, in dnen dein Zugriffslevel 10 
	    oder hher betrgt.
	
	Channels mit der NOEXPIRE Option sind mit einem Ausrufezeichen
	 markiert.
NICK_HELP_ALIST
	Syntax: ALIST [level]
	
	Listet alle Channels auf, auf denen du Zugriff hast. Optional kannst du
	das Level-Format (XOP oder ACCESS) bestimmen. Die daraus resultierende 
	liste wird nur Channels enthalten, wo du den entsprechenden 
	Zugriffslevel hast.

	Examples:
	    ALIST Founder
	        Listet alle Channels auf, in denen du Founder-Access hast.

	    ALIST AOP
	        Listet alle Channels auf, in denen du AOP-Access oder hher
	    hast.

	    ALIST 10
	        Listet alle Channels auf, in denen du das Zugriffs-Level 10 
	    oder hher hast..
	
	Channels, die die NOEXPIRE Option gesetztist,  haben ein 
	Ausrufezeiche als Prefix.
	
NICK_HELP_GLIST
	Syntax: GLIST
	
	Fhrt alle Nicks auf, die in deiner Gruppe enthalten sind.	
	
NICK_HELP_STATUS
	Syntax: STATUS nickname...
	
	Liefert einen Wert zurck, der besagt, ob der augenblickliche
	Nutzer des Nicks der identifizierte Eigentmer ist, oder nicht.
	Die Antwort hat das Format:
	
	    nickname status-code
	
	wobei nickname der Nick ist, der mit dem Kommando angefragt
	wurde, und status-code eine der folgenden Werte:
	
	    0 - User ist nicht online or Nick nicht registriert
	    1 - User wird nicht als Eigentmer erkannt
	    2 - User wird als Eigentmer erkannt durch die
	        Zugriffsliste
	    3 - User wird als Eigentmer erkannt durch die
	        Identifizierung mit Passwort
	
	Bis zu 16 Nicknamen knnen dem Kommando bergeben werden;
	der Rest wird ignoriert. Es wird keine Fehlermeldung
	ausgegeben, wenn kein Nick angegeben wird.
	
NICK_HELP_SENDPASS
	Syntax: SENDPASS nickname
	
	Sendet das Passwort des angegebenen Nicks zu der damit
	verbundenen eMail-Adresse aus der NickServ-Datenbank.
	Dieses Kommando ist wirklich ntzlich, wenn du dein
	Passwort vergessen haben solltest.
	
	Kann in manchen Netzen auf IRC Operatoren begrenzt
	sein.
	
	Dieses Kommando ist nicht verfgbar, wenn die Datenbanken
	verschlsselt angelegt sind.

NICK_SERVADMIN_HELP
	
	Die folgenden Kommandos sind fr Services Admins 
	verfgbar:
	
	    GETPASS    Das Passwort eines Nicks aus der
	                   Datenbank auslesen (nur wenn keine
	                   Verschlsselung aktiv ist)
	    FORBID     Einen bestimmten Nick verbieten
	
	Services Admins knnen auch registrierte Nicks lschen,
	ohne sich fr den jeweiligen Nick identifizieren zu
	mssen. Zustzlich knnen sie die Zugriffsliste eines
	jeden Nicks ansehen und bearbeiten (siehe /msg %S
	ACCESS LIST nick).

NICK_SERVADMIN_HELP_LOGOUT
	Syntax: LOGOUT [nickname [REVALIDATE]]
	
	Ohne angegebenen Parameter, macht dieses Kommando die
	Wirkung von IDENTIFY rckgngig; zum Beispiel
	wirst du nicht mehr als Eigentmer des Nicks erkannt.
	Beachte jedoch, dass du nicht erneut zur Identifizierung
	aufgefordert wirst.
	
	Mit angegebenem Parameter passiert das gleiche fr den
	Nicknamen. Wenn du zustzlich REVALIDATE angibst, wird
	Services dich auffordern, dich erneut fr den Nick
	zu identifizieren. 
	
	Diese Funktion ist beschrnkt auf die Services Admins.
	
NICK_SERVADMIN_HELP_DROP
	Syntax: DROP [nickname]
	
	Ohne angegebenen Parameter entfernt es deinen Nicknamen
	aus der Datenbank von %S.
	
	Mit dem Nicknamen als Parameter, wird dieser Nickname
	von der Datenbank entfernt. Du kannst jeden Nick in
	deiner Gruppe ohne bestimmte Privilegien entfernen.
	
	Das Entfernen eines beliebigen Nicks ist beschrnkt
	auf Services Admins.

NICK_SERVADMIN_HELP_SET
	
	Als zustzliche Option knnen die Services das
	NOEXPIRE-Flag an einem Nick setzen, dass diesen
	vor dem Auslaufen bei Nichtnutzung verhindert.
	
	Zustzlich knnen Services Admins die Optionen
	eines belieben Nicks verndern, ohne vorher
	ein Passwort fr den Nick einzugeben; dafr gilt
	das Format SET nickname option parameters.

NICK_SERVADMIN_HELP_SET_NOEXPIRE
	Syntax: SET [nickname] NOEXPIRE {ON | OFF}
	
	Stellt den Auslauf bei Nichtnutzung des angegebenen
	Nicknamen ein. Setzt man diesen Wert auf ON, wird
	der Nick nicht auslaufen. Wird kein Parameter ber-
	geben, wird das No-Expire Flag deines Nicks gendert.
	
	Diese Funktion ist beschrnkt auf Services Admins.

NICK_SERVADMIN_HELP_INFO
	
	Services Admins knnen den ALL Parameter fr
	jeden beliebigen Nick benutzen.

NICK_SERVADMIN_HELP_LIST
	Syntax: LIST pattern [FORBIDDEN] [NOEXPIRE]

	Zeigt alle registrierten Nicknamen an, die einem bestimmten
	Muster (pattern), nick!user@host, entsprechen.
	Nicks mit aktivierter PRIVATE-Option werden nur
	Services Admins angezeigt. Nicks bei denen das
	NOEXPIRE eingeschaltet ist, werden ein ! vor ihrem
	Eintrag in der Liste haben (nur bei Services Admins).
	
	Bei Angabe des Parameters FORBIDDEN oder NOEXPIRE werden
	nur Nicks aufgelistet, die das entsprechende Flag gesetzt
	haben. Wenn beide Parameter gleichzeitig angegeben, nur 
	Nicks, die beide Flags eingeschaltet haben. Diese 
	Funktion ist beschrnkt auf Services Admins.
	
	Beispiele:
	
	    LIST *!joeuser@foo.com
	        Zeigt alle Nicknamen die von joeuser@foo.com
	        besessen werden.
	
	    LIST *Bot*!*@*
	        Listet alle registrierten Nicknamen die Bot in
	        ihrem Ident haben (unabhngig von Gross/Klein-
	        schreibung).
	
	    LIST * NOEXPIRE
	        Zeigt alle registrierten Nicks an, die das NOEXPIRE
	        Flag gesetzt haben.

NICK_SERVADMIN_HELP_ALIST
	Syntax: ALIST [nickname] [level]
	
	Mit keinen Parametern werden alle Channels aufgelistet, auf
	die du Zugriff hast. Mit einem Parameter werden alle Channels
	aufgelistet, auf die nickname Zugriff hat. Mit zwei 
	Parametern werden alle Channel aufgelistet, in denen nickname 
	Zugriffslevel level oder hher hat.

	Beschrnkt auf Services admins.

NICK_SERVADMIN_HELP_GLIST
	Syntax: GLIST [nickname]
	
	Wird kein Parameter angegeben, werden alle Nicks in 
	deiner Gruppe angezeigt.
	
	Ansonsten werden alle Nicks, die in der Gruppe des
	angegebenen Nicks sind, aufgelistet. Diese Funktion
	ist beschrnkt auf Services Admins.

NICK_SERVADMIN_HELP_GETPASS
	Syntax: GETPASS nickname
	
	Liest das Passwort von nickname aus der Datenbank aus.
	Beachte dass wenn jemand dieses Kommando nutzt,
	diese Aktion im Logbuch der Services vermerkt wird.
	Zustzlich wird eine Nachricht an alle Oper per
	WALLOPS/GLOBOPS ausgesandt.
	
	Beschrnkt auf Services Admins.
	
	Dieses Kommando ist nicht verfgbar bei aktivierter
	Verschlsselung.

NICK_SERVADMIN_HELP_GETEMAIL
	Syntax: GETEMAIL user@emailhost

	Gibt die passenden Nicks auf, welche die gegebene email benutzen. 
	Beachte, dass du keine wildcards fr den User oder emailhost
	verwenden kannst. Immer, wenn dieser Befehl benutzt wird, wird eine
	Nachricht mit dem Nick der Person mitgeloggt, welche diesen Befehl 
	ausfhrt.

	Limited to Services admins.

NICK_SERVADMIN_HELP_FORBID
	Syntax: FORBID nickname [reason]
	
	Verhindert, dass der angegebene Nickname registriert
	oder genutzt wird. Diese Einschrnkung kann durch
	DROPen des Nicks aufgehoben werden.
	
	In bestimmten Netzen wird ein Grund (reason) fr das
	Verbot bentigt.
	
	Beschrnkt auf Services Admins.

###########################################################################
#
# ChanServ help messages
#
###########################################################################

CHAN_HELP
	Mit Hilfe von %S kann man Channel registrieren und
	eine Vielzahl von Kontrolloptionen einstellen. %S
	kann zum Beispiel das "Takeover" von Channels verhindern,
	in dem man die Channel-Op Privilegien auf bestimmte
	registrierte Nicks begrenzt. Verfgbare Kommandos
	sind unten aufgelistet; um sie zu benutzen tippe
	/msg %S command.  Fr weitere Informationen
	zu einem bestimmten Befehl, tippe /msg %S 
	HELP command.
	
	    REGISTER   Einen Channel registrieren
	    IDENTIFY   Sich mit Passwort als Founder (z.B.)
	               des Channels identifizieren
	    SET        Bestimmte Channel-Optionen und
	               Informationen einstellen
	    ACCESS     Die Liste der priviligierten User
	               bearbeiten
	    LEVELS     Die Einstellungen verschiedener
	               Zugriffslevel neu definieren
	    AKICK      Die Autokick-Liste bearbeiten
	    DROP       Registrierung eines Channels aufheben
	    SENDPASS   Hilft bei vergessenen Passwrtern
	
	Weitere Kommandos: CLEAR, DEOP, DEVOICE, GETKEY, INFO, 
	                   INVITE, KICK, LIST, LOGOUT, OP,
	                   UNBAN, VOICE
	
CHAN_HELP_UNREAL
	
	Diese Befehle stehen zustzlich in diesem
	Netzwerk zur Verfgung:
	    HALFOP, DEHALFOP, PROTECT, DEPROTECT

CHAN_HELP_ULTIMATE
	
	Diese Befehle stehen zustzlich in diesem
	Netzwerk zur Verfgung:
	
	    DEHALFOP, HALFOP, HOP

CHAN_HELP_ULTIMATE3
	
	Diese Befehle stehen zustzlich in diesem
	Netzwerk zur Verfgung:
	
	    DEHALFOP, HALFOP, HOP, ADMIN, DEADMIN

CHAN_HELP_EXPIRES
	
	Beachte das jeder Channel der fr %d Tage nicht
	genutzt wird (bzw wenn kein User aus der Zugriffs-
	liste diese bestimmte Zeit nicht erscheint), wird
	die Registrierung des Channels automatisch
	auslaufen.

CHAN_HELP_REGISTER
	Syntax: REGISTER channel password description
	
	Registriert einen Channel in der Datenbank von %S.
	Wenn du dieses Kommando nutzen mchtest, musst du
	Operator-Status in dem Channel besitzen. Das
	Passwort, dass du mit dem IDENTIFY Kommando
	einstellst, erlaubt es spter anderen nderungen 
	am Channel durchzufhren.
	Der letzte Parameter, der angegeben werden muss,
	sollte eine allgemeine Beschreibung des Channels bzw
	dessen Zweck beinhalten.	
	
	Wenn du einen Channel registrierst, wird dein Nick
	als Founder (Grnder) eingetragen. Der Channel-
	Founder kann alle Einstellungen des Channels
	bearbeiten, und wird automatisch beim Joinen des
	Channels durch %S mit Founder/Operator-
	Privilegien ausgestattet.  
	Mit Hilfe des ACCESS Kommandos (tippe
	/msg %S HELP ACCESS) kann man einen Teil dieser
	Privilegien anderen registrierten Nicks ebenfalls
	erteilen.
	
	Hinweis: Fr das Registrieren eines Channels
	musst du einen registrierten und identifizierten
	Nick benutzen. Hast du dies noch nicht getan,
	tippe/msg %s HELP um weitere Informationen
	darber zu erhalten.

CHAN_HELP_IDENTIFY
	Syntax: IDENTIFY channel password
	
	Identifiziert durch gegenber %S als Grnder
	(Founder) des angegebenen Channels. Viele
	Befehle bentigen diesen Schritt, bevor du sie
	benutzen kannst. Das Passwort ist das, das du beim
	REGISTER Kommando angegeben hattest.
	
CHAN_HELP_LOGOUT
	Syntax: LOGOUT channel nickname
	
	Hebt die Identifizierung als Channel-Founder fr
	den angegebenen Channel wieder auf.
	
	Wenn du der Channel-Founder bist, kannst du jeden
	ausloggen, jeder andere nur sich selbst.

CHAN_HELP_DROP
	Syntax: DROP channel
	
	Entfernt die Registrierung des angegebenen Channels.
	Kann nur vom Channel-Founder benutzt werden, 
	der sich vorher mit dem IDENTIFY zu erkennen
	geben muss.

CHAN_HELP_SET
	Syntax: SET channel option parameters
	
	Erlaubt es dem Channel-Founder bestimmte Optionen
	und Informationen des Channels zu ndern.
	
	Verfgbare Optionen:
	
	    FOUNDER       Stellt den Grnder des Channels ein
	    SUCCESSOR     Stellt den Vertreter des Founders ein
	    PASSWORD      ndert das Passwort des
	                     Channel-Founders
	    DESC          ndert die Channel-Beschreibung
	    URL           Verbindet eine URL mit dem Channel
	    EMAIL         Verbindet eine eMail-Adresse mit dem
	                     Channel
	    ENTRYMSG      Stellt eine Begrssungsmeldung des
	                     Channels ein
	    TOPIC         ndert das Topic im Channel
	    BANTYPE       ndert den Ban-Typ, den die Services
	                     in dem Channel anwenden
	    KEEPTOPIC     Topic behalten, wenn Channel nicht
	                     benutzt wird
	    TOPICLOCK     Topic kann nur durch TOPIC
	                     gendert werden
	    MLOCK         Channel-Modes fest einstellen
	    PRIVATE       Den Channel vom /LIST-Befehl verstecken
	    RESTRICTED    Eingeschrnkter Zugriff auf den Channel
	    SECURE        Aktiviert %S's Sicherheits-
	                     funktionen
	    SECUREOPS     Strengere Kontrolle des Op-Status im
	                     Channel
	    SECUREFOUNDER Strengere Kontrolle des Founder-Status
	    SIGNKICK      Kicks durch ChanServ in dem Channel
	                     werden durch den Kicker signiert
	    OPNOTICE      Sendet eine Notice wenn Op/Deop-Kommandos
	                     benutzt werden
	
	Tippe /msg %S HELP option fr weitere Informationen
	zu einem bestimmten Kommando.

CHAN_HELP_SET_FOUNDER
	Syntax: SET channel FOUNDER nick
	
	ndert den Grnder (Founder) eines Channels. Der neue
	Nick muss registriert sein.

CHAN_HELP_SET_SUCCESSOR
	Syntax: SET channel SUCCESSOR nick
	
	ndert den Vertreter des Grnders in dem Channel. Wenn
	der Nickname des Grnders ausluft oder gedropped wird,
	wenn der Channel registriert ist, wird der Vertreter
	der neue Grnder des Channels. Wenn jedoch der 
	Vertreter bereits zu viele Channels registriert hat
	(max %d), wird der Channel gedropped.
	
	Der Nickname des Vertreters muss registriert sein.

CHAN_HELP_SET_PASSWORD
	Syntax: SET channel PASSWORD password
	
	ndert das Passwort, dass dich als Founder (Grnder)
	des Channels identifiziert.

CHAN_HELP_SET_DESC
	Syntax: SET channel DESC description
	
	ndert die Beschreibung fr einen Channel, die bei
	dem LIST und INFO Kommando angezeigt wird.

CHAN_HELP_SET_URL
	Syntax: SET channel URL [url]
	
	Verbindet die angegebene URL mit dem Channel. Diese
	URL wird angezeigt, wenn jemand Informationen
	ber den Channel mit dem INFO Kommando abfragt.
	Wird kein Parameter angegeben, wird die aktuelle
	URL gelscht.

CHAN_HELP_SET_EMAIL
	Syntax: SET channel EMAIL [address]
	
	Verbindet die angegebene eMail-Adresse mit dem
	Channel. Diese eMail-Adresse wird angezeigt,
	wenn jemand Informationen ber den Channel mit
	dem INFO Kommando abfragt.
	Wird kein Parameter angegeben, wird die aktuelle
	eMail-Adresse gelscht.

CHAN_HELP_SET_ENTRYMSG
	Syntax: SET channel ENTRYMSG [message]
	
	ndert die Nachricht, die User beim Joinen des
	Channels per /notice bekommen. Wird kein Parameter
	angegeben, wird keine Nachricht beim Joinen 
	angezeigt.
	
CHAN_HELP_SET_BANTYPE
	Syntax: SET channel BANTYPE bantype
	
	Stellt den Ban-Typ fr den Channel ein, den die
	Services anwenden, wenn sie einen Ban eintragen
	(z.B. bei einem Auto-Kick).
	
	bantype muss einer der folgenden Werte sein:
	
	0: Ban in der Form *!user@host
	1: Ban in der Form *!*user@host
	2: Ban in der Form *!*@host
	3: Ban in der Form *!*user@*.domain

CHAN_HELP_SET_KEEPTOPIC
	Syntax: SET channel KEEPTOPIC {ON | OFF}
	
	Aktiviert oder deaktiviert die Topic Wiederherstellung fr
	den Channel. Wird diese Option eingeschaltet, wird das 
	Topic des Channels gespeichert durch %S; selbst wenn 
	der letzte User den Channel verlsst, wird es 
	wiederhergestellt sobald jemand wieder in den Channel 
	kommt.

CHAN_HELP_SET_TOPICLOCK
	Syntax: SET channel TOPICLOCK {ON | OFF}
	
	Aktiviert oder deaktiviert die topic lock-Option
	fr den angegebenen Channel.
	Wenn topic lock eingeschaltet ist, wird %S jede
	nderung des Topics verhindern/rckgngig machen,
	ausser es wurde durch TOPIC eingestellt.

CHAN_HELP_SET_MLOCK
	Syntax: SET channel MLOCK modes
	
	Stellt den Mode-Lock-Parameter fr den angegebenen
	Channel ein. %S ermglicht es dir, einzustellen,
	dass bestimmte Modi immer aus bzw an sein mssen.
	
	Die Modi die gelockt werden knnen sind i, k, l,
	m, n, p, s, and t; jede einzelne dieser Modi kann
	ein/aus oder gar nicht gelockt werden. Der modes Parameter 
	ist genauso aufgebaut wie das jeweilige /MODE Kommando; dies
	bedeutet, Modi die durch ein + gekennzeichnet sind, sind aktiviert;
	Durch ein - sind sie deaktiviert.
	
	Warnung:  Wenn du den Channel mit Hilfe des SET MLOCK
	Befehls mit einem Key (Passwort) schtzt, solltest du
	zustzlich die RESTRICTED Option fr den Channel ein-
	schalten (siehe HELP SET RESTRICTED), oder jeder der in
	diesen Channel kommt wenn er leer ist kann den Key sehen!
	
	Beispiele:
	
	    SET #channel MLOCK +nt-iklps
	        Erzwingt die Channel-Modi n und t auf an, die i,
	        k,l,p und s aus. Mode m wird nicht explizit gelockt
	        und kann wahlweise an oder ausgeschaltet werden.
	
	    SET #channel MLOCK +knst-ilmp mein-key
	        Erzwingt die Modi k, n, s und t an, die Modi i, l, m,
	        und p aus.  Weiterhin wird der Channel-Key fest auf
	        "mein-key" eingestellt.
	
	    SET #channel MLOCK +
	        Entfernt alle gelockten Channel-Modi; jeder Modus
	        kann nun wahlweise an- oder ausgeschaltet werden.

CHAN_HELP_SET_PEACE
	Syntax: SET channel PEACE {ON | OFF}

	Aktiviert oder deaktiviert die peace Option. Wenn
	peace aktiviert ist, kann ein User einen anderen User
	mit gleichem oder hherem Zugriffslevel nicht mehr per 
	%S  kicken, bannen oder dessen Channelstatus lschen.

CHAN_HELP_SET_PRIVATE
	Syntax: SET channel PRIVATE {ON | OFF}
	
	Schaltet den Privat-Modus fr einen Channel an
	oder aus. Wird er aktiviert, wird der Channel in der
	Ausgabe von/msg %S LIST nicht mehr auftauchen.

CHAN_HELP_SET_RESTRICTED
	Syntax: SET channel RESTRICTED {ON | OFF}
	
	Aktiviert oder deaktiviert den restricted access
	(beschrnkter Zugriff)-Modi fr einen Channel. Wenn 
	restricted access eingeschaltet ist, werden
	User die sonst keinen Channel Operator-Status besitzen
	wrden (Nicks mit negativem Zugriffslevel, oder wenn
	Secure Ops aktiv ist: Nicks die nicht auf der
	Zugriffsliste sind) vom Channel gekicked und gebanned.

CHAN_HELP_SET_SECURE
	Syntax: SET channel SECURE {ON | OFF}
	
	Aktiviert oder deaktiviert die Sicherheitsfunktionen
	von %S fr den angegebenen Channel. 
	Wird SECURE eingeschaltet, werden nur registrierte
	Nicks (durch %s) die per Passwort 
	identifiziert sind in den Channel gelassen, so wie es 
	in der Zugriffsliste des Channels steht.

CHAN_HELP_SET_SECUREOPS
	Syntax: SET channel SECUREOPS {ON | OFF}
	
	ndert die Secure-Ops Option fr einen Channel.
	Wird diese Option eingeschaltet, knnen Nicks, die nicht
	auf der Zugriffsliste des Channels stehen, keinen Op-Status
	erhalten.
	
CHAN_HELP_SET_SECUREFOUNDER
	Syntax: SET channel SECUREFOUNDER {ON | OFF}
	
	Aktiviert oder deaktiviert die Secure Founder-Option
	fr einen Channel.
	Wird diese Option eingeschaltet, kann nur der "echte"
	Grnder des Channels diesen DROPen, das Passwort und den
	Successor verndern; und nicht derjenige, der sich per
	IDENTIFY gegenber %S als Grnder (Founder) identifiziert
	hat.
	
CHAN_HELP_SET_SIGNKICK
	Syntax: SET channel SIGNKICK {ON | LEVEL | OFF}
	
	Aktiviert oder deaktiviert signierte Kicks fr einen
	Channel. Ist SIGNKICK aktiviert, wird der Reason
	eines Kicks der durch %S KICK ausgefhrt wurde, durch
	den Nicknamen des Kickers signiert.
	
	Wird LEVEL benutzt, werden Kicks durch Nicknamen
	deren Level grsser oder gleich dem SIGNKICK Level ist,
	nicht durch den Nicknamen signiert.
	Siehe /msg %S HELP LEVELS fr weitere Informationen.

CHAN_HELP_SET_XOP
	Syntax: SET channel XOP {ON | OFF}
	
	Aktiviert oder deaktiviert das xOP Listen System fr einen Channel.
	Wenn XOP aktiviert ist, musst du AOP/SOP/VOP
	Commands nutzen, um Zugriffslevel festlegen zu knnen. Andernfalls
	musst du das ACCESS Command nutzen.
	
	Technische Bemerkung: Wenn du vom Access zum xOP System 
	wechselst, werden die Zugriffslevel gendert, folglich wirst du
	nicht die selben Werte finden, wenn du zu Access zurckwechselst.
	
	Du solltest nach einem Wechsel zum xOP System darauf achten, 
	dass die User das richtige Level besitzen, da das Umwechseln
	auf Vermutung basiert und nicht immer perfekt funktioniert. 
	Es ist nicht empfohlen nach einer nderung der Levels das xOP
	System zu nutzen.
	
	Der Wechsel vom xOP System zum Access System fuktioniert
	jedoch fehlerfrei.

CHAN_HELP_SET_OPNOTICE
	Syntax: SET channel OPNOTICE {ON | OFF}
	
	Aktiviert oder deaktiviert die Op-Notice Option fr
	einen Channel.
	Wird Op-Notice eingeschaltet, sendet %S eine
	Notice an den Channel wenn OP oder DEOP Kommandos
	benutzt werden.

CHAN_HELP_AOP
	Syntax: AOP channel ADD nick
	        AOP channel DEL {nick | entry-num | list}
	        AOP channel LIST [mask | list]
	        AOP channel CLEAR
	
	Verwaltet die AOP (AutoOP) Liste eines Channels. Die 
	AOP Liste gibt Usern automatisch Operator Status in deinem
	und gibt ihnen das Recht die Commands UNBAN und INVITE.
	zu nutzen, beim Betreten des Channels werden die Greet
	Messages dieser User angezeigt, usw.

	Das AOP ADD Command fgt den jeweiligen Nick zur AOP Liste
	hinzu.
	
	Das AOP DEL Command lscht den jeweiligen Nick aus der
	AOP Liste. Wenn mehrere Eintragsnummern angegeben werden, 
	werden diese Eintrge gelscht.  (Siehe Beispiel bei LIST.)

	
	Das AOP LIST Command zeigt die aktuelle AOP Liste. Wenn
	Wildcard Masks angegeben werden, werden nur die betroffenen 
	Eintrge angezeigt. Werden mehrere Eintragsnummern angegeben,
	werden nur diese Eintrge angezeigt, zB:

	   AOP #channel LIST 2-5,7-9
	      Listet die AOP Eintrge 2 bis 5 und 7 bis 9.
	      
	Das AOP CLEAR Command lscht alle Eintrge der AOP Liste.
	
	AOP ADD und AOP DEL  sind auf SOPs beschrnkt, whrend
	AOP CLEAR nur vom Channel Founder genutzt werden kann.
	Jeder User auf der AOP Liste kann das AOP LIST Command nutzen.
	
	Dieses Command kann fr deinen Channel ausgeschaltet sein, in
	diesem Fall nutze bitte die Access Liste. Fr weitere Infos zur
	Access Liste, tippe bitte /msg %S HELP ACCESS und
	/msg %S HELP SET XOP fr Infos ber den Wechsel vom xOP und 
	vom Access System.

CHAN_HELP_HOP
	Syntax: HOP channel ADD nick
	        HOP channel DEL {nick | entry-num | list}
	        HOP channel LIST [mask | list]
	        HOP channel CLEAR
	
	Verwaltet die HOP (HalfOP) Liste eines Channels. User auf
	dieser Liste werden automatisch gehalfopt, wenn sie joinen.
	
	Das HOP ADD Command fgt den jeweiligen Nick zur HOP Liste
	hinzu.

	Das HOP DEL Command lscht den jeweiligen Nick aus der
	HOP Liste. Wenn mehrere Eintragsnummern angegeben werden,
	werden diese Eintrge gelscht.  (Siehe Beispiel bei LIST.)
	        
	
	Das HOP LIST Command zeigt die aktuelle HOP Liste. Wenn
	Wildcard Masks angegeben werden, werden nur die betroffenen
	Eintrge angezeigt. Werden mehrere Eintragsnummern angegeben,
	werden nur diese Eintrge angezeigt, zB:
	
	   HOP #channel LIST 2-5,7-9
	     Listet die HOP Eintrge 2 bis 5 und 7 bis 9.

	Das HOP CLEAR Command lscht alle Eintrge der HOP Liste.

	HOP ADD, HOP DEL und HOP LIST sind auf AOPs oder
	hher beschrnkt, whrend HOP CLEAR nur vom Founder genutzt
	werden kann.
	
	Dieses Command kann fr deinen Channel ausgeschaltet sein, in  
	diesem Fall nutze bitte die Access Liste. Fr weitere Infos zur
	Access Liste, tippe bitte /msg %S HELP ACCESS und
	/msg %S HELP SET XOP fr Infos ber den Wechsel vom xOP und
	vom Access System.
	
CHAN_HELP_SOP
	Syntax: SOP channel ADD nick
	        SOP channel DEL {nick | entry-num | list}
	        SOP channel LIST [mask | list]
	        SOP channel CLEAR
	
	Verwaltet die SOP (SuperOP) Liste eines Channels. Ein User
	in der SOP Liste besitzt die selben Rechte wie ein AOP und kann
	zustzlich die AutoKick und BadWord Listen bearbeiten, Channel-
	memos lesen und senden, usw. 
	
	Das SOP ADD Command fgt den jeweiligen Nick zur SOP Liste
	hinzu.

	Das SOP DEL Command lscht den jeweiligen Nick aus der
	SOP Liste. Wenn mehrere Eintragsnummern angegeben werden,
	werden diese Eintrge gelscht.  (Siehe Beispiel bei LIST.)
	
	            
	Das SOP LIST Command zeigt die aktuelle SOP Liste. Wenn
	Wildcard Masks angegeben werden, werden nur die betroffenen
	Eintrge angezeigt. Werden mehrere Eintragsnummern angegeben,
	werden nur diese Eintrge angezeigt, zB:

	   SOP #channel LIST 2-5,7-9
	      Listet die SOP Eintrge 2 bis 5 und 7 bis 9.
	
	Das SOP CLEAR Command lscht alle Eintrge der SOP Liste.

	SOP ADD, SOP DEL und SOP CLEAR sind auf den Channel-
	founder beschrnkt. SOP LIST kann von jedem AOP genutzt
	werden.
	
	Dieses Command kann fr deinen Channel ausgeschaltet sein, in  
	diesem Fall nutze bitte die Access Liste. Fr weitere Infos zur
	Access Liste, tippe bitte /msg %S HELP ACCESS und
	/msg %S HELP SET XOP fr Infos ber den Wechsel vom xOP und
	vom Access System.

CHAN_HELP_VOP
	Syntax: VOP channel ADD nick
	        VOP channel DEL {nick | entry-num | list}
	        VOP channel LIST [mask | list]
	        VOP channel CLEAR

	Verwaltet die VOP (Voice) Liste eines Channels.VOPs
	bekommen automatisch Voice, wenn sie den Channel betreten.

	Das VOP ADD Command fgt den jeweiligen Nick zur VOP Liste
	hinzu.

	Das VOP DEL Command lscht den jeweiligen Nick aus der
	VOP Liste. Wenn mehrere Eintragsnummern angegeben werden,
	werden diese Eintrge gelscht.  (Siehe Beispiel bei LIST.)


	Das VOP LIST Command zeigt die aktuelle VOP Liste. Wenn
	Wildcard Masks angegeben werden, werden nur die betroffenen
	Eintrge angezeigt. Werden mehrere Eintragsnummern angegeben,
	werden nur diese Eintrge angezeigt, zB:

	   VOP #channel LIST 2-5,7-9
	      Listet die VOP Eintrge 2 bis 5 und 7 bis 9.

	Das VOP CLEAR Command lscht alle Eintrge der VOP Liste.

	VOP ADD, VOP DEL und VOP LIST sind auf AOPs oder
	hher beschrnkt, wrend VOP CLEAR nur vom Channelfounder
	genutzt werden kann.
	
	Dieses Command kann fr deinen Channel ausgeschaltet sein, in
	diesem Fall nutze bitte die Access Liste. Fr weitere Infos zur
	Access Liste, tippe bitte /msg %S HELP ACCESS und
	/msg %S HELP SET XOP fr Infos ber den Wechsel vom xOP und
	vom Access System.

CHAN_HELP_ACCESS
	Syntax: ACCESS channel ADD nick level
	        ACCESS channel DEL {nick | entry-num | list}
	        ACCESS channel LIST [mask | list]
	        ACCESS channel CLEAR
	
	Verwaltet die Zugriffsliste fr einen Channel. Diese
	Liste sagt aus, welchem User Channel-Op-Status ermglicht
	oder wem Zugriff auf %S Kommandos des Channels
	freigeschaltet werden soll.
	
	Verschiedene Zugriffslevel bestimmen den Zugriff auf
	Privilegien, die dieser User dann im Channel besitzt;
	tippe /msg %S HELP ACCESS LEVELS fr weitere Infos.
	Jeder Nick, der nicht auf der Zugriffsliste steht, hat
	automatisch einen Level von 0.
	
	Das ACCESS ADD Kommando fgt einen Nick mit dem
	angegeben Level auf die Zugriffsliste ein; wenn der Nick
	schon auf der Liste steht, wird der Level nur gendert.
	Der angegebene level muss kleiner als der des Users
	sein, der diesen Befehl aufruft; und wenn der Nick schon
	auf der Zugriffsliste steht, muss sein aktueller Level
	ebenfalls kleiner sein, als von dem User, der den
	Befehl aufruft.
	
	Mit ACCESS DEL Kommando wird ein Nick von der Zugriffs-
	liste entfernt. Wenn eine Liste von Nummern angegeben wird,
	werden diese Eintrge entfernt (siehe die Beispiele
	fr LIST weiter unten).
	
	Das ACCESS LIST Kommando zeigt die Zugriffsliste eines
	Channels an. Wird eine Bereichsliste angegeben, werden die
	entsprechenden Eintrge angezeigt, zum Beispiel:
	
	   ACCESS #channel LIST 2-5,7-9
	      Zeigt Eintrge mit den Nummern 2 bis 5 und 
	      7 bis 9 an.
	      
	Durch ACCESS CLEAR werden alle Eintrge der
	Zugriffsliste entfernt.

CHAN_HELP_ACCESS_LEVELS
	User Zugriffslevel
	
	Standardmssig sind die Zugriffslevel wie folgt
	definiert:
	
	   Founder   (Grnder) vollstndiger Zugriff auf
	                   den Channel und alle dazugehrigen
	                   Funktionen durch %S; wird 
	                   automatisch mit Op-Status versehen beim 
	                   Joinen. Beachte dass nur eine Person den 
	                   Founder-Status besitzen kann (kann auch 
	                   nicht durch das ACCESS Kommando 
	                   erteilt werden).
	        10   Zugriff auf AKICK, hat Auto-Op.
	         5   Automatischer Op-Status.
	         3   Automatischer Voice-Status.
	         0   Keine speziellen Privilegien; kann durch
	                   andere Ops Channel-Operator werden
	                   (ausser Secure-Ops ist aktiv).
	        <0   Kann keinen Operator-Status erlangen.
	
	Neue Levels knnen Levels hinzugefgt oder verndert
	werden mit Hilfe des LEVELS Kommandos; tippe /msg 
	%S HELP LEVELS fr weitere Informationen.

CHAN_HELP_AKICK
	Syntax: AKICK channel ADD mask [reason]
	        AKICK channel DEL mask
	        AKICK channel LIST [mask]
	        AKICK channel VIEW [mask]
	        AKICK channel ENFORCE
	        AKICK channel CLEAR
	
	Verwaltet die AutoKick-Liste fr einen Channel.
	Wenn ein User joined, der auf der AutoKick-Liste steht,
	wird %S einen Ban auf den User setzen und ihn 
	dann kicken.
	
	Mit Hilfe von AKICK ADD kann man Nicks oder Hostmasken
	der AutoKick-Liste hinzufgen. Wird ein reason beim
	Befehl angegeben, wird dieser als Kick-Reason fr den
	User genutzt; ohne Reason wird standardmssig 
	"You have been banned from the channel" verwendet.
	
	Durch das AKICK DEL Kommando wird ein Eintrag von der
	AutoKick-Liste entfernt. Es entfernt jedoch nicht die Bans,
	die noch im Channel von ChanServ gesetzt sind; diese
	mssen manuell entfernt werden.

	Der AKICK STICK Befehl bannt die gegebenne Maske 
	dauerhft vom Channel. Falls jemand versucht, den Ban zu
	entfernen, wird %S ihn automatisch neu setzen. Kann
	nicht fr registrierte Nicks genutzt werden.
	
	Der AKICK UNSTICK Befehl macht den AKICK STICK
	Befehl wieder rckgngig, sodass der Ban wieder
	entfernt werden kann.
	
	Das AKICK LIST Kommando zeigt den Inhalt einer 
	AutoKick-Liste an; oder optional die Eintrge, die auf
	das angegebene Muster passen.
	
	Das Ergebnis von AKICK VIEW ist im Grunde das Gleiche
	wie das von AKICK LIST, jedoch werden mehr Informationen
	angezeigt.
	
	Durch AKICK ENFORCE wird %S gezwungen, die 
	aktuelle AutoKick-Liste auf den Channel anzuwenden 
	und User, die ein Muster der Liste treffen, zu entfernen.
	
	Das AKICK CLEAR Kommando entfernt alle Eintrge aus
	Der AutoKick-Liste.

CHAN_HELP_LEVELS
	Syntax: LEVELS channel SET type level
	        LEVELS channel {DIS | DISABLE} type
	        LEVELS channel LIST
	        LEVELS channel RESET
	
	
	Das LEVELS Kommando erlaubt eine feinere Regelung
	der Zugriffslevel eines Channels. Mit diesem Kommando
	kann man Zugriffslevel definieren, die die meisten
	Funktionen von %S abdecken. (SET FOUNDER und SET PASSWORD,
	genau wie dieses Kommando, sind beschrnkt auf den Channel-
	Founder.)
	
	LEVELS SET erlaubt einem Zugriffslevel eine nderung seiner
	Funktion bzw Gruppe von Funktionen. LEVELS DISABLE (oder 
	DIS als Abkrzung) deaktiviert eine automatische Funktion
	oder verweigert den Zugriff auf jeden anderen ausser den
	Channel-Founder.
	
	Durch LEVELS LIST werden die aktuellen Levels und ihre
	Funktionen aufgelistet. LEVELS RESET setzt alle Level auf
	die Standardwerte eines neu erzeugten Channels zurck
	(siehe HELP ACCESS LEVELS).
	
	Fr eine Auflistung der Funktionen, die diese Parameter 
	haben, siehe HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	Die folgenden Befehle/Funktionen werden untersttzt. 
	Beachte bitte, dass die hier angegebenen Level fr
	AUTODEOP und NOJOIN Maximum-Levels sind, alle anderen
	hingegegen sind Minimum-Level.

CHAN_HELP_LEVELS_DESC_FORMAT
	    %-*s  %s

CHAN_HELP_INFO
	Syntax: INFO channel [ALL]
	
	Zeigt Informationen ber einen registrierten Channel;
	seinen Grnder, das Datum der Registrierung, die
	letzte Nutzung, seine Beschreibung und Mode-Locks,
	wenn welche eingestellt sind. Wenn du als Founder
	(Grnder) identifiziert bist und den Parameter 
	ALL angibst, wird die Eintrittsmeldung und 
	die Successors (Vertreter) ebenfalls angezeigt.

CHAN_HELP_LIST
	Syntax: LIST pattern
	
	Listet alle registrierten Channels, die dem Muster
	entsprechen, auf. (Alle Channels mit aktiviertem
	PRIVATE-Flag werden nicht angezeigt.)

CHAN_HELP_OP
	Syntax: OP [#channel [nick]]
	
	Setzt den Operator-Status des angegebenen Nicks in
	dem Channel. Wird kein Nick angegeben, wird
	ChanServ dich oppen, vorausgesetzt, du hast die
	entsprechenden Rechte in der Zugriffsliste um
	diesen Befehl auszufhren.
	
	Standardmssig ist dafr ein Level von 5 oder
	grsser erforderlich.

CHAN_HELP_DEOP
	Syntax: DEOP [#channel [nick]]
	
	Entfernt den Operator-Status eines bestimmten Nicks in
	dem Channel. Wird kein Nick angegeben, wird ChanServ
	dich deoppen. Wird weder Channel noch Nick als Parameter
	bergeben, wird ChanServ dich in allen Channels deoppen
	in denen du die entsprechenden Rechte hast.
	
	Standardmssig ist dafr ein Level von 5 oder
	grsser erforderlich.
	
CHAN_HELP_VOICE
	Syntax: VOICE [#channel [nick]]
	
	Erteilt dem angegebenen Nick Voice-Status in dem
	Channel. Wird kein Nick angegeben, wird ChanServ dich
	voicen. Wird weder Channel noch Nick angegeben, wird
	ChanServ dich in allen Channels voicen, in denen du
	die entsprechenden Rechte hast.
	
	Standardmssig brauchst du dafr ein Level von 5
	um anderen Voice zu erteilen, oder Level 3 um dich
	selbst zu voicen.

CHAN_HELP_DEVOICE
	Syntax: DEVOICE [#channel [nick]]
	
	Entfernt den Voice-Status des Nicks in dem Channel.
	Wird kein Nick angegeben, wird ChanServ dich devoicen.
	Wird weder Channel noch Nick angegeben, wird ChanServ
	dich in allen Channels voicen, in denen du die
	entsprechenden Rechte hast.
	
	Standardmssig brauchst du dafr ein Level von 5
	um andere zu devoicen, oder Level 3 um dich selbst
	vom Voice-Flag zu befreien.
	
CHAN_HELP_HALFOP
	Syntax: HALFOP [#channel [nick]]
	
	Setzt den Half-Op-Status des angegebenen Nicks in dem
	Channel. Wird kein Nick angegeben, wird ChanServ dich
	halfoppen. Wird weder Channel noch Nick angegeben,
	wird ChanServ dich in allen Channels halfoppen, in denen
	du die entsprechenden Rechte hast.
	
	Standardmssig brauchst du dafr ein Level von 5
	um andere zu halfoppen, oder Level 4 um dich selbst zu
	halfoppen.

CHAN_HELP_DEHALFOP
	Syntax: DEHALFOP [#channel [nick]]
	
	Entfernt den Half-Op-Status des angegebenen Nicks in dem
	Channel. Wird kein Nick angegeben, wird ChanServ dich
	dehalfoppen. Wird weder Channel noch Nick angegeben,
	wird ChanServ dich in allen Channels dehalfoppen, in denen
	du die entsprechenden Rechte hast.
	
	Standardmssig brauchst du dafr ein Level von 5
	um andere zu dehalfoppen, oder Level 4 um dich selbst zu
	dehalfoppen.
	
CHAN_HELP_PROTECT
	Syntax: PROTECT [#channel [nick]]
	
	Beschtzt den angegebenen Nick in dem Channel. Wird kein
	Nick angegeben, wird ChanServ dich beschtzen. Wird weder
	Nick noch Channel angegeben, wird ChanServ dich in allen
	Channels beschtzen in denen du die entsprechenden
	Rechte hast.
	
	Standardmssig lsst sich diese Funktion vom Founder
	aufrufen oder von denjenigen mit Level 10 und grsser, 
	die den Schutz auf sich selbst anwenden.

CHAN_HELP_DEPROTECT
	Syntax: DEPROTECT [#channel [nick]]
	
	Entfernt den Schutz auf den angegebenen Nick in dem Channel.
	Wird kein Nick angegeben, wird ChanServ dich nicht mehr
	beschtzen. Wird weder Nick noch Channel angegeben, wird
	ChanServ dich in allen Channels nicht lnger schtzen,
	in denen du die entsprechenden Rechte hast.
	
	Standardmssig lsst sich diese Funktion vom Founder
	aufrufen oder von denjenigen mit Level 10 und grsser,
	die den Schutz von sich selbst aufheben wollen.
	
CHAN_HELP_OWNER
	Syntax: OWNER [#channel]
	
	Gibt dir Owner Status im Channel. Fr den Fall, dass
	kein Channel angegeben wird, wird dir in jedem Channel,
	in dem du ausreichend Rechte besitzt, Owner Status
	gegeben.
	
	Bentigt Founder Zugriffslevel im jeweiligen Channel.

CHAN_HELP_DEOWNER
	Syntax: DEOWNER [#channel]
	
	Nimmt dir Owner Status im Channel. Fr den Fall, dass    
	kein Channel angegeben wird, wird dir in jedem Channel,        
	in dem du ausreichend Rechte besitzt, Owner Status 
	genommen.
	
	Bentigt Founder Zugriffslevel im jeweiligen Channel.

CHAN_HELP_INVITE
	Syntax: INVITE channel
	
	Diese Funktion erlaubt es dir, dich durch %S in den
	angegebenen Channel einladen zu lassen. Standardmssig
	wird dies nur ausgefhrt, wenn den Nick auf der 
	Zugriffsliste des Channels einen Level grsser 0 hat.

CHAN_HELP_UNBAN
	Syntax: UNBAN channel
	
	Durch %S werden alle Bans entfernt, die dich am joinen
	des Channels hindern. Eine Vorraussetzung dafr ist
	allerdings, dass dein Level in dem Channel grsser als
	0 ist.
	
CHAN_HELP_KICK
	Syntax: KICK [#channel [nick [reason]]]
	
	Kickt den ausgewhlten Nick aus dem Channel. Wird
	kein Nick angegeben, wird ChanServ dich (!) kicken.
	Wenn weder Nick noch Channel angegeben werden, wird
	ChanServ dich aus allen Channels kicken, in denen
	du die entsprechenden Rechte hast.
	
	Standardmssig ist fr diese Funktion ein Level
	von mindestens 5 erforderlich.

CHAN_HELP_BAN
	Syntax: BAN [#channel [nick [reason]]]
	
	Bannt einen Nick im Channel. Falls kein Nick angegeben
	wird, wirst du gebannt. Falls kein Nick und kein Channel
	angegeben werden, wirst du in allen Channels gebannt,
	vorausgesetzt du hast die ntige Berechtigung.
	
	Standardmssig auf AOPs oder User mit Access Level 5 oder
	hher beschrnkt.

CHAN_HELP_TOPIC
	Syntax: TOPIC channel [topic]
	
	Veranlasst %S ein Topic im Channel zu setzen. Falls topic
	nicht angegeben wird, wird ein leeres Topic gesetzt. Dieses
	Command ist vor allem in Verbindung mit SET TOPICLOCK
	ntzlich. Tippe /msg %S HELP SET TOPICLOCK fr weitere
	Informationen.
	
	Standardmssig auf Founder beschrnkt. 

CHAN_HELP_CLEAR
	Syntax: CLEAR channel what
	
	Sagt %S, dass es bestimmte Einstellungen 
	in einem Channel zurcksetzen soll. Die Option 
	kann eine der folgenden sein:
	
	     MODES    Setzt alle Modes in dem Channel zurck.
	                  (z.B. Mode i,k,l,m,n,p,s und t)
	     BANS     Entfernt alle Bans in dem Channel
	     EXCEPTS  Entfernt alle Excepts in dem Channel
	     OPS      Entfernt jeden Operator-Status (mode +o)
	                  in dem Channel.
	     VOICES   Entfernt alle Voice-Flags (mode +v) in 
	                  dem Channel.
	     USERS    Entfernt (kickt) alle User aus dem Channel.
	
	Standardmssig muss dein Zugriffslevel in diesem Channel
	mindestens 10 betragen.
	
CHAN_HELP_GETKEY
	Syntax: GETKEY channel
	
	Liefert den Key des angegebenen Channels zurck. Dieses
	Kommando wird am hufigsten von Bots und/oder Skripten
	genutzt, daher wird das Ergebnis in dieser Form
	zurckgeliefert:
	
	KEY <channel> <key>
	
	key ist "NO KEY", wenn kein Key eingestellt ist.
	
CHAN_HELP_SENDPASS
	Syntax: SENDPASS channel
	
	Sendet das Passwort des angegebenen Channels an die
	eMail-Adresse, die dem Founder in der Datenbank
	assoziiert ist. Dieses Kommando ist sehr ntzlich,
	wenn man mit dem Problem des vergessenen Passwortes
	konfrontiert wird.
	
	Kann in einigen Netzen auf IRC Operatoren beschrnkt
	sein.
	
	Dieses Kommando ist nicht verfgbar, wenn die
	Datenbank verschlsselt gespeichert wird.

CHAN_SERVADMIN_HELP
	
	Die folgenden Kommandos sind zustzlich fr
	Services Admins verfgbar:
	
	    GETPASS    Liest das Passwort des Channel-Founders
	                  aus der Datenbank aus (wenn die
	                  Verschlsselung deaktiviert ist)
	    FORBID     Verhindert die Nutzung eines Channels
	    STATUS     Liefert das Zugriffslevel eines Users
	                  in dem Channel
	
	Services Admins knnen weiterhin beliebige Channels
	DROPen, Zugriffslisten oder Channel-Einstellungen
	ansehen ohne sich vorher fr den Channel identifizieren
	zu mssen.
	
CHAN_SERVADMIN_HELP_LOGOUT
	Syntax: LOGOUT channel [nickname]
	
	Durch dieses Kommando wird dich ChanServ nicht mehr als
	identifiziert fr den angegebenen Channel betrachten.
	
	Wenn du der Founder (Grnder) dieses Channels bist, kannst
	du jeden ausloggen, ansonsten nur dich selbst.
	
	Bist du ein Services Admin, kannst du jeden des
	angegebenen Channels ausloggen, ohne Founder-Rechte
	des Channels zu besitzen. Weiterhin musst du den
	Parameter Nickname nicht unbedingt angeben; dies hat zur
	Folge, dass jeder Nick aus dem Channel ausgeloggt wird.

CHAN_SERVADMIN_HELP_DROP
	Syntax: DROP channel
	
	Entfernt die Registrierung des angegebenen Channels aus
	der Datenbank; zustzlich werden Zugriffslisten, 
	Einstellungen usw mit aus der Datenbank entfernt.	
	
	Nur Services Admins knnen Channel DROPen, ohne
	sich vorher gegenber dem Channel als Founder zu
	identifizieren.

CHAN_SERVADMIN_HELP_SET
	
	Services Admins knnen zustzlich die Option NOEXPIRE
	an einem Channel setzen; dies verhindert den automatischen
	Auslauf des Channels.
	
	Weiterhin knnen Services Admins Einstellungen eines 
	Channels verndern, ohne sich vorher fr ihn
	identifizieren zu mssen.

CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	Syntax: SET channel NOEXPIRE {ON | OFF}
	
	ndert das NOEXPIRE-Flag an einem Channel. Wird es
	auf ON gestellt, wird der Channel bei Nichtnutzung
	nicht auslaufen.
	
	Diese Funktion ist beschrnkt auf Services Admins.

CHAN_SERVADMIN_HELP_INFO
	
	Services Admins knnen den ALL Parameter bei jedem
	Channel benutzen.

CHAN_SERVADMIN_HELP_LIST
	Syntax: LIST pattern [FORBIDDEN] [NOEXPIRE]
	
	Zeigt alle registrierten Channels die auf das angegebene
	Muster (Pattern) treffen.
	Channels mit aktivierter PRIVATE Option werden nur Services
	Admins angezeigt. Channels mit aktivem NOEXPIRE werden in der
	Liste ein ! vor dem Eintrag haben.
	
	Wird FORBIDDEN oder NOEXPIRE angegeben, werden nur Channels
	mit dem entsprechenden Flag angezeigt. Werden beide Optionen
	angegeben, werden nur Channels angezeigt, die mindestens eins
	der entsprechenden Flags gesetzt haben. Diese Funktionen sind
	beschrnkt auf Services Admins.

CHAN_SERVADMIN_HELP_GETPASS
	Syntax: GETPASS channel
	
	Liest das Founder-Passwort des angegebenen Channels 
	aus der Datenbank von ChanServ aus.
	Beachte dass wenn jemand dieses Kommando nutzt,
	diese Aktion im Logbuch der Services vermerkt wird.
	Zustzlich wird eine Nachricht an alle Oper per
	WALLOPS/GLOBOPS ausgesandt.
	
	Beschrnkt auf Services Admins.

CHAN_SERVADMIN_HELP_FORBID
	Syntax: FORBID channel [reason]
	
	Verbietet die Nutzung bzw die Registrierung des
	angegebenen Channels. 
	Die Wirkung wird wieder aufgehoben durch DROPen
	des Channels.
	
	Bei einigen Netzen muss evtl ein Grund angegeben
	werden.
	
	Beschrnkt auf Services Admins.

CHAN_SERVADMIN_HELP_SUSPEND
	Syntax: SUSPEND channel [reason]
	
	Verbietet jegliche Nutzung des Channels. Kann durch
	das UNSUSPEND Command wieder aufgehoben werden,
	wobei alle vorherigen Einstellungen wieder bernommen
	werden.
	
	Reason kann auf manchen Networks notwendig sein.
	
	Beschrnkt auf Services admins.

CHAN_SERVADMIN_HELP_UNSUSPEND
	Syntax: UNSUSPEND channel
	
	Gibt einen Channel, der auf SUSPEND gesetzt ist,
	wieder frei. Alle vorherigen Einstellungen werden
	bernommen.

	Beschrnkt auf Services admins.

CHAN_SERVADMIN_HELP_STATUS
	Syntax: STATUS channel nickname
	
	Liefert den Zugriffslevel des angegebenen Nick aus dem
	Channel. Die Antwort erfolgt in dieser Form:
	
	    STATUS channel nickname access-level
	
	Tritt ein Fehler auf, wird die Antwort in dieser Form
	zurckgeliefert:
	
	    STATUS ERROR error-message
	
	Beschrnkt auf Services Admins.

###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP
	%S ist eine Einrichtung, die es erlaubt, 
	dass sich IRC User untereinander kurze Textnachrichten 
	senden; egal ob die Empfnger zu dem Zeitpunkt online 
	sind oder nicht.
	Als Empfnger knnen auch Channels angegeben werden (*).
	
	Sowohl der Nick des Senders als auch Empfngers mssen
	registriert sein, um eine Memo versenden zu knnen.
	
	%S's Kommandos beinhalten:
	
	    SEND   Sendet eine Memo an einen Nick oder Channel
	    CANCEL Annulliert deine letzte gesendete Memo
	    LIST   Erzeugt eine Liste deiner Memos
	    READ   Lesen einer oder mehrerer Memos
	    DEL    Lschen einer oder mehrerer Memos
	    SET    Stellt bestimmte Optionen ein in Hinsicht
	             auf Memos
	    INFO   Zeigt Informationen bezglich deiner Memos an

MEMO_HELP_ADMIN
	    SENDALL  Sendet eine Nachricht an alle registrierten 
	    User.

MEMO_HELP_OPER
	    STAFF  Sendet allen opers/admins eine Nachricht.

MEMO_HELP_FOOTER
	
	Type /msg %S HELP command fr hilfe bei jedem der
	oben aufgefhrten Befehle.

	(*) Bei der Standarteinstellung kann jeder User mit einem 
	    Access-Level auf den Channel von 10 oder hher die 
	    Channel-Nachrichten lesen. Dies kann mit dem
	    %s LEVELS Befehl gendert werden.

MEMO_HELP_SEND
	Syntax: SEND {nick | channel} memo-text
	
	Sendet an nick oder channel die Memo mit dem
	Inhalt memo-text.  Wird an einen Nicknamen 
	gesendet, erhlt der Empfnger eine Notice, dass
	er/sie eine neue Memo hat.
	Der Empfnger (Nick/Channel) muss registriert sein.
	
MEMO_HELP_CANCEL
	Syntax: CANCEL {nick | channel}
	
	Widerruft die letzte Memo die du an den angegebenen Nick
	oder Channel gesendet hast, vorrausgesetzt sie ist noch
	nicht gelesen worden.

MEMO_HELP_LIST
	Syntax: LIST [channel] [list | NEW]
	
	Fhrt alle Memos auf, die du im Moment gespeichert hast.
	Mit dem Parameter NEW werden nur neue, ungelesene, Memos
	aufgelistet. Ungelesene Memos sind durch ein "*" markiert,
	links neben ihrer Nummer. Du kannst auch einen Bereich
	von Nummern definieren; siehe das Beispiel:
	
	   LIST 2-5,7-9
	      Zeigt Memos mit den Nummern 2 bis 5 und 7 bis 9.

MEMO_HELP_READ
	Syntax: READ [channel] {num | list | LAST | NEW}
	
	Schickt dir den Inhalt der Memo, die du lesen mchtest.
	Wird LAST angegeben, bekommst du die Memo die du als 
	letztes erhalten hast. Mit NEW werden dir alle neuen,
	ungelesenen, Memos geschickt. 
	
	Andernfalls kannst du auch mit Hilfe der Memo-Nummer
	num oder einer Bereichsliste dir Memos anzeigen
	lassen, zum Beispiel so:
	
	   READ 2-5,7-9
	      Zeigt den Inhalt der Memos 2 bis 5 und 7 bis 9.

MEMO_HELP_DEL
	Syntax: DEL [channel] {num | list | LAST | ALL}
	
	Entfernt Memos aus deinem Postfach. Du kannst mehrere
	Nummern oder Bereiche angeben anstatt einer einzelnen
	Nummer; wie das zweite Beispiel zeigt.
	
	Wird LAST angegeben, wird die letzte Memo gelscht.
	Wird ALL angegeben, werden alle deine Memos
	entfernt.
	
	Beispiele:
	
	   DEL 1
	      Lscht dein Memo mit der Nummer 1.
	
	   DEL 2-5,7-9
	      Lscht Memos mit den Nummern 2 bis 5 und 7 bis 9.

MEMO_HELP_SET
	Syntax: SET option parameters
	
	Stellt verschiedene Optionen bezglich der Memos ein.
	option kann einer der Parameter sein:
	
	    NOTIFY      Stellt ein, wann du benachrichtigt wirst,
	                   wenn du eine neue Memo bekommst.
	
	    LIMIT       ndert die maximale Anzahl Memos, die
	                   du empfangen kannst.
	
	Tippe /msg %S HELP SET option fr weitere Infos
	ber eine bestimmte Option.

MEMO_HELP_SET_NOTIFY
	Syntax: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	ndert den Zeitpunkt, wann MemoServ dich ber neue
	eingegangene Memos informiert:
	
	    ON      Du wirst ber neue Nachrichten informiert,
	              wenn du dich identifizierst, /AWAY aufhebst,
	              und wenn sie an dich gesandt werden.
	    LOGON   Du wirst nur benachrichtigt, wenn du dich
	              identifizierst oder das /AWAY rckgngig
	              machst.
	    NEW     Du wirst nur informiert, wenn sie an dich
	              gesendet werden.
	    OFF     Es wird keine Benachrichtigung ber neue
	              Memos stattfinden.
	
	ON ist eine Kombination aus LOGON und NEW.

MEMO_HELP_SET_LIMIT
	Syntax: SET LIMIT [channel] limit
	
	ndert das Limit der Anzahl der Memos, die du
	(oder der angegebene Channel) haben darf. Wird dies auf
	0 gesetzt, kann dir niemand mehr Memos senden.
	Du kannst es jedoch auch nicht hher als %d setzen.

MEMO_HELP_INFO
	Syntax: INFO [channel]
	
	Zeigt Informationen ber die Anzahl der Memos die du
	hast, wie viele davon ungelesen sind und wie viele
	du max. empfangen kannst. Mit angegebenem Parameter
	wird die gleiche Information ber den Channel angezeigt.

MEMO_SERVADMIN_HELP_SET_LIMIT
	Syntax: SET LIMIT [user | channel] {limit | NONE} [HARD]
	
	ndert die max. Anzahl von Memos die ein User oder
	Channel haben kann. Das setzen dieser Grenze auf 0
	verhindert das Empfangen jeglicher Memos; wird 
	hingegen NONE eingestellt, kann der User so
	viele Memos empfangen und behalten wie er will.
	Wird kein User oder Channel angegeben, vernderst
	du dein eigenes Limit.
	
	Durch den Zusatzparameter HARD wird eine nderung
	des Limits durch den entsprechenden User verhindert.
	Wird dieser Parameter nicht angegeben, hat das den
	gegenteiligen Effekt - der User kann sein Limit 
	ndern (sogar wenn das vorherige Limit auf 
	HARD eingestellt war).
	
	Die Nutzung des SET LIMIT Kommandos ist beschrnkt
	auf Services Admins. Jeder andere User kann nur das
	Limit von sich selbst oder dem Channel ndern, in dem
	er einen entsprechenden Zugriffslevel besitzt; er kann
	auch nicht die Grenze von %d Memos berschreiten.
	Das HARD Kommando kann er auch nicht nutzen.

MEMO_SERVADMIN_HELP_INFO
	Syntax: INFO [nick | channel]
	
	Ohne Parameter werden Informationen ber dein Postfach
	angezeigt; die Anzahl Memos die du hast, die davon neu
	bzw ungelesen sind, und wie viele Memos du max.
	empfangen kannst.
	
	Mit einem Channel als Parameter werden die entsprechenden
	Informationen ber den Channel angezeigt.
	
	Wird eine Nickname bergeben, werden die entsprechenden
	Informationen ber den Nicknamen angezeigt. Diese
	Funktion ist beschrnkt auf Services Admins.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_STAFF
	Syntax: STAFF memo-text

	Sendet allen Usern mit Zugriff auf die Services eine Nachricht mit
	dem memo-text.
	Note: Wenn du Operatoren ion beide der Services-Zugriffs-Listen 
	(oper und admin) hast, so werden diese alle diese Nachricht erhalten. 
	Das gleichte trifft fr die Operatoren auf der Root-Liste zu.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_SENDALL
	Syntax: SENDALL memo-text

	Sends allen registrieten Usern eine Nachricht mit dem 
	memo-text.

###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP
	Kommandos von %S:
	    GLOBAL      Eine Notice an alle User schicken
	    STATS       Status des Netzes und der Services anzeigen
	    OPER LIST   Alle Services Operatoren anzeigen
	    ADMIN LIST  Alle Services Admins anzeigen
	    STAFF       Display Services staff and online status

OPER_HELP_OPER_CMD
	Kommandos, auf die nur Services Operatoren und
	Services Admins Zugriff haben:
	    MODE        Channel-Modes ndern
	    KICK        Einen User aus einem beliebigen
	                   Channel kicken
	    CLEARMODES  Die Modes eines Channels zurcksetzen
	    KILLCLONES  Kill all users that have a certain host
	    AKILL       Die AutoKill-Liste bearbeiten
	    SGLINE      Die SGLINE-Liste bearbeiten
	    SZLINE      Die SZLINE-Liste bearbeiten

OPER_HELP_ADMIN_CMD
	Kommandos, auf die nur Services Admins Zugriff haben:
	    SESSION     Hosts mit einer bestimmten Anzahl
	                   Verbindungen auflisten
	    EXCEPTION   Bearbeiten der Liste der
	                   eingeschrnkten Verbindungen
	    KILLCLONES  Alle User mit einem bestimmten Host killen
	    CHANLIST    Alle registrierten Channel anzeigen
	    USERLIST    Alle registrierten Nicks anzeigen
	    OPER        Die Services Operatoren Liste bearbeiten
	    LOGONNEWS   Logon News bearbeiten
	    OPERNEWS    Oper News bearbeiten
	    NOOP        Alle O:-Lines temporr deaktivieren
	    JUPE        Einen Server "jupitern"
	    IGNORE      die Services Ignore Liste bearbeiten
	    UMODE       User Modes ndern
	    OLINE       einem User Operflags setzen
	    SET         Verschiedene Services Optionen einstellen
	    UPDATE      Die Services Datenbnke sofort speichern
	    RELOAD      Die Konfigurationsdatei neu einlesen
	    QUIT        Services _ohne_ Speichern der Datenbanken
	                   beenden
	    RESTART     Datenbanken speichern und Services
	                   neustarten
	    SHUTDOWN    Datenbanken speichern und Services beenden

	Kommando, auf die nur Services Roots (diese sind
	fest in der services.conf eingetragen) Zugriff haben:
	    ADMIN       Liste der Services Admins bearbeiten

OPER_HELP_ROOT_CMD
	Commands available to Serivces Roots only:
	    MODLOAD     Ldt ein Module
	    MODUNLOAD   Entfernt ein Module
	    MODLIST     Listet die geladenen Module auf
	    MODINFO     Info ber ein geladenes Module

OPER_HELP_LOGGED
	Achtung: Alle Kommandos die an %S gesendet werden,
	werden geloggt!

OPER_HELP_GLOBAL
	Syntax: GLOBAL message
	
	Ermglicht es IRCops eine Nachricht an alle User auf
	dem Netzwerk zu senden. Die Nachricht wird als
	Absender %s tragen.

OPER_HELP_STATS
	Syntax: STATS [AKILL | ALL | RESET]
	
	Wird keine Option angegeben, wird eine kurze Statistik
	ausgegeben. Sie enthlt die aktuelle Anzahl verbundener
	User, IRCops (inklusive den Services), die max. Anzahl
	gleichzeitig verbundener User seitdem die Services
	gestartet wurde und die Uptime.
	
	Mit der AKILL Option, wird die aktuelle Grsse der
	AutoKill-Liste ausgegeben und dessen standardmssige
	Auslaufzeit.
	
	Die ALL Option ist nur fr Services Admins verfgbar;
	sie zeigt unter anderem den aktuellen Speicherverbrauch
	der Services. Dieses Kommando kann auf einem grossen
	Netzwerk dazu fhren, dass die Services fr kurze
	Zeit nicht mehr ansprechbar sind, also bertreib es nicht.
	
	Durch RESET werden einige Werte der Statistik zurck-
	gesetzt, unter anderem die max. Anzahl gleichzeitig
	verbundener User.
	
	UPTIME kann als Synonym fr STATS verwendet
	werden.

OPER_HELP_OPER
	Syntax: OPER ADD nick
	        OPER DEL {nick | entry-num | list}
	        OPER LIST [mask | list]
	        OPER CLEAR
	
	Erlaubt es Services Admins bestimmte Nicks in die Liste
	der Services Opers aufnehmen oder zu entfernen. Ein
	User der sich fr diesen Nick gegenber %s 
	identifiziert hat und auf der Liste der Services Opers 
	ist, hat Zugriff auf die Kommandos von OperServ.
	
	Mit OPER ADD wird der angegebene Name auf die Liste der
	Services Operatoren hinzugefgt.
	
	Durch OPER DEL wird der angegebene Nick von der Liste
	entfernt. Wird ein Bereich von Zahlen bergeben, werden
	die entsprechenden Eintrge gelscht. (Siehe das Beispiel
	fr LIST weiter unten.)
	
	Das OPER LIST Kommando zeigt den Inhalt der Liste der
	Services Operatoren. Wird eine Maske mit Platzhaltern
	(Wildcards) angegeben, werden die entsprechenden Eintrge 
	angezeigt. Wird eine Zahlenbereich angegeben, werden
	ebenfalls nur die entsprechenden Eintrge angezeigt,
	zum Beispiel:
	
	   OPER LIST 2-5,7-9
	      Zeigt die Eintrge 2 bis 5 und 7 bis 9 aus
	      der Services Operatoren-Liste.
	
	Durch OPER CLEAR werden alle Eintrge aus dieser Liste
	entfernt.
	
	Jeder IRC Operator kann das OPER LIST Kommando verwenden;
	alle weiteren sind beschrnkt auf Services Admins.

OPER_HELP_ADMIN
	Syntax: ADMIN ADD nick
	        ADMIN DEL {nick | entry-num | list}
	        ADMIN LIST [mask | list]
	        ADMIN CLEAR
	
	Erlaubt es Services Roots bestimmte Nicks in die Liste
	der Services Admins aufnehmen oder zu entfernen. Ein
	User der sich fr diesen Nick gegenber %s
	identifiziert hat und auf der Liste der Services Admins
	ist, hat Zugriff auf die Admin Kommandos von OperServ.
	
	Mit ADMIN ADD wir der angegebene Name auf die Liste der
	Services Admins hinzugefgt.
	
	Durch ADMIN DEL wird der angegebene Nick von der Liste
	entfernt. Wird ein Bereich von Zahlen bergeben, werden
	die entsprechenden Eintrge gelscht. (Siehe das Beispiel
	fr LIST weiter unten.)
	
	Das ADMIN LIST Kommando zeigt den Inhalt der Liste der
	Services Admins. Wird eine Maske mit Platzhaltern
	(Wildcards) angegeben, werden die entsprechenden Eintrge
	angezeigt. Wird eine Zahlenbereich angegeben, werden
	ebenfalls nur die entsprechenden Eintrge angezeigt,
	zum Beispiel:
	
	   ADMIN LIST 2-5,7-9
	      Zeigt die Eintrge 2 bis 5 und 7 bis 9 aus der
	      Liste der Services Admins.
	
	Mit Hilfe von ADMIN CLEAR wird die Liste der Services
	Admins komplett geleert.
	
	Jeder IRC Operator kann das Kommando ADMIN LIST nutzen, 
	jegliches andere Kommando kann nur von einem Services Root
	aufgerufen werden.

OPER_HELP_IGNORE
	Syntax: IGNORE {ADD|DEL|LIST|CLEAR} [time] [nick]

	Erlaubt es Services Admins einen Nick eine bestimmte Zeit
	oder bis zum nchsten Restart von den Services ignorieren
	zu lassen. Das Standard Zeit Format ist Sekunden, du kannst
	es aber ber Units bestimmen. Zulssige Units sind: s fr
	Sekunden, m fr Minuten, h fr Stunden und d fr Tage.
	Kombinationen dieser Units sind nicht erlaubt. Um einen User
	permanent ignorieren zu lassen, tippe 0 als Zeit.

	Beschrnkt auf Services Admins.

OPER_HELP_MODE
	Syntax: MODE channel modes
	
	Erlaubt es Services Operatoren die Channel Modes eines
	beliebigen Channels zu verndern. Der Paramater hat das
	gleiche Format wie der normale /MODE Befehl.
	
	Beschrnkt auf Services Operatoren.

OPER_HELP_UMODE
	Syntax: UMODE user modes
	
	Erlaubt es Services Admins die Usermodes eines beliebigen
	Users zu ndern. Der Paramater hat das gleiche Format wie 
	der normale /MODE Befehl.
	
	Beschrnkt auf Services Admins.

OPER_HELP_OLINE
	Syntax: OLINE user flags
	
	Erlaubt es Services Admins einem User Operflags zu setzen.
	Den Flags muss ein "+" oder ein "-" vorangestellt werden. 
	Um alle Operflags zu entfernen, nutze einfach ein "-" ohne
	Operflags.

	Beschrnkt auf Services Admins.

OPER_HELP_CLEARMODES
	Syntax: CLEARMODES channel [ALL]
	
	Entfernt alle Modes (i,k,l,m,n,p,s,t) und Bans eines
	Channels. Wird ALL angegeben, werden ebenfalls alle
	Op-Flags und Voices (+o und +v Modi) entfernt.
	
	Beschrnkt auf Services Operatoren.

OPER_HELP_KICK
	Syntax: KICK channel user reason
	
	Erlaubt es IRCops einen User aus einem beliebigen
	Channel zu kicken. Die Parameter sind dieselben
	wie fr das normale /KICK Kommando.
	Die Kick-Nachricht wird den Nick des IRCops
	vor dem Reason haben; zum Beispiel:
	
	*** SpamMan has been kicked off channel #my_channel by %S (chemical (Flood))
	
	Beschrnkt auf Services Operators.

OPER_HELP_SVSNICK
	Syntax: SVSNICK nick newnick
	
	Erzwingt die nderung des Nicks eines User zu dem neuen Nick.
	
	Beschrnkt auf Services admins

OPER_HELP_AKILL
	Syntax: AKILL ADD [+expiry] mask reason
	        AKILL DEL {mask | entry-num | list}
	        AKILL LIST [mask | list]
	        AKILL VIEW [mask | list]
	        AKILL CLEAR
	
	Erlaubt es Services Operatoren die AutoKill-Liste zu
	bearbeiten. Versucht ein User zu connecten der einen
	entsprechenden Eintrag auf der AKILL-Liste hat, werden
	die Services ihn killen und, falls der Server dies
	untersttzt, einen Ban (K-line) fr den User setzen.
	
	AKILL ADD fgt die angegebene user@host-Maske mit
	dem reason (dieser muss angegeben werden) zur AKILL-
	Liste hinzu. Mit Hilfe von expiry lsst sich eine bestimmte
	Auslaufzeit dieses Eintrags definieren.
	expiry wird durch eine Ganzzahl angegeben, gefolgt von
	einem Buchstaben:
	d (Tage), h (Stunden), oder m (Minuten). Kombinationen
	(wie zum Beispiel 1h30m) sind nicht zulssig. Wird kein
	Buchstabe angegeben, wird von Tagen ausgegangen (also +30 
	bedeutet dann z.B. 30 Tage). Um einen AKILL-Eintrag zu
	erstellen, der nicht ausluft, benutze +0.  Fngt die Usermaske
	mit einem + an, muss eine Auslaufzeit (expiry) definiert
	werden, auch wenn es die Standard-Zeit ist. Die Standard-
	Auslaufzeit fr einen AKILL kann man unter STATS AKILL finden.
	
	Das AKILL DEL Kommando entfernt die angegebene Maske von
	der AKILL-Liste, sofern ein solcher Eintag existiert. Wird
	eine Liste von Nummern angegeben, werden diese Eintrge
	entfernt. (Siehe das Beispiel fr LIST weiter unten.)
	
	Mit Hilfe von AKILL LIST wird die AKILL Liste angezeigt.
	Werden Platzhalter (Wildcards) in der Maske angegeben, werden
	nur die entsprechenden Eintrge angezeigt. Die Ausgabe
	lsst sich ebenfalls durch einen Zahlenbereich begrenzen, 
	wie das Beispiel zeigt:
	
	   AKILL LIST 2-5,7-9
	      Zeigt nur die Eintrge 2 bis 5 und 7 bis 9.
	
	AKILL VIEW ist eine ausfhrlichere Version des AKILL LIST
	Kommandos und zeigt zustzlich, wer einen Eintrag wann 
	erstellt hat, wann er ausluft und natrlich die user@host
	Maske mit dem Grund.
	
	AKILL CLEAR entfernt alle Eintrge aus der AKILL-Liste.
	
	Beschrnkt auf Services Operatoren.
	
OPER_HELP_SGLINE
	Syntax: SGLINE ADD [+expiry] mask:reason
	    SGLINE DEL {mask | entry-num | list}
	        SGLINE LIST [mask | list]
	        SGLINE VIEW [mask | list]
	        SGLINE CLEAR
	
	Erlaubt es Services Operatoren die SGLINE-Liste zu
	bearbeiten. Versucht ein User zu connecten dessen
	Realname auf einen Eintrag in der SGLINE-Liste trifft,
	werden die Services ihn den Connect auf das IRC Netz
	nicht ausfhren lassen.
	
	SGLINE ADD fgt die angegebene Realnamen-Maske mit 
	dem Grund (muss angegeben werden) zur SGLINE-Liste 
	hinzu. Mit Hilfe von expiry lsst sich eine bestimmte
	Auslaufzeit dieses Eintrags definieren.
	expiry wird durch eine Ganzzahl angegeben, gefolgt von
	einem Buchstaben:
	d  (Tage), h (Stunden), oder m (Minuten). Kombinationen
	(wie zum Beispiel 1h30m) sind nicht zulssig.  Wird kein
	Buchstabe angegeben, wird von Tagen ausgegangen (also +30 
	bedeutet dann z.B. 30 Tage). Um einen SGLINE-Eintrag zu
	erstellen, der nicht ausluft, benutze +0. Beginnt
	die Realnamen-Maske mit einem +, an, muss eine 
	Auslaufzeit (expiry) definiert werden, auch wenn es die 
	Standard-Zeit ist. Die Standard-Auslaufzeit fr eine
	SGLINE kann man unter STATS AKILL finden.
	
	Beachte: Da die Realnamen-Maske Leerzeichen enthalten kann,
	ist das Trennzeichen zwischen der Maske und dem Reason
	ein Doppelpunkt.

	Das SGLINE DEL Kommando entfernt die angegebene Maske
	von der SGLINE-Liste, sofern ein solcher Eintag existiert.
	Wird eine Liste von Nummern angegeben, werden diese
	Eintrge entfernt. (Siehe das Beispiel fr LIST weiter
	unten.)
	
	Mit Hilfe von SGLINE LIST wird die SGLINE-Liste 
	angezeigt. Werden Platzhalter (Wildcards) in der Maske
	angegeben, werden nur die entsprechenden Eintrge
	angezeigt. Die Ausgabe lsst sich ebenfalls durch einen
	Zahlenbereich begrenzen, wie das Beispiel zeigt:
	
	   SGLINE LIST 2-5,7-9
	      Zeigt nur die Eintrge 2 bis 5 und 7 bis 9.
	
	SGLINE VIEW ist eine ausfhrlichere Version des 
	SGLINE LIST Kommandos und zeigt zustzlich, wer einen 
	Eintrag wann erstellt hat, wann er ausluft und 
	natrlich die user@host Maske mit dem Grund.
	
	SGLINE CLEAR entfernt alle Eintrge aus der 
	SGLINE-Liste.
	
	Beschrnkt auf Services Operatoren.

OPER_HELP_SQLINE
	Syntax: SQLINE ADD [+expiry] mask reason
	        SQLINE DEL {mask | entry-num | list}
	        SQLINE LIST [mask | list]
	        SQLINE VIEW [mask | list]
	        SQLINE CLEAR
	
	Erlaubt Services Operatoren die SQLINE Liste zu bearbeiten.
	Falls ein User mit passendem Nick versucht, zu connecten,
	werden die Services ihn den Connect nich ausfhren lassen.
	
	Wenn der erste Buchstabe ein # ist, werden die Services die
	Nutzung des betreffenden Channels nicht zulassen (bei IRCds,
	die dieses Feature untersttzen).
	
	SQLINE ADD fgt den angegeben Nick mit dem Grund (muss
	angegeben werden) zur SGLINE-Liste hinzu. ^_expiry^_ wird
	durch eine Ganzzahl angegeben, gefolgt von einem Buchstaben: 
	d (Tage), h (Stunden), oder m (Minuten).
	Kombinationen sind nicht erlaubt. Wird kein Buchstabe angegeben,
	wird von Tagen ausgegangen (also +30 bedeutet 30 Tage).
	Um einen SQLINE-Eintrag zu erstellen, der nicht ausluft,
	benutze+0.  
	Beginnt die Maske mit einem +, muss eine Auslaufzeit
	(expiry) definiert werden, auch wenn es die Standard-Zeit ist. 
	Die Standard-Auslaufzeit fr eine SQLINE kann man unter
	STATS AKILL finden.
	    
	Das SQLINE DEL Command entfernt die betreffende Maske von
	der SQLINE Liste.  Wird eine Liste von Nummern angegeben,
	werden diese Eintrge entfernt. (Siehe das Beispiel fr LIST 
	weiter unten.)
	
	Mit Hilfe von SQLINE LIST wird die SQLINE-Liste angezeigt.
	Werden Wildcards in der Maske angegeben, werden nur die
	entsprechenden Eintrge angezeigt. Die Ausgabe lsst sich
	ebenfalls durch einen Zahlenbereich begrenzen:

	   SQLINE LIST 2-5,7-9
	      Zeigt die SQLINE Eintrge 2 bis 5 und 7 bis 9 an.

	SQLINE VIEW ist eine ausfhrlichere Version von SQLINE LIST
	und zeigt an, wer eine SQLINE gesetzt hat, das Datum und wann
	diese ausluft, ausserdem die Mask und den Grund.
	
	SQLINE CLEAR lscht alle Eintrge der SQLINE Liste.
	
	Beschrnkt auf Services Operatoren.

OPER_HELP_SZLINE
	Syntax: SZLINE ADD [+expiry] mask reason
	        SZLINE DEL {mask | entry-num | list}
	        SZLINE LIST [mask | list]
	        SZLINE VIEW [mask | list]
	        SZLINE CLEAR
	
	Erlaubt es Services Operatoren die SZLINE-Liste zu
	bearbeiten. Versucht ein User zu connecten dessen
	IP auf einen entsprechenden Eintrag auf der SZLINE-
	Liste passt, wird der Server seine IRC Verbindung
	verhindern (unabhngig davon, ob die IP einen
	PTR-Record hat oder nicht.)
	
	SZLINE ADD fgt die angegebene IP-Maske mit dem
	Reason (muss angegeben werden) zur SZLINE-Liste 
	hinzu. Mit Hilfe von expiry lsst sich eine bestimmte
	Auslaufzeit dieses Eintrags definieren.
	expiry wird durch eine Ganzzahl angegeben, gefolgt von
	einem Buchstaben:
	 d (Tage), h (Stunden), oder m (Minuten). Kombinationen
	(wie zum Beispiel 1h30m) sind nicht zulssig. Wird kein
	Buchstabe angegeben, wird von Tagen ausgegangen (also +30 
	bedeutet dann z.B. 30 Tage). Um einen SZLINE-Eintrag zu
	erstellen, der nicht ausluft, benutze +0. Fngt die
	IP-Maske mit einem  + an, muss eine Auslaufzeit
	(expiry) definiert werden, auch wenn es die Standard-Zeit
	ist. Die Standard-Auslaufzeit fr eine SZLINE kann man 
	unter STATS AKILL finden.
	
	Das SZLINE DEL Kommando entfernt die angegebene Maske
	von der SZLINE-Liste, sofern ein solcher Eintag existiert. 
	Wird eine Liste von Nummern angegeben, werden diese Eintrge
	entfernt. (Siehe das Beispiel fr LIST weiter unten.)
	
	Mit Hilfe von SZLINE LIST wird die SZLINE-Liste angezeigt.
	Werden Platzhalter (Wildcards) in der Maske angegeben, werden
	nur die entsprechenden Eintrge angezeigt. Die Ausgabe
	lsst sich ebenfalls durch einen Zahlenbereich begrenzen,
	wie das Beispiel zeigt:
	
	   SZLINE LIST 2-5,7-9
	      Zeigt nur die Eintrge 2 bis 5 und 7 bis 9.
	
	SZLINE VIEW ist eine ausfhrlichere Version des
	SZLINE LIST Kommandos und zeigt zustzlich, wer einen
	Eintrag wann erstellt hat, wann er ausluft und natrlich
	die IP Maske mit dem Grund.
	
	SZLINE CLEAR entfernt alle Eintrge aus der SZLINE-Liste.
	
	Beschrnkt auf Services Operatoren.

OPER_HELP_SET
	Syntax: SET option setting
	
	ndert globale Einstellungen der Services Optionen.
	Diese Optionen lassen sich ndern:
	
	    READONLY   Nur-Lese Modus der Datenbank an
	                      oder aus
	    LOGCHAN    Zeigt Logmessages in einem Chan
	    DEBUG      Debug-Modus der Services an oder
	                      aus
	    NOEXPIRE   Den Auslauf-Modus der Services
	                      an oder aus
	    SUPERADMIN Den Super-Admin Modus an oder aus
	
	Beschrnkt auf Services Admins.

OPER_HELP_SET_READONLY
	Syntax: SET READONLY {ON | OFF}
	
	Schaltet den Read-Only-Mode an oder aus. Im
	Read-Only-Modus knnen normale User nichts mehr
	an den Datenbanken der Services ndern, dies beinhaltet
	Channel und Nicknamen-Zugriffslisten, etc. IRCops mit
	gengend Rechten werden weiterhin nderungen an der
	AKILL-Liste, Nicknamen sperren oder DROPen drfen;
	aber diese nderungen werden nicht gespeichert, bis
	der Read-Only-Mode deaktiviert wurde bevor die
	Services beendet oder neu gestartet werden.
	
	Diese Option ist quivalent mit der Befehlszeilen-
	Option -readonly.

OPER_HELP_SET_LOGCHAN
	Syntax: SET LOGCHAN {ON | OFF}

	Mit dieser Option senden die Services alle Logeintrge zum
	angegebenen Channel. LogChannel muss in der Services Config
	Datei aktiviert sein.

	Anmerkung: Diese Option kann ein groes Sicherheitsproblem
	               darstellen, wenn der Logchannel nicht ausreichend
	               gesichert ist.

OPER_HELP_SET_DEBUG
	Syntax: SET DEBUG {ON | OFF | num}
	
	Schaltet den Debug-Modus an oder aus. Wird der aktiviert,
	werden alle Daten von/an die Services gesendet werden
	(und ein paar anderen Debug-Meldungen) in ein Logfile
	geschrieben. Wird num angegeben, wird der Debugging
	Level auf num gesetzt.
	
	Diese Option ist quivalent mit der Befehlszeilen-
	Option -debug.
	
OPER_HELP_SET_NOEXPIRE
	Syntax: SET NOEXPIRE {ON | OFF}
	
	Setzt den No-Expire-Mode an oder aus. Wird er
	aktiviert, werden Nicks, Channels und AKILLs nicht
	auslaufen bis dieser Modus wieder ausgeschaltet
	wird.

	Diese Option ist quivalent mit der Befehlszeilen-
	Option -noexpire.

OPER_HELP_SET_SUPERADMIN
	Syntax: SET SUPERADMIN {ON | OFF}

	Der Super-Admin Modus verleiht dir zustzliche Rechte, wie
	zB. Founder in jedem Channel, etc.

	Dieser Modus ist nicht dauerhaft und sollte nur genutzt
	werden, wenn er wirklich gebraucht wird. Danach sollte er
	sofort wieder ausgeschaltet werden.

OPER_HELP_NOOP
	Syntax: NOOP SET server
	        NOOP REVOKE server
	
	NOOP SET entfernt temporr alle O:Lines des 
	angegebenen Servers und killt alle IRCops die 
	gegenwrtig auf diesem verbunden sind, und verhindert 
	so das rehashen des Servers (dieses wrde die Funktion
	aufheben).
	
	NOOP REVOKE macht alle O:Lines wieder verfgbar auf
	dem angegebenen Server.
	
	Achtung: Der Server wird in keinster Weise
	von den Services geprft.
	
	Beschrnkt auf Services Admins.

OPER_HELP_JUPE
	Syntax: JUPE server [reason]

	Durch die Services wird ein Server "gejupitert". Dies
	bedeutet, dass ein Server vorgetuscht und so der
	echte Server daran gehindert wird, zu connecten. Der
	"Server" kann durch das normale SQUIT-Kommando
	entfernt werden. Wird ein Grund (reason) angegeben,
	wird dieser im Server Informationsfeld angezeigt,
	ansonsten nur "Jupitered by <nick>".
	
	Beschrnkt auf Services Admins.

OPER_HELP_RAW
	Syntax: RAW text
	
	Sendet die Zeichenkette von text direkt an den Server,
	zu denen die Services verbunden sind. Dieses Kommando
	hat einen sehr beschrnkten Nutzenfaktor, und kann
	leicht den Ablauf des Netzes stren, wenn es falsch
	benutz wird. BENUTZE DIESES KOMMANDO NICHT so lange
	du nicht genau weisst, was du tust!
	
	Beschrnkt auf Services Admins.

OPER_HELP_UPDATE
	Syntax: UPDATE
	
	Erzwingt die Services, sofort alle Datenbanken auf der
	Festplatte zu aktualisieren.
	
	Beschrnkt auf Services Admins.
	
OPER_HELP_RELOAD
	Syntax: RELOAD
	
	Die Services werden bei diesem Befehl die Konfigurations-
	datei neu einlesen. Beachte das fr einige Direktiven
	trotzdem ein Neustart der Services erforderlich ist, um
	sie wirksam zu machen (so wie die Services Nicknamen,
	Aktivierung der Verbindungseinschrnkungen, etc.)
	
	Beschrnkt auf Services Admins.

OPER_HELP_QUIT
	Syntax: QUIT
	
	Zwingt die Services, sich sofort zu beenden; die
	Datenbanken werden dabei nicht gespeichert.
	Dieses Kommando sollte nicht benutzt werden, ausser
	die Datenbanken sollen wirklich nicht aktualisiert
	werden. Fr das normale Beenden der Services sollte
	das Kommando SHUTDOWN benutzt werden.
	
	Beschrnkt auf Services Admins.

OPER_HELP_SHUTDOWN
	Syntax: SHUTDOWN
	
	Die Services werden durch dieses Kommando normal
	beendet und die Datenbanken werden gespeichert.
	
	Beschrnkt auf Services Admins.

OPER_HELP_RESTART
	Syntax: RESTART
	
	Die Services werden sich bei diesem Kommando beenden,
	die Datenbanken speichern, und danach neustarten
	(die ausfhrbare Datei erneut aufrufen).
	
	Beschrnkt auf Services Admins.	

OPER_HELP_KILLCLONES
	Syntax: KILLCLONES nick
	
	Killt alle User die den gleichen Hostnamen haben wie
	nick. Ein temporrer AKILL, in der Form *@host
	wird ebenfalls aktiviert, dass die Klone daran hindert,
	sofort neu zu connecten. Es wird zustzlich eine
	wallops gesendet, die alle Oper darber informiert,
	wer das Kommando genutzt hat und wieviele Hosts
	betroffen waren. Es ist ntzlich, wenn man mehrere
	Klones vom Netz entfernen mchte.
	
	Beschrnkt auf Services Admins.
	
OPER_HELP_CHANLIST
	Syntax: CHANLIST [{pattern | nick} [SECRET]]
	
	Zeigt alle Channel an, die augenblicklich benutzt werden, 
	egal ob sie registriert sind oder nicht.
	
	Wird ein Muster (pattern) angegeben, werden nur die 
	dem Muster entsprechenden Channel angezeigt. Wird ein 
	Nickname angegeben, werden nur die Channels aufgelistet, 
	in denen sich der User mit dem Nick befindet. Wird
	zustzlich der Parameter SECRET angegeben, werden nur 
	Channel aufgelistet, die Mode +s oder Mode +p gesetzt
	haben.
	
	Beschrnkt auf Services Admins.
	
OPER_HELP_USERLIST
	Syntax: USERLIST [{pattern | channel} [INVISIBLE]]
	
	Listet alle User auf, die gerade im IRC Netzwerk sind; egal ob
	ihr Nick registriert ist oder nicht.
	
	Wird ein Muster (pattern) angegeben, werden nur die User
	angezeigt, auf die das Muster passt (es muss im Format
	nick!user@host sein).  Wird ein Channel angegeben, werden
	nur die User angezeigt, die in diesem Channel sind. Wird
	zustzlich INVISIBLE angegeben, werden nur User mit dem Flag
	+i angezeigt.
	
	Beschrnkt auf Services Admins.
	
###########################################################################
#
# BotServ help messages
#
###########################################################################
	
OPER_HELP_CACHE
	Syntax: CACHE DEL hostname
	        CACHE LIST pattern [QUEUED | ALL]
	
	Das CACHE DEL Command lscht den angegeben Hostnamen aus dem
	Cache. Dieses Command ist ausschlielich fr DEBUG Zwecke.

	Das CACHE LIST Command listet alle Proxies auf, die dem
	angegebenen Muster entsprechen. Falls die QUEUED Option
	mitangegeben wird, werden alle Scans in der Warteschlange und
	alle Scans die gerade laufen, angezeigt. Wenn die ALL Option 
	mitangegeben wird, werden alle Hostnamen aufgelistet.
	
	Beschrnkt auf Services admins.

###########################################################################
#
# BotServ help messages
#
###########################################################################
	
OPER_HELP_MODLOAD
	Syntax: MODLOAD FileName

	Dieser Befehl ldt das benannte Module aus dem 
	modules - Verzeichnis.
	

	Beschrnkt auf Services Roots.

OPER_HELP_MODUNLOAD
	Syntax: MODUNLOAD FileName

	Dieser befehl entfernt das benannte Module aus dem 
	modules - Verzeichnis.

	Beschrnkt auf Services Roots.

OPER_HELP_MODINFO
	Syntax: MODINFO FileName

	Dieser Befehl listet Information ber das benannte geladene 
	Module auf.

	Beschrnkt auf Services Roots.

OPER_HELP_MODLIST
	Syntax: MODLIST

	Listet alle derzeit geladenen Module auf.

	Beschrnkt auf Services Roots.


###########################################################################
#
# BotServ help messages
#
###########################################################################
	
BOT_HELP
	%S ist dafr geschaffen, Bots in Channels 
	einzubringen. Geschaffen wurde er fr User, die
	selber keinen Bot aufetzen knnen, oder auch Netzwerke,
	die Bots verbieten. Mgliche Befehle siehe unten, 
	die Syntax ist /msg %S command.  
	
	Fr weitere Hilfe zu einem bestimmten Kommando
	tippe /msg %S HELP Kommando
	
	    BOTLIST       Zeigt alle vorhandenen Bots
	    ASSIGN        Weist einem Channel einen Bot zu
	    SET           Konfiguriert die Bot-Optionen
	    KICK          Konfiguriert den Kicker (s.u.)
	    BADWORDS      Verwaltet die Bad-Word-Liste	
	
	Weitere Kommandos: ACT, INFO, SAY, UNASSIGN
	
	Ein Bot betritt den Channel erst, wenn sich %d User 
	in diesem befinden.
	
BOT_HELP_BOTLIST
	Syntax: BOTLIST
	
	Zeigt alle verfgbaren Bots des Netzwerkes.
	
BOT_HELP_ASSIGN
	Syntax: ASSIGN chan nick
	
	Weist einem Channel einen Bot zu. Nick muss in diesem 
	Fall ein existierender Bot sein. Nach dieser Zuweisung 
	knnen die Channel-spezifischen Einstellungen des
	Bots angepasst werden.
	
BOT_HELP_UNASSIGN
	Syntax: UNASSIGN chan
	
	Lscht die Zuweisung eines Bots zu einem Channel.
	Dieses Kommando bewirkt, dass der Bot den Channel
	nicht mehr joined. Die Konfiguration des Bots fr den 
	Channel bleibt jedoch erhalten, so dass der Bot dem
	Channel wieder zugewiesen werden kann, ohne dass 
	alle Einstellungen verloren gehen.

BOT_HELP_INFO
	Syntax: INFO {chan | nick}
	
	Zeigt %S Informationen ber einen Bot oder einen Channel
	an. Wenn der Parameter ein Channel ist, so werden 
	Informationen wie aktive Kicks etc. angezeigt, wenn 
	der Parameter ein Nick ist, so werden Infos wie 
	Erstellungsdatum oder Anzahl der Channel angezeigt.

BOT_HELP_SET
	Syntax: SET channel option parameters
	
	Konfiguriert Optionen fr einen Bot.
	option kann folgende Werte annehmen:
	
	    DONTKICKOPS      Chan-Ops werden (nicht) vom Bot 
	                        gekicked.
	    DONTKICKVOICES   Gevoicete User werden (nicht) 
	                        vom Bot gekickt.
	    GREET            Eintrittsmeldung
	    FANTASY          Kommandos wie !op !deop usw. 
	                        aktivieren
	    SYMBIOSIS        Bot bernimmt die Aufgaben vom 
	                        ChanServ
	
	/msg %S HELP SET option fr weitere Informationen
	ber ein spezifisches Kommando.
	
	Achtung: Die Berechtigungsstufen fr diese Kommandos
	knnen variieren!

BOT_HELP_SET_DONTKICKOPS
	Syntax: SET channel DONTKICKOPS {ON|OFF}
	
	Aktiviert / deaktiviert die Op Protection in einem
	Channel. Wenn aktiviert, werden Ops nicht vom
	Bot gekickt, auch wenn sie nicht das NOKICK-Level
	haben.

BOT_HELP_SET_DONTKICKVOICES
	Syntax: SET channel DONTKICKVOICES {ON|OFF}
	
	Aktiviert / deaktiviert die Voice Protection in einem
	Channel. Wenn aktiviert, werden Ops nicht vom
	Bot gekickt, auch wenn sie nicht das NOKICK-Level
	haben.

BOT_HELP_SET_FANTASY
	Syntax: SET channel FANTASY {ON|OFF}
	
	Aktiviert oder deaktiviert den fantasy in einem
	channel. Wenn dieser aktiviert ist, ist es Usern
	mglich, die Kommandos !op, !deop, !voice, !devoice,
	!kick, !kb, !unban, !seen und !halfop im channel zu 
	benutzen. Die Kommandos sind selbsterklrend, 
	probiert's halt mal aus, mit oder ohne Nick.
	
	Hinweis: Auch hier bentigt der ausfhrende User
	die Rechte, um die Kommandos zu benutzen, und zwar
	sowohl das Level um Fantasy zu nutzen, als auch
	ein Level bz Mode, mit dem er hndisch das gegebene 
	Kommando ausfhren knnte. (Beispiel: Jemand, 
	der kein Op ist, kann auch niemanden mit !op oppen.)
	
BOT_HELP_SET_GREET
	Syntax: SET channel GREET {ON|OFF}
	
	Aktiviert oder deaktiviert den Greet Mode
	in einem Channel. Wenn aktiviert, zeigt der Bot
	eine Eintrittsmeldung bei joinenden Usern, die eine
	Msg definiert haben und weiterhin auch die 
	Berechtigung haben, dass diese angezeigt wird.
	
BOT_HELP_SET_SYMBIOSIS
	Syntax: SET channel SYMBIOSIS {ON|OFF}
	
	Aktiviert oder deaktiviert den symbiosis Mode.
	Wenn aktiviert fhrt der Bot alle Aktionen aus,
	die sonst %s bernimmt. 
	(Modechanges, Kicks, Eintrittsmeldungen usw.)
	
BOT_HELP_KICK
	Syntax: KICK channel option parameters
	
	Konfiguriert die Kicks des Bots
	option kann folgende Werte annehmen:
	
	    BOLDS         Bot kickt bei fettem Schriftstil (Bold)
	    BADWORDS      Bot kickt bei Bad words
	    CAPS          Bot kickt bei CAPS (Grossschrift)
	    COLORS        Bot kickt bei Farben
	    FLOOD         Bot kickt Flooder
	    REPEAT        Bot kickt User, die sich wiederholen.
	    REVERSES      Bot kickt bei invertiertem Schriftstil
	    UNDERLINES    Bot kickt bei Unterstreichungen
	
	/msg %S HELP KICK option fr weitere 
	Informationen ber ein spezifisches Kommando
	
	Achtung: Die Berechtigungsstufen fr diese Kommandos
	knnen variieren!

BOT_HELP_KICK_BOLDS
	Syntax: KICK channel BOLDS {ON|OFF} [ttb]
	
	Kicken bei fettem Schriftstil an oder aus. Wenn 
	der Parameter ON gegeben ist, werden User, die fetten 
	Schriftstil verwenden, durch den Bot gekickt.
	
	ttb beschreibt wie oft der User gekicked wird, bevor
	er einen Ban bekommt. Wenn keine ttb angegeben 
	wird, wird er nie gebannt.

BOT_HELP_KICK_COLORS
	Syntax: KICK channel COLORS {ON|OFF} [ttb]
	
	Kicken bei Farben an oder aus. Wenn der Parameter
	ON gegeben ist, werden User, die Farben verwenden,
	durch den Bot gekickt.
	
	ttb beschreibt wie oft der User gekicked wird, bevor
	er einen Ban bekommt. Wenn keine ttb angegeben 
	wird, wird er nie gebannt.

BOT_HELP_KICK_REVERSES
	Syntax: KICK channel REVERSES {ON|OFF} [ttb]
	
	Kicken bei invertiertem Schriftstil an oder aus. 
	Wenn der Parameter ON gegeben ist, werden User, die 
	invertierten Schriftstil verwenden, durch den Bot 
	gekickt.
	
	ttb beschreibt wie oft der User gekicked wird, bevor
	er einen Ban bekommt. Wenn keine ttb angegeben 
	wird, wird er nie gebannt.

BOT_HELP_KICK_UNDERLINES
	Syntax: KICK channel UNDERLINES {ON|OFF} [ttb]
	
	Kicken bei Unterstreichungen an oder aus. Wenn der 
	Parameter ON gegeben ist, werden User, die 
	Unterstreichungen verwenden, durch den Bot gekickt.
	
	ttb beschreibt wie oft der User gekicked wird, bevor
	er einen Ban bekommt. Wenn keine ttb angegeben 
	wird, wird er nie gebannt.

BOT_HELP_KICK_CAPS
	Syntax: KICK channel CAPS {ON|OFF} [ttb [min [percent]]]
	
	Kicken bei CAPS an oder aus. Wenn der Parameter
	ON gegeben ist, werden User, die CAPS verwenden,
	durch den Bot gekickt.
	
	Der Bot kickt nur, wenn mindestens min Grossbuchstaben
	verwendet wurden und der Text mindestens percent%% 
	Grossbuchstaben enthlt. (Standard ist hier zehn Zeichen und
	25 %% - dieser wird angewendet, wenn die Paramter nicht
	angegeben werden.
	
	ttb beschreibt wie oft der User gekicked wird, bevor
	er einen Ban bekommt. Wenn keine ttb angegeben 
	wird, wird er nie gebannt.

BOT_HELP_KICK_FLOOD
	Syntax: KICK channel FLOOD {ON|OFF} [ttb [ln [secs]]]
	
	Schaltet den Flood-Kicker an oder aus. Wenn er 
	aktiviert ist, kickt er User, die den Channel 
	mit mindestens ln Zeilen in secs flooden.
	Sollte weder ln noch secs angegeben sein,
	so werden defaultmssig 6 Zeilen / 10 Sekunden 
	gesetzt.
	
	ttb beschreibt wie oft der User gekicked wird, bevor
	er einen Ban bekommt. Wenn keine ttb angegeben 
	wird, wird er nie gebannt.

BOT_HELP_KICK_REPEAT
	Syntax: KICK #channel REPEAT {ON|OFF} [ttb [num]]
	
	Schaltet den Wiederholungs-Kicker an oder aus.
	Wenn aktiviert, wird ein User, der sich num mal
	wiederholt, gekickt. Sollte kein num angegeben
	sein, so wird 3 als Standardwert gesetzt
	
	ttb beschreibt wie oft der User gekicked wird, bevor
	er einen Ban bekommt. Wenn keine ttb angegeben 
	wird, wird er nie gebannt.

BOT_HELP_KICK_BADWORDS
	Syntax: KICK #channel BADWORDS {ON|OFF} [ttb]
	
	Schaltet den Bad-Word-Kicker an oder aus. Wenn er 
	aktiviert ist, kickt der er den Bsewicht, der ein Wort
	aus der Bad-Word-Liste sagt.
	
	Die Bad-Words werden mit dem BADWORDS 
	Kommando festgelegt.
	/msg %S HELP BADWORDS fr weitere 
	Informationen.
	
	ttb beschreibt wie oft der User gekicked wird, bevor
	er einen Ban bekommt. Wenn keine ttb angegeben 
	wird, wird er nie gebannt.
	
BOT_HELP_BADWORDS
	Syntax: BADWORDS channel ADD word [SINGLE | START | END]
	        BADWORDS channel DEL {word | entry-num | list}
	        BADWORDS channel LIST [mask | list]
	        BADWORDS channel CLEAR
	
	Verwaltet die Bad-Word-List eines Channels.
	
	In dieser Liste sind Wrter gespeichert, bei denen der
	entsprechende User aus dem Channel gekickt wird, wenn er 
	eines dieser Wrter erwhnt.
	
	Fr mehr Informationen: /msg %S HELP KICK BADWORDS.
	
	Das Kommando BADWORDS ADD fgt Wrter zur
	Bad-Word-Liste hinzu. Wenn das Wort mit dem Paramter
	SINGLE angeben wird, so wird ein User nur dann gekickt,
	wenn er das ganze Wort sagt. Mit dem Parametern
	END / START wird der User gekickt, wenn er ein Wort sagt,
	das mit dem angegebenen Wort anfngt / endet.
	
	Wenn keine Parameter angegeben werden, wird der User,
	sobald er das angegebene Wort in irgendeiner Kombination
	sagt, gekickt.
	
	BADWORDS DEL lscht Eintrge von der Bad 
	Word Liste. Auch hier gibt es die Mglichkeit, mehrere
	Eintrge auf einmal zu lschen (siehe BADWORDS LIST)
	
	BADWORDS LIST zeigt Eintrge der Bad Word Liste.
	Wildcards wie auch Bereiche werden interpretiert, z.B:
	
	BADWORDS #channel LIST 2-5,7-9
	Zeigt die Eintrge 2-5 und 7-9 der Bad Word List an.
	      
	BADWORDS CLEAR lscht alle Eintrge aus der
	Bad Word List.

BOT_HELP_SAY
	Syntax: SAY channel text
	
	Der Bot sagt den eingegebenen Text auf dem angegebenen Channel.

BOT_HELP_ACT
	Syntax: ACT channel text
	
	Bringt den Bot dazu, /me text auf dem angegebenen Channel auszugeben.

BOT_SERVADMIN_HELP
	
	Das folgende Kommando ist nur fr Services-Admins verfgbar:
	
	    BOT              Verwaltung der Bots

BOT_SERVADMIN_HELP_BOT
	Syntax: BOT ADD nick user host real
	        BOT CHANGE oldnick newnick [user [host [real]]]
	        BOT DEL nick
	        BOT LIST
	
	Erlaubt Services-Admins Bots zu erstellen/verndern/lschen,
	die die User in Ihren Channeln benutzen knnen.
	
	BOT ADD fgt einen Bot mit dem angegebenen Nick, User-, 
	Host und Realnamen hinzu. 
	BOT CHANGE ndert Attribute eines Bots wie Host, Nick usw.
	BOT DEL lscht den angegebenen Bot von der Botliste.  
	BOT LIST ist ein Alias fr BOTLIST und zeigt alle
	im Netz verfgbaren Bots an.
	
	Achtung: Wenn ein Bot erstellt wird, dessen Nick 
	registriert ist, wird dieser Nick gedropped. 
	Weiterhin wird, falls ein User mit diesem Nick 
	momentan online ist, dieser gekilled.

BOT_SERVADMIN_HELP_SET
	
	Diese Optionen sind nur durch Services Admins nutzbar:
	
	    NOBOT            Mit dieser Option kann man 
	                         einen Channel keinen Bot 
	                         zuweisen und alle aktuellen 
	                         Zuweisungen aufheben.
	
BOT_SERVADMIN_HELP_SET_NOBOT
	Syntax: SET channel NOBOT {ON|OFF}
	
	Durch diese Option kann einem Channel explizit kein Bot 
	zugewiesen werden. Sollte dem Channel, fr den diese 
	Option gewhlt wird, bereits ein Bot zugewiesen 
	sein, so verfllt die Zuweisung.
	
	Beschrnkt auf Services Admins.
BOT_SERVADMIN_HELP_SET_PRIVATE
	Syntax: SET bot-nick PRIVATE {ON|OFF}
	
	Verhindert, dass der Bot durch Nicht-IRC Operatoren
	assigned werden kann.
	
	Beschrnkt auf Services admins.

###########################################################################
#
# HostServ messages
#
###########################################################################
HOST_EMPTY
	Die vhost Liste ist leer.
HOST_ENTRY
	#%d Nick:%s, vhost:%s (%s - %s)
HOST_IDENT_ENTRY
	#%d Nick:%s, vhost:%s@%s (%s - %s)
HOST_SET
	vhost fr %s wurde gesetzt: %s.
HOST_IDENT_SET
	vhost fr %s wurde gesetzt: %s@%s.
HOST_SETALL
	vhost fr die group %s wurde gesetzt: %s.
HOST_DELALL
	vhosts for group %s have been removed.
HOST_DELALL_SYNTAX
	Syntax: DELALL <nick>.
HOST_IDENT_SETALL
	vhost fr die group %s wurde gesetzt: %s@%s.
HOST_SET_ERROR
	Fehler! Ein vhost darf nur die Zeichen A-Z, a-z, 0-9, '.' und '-' enthalten.
HOST_SET_IDENT_ERROR
	A vhost ident must be in the format of a valid ident
HOST_SET_TOOLONG
	Fehler! Der vhost ist zu lang, bitte nutze einen vhost mit weniger als
	 %d Buchstaben.
HOST_SET_IDENTTOOLONG
	Fehler! Die Ident ist zu lang, bitte nutze eine Ident mit weniger als
	%d Buchstaben.
HOST_NOREG
	User %s wurde nicht in der nickserv db gefunden.
HOST_SET_SYNTAX
	Syntax /msg %s set <nick> <hostmask>.
HOST_SETALL_SYNTAX
	Syntax /msg %s setall <nick> <hostmask>.
HOST_DENIED
	Zugriff verweigert.
HOST_NOT_ASSIGNED
	Bitte kontaktiere einen IRC Operator, um diesem Nick einen vhost zuzuweisen.
HOST_ACTIVATED
	Dein vhost (%s) ist nun aktiviert.
HOST_IDENT_ACTIVATED
	Dein vhost (%s@%s) ist nun aktiviert.
HOST_ID
	Bitte identifiziere dich zuerst.
HOST_NOT_REGED
	Du musst erst deinen Nick registrieren, um einen vhost zu erhalten.
HOST_DEL
	vhost fr %s wurde gelscht.
HOST_DEL_SYNTAX
	Syntax: /msg %s del <nick>.
HOST_OFF_UNREAL
	Dein vhost wurde gelscht. Um die normale Host-Verschlsselung zu reaktivieren, tippe /mode %s +x
HOST_NO_VIDENT
	Dein IRCd untersttzt keine vIdent's, falls das inkorrekt sein sollte, melde das bitte als einen Bug.
HOST_GROUP
	Alle Vhost's in der Gruppe %s wurden auf %s gesetzt.
HOST_IDENT_GROUP
	Alle Vhost's in der Gruppe %s wurden auf %s@%s gesetzt.

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_LIST_FOOTER
	Zeigt alle Eintrge (Count: %d)
HOST_LIST_RANGE_FOOTER
	Zeigt alle Eintrge von %d bis %d
HOST_LIST_KEY_FOOTER
	Zeigt die auf den Key passenden eintrge %s (Count: %d)

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_HELP
	%S Commands:
	    ON          Aktiviert deinen vhost
	    OFF         Deaktiviert deinen vhost
	    GROUP       Gleicht den vhost fr alle Nicks in einer 
	                Gruppe an

HOST_OPER_HELP
	Commands fr Services Operatoren:
	    SET         Setzt einem User einen vhost
	    SETALL      Setzt einer Gruppe einen vhost
	    DEL         Lscht den vhost eines Users
	    LIST        Zeigt einen oder mehrere vhost Eintrge an.

HOST_ADMIN_HELP
	Commands fr Services Admins:

HOST_HELP_ON
	Syntax: ON

	Aktiviert den vhost der deinem Nick zugewiesen wurde. Wenn
	du dieses Command nutzt, wird jeder User, der ein /whois
	auf dich anwendet, diesen vhost anstatt deines Hosts sehen.

HOST_HELP_SET
	Syntax: SET <nick> <hostmask>.

	Setzt einem User einen vhost anstelle des normalen
	Hosts.  Falls dein IRCd vIdents untersttzt, kannst
	du mit SET <nick> <ident>@<hostmask> auch eine Ident
	wie einen vhost setzen.

	Beschrnkt auf Services Operatoren.

HOST_HELP_DELALL
	Syntax: DELALL <nick>.

	Lscht den Vhost aller Nick's aus der gleichen gruppe des 
	angegeben Nick's.

	Beschrnkt auf Host Removers.


HOST_HELP_SETALL
	Syntax: SETALL <nick> <hostmask>.

	Setzt allen Usern einer Group einen vhost. Falls dein
	IRCd vIdents untersttzt, kannst du mit 
	SETALL <nick> <ident>@<hostmask> eine Ident wie einen
	vhosts setzen.

	* Anmerkung, dieses Command betrifft keine Nicks, die
	nachtrglich zur Group hinzugefgt wurden.

	Beschrnkt auf Services Operatoren.

HOST_HELP_OFF
	Syntax: OFF

	Deaktiviert den gerade genutzten vhost eines Nicks.
	Nach der Nutzung dieses Commands wird jeder User, der
	ein /whois auf dich anwendet, deine echte IP Adresse
	sehen.

HOST_HELP_DEL
	Syntax: DEL <nick>

	Lscht den vhost des angegebenen Nicks.

	Beschrnkt auf Services Operatoren.

HOST_HELP_LIST
	Syntax: LIST [<key>|<#X-Y>]

	Dieser Befehl listet dem Operator die registrierten Vhost's.
	Wenn ein Key angegeben ist, nur die eintrge des nicks oder
	Vhost's, die dem gegeben pattern <Key> entsprechen, z.B.
	 Rob* fr alle Eintrge, die mit "Rob" beginnen.

	Wenn ein #X-Y style benutzt wird, werden nur die Eintrge 
	zwischen den angegeben Faktoren angezeigt, z.B. #1-3 wird 
	die ersten drei Nick/Vhost-Eintrge anzeigen.

	Die litste benutzt jedes mal den Wert von NSListMax als ein 
	festes Limit fr die Anzahl der dem Operator anzuzeigenden 
	Eintrge.

	Beschrnkt auf Services operators.

HOST_HELP_GROUP
	Syntax:GROUP
	
	Dieses Command erlaubt es Usern, den vhost ihres aktuellen
	Nicks, zum vhost der gessamten Group zu setzen.

