# Portuguese language file.
#
# (C) 2003 Anope Team
# Contact us at info@anope.org
#
# Please read COPYING and README for furhter details.
#
# Based on the original code of Epona by Lara.
# Based on the original code of Services by Andy Church.
#
# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, let me know
# (achurch@dragonfire.net) which message is causing a problem and I'll see
# what I can do.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# config.h).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.

###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	Portugus (Portuguese)

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%d %b %H:%M:%S %Y %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %d %b %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%d %b %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	Dom
	Seg
	Ter
	Qua
	Qui
	Sex
	Sab
# %A
STRFTIME_DAYS_LONG
	Domingo
	Segunda
	Tera
	Quarta
	Quinta
	Sexta
	Sbado
# %b
STRFTIME_MONTHS_SHORT
	Jan
	Fev
	Mar
	Abr
	Mai
	Jun
	Jul
	Ago
	Set
	Out
	Nov
	Dez
# %B
STRFTIME_MONTHS_LONG
	Janeiro
	Fevereiro
	Maro
	Abril
	Maio
	Junho
	Julho
	Agosto
	Setembro
	Outubro
	Novembro
	Dezembro


# This is used in ChanServ/NickServ INFO displays.
COMMA_SPACE
	, 


# Various error messages.
USER_RECORD_NOT_FOUND
	Erro interno - no foi possvel processar seu pedido.
UNKNOWN_COMMAND
	Comando desconhecido: %s.
UNKNOWN_COMMAND_HELP
	Comando desconhecido %s.  "/msg %s HELP" para ajuda.
SYNTAX_ERROR
	Sintaxe: %s
MORE_INFO
	/msg %s HELP %s para maiores informaes.
NO_HELP_AVAILABLE
	Nenhuma ajuda disponvel para %s.
OBSOLETE_COMMAND
	Este comando no  mais usado; use %s.

BAD_USERHOST_MASK
	A mscara deve ser no formato user@host.
BAD_EXPIRY_TIME
	Tempo de expirao invlido.
USERHOST_MASK_TOO_WIDE
	Mscara %s  muito grande; por favor seja mais especfico.

SERVICE_OFFLINE
	%s no est conectado no momento.
READ_ONLY_MODE
	Ateno: Os services esto no modo leitura apenas; as mudanas no sero salvas!
PASSWORD_INCORRECT
	Senha incorreta.

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	Acesso negado.
PERMISSION_DENIED
	Permisso negada.
RAW_DISABLED
	A opo RAW ha sido desabilitada. Se realmente precisar deve habilitar a opo DisableRaw na configurao dos Servicos.

MORE_OBSCURE_PASSWORD
	Por favor tente novamente com uma senha mais difcil. No use TAB ou espaos.
PASSWORD_TRUNCATED
	Ateno: Sua senha foi reduzida a %d caracteres.

NICK_NOT_REGISTERED
	Seu nick no est registrado.
NICK_NOT_REGISTERED_HELP
	Seu nick no est registrado.  Digite /msg %s HELP para maiores informaes sobre como registrar o nick.
NICK_X_NOT_REGISTERED
	Nick %s no est registrado.
NICK_X_IN_USE
	Nick %s is currently in use.
NICK_X_NOT_IN_USE
	Nick %s no est sendo usado.
NICK_X_NOT_ON_CHAN
	%s is not currently on channel %s.
NICK_X_FORBIDDEN
	Nick %s no pode ser registrado ou usado.
NICK_X_FORBIDDEN_OPER
	Nick %s foi bloqueado por %s:
	%s
NICK_X_ILLEGAL
	Nick %s is an illegal nickname and cannot be used.
NICK_X_TRUNCATED
	Nick %s was truncated to %d characters.
CHAN_X_NOT_REGISTERED
	O canal %s no est registrado.
CHAN_X_NOT_IN_USE
	O canal %s no existe.
CHAN_X_FORBIDDEN
	O canal %s no pode ser registrado ou usado.
CHAN_X_FORBIDDEN_OPER
	Canal %s foi bloqueado por %s:
	%s
CHAN_X_SUSPENDED
	      Suspended: [%s] %s
NICK_IDENTIFY_REQUIRED
	Identificao de senha requerida para usar este comando.
	Tente novamente aps digitar /msg %s IDENTIFY senha.
CHAN_IDENTIFY_REQUIRED
	Identificao de senha requerida para usar este comando.
	Tente novamente aps digitar /msg %s IDENTIFY %s senha.
	
MAIL_DISABLED
	Os services foram configurados para no enviar e-mail.
MAIL_INVALID
	E-mail para %s  invlido.
MAIL_X_INVALID
	%s no  um endereo de e-mail vlido.
MAIL_LATER
	No foi possvel enviar e-mail agora; tente novamente mais tarde.
MAIL_DELAYED
	Por favor aguarde %d segundos e tente novamente.
	
NO_REASON
	Sem motivo
UNKNOWN
	<desconhecido>

# Duration system
DURATION_DAY
	1 dia
DURATION_DAYS
	%d dias
DURATION_HOUR
	1 hora
DURATION_HOURS
	%d horas
DURATION_MINUTE
	1 minuto
DURATION_MINUTES
	%d minutos
DURATION_SECOND
	1 segundo
DURATION_SECONDS
	%d segundos
	
# Human readable expiration
NO_EXPIRE
	no expira
EXPIRES_SOON
	ir expirar na prxima atualizao do banco de dados
EXPIRES_M
	expira em %d minutos
EXPIRES_1M
	expira em %d minuto
EXPIRES_HM
	expira em %d horas, %d minutos
EXPIRES_H1M
	expira em %d horas, %d minuto
EXPIRES_1HM
	expira em %d hora, %d minutos
EXPIRES_1H1M
	expira em %d hora, %d minuto
EXPIRES_D
	expira em %d dias
EXPIRES_1D
	expira em %d dia

# Generic Footer message
END_OF_ANY_LIST
	End of %s list.

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Este nick foi registrado por outra pessoa.  Por favor escolha outro.
	(Se este for seu nick, digite /msg %s IDENTIFY senha.)
NICK_IS_SECURE
	Este nick est registrado e protegido.  Se este for seu
	nick, digite /msg %s IDENTIFY senha.  Caso contrrio,
	por favor escolha outro nick.
NICK_MAY_NOT_BE_USED
	Este nick no pode ser usado.  Por favor escolha outro.
FORCENICKCHANGE_IN_1_MINUTE
	Se voc no mudar seu nick em 1 minuto, eu irei mud-lo.
FORCENICKCHANGE_IN_20_SECONDS
	Se voc no mudar seu nick em 20 segundos, eu irei mud-lo.
FORCENICKCHANGE_NOW
	Este nick  registrado; voc no pode us-lo.
FORCENICKCHANGE_CHANGING
	Seu nick est sendo mudado para %s.

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER senha [email]
NICK_REGISTER_SYNTAX_EMAIL
	REGISTER senha email
NICK_REGISTRATION_DISABLED
	Desculpe, registros de nick esto temporariamente desativados.
NICK_REGISTRATION_FAILED
	Desculpe, registro de nick falhou.
NICK_REG_PLEASE_WAIT
	Por favor espere %d segundos antes de usar o comando REGISTER novamente.
NICK_CANNOT_BE_REGISTERED
	O nick %s no pode ser registrado.
NICK_ALREADY_REGISTERED
	O nick %s j est registrado!
NICK_REGISTERED
	O nick %s foi registrado em sua conta: %s
NICK_PASSWORD_IS
	Sua senha  %s - guarde ela para uso posterior.

# GROUP responses
NICK_GROUP_SYNTAX
	GROUP alvo senha
NICK_GROUP_DISABLED
	Desculpe, o comando GROUP est temporariamente desativado.
NICK_GROUP_FAILED
	Desculpe, o comando GROUP falhou.
NICK_GROUP_PLEASE_WAIT
	Por favor espere %d segundos antes de usar o comando GROUP novamente.
NICK_GROUP_CHANGE_DISABLED
	Seu nick j est registrado; digite /msg %s DROP primeiro.
NICK_GROUP_SAME
	Voc j  um membro do grupo %s.
NICK_GROUP_TOO_MANY
	There are too many nicks in %s's group; list them and drop some.
	Type /msg %s HELP GLIST and /msg %s HELP DROP 
	for more information.
NICK_GROUP_JOINED
	Voc  agora um membro do grupo %s.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY senha
NICK_IDENTIFY_FAILED
	Desculpe, a identificao falhou.
NICK_IDENTIFY_SUCCEEDED
	Senha aceita - voc est agora reconhecido.
NICK_IDENTIFY_EMAIL_REQUIRED
	Voc deve agora setar um e-mail para seu nick.
	Este e-mail permitir que voc receba sua senha por ele
	caso voc se esquea dela.
NICK_IDENTIFY_EMAIL_HOWTO
	Digite /msg %S SET EMAIL e-mail para setar seu e-mail.
	Sua privacidade  respeitada; seu e-mail no ser dado
	para terceiros.
	
# LOGOUT responses
NICK_ALREADY_IDENTIFIED
	You are already identified.

# UPDATE responses
NICK_UPDATE_SUCCESS
	Status updated (memos, vhost, chmodes, flags).
	
# LOGOUT responses
NICK_LOGOUT_SYNTAX
	LOGOUT
NICK_LOGOUT_SUCCEEDED
	Seu nick foi desconectado.
NICK_LOGOUT_X_SUCCEEDED
	O nick %s foi desconectado.

# DROP responses
NICK_LOGOUT_SERVICESADMIN
	Can't logout %s because he's a services administrator.

# DROP responses
NICK_DROP_DISABLED
	Desculpe, o comando DROP est temporariamente desativado.
NICK_DROPPED
	O registro do seu nick foi cancelado.
NICK_X_DROPPED
	O nick %s foi desregistrado.

# SET responses
NICK_SET_SYNTAX
	SET opes parmetros
NICK_SET_SERVADMIN_SYNTAX
	SET [nick] opes parmetros
NICK_SET_DISABLED
	Desculpe, a opo SET est temporariamente desativada.
NICK_SET_UNKNOWN_OPTION
	Opo SET desconhecida: %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Opo SET desconhecida: %s, ou nick no registrado.
NICK_SET_OPTION_DISABLED
	Opo %s no pode ser usada nesta Rede.

# SET DISPLAY responses
NICK_SET_DISPLAY_INVALID
	O novo display deve ser um nick do seu grupo!
NICK_SET_DISPLAY_CHANGED
	O novo display  agora %s.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	Desculpe, no foi possvel alterar a senha.
NICK_SET_PASSWORD_CHANGED
	Senha alterada.
NICK_SET_PASSWORD_CHANGED_TO
	Senha alterada para %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE nmero
NICK_SET_LANGUAGE_UNKNOWN
	Nmero de linguagem desconhecida %d.  Digite /msg %s HELP SET LANGUAGE para uma lista das linguagens disponveis.
NICK_SET_LANGUAGE_CHANGED
	Linguagem alterada para Portugus.

# SET URL responses
NICK_SET_URL_CHANGED
	URL alterada para %s.
NICK_SET_URL_UNSET
	URL removida.

# SET EMAIL responses
NICK_SET_EMAIL_CHANGED
	E-mail alterado para %s.
NICK_SET_EMAIL_UNSET
	E-mail removido.
NICK_SET_EMAIL_UNSET_IMPOSSIBLE
	Voc no pode remover o e-mail nessa Rede.
	
# SET ICQ responses
NICK_SET_ICQ_CHANGED
	Nmero de ICQ alterado para %s.
NICK_SET_ICQ_UNSET
	Nmero de ICQ removido.
NICK_SET_ICQ_INVALID
	%s no  um nmero vlido.
	
# SET GREET responses
NICK_SET_GREET_CHANGED
	Mensagem de entrada alterada para %s.
NICK_SET_GREET_UNSET
	Mensagem de entrada removida.

# SET PROTECT responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	Proteo de KILL est agora ATIVADA.
NICK_SET_KILL_QUICK
	Proteo de KILL est agora ATIVADA, com tempo de espera reduzido.
NICK_SET_KILL_IMMED
	Proteo de KILL est agora ATIVADA, sem tempo de espera.
NICK_SET_KILL_IMMED_DISABLED
	O comando IMMED no est disponvel nesta Rede.
NICK_SET_KILL_OFF
	Proteo de KILL est agora DESATIVADA.

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	Opo SECURE est agora ATIVADA.
NICK_SET_SECURE_OFF
	Opo SECURE est agora DESATIVADA.

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	Opo PRIVATE est agora ATIVADA.
NICK_SET_PRIVATE_OFF
	Opo PRIVATE est agora DESATIVADA.

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	Seu e-mail est agora escondido do comango %s INFO.
NICK_SET_HIDE_EMAIL_OFF
	Seu e-mail ir agora aparecer no comando %s INFO.
NICK_SET_HIDE_MASK_ON
	Seu ltimo endereo usado (user@host) est agora escondido do comando %s INFO.
NICK_SET_HIDE_MASK_OFF
	Seu ltimo endereo usado (user@host) ir agora aparecer no comando %s INFO.
NICK_SET_HIDE_QUIT_ON
	Sua ltima mensagem de sada est agora escondida do comando %s INFO.
NICK_SET_HIDE_QUIT_OFF
	Sua ltima mensagem de sada ir agora aparecer no comando %s INFO.
	
# SET MSG responses
NICK_SET_MSG_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_MSG_ON
	Os services iro agora respond-lo atravs de mensagens.
NICK_SET_MSG_OFF
	Os services iro agora respond-lo atravs de notices.

# SET NOEXPIRE responses
NICK_SET_NOEXPIRE_SYNTAX
	SET [nic] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	O nick %s no ir expirar.
NICK_SET_NOEXPIRE_OFF
	O nick %s ir expirar.

# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [mask]
NICK_ACCESS_ALREADY_PRESENT
	A mscara %s j se encontra em sua lista de acesso.
NICK_ACCESS_REACHED_LIMIT
	Desculpe, voc pode ter somente %d entradas em sua lista de acesso.
NICK_ACCESS_ADDED
	%s adicionado em sua lista de acesso.
NICK_ACCESS_NOT_FOUND
	%s no foi encontrado em sua lista de acesso.
NICK_ACCESS_DELETED
	%s removido da sua lista de acesso.
NICK_ACCESS_LIST
	Lista de acesso:
NICK_ACCESS_LIST_X
	Lista de acesso para %s:

# INFO responses
NICK_INFO_SYNTAX
	INFO nick [ALL]
NICK_INFO_REALNAME
	%s  %s
NICK_INFO_SERVICES_OPER
	%s  um Operador dos Services.
NICK_INFO_SERVICES_ADMIN
	%s  um Admin dos Services.
NICK_INFO_ADDRESS
	ltimo endereo visto: %s
NICK_INFO_ADDRESS_ONLINE
	est online em: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s est online neste momento.
NICK_INFO_TIME_REGGED
	Hora de registro: %s
NICK_INFO_LAST_SEEN
	Ultimo horrio visto: %s
NICK_INFO_LAST_QUIT
	ltima mensagem de sada: %s
NICK_INFO_URL
	URL: %s
NICK_INFO_EMAIL
	E-mail: %s
NICK_INFO_VHOST
	    vhost: %s
NICK_INFO_ICQ
	ICQ: %d
NICK_INFO_GREET
	Mensagem de entrada: %s
NICK_INFO_OPTIONS
	Opes: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Proteo
NICK_INFO_OPT_SECURE
	Segurana
NICK_INFO_OPT_PRIVATE
	Privado
NICK_INFO_OPT_MSG
	Modo mensagem
NICK_INFO_OPT_NONE
	Nenhuma
NICK_INFO_NO_EXPIRE
	Este nick no ir expirar.
NICK_INFO_FOR_MORE
	Para maiores informaes sobre o usurio, digite /msg %s INFO %s ALL.

# LIST responses
NICK_LIST_SYNTAX
	LIST opes
NICK_LIST_SERVADMIN_SYNTAX
	LIST opes [FORBIDDEN] [NOEXPIRE]
NICK_LIST_HEADER
	Lista de entradas com %s:
NICK_LIST_RESULTS
	Fim da listagem - %d/%d resultados mostrados.

# GLIST responses
NICK_ALIST_SYNTAX
	ALIST nickname
NICK_ALIST_HEADER
	Channels that you have access on:
	  Num  Channel              Level    Description 
NICK_ALIST_HEADER_X
	Channels that %s has access on:
	  Num  Channel              Level    Description 
NICK_ALIST_XOP_FORMAT
	  %3d %c%-20s %-8s %s
NICK_ALIST_ACCESS_FORMAT
	  %3d %c%-20s %-8d %s
NICK_ALIST_FOOTER
	Fim da listagem - %d/%d resultados mostrados.

# GLIST responses
NICK_GLIST_HEADER
	Lista de nicks no grupo:
NICK_GLIST_HEADER_X
	Lista de nicks no grupo %s:
NICK_GLIST_FOOTER
	%d nicks no grupo.

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER nick [senha]
NICK_NO_RECOVER_SELF
	Voc no pode usar o comando RECOVER em si mesmo!
NICK_RECOVERED
	Usurio que usava seu nick foi derrubado.
	/msg %s RELEASE %s para liberar seu nick antes de um minuto.

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE nick [senha]
NICK_RELEASE_NOT_HELD
	Nick %s no est em uso no momento.
NICK_RELEASED
	Seu nick foi derrubado e pode ser usado.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST nick [senha]
NICK_NO_GHOST_SELF
	Voc no pode usar o comando GHOST em si mesmo!
NICK_GHOST_KILLED
	Seu nick foi derrubado e pode ser usado.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS nick
NICK_GETPASS_UNAVAILABLE
	Comando GETPASS no disponvel: modo de encriptao ativado.
NICK_GETPASS_PASSWORD_IS
	Senha para %s  %s.
	
# SENDPASS responses
NICK_GETEMAIL_SYNTAX
	GETEMAIL user@email-host No WildCards!!
NICK_GETEMAIL_EMAILS_ARE
	Emails Match %s to %s.
NICK_GETEMAIL_NOT_USED
	No Emails listed for %s.
	
# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS nick
NICK_SENDPASS_UNAVAILABLE
	Comando SENDPASS no disponvel: modo de encriptao ativado.
NICK_SENDPASS_SUBJECT
	Senha do nick (%s)
NICK_SENDPASS_HEAD
	Ol,
NICK_SENDPASS_LINE_1
	Voc pediu para que a senha do nick %s fosse enviada por e-mail.
NICK_SENDPASS_LINE_2
	A senha  %s. Por motivos de segurana, recomendamos que voc mude sua senha aps ler este e-mail.
NICK_SENDPASS_LINE_3
	Se voc no souber porque este e-mail lhe foi enviado, por favor ignore-o.
NICK_SENDPASS_LINE_4
	NO RESPONDA ESTE E-MAIL!
NICK_SENDPASS_LINE_5
	Administradores do %s.
NICK_SENDPASS_OK
	Senha para %s foi enviada.

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID nick [motivo]
NICK_FORBID_SYNTAX_REASON
	FORBID nick motivo
NICK_FORBID_SUCCEEDED
	Nick %s est agora bloqueado.
NICK_FORBID_FAILED
	No foi possvel bloquear o nick %s!

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
NICK_REQUESTED
	This nick has already been requested, please check your e-mail address for the pass code
NICK_REG_RESENT
	Your passcode has been re-sent to %s.
NICK_REG_UNABLE
	Nick NOT registered, please try again later.
NICK_IS_PREREG
	This nick is awaiting an e-mail verification code before completing registration.
NICK_ENTER_REG_CODE
	A passcode has been sent to %s, please type /msg %s confirm <passcode> to complete registration
NICK_CONFIRM_NOT_FOUND
	Registration step 1 may have expired, please use "/msg %s register <password> <email>" first.
NICK_CONFIRM_INVALID
	Invalid passcode has been entered, please check the e-mail again, and retry
NICK_REG_MAIL_SUBJECT
	Nickname Registration (%s)
NICK_REG_MAIL_HEAD
	Hi,
NICK_REG_MAIL_LINE_1
	You have requested to register the following nickname %s.
NICK_REG_MAIL_LINE_2
	Please type " /msg %s confirm %s " to complete registration.
NICK_REG_MAIL_LINE_3
	If you don't know why this mail is sent to you, please ignore it silently.
NICK_REG_MAIL_LINE_4
	PLEASE DON'T ANSWER TO THIS MAIL!
NICK_REG_MAIL_LINE_5
	%s administrators.
NICK_GETPASS_PASSCODE_IS
	Passcode for %s is %s.
NICK_FORCE_REG
	Nickname %s confirmed

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Modo +o automtico
CHAN_LEVEL_AUTOVOICE
	Modo +v automtico
CHAN_LEVEL_AUTOHALFOP
	Modo +h automtico
CHAN_LEVEL_AUTOPROTECT
	Modo +a automtico
CHAN_LEVEL_AUTODEOP
	Modo -o automtico
CHAN_LEVEL_NOJOIN
	Entrada no canal no permitida se a opo RESTRICTED estiver ativada
CHAN_LEVEL_INVITE
	Permitido o uso do comando INVITE
CHAN_LEVEL_AKICK
	Permitido o uso do comando AKICK
CHAN_LEVEL_SET
	Permitido o uso do comando SET (no inclui FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	Permitido o uso do comando CLEAR
CHAN_LEVEL_UNBAN
	Permitido o uso do comando UNBAN
CHAN_LEVEL_OPDEOP
	Permitido o uso do comando OP/DEOP
CHAN_LEVEL_ACCESS_LIST
	Permitido visualizar a lista de acesso
CHAN_LEVEL_ACCESS_CHANGE
	Permitido modificar a lista de acesso
CHAN_LEVEL_MEMO
	Permitido listar/ler memos do canal
CHAN_LEVEL_ASSIGN
	Permitido associar/desassociar um bot  um canal
CHAN_LEVEL_BADWORDS
	Permitido o uso do comando BADWORDS
CHAN_LEVEL_NOKICK
	Nunca ser kickado pelos kickers do bot
CHAN_LEVEL_FANTASIA
	Permitido o uso do comando FANTASIA
CHAN_LEVEL_SAY
	Permitido o uso dos comandos SAY e ACT
CHAN_LEVEL_GREET
	Mensagem de entrada
CHAN_LEVEL_VOICEME
	Permitido usar o comando (de)voice em si mesmo
CHAN_LEVEL_VOICE
	Permitido o uso dos comandos VOICE/DEVOICE
CHAN_LEVEL_GETKEY
	Permitido o uso do comando GETKEY
CHAN_LEVEL_OPDEOPME
	Permitido usar o comando (de)op em si mesmo
CHAN_LEVEL_HALFOPME
	Permitido usar o comando (de)halfop em si mesmo
CHAN_LEVEL_HALFOP
	Permitido o uso dos comandos HALFOP/DEHALFOP
CHAN_LEVEL_PROTECTME
	Permitido usar o comando (de)protect em si mesmo
CHAN_LEVEL_PROTECT
	Permitido o uso dos comandos PROTECT/DEPROTECT
CHAN_LEVEL_KICKME
	Permitido usar o comando KICK em si mesmo
CHAN_LEVEL_KICK
	Permitido o uso do comando KICK
CHAN_LEVEL_SIGNKICK
	Sem assinatura no kick quando a opo SIGNKICK LEVEL estiver em uso

# Automatic responses
CHAN_LEVEL_BANME
	Allowed to ban him/herself
CHAN_LEVEL_BAN
	Allowed to use BAN command
CHAN_LEVEL_TOPIC
	Allowed to use TOPIC command
CHAN_LEVEL_INFO
	Allowed to use INFO command with ALL option

# Automatic responses
CHAN_IS_REGISTERED
	Este canal foi registrado com o %s.
CHAN_NOT_ALLOWED_OP
	Voc no tem permisso para ser operador no canal %s.
CHAN_MAY_NOT_BE_USED
	Este canal no pode ser usado.
CHAN_NOT_ALLOWED_TO_JOIN
	Voc no tem permisso para permanecer neste canal.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER canal senha descrio
CHAN_REGISTER_DISABLED
	Desculpe, o registro de canais est temporariamente desativado.
CHAN_REGISTER_NOT_LOCAL
	Canais locais no podem ser registrados.
CHAN_MUST_REGISTER_NICK
	Voc deve registrar seu nick primeiro.  Digite /msg %s HELP para maiores informaes sobre registro de nick.
CHAN_MUST_IDENTIFY_NICK
	Por favor se identifique com o %s primeiro, usando o comando:
	/msg %s IDENTIFY senha
CHAN_MAY_NOT_BE_REGISTERED
	O canal %s no pode ser registrado.
CHAN_ALREADY_REGISTERED
	O canal %s j est registrado!
CHAN_MUST_BE_CHANOP
	Voc deve ser no mnimo um operador para registrar o canal.
CHAN_REACHED_CHANNEL_LIMIT
	Desculpe, voc j alcanou o limite de %d canais registrados.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Desculpe, voc j ultrapassou o limite de %d canais registrados.
CHAN_REGISTRATION_FAILED
	Desculpe, o registro falhou.
CHAN_REGISTERED
	O canal %s est registrado sob seu nick: %s
CHAN_PASSWORD_IS
	A senha do seu canal  %s - guarde ela para uso posterior.

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY canal senha
CHAN_IDENTIFY_FAILED
	Desculpe, a identificao falhou.
CHAN_IDENTIFY_SUCCEEDED
	Senha aceita - voc est sendo reconhecido agora como dono do %s.

# LOGOUT responses
CHAN_LOGOUT_SYNTAX
	LOGOUT canal nick
CHAN_LOGOUT_SERVADMIN_SYNTAX
	LOGOUT canal [nick]
CHAN_LOGOUT_SUCCEEDED
	Usurio %s foi desconectado do canal %s.
CHAN_LOGOUT_ALL_SUCCEEDED
	Todos os usurios registrados foram desconectados do canal %s.

# DROP responses
CHAN_DROP_SYNTAX
	DROP canal
CHAN_DROP_DISABLED
	Desculpe, o comando DROP est temporariamente desativado.
CHAN_DROPPED
	O canal %s foi desregistrado.

# SET responses
CHAN_SET_SYNTAX
	SET canal opes parmetros
CHAN_SET_DISABLED
	Desculpe, o comando SET est temporariamente desativado.
CHAN_SET_UNKNOWN_OPTION
	Comando SET %s desconhecido.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s possui muitos canais registrados.
CHAN_FOUNDER_CHANGED
	Founder do canal %s alterado para %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	Successor do canal %s alterado para %s.
CHAN_SUCCESSOR_UNSET
	Successor do canal %s removido.
CHAN_SUCCESSOR_IS_FOUNDER
	%s no pode ser o successor do canal %s porque ele  o founder.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	Desculpe, a mudana de senha falhou.
CHAN_PASSWORD_CHANGED
	A senha do %s foi alterada.
CHAN_PASSWORD_CHANGED_TO
	A senha do %s foi alterada para %s.

# SET DESC responses
CHAN_DESC_CHANGED
	Descrio do canal %s alterada para %s.

# SET URL responses
CHAN_URL_CHANGED
	URL do canal %s alterada para %s.
CHAN_URL_UNSET
	URL do canal %s removida.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	E-mail do canal %s alterado para %s.
CHAN_EMAIL_UNSET
	E-mail do canal %s removido.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	Mensagem de entrada para o canal %s alterada.
CHAN_ENTRY_MSG_UNSET
	Mensagem de entrada para o canal %s removida.
	
# SET BANTYPE responses
CHAN_SET_BANTYPE_INVALID
	%s no  um ban vlido.
CHAN_SET_BANTYPE_CHANGED
	Tipo de ban para o canal %s  agora #%d.

# SET MLOCK responses
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Modo %c desconhecido e ignorado.
CHAN_SET_MLOCK_IMPOSSIBLE_CHAR
	Mode %c ignored because you can't lock it.
CHAN_SET_MLOCK_L_REQUIRED
	Voc deve setar o modo +l bem como o modo +L.
CHAN_SET_MLOCK_K_REQUIRED
	You must lock mode +i as well to lock mode +K.
CHAN_MLOCK_CHANGED
	Modo MLOCK no canal %s alterado para %s.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET canal KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Reteno de tpico est agora ATIVADA.
CHAN_SET_KEEPTOPIC_OFF
	Reteno de tpico est agora DESATIVADA.

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET canal TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Trava de tpico est agora ATIVADA.
CHAN_SET_TOPICLOCK_OFF
	Trava de tpico est agora DESATIVADA.

# SET PRIVATE responses
CHAN_SET_PEACE_SYNTAX
	SET channel PEACE {ON | OFF}
CHAN_SET_PEACE_ON
	Peace option is now ON.
CHAN_SET_PEACE_OFF
	Peace option is now OFF.

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET canal PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Opo Private est agora ATIVADA.
CHAN_SET_PRIVATE_OFF
	Opo Private est agora DESATIVADA.

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET canal SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Opo Secure ops est agora ATIVADA.
CHAN_SET_SECUREOPS_OFF
	Opo Secure ops est agora DESATIVADA.
	
# SET SECUREFOUNDER responses
CHAN_SET_SECUREFOUNDER_SYNTAX
	SET canal SECUREFOUNDER {ON | OFF}
CHAN_SET_SECUREFOUNDER_ON
	Opo Secure founder est agora ATIVADA.
CHAN_SET_SECUREFOUNDER_OFF
	Opo Secure founder est agora DESATIVADA.

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET canal RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Opo Restricted est agora ATIVADA.
CHAN_SET_RESTRICTED_OFF
	Opo Restricted est agora DESATIVADA.

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET canal SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	Opo Secure est agora ATIVADA.
CHAN_SET_SECURE_OFF
	Opo Secure est agora DESATIVADA.
	
# SET SIGNKICK responses
CHAN_SET_SIGNKICK_SYNTAX
	SET canal SIGNKICK {ON | LEVEL | OFF}
CHAN_SET_SIGNKICK_ON
	Opo Signed kick est agora ATIVADA.
CHAN_SET_SIGNKICK_LEVEL
	Opo Signed kick est agora ATIVADA, mas depende do nvel de acesso 
	do usurio que usar o comando.
CHAN_SET_SIGNKICK_OFF
	Opo Signed kick est agora DESATIVADA.

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET canal OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Opo Op-notice est agora ATIVADA.
CHAN_SET_OPNOTICE_OFF
	Opo Op-notice est agora DESATIVADA.

# SET NOEXPIRE responses
CHAN_SET_XOP_SYNTAX
	SET channel XOP {ON | OFF}
CHAN_SET_XOP_ON
	xOP lists system is now ON.
CHAN_SET_XOP_OFF
	xOP lists system is now OFF.

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET canal NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	O canal %s no ir expirar.
CHAN_SET_NOEXPIRE_OFF
	O canal %s ir expirar.

# xOP messages
CHAN_XOP_REACHED_LIMIT
	Sorry, you can only have %d AOP/SOP/VOP entries on a channel.
CHAN_XOP_LIST_FORMAT
	  %3d  %s
CHAN_XOP_ACCESS
	You can't use this command. Use the ACCESS command instead.
	Type /msg %s HELP ACCESS for more information.

# AOP messages
CHAN_AOP_SYNTAX
	AOP channel {ADD|DEL|LIST|CLEAR} [nick | entry-list]
CHAN_AOP_DISABLED
	Sorry, channel AOP list modification is temporarily disabled.
CHAN_AOP_NICKS_ONLY
	Channel AOP lists may only contain registered nicknames.
CHAN_AOP_ADDED
	%s added to %s AOP list.
CHAN_AOP_MOVED
	%s moved to %s AOP list.
CHAN_AOP_NO_SUCH_ENTRY
	No such entry (#%d) on %s AOP list.
CHAN_AOP_NOT_FOUND
	%s not found on %s AOP list.
CHAN_AOP_NO_MATCH
	No matching entries on %s AOP list.
CHAN_AOP_DELETED
	%s deleted from %s AOP list.
CHAN_AOP_DELETED_ONE
	Deleted 1 entry from %s AOP list.
CHAN_AOP_DELETED_SEVERAL
	Deleted %d entries from %s AOP list.
CHAN_AOP_LIST_EMPTY
	%s AOP list is empty.
CHAN_AOP_LIST_HEADER
	AOP list for %s:
	  Num  Nick
CHAN_AOP_CLEAR
	Channel AOP list has been cleared.

# HOP messages
CHAN_HOP_SYNTAX
	HOP channel {ADD|DEL|LIST|CLEAR} [nick | entry-list]
CHAN_HOP_DISABLED
	Sorry, channel HOP list modification is temporarily disabled.
CHAN_HOP_NICKS_ONLY
	Channel HOP lists may only contain registered nicknames.
CHAN_HOP_ADDED
	%s added to %s HOP list.
CHAN_HOP_MOVED
	%s moved to %s HOP list.
CHAN_HOP_NO_SUCH_ENTRY
	No such entry (#%d) on %s HOP list.
CHAN_HOP_NOT_FOUND
	%s not found on %s HOP list.
CHAN_HOP_NO_MATCH
	No matching entries on %s HOP list.
CHAN_HOP_DELETED
	%s deleted from %s HOP list.
CHAN_HOP_DELETED_ONE
	Deleted 1 entry from %s HOP list.
CHAN_HOP_DELETED_SEVERAL
	Deleted %d entries from %s HOP list.
CHAN_HOP_LIST_EMPTY
	%s HOP list is empty.
CHAN_HOP_LIST_HEADER
	HOP list for %s:
	  Num  Nick
CHAN_HOP_CLEAR
	Channel HOP list has been cleared.

# SOP messages
CHAN_SOP_SYNTAX
	SOP channel {ADD|DEL|LIST|CLEAR} [nick | entry-list]
CHAN_SOP_DISABLED
	Sorry, channel SOP list modification is temporarily disabled.
CHAN_SOP_NICKS_ONLY
	Channel SOP lists may only contain registered nicknames.
CHAN_SOP_ADDED
	%s added to %s SOP list.
CHAN_SOP_MOVED
	%s moved to %s SOP list.
CHAN_SOP_NO_SUCH_ENTRY
	No such entry (#%d) on %s SOP list.
CHAN_SOP_NOT_FOUND
	%s not found on %s SOP list.
CHAN_SOP_NO_MATCH
	No matching entries on %s SOP list.
CHAN_SOP_DELETED
	%s deleted from %s SOP list.
CHAN_SOP_DELETED_ONE
	Deleted 1 entry from %s SOP list.
CHAN_SOP_DELETED_SEVERAL
	Deleted %d entries from %s SOP list.
CHAN_SOP_LIST_EMPTY
	%s SOP list is empty.
CHAN_SOP_LIST_HEADER
	SOP list for %s:
	  Num  Nick
CHAN_SOP_CLEAR
	Channel SOP list has been cleared.

# VOP messages
CHAN_VOP_SYNTAX
	VOP channel {ADD|DEL|LIST|CLEAR} [nick | entry-list]
CHAN_VOP_DISABLED
	Sorry, channel VOP list modification is temporarily disabled.
CHAN_VOP_NICKS_ONLY
	Channel VOP lists may only contain registered nicknames.
CHAN_VOP_ADDED
	%s added to %s VOP list.
CHAN_VOP_MOVED
	%s moved to %s VOP list.
CHAN_VOP_NO_SUCH_ENTRY
	No such entry (#%d) on %s VOP list.
CHAN_VOP_NOT_FOUND
	%s not found on %s VOP list.
CHAN_VOP_NO_MATCH
	No matching entries on %s VOP list.
CHAN_VOP_DELETED
	%s deleted from %s VOP list.
CHAN_VOP_DELETED_ONE
	Deleted 1 entry from %s VOP list.
CHAN_VOP_DELETED_SEVERAL
	Deleted %d entries from %s VOP list.
CHAN_VOP_LIST_EMPTY
	%s VOP list is empty.
CHAN_VOP_LIST_HEADER
	VOP list for %s:
	  Num  Nick
CHAN_VOP_CLEAR
	Channel VOP list has been cleared.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS canal {ADD|DEL|LIST|CLEAR} [nick [nvel] | entry-list]
CHAN_ACCESS_XOP
	You can't use this command. 
	Use the AOP, SOP and VOP commands instead.
	Type /msg %s HELP command for more information.
CHAN_ACCESS_DISABLED
	Desculpe, o registro de canais est temporariamente desativado.
CHAN_ACCESS_LEVEL_NONZERO
	O nvel de acesso deve ser diferente de zero.
CHAN_ACCESS_LEVEL_RANGE
	O nvel de acesso deve ser entre %d e %d inclusive.
CHAN_ACCESS_NICKS_ONLY
	A lista de acesso do canal deve conter apenas nicks registrados.
CHAN_ACCESS_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d entradas na lista de acesso do canal.
CHAN_ACCESS_LEVEL_UNCHANGED
	Nvel de acesso para %s no %s no alterado %d.
CHAN_ACCESS_LEVEL_CHANGED
	Nvel de acesso para %s no %s alterado para %d.
CHAN_ACCESS_ADDED
	%s adicionado a lista de acesso do %s com o nvel %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	Nenhuma entrada com (#%d) encontrada na lista de acesso do %s.
CHAN_ACCESS_NOT_FOUND
	%s no foi encontrado na lista de acesso do %s.
CHAN_ACCESS_NO_MATCH
	Resultado no encontrado na lista de acesso do %s.
CHAN_ACCESS_DELETED
	%s removido da lista de acesso do %s.
CHAN_ACCESS_DELETED_ONE
	Removida 1 entrada da lista de acesso do %s.
CHAN_ACCESS_DELETED_SEVERAL
	Removidas %d entradas da lista de acesso do %s.
CHAN_ACCESS_LIST_EMPTY
	Lista de acesso do %s vazia.
CHAN_ACCESS_LIST_HEADER
	Lista de acesso para %s:
	  Num   Nv  Nick
CHAN_ACCESS_LIST_FOOTER
	Fim da lista de acesso.
CHAN_ACCESS_LIST_XOP_FORMAT
	  %3d   %s  %s
CHAN_ACCESS_LIST_AXS_FORMAT
	  %3d  %4d  %s
CHAN_ACCESS_CLEAR
	Lista de acesso do canal apagada.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK canal {ADD | DEL | LIST | VIEW | ENFORCE | CLEAR} [nick-ou-mscara]
CHAN_AKICK_DISABLED
	Desculpe, o comando AKICK est temporariamente desativado.
CHAN_AKICK_ALREADY_EXISTS
	%s j existe na lista de akick do %s.
CHAN_AKICK_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d akicks na lista do canal.
CHAN_AKICK_ADDED
	%s adicionado a lista de akick do %s.
CHAN_AKICK_NO_SUCH_ENTRY
	Nenhuma entrada com (#%d) na lista de akick do %s.
CHAN_AKICK_NOT_FOUND
	%s no encontrado na lista de akick do %s.
CHAN_AKICK_NO_MATCH
	Nenhum resultado encontrado na lista de akick do %s.
CHAN_AKICK_STUCK
	%s is now always active on channel %s.
CHAN_AKICK_UNSTUCK
	%s is not always active anymore on channel %s.
CHAN_AKICK_DELETED
	%s removido da lista de akick do %s.
CHAN_AKICK_DELETED_ONE
	Removida 1 entrada da lista de akick do %s.
CHAN_AKICK_DELETED_SEVERAL
	Removidas %d entradas da lista de akick do %s.
CHAN_AKICK_LIST_EMPTY
	Lista de akick do %s vazia.
CHAN_AKICK_LIST_HEADER
	Lista de akick para %s:
CHAN_AKICK_LIST_FORMAT
	  %3d %s%s
CHAN_AKICK_VIEW_FORMAT
	%3d %s (por %s em %s)
	    %s
CHAN_AKICK_VIEW_FORMAT_STUCK
	%3d %s (stuck) (by %s on %s)
	    %s
CHAN_AKICK_ENFORCE_DONE
	AKICK ENFORCE para %s terminado; %d usurios afetados.
CHAN_AKICK_CLEAR
	Lista de akick do canal foi limpa.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS canal {SET | DIS[ABLE] | LIST | RESET} [item [nvel]]
CHAN_LEVELS_XOP
	This command is useless in this mode.
CHAN_LEVELS_RANGE
	O nvel deve ser entre %d e %d inclusive.
CHAN_LEVELS_CHANGED
	Nvel para %s no canal %s alterado para %d.
CHAN_LEVELS_UNKNOWN
	Level %s desconhecido.  Digite /msg %s HELP LEVELS DESC para uma lista de levels vlidos.
CHAN_LEVELS_DISABLED
	%s desabilitado no canal %s.
CHAN_LEVELS_LIST_HEADER
	Opes de nvel de acesso para o canal %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (desabilitado)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (founder apenas)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %d
CHAN_LEVELS_RESET
	Nveis de acesso para o %s redefinidos para o padro.

# INFO responses
CHAN_INFO_SYNTAX
	INFO canal [ALL]
CHAN_INFO_HEADER
	Informaes do canal %s:
CHAN_INFO_FOUNDER
	             Fundador: %s (%s)
CHAN_INFO_NO_FOUNDER
	             Fundador: %s
CHAN_INFO_SUCCESSOR
	             Sucessor: %s (%s)
CHAN_INFO_NO_SUCCESSOR
	             Sucessor: %s
CHAN_INFO_DESCRIPTION
	            Descrio: %s
CHAN_INFO_ENTRYMSG
	  Mensagem de entrada: %s
CHAN_INFO_TIME_REGGED
	           Registrado: %s
CHAN_INFO_LAST_USED
	           ltimo uso: %s
CHAN_INFO_LAST_TOPIC
	        ltimo tpico: %s
CHAN_INFO_TOPIC_SET_BY
	           Tpico por: %s
CHAN_INFO_URL
	                  URL: %s
CHAN_INFO_EMAIL
	               E-mail: %s
CHAN_INFO_BANTYPE
	          Tipo de ban: %d
CHAN_INFO_OPTIONS
	               Opes: %s
CHAN_INFO_OPT_KEEPTOPIC
	Reteno de tpico
CHAN_INFO_OPT_OPNOTICE
	OP Notice
CHAN_INFO_OPT_PEACE
	Peace
CHAN_INFO_OPT_PRIVATE
	Privado
CHAN_INFO_OPT_RESTRICTED
	Acesso restrito
CHAN_INFO_OPT_SECURE
	Seguro
CHAN_INFO_OPT_SECUREOPS
	Secure Ops
CHAN_INFO_OPT_SECUREFOUNDER
	Secure Founder
CHAN_INFO_OPT_SIGNKICK
	Signed kicks
CHAN_INFO_OPT_TOPICLOCK
	Trava de tpico
CHAN_INFO_OPT_XOP
	xOP lists system
CHAN_INFO_OPT_NONE
	Nenhuma
CHAN_INFO_MODE_LOCK
	        Trava de modo: %s
CHAN_INFO_NO_EXPIRE
	Este canal no ir expirar.

# LIST responses
CHAN_LIST_SYNTAX
	LIST padro
CHAN_LIST_SERVADMIN_SYNTAX
	LIST padro [FORBIDDEN] [NOEXPIRE]
CHAN_LIST_HEADER
	Lista de entradas com %s:
CHAN_LIST_FORMAT
	    %-20s  %s
CHAN_LIST_END
	Fim da lista - %d/%d resultados mostrados.
	
# CLIST responses
CHAN_INVITE_SYNTAX
	INVITE canal

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN canal
CHAN_UNBANNED
	Voc no est mais banido do %s.

# CLEAR responses
CHAN_TOPIC_SYNTAX
	TOPIC channel [topic]

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR canal opo
CHAN_CLEARED_BANS
	Todos os bans do canal %s foram removidos.
CHAN_CLEARED_EXCEPTS
	Todos os excepts do canal %s foram removidos.
CHAN_CLEARED_MODES
	Todos os modos no canal %s foram removidos.
CHAN_CLEARED_OPS
	Modo +o foi retirado do canal %s.
CHAN_CLEARED_VOICES
	Mode +v foi retirado do canal %s.
CHAN_CLEARED_USERS
	Todos os usurios foram kickados do canal %s.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS canal
CHAN_GETPASS_UNAVAILABLE
	Comando GETPASS indisponvel: modo de encriptao em uso.
CHAN_GETPASS_PASSWORD_IS
	Senha do canal %s  %s.
	
# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS canal
CHAN_SENDPASS_UNAVAILABLE
	Comando SENDPASS indisponvel: modo de encriptao em uso.
CHAN_SENDPASS_SUBJECT
	Senha do canal (%s)
CHAN_SENDPASS_HEAD
	Ol,
CHAN_SENDPASS_LINE_1
	Voc pediu para receber a senha do canal %s por e-mail.
CHAN_SENDPASS_LINE_2
	A senha  %s. Por motivos de segurana, recomendamos que voc mude a senha assim que receber este e-mail.
CHAN_SENDPASS_LINE_3
	Se voc no sabe porque este e-mail lhe foi enviado, por favor ignore-o.
CHAN_SENDPASS_LINE_4
	POR FAVOR NO RESPONDA ESTE E-MAIL!
CHAN_SENDPASS_LINE_5
	Administradores do %s.
CHAN_SENDPASS_OK
	Senha do canal %s foi enviada.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID canal [motivo]
CHAN_FORBID_SYNTAX_REASON
	FORBID canal motivo
CHAN_FORBID_SUCCEEDED
	Canal %s est agora bloqueado.
CHAN_FORBID_FAILED
	No foi possvel bloquear o canal %s!

# Misc responses
CHAN_FORBID_REASON
	This channel has been forbidden.

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND channel [reason]
CHAN_SUSPEND_SYNTAX_REASON
	SUSPEND channel reason
CHAN_SUSPEND_SUCCEEDED
	Channel %s is now suspended.
CHAN_SUSPEND_FAILED
	Couldn't suspended channel %s!
CHAN_SUSPEND_REASON
	This channel has been suspended.

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND channel
CHAN_UNSUSPEND_ERROR
	No # found in front of channel name.
CHAN_UNSUSPEND_SUCCEEDED
	Channel %s is now released.
CHAN_UNSUSPEND_FAILED
	Couldn't release channel %s!

# Misc responses
CHAN_EXCEPTED
	%s matches an except on %s and cannot be banned until the except have been removed.

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	Voc tem 1 novo memo.
MEMO_HAVE_NEW_MEMOS
	Voc tem %d novos memos.
MEMO_TYPE_READ_LAST
	Digite /msg %s READ LAST para ler.
MEMO_TYPE_READ_NUM
	Digite /msg %s READ %d para ler.
MEMO_TYPE_LIST_NEW
	Digite /msg %s LIST NEW para listar.
MEMO_AT_LIMIT
	Ateno: Voc atingiu seu nmero mximo de memos (%d).  No ser possvel receber novos memos enquanto voc no apagar alguns.
MEMO_OVER_LIMIT
	Ateno: Voc ultrapassou seu nmero mximo de memos (%d).  No ser possvel receber novos memos enquanto voc no apagar alguns.
MEMO_X_MANY_NOTICE
	There are %d memos on channel %s.
MEMO_X_ONE_NOTICE
	There is %d memo on channel %s.
MEMO_NEW_X_MEMO_ARRIVED
	There is a new memo on channel %s.
	Type /msg %s READ %s %d to read it.
MEMO_NEW_MEMO_ARRIVED
	Voc possui um novo memo de %s.
	Digite /msg %s READ %d para ler.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	Voc no possui memos.
MEMO_X_HAS_NO_MEMOS
	%s no possui memos.
MEMO_DOES_NOT_EXIST
	Memo %d no existe!
MEMO_LIST_NOT_FOUND
	Nenhum memo encontrado.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {nick | canal} texto
MEMO_SEND_DISABLED
	Desculpe, o envio de memos est temporariamente desabilitado.
MEMO_SEND_PLEASE_WAIT
	Por favor aguarde %d segundos antes de usar o comando SEND novamente.
MEMO_X_GETS_NO_MEMOS
	%s no pode receber memos.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s possui muitos memos atualmente e no pode receber mais nenhum.
MEMO_SENT
	Memo enviado para %s.
	
# CANCEL responses
MEMO_MASS_SENT
	A massmemo has been sent to all registered users.
	
# CANCEL responses
MEMO_CANCEL_SYNTAX
	CANCEL {nick | canal}
MEMO_CANCEL_DISABLED
	Desculpe, o comando CANCEL est temporariamente desativado.
MEMO_CANCEL_NONE
	Nenhum memo foi cancelado.
MEMO_CANCELLED
	ltimo memo enviado para %s foi cancelado.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [canal] [list | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	Voc no possui novos memos.
MEMO_X_HAS_NO_NEW_MEMOS
	%s no possui novos memos.
MEMO_LIST_MEMOS
	Memos para %s.  Para ler, digite: /msg %s READ nm
MEMO_LIST_NEW_MEMOS
	Novos memos para %s.  Para ler, digite: /msg %s READ nm
MEMO_LIST_CHAN_MEMOS
	Memos para %s.  Para ler, digite: /msg %s READ %s nm
MEMO_LIST_CHAN_NEW_MEMOS
	Novos memos para %s.  Para ler, digite: /msg %s READ %s nm
MEMO_LIST_HEADER
	 Nm  Remetente            Data/Hora
MEMO_LIST_FORMAT
	%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [canal] {list | LAST | NEW}
MEMO_HEADER
	Memo %d de %s (%s).  Para apagar, digite: /msg %s DEL %d
MEMO_CHAN_HEADER
	Memo %d de %s (%s).  Para apagar, digite: /msg %s DEL %s %d
MEMO_TEXT
	%s

# DEL responses
MEMO_DEL_SYNTAX
	DEL [canal] {nm | list | ALL}
MEMO_DELETED_NONE
	Nenhum memo apagado.
MEMO_DELETED_ONE
	Memo %d foi apagado.
MEMO_DELETED_SEVERAL
	Memos %s foram apagados.
MEMO_DELETED_ALL
	Todos os seus memos foram apagados.

# SET responses
MEMO_CHAN_DELETED_ALL
	All memos for channel %s have been deleted.

# SET responses
MEMO_SET_SYNTAX
	SET opo parmetros
MEMO_SET_DISABLED
	Desculpe, a opo SET est temporariamente desativada.
MEMO_SET_UNKNOWN_OPTION
	Comando SET desconhecido: %s.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s ir agora notific-lo de novos memos quando voc conectar ou quando eles lhe forem enviados.
MEMO_SET_NOTIFY_LOGON
	%s ir agora notific-lo de novos memos quando voc conectar ou desativar o /AWAY.
MEMO_SET_NOTIFY_NEW
	%s ir agora notific-lo de novos memos quando eles lhe forem enviados.
MEMO_SET_NOTIFY_OFF
	%s no ir mais notific-lo de novos memos.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [canal] limite
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [usurio | canal] {limite | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	Voc no tem permisso para mudar seu limite de memos.
MEMO_SET_LIMIT_FORBIDDEN
	O limite de memos para %s no pode ser mudado.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	Voc no pode colocar seu limite de memos maior que %d.
MEMO_SET_LIMIT_TOO_HIGH
	Voc no pode colocar o limite de memos para %s maior que %d.
MEMO_SET_LIMIT_OVERFLOW
	Limite de memos muito grande; limitando em %d.
MEMO_SET_YOUR_LIMIT
	Seu limite de memo  agora de %d.
MEMO_SET_YOUR_LIMIT_ZERO
	Voc no poder mais receber memos.
MEMO_UNSET_YOUR_LIMIT
	Seu limite de memos foi desativado.
MEMO_SET_LIMIT
	Limite de memos para %s  agora de %d.
MEMO_SET_LIMIT_ZERO
	Limite de memos para %s  agora de 0.
MEMO_UNSET_LIMIT
	Limite de memos desativado para %s.

# INFO responses
MEMO_INFO_SYNTAX
	INFO [anal]
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [nick | canal]
MEMO_INFO_NO_MEMOS
	Voc no possui nenhum memo atualmente.
MEMO_INFO_MEMO
	Voc possui atualmente 1 memo.
MEMO_INFO_MEMO_UNREAD
	Voc possui atualmente 1 memo, e este ainda no foi lido.
MEMO_INFO_MEMOS
	Voc possui atualmente %d memos.
MEMO_INFO_MEMOS_ONE_UNREAD
	Voc possui atualmente %d memos, dos quais 1 no foi lido.
MEMO_INFO_MEMOS_SOME_UNREAD
	Voc possui atualmente %d memos, dos quais %d no foram lidos.
MEMO_INFO_MEMOS_ALL_UNREAD
	Voc possui atualmente %d memos; dos quais nenhum foi lido.
MEMO_INFO_LIMIT
	Seu limite de memos  de %d.
MEMO_INFO_HARD_LIMIT
	Seu limite de memos  de %d, e no pode ser alterado.
MEMO_INFO_LIMIT_ZERO
	Seu limite de memos  de 0; voc no pode receber novos memos.
MEMO_INFO_HARD_LIMIT_ZERO
	Seu limite de memos  de 0; voc no pode receber novos memos.  Voc no pode alterar esse limite.
MEMO_INFO_NO_LIMIT
	Voc no possui limite de memos que pode guardar.
MEMO_INFO_NOTIFY_OFF
	Voc ser notificado de novos memos.
MEMO_INFO_NOTIFY_ON
	Voc ser notificado de novos memos quando conectar e quando eles forem enviados.
MEMO_INFO_NOTIFY_RECEIVE
	Voc ser notificado de novos memos quando eles forem enviados.
MEMO_INFO_NOTIFY_SIGNON
	Voc ser notificado de novos memos quando conectar.
MEMO_INFO_X_NO_MEMOS
	%s no possui nenhum memo atualmente.
MEMO_INFO_X_MEMO
	%s possui atualmente 1 memo.
MEMO_INFO_X_MEMO_UNREAD
	%s possui atualmente 1 memo, e ainda no foi lido.
MEMO_INFO_X_MEMOS
	%s possui atualmente %d memos.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s possui atualmente %d memos, dos quais 1 no foi lido.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s possui atualmente %d memos, dos quais %d no foram lidos.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s possui atualmente %d memos; dos quais nenhum foi lido.
MEMO_INFO_X_LIMIT
	Limite de memos para %s  de %d.
MEMO_INFO_X_HARD_LIMIT
	Limite de memos para %s  de %d, e no pode ser alterado.
MEMO_INFO_X_NO_LIMIT
	%s no possui limite de memos.
MEMO_INFO_X_NOTIFY_OFF
	%s no  notificado de novos memos.
MEMO_INFO_X_NOTIFY_ON
	%s  notificado de novos memos quando conecta e quando eles so enviados.
MEMO_INFO_X_NOTIFY_RECEIVE
	%s  notificado de novos memos quando eles so enviados.
MEMO_INFO_X_NOTIFY_SIGNON
	%s  notificado de novos memos quando conecta.
	
###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
BOT_DOES_NOT_EXIST
	Bot %s no existe.
BOT_NOT_ASSIGNED
	Voc precisa primeiro associar um bot ao canal antes de usar este comando.
	Digite /msg %S HELP ASSIGN para maiores informaes.
BOT_NOT_ON_CHANNEL
	Bot no est no canal %s.
	
# Kick reasons (must be a single line)
BOT_REASON_BADWORD
	No use a palavra %s neste canal!
BOT_REASON_BADWORD_GENTLE
	Cuidado com suas palavras!
BOT_REASON_BOLD
	No use negritos neste canal!
BOT_REASON_CAPS
	Desligue o CAPS LOCK!
BOT_REASON_COLOR
	No use cores neste canal!
BOT_REASON_FLOOD
	Pare de floodar!
BOT_REASON_REPEAT
	Pare de ficar repetindo!
BOT_REASON_REVERSE
	Por favor no user reversos no canal!
BOT_REASON_UNDERLINE
	No use sublinhados neste canal!
	
# !seen replies
BOT_SEEN_BOT
	Voc me encontrou, %s!
BOT_SEEN_YOU
	Procurando por si mesmo %s?
BOT_SEEN_ON_CHANNEL
	%s est no canal neste momento!
BOT_SEEN_ON_CHANNEL_AS
	%s est no canal neste momento (como %s) ! 
BOT_SEEN_ON
	%s foi visto aqui pela ltima vez %s atrs.
BOT_SEEN_NEVER
	Eu nunca vi %s neste canal.
BOT_SEEN_UNKNOWN
	Eu no sei quem  %s.
	
# BOT responses
BOT_BOT_SYNTAX
	BOT ADD nick user host real
	BOT CHANGE nickantigo nicknovo [user [host [real]]]
	BOT DEL nick
	BOT LIST
BOT_BOT_ALREADY_EXISTS
	Bot %s j existe.
BOT_BOT_CREATION_FAILED
	Desculpe, criao do bot falhou.
BOT_BOT_READONLY
	Desculpe, comando CHANGE temporariamente desativado.
BOT_BOT_ADDED
	%s!%s@%s (%s) adicionado a lista de bots.
BOT_BOT_ANY_CHANGES
	Informao antiga  igual a nova.
BOT_BOT_CHANGED
	Bot %s foi alterado para %s!%s@%s (%s)
BOT_BOT_DELETED
	Bot %s foi removido.
	
# BOTLIST responses
BOT_BOTLIST_HEADER
	Lista de bots:
BOT_BOTLIST_PRIVATE_HEADER
	Bots reserved to IRC operators:
BOT_BOTLIST_FOOTER
	%d bots available.
BOT_BOTLIST_EMPTY
	No existem bots disponveis no momento.
	Pergunte a um Administrador dos Services para criar mais bots!
	
# ASSIGN responses
BOT_ASSIGN_SYNTAX
	ASSIGN canal nick
BOT_ASSIGN_READONLY
	Desculpe, mas o comando ASSIGN est temporariamente desativado.
BOT_ASSIGN_ALREADY
	Bot %s is already assigned to channel %s.
BOT_ASSIGN_ASSIGNED
	Bot %s foi associado ao canal %s.
	
# UNASSIGN responses
BOT_UNASSIGN_SYNTAX
	UNASSIGN canal
BOT_UNASSIGN_UNASSIGNED
	No possui mais nenhum bot associado ao canal %s.
	
# INFO responses
BOT_INFO_SYNTAX
	INFO {canal | nick}
BOT_INFO_NOT_FOUND
	%s no  um bot vlido ou um canal registrado.
BOT_INFO_BOT_HEADER
	Informaes do bot %s:
BOT_INFO_BOT_MASK
	       Mscara : %s@%s
BOT_INFO_BOT_REALNAME
	     Nome real : %s
BOT_INFO_BOT_CREATED
	        Criado : %s
BOT_INFO_BOT_USAGE
	      Usado em : %d canal(is)
BOT_INFO_BOT_OPTIONS
	    Options : %s
BOT_INFO_OPT_PRIVATE
	Private
BOT_INFO_CHAN_HEADER
	Informaes do canal %s:
BOT_INFO_CHAN_BOT
	           Nick do bot : %s
BOT_INFO_CHAN_BOT_NONE
	           Nick do bot : nenhum associado no momento.
BOT_INFO_CHAN_KICK_BADWORDS
	     Kick por palavro : %s
BOT_INFO_CHAN_KICK_BADWORDS_BAN
	     Kick por palavro : %s (%d kick(s) para banir)
BOT_INFO_CHAN_KICK_BOLDS
	      Kick por negrito : %s
BOT_INFO_CHAN_KICK_BOLDS_BAN
	      Kick por negrito : %s (%d kick(s) para banir)
BOT_INFO_CHAN_KICK_CAPS_ON
	         Kick por Caps : %s (mnimo %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_BAN
	         Kick por Caps : %s (%d kick(s) para banir; mnimo %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_OFF
	         Kick por Caps : %s
BOT_INFO_CHAN_KICK_COLORS
	        Kick por cores : %s
BOT_INFO_CHAN_KICK_COLORS_BAN
	        Kick por cores : %s (%d kick(s) para banir)
BOT_INFO_CHAN_KICK_FLOOD_ON
	        Kick por flood : %s (%d linhas em %ds)
BOT_INFO_CHAN_KICK_FLOOD_BAN
	        Kick por flood : %s (%d kick(s) para banir; %d linhas em %ds)
BOT_INFO_CHAN_KICK_FLOOD_OFF
	        Kick por flood : %s
BOT_INFO_CHAN_KICK_REPEAT_ON
	    Kick por repetio : %s (%d vezes)
BOT_INFO_CHAN_KICK_REPEAT_BAN
	    Kick por repetio : %s (%d kick(s) para banir; %d vezes)
BOT_INFO_CHAN_KICK_REPEAT_OFF
	    Kick por repetio : %s
BOT_INFO_CHAN_KICK_REVERSES
	    Kick por reversos : %s
BOT_INFO_CHAN_KICK_REVERSES_BAN
	    Kick por reversos : %s (%d kick(s) para banir)
BOT_INFO_CHAN_KICK_UNDERLINES
	   Kick por sublinhado : %s
BOT_INFO_CHAN_KICK_UNDERLINES_BAN
	   Kick por sublinhado : %s (%d kick(s) para banir)
BOT_INFO_ACTIVE
	ativado
BOT_INFO_INACTIVE
	desativado
BOT_INFO_CHAN_OPTIONS
	                Opes : %s
BOT_INFO_OPT_DONTKICKOPS
	Proteo de Ops
BOT_INFO_OPT_DONTKICKVOICES
	Proteo de Voices
BOT_INFO_OPT_FANTASY
	Fantasia
BOT_INFO_OPT_GREET
	Mensagem de entrada
BOT_INFO_OPT_NOBOT
	Sem bot
BOT_INFO_OPT_SYMBIOSIS
	Simbiose
BOT_INFO_OPT_NONE
	Nenhuma
	
# SET responses
BOT_SET_SYNTAX
	SET canal opes configuraes
BOT_SET_DISABLED
	Desculpe, o comando SET est temporariamente desativado.
BOT_SET_UNKNOWN
	Opo desconhecida: %s.
	Digite /msg %S HELP SET para maiores informaes.
	
# SET DONTKICKOPS messages
BOT_SET_DONTKICKOPS_SYNTAX
	SET canal DONTKICKOPS {ON|OFF}
BOT_SET_DONTKICKOPS_ON
	Bot no ir kickar ops no canal %s.
BOT_SET_DONTKICKOPS_OFF
	Bot ir kickar ops no canal %s.
	
# SET DONTKICKVOICES messages
BOT_SET_DONTKICKVOICES_SYNTAX
	SET canal DONTKICKVOICES {ON|OFF}
BOT_SET_DONTKICKVOICES_ON
	Bot no ir kickar voices no canal %s.
BOT_SET_DONTKICKVOICES_OFF
	Bot ir kickar voices no canal %s.

# SET FANTASY messages
BOT_SET_FANTASY_SYNTAX
	SET canal FANTASY {ON|OFF}
BOT_SET_FANTASY_ON
	Modo Fantasia est agora ATIVADO no canal %s.
BOT_SET_FANTASY_OFF
	Modo Fantasia est agora DESATIVADO no canal %s.
	
# SET GREET messages
BOT_SET_GREET_SYNTAX
	SET canal GREET {ON|OFF}
BOT_SET_GREET_ON
	Modo mensagem de entrada est agora ATIVADO no canal %s.
BOT_SET_GREET_OFF
	Modo mensagem de entrada est agora DESATIVADO no canal %s.
	
# SET NOBOT
BOT_SET_NOBOT_SYNTAX
	SET canal NOBOT {ON|OFF}
BOT_SET_NOBOT_ON
	Modo NOBOT est agora ATIVADO no canal %s.
BOT_SET_NOBOT_OFF
	Modo NOBOT est agora DESATIVADO no canal %s.
	
# SET SYMBIOSIS
BOT_SET_PRIVATE_SYNTAX
	SET channel PRIVATE {ON|OFF}
BOT_SET_PRIVATE_ON
	Private mode of bot %s is now ON.
BOT_SET_PRIVATE_OFF
	Private mode of bot %s is now OFF.

# SET SYMBIOSIS
BOT_SET_SYMBIOSIS_SYNTAX
	SET canal SYMBIOSIS {ON|OFF}
BOT_SET_SYMBIOSIS_ON
	Modo SYMBIOSIS est agora ATIVADO no canal %s.
BOT_SET_SYMBIOSIS_OFF
	Modo SYMBIOSIS est agora DESATIVADO no canal %s.
	
# KICK responses
BOT_KICK_SYNTAX
	KICK canal opes {ON|OFF} [configuraes]
BOT_KICK_DISABLED
	Desculpe, as configuraes do kicker esto temporariamente desativadas.
BOT_KICK_UNKNOWN
	Opo desconhecida: %s.
	Digite /msg %S HELP KICK para maiores informaes.
BOT_KICK_BAD_TTB
	%s no pode ser colocado como tempo para ban.

BOT_KICK_BADWORDS_ON
	O bot ir agora kickar por palavres. Use o comando
	BADWORDS para adicionar ou remover um palavro.
BOT_KICK_BADWORDS_ON_BAN
	O bot ir agora kickar por palavres, e ir setar um ban 
	aps %d kicks no mesmo usurio. Use o comando BADWORDS
	para adicionar ou remover um palavro.
BOT_KICK_BADWORDS_OFF
	O bot no ir mais kickar por palavres.
BOT_KICK_BOLDS_ON
	O bot ir agora kickar por negritos.
BOT_KICK_BOLDS_ON_BAN
	O bot ir agora kickar por negritos, e ir setar um ban 
	aps %d kicks no mesmo usurio.
BOT_KICK_BOLDS_OFF
	O bot no ir mais kickar por negritos.
BOT_KICK_CAPS_ON
	O bot ir agora kickar por caps (deve ter no mnimo
	%d caracteres e %d%% na mensagem inteira).
BOT_KICK_CAPS_ON_BAN
	O bot ir agora kickar por caps (deve ter no mnimo
	%d caracteres e %d%% na mensagem inteira), e ir setar
	um ban aps %d kicks no mesmo usurio.
BOT_KICK_CAPS_OFF
	O bot no ir mais kickar por caps.
BOT_KICK_COLORS_ON
	O bot ir agora kickar por cores.
BOT_KICK_COLORS_ON_BAN
	O bot ir agora kickar por cores, e ir setar um ban aps %d 
	kicks no mesmo usurio.
BOT_KICK_COLORS_OFF
	O bot no ir mais kickar por cores.
BOT_KICK_FLOOD_ON
	O bot ir agora kickar por flood (%d linhas em %d segundos).
BOT_KICK_FLOOD_ON_BAN
	O bot ir agora kickar por flood (%d linhas em %d segundos), e 
	setar um ban aps %d kicks no mesmo usurio.
BOT_KICK_FLOOD_OFF
	O bot no ir mais kickar por flood.
BOT_KICK_REPEAT_ON
	O bot ir agora kickar por repetio (usurios que escreverem
	%d vezes a mesma coisa).
BOT_KICK_REPEAT_ON_BAN
	O bot ir agora kickar por repetio (usurios que escreverem
	%d vezes a mesma coisa), e ir setar um ban aps %d 
	kicks no mesmo usurio.
BOT_KICK_REPEAT_OFF
	O bot no ir mais kickar por repetio.
BOT_KICK_REVERSES_ON
	O bot ir agora kickar por reversos.
BOT_KICK_REVERSES_ON_BAN
	O bot ir agora kickar por reversos, e ir setar um ban aps %d 
	kicks no mesmo usurio.
BOT_KICK_REVERSES_OFF
	O bot no ir mais kickar por reversos.
BOT_KICK_UNDERLINES_ON
	O bot ir agora kickar por sublinhados.
BOT_KICK_UNDERLINES_ON_BAN
	O bot ir agora kickar por sublinhados, e ir setar um ban aps %d 
	kicks no mesmo usurio.
BOT_KICK_UNDERLINES_OFF
	O bot no ir mais kickar por sublinhados.
	
# BADWORDS messages
BOT_BADWORDS_SYNTAX
	BADWORDS canal {ADD|DEL|LIST|CLEAR} [palavra | lista] [SINGLE|START|END]
BOT_BADWORDS_DISABLED
	Desculpe, o comando BADWORDS est temporariamente desatvado.
BOT_BADWORDS_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d palavres em sua lista.
BOT_BADWORDS_ALREADY_EXISTS
	%s j existe na lista de palavres do %s.
BOT_BADWORDS_ADDED
	%s adicionado na lista de palavres do %s.
BOT_BADWORDS_NO_SUCH_ENTRY
	Entrada no encontrada (#%d) na lista de palavres do %s.
BOT_BADWORDS_NOT_FOUND
	%s no foi encontrado na lista de palavres do %s.
BOT_BADWORDS_NO_MATCH
	Nenhum resultado correspondente encontrado na lista do %s.
BOT_BADWORDS_DELETED
	%s removido da lista de palavres do %s.
BOT_BADWORDS_DELETED_ONE
	Removida 1 entrada da lista de palavres do %s.
BOT_BADWORDS_DELETED_SEVERAL
	Removidas %d entradas da lista de palavres do %s.
BOT_BADWORDS_LIST_EMPTY
	Lista de palvres do %s est vazia.
BOT_BADWORDS_LIST_HEADER
	Lista de palavres do %s:
	  Nm   Palavra                        Tipo
BOT_BADWORDS_LIST_FORMAT
	  %3d   %-30s %s
BOT_BADWORDS_CLEAR
	Lista de palavres est agora vazia.

# SAY responses
BOT_SAY_SYNTAX
	SAY canal texto

# ACT responses
BOT_ACT_SYNTAX
	ACT canal texto

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
BOT_EXCEPT
	User matches channel except.

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
BOT_BAD_NICK
	Bot Nicks may only contain valid nick characters.
BOT_BAD_HOST
	Bot Hosts may only contain valid host characters.
BOT_BAD_IDENT
	Bot Idents may only contain valid characters.
###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	Os services no conseguiram alterar os modos.  Seus servers esto configurados corretamente?
OPER_BOUNCY_MODES_U_LINE
	Os services no conseguiram alterar os modos.  As U:lines do seus servers esto configuradas corretamente?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL mensagem

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Opo STATS desconhecida: %s.
OPER_STATS_CURRENT_USERS
	Usurios atuais: %d (%d ops)
OPER_STATS_MAX_USERS
	Mximo atingido: %d (%s)
# This is ugly, but at least it's language-portable...
# Note that you can include seconds in any of these--my personal preference
# is to only give resolution to the nearest minute when uptime is one hour
# or more, but just add a %d to get seconds as well.
OPER_STATS_UPTIME_DHMS
	Services ativos %d dias, %02d:%02d
OPER_STATS_UPTIME_1DHMS
	Services ativos %d dia, %02d:%02d
OPER_STATS_UPTIME_HMS
	Services ativos %d horas, %d minutos
OPER_STATS_UPTIME_HM1S
	Services ativos %d horas, %d minutos
OPER_STATS_UPTIME_H1MS
	Services ativos %d horas, %d minut0
OPER_STATS_UPTIME_H1M1S
	Services ativos %d horas, %d minut0
OPER_STATS_UPTIME_1HMS
	Services ativos %d hora, %d minutos
OPER_STATS_UPTIME_1HM1S
	Services ativos %d hora, %d minutos
OPER_STATS_UPTIME_1H1MS
	Services ativos %d hora, %d minuto
OPER_STATS_UPTIME_1H1M1S
	Services ativos %d hora, %d minuto
OPER_STATS_UPTIME_MS
	Services ativos %d minutos, %d segundos
OPER_STATS_UPTIME_M1S
	Services ativos %d minutos, %d segundo
OPER_STATS_UPTIME_1MS
	Services ativos %d minuto, %d segundos
OPER_STATS_UPTIME_1M1S
	Services ativos %d minuto, %d segundo
OPER_STATS_BYTES_READ
	Bytes lidos   : %5d kB
OPER_STATS_BYTES_WRITTEN
	Bytes escritos: %5d kB
OPER_STATS_USER_MEM
	Usurios      : %6d registros, %5d kB
OPER_STATS_CHANNEL_MEM
	Channel       : %6d registros, %5d kB
OPER_STATS_GROUPS_MEM
	NS Grupos     : %6d registros, %5d kB
OPER_STATS_ALIASES_MEM
	NS Aliases    : %6d registros, %5d kB
OPER_STATS_CHANSERV_MEM
	ChanServ      : %6d registros, %5d kB
OPER_STATS_BOTSERV_MEM
	BotServ       : %6d registros, %5d kB
OPER_STATS_OPERSERV_MEM
	OperServ      : %6d registros, %5d kB
OPER_STATS_SESSIONS_MEM
	Sesses       : %6d registros, %5d kB
OPER_STATS_PROXY_MEM
	Proxies       : %6d records, %5d kB
OPER_STATS_AKILL_COUNT
	Nmero atual de AKILLs: %d
OPER_STATS_AKILL_EXPIRE_DAYS
	Tempo atual de expirao de akill: %d dias
OPER_STATS_AKILL_EXPIRE_DAY
	Tempo atual de expirao de akill: 1 dia
OPER_STATS_AKILL_EXPIRE_HOURS
	Tempo atual de expirao de akill: %d horas
OPER_STATS_AKILL_EXPIRE_HOUR
	Tempo atual de expirao de akill: 1 hora
OPER_STATS_AKILL_EXPIRE_MINS
	Tempo atual de expirao de akill: %d minutos
OPER_STATS_AKILL_EXPIRE_MIN
	Tempo atual de expirao de akill: 1 minuto
OPER_STATS_AKILL_EXPIRE_NONE
	Tempo atual de expirao de akill: No expira
OPER_STATS_SGLINE_COUNT
	Nmero atual de SGLINEs: %d
OPER_STATS_SGLINE_EXPIRE_DAYS
	Tempo atual de expirao de SGLINE: %d dias
OPER_STATS_SGLINE_EXPIRE_DAY
	Tempo atual de expirao de SGLINE: 1 dia
OPER_STATS_SGLINE_EXPIRE_HOURS
	Tempo atual de expirao de SGLINE: %d horas
OPER_STATS_SGLINE_EXPIRE_HOUR
	Tempo atual de expirao de SGLINE: 1 hora
OPER_STATS_SGLINE_EXPIRE_MINS
	Tempo atual de expirao de SGLINE: %d minutos
OPER_STATS_SGLINE_EXPIRE_MIN
	Tempo atual de expirao de SGLINE: 1 minuto
OPER_STATS_SGLINE_EXPIRE_NONE
	Tempo atual de expirao de SGLINE: No expira
OPER_STATS_SQLINE_COUNT
	Current number of SQLINEs: %d
OPER_STATS_SQLINE_EXPIRE_DAYS
	Default SQLINE expiry time: %d days
OPER_STATS_SQLINE_EXPIRE_DAY
	Default SQLINE expiry time: 1 day
OPER_STATS_SQLINE_EXPIRE_HOURS
	Default SQLINE expiry time: %d hours
OPER_STATS_SQLINE_EXPIRE_HOUR
	Default SQLINE expiry time: 1 hour
OPER_STATS_SQLINE_EXPIRE_MINS
	Default SQLINE expiry time: %d minutes
OPER_STATS_SQLINE_EXPIRE_MIN
	Default SQLINE expiry time: 1 minute
OPER_STATS_SQLINE_EXPIRE_NONE
	Default SQLINE expiry time: No expiration
OPER_STATS_SZLINE_COUNT
	Nmero atual de SZLINEs: %d
OPER_STATS_SZLINE_EXPIRE_DAYS
	Tempo atual de expirao de SZLINE: %d dias
OPER_STATS_SZLINE_EXPIRE_DAY
	Tempo atual de expirao de SZLINE: 1 dia
OPER_STATS_SZLINE_EXPIRE_HOURS
	Tempo atual de expirao de SZLINE: %d horas
OPER_STATS_SZLINE_EXPIRE_HOUR
	Tempo atual de expirao de SZLINE: 1 hora
OPER_STATS_SZLINE_EXPIRE_MINS
	Tempo atual de expirao de SZLINE: %d minutos
OPER_STATS_SZLINE_EXPIRE_MIN
	Tempo atual de expirao de SZLINE: 1 minuto
OPER_STATS_SZLINE_EXPIRE_NONE
	Tempo atual de expirao de SZLINE: No expira
OPER_STATS_RESET
	Resetar estatsticas.

# MODE responses
OPER_MODE_SYNTAX
	MODE canal modos

# CLEARMODES responses
OPER_UMODE_SYNTAX
	UMODE nick modes

# OLINE responses
OPER_UMODE_SUCCESS
	Changed usermodes of %s.
OPER_UMODE_CHANGED
	%s changed your usermodes.

# OLINE responses
OPER_OLINE_SYNTAX
	OLINE nick flags
OPER_OLINE_SUCCESS
	An O:Line with the flags %s has been added for %s.

# CLEARMODES responses
OPER_OLINE_IRCOP
	You are now an IRC Operator.

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES canal [ALL]
OPER_CLEARMODES_DONE
	Modos binrios e bans removidos do canal %s.
OPER_CLEARMODES_ALL_DONE
	Todos os modos foram removidos do canal %s.


# KICK responses
OPER_KICK_SYNTAX
	KICK canal usurio motivo
	
# ADMIN responses
OPER_SVSNICK_SYNTAX
	SVSNICK nick newnick 
OPER_SVSNICK_NEWNICK
	The nick %s is now being changed to %s.
	
# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD|DEL|LIST|CLEAR} [nick | lista]
OPER_ADMIN_SKELETON
	Services esto no modo esqueleto; o comando ADMIN no est disponvel.
OPER_ADMIN_EXISTS
	%s j est na lista de Administradores dos Services.
OPER_ADMIN_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d Administradores dos Services.
OPER_ADMIN_ADDED
	%s adicionado a lista de Administradores dos Services.
OPER_ADMIN_NOT_FOUND
	%s no encontrado na lista de Administradores dos Services.
OPER_ADMIN_NO_MATCH
	Nenhum resultado encontrado na lista de Administradores dos Services.
OPER_ADMIN_DELETED
	%s removido da lista de Administradores dos Services.
OPER_ADMIN_DELETED_ONE
	Removida 1 entrada da lista de Administradores dos Services.
OPER_ADMIN_DELETED_SEVERAL
	Removidas %d entradas da lista de Administradores dos Services.
OPER_ADMIN_LIST_EMPTY
	A lista de Administradores dos Services est vazia.
OPER_ADMIN_LIST_HEADER
	Lista de Administradores dos Services:
	  Nm   Nick
OPER_ADMIN_LIST_FORMAT
	  %3d   %s
OPER_ADMIN_CLEAR
	Lista de Administradores dos Services foi apagada.

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD|DEL|LIST|CLEAR} [nick | lista]
OPER_OPER_SKELETON
	Services esto no modo esqueleto; o comando OPER no est disponvel..
OPER_OPER_EXISTS
	%s j est na lista de Operadores dos Services.
OPER_OPER_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d Operadores dos Services.
OPER_OPER_ADDED
	%s adicionado a lista de Operadores dos Services.
OPER_OPER_NOT_FOUND
	%s no encontrado na lista de Operadores dos Services.
OPER_OPER_NO_MATCH
	Nenhum resultado equivalente na lista de Operadores dos Services.
OPER_OPER_DELETED
	%s removido da lista de Operadores dos Services.
OPER_OPER_DELETED_ONE
	Removida 1 entrada da lista de Operadores dos Services.
OPER_OPER_DELETED_SEVERAL
	Removidas %d entradas da lista de Operadores dos Services.
OPER_OPER_LIST_EMPTY
	A lista de Operadores dos Services est vazia.
OPER_OPER_LIST_HEADER
	Lista de Operadores dos Services:
	  Nm   Nick
OPER_OPER_LIST_FORMAT
	  %3d   %s
OPER_OPER_CLEAR
	A lista de Operadores dos Services foi apagada.

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | CLEAR} [[+tempo] {mscara | lista} [motivo]]
OPER_AKILL_EXISTS
	%s j se encontra na lista de AKILL.
OPER_AKILL_ALREADY_COVERED
	%s j est coberto pelo AKILL %s.
OPER_AKILL_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d AKILLs.
OPER_AKILL_NO_NICK
	Lembrete: As mscaras de AKILL no devem conter o nick; tenha certeza de que voc no incluiu o nick na mscara.
OPER_AKILL_ADDED
	%s adicionado a lista de AKILL.
OPER_AKILL_CHANGED
	Tempo de expirao para %s alterado.
OPER_AKILL_NOT_FOUND
	%s no encontrado na lista de AKILL.
OPER_AKILL_NO_MATCH
	Nenhum resultado equivalente na lista de AKILL.
OPER_AKILL_DELETED
	%s removido da lista de AKILL.
OPER_AKILL_DELETED_ONE
	Removida 1 entrada da lista de AKILL.
OPER_AKILL_DELETED_SEVERAL
	Removidas %d entradas da lista de AKILL.
OPER_AKILL_LIST_EMPTY
	A lista de AKILL est vazia.
OPER_AKILL_LIST_HEADER
	Current AKILL list:
	  Nm   Mscara                           Motivo
OPER_AKILL_LIST_FORMAT
	  %3d   %-32s  %s
OPER_AKILL_VIEW_HEADER
	Lista de AKILL atual:
# number, mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_FORMAT
	%3d  %s (por %s em %s; %s)
	      %s
OPER_AKILL_CLEAR
	Lista de AKILL apagada.
	
# SGLINE responses
OPER_CHANKILL_SYNTAX
	CHANAKILL [+expiry] {#channel} [reason]
# SGLINE responses
OPER_SGLINE_SYNTAX
	SGLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+tempo] {mscara | lista}[:motivo]]
OPER_SGLINE_UNSUPPORTED
	Desculpe, o comando SGLINE no est disponvel nesta Rede.
OPER_SGLINE_EXISTS
	%s j se encontra na lista de SGLINE.
OPER_SGLINE_ALREADY_COVERED
	%s j est coberto por %s.
OPER_SGLINE_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d SGLINEs.
OPER_SGLINE_ADDED
	%s adicionado a lista de SGLINE.
OPER_SGLINE_CHANGED
	Tempo de expirao para %s aterado.
OPER_SGLINE_NOT_FOUND
	%s no encontrado na lista de SGLINE.
OPER_SGLINE_NO_MATCH
	Nenhum resultado equivalente na lista de SGLINE.
OPER_SGLINE_DELETED
	%s removido da lista de SGLINE.
OPER_SGLINE_DELETED_ONE
	Removida 1 entrada da lista de SGLINE.
OPER_SGLINE_DELETED_SEVERAL
	Removidas %d entradas da lista de SGLINE.
OPER_SGLINE_LIST_EMPTY
	A lista de SGLINE est vazia.
OPER_SGLINE_LIST_HEADER
	Current SGLINE list:
	  Nm   Mscara                           Motivo
OPER_SGLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SGLINE_VIEW_HEADER
	Current SGLINE list:
# number, mask, set-by, set-time, expires, reason
OPER_SGLINE_VIEW_FORMAT
	%3d  %s (por %s em %s; %s)
	      %s
OPER_SGLINE_CLEAR
	A lista  de SGLINE foi apagada.

# SZLINE responses
OPER_SQLINE_SYNTAX
	SQLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+expiry] {mask | entry-list} [reason]]
OPER_SQLINE_CHANNELS_UNSUPPORTED
	Channel SQLINEs are not supported by your IRCd, so you can't use them.
OPER_SQLINE_EXISTS
	%s already exists on the SQLINE list.
OPER_SQLINE_ALREADY_COVERED
	%s is already covered by %s.
OPER_SQLINE_REACHED_LIMIT
	Sorry, you can only have %d SQLINEs.
OPER_SQLINE_ADDED
	%s added to the SQLINE list.
OPER_SQLINE_CHANGED
	Expiry time of %s changed.
OPER_SQLINE_NOT_FOUND
	%s not found on the SQLINE list.
OPER_SQLINE_NO_MATCH
	No matching entries on the SQLINE list.
OPER_SQLINE_DELETED
	%s deleted from the SQLINE list.
OPER_SQLINE_DELETED_ONE
	Deleted 1 entry from the SQLINE list.
OPER_SQLINE_DELETED_SEVERAL
	Deleted %d entries from the SQLINE list.
OPER_SQLINE_LIST_EMPTY
	SQLINE list is empty.
OPER_SQLINE_LIST_HEADER
	Current SQLINE list:
	  Num   Mask                              Reason
OPER_SQLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SQLINE_VIEW_HEADER
	Current SQLINE list:
# number, mask, set-by, set-time, expires, reason
OPER_SQLINE_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_SQLINE_CLEAR
	The SQLINE list has been cleared.

# SZLINE responses
OPER_SZLINE_SYNTAX
	SZLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+tempo] {mscara | lista} [motivo]]
OPER_SZLINE_UNSUPPORTED
	Desculpe, comando SZLINE no disponvel nesta Rede.
OPER_SZLINE_EXISTS
	%s j existe na lista de SZLINE.
OPER_SZLINE_ALREADY_COVERED
	%s j est coberto por %s.
OPER_SZLINE_REACHED_LIMIT
	Desculpe, voc pode ter apenas %d SZLINEs.
OPER_SZLINE_ONLY_IPS
	Lembrete: voc pode apenas adicionar endereos de IP para a lista de SZLINE.
OPER_SZLINE_ADDED
	%s adicionado a lista de SZLINE.
OPER_SZLINE_CHANGED
	Tempo de expirao para %s alterado.
OPER_SZLINE_NOT_FOUND
	%s no foi encontrado na lista de SZLINE.
OPER_SZLINE_NO_MATCH
	Nenhum resultado equivalente na lista de SZLINE.
OPER_SZLINE_DELETED
	%s removido da lista de SZLINE.
OPER_SZLINE_DELETED_ONE
	Removida 1 entrada da lista de SZLINE.
OPER_SZLINE_DELETED_SEVERAL
	Removidas %d entradas da lista de SZLINE.
OPER_SZLINE_LIST_EMPTY
	A lista de SZLINE est vazia.
OPER_SZLINE_LIST_HEADER
	Lista atual de SZLINE:
	  Nm   Mscara                           Motivo
OPER_SZLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SZLINE_VIEW_HEADER
	Current SZLINE list:
# number, mask, set-by, set-time, expires, reason
OPER_SZLINE_VIEW_FORMAT
	%3d  %s (por %s em %s; %s)
	      %s
OPER_SZLINE_CLEAR
	A lista de SZLINE foi apagada.

# SET responses
OPER_SET_SYNTAX
	SET opo configurao
OPER_SET_IGNORE_ON
	Opo IGNORE ser usada.
OPER_SET_IGNORE_OFF
	Opo IGNORE no ser usada.
OPER_SET_IGNORE_ERROR
	Configurao do IGNORE deve ser ON ou OFF.
OPER_SET_READONLY_ON
	Services esto agora no modo somente leitura.
OPER_SET_READONLY_OFF
	Services esto agora no modo leitura e gravao.
OPER_SET_READONLY_ERROR
	Configurao do READONLY deve ser ON ou OFF.
OPER_SET_LOGCHAN_ON
	Services esto enviando o log no canal %s.
OPER_SET_LOGCHAN_OFF
	Services deixando de enviar o log.
OPER_SET_LOGCHAN_ERROR
	Configurao do LOGCHAN deve ser ON ou OFF e LogChan deve estar definido.
OPER_SET_DEBUG_ON
	Services esto agora no modo debug.
OPER_SET_DEBUG_OFF
	Services no esto mais no modo debug.
OPER_SET_DEBUG_LEVEL
	Services esto agora no modo debug (nvel %d).
OPER_SET_DEBUG_ERROR
	Configurao do DEBUG deve ser ON, OFF, ou um nmero positivo.
OPER_SET_NOEXPIRE_ON
	Services esto agora no modo no expira.
OPER_SET_NOEXPIRE_OFF
	Services esto agora no modo expira.
OPER_SET_NOEXPIRE_ERROR
	Opo NOEXPIRE deve ser ON ou OFF.
OPER_SET_UNKNOWN_OPTION
	Opo desconhecida: %s.

# NOOP responses
OPER_NOOP_SYNTAX
	NOOP {SET|REVOKE} servidor
OPER_NOOP_SET
	Todas as O:lines do servidor %s foram removidas.
OPER_NOOP_REVOKE
	Todas as O:lines do servidor %s foram resetadas.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE server [motivo]

# RAW responses
OPER_JUPE_HOST_ERROR
	Please use a valid server name when juping
	
# RAW responses
OPER_RAW_SYNTAX
	RAW texto

# UPDATE responses
OPER_UPDATING
	Atualizando banco de dados.
	
# RELOAD responses
OPER_RELOAD
	Arquivos de configurao dos services foram recarregados.

# RESTART responses
OPER_CANNOT_RESTART
	SERVICES_BIN no definido; no foi possvel reiniciar.  Rode novamente o \2configure\2 e reconfigure os services para habilitar o comando RESTART.

# LISTIGNORE responses
OPER_IGNORE_SYNTAX
	Syntax: IGNORE {ADD|DEL|LIST|CLEAR} [time] [nick]
OPER_IGNORE_VALID_TIME
	You have to enter a valid number as time.
OPER_IGNORE_TIME_DONE
	%s will now be ignored for %s.
OPER_IGNORE_PERM_DONE
	%s will now permanently be ignored.
OPER_IGNORE_DEL_DONE
	%s will no longer be ignored.
OPER_IGNORE_LIST
	Lista de ignore dos Services:
OPER_IGNORE_LIST_NOMATCH
	%s not found on ignore list.
OPER_IGNORE_LIST_EMPTY
	Lista de ignore dos Services vazia.

# KILLCLONES responses
OPER_IGNORE_LIST_CLEARED
	Ignore list has been cleared.

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES nick
OPER_KILLCLONES_UNKNOWN_NICK
	No foi possvel encontrar o nick %s.
	
# CHANLIST responses
OPER_CHANLIST_HEADER
	Lista de canais:
	Nome                 Users Tpico
OPER_CHANLIST_HEADER_USER
	Lista de canais do %s:
	Nome                 Users Tpico
OPER_CHANLIST_RECORD
	%-20s  %4d %s
OPER_CHANLIST_END
	Fim da listagem.
	
# USERLIST responses
OPER_USERLIST_HEADER
	Lista de usurios:
	Nick                 Mscara
OPER_USERLIST_HEADER_CHAN
	Lista de users do %s:
	Nick                 Mscara
OPER_USERLIST_RECORD
	%-20s %s@%s
OPER_USERLIST_END
	Fim da listagem.

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_CACHE_SYNTAX
	CACHE {DEL | LIST} {hostname | pattern} [QUEUED | ALL]
OPER_CACHE_DISABLED
	Proxy detection is disabled.
OPER_CACHE_NOT_FOUND
	%s was not found in the cache.
OPER_CACHE_REMOVED
	%s has been removed from the cache.
OPER_CACHE_HEADER
	Hostname                                         Status
OPER_CACHE_LIST
	%-48s %s
OPER_CACHE_FOOTER
	End of list - %d/%d matches shown.
OPER_CACHE_QUEUED
	Queued
OPER_CACHE_PROGRESS
	In progress
OPER_CACHE_NORMAL
	Normal
OPER_CACHE_WINGATE
	Wingate
OPER_CACHE_SOCKS4
	SOCKS 4
OPER_CACHE_SOCKS5
	SOCKS 5
OPER_CACHE_HTTP
	HTTP proxy

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_SUPER_ADMIN_ON
	You are now a SuperAdmin
OPER_SUPER_ADMIN_OFF
	You are no longer a SuperAdmin
OPER_SUPER_ADMIN_SYNTAX
	Setting for SuperAdmin must be ON or OFF.
OPER_SUPER_ADMIN_WALL_ON
	%s is now a Super-Admin
OPER_SUPER_ADMIN_WALL_OFF
	%s is no longer a Super-Admin

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_SUPER_ADMIN_ONLY
	Only Super-Admins can use this command.

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_STAFF_LIST_HEADER
	On Level Nick

# DefCon Messages

OPER_STAFF_FORMAT
	 %c %s  %s
OPER_STAFF_AFORMAT
	 %c %s  %s [%s]

# DefCon Messages

OPER_DEFCON_SYNTAX
	Syntax: DEFCON [1|2|3|4|5]
OPER_DEFCON_DENIED
	This service is temporarly disabled, please try again later
OPER_DEFCON_NO_CONF
	The Defcon system must be enabled in the services.conf file
OPER_DEFCON_CHANGED
	Services are now at DEFCON %d
OPER_DEFCON_WALL
	%s Changed the DEFCON level to %d
DEFCON_GLOBAL
	The Defcon Level is now at Level: %d

# Modules strings

OPER_MODULE_LOADED
	Module %s loaded
OPER_MODULE_UNLOADED
	Module %s unloaded
OPER_MODULE_LOAD_FAIL
	Unable to load module %s
OPER_MODULE_REMOVE_FAIL
	Unable to remove module %s
OPER_MODULE_LOAD_SYNTAX
	MODLOAD FileName
OPER_MODULE_UNLOAD_SYNTAX
	MODUNLOAD FileName
OPER_MODULE_LIST
	Module: %s
OPER_MODULE_INFO_LIST
	Module: %s Version: %s Author: %s loaded: %s
OPER_MODULE_CMD_LIST
	Providing command: /msg %s %s
OPER_MODULE_MSG_LIST
	Providing IRCD handler for: %s
OPER_MODULE_NO_LIST
	No modules currently loaded
OPER_MODULE_NO_INFO
	No information about module %s is available
OPER_MODULE_INFO_SYNTAX
	MODINFO FileName

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
MODULE_HELP_HEADER
	The following commands have been loaded by a module:

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [parmetros]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+tempo] mscara limite motivo
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {mscara | lista}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE nm posio
OPER_EXCEPTION_DISABLED
	Opo de limite de sesses desabilitada.
OPER_EXCEPTION_ALREADY_PRESENT
	Mscara %s j presente na lista de limite de sesses.
OPER_EXCEPTION_TOO_MANY
	Lista de limite de sesses est cheia!
OPER_EXCEPTION_ADDED
	Limite de sesses para %s  agora de %d.
OPER_EXCEPTION_MOVED
	Sesso para %s (#%d) alterada para a posio %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	Nenhuma entrada equivalente (#%d) na lista de limite de sesses.
OPER_EXCEPTION_NOT_FOUND
	%s no encontrado na lista de limite de sesses.
OPER_EXCEPTION_NO_MATCH
	Nenhum resultado encontrado na lista de limite de sesses.
OPER_EXCEPTION_DELETED
	%s removido da lista de limite de sesses.
OPER_EXCEPTION_DELETED_ONE
	Removida 1 entrada da lista de limite de sesses.
OPER_EXCEPTION_DELETED_SEVERAL
	Removidas %d entradas da lista de limite de sesses.
OPER_EXCEPTION_LIST_HEADER
	Atual lista de Kimite de sesses:
# mask, limit
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
OPER_EXCEPTION_LIST_COLHEAD
	Nm  Limite  Host
# mask, set-by, set-time, expires, limit, reason
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (por %s em %s; %s)
	    Limite: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	Limite de sesso invlida. O limite deve ser um nmero inteiro maior ou igual a zero e menor que %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	Mscara invlida. Apenas mscaras (hosts) so vlidas como excees aos limites de sesses. Nick ou username no so vlidos.

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST limite | VIEW host}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST limite
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW host
OPER_SESSION_DISABLED
	Limite de sesses est desativado.
OPER_SESSION_INVALID_THRESHOLD
	Nmero invlido. Deve ser um nmero inteiro maior que 1.
OPER_SESSION_NOT_FOUND
	%s no encontrado na lista de Limite de Sesses.
OPER_SESSION_LIST_HEADER
	Hosts com pelo menos %d sesses:
OPER_SESSION_LIST_COLHEAD
	Sesses  Host
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	O host %s possui atualmente %d sesses com um limite de %d.

# EXCEPTION help

OPER_HELP_EXCEPTION
	Sintaxe: EXCEPTION ADD [+tempo] mscara limite motivo
	         EXCEPTION DEL {mscara | lista}
	         EXCEPTION MOVE nm posio
	         EXCEPTION LIST [mscara | lista]
	         EXCEPTION VIEW [mscara | lista]
	
	Permite que os Administradores dos Services manipulem a lista
	de hosts que tenham limite de conexes especificados - deixando 
	certos hosts, como shell de servidores, conectar mais que o
	nmero padro de conexes simultneas. Uma vez um host atingindo
	um limite de conexo, todos os clientes que tentem conectar 
	daquele host sero expulsos ("killados").

	Antes do usurio ser expulso ("killado"), ele ser notificado
	via /NOTICE do %S com um tpico de ajuda sobre limitao
	de conexes.
	
	EXCEPTION ADD adiciona a mscara fornecida  lista de excees.
	Note que as mscaras nick!user@host e user@host so
	invlidas. S nomes reais de hosts, como mail.dominio.com e 
	*.dominio.com, so permitidos porque a limitao de
	conexo no utiliza o nick ou ident para bloquear o acesso. 
	
	EXCEPTION DEL remove a mscara especificada da Lista de
	excees.
	EXCEPTION MOVE move uma exceo de nmero num para uma
	posio dada. As excees que estavam na faixa onde houve
	alterao sero todas movidas para cima ou para baixo conforme
	for o deslocamento necessrio.
	EXCEPTION LIST ou EXCEPTION VIEW mostram todas as 
	excees atuais vlidas; se uma mscara  dada como parmetro
	opcional, a lista  limitada as excees que so compatveis
	com a mscara dada. A diferenca  que EXCEPTION VIEW 
	 mais detalhado, mostrando o nome da pessoa que adicionou 
	a exceo, o seu limite de conexes, o motivo, a mscara do
	host, a data e o tempo de validade.
	
	Note que um cliente que conecte vai usar a primeira exceo
	que for compatvel com o seu host. Listas de excees muito
	grandes e mscaras de hosts muito abrangentes certamente
	iro degradar a eficcia de funcionamento ("performance")
	dos services.
	
	Limitado aos Administradores dos Services.

OPER_HELP_SESSION
	Sintaxe: SESSION LIST nmero
	         SESSION VIEW host
	
	Permite que os Administradores dos Services vejam a lista de
	conexes.
	
	SESSION LIST lista mscaras de hosts com pelo menos 
	nmero conexes permitidas.
	O limite deve ser um nmero maior que 1. Isto deve previnir 
	a listagem de muitos hosts com um limite de conexes 
	limitado a 1.
	SESSION VIEW mostra informaes detalhadas sobre um host
	especfico, incluindo o nmero de conexes atual e o limite
	A mscara dada em host no deve incluir wildcards.
	
	Veja a ajuda sobre EXCEPTION para mais informaes sobre
	o limite de conexes e como especificar limites de conexes
	para certos hosts e grupos de hosts.
	
	Limitado aos Administradores dos Services.

###########################################################################
#
# News system messages
#
###########################################################################

OPER_HELP_STAFF
	Syntax: STAFF

	Displays all Services Staff nicks along with level
	and on-line status.

OPER_HELP_DEFCON
	Syntax: DEFCON [1|2|3|4|5]

	The defcon system can be used to implement a pre-defined
	set of restrictions to services useful during an attemtped
	attack on the network.

OPER_HELP_DEFCON_NO_NEW_CHANNELS
	* No new channel registrations
OPER_HELP_DEFCON_NO_NEW_NICKS
	* No new nick registrations
OPER_HELP_DEFCON_NO_MLOCK_CHANGE
	* No MLOCK changes
OPER_HELP_DEFCON_FORCE_CHAN_MODES
	* Force Chan Modes (%s) to be set on all channels
OPER_HELP_DEFCON_REDUCE_SESSION
	* Use the reduced session limit of %d
OPER_HELP_DEFCON_NO_NEW_CLIENTS
	* Kill any NEW clients connecting
OPER_HELP_DEFCON_OPER_ONLY
	* Ignore any non-opers with message
OPER_HELP_DEFCON_SILENT_OPER_ONLY
	* Silently ignore non-opers
OPER_HELP_DEFCON_AKILL_NEW_CLIENTS
	* AKILL any new clients connecting


###########################################################################
#
# News system messages
#
###########################################################################

OPER_HELP_DEFCON_NO_NEW_MEMOS
	* No new memos sent
OPER_HELP_CHANKILL
	Syntax: CHANKILL [+expiry] channel reason

	Puts an AKILL for every nick on the specified channel. It
	uses the entire and complete real ident@host for every nick,
	then enforces the AKILL. 

###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[Logon News - %s] %s
NEWS_OPER_TEXT
	[Oper News - %s] %s

NEWS_RANDOM_TEXT
	[Random News - %s] %s

NEWS_LOGON_SYNTAX
	Sintaxe: LOGONNEWS {ADD|DEL|LIST} [texto|nm]
NEWS_LOGON_LIST_HEADER
	Logon news items:
NEWS_LOGON_LIST_ENTRY
	%5d (%s por %s)
	    %s
NEWS_LOGON_LIST_NONE
	No existem logon news.
NEWS_LOGON_ADD_SYNTAX
	Sintaxe: LOGONNEWS ADD texto
NEWS_LOGON_ADD_FULL
	Lista de logon news est cheia!
NEWS_LOGON_ADDED
	Adicionado novo logon news (#%d).
NEWS_LOGON_DEL_SYNTAX
	Sintaxe: LOGONNEWS DEL {nm | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Logon news no encontrado #%d!
NEWS_LOGON_DELETED
	Logon news removido #%d.
NEWS_LOGON_DEL_NONE
	Nenhum logon news para remover!
NEWS_LOGON_DELETED_ALL
	Todos os logon news foram removidos.

NEWS_OPER_SYNTAX
	Sintaxe: OPERNEWS {ADD|DEL|LIST} [texto|nm]
NEWS_OPER_LIST_HEADER
	Oper news items:
NEWS_OPER_LIST_ENTRY
	%5d (%s por %s)
	    %s
NEWS_OPER_LIST_NONE
	No existe nenhum oper news.
NEWS_OPER_ADD_SYNTAX
	Sintaxe: OPERNEWS ADD texto
NEWS_OPER_ADD_FULL
	Lista de oper news est cheia!
NEWS_OPER_ADDED
	Adicionado novo oper news (#%d).
NEWS_OPER_DEL_SYNTAX
	Sintaxe: OPERNEWS DEL {nm | ALL}
NEWS_OPER_DEL_NOT_FOUND
	Oper news no encontrado #%d!
NEWS_OPER_DELETED
	Oper news removido #%d.
NEWS_OPER_DEL_NONE
	Nenhum oper news para remover!
NEWS_OPER_DELETED_ALL
	Todos os oper news foram removidos.

NEWS_RANDOM_SYNTAX
	Syntax: RANDOMNEWS {ADD|DEL|LIST} [text|num]
NEWS_RANDOM_LIST_HEADER
	Random news items:
NEWS_RANDOM_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_RANDOM_LIST_NONE
	There is no random news.
NEWS_RANDOM_ADD_SYNTAX
	Syntax: RANDOMNEWS ADD text
NEWS_RANDOM_ADD_FULL
	News list is full!
NEWS_RANDOM_ADDED
	Added new random news item (#%d).
NEWS_RANDOM_DEL_SYNTAX
	Syntax: RANDOMNEWS DEL {num | ALL}
NEWS_RANDOM_DEL_NOT_FOUND
	Random news item #%d not found!
NEWS_RANDOM_DELETED
	Random news item #%d deleted.
NEWS_RANDOM_DEL_NONE
	No random news items to delete!
NEWS_RANDOM_DELETED_ALL
	All random news items deleted.

NEWS_HELP_LOGON
	Sintaxe: LOGONNEWS ADD texto
	         LOGONNEWS DEL {nm | ALL}
	         LOGONNEWS LIST
	
	Edita ou mostra a lista de logon news. Quando um usurio
	se conecta  rede, estas mensagens so enviadas para ele.
	(No entanto, no mais que trs mensagens sero enviadas
	simultaneamente para evitar flood. Se houver mais que trs
	mensagens novas, apenas essas mais novas sero mostradas.)
	
	LOGONNEWS LIST pode ser usado por qualquer Operador
	para listar as mensagens atuais. ADD e DEL s podem
	ser usados pelos Administradores dos Services.

NEWS_HELP_OPER
	Sintaxe: OPERNEWS ADD texto
	         OPERNEWS DEL {nm | ALL}
	         OPERNEWS LIST
	
	Edita ou mostra a lista de oper news. Quando um usurio
	se torna operador (pelo comando /OPER), estas mensagens
	lhe sero enviadas. (No entanto, no mais que trs
	mensagens sero enviadas simultaneamente para evitar
	flood. Se houver mais que trs mensagens novas, apenas
	as trs mais novas sero mostradas).
	
	OPERNEWS LIST pode ser usado por qualquer Operador
	para listar as oper news. ADD e DEL s podem ser usados
	Administradores dos Services.

###########################################################################
#
# HelpServ help message
#
###########################################################################

NEWS_HELP_RANDOM
	Syntax: RANDOMNEWS ADD text
	        RANDOMNEWS DEL {num | ALL}
	        RANDOMNEWS LIST
	
	Edits or displays the list of random news messages.  When a
	user connects to the network, one (and only one) of the
	random news will be randomly chosen and sent to them.
	
	RANDOMNEWS LIST may be used by any IRC operator to list the
	current news messages.  ADD and DEL may only be used by
	Services admins.

###########################################################################
#
# HelpServ help message
#
###########################################################################

HELP_HELP
	%S  um services criado para dar informaes sobre
	os Services.  Os tpicos de ajuda so enviados pelo 
	comando HELP dos outros clientes dos Services:

	/msg %s HELP
	     para informaes sobre como registrar nicks

	/msg %s HELP
	     para informaes sobre como registrar e controlar
	     canais

	/msg %s HELP
	     para informaes sobre como enviar mensagens para
	     usurios que no estejam conectados no momento.

HELP_HELP_BOT

	/msg %s HELP
	     para informaes sobre como colocar um bot em seu canal

HELP_HELP_HOST

	/msg %s HELP
	     for information on setting up nick vHosts

###########################################################################
#
# NickServ help messages
#
###########################################################################

NICK_HELP
	%S permite que voc "registre" um nick e evita que outras
	pessoas o utilizem. Os seguintes comandos permitem o
	registro e a manuteno dos nicks; para utiliz-los, digite
	/msg %S comando. Para maiores informaes sobre um
	comando digite /msg %S HELP comando.
	
	    REGISTER   Registra um nick
	    GROUP      Se junta a um grupo
	    IDENTIFY   Identifica seu nick com sua senha
	    ACCESS     Modifica a lista de endereos autorizados
	    SET        Ajusta opes, incluindo proteo de kill
	    DROP       Cancela o registro de um nick
	    RECOVER    Derruba usurio que esteja usando seu nick
	    RELEASE    Retoma a custdia do seu nick aps um RECOVER
	    SENDPASS   Esqueceu sua senha? Tente isto
	
	Outros comandos: GHOST, GLIST, INFO, LIST, LOGOUT, STATUS
	
	NOTICE: Este servio tem a inteno de prover um modo para
	que usurios do IRC no tenham sua identidade comprometida.
	Isto NO  voltado para facilitar "roubo" dos nicks ou
	outras atitudes m intencionadas. O abuso do %S
	resultar em, no mnimo, perda do(s) nick(s) abusivo(s). 
	
NICK_HELP_EXPIRES
	
	Nicks que no estejam mais sendo usados esto sujeitos 
	a expirarem automaticamente, ex. eles sero apagados
	aps %d dias sem serem usados.

NICK_HELP_REGISTER
	Sintaxe: REGISTER senha [email]
	
	Registra seu nick no banco de dados do %S. Uma vez
	que seu nick est registrado, voc pode usar os comandos
	SET e ACCESS para configurar as opes do seu nick como
	voc preferir depois. Certifique-se de lembrar sua senha
	durante o registro, voc precisar dela para fazer alteraes
	no seu nick futuramente.
	(Lembre-se que maisculas diferem, como:  ANOPE, Anope e 
	anope so senhas diferentes!)
	
	Sugestes ao escolher sua senha:
	
	As senhas no devem ser de fcil adivinhao. Por exemplo,
	usar seu nome como senha  uma pssima idia. Utilizar seu
	nick como senha  uma idia muito pior e, de fato, o %S
	no permitir isso. Da mesma maneira, senhas curtas so
	vulnerveis a testes de erro-e-acerto, ento voc deve
	escolher uma senha com pelo menos 5 caracteres. Finalmente,
	o caractere "ESPAO" no pode ser usado em senhas.
	
	O parmetro email  opcional e servir para setar um
	email para seu nick. Entretanto, o email pode ser obrigatrio
	em algumas Redes de IRC.
	Sua privacidade  respeitada; teste e-mail nunca ser dado
	para terceiros.
	
	Este comando servir tambm para criar um GRUPO para o seu
	nick, e ir permitir que voc registre outros nicks e divida
	as mesmas configuraes, os mesmos memos e os mesmos 
	privilgios em canais.  conhecido em outras redes como LINK.
	Para maiores informaes, digite /msg %S HELP GROUP.
	
NICK_HELP_GROUP
	Syntax: GROUP alvo senha
	
	Liga seu nick a outro, efetivamente, fazendo uma ligao 
	do seu nick atual com um outro nick especificado. Quando
	voc emite este comando, a lista de acesso do seu nick
	atualmente em uso  apagada e substituida pelo nick que
	voc est ligando, todos os memos do seu nick atual so
	adicionados na lista de memos do nick alvo (isso pode
	causar um excesso no limite de memos do nick, em alguns
	casos voc precisa apagar alguns memos antes de poder
	receber mais memos de uma outra pessoa).
	
	Uma vez que a ligao foi estabilizada, seu nick ser
	transparentemente convertido para o nick alvo em todos
	os lugares nos Services, exceto para os comandos NickServ
	UNLINK e DROP.
	 
	Por exemplo, voc pode usar um nick ou outro para ler
	o mesmo conjunto de memos (e mensagens enviadas para
	um nick ou outro iro para a mesma lista). Se voce se
	identificar para um nick, estar automaticamente
	identificado para o outro. Se um nick ou outro est
	na lista de acesso de um canal, ambos nicks tero os
	mesmos privilgios de acesso.
	
	Para usar este comando, voc deve identificar o nick
	atual usando /msg %S IDENTIFY senha, e voc
	deve forneceer a senha para o nick que voc deseja 
	ligar.
	
	Ateno: todos os nicks do grupo tero a mesma senha.

NICK_HELP_IDENTIFY
	Syntax: IDENTIFY senha
	
	Identifica voc ao %S como sendo dono do nick.
	Muitos comandos exigem que voc se identifique com este
	comando antes de voc us-los. A senha deve ser a mesma que
	voc enviou com o comando REGISTER.
	
NICK_HELP_UPDATE
	Syntax: UPDATE

	Updates your current status, i.e. it checks for new memos,
	sets needed chanmodes (ModeonID) and updates your vhost and
	your userflags (lastseentime, etc).
	
NICK_HELP_LOGOUT
	Sintaxe: LOGOUT
	
	Este comando reverte o efeito do comando IDENTIFY, ex.
	faz com que voc no seja mais reconhecido como o verdadeiro
	dono do nick. Note, entretanto, que ele no pedira que
	voc se identifique novamente.

NICK_HELP_DROP
	Syntax: DROP [nick]
	
	Sem parmetros, cancela o registro de seu nick no banco de
	dados do %S.
	
	Com parmetros, cancela o registro de um nick especificado
	do banco de dados (restrito aos Administradores dos
	Services).
	
	Para voc usar este comando, ser necessrio que primeiro
	voc se identifique usando sua senha (/msg %S HELP DROP 
	para maiores informaes).

NICK_HELP_ACCESS
	Sintaxe: ACCESS ADD mscara
	         ACCESS DEL mscara
	         ACCESS LIST
	
	Modifica ou mostra a lista de acesso do seu nick. Esta 
	a lista de endereos a qual ser automaticamente reconhecida
	pelo %S como as permitidas a usarem seu nick. Se voc
	quer usar um nick de um endereo diferente, voc deve usar o
	comando IDENTIFY para identificar-se ao %S
	
	Exemplos:
	
	    ACCESS ADD nick@*.provedor.com.br
	        Permite o acesso do usurio nick de qualquer
	        mquina com o domnio provedor.com.br.
	
	    ACCESS DEL nick@*.provedor.com.br
	        Reverte o comando anterior
	
	    ACCESS LIST
	        Mostra a lista de acesso atual.

NICK_HELP_SET
	Sintaxe: SET opo parmetros
	
	Ajusta vrias opes de nick.  A opo pode ser:
	
	    DISPLAY    Mostra o seu grupo nos Services
	    PASSWORD   Ajusta a senha do seu nick
	    LANGUAGE   Ajusta a linguagem dos Services quando
	                   mensagens so enviadas  voc
	    URL        Associa um endereo URL com seu nick
	    EMAIL      Associa um endereo de e-mail ao seu nick
	    ICQ        Associa um nmero de ICQ ao seu nick
	    GREET      Associa uma mensgem de entrada ao seu nick
	    KILL       Ativa/Desativa a proteo de kill para o seu
	               nick
	    SECURE     Ativa/Desativa o dispositivo de segurana para
	               o seu nick
	    PRIVATE    Previne seu nick de aparecer em um /msg %S LIST
	    HIDE       Esconde certas informaes sobre seu nick
	    MSG        Altera o mtodo de comunicao dos Services
	
	Para usar este comando, voc deve primeiro se identificar
	com sua senha (/msg %S HELP IDENTIFY para maiores
	informaes).
	
	Digite /msg %S HELP SET oo para maiores informaes
	sobre um comando especfico.

NICK_HELP_SET_DISPLAY
	Sintaxe SET DISPLAY novo-display
	
	Altera o display usado como referncia ao nome do seu grupo 
	nos Services. O novo display DEVE ser um nick do seu grupo.

NICK_HELP_SET_PASSWORD
	Sintaxe: SET PASSWORD nova-senha
	
	Muda a senha de seu nick.

NICK_HELP_SET_LANGUAGE
	Sintaxe: SET LANGUAGE nmero
	
	Muda a linguagem que os Services usam ao enviar mensagens
	para voc (por exemplo, quando responde um comando que voc
	emite). Lembre-se que apenas a linguagem em Portugus est
	totalmente atualizada, outras linguagens podem enviar
	mensagens com informaes incorretas.
	O nmero deve ser escolhido da seguinte lista de lnguas:
	

NICK_HELP_SET_URL
	Sintaxe: SET URL url
	
	Associa uma dada URL ao seu nick. Esta URL ser mostrada
	sempre que alguem solicitar informao sobre seu nick
	atravs do comando INFO.

NICK_HELP_SET_EMAIL
	Sintaxe: SET EMAIL endereo
	
	Associa um endereo de email designado ao seu nick. Este
	endereo ser sempre mostrado quando algum solicitar
	informao sobre seu nick atraves do comando INFO.
	O email especificado tambm  usado para enviar sua senha
	caso seja perdida. Caso no tenha nenhum endereo para seu
	nick ou o mesmo seje invlido, no ser possvel recuperar
	a senha perdida.
	
NICK_HELP_SET_ICQ
	Sintaxe: SET ICQ nmero
	
	Associa um nmero de ICQ ao seu nick. Este nmero
	ser sempre mostrado quando algum solicitar 
	informao sobre seu nick atravs do comando INFO.
	
NICK_HELP_SET_GREET
	Sintaxe: SET GREET mensagem
	
	Faz com que a mensagen escolhida se torne a sua mensagem
	de entrada que aparecer sempre quando voc entrar em um canal
	que tenha a opo GREET habilitada, e tambm tenha acesso a isto.

NICK_HELP_SET_KILL
	Sintaxe: SET KILL {ON | QUICK | IMMED | OFF}
	
	Possibilita a proteo de KILL do seu nick. Com a proteo
	de KILL acionada, se outro usurio tentar tomar seu nick,
	ser dado 1 minuto para este mudar de nick, aps isso, ser
	trocado de nick ou removido do irc pelo %S.
	
	Se voc selecionar QUICK, ser dado ao usurio somente 20
	segundos para mudar de nick ao invs do usual (60 segundos).
	Se voc selecionar a opo IMMED, o nick ser mudado
	imediatamente sem mesmo ser avisado antes;  recomendado
	no usar essa opo, a no ser que seja necessrio. Pode
	acontecer do Administrador da Rede desabilitar essa opo.

NICK_HELP_SET_SECURE
	Sintaxe: SET SECURE {ON | OFF}
	
	Torna os recursos de segurana do %S ativados (ON) ou
	desativados (OFF) sobre o seu nick. Com o SECURE acionado
	voc deve entrar com sua senha antes de ser reconhecido como
	usurio do nick, independentemente do fato do seu endereo
	constar na lista de acesso.  Entretanto, se voc est na
	lista de acesso, o %S no ir dar auto-kill em voc de
	acordo com os ajustes da opo KILL.

NICK_HELP_SET_PRIVATE
	Sintaxe: SET PRIVATE {ON | OFF}
	
	Torna a opo de privacidade do %S sobre o seu nick
	em ativada (ON) ou desativada (OFF). Com o PRIVATE ativado,
	seu nick no aparecer nas listagens de nicks geradas com
	o comando %S's LIST. (Entretando, algum que sabe do seu
	nick ainda pode obter informaes usando o comando INFO).

NICK_HELP_SET_HIDE
	Sintaxe: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	Permite que voc previna que certas informaes sejam
	mostradas quando algum usa %S INFO no seu nick. Voc pode
	esconder seu endereo de e-mail (EMAIL), ltima mscara vista
	user@host (USERMASK), e sua ltima mensagem de saida (QUIT).
	O segundo parmetro especifica quando a informao deve ser
	mostrada (OFF) ou escondida (ON).
	
NICK_HELP_SET_MSG
	Sintaxe: SET MSG {ON | OFF}
	
	Permite que voc escolha a forma que os Services devem se 
	comunicar com voc. Com MSG acionado, os Services iro usar
	mensagems, caso contrrio, usaro notices. 

NICK_HELP_RECOVER
	Syntax: RECOVER nickname [password]
	
	Permite que voc recupere seu nick se algum o tiver
	tomado; isso faz o mesmo que o %S faz automaticamente
	se algum "rouba" um nick protegido com kill.
	
	Quando voc usa este comando, o %S trar um falso
	usurio online com o mesmo nick de quem o est usando.
	Isto causar uma desconexo pelo servidor de IRC do outro
	usurio. O falso usurio ficara online por 1 minuto para
	assegurar que o outro usurio no reconecte imediatamente;
	Durante este minuto, voc pode reivindicar seu nick.
	Alternativamente, use o comando RELEASE
	(/msg %S HELP RELEASE) para retomar seu nick mais 
	rapidamente.
	
	Para usar o comando RECOVER com um nick, seu endereo atual
	como mostrado com /WHOIS deve estar na lista de acesso do
	nick, ou voc deve fornecer a senha correta para o nick.

NICK_HELP_RELEASE
	Sintaxe: RELEASE nick [senha]
	
	Instrui o %S a remover qualquer espera no seu nick
	causada pelo kill automtico de proteo ou pelo uso do
	comando RECOVER. Por padro, essa espera dura 1 minuto;
	este comando libera o seu nick mais cedo.
	 
	Para usar o comando RELEASE para um nick, seu endereo
	atual	como mostrado com /WHOIS deve estar na lista de acesso 
	do nick, ou voc deve fornecer a senha correta para o nick.

NICK_HELP_GHOST
	Sintaxe: GHOST nick [senha]
	 
	Elimina uma sesso "fantasma" de IRC que esteja usando seu
	nick. A sesso "fantasma"  aquela que no est realmente
	conectada, mas que o servidor de IRC acredita estar ainda
	ativa por qualquer razo. Isso acontece normalmente se seu
	computador travar ou se sua conexo com a internet ou modem
	cair por um perodo curto de tempo enquanto voc esta no IRC.
	 
	Para usar o comando GHOST em um nick, seu endereo atual
	como mostrado no /WHOIS deve pertencer a lista de acesso do
	nick, ou voc deve fornecer a senha correta para o nick.

NICK_HELP_INFO
	Sintaxe: INFO nick [ALL]
	 
	Mostra a informao sobre o nick dado, como o dono do nick,
	ltimo endereo utilizado, tempo e opes. Se voc est
	identificado para o nick que voc esta obtendo informaes
	e a opo ALL  especificada, ser mostrado  voc toda
	informao possvel; havendo opes para esconder
	informaes ou no.

NICK_HELP_LIST
	Sintaxe: LIST padro
	
	Lista todos os nicks registrados que combinam com o padro
	fornecido no formato nick!ident@host. Nicks com a opo
	PRIVATE ligada no sero mostrados.

NICK_HELP_ALIST
	Syntax: ALIST [level]
	
	Lists all channels you have access on. Optionally, you can specify
	a level in XOP or ACCESS format. The resulting list will only 
	include channels where you have the given level of access.

	Examples:
	ALIST Founder
	     Lists all channels where you have Founder
	     access.

	ALIST AOP
	     Lists all channels where you have AOP access 
	     or greater.

	ALIST 10
	    Lists all channels where you have level 10 
	    access or greater.
	
	Channels that have the NOEXPIRE option set will be prefixed by 
	an exclamation mark.
	
NICK_HELP_GLIST
	Sintaxe: GLIST
	
	Lista todos os nicks do grupo.

NICK_HELP_STATUS
	Sintaxe: STATUS nick
	 
	Retorna se o usurio que est usando um determinado nick
	 reconhecio como dono do nick. 
	A resposta tem este formato:
	 
	    nickname cdigo-de-status
	 
	onde nick  o nick enviado com o comando, e
	cdigo-de-status um dos seguintes:
	
	    0 - usurio no est conectado ou o nick no est registrado
	    1 - usurio no reconhecido como dono do nick
	    2 - usurio reconhecido como dono s pela lista de acesso
	    3 - usurio reconhecido como dono via identificao por senha
	
	At 16 nicks podem ser enviados com cada comando; o resto ser
	ignorado. No  gerado mensagem de erro se nenhum nick for fornecido.
	
NICK_HELP_SENDPASS
	Sintaxe: SENDPASS nick
	
	Envia a senha do nick em questo para o endereo de email
	que ele tiver setado para seu nick. Esse comando  bem til em
	se falando de senhas perdidas.
	
	Poder ser limitado a IRC operators em algumas redes.
	
	Este comando no est disponvel quando estiver usando encriptao.

NICK_SERVADMIN_HELP
	
	Os comandos abaixo esto disponveis para Admins dos Services:
	
	    GETPASS    Recupera a senha de um nick determinado
	                 (apenas se no estiver com encriptao)
	    FORBID     Previne um nick de ser usado ou registrado
	
	Os Administradores podem ainda usar o DROP em qualquer nick
	sem ser necessrio se identificar como dono dele (/msg %S 
	ACCESS LIST nick).

NICK_SERVADMIN_HELP_LOGOUT
	Sintaxe: LOGOUT [nick [REVALIDATE]]
	
	Sem nenhum parmetro ele ir apenas reverter o efeito do comando IDENTIFY 
	
	Com um parmetro, far o mesmo para o nick determinado. Se voc usar 
	o comando REVALIDATE os Services iro pedir que o nick em questo
	se identifique novamente. 
	
	Comando limitado aos Administradores dos Services.

NICK_SERVADMIN_HELP_DROP
	Sintaxe: DROP [nick]
	
	Sem parmetros, cancela o registro de seu nick no banco de
	dados do %S.
	
	Com parmetros, cancela o registro de um nick especificado
	do banco de dados.
	Este comando  restrito aos Administradores dos Services.

NICK_SERVADMIN_HELP_SET
	
	Administradores dos Services podem ajustar a opo NOEXPIRE,
	com a qual os nicks podem ser protegidos de expirar. E ainda,
	Administradores dos Services podem ajustar opes para qualquer
	nick sem se identificar com a senha, usando:
	SET nick opo parametros.

NICK_SERVADMIN_HELP_SET_NOEXPIRE
	Sintaxe: SET nick NOEXPIRE {ON | OFF}
	
	Determina se um nick fornecido poder ser expirado.
	Ajustando este para ON, evita que o nick seja expirado.
	
	Limitado aos Administradores dos Services.

NICK_SERVADMIN_HELP_INFO
	
	Administradores de Services podem usar o comando ALL com qualquer nick.

NICK_SERVADMIN_HELP_LIST
	Sintaxe: LIST padro [FORBIDDEN] [NOEXPIRE]
	
	Lista todos os nicks registrados que combinem com o padro
	fornecido (formato nick!ident@host). Nicks com opo PRIVATE
	sero somente exibidos para os Administradores dos Services.
	Nicks com opo NOEXPIRE ajustada tero um ! preposto ao nick
	na lista quando for a pedido de Administrador dos Services.
	Se as opes FORBIDDEN ou NOEXPIRE forem fornecidas, somente os
	nicks proibidos (forbidden) ou os que tem a flag NOEXPIRE sero
	exibidos, respectivamente. Se ambas as opes so fornecidas,
	ambos os tipos de nicks sero exibidos.
	
	Essas opes so limitadas aos Administradores dos Services.
	
	Exemplos:
	
	     LIST *!ident@servidor.com.br
	        Lista todos os nicks de *!ident@servidor.com.br.
	
	     LIST *Bot*!*@*
	        Lista todos os nicks registrados com Bot em seus nomes.
	
	     LIST * NOEXPIRE
	        Lista todos os nicks registrados cujos registros foram
	        ajustados para no expirar.

NICK_SERVADMIN_HELP_ALIST
	Syntax: ALIST [nickname] [level]
	
	With no parameters, lists channels you have access on. With
	one parameter, lists channels that nickname has access 
	on. With two parameters lists channels that nickname has 
	level access or greater on.

	This use limited to Services admins.

NICK_SERVADMIN_HELP_GLIST
	Sintaxe: GLIST [nick]
	
	Sem nenhum parmetro lista todos os nicks no seu grupo.
	
	Com um parmetro, lista todos os nicks no grupo determinado.
	
	Este comando  limitado aos Administradores dos Services.

NICK_SERVADMIN_HELP_GETPASS
	Sintaxe: GETPASS nick
	
	Mostra a senha de um nick especificado.
	Note que sempre que este comando for usado, uma mensagem
	incluindo o nick da pessoa que emitiu o comando o nick
	requisitado ser gravado e enviado para WALLOPS/GLOBOPS.
	
	Limitado aos Administradores dos Services.
	
	Este comando no  disponvel quando a encriptao est habilitada.

NICK_SERVADMIN_HELP_GETEMAIL
	Syntax: GETEMAIL user@emailhost

	Returns the matching nicks that used given email. Note that
	you can not use wildcards for either user or emailhost. Whenever
	this command is used, a message including the person who issued
	the command and the email it was used on will be logged.

	Limited to Services admins.

NICK_SERVADMIN_HELP_FORBID
	Sintaxe: FORBID nick
	
	No permite que um nick seja registrado ou usado por
	ningum. Pode ser cancelado desregistrando o nick.
	
	Limitado aos Administradores dos Services.

###########################################################################
#
# ChanServ help messages
#
###########################################################################

CHAN_HELP
	%S permite que voc registre e controle vrios
	aspectos do canal. %S pode prevenir o "take over"
	do canal de usurios maliciosos limitando quem possui
	o privilgio de OP do canal. Os comandos disponveis
	esto listados abaixo.
	Para us-los, digite /msg %S comando.
	Para mais informaes de um comando, digite
	/msg %S HELP comando.
	
	    REGISTER   Registra um canal
	    IDENTIFY   Identifica seu nick
	    SET        Ajusta as opes e informaes do canal
	    ACCESS     Modifica a lista de usurios privilegiados
	    LEVELS     Redefine os nveis de acesso
	    AKICK      Faz a manuteno da Lista de Autokick
	    DROP       Cancela o registro de um canal
	    SENDPASS   Ajuda para recuperar senhas
	
	Outros comandos: CLEAR, DEOP, DEVOICE, GETKEY, INFO, 
	                INVITE, KICK, LIST, LOGOUT, OP, UNBAN, 
	                VOICE
	
CHAN_HELP_UNREAL
	
	Estes comandos esto tambm disponveis nesta Rede:
	    HALFOP, DEHALFOP, PROTECT, DEPROTECT

CHAN_HELP_ULTIMATE
	
	Estes comandos esto tambm disponveis nesta Rede:
	    HALFOP, DEHALFOP, HOP

CHAN_HELP_ULTIMATE3
	
	Estes comandos esto tambm disponveis nesta Rede:
	    HALFOP, DEHALFOP, HOP, ADMIN, DEADMIN

CHAN_HELP_EXPIRES
	
	Note que qualquer canal no utilizado por %d dias
	(entenda como se nenhum usurio da lista de acesso
	desse canal entrar neste periodo de tempo) ter
	automaticamente cancelado o seu registro.

CHAN_HELP_REGISTER
	Sintaxe: REGISTER canal senha descrio
	
	Registra um canal no banco de dados do %S. 
	Para utilizar este comando, voc deve primeiro ser OP
	do canal que est tentando registrar. O canal  registrado
	para o seu nick, e voc ter acesso de fundador do canal
	quando tiver identificado quando tiver identificado a senha 
	do canal com o %S. Para ajuda sobre como mudar os privilgios 
	de usurios ao seu canal, escreva /msg %S HELP ACCESS.
	
	IMPORTANTE: Para registrar um canal, voc deve antes ter
	registrado seu nick. Se ainda no tiver seu nick registrado,
	digite /msg %s HELP para mais informaes de como faz-lo.

CHAN_HELP_IDENTIFY
	Sintaxe: IDENTIFY canal senha
	
	Identifica voc no %S como fundador do canal fornecido.
	Muitos comandos exigem que voc use este comando antes
	de us-los. A senha dever ser a mesma usada por voc
	no comando REGISTER.
	
CHAN_HELP_LOGOUT
	Sintaxe: LOGOUT canal nick
	
	Este comando faz que o nick determinado no esteja mais
	reconhecido no canal especificado.
	
	Se voc for o dono do canal voc pode usar este comando
	em qualquer um, caso contrrio, apenas em si mesmo.

CHAN_HELP_DROP
	Sintaxe: DROP #canal
	
	Cancela o registro do canal. So poder ser usado pelo
	fundador do canal, que primeiramente dever estar
	identificado com o nickserv.

CHAN_HELP_SET
	Sintaxe: SET canal opo parmetros
	
	Permite ao fundador do canal ajustar as vrias opes do
	canal e outras informaes. O fundador deve se identificar
	com o nickserv antes de usar o SET.
	
	Comandos disponiveis:
	
	    FOUNDER       Ajusta o fundador do canal
	    SUCCESSOR     Ajusta o sucessor do canal
	    PASSWORD      Ajusta a senha do founder
	    DESC          Ajusta a descrio do canal
	    URL           Associa uma URL a um canal
	    EMAIL         Associa um e-mail a um canal
	    ENTRYMSG      Ajusta a mensagem que deve ser mandada
	                  aos usurios quando eles entram no canal
	    TOPIC         Altera o tpico do canal
	    BANTYPE       Ajusta com os services devem fazer o ban
	    KEEPTOPIC     Mantem o tpico quando o canal
	                  no est em uso
	    TOPICLOCK     O tpico pode ser mudado apenas
	                  com o TOPIC
	    MLOCK         Liga ou desliga a trava dos modos do canal
	    PRIVATE       Esconde o canal do comando LIST
	    RESTRICTED    Acesso restrito ao canal
	    SECURE        Ativa os recursos de segurana do %S
	    SECUREOPS     Rigoroso o controle de status de OP
	    SECUREFOUNDER Controle restrito do fundador do canal
	    SIGNKICK      Assinatura dos kicks usados pelo comando kick
	    OPNOTICE    Envia uma notice quando os comandos OP/DEOP
	                so usados
	
	Digite /msg %S HELP SET opes para maiores informaes
	sobre uma opo em particular.

CHAN_HELP_SET_FOUNDER
	Sintaxe: SET canal FOUNDER nick
	
	Muda o fundador do canal. O novo nick deve estar
	registrado.

CHAN_HELP_SET_SUCCESSOR
	Sintaxe: SET canal SUCCESSOR nick
	
	Muda o sucessor de um canal. Se o nick do founder expirar
	ou estiver dropado enquanto o canal ainda estiver registrado,
	o sucessor se tornar o novo founder do canal.
	No entanto, se o sucessor possuir muitos canais registrados
	(%d), o canal ser dropado, como se nenhum sucessor tivesse
	sido ajustado. O novo nick dever estar registrado.

CHAN_HELP_SET_PASSWORD
	Sintaxe: SET canal PASSWORD senha
	
	Ajusta a senha utilizada para identificao do
	fundador do canal.

CHAN_HELP_SET_DESC
	Sintaxe: SET canal DESC descrio
	
	Ajusta a descrio para o canal, que so mostradas com
	os comandos LIST e INFO.

CHAN_HELP_SET_URL
	Sintaxe: SET canal URL [url]
	
	Associa uma URL ao canal. Esta URL ser mostrada
	sempre que alguem solicitar informao sobre o canal
	com o comando INFO. Se nenhum parmetro for fornecido,
	apaga qualquer URL atualmente designada para o canal.

CHAN_HELP_SET_EMAIL
	Sintaxe: SET canal EMAIL [endereco]
	
	Associa um endereo de e-mail fornecido ao canal.
	Este endereo ser mostrado sempre que alguem solicitar
	informao sobre o canal com o comando INFO. Se nenhum
	parmetro for fornecido, apaga qualquer endereo de e-mail
	do canal.

CHAN_HELP_SET_ENTRYMSG
	Sintaxe: SET canal ENTRYMSG [mensagem]
	
	Ajusta a mensagem na qual ser enviada via /notice para
	os usurios quando eles entrarem no canal. Se nenhum
	parmetro  fornecido, nenhuma mensagem ser enviada
	ao se entrar no canal.
	
CHAN_HELP_SET_BANTYPE
	Sintaxe: SET canal BANTYPE tipo-do-ban
	
	Seleciona o tipo do ban sempre que os Services precisarem
	banir algum do seu canal.
	
	O tipo do ban  um nmero entre 0 e 3 que significa:
	
	0: ban na forma *!user@host
	1: ban na forma *!*user@host
	2: ban na forma *!*@host
	3: ban na forma *!*user@*.domain

CHAN_HELP_SET_KEEPTOPIC
	Sintaxe: SET canal KEEPTOPIC {ON|OFF}
	
	Ativa ou desativa a opo de reteno de tpico para 	
	um canal. Quando a reteno de tpico est acionada,
	o tpico para o canal ser relembrado pelo %S
	mesmo depois que os usurios deixarem o canal, e ser
	restaurado na prxima vez que o canal for re-aberto.

CHAN_HELP_SET_TOPICLOCK
	Sintaxe: SET canal TOPICLOCK {ON|OFF}
	
	Ativa ou desativa a opo de trava do tpico de um canal.
	Quando a Trava do tpico est ativada, o %S no
	permitir a mudana do tpico do canal exceto pelo comando 
	TOPIC.

CHAN_HELP_SET_MLOCK
	Sintaxe: SET canal MLOCK modos
	
	Ajusta o parmetro da trava do modo para um canal. O
	%S permite que voc defina certos modos no canal
	a serem sempre ativos (ou desativos). Os modos podem 
	ser i, k, l, m, n, p, s e t; cada um desses travado
	como ativo, desativo ou no travado. O parmetro
	modos e usado exatamente do mesmo modo como o comando
	/MODE;  isto , modos seguidos de + so travados como
	ativos, e modos seguidos de - so travados como desativos.
	
	Cuidado: Se voc trava uma senha, como no segundo exemplo
	abaixo, voc deveria tambm ajustar a opo RESTRICTED para
	o canal (veja HELP SET RESTRICTED), ou qualquer usurio
	que entra no canal que est vazio ser capaz de ver a senha!
	
	Exemplos:
	
	    SET #canal MLOCK +nt-iklps
	        Trava os modos n e t ativados, e os modos i, k, l, p,
	        e s desligados. Modo m  livremente deixado para se
	        ligado(on)ou desligado(off).
	
	    SET #canal MLOCK +knst-ilmp minha-senha
	        Trava os modos k, n, s, t como ligados e os modos i,
	        l, m, p como desligados. Tambm trava a senha do canal
	        como "minha-senha".
	
	    SET #canal MLOCK +
	        Elimina a trava do modos; todos os modos do canal
	        ficam livres para ser ativados ou desativados.

CHAN_HELP_SET_PEACE
	Syntax: SET channel PEACE {ON | OFF}
	
	Enables or disables the peace option for a channel.
	When peace is set, an user won't be able to kick,
	ban or remove a channel status of an user that has
	a level superior or equal to his via %S commands.

CHAN_HELP_SET_PRIVATE
	Sintaxe: SET canal PRIVATE {ON|OFF}
	
	Ativa ou desativa a opo private para um canal. Quando
	private est ativada, um /msg %S LIST no ir incluir
	o canal em qualquer listagem.

CHAN_HELP_SET_RESTRICTED
	Sintaxe: SET canal RESTRICTED {ON|OFF}
	
	Ativa ou desativa a opo de acesso restrito para um canal.
	Quando o acesso restrito estiver ativado, usurios que
	normalmente no possuem privilegios de OP no canal
	(usurios com nvel negativo de acesso e, se secure ops
	estiver ativado, usurios que no pertence a lista de
	acesso) sero imediatamente kickados e banidos do canal.

CHAN_HELP_SET_SECURE
	Sintaxe: SET canal SECURE {ON|OFF}
	
	Ativa ou desativa os recursos de segurana do %S
	para um canal. Quando o SECURE estiver ativo, somente
	usurios que possuirem seus nicks registrados no %s
	e identificados com sua senha podero entrar no canal
	controlado pela lista de acesso.

CHAN_HELP_SET_SECUREOPS
	Sintaxe: SET canal SECUREOPS {ON|OFF}
	
	Ativa ou desativa a opo de segurana de ops para um canal.
	Quando secure-ops estiver ativada, os usurios que nao
	estiverem na lista de acesso no podero ter o status de OP.
	
CHAN_HELP_SET_SECUREFOUNDER
	Syntax: SET canal SECUREFOUNDER {ON | OFF}
	
	Habilita ou desabilitada a opo secure founder para um canal.
	Quando o secure founder est ligado, apenas o verdadeiro founder
	poder dar DROP no canal, mudar sua senha, seu founder e seu
	successor, e no aqueles que estiverem com IDENTIFY no %S.
	
CHAN_HELP_SET_SIGNKICK
	Sintaxe: SET canal SIGNKICK {ON | LEVEL | OFF}
	
	Habilita ou desabilita a assinatura nos kicks para um
	canal.  Quando o SIGNKICK est habilitado, kicks atravs
	do comando %S KICK tero o nick que usou o comando no motivo
	do kick.
	
	Se voc usar LEVEL, aqueles que tiverem um level igual ou 
	superior ao level do SIGNKICK no tero o nick aparecendo no 
	motivo. Veja /msg %S HELP LEVELS para maiores informaes. 

CHAN_HELP_SET_XOP
	Syntax: SET channel XOP {ON | OFF}
	
	Enables or disables the xOP lists system for a channel.
	When XOP is set, you have to use the AOP/SOP/VOP
	commands in order to give channel privileges to
	users, else you have to use the ACCESS command.
	
	Technical Note: when you switch from access list to xOP 
	lists system, your level definitions and user levels will be
	changed, so you won't find the same values if you
	switch back to access system! 
	
	You should also check that your users are in the good xOP 
	list after the switch from access to xOP lists, because the 
	guess is not always perfect... in fact, it is not recommended 
	to use the xOP lists if you changed level definitions with 
	the LEVELS command.
	
	Switching from xOP lists system to access list system
	causes no problem though.

CHAN_HELP_SET_OPNOTICE
	Sintaxe: SET canal OPNOTICE {ON | OFF}
	
	Ativa e desativa a opo Op-Notice para um canal. Quando
	Op-Notice estiver ativado, o %S enviar uma notice para
	o canal sempre que os comandos OP ou DEOP forem usados em um
	usurio no canal.

CHAN_HELP_AOP
	Syntax: AOP channel ADD nick
	        AOP channel DEL {nick | entry-num | list}
	        AOP channel LIST [mask | list]
	        AOP channel CLEAR
	
	Maintains the AOP (AutoOP) list for a channel. The AOP 
	list gives users the right to be auto-opped on your channel,
	to unban or invite themselves if needed, to have their
	greet message showed on join, and so on.
	
	The AOP ADD command adds the given nickname to the
	AOP list.
	
	The AOP DEL command removes the given nick from the
	AOP list.  If a list of entry numbers is given, those
	entries are deleted.  (See the example for LIST below.)
	
	The AOP LIST command displays the AOP list.  If
	a wildcard mask is given, only those entries matching the
	mask are displayed.  If a list of entry numbers is given,
	only those entries are shown; for example:

	   AOP #channel LIST 2-5,7-9
	      Lists AOP entries numbered 2 through 5 and
	      7 through 9.
	      
	The AOP CLEAR command clears all entries of the
	AOP list.
	
	The AOP ADD and AOP DEL commands are limited to
	SOPs or above, while the AOP CLEAR command can only
	be used by the channel founder. However, any user on the
	AOP list may use the AOP LIST command.
	
	This command may have been disabled for your channel, and
	in that case you need to use the access list. See 
	/msg %S HELP ACCESS for information about the access list,
	and /msg %S HELP SET XOP to know how to toggle between 
	the access list and xOP list systems.

CHAN_HELP_HOP
	Syntax: HOP channel ADD nick
	        HOP channel DEL {nick | entry-num | list}
	        HOP channel LIST [mask | list]
	        HOP channel CLEAR
	
	Maintains the HOP (HalfOP) list for a channel. The HOP 
	list gives users the right to be auto-halfopped on your 
	channel.
	
	The HOP ADD command adds the given nickname to the
	HOP list.
	
	The HOP DEL command removes the given nick from the
	HOP list.  If a list of entry numbers is given, those
	entries are deleted.  (See the example for LIST below.)
	
	The HOP LIST command displays the HOP list.  If
	a wildcard mask is given, only those entries matching the
	mask are displayed.  If a list of entry numbers is given,
	only those entries are shown; for example:

	   HOP #channel LIST 2-5,7-9
	      Lists HOP entries numbered 2 through 5 and
	      7 through 9.
	      
	The HOP CLEAR command clears all entries of the
	HOP list.
	
	The HOP ADD, HOP DEL and HOP LIST commands are 
	limited to AOPs or above, while the HOP CLEAR command 
	can only be used by the channel founder.
	
	This command may have been disabled for your channel, and
	in that case you need to use the access list. See 
	/msg %S HELP ACCESS for information about the access list,
	and /msg %S HELP SET XOP to know how to toggle between 
	the access list and xOP list systems.

CHAN_HELP_SOP
	Syntax: SOP channel ADD nick
	        SOP channel DEL {nick | entry-num | list}
	        SOP channel LIST [mask | list]
	        SOP channel CLEAR
	
	Maintains the SOP (SuperOP) list for a channel. The SOP 
	list gives users all rights given by the AOP list, and adds
	those needed to use the AutoKick and the BadWords lists, 
	to send and read channel memos, and so on.
	
	The SOP ADD command adds the given nickname to the
	SOP list.
	
	The SOP DEL command removes the given nick from the
	SOP list.  If a list of entry numbers is given, those
	entries are deleted.  (See the example for LIST below.)
	
	The SOP LIST command displays the SOP list.  If
	a wildcard mask is given, only those entries matching the
	mask are displayed.  If a list of entry numbers is given,
	only those entries are shown; for example:

	   SOP #channel LIST 2-5,7-9
	      Lists AOP entries numbered 2 through 5 and
	      7 through 9.
	      
	The SOP CLEAR command clears all entries of the
	SOP list.
	
	The SOP ADD, SOP DEL and SOP CLEAR commands are 
	limited to the channel founder. However, any user on the
	AOP list may use the SOP LIST command.
	
	This command may have been disabled for your channel, and
	in that case you need to use the access list. See 
	/msg %S HELP ACCESS for information about the access list,
	and /msg %S HELP SET XOP to know how to toggle between 
	the access list and xOP list systems.

CHAN_HELP_VOP
	Syntax: VOP channel ADD nick
	        VOP channel DEL {nick | entry-num | list}
	        VOP channel LIST [mask | list]
	        VOP channel CLEAR
	
	Maintains the VOP (VOicePeople) list for a channel.  
	The VOP list allows users to be auto-voiced and to voice 
	themselves if they aren't.
	
	The VOP ADD command adds the given nickname to the
	VOP list.
	
	The VOP DEL command removes the given nick from the
	VOP list.  If a list of entry numbers is given, those
	entries are deleted.  (See the example for LIST below.)
	
	The VOP LIST command displays the VOP list.  If
	a wildcard mask is given, only those entries matching the
	mask are displayed.  If a list of entry numbers is given,
	only those entries are shown; for example:

	   VOP #channel LIST 2-5,7-9
	      Lists VOP entries numbered 2 through 5 and
	      7 through 9.
	      
	The VOP CLEAR command clears all entries of the
	VOP list.
	
	The VOP ADD, VOP DEL and VOP LIST commands are 
	limited to AOPs or above, while the VOP CLEAR command 
	can only be used by the channel founder.
	
	This command may have been disabled for your channel, and
	in that case you need to use the access list. See 
	/msg %S HELP ACCESS for information about the access list,
	and /msg %S HELP SET XOP to know how to toggle between 
	the access list and xOP list systems.

CHAN_HELP_ACCESS
	Sintaxe: ACCESS canal ADD nick nvel
	         ACCESS canal DEL {nick | entry-num | list}
	         ACCESS canal LIST [mscara | list]
	
	Faz manuteno da lista de acesso de um canal. A lista
	de acesso especifica que usurios tem permisso para
	0 status de OP ou tem acesso aos comandos do %S em
	um canal. Nveis diferentes de usurios permitem acesso
	a diferentes subnveis de privilgios; /msg %S HELP
	ACCESS LEVELS para mais informaes especficas. Por
	padro, qualquer nick no presente na lista de acesso
	possui nivel 0.
	
	O comando ACCESS ADD adiciona um nick ou mscara de um
	usurio na lista de acesso com o nvel especificado; se o
	nick ou mscara j estiver presente na lista, seu nvel de
	acesso ser alterado para o nvel especificado. O nivel
	especificado deve ser menor do que o usurio que emitiu o
	comando.
	
	O comando ACCESS DEL remove um nick especificado da lista
	de acesso. Se uma lista de nmeros  fornecida, essas
	entradas so apagadas. (Veja o exemplo para LIST abaixo.)
	
	O comando ACCESS LIST mostra a lista de acesso do canal.
	Se uma mscara for fornecida, somente aquelas entradas que
	combinarem com o padro especificado na mscara sero 
	mostradas. Se uma lista de nmeros  fornecida, somente
	essas entradas sero mostradas, por exemplo:
	
	ACCESS #canal LIST 2-5,7-9
	   Lista as entradas de acesso numeradas de 2 a 5 e 7 a 9.

CHAN_HELP_ACCESS_LEVELS
	Nveis de Acesso do Usurio
	
	Por padro, os seguintes nveis de acesso so definidos:
	
	   Founder	Acesso total as funes do %S; OP automtico
	                  quando entrar no canal. Note que de somente uma
	                  pessoa pode ter o status fundador (isto no pode
	                  ser dado usando o comando ACCESS).
	        10      Acesso ao comando AKICK; OP automtico.
	         5      OP automtico.
	         3      Voice automtico.
	         0      Sem privilgios especiais; pode se tornar OP
	                  atravs de outros ops (a menos que secure-ops
	                  esteja ativada).
	        <0      No pode ser OP.
	
	Esses nveis podem ser mudados, ou adicionar novos, usando o
	comando LEVELS; digite /msg %S HELP LEVELS para informaes.

CHAN_HELP_AKICK
	Sintaxe: AKICK canal ADD mscara [razo]
	         AKICK canal DEL mscara
	         AKICK canal LIST [mscara]	
	         AKICK canal ENFORCE
	   	
	Faz a manuteno da lista de Autokick de um canal.
	Se um usurio que estiver na lista de AutoKick tentar
	entrar no canal, o %S banir este usurio do 
	canal, e depois kickar o usurio.
	
	O comando AKICK ADD adiciona o usurio especificado ou
	mscara na lista de Autokick. Se uma razo  dada com
	o comando, esta razo ser usada quando o usurio for
	kickado; se no, a razo padro ser "Voc foi banido
	deste canal" via o %S.
	
	O comando AKICK DEL remove um nick ou mscara da lista
	de AutoKick. Isso, entretanto, no remove qualquer ban
	colocado pelo AutoKick; estes devem ser removidos
	manualmente.
	
	O comando AKICK LIST mostra a lista de AutoKick, ou
	opcionalmente, s os registros de AutoKick que se
	encaixam com o padro de uma mscara dada.
	
	O comando AKICK ENFORCE obriga o %S a verificar
	a lista de AKICKs para remover os usurios conectados que
	sejam compatveis com a mscara dada.

CHAN_HELP_LEVELS
	Sintaxe: LEVELS canal SET tipo nvel
	         LEVELS canal {DIS | DISABLE} tipo
	         LEVELS canal LIST
	         LEVELS canal RESET
	
	O comando LEVELS permite ajuste detalhado sobre o
	significado numrico dos nveis de acesso usados pelos
	canais. Com esse comando, voc pode definir o nvel de
	acesso requerido pela maioria das funes do %S.
	(Os comandos SET FOUNDER e SET PASSWORD, assim como
	este comando, so sempre restritos ao fundador do canal).
	
	LEVELS SET permite que o nvel de acesso para uma funo ou
	grupo de funes sejam alterados. LEVELS DISABLE (ou DIS
	para encurtar) desabilita automaticamente os dispositivos ou
	no permite o acesso a funes para qualquer outra pessoa que
	no seja o fundador do canal. LEVELS LIST mostra os nveis
	atuais para cada funo ou para um grupo de funes. LEVELS
	RESET recoloca os nveis de acordo com o padro de um canal
	recem-criado (veja HELP ACCESS LEVELS).
	
	Para lista de recursos e funes cujos nveis podem ser
	ajustados, veja HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	A seguinte caracterstica/funo so entendidas. Note que
	estes nveis para AUTODEOP e NOJOIN so os nveis mximos,
	enquanto que todos os outros so nveis mnimos.

CHAN_HELP_LEVELS_DESC_FORMAT
	    %-*s  %s

CHAN_HELP_INFO
	Sintaxe: INFO canal [ALL]
	
	Lista os dados referentes ao canal registrado dado,
	incluindo seu fundador, data do registro, ltima vez que
	foi usado, descrio, e trava dos modos (se existirem).
	Se voc est identificado como fundador do canal que est
	solicitando informaes e a opo ALL  especificada,
	informaes sobre a mensagem de entrada e sobre o sucessor
	do canal tambm ser mostrada.

CHAN_HELP_LIST
	Sintaxe: LIST padro
	
	Lista todos os canais registrados que combinam com o padro
	dado. (Canais com opo PRIVATE ativada no sero listados).

CHAN_HELP_OP
	Sintaxe: OP #canal nick
	
	Atribui status de Operador (modo +o) para o nick dado em
	um determinado canal. Limitado aos usurios de nvel 5, no
	mnimo, do canal especificado.

CHAN_HELP_DEOP
	Sintaxe: DEOP #canal nick
	
	Remove o status de Operador (modo +o) do nick dado para
	um determinado canal. Limitado aos usurios de nvel 5,
	no mnimo, do canal especificado.
	
CHAN_HELP_VOICE
	Sintaxe: VOICE [#canal [nick]]
	
	D voice para um determinado nick no canal.

CHAN_HELP_DEVOICE
	Sintaxe: DEVOICE [#canal [nick]]
	
	Tira o voice de um determinado nick no canal.
	
CHAN_HELP_HALFOP
	Sintaxe: HALFOP [#canal [nick]]
	
	Halfop um nick em um determinado canal.

CHAN_HELP_DEHALFOP
	Sintaxe: DEHALFOP [#canal [nick]]
	
	Dehalfop um nick em um determinado canal.

CHAN_HELP_PROTECT
	Sintaxe: PROTECT [#canal [nick]]
	
	Protege um determinado nick no canal.

CHAN_HELP_DEPROTECT
	Sintaxe: DEPROTECT [#canal [nick]]
	
	Desprotege um nick em um determinado canal.

CHAN_HELP_OWNER
	Syntax: OWNER [#channel]
	
	Gives you owner status on channel. If channel is not 
	given, it will give you owner status on all channels you're 
	on, provided you have the rights to.
	
	Limited to those with founder access on the channel.

CHAN_HELP_DEOWNER
	Syntax: DEOWNER [#channel]
	
	Removes your owner status on channel. If channel is 
	not given, it will remove your owner status on all channels 
	you're on, provided you have the rights to.
	
	Limited to those with founder access on the channel.

CHAN_HELP_INVITE
	Sintaxe: INVITE #canal
	
	Manda o %S dar um invite em voc para o canal dado.
	Somente funcionar se seu nvel de acesso for maior
	que zero.

CHAN_HELP_UNBAN
	Sintaxe: UNBAN #canal
	
	Diz ao %S para remover todos os bans permitindo que
	voc entre em um canal. Por padro, somente funciona se
	seu nvel de acesso no canal for maior que zero.
	
CHAN_HELP_KICK
	Sintaxe: KICK [#canal [nick [motivo]]]
	
	Kicka um determinado nick no canal.

CHAN_HELP_BAN
	Syntax: BAN [#channel [nick [reason]]]
	
	Bans a selected nick on a channel. If nick is not given,
	it will ban you. If channel and nick are not given,
	it will ban you on all channels you're on, provided you
	have the rights to.
	
	By default, limited to AOPs or those with level 5 access 
	and above on the channel.

CHAN_HELP_TOPIC
	Syntax: TOPIC channel [topic]
	
	Causes %S to set the channel topic to the one
	specified. If topic is not given, then an empty topic
	is set. This command is most useful in conjunction
	with SET TOPICLOCK. See /msg %S HELP SET TOPICLOCK
	for more information.
	
	By default, limited to those with founder access on the
	channel. 

CHAN_HELP_CLEAR
	Sintaxe: CLEAR canal opo
	
	Diz ao %S para remover certas colocaes de um canal.
	A opo pode ser uma das seguintes:
	
	     MODES    Anula todos os modos do canal (isto , remove
	              os modos i,k,l,m,n,p,s,t).
	     BANS     Remove todos os bans do canal.
	     EXCEPTS  Remove todos os excepts do canal.
	     OPS      Remove o status de Operador do canal (mode +o)
	              de todos os Operadores do canal.
	     VOICES   Remove o status "voice" (mode +v) de qualquer
	              pessoa que tenha esse modo.
	     USERS    Remove (kicka) todos os usurios do canal.
	
	Por padro, seu nvel de acesso no canal dever ser no
	mnimo 10 para usar este comando.
	
CHAN_HELP_GETKEY
	Sintaxe: GETKEY canal
	
	Retorna a key de um determinado canal. Este comando 
	geralmente usado por bots e/ou scripts, da seguinte forma:
	
	KEY <canal> <key>
	
	key  "NENHUM KEY" se nenhuma key estiver gravada.
	
CHAN_HELP_SENDPASS
	Sintaxe: SENDPASS canal
	
	Envia a senha de um determinado canal para o email gravado
	como email do canal no ChanServ. Este comando  realmente 
	til quando se trata de senhas perdidas.
	
	Pode estar limitado aos IRC operators em algumas Redes.
	
	Este comando s funciona se o modo de encriptao no estiver
	ligado.

CHAN_SERVADMIN_HELP
	
	Os seguintes comandos estao disponveis para
	os Administradores dos Services:
	
	    GETPASS    Recupera a senha de um canal
	               (caso mode de encriptao no seja usado)
	    FORBID     Previne um canal de ser registrado/usado
	    STATUS     Fornece o atual nvel de acesso de um
	               usurio em um canal
	    CLIST      Mostra todos canais que um determinado user
	                founder.
	
	Os Administradores dos Services podem tambm usar o comando
	DROP mesmo sem se identificarem como donos do cnaal, e podem
	tambm ver as listas de acesso, AKICK, e levels de qualquer
	canal.
	
CHAN_SERVADMIN_HELP_LOGOUT
	Sintaxe: LOGOUT canal [nick]
	
	Faz com que um determinado nick no esteja mais identificado
	em um determinado canal.
	
	Se voc for o founder do canal pode usar este comando em
	qualquer usurio e em si mesmo.

CHAN_SERVADMIN_HELP_DROP
	Sintaxe: DROP canal
	
	Cancela o registro de um canal. Somente Administradores dos
	Services podem cancelar canais que pertencem a outros usurios.

CHAN_SERVADMIN_HELP_SET
	
	Administradores dos Services tambm pode ajustar a opo 
	NOEXPIRE,	fazendo com que canais sejam impedidos de ter 
	seu registro expirado. AdministradoresRoot dos Services 
	ainda podem ajustar opes para qualquer canal de outros usurios.

CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	Sintaxe: SET canal NOEXPIRE {ON | OFF}
	
	Determina se o canal poder ter seu registro expirado.
	Ajustando para ON, evita que o canal seja desregistrado
	por passar do tempo de expirao.
	
	Limitado aos Administradores dos Services.

CHAN_SERVADMIN_HELP_INFO
	
	Administradores de Services podem usar o comando ALL com qualquer canal.

CHAN_SERVADMIN_HELP_LIST
	Sintaxe: LIST padrao
	
	Lista todos os canais registrados que combinam com o
	padro fornecido. Canais com opo PRIVATE ativada
	s sero mostrados aos Administradores dos Services.

	Sintaxe: GETPASS canal
	
	Retorna a senha de um canal. Note que toda vez que esse
	este comando for usado, uma mensagem incluindo o nick da
	pessoa que emitiu o comando e o canal que foi dado sero
	gravados e enviados para WALLOPS/GLOBOPS.
	
	Limitado aos Administradores dos Services.

CHAN_SERVADMIN_HELP_GETPASS
	Syntax: GETPASS channel
	
	Returns the password for the given channel.  Note that
	whenever this command is used, a message including the
	person who issued the command and the channel it was used
	on will be logged and sent out as a WALLOPS/GLOBOPS.
	
	Limited to Services admins.

CHAN_SERVADMIN_HELP_FORBID
	Sintaxe: FORBID canal
	
	Proibe que qualquer pessoa registre e utilize o canal
	dado.  Pode ser cancelado pelo desregistro do canal.
	
	Limitado aos Administradores dos Services.

CHAN_SERVADMIN_HELP_SUSPEND
	Syntax: SUSPEND channel [reason]
	
	Disallows anyone from registering or using the given
	channel.  May be cancelled by using the UNSUSPEND
	command to preserve all previous channel data/settings.
	
	Reason may be required on certain networks.
	
	Limited to Services admins.

CHAN_SERVADMIN_HELP_UNSUSPEND
	Syntax: UNSUSPEND channel
	
	Releases a suspended channel. All data and settings
	are preserved from before the suspension.
	
	Limited to Services admins.

CHAN_SERVADMIN_HELP_STATUS
	Retorna o nvel de acesso atual de um determinado nick em um
	determinado canal. A resposta ser no formato:
	
	    STATUS canal nick nvel-de-acesso
	
	Se um erro ocorrer, a resposta ser no formato:
	
	    STATUS ERROR mensagem-de-erro
	
	Limitado aos Administradores dos Services

###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP
	%S eh um utilitario que permite aos usuarios de IRC
	enviar curtas mensagens a outros usuarios, mesmo
	que eles estejam conectados no momento ou nao; ou
	nos canais(*).  Ambos, destinatarios e remetentes,
	devem possuir seu nick (ou canal) registrados para
	que possam enviar uma mensagem (memo).
	Os comandos do %S sao:
	
	    SEND   Envia uma mensagem para um nick ou para um canal
	    CANCEL Cancela o ltimo memo enviado por voc
	    LIST   Lista suas mensagens
	    READ   Le a(s) mensagem(ns)
	    DEL    Apaga a(s) mensagem(ns)
	    SET    Ajusta opcoes relacionadas as mensagens
	    INFO   Displays information about your memos
	
MEMO_HELP_ADMIN
	    SENDALL  Send a memo to all registered users

MEMO_HELP_OPER
	    STAFF  Send a memo to all opers/admins

MEMO_HELP_FOOTER
	
	Type /msg %S HELP command for help on any of the
	above commands.

	(*) By default, any user with at least level 10 access on a
	    channel can read that channel's memos.  This can be
	    changed with the %s LEVELS command.

MEMO_HELP_SEND
	Sintaxe: SEND {nick | canal} mensagem
	
	Envia um memo ao nick ou ao canal determinado contendo
	a mensagem.  Quando enviada para o destinatario, este
	recebera um aviso que possui uma nova mensagem.  O nick/
	/canal de destino devera estar registrado.
	
MEMO_HELP_CANCEL
	Sintaxe: CANCEL {nick | canal}
	
	Cancela a ltima mensagem enviada para um determinado nick ou
	canal caso ele ainda no tenha lido no momento que este comando
	for usado.

MEMO_HELP_LIST
	Sintaxe: LIST [canal] [list | NEW]
	
	Lista quaisquer mensagens que voce tiver. Com NEW, lista apenas
	as novas mensagens(nao lidas). Mesangem nao lidas sao marcadas
	com "*" a esquerda do numero. Voce tambem pode especificar uma
	lista de numeros, como no exemplo abaixo:
	
	LIST 2-5,7-9
	   Lista mensagens numeradas de 2 a 5 e 7 a 9.

MEMO_HELP_READ
	Sintaxe: READ [canal] {num | list | LAST | NEW}
	
	Mostra as mensagens especificadas. Se LAST eh fornecido, envia
	a voce a mensagem recebida mais recentemente. Se NEW eh fornecido,
	envia a voce todas as suas novas mensagens. Caso contrario, envia
	a voce uma mensagem numerada. Voce tambem pode fornecer uma lista
	de numeros, como por exemplo:
	
	READ 2-5,7-9
	   Mostra as mensagens numeradas de 2 a 5 e 7 a 9.

MEMO_HELP_DEL
	Sintaxe: DEL [canal] {num | list | LAST | ALL}
	
	Apaga a(s) mensagem(ns) especificada(s). Voce pode fornecer
	varios numeros de mensagens ou sequencias de numeros ao inves
	de um unico numero, como no segundo exemplo abaixo.

	If LAST is given, the last memo will be deleted.
	Se ALL eh fornecido, apaga todas suas mensagens.
	
	Exemplos:
	
	   DEL 1
	      Apaga sua primeira mensagem.
	
	   DEL 2-5,7-9
	      Apaga mensagens numeradas de 2 a 5 e de 7 a 9.

MEMO_HELP_SET
	Sintaxe: SET opcao parametros
	
	Ajusta varias opcoes de mensagens.  opcao pode ser uma dessas:
	
	    NOTIFY      Muda quando voce for notificado sobre novas
	                    mensagens (so para nicks)
	    LIMIT       Ajusta o numero maximo de mensagens que voce
	                    pode receber.
	
	Digite /msg %S HELP SET <comando>, para mais informacoes sobre
	um comando especifico.

MEMO_HELP_SET_NOTIFY
	Sintaxe: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	Mudancas que ocorrem quando voce for notificado sobre novas
	mensagens:
	
	    ON      Voce soh sera notificado sobre mensagens quando voce
	                conectar, quando voltar de um /AWAY e quando
	                sao enviadas a voce.
	    LOGON   Voce soh sera notificado sobre mensagens quando voce
	                conectar ou quando voltar de um /AWAY.
	    NEW     Voce soh sera notificado sobre mensagens quando
	                estiverem enviando para voce.
	    OFF     Voce nao recebera nenhuma notificacao sobre mensagens.
	
	ON eh essencialmente a combinacao LOGON e NEW.

MEMO_HELP_SET_LIMIT
	Sintaxe: SET LIMIT [canal] limite
	
	Ajusta o numero maximo de mensagens que voce pode ter
	(ou do canal fornecido).  Se voce ajustar para 0, ninguem
	sera capaz de enviar mensagens para voce.  Entretanto,
	voce nao pode ajustar este limite para mais que %d.

MEMO_HELP_INFO
	Sintaxe: INFO [canal]
	
	Informa o numero de mensagens que voce tem, quantas
	mensagens nao foram lidas, e o total de quantas
	mensagens voce pode receber.
	Com o parametro, mostra a mesma informacao para o canal
	fornecido.

MEMO_SERVADMIN_HELP_SET_LIMIT
	Sintaxe: SET LIMIT [usuario | canal] {limite | NONE} [HARD]
	
	Ajusta o numero maximo de mensagens que um nick ou canal podem
	ter.  Ajustando o limite para 0, previne o usuario de receber
	qualquer mensagem; colocando o limite em NONE permite que o
	usuario receba e mantenha quantas mensagens quiser.  Se voce
	nao fornecer o nick ou canal, seu proprio limite sera ajustado.
	
	Adicionando HARD previne que o usuario mude o limite.
	Nao colocar HARD tem o efeito contrario, permitindo
	que o usuario mude o limite (mesmo se um limite anterior
	foi ajustado com HARD).
	
	O uso do comando SET LIMIT eh limitado aos Administradores
	dos Services.  Outros usuarios somente ajustarao seus
	proprios limites ou de um canal onde tenham privilegios
	para isso, nao podem remover seu proprio limite, nao
	podem ajustar o limite acima de %d, e nao podem ajustar
	um limite maximo (HARD).

MEMO_SERVADMIN_HELP_INFO
	Sintaxe: INFO [nick | canal]
	
	Sem um parametro, informa o numero de mensagens que voce
	tem, quantas mensagens ainda nao foram lidas, e o total
	de quantas mensagens voce pode receber.
	
	Com o parametro do canal, mostra a mesma informacao sobre
	um canal.
	
	Com o parametro de nick, mostra a mesma informacao sobre
	um nick.  Esta derivacao do comando eh limitada aos
	Administradores dos Services.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_STAFF
	Syntax: STAFF memo-text

	Sends all services staff a memo containing memo-text.
	Note: If you have opers on both the oper list and the
	admin list they will recive the memo twice.  The same
	applies for oper's on the Root list as well as other
	lists.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_SENDALL
	Syntax: SENDALL memo-text

	Sends all registered users a memo containing memo-text.

###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP
	Comandos do %S:
	    GLOBAL      Envia uma mensagem para todos usurios
	    STATS       Mostra estatsticas dos Services e da Rede
	    OPER LIST   Lista todos os Operadores dos Services
	    ADMIN LIST  Lista todos os Administradores dos Services
	    STAFF       Display Services staff and online status

OPER_HELP_OPER_CMD
	Comandos disponveis para Operadores e Admins dos Services:
	    MODE        Muda o modo de um canal
	    KICK        Kicka um usurio de um canal
	    CLEARMODES  Limpa os modos de um canal
	    AKILL       Manipula a Lista de AKILL
	    SGLINE      Manipula a lista de SGLINE
	    SZLINE      Manipula a lista de SZLINE

OPER_HELP_ADMIN_CMD
	Comandos disponveis para os Administradores dos Services:
	    SESSION     Mostra a lista de conexes
	    EXCEPTION   Modifica a lista de limite de sesses
	    KILLCLONES  Derruba todos os usurio de um mesmo host
	    CHANLIST    Lista todos os records de um canal
	    USERLIST    Lista todos os records dos usurios
	    OPER        Modifica a lista de Operadores dos Services
	    LOGONNEWS   Define mensagens a serem mostradas na conexo
	    OPERNEWS    Defini mensagens a serem mostradas aos ircops
	    NOOP        Remove temporariamente as O:lines de um 
	                determinado server remotamente
	    JUPE        Jupa um servidor
	    SET         Configura varias opes globais dos Services
	    UPDATE      Salva os dados atuais
	    RELOAD      Recarrega o arquivo de configurao
	    QUIT        Retira os services da rede sem salvar os dados
	    RESTART     Salva os dados e reinicia os Services
	    SHUTDOWN    Termina os Services salvando os dados
	
	Comandos disponveis para Super usurios dos Services:
	    ADMIN       Modifica lista de Administradores dos Services

OPER_HELP_ROOT_CMD
	Commands available to Serivces Roots only:
	    MODLOAD     Load a module
	    MODUNLOAD   Un-Load a module
	    MODLIST     List loaded modules
	    MODINFO     Info about a loaded module

OPER_HELP_LOGGED
	Ateno: Todos os comandos enviados para o %S so logados!

OPER_HELP_GLOBAL
	Sintaxe: GLOBAL mensagens
	
	Permite que os IRCops enviem mensagens para todos os usurios
	da Rede. A menssagen sera enviada por %s.

OPER_HELP_STATS
	Sintaxe: STATS [AKILL | ALL]
	
	Sem nenhuma opcao, mostra o numero atual de usuarios e
	IRCops online (excluindo Services), o numero maximo de
	usuarios online conectados simultaneamente e o tempo
	de duracao desde que a secao dos Services comecou a funcionar.
	
	Com a opcao AKILL, mostra o tamanho atual da lista de
	AKILL e o tempo default para um AKILL expirar.
	
	A opcao ALL eh disponivel somente para os Administradores
	dos Services, e mostra informacoes sobre o consumo de memoria
	dos Services.  Usando este comando, pode-se congelar os
	Services por um curto periodo de tempo em redes grandes,
	entao nao abuse deste comando!
	
	UPTIME pode ser usado como um sinonimo para STATS.

OPER_HELP_OPER
	Sintaxe: OPER ADD nick
	         OPER DEL nick
	         OPER LIST
	
	Permite os Administradores dos Services adicionar ou remover
	nicks da lista de Operadores dos Services.  O usuario que
	tem o nick na lista de Operadores dos Services e que esta
	identificado no %s eh capaz de acessar os comandos de
	Operador dos Services.
	
	Qualquer IRCop pode usar o OPER LIST.
	Todos as outras derivacoes do comando OPER sao limitados
	aos Administradores dos Services.

OPER_HELP_ADMIN
	Sintaxe: ADMIN ADD nick
	         ADMIN DEL nick
	         ADMIN LIST
	
	Permite que os super-usuarios dos Services adicionem ou
	removam nicks da lista de Administradores dos Services.
	O usuario que tem o nick na lista de Administradores dos
	Services e que ja tenham se identificado no %s sera
	capaz de ter acesso aos comandos de Administradores dos
	Services.
	
	Qualquer IRCop pode usar o comando ADMIN LIST.
	Todas as outras derivacoes do ADMIN sao limitadas ao
	Super-usuario (root) dos Services

OPER_HELP_IGNORE
	Syntax: IGNORE {ADD|DEL|LIST} [time] [nick]

	Allows Services Admins to make Services ignore an user for
	a certain time or until the next restart. The default time
	format is seconds. You can specify it by using units. Valid
	units are: s for seconds, m for minutes, h for hours and
	d for days. Combinations of these units are not permitted. To 
	make Services permanently ignore the user type 0 as time.

OPER_HELP_MODE
	Sintaxe: MODE canal modos
	
	Permite que os Operadores dos Services ajustem os modos de
	qualquer canal.  Os parametros sao os mesmos que o do
	comando /MODE padrao.
	
	Limitado aos Operadores dos Services.

OPER_HELP_UMODE
	Syntax: UMODE user modes
	
	Allows Services admins to set user modes for any user.
	Parameters are the same as for the standard /MODE
	command.
	
	Limited to Services admins.

OPER_HELP_OLINE
	Syntax: OLINE user flags
	
	Allows Services admins to give Operflags to any user.
	Flags have to be prefixed with a "+" or a "-". To
	remove all flags simply type a "-" instead of any flags.

	Limited to Services admins.

OPER_HELP_CLEARMODES
	Sintaxe: CLEARMODES canal [ALL]
	
	Limpa todos os modos binarios (i,k,l,m,n,p,s,t) e bans de um
	canal.  Se ALL eh fornecido, limpa tambem todos os ops e
	voices (modos +o e +v) de um canal.
	
	Limitado aos Operadores dos Services.

OPER_HELP_KICK
	Sintaxe: KICK canal usuario razao
	
	Permite IRCops kickar qualquer usuario de um canal.
	Paramentros sao os mesmos que comando /KICK padrao.
	A mensagem do kick tem o nick do IRCop que envia o
	comando KICK, por exemplo:
	
	*** SpamMan has been kicked off from channel #bras por %S (Bras (Flood))
	
	Limitado aos Operadores dos Services.

OPER_HELP_SVSNICK
	Syntax: SVSNICK nick newnick
	
	Forcefully changes a user's nickname from nick to newnick.
	
	Limited to Services admins

OPER_HELP_AKILL
	Sintaxe: AKILL ADD [+tempo] mascara razao
	         AKILL DEL mascara
	         AKILL LIST [mascara]
	         AKILL VIEW [mascara]
	
	Permite que Operadores dos Services manipulem a lista de
	AKILL.  Se um usuario que tenta conectar possui uma mascara
	prevista na lista de AKILL, os Services emitem um KILL para
	aquele usuario, para servidores que suporta, e instrui todos
	os servidores da rede a adicionar um ban (K-line) para a
	mascara do usuario encontrado.
	
	AKILL ADD adiciona uma mascara ident@host na lista de AKILL
	para uma dada razao (deve ser posta obrigatoriamente).
	AKILL DEL remove uma dada mascara da lista de AKILL, se esta
	estiver presente.  AKILL LIST mostra todos os AKILLs atuais;
	se uma mascara opcional for fornecida, a listagem sera
	limitada aquela mascara.  AKILL VIEW eh uma versao mais
	detalhada do AKILL LIST e mostrara quem adicionou o AKILL, a
	data que foi adicionado, e quando sera expirado, como tambem
	a mascara (ident@host) e a razao.
	
	Opcionalmente, um tempo para o akill expirar pode ser
	fornecido com o comando AKILL ADD.  O tempo precede a
	mascara ident@host, e eh especificado como um numero inteiro
	seguido por um dos d (dias), h (horas) ou m (minutos).
	Combinacoes (como de 1h30m) nao sao permitidas.  Se uma
	unidade especifica nao eh incluida, o default e em dias
	(entao +30 significa 30 dias). Para adicionar um AKILL que
	nao expira, use +0.  Se a mascara a ser adicionada comecar
	com um +, o tempo do AKILL deve ser fornecido, ate mesmo se
	este tempo for igual ao default.  O atual tempo de expiracao
	de AKILLs pode ser encontrado com o comando STATS AKILL.
	
	A razao existe apenas para uso dos IRCops, e nao sera
	mostrada aos usuarios nas mensagens de KILL.
	
	Este comando eh limitado aos Operadores dos Services.
	
OPER_HELP_SGLINE
	Sintaxe: SGLINE ADD [+tempo] mscara:motivo
	       SGLINE DEL {mscara | nm-entrada | lista}
	         SGLINE LIST [mscara | lista]
	         SGLINE VIEW [mscara | lista]
	         SGLINE CLEAR
	
	Permite que os Operadores dos Services manipulem a lista de
	SGLINE. Se um user estiver com a mesma mscara do SGLINE tentar 
	conectar, os Services no permitiro tal feito.
	
	Limitado aos Operadores dos Services.

OPER_HELP_SQLINE
	Syntax: SQLINE ADD [+expiry] mask reason
	        SQLINE DEL {mask | entry-num | list}
	        SQLINE LIST [mask | list]
	        SQLINE VIEW [mask | list]
	        SQLINE CLEAR
	
	Allows Services operators to manipulate the SQLINE list.  If
	a user with a nick matching an SQLINE mask attempts to 
	connect, Services will not allow it to pursue his IRC
	session.
	
	If the first character of the mask is #, services will 
	prevent the use of matching channels (on IRCds that 
	support it).
	
	SQLINE ADD adds the given mask to the SQLINE
	list for the given reason (which must be given).
	expiry is specified as an integer followed by one of d 
	(days), h (hours), or m (minutes).  Combinations (such as 
	1h30m) are not permitted.  If a unit specifier is not 
	included, the default is days (so +30 by itself means 30 
	days).  To add an SQLINE which does not expire, use +0.  
	If the mask to be added starts with a +, an expiry time 
	must be given, even if it is the same as the default. The
	current SQLINE default expiry time can be found with the
	STATS AKILL command.
	
	The SQLINE DEL command removes the given mask from the
	SQLINE list if it is present.  If a list of entry numbers is 
	given, those entries are deleted.  (See the example for LIST 
	below.)
	
	The SQLINE LIST command displays the SQLINE list.  
	If a wildcard mask is given, only those entries matching the
	mask are displayed.  If a list of entry numbers is given,
	only those entries are shown; for example:

	   SQLINE LIST 2-5,7-9
	      Lists SQLINE entries numbered 2 through 5 and 7 
	      through 9.
	      
	SQLINE VIEW is a more verbose version of SQLINE LIST, and 
	will show who added an SQLINE, the date it was added, and when 
	it expires, as well as the mask and reason.
	
	SQLINE CLEAR clears all entries of the SQLINE list.
	
	Limited to Services operators.

OPER_HELP_SZLINE
	Sintaxe: SZLINE ADD [+tempo] mscara motivo
	         SZLINE DEL {mscara | nm-entrada | lista}
	         SZLINE LIST [mscara | lista]
	         SZLINE VIEW [mscara | lista]
	         SZLINE CLEAR
	
	Permite que os Operadores dos Services manipulem a lista
	de SZLINE. Se um usurio com o mesmo IP do SZLINE tentar 
	conectar, os Services no permitiro tal feito.
	
	Limitado aos Operadores dos Services.

OPER_HELP_SET
	Sintaxe: SET opcao selecao
	
	Ajusta varias opcoes globais dos Services.  Nomes de opcao
	atualmente definidas sao:
	    READONLY   Determina o modo read-only ou read-write
	    LOGCHAN    Ativa ou desativa reported de log a um canal
	    DEBUG      Ativa ou desativa o modo de depuracao (debug)
	
	Limitado aos Administradores dos Services.

OPER_HELP_SET_READONLY
	Sintaxe: SET READONLY {ON | OFF}
	
	Ativa ou desativa o modo read-only.  No modo read-only,
	usuarios normais nao serao capazes de modificar nenhum dado
	nos Services, incluindo lista de acesso de canais e nick,
	etc.  IRCops com privilegios suficientes nos Services serao
	capazes de mudar a lista de AKILL e de proibir e cancelar o
	registro de canais ou nicks, embora quaisquer mudancas nao
	serao salvas no banco de dados a menos que o modo read-only
	seja desativado antes dos Services serem terminados ou
	reiniciados.
	
	Esta opcao eh equivalente a opcao da linha de comando
	"-readonly".

OPER_HELP_SET_LOGCHAN
	Sintaxe: SET LOGCHAN {ON | OFF}

	No modo on, Services enviam todo o log para o canal especificado.
	LogChannel tem q estar definido na configuracion dos Services para
	poder usar esta opcao.

	Nota: O canal deve estar apropriadamente seguro, e so permitir
	ingresso a Administradores.

OPER_HELP_SET_DEBUG
	Sintaxe: SET DEBUG {ON | OFF | numero}
	
	Ativa ou desativa o modo de depuracao (debug).  No modo de
	depuracao, todos os dados enviados para os Services, assim
	como todas as outras mensagens de depuracao sao enviadas a
	um arquivo de log.  Se num eh fornecido, o modo de depuracao
	eh ativado, com nivel de debug fornecido.
	
	Esta opcao eh equivalente a opcao da linha de comando
	"-debug".
	
OPER_HELP_SET_NOEXPIRE
	Sintaxe: SET NOEXPIRE {ON | OFF}
	
	Ativa ou desativa o modo NOEXPIRE.  Se estiver ativado, os nicks
	canais, akills e lista de sesses no iro expirar enquanto a 
	opo no for desativada.

OPER_HELP_SET_SUPERADMIN
	Syntax: SET SUPERADMIN {ON | OFF}

	Setting this will grant you extra privlages such as the
	ability to be "founder" on all channel's etc...

	This opion is _NOT_ persistant, and should only be used when
	needed, and set back to OFF when no longer needed.


OPER_HELP_NOOP
	Sintaxe: NOOP SET servidor
	         NOOP REVOKE servidor
	
	NOOP SET Adiciona NOOP em um servidor 
	
	NOOP REVOKE Remove NOOP de um servidor
	
	Lembrete: O servidor nunca  checado pelos Services.
	
	Limitado aos Administradores dos Services.

OPER_HELP_JUPE
	Sintaxe: JUPE servidor
	
	Diz aos Services para "jupar" um servidor -- isto eh, criar
	um falso servidor conectado aos Services que previne que o
	servidor real com aquele nome se conecte na rede.  O jupe
	pode ser removido usando um simples SQUIT.
	
	Limitado aos Administradores dos Services.

OPER_HELP_RAW
	Sintaxe: RAW texto
	
	Envia uma serie de texto diretamente ao servidor onde os
	Services estao conectados.  Este comando tem varias
	limitacoes de uso, e pode criar confusoes e problemas na
	rede se usado impropriamente. NAO USE ESTE COMANDO a menos
	que voce tenha a certeza do que esta fazendo!
	
	Limitado aos Administradores dos Services.

OPER_HELP_UPDATE
	Sintaxe: UPDATE
	
	Faz com que os Services atualizem o banco de dados logo que
	voce envia este comando.
	
	Limitado aos Administradores dos Services.
	
OPER_HELP_RELOAD
	Syntax: RELOAD
	
	Faz com que os Services recarreguem seu arquivo de configurao. 
	Repare que algumas mudanas sero necessrias que os Services 
	sejam reinicados para ter efeito.
	
	Limitado aos Administradores dos Services.

OPER_HELP_QUIT
	Sintaxe: QUIT
	
	Faz com que deligue os Services imediatamente; o banco de
	dados nao eh salvo.  Este comando nao deve ser usado a menos
	que haja um dano da copia do banco de dados na memoria e por
	isso nao eles nao devem ser salvos.  Para desligar
	normalmente, use o comando SHUTDOWN.
	
	Limitado aos Administradores dos Services.

OPER_HELP_SHUTDOWN
	Sintaxe: SHUTDOWN
	
	Salva o banco de dados dos Services e os desliga.
	
	Limitado aos Administradores dos Services.

OPER_HELP_RESTART
	Sintaxe: RESTART
	
	Salva o banco de dados dos Services e os reinicia.
	(sai e roda imediatamente o executavel).
	
	Limitado aos Administradores dos Services.

OPER_HELP_KILLCLONES
	Sintaxe: KILLCLONES nick
	
	Expulsa ("killa") todos os usuarios que tenham os mesmos
	hosts que o nick especificado, adicionando *@host.com como 
	AKILL temporario para prevenir que usuarios indesejados
	reconectem imediatamente. Uma mensagem em WallOps eh tambem
	enviada para indicar quem usou o comando, quais hosts foram
	afetados e quantos usuarios foram expulsos ("killados").
	Eh usado para remover varios clones da rede.
	
	Limitado aos Administradores dos Services.
	
OPER_HELP_CHANLIST
	Sintaxe: CHANLIST [{padro | nick} [SECRET]]
	
	Lista todos os canais em uso na Rede, sejam eles registrados ou no.
	
	Limitado aos Administradores dos Services.
	
OPER_HELP_USERLIST
	Sintaxe: USERLIST [{padro | canal} [INVISIBLE]]
	
	Lista todos os usurios online na Rede, sejam eles registrados
	ou no.
	
	Limitado aos Administradores dos Services.
	
###########################################################################
#
# BotServ help messages
#
###########################################################################
	
OPER_HELP_CACHE
	Syntax: CACHE DEL hostname
	        CACHE LIST pattern [QUEUED | ALL]
	
	The CACHE DEL command deletes the specified hostname from 
	the cache. This is meant for debug purpose only.

	The CACHE LIST command lists all found proxies that match the
	given pattern. If the QUEUED option is given, it will list
	the queued or in progress scans instead, and if the ALL option 
	is given, it will list all cached hostnames.
	
	Limited to Services admins.

###########################################################################
#
# BotServ help messages
#
###########################################################################
	
OPER_HELP_MODLOAD
	Syntax: MODLOAD FileName

	This command loads the module named FileName from the modules
	directory.

	Limited to Services Roots.

OPER_HELP_MODUNLOAD
	Syntax: MODUNLOAD FileName

	This command unloads the module named FileName from the modules
	directory.

	Limited to Services Roots.

OPER_HELP_MODINFO
	Syntax: MODINFO FileName

	This command lists information about the specified loaded module

	Limited to Services Roots.

OPER_HELP_MODLIST
	Syntax: MODLIST

	Lists all currently loaded modules.

	Limited to Services Roots.


###########################################################################
#
# BotServ help messages
#
###########################################################################
	
BOT_HELP
	%S permite que voc tenha um bot no seu canal.
	Foi criado para usurios que no tem como hospedar
	ou configurar um bot, ou para Redes que no permitem
	os usurios terem um bot. Os comandos disponveis 
	esto listados abaixo; para us-los, digite
	/msg %S comando. Para informaes mais especficas
	sobre um comando, digite /msg %S HELP comando.
	
	BOTLIST            Lista os bots disponveis
	ASSIGN             Associa um bot ao canal
	SET                Configura as opes do bot
	KICK               Configura os kickers
	BADWORDS           Configura os palavres
	
	Outros comandos: ACT INFO SAY UNASSIGN
	
	O bot ir entrar no canal sempre que tiver ao menos
	%d usurio(s) nele.
	
BOT_HELP_BOTLIST
	Sintaxe: BOTLIST
	
	Lista todos os bots disponveis nesta Rede.
	
BOT_HELP_ASSIGN
	Sintaxe: ASSIGN canal nick-bot
	
	Associa o nick de um bot a um canal. Voc poder ento
	configurar o bot para o canal de acordo com as suas
	necessidades.  
	
BOT_HELP_UNASSIGN
	Sintaxe: UNASSIGN canal
	
	Desassocia um bot de um canal. Quando voc usa este comando,
	o bot no ir entrar mais no canal. Entretando, ser mantido
	a configurao do bot para aquele canal, para que voc possa
	sempre poder associ-lo aquele canal mais tarde sem ter que
	configurar tudo novamente.
	
BOT_HELP_INFO
	Sintaxe: INFO {canal | nick}
	
	Permite que voc possas ver as informaes do %S sobre um
	canal ou bot. Se a opo for um canal, ento voc ter
	informaes tais como kickers ativos. Se tiver sido um nick,
	voc ter informaes sobre o bot, como o horrio de criao
	ou nmero do canal.
	
BOT_HELP_SET
	Sintaxe: SET canal opo parmetros
	
	Configura as opes do bot.  opo pode ser:
	
	    DONTKICKOPS      Protege os ops contra kicks
	    DONTKICKVOICES   Protege os voices contra kicks
	    GREET            Habilita a mensagem de entrada
	    FANTASY          Habilita os comandos Fantasia
	    SYMBIOSIS        Permite que o bot seja um bot real
	
	Digite /msg %S HELP SET opo para maiores informaes
	sobre uma opo especfica.
	
	Ateno: o acesso a este comando  controlado pela opo
	level SET.
	
BOT_HELP_SET_DONTKICKOPS
	Sintaxe: SET canal DONTKICKOPS {ON|OFF}
	
	Ativa ou desativa o modo de proteo de ops em um canal.
	Quando estiver ativado, os ops no sero kickados pelo bot.
	
BOT_HELP_SET_DONTKICKVOICES
	Sintaxe: SET canal DONTKICKVOICES {ON|OFF}
	
	Ativa ou desativa o modo de proteo de voices em um canal.
	Quando estiver ativado, os voices no sero kickados pelo bot.
	
BOT_HELP_SET_FANTASY
	Sintaxe: SET canal FANTASY {ON|OFF}
	
	Ativa ou desativa o modo fantasia em um canal.
	Quando estiver ativado, os usurios podero usar
	comandos como !op, !deop, !voice, !devoice,
	!kick, !kb, !unban, !seen em um canal.
	
	Note que os usurios que quiserem usar esses 
	comandos DEVEM ter um nvel suficiente tanto para
	o FANTASIA quando para outro nvel dependendo
	do comando usado (por exemplo, para usar !op, o 
	usurio deve ter acesso aos comandos OP e DEOP).

BOT_HELP_SET_GREET
	Sintaxe: SET canal GREET {ON|OFF}
	
	Ativa ou desativa o modo greet em um canal.
	Quando ativado, o bot ir mostrar mensagens de
	entradas dos usurios quando eles entrarem no
	canal, caso eles tenham nvel de acessosuficiente.

BOT_HELP_SET_SYMBIOSIS
	Sintaxe: SET canal SYMBIOSIS {ON|OFF}
	
	Ativa ou desativa o modo symbiosis em um canal.
	Quando ativado, o bot far tudo aquilo que 
	normalmente  feito pelo %s nos canais, como as 
	mudanas de modos, kicks, e inclusive a mensagem
	de entrada (entrymsg).

BOT_HELP_KICK
	Sintaxe: KICK canal opo parmetros
	
	Configura os kicks do bot.  opo pode ser:
	
	    BOLDS         Seleciona se o bot kicka por negrito
	    BADWORDS      Seleciona se o bot kicka por palavres
	    CAPS          Seleciona se o bot kicka por caps
	    COLORS        Seleciona se o bot kicka por cores
	    FLOOD         Seleciona se o bot kicka por flood
	    REPEAT        Seleciona se o bot kicka por repetio
	    REVERSES      Seleciona se o bot kicka por reversos
	    UNDERLINES    Seleciona se o bot kicka por sublinhado
	
	Digite /msg %S HELP KICK opo para maiores informaes
	sobre uma opo especfica.
	
	Nota: o acesso a esse comando  controlado pelo level SET.

BOT_HELP_KICK_BOLDS
	Sintaxe: KICK canal BOLDS {ON|OFF} [ttb]

	Ativa ou desativa o kick por negrito. Quando ativado
	o bot ir kickar os usurios que usarem negrito.

	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido.

BOT_HELP_KICK_COLORS
	Sintaxe: KICK canal COLORS {ON|OFF} [ttb]

	Ativa ou desativa o kick por cores. Quando ativado
	o bot ir kickar os usurios que usarem cores.

	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido.

BOT_HELP_KICK_REVERSES
	Sintaxe: KICK canal REVERSES {ON|OFF} [ttb]

	Ativa ou desativa o kick por reverso. Quando ativado
	o bot ir kickar os usurios que usarem reverso.

	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido.

BOT_HELP_KICK_UNDERLINES
	Sintaxe: KICK canal UNDERLINES {ON|OFF} [ttb]

	Ativa ou desativa o kick por sublinhado. Quando ativado
	o bot ir kickar os usurios que usarem sublinhado.

	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido.

BOT_HELP_KICK_CAPS
	Sintaxe: KICK canal CAPS {ON|OFF} [ttb [min [porcent]]]

	Ativa ou desativa o kick por caps. Quando ativado
	o bot ir kickar os usurios que usarem caps.

	O bot ir kickar apenas se tiver pelo menos min caps
	e eles constiturem pelo menos porcent%% do total 
	do texto (se no for especificado, o padro  10 caracteres
	e 25%%).

	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido.

BOT_HELP_KICK_FLOOD
	Sintaxe: KICK canal FLOOD {ON|OFF} [ttb [linhas [segs]]]

	Ativa ou desativa o kick por flood. Quando ativado o
	o bot ir kickar por flood no canal desde que sejam
	pelo menos linhas linhas em segs segundos.
	(se no for especificado, o padro  6 linhas em
	10 segundos).
	
	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido.

BOT_HELP_KICK_REPEAT
	Sintaxe: KICK #canal REPEAT {ON|OFF} [ttb [nm]]

	Ativa ou desativa o kick por repetio. Quando ativado
	o bot ir kickar os usurios que repetirem (onde
	nm  o nmero de repeties para kick).

	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido.

BOT_HELP_KICK_BADWORDS
	Sintaxe: KICK #canal BADWORDS {ON|OFF} [ttb]

	Ativa ou desativa o kick por sublinhado. Quando ativado
	o bot ir kickar os usurios que usarem sublinhado.

	ttb  o nmero de vezes que o usurio ser kickado
	antes de ser banido.

	Voc pode definir os palavres para um canal usando o
	comando BADWORDS. Digite /msg %S HELP BADWORDS para
	maiores informaes.

BOT_HELP_BADWORDS
	Sintaxe: BADWORDS canal ADD palavra [SINGLE | START | END]
	         BADWORDS canal DEL {palavra | nm-entrada | lista}
	         BADWORDS canal LIST [mscara | lista]
	         BADWORDS canal CLEAR
	
	Faz a manuteno da lista de palavres em um canal. Essa lista
	determina quais so as palvras que devero ser motivo de kick
	em um canal quando a opo BADWORDS estiver ativada. Para maiores
	informaes, digite /msg %S HELP KICK BADWORDS.
	
	O comando BADWORDS ADD adiciona a palavra na lista de
	palavres. A opo SINGLE quando ativada s kicka o usurio
	se ele escrever a palavra inteira. A opo START quando 
	ativada ir kickar o usurio que escrever uma palavra que comece
	com a palavra. A opo END se tiver sido ativada s kicka
	o usurio que escrever uma palavra que termine com a
	palavra. Se voc no especificar nada o bot ir kickar sempre
	que a palavra for escrita pelo usurio.
	
	O comando BADWORDS DEL remove uma palavra da lista de
	palavres de um determinado canal.
	
	O comando BADWORDS LIST mostra a lista de palavres.
	Se forem usados wildcards, apenas aquelas entradas com
	as determinadas mscaras sero mostradas.  Se uma lista
	de nmeros de entrada for dada, apenas aquelas entradas
	sero mostradas; por exemplo:

	   BADWORDS #canal LIST 2-5,7-9
	      Lista as entradas dos palavres numeradas de 2 a 5 e
	      7 a 9.
	      
	O comando BADWORDS CLEAR limpa todas entradas da lista.

BOT_HELP_SAY
	Sintaxe: SAY canal texto
	
	Faz com que o bot diga determinado texto no determinado canal.

BOT_HELP_ACT
	Sintaxe: ACT canal texto
	
	Faz com que o bot faa o mesmo que o comando "/me"
	em um determinado canal com o determinado texto.

BOT_SERVADMIN_HELP
	
	Os seguintes comandos podem ser usados por Admins dos Services:
	
	    BOT              Mantm a lista de bots da Rede

BOT_SERVADMIN_HELP_BOT
	Sintaxe: BOT ADD nick user host real
	         BOT CHANGE oldnick novonick [user [host [real]]]
	         BOT DEL nick
	         BOT LIST
	
	Permite que os Administradores dos Services criem,
	modifiquem, e apaguem bots que os usurios podero usar
	em seus prprios canais.
	
	BOT ADD adiciona um bot com um determinado nick, username,
	hostname e realname. 
	BOT CHANGE permite alterar o nick, username, hostname
	ou realname de um bot sem que seja necessrio apag-lo (e
	todas as informaes nele contidas).
	BOT DEL remove um bot da lista de bots.  
	BOT LIST  um an alias de BOTLIST e apenas lista todos
	os bots disponveis na Rede.
	
	Nota: se voc criar um bot que use um nick registrado 
	no NickServ, este ser dropado. E se tiver um usurio
	usando o nick na hora, este ser killado.

BOT_SERVADMIN_HELP_SET
	
	Essas opes so reservadas aos Administradores dos Services:
	
	    NOBOT            Previne um bot de ser associado a 
	                     um canal

BOT_SERVADMIN_HELP_SET_NOBOT
	Sintaxe: SET canal NOBOT {ON|OFF}
	
	Este comando faz com que um determinado canal no possa ser
	associado a um bot. Se j houver um bot associado a este
	canal, este ser automaticamente desassociado quando voc
	ativar essa opo.
	
	Limitado aos Administradores dos Services.
BOT_SERVADMIN_HELP_SET_PRIVATE
	Syntax: SET bot-nick PRIVATE {ON|OFF}
	
	This option prevents a bot from being assigned to a
	channel by users that aren't IRC operators.
	
	Limited to Services admins.

###########################################################################
#
# HostServ messages
#
###########################################################################
HOST_EMPTY
	The vhost list is empty.
HOST_ENTRY
	#%d Nick:%s, vhost:%s (%s - %s)
HOST_IDENT_ENTRY
	#%d Nick:%s, vhost:%s@%s (%s - %s)
HOST_SET
	vhost for %s set to %s.
HOST_IDENT_SET
	vhost for %s set to %s@%s.
HOST_SETALL
	vhost for group %s set to %s.
HOST_DELALL
	vhosts for group %s have been removed.
HOST_DELALL_SYNTAX
	Syntax: DELALL <nick>.
HOST_IDENT_SETALL
	vhost for group %s set to %s@%s.
HOST_SET_ERROR
	Error! A vhost can only contain A-Z, a-z, 0-9, '.' and '-'.
HOST_SET_IDENT_ERROR
	A vhost ident must be in the format of a valid ident
HOST_SET_TOOLONG
	Error! The vhost is too long, please use a host shorter than %d characters.
HOST_SET_IDENTTOOLONG
	Error! The Ident is too long, please use an ident shorter than %d characters.
HOST_NOREG
	User %s not found in the nickserv db.
HOST_SET_SYNTAX
	Syntax /msg %s set <nick> <hostmask>.
HOST_SETALL_SYNTAX
	Syntax /msg %s setall <nick> <hostmask>.
HOST_DENIED
	Access Denied.
HOST_NOT_ASSIGNED
	Please contact an Operator to get a vhost assigned to this nick.
HOST_ACTIVATED
	Your vhost of %s is now activated.
HOST_IDENT_ACTIVATED
	Your vhost of %s@%s is now activated.
HOST_ID
	Please identify to services first.
HOST_NOT_REGED
	You need to register before a vhost can be assigned to you.
HOST_DEL
	vhost for %s removed.
HOST_DEL_SYNTAX
	Syntax: /msg %s del <nick>.

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_OFF_UNREAL
	Your vhost was removed. To re-enable the standard host cloaking, type /mode %s +x
HOST_NO_VIDENT
	Your IRCD does not support vIdent's, if this is incorrect, please report this as a possible bug

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_GROUP
	All vhost's in the group %s have been set to %s
HOST_IDENT_GROUP
	All vhost's in the group %s have been set to %s@%s

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_LIST_FOOTER
	Displayed all records (Count: %d)
HOST_LIST_RANGE_FOOTER
	Displayed records from %d to %d
HOST_LIST_KEY_FOOTER
	Displayed records matching key %s (Count: %d)

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_HELP
	%S commands:
	    ON          Activates your assigned vhost
	    OFF         Deactivates your assigned vhost

HOST_OPER_HELP
	Commands available to services operators only:
	    SET         Set the vhost of another user
	    SETALL      Set the vhost for all nicks in a group
	    DEL         Delete the vhost of another user
	    LIST        Displays one or more vhost entries.

HOST_ADMIN_HELP
	Commands available to services admins only:

HOST_HELP_ON
	Syntax: ON

	Activates the vhost currently assigned to the nick in use.
	When you use this command any user who performs a /whois
	on you will see the vhost instead of your real IP address.

HOST_HELP_SET
	Syntax: SET <nick> <hostmask>.

	Sets the vhost for the given nick to that of the given
	hostmask.  If your IRCD supports vIdents, then using
	SET <nick> <ident>@<hostmask> set idents for users as 
	well as vhosts.

	Limited to Services operators.

HOST_HELP_DELALL
	Syntax: DELALL <nick>.

	Deletes the vhost for all nick's in the same group as
	that of the given nick.

	Limited to Host Removers.


HOST_HELP_SETALL
	Syntax: SETALL <nick> <hostmask>.

	Sets the vhost for all nicks in the same group as that
	of the given nick.  If your IRCD supports vIdents, then
	using SETALL <nick> <ident>@<hostmask> will set idents
	for users as well as vhosts.

	* NOTE, this will not update the vhost for any nick's
	added to the group after this command was used.

	Limited to Services operators.

HOST_HELP_OFF
	Syntax: OFF

	Deactivates the vhost currently assigned to the nick in use.
	When you use this command any user who performs a /whois
	on you will see your real IP address.

HOST_HELP_DEL
	Syntax: DEL <nick>

	Deletes the vhost assigned to the given nick from the
	database.

	Limited to Services operators.

HOST_HELP_LIST
	Syntax: LIST [<key>|<#X-Y>]

	This command lists registered vhosts to the operator
	if a Key is specified, only entries whos nick or vhost match
	the pattern given in <key> are displayed e.g. Rob* for all
	entries beginning with "Rob"

	If a #X-Y style is used, only entries between the range of X
	and Y will be displayed, e.g. #1-3 will display the first 3
	nick/vhost entries.

	The list uses the value of NSListMax as a hard limit for the
	number of items to display to a operator at any 1 time.

	Limited to Services operators.

HOST_HELP_GROUP
	Syntax: GROUP
	
	This command allows users to set the vhost of thier
	CURRENT nick to be the vhost for all nicks in the same
	group.
