# Turkish language file.
#
# (C) 2003 Anope Team
# Contact us at info@anope.org
#
# Please read COPYING and README for furhter details.
#
# Based on the original code of Epona by Lara.
# Based on the original code of Services by Andy Church.
#
# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, let me know
# (achurch@dragonfire.net) which message is causing a problem and I'll see
# what I can do.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# config.h).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.

###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	Trke (Turkish)
#################################################################
# Translated by CafeiN (oytuny@yahoo.com) irc.ixir.net          #
# Modified by MeShGuL - guzelbey@cs.utk.edu - irc.arkadas.com   #
#################################################################

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%b %d %H:%M:%S %Y %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %b %d %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%b %d %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	Paz
	Pzt
	Sal
	ar
	Per
	Cum
	Cmt
# %A
STRFTIME_DAYS_LONG
	Pazar
	Pazartesi
	Sal
	aramba
	Perembe
	Cuma
	Cumartesi
# %b
STRFTIME_MONTHS_SHORT
	Oca
	ub
	Mar
	Nis
	May
	Haz
	Tem
	Au
	Eyl
	Eki
	Kas
	Ara
# %B
STRFTIME_MONTHS_LONG
	Ocak
	ubat
	Mart
	Nisan
	Mays
	Haziran
	Temmuz
	Austos
	Eyll
	Ekim
	Kasm
	Aralk


# This is used in ChanServ/NickServ INFO displays.
COMMA_SPACE
	, 


# Various error messages.
USER_RECORD_NOT_FOUND
	Dahili hata - Kullanc kayd bulunamad.
UNKNOWN_COMMAND
	Varolmayan komut %s.
UNKNOWN_COMMAND_HELP
	Varolmayan komut %s. yardm iin "/msg %s HELP" yaznz.
SYNTAX_ERROR
	Kullanm: %s
MORE_INFO
	Daha fazla bilgi iin /msg %s HELP %s yaznz.
NO_HELP_AVAILABLE
	%s hakknda yardm bulunamad.
OBSOLETE_COMMAND
	Bu komut artk kullanlmyor; onun yerine %s komutunu deneyin.

BAD_USERHOST_MASK
	Mask user@host eklinde tanmlanmaldr.
BAD_EXPIRY_TIME
	Geersiz zaman am sresi.
USERHOST_MASK_TOO_WIDE
	%s kapsam ar geni; Ltfen daha belirli bir mask kullann.

SERVICE_OFFLINE
	%s u an devre d.
READ_ONLY_MODE
	Not: Servisler read-only modunda; deiiklikler kaydedilmeyecektir!
PASSWORD_INCORRECT
	ifre geersiz.

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	Bu komuta eriiminiz yok.
PERMISSION_DENIED
	Bu komutu kullanma izniniz yok.
RAW_DISABLED
	The RAW option has been disabled. If you must use it, enable the DisableRaw directive in Services configuration.

MORE_OBSCURE_PASSWORD
	Ltfen daha zor bir ifre deneyin.  ifreler en az 5 karakter uzunlukta, kolayca tahmin edilemeyecek birey olmaldr(r: gerek isminiz, nickiniz v.b. olmamaldr), ve bolukla tab kullanlmamaldr.
PASSWORD_TRUNCATED
	Uyar:  ifreniz %d karaktere kadar ksaltld.

NICK_NOT_REGISTERED
	Nickiniz kaytl deil.
NICK_NOT_REGISTERED_HELP
	Nickiniz kaytl deil.  Nick kayt hakknda bilgi almak iin /msg %s HELP yazn.
NICK_X_NOT_REGISTERED
	%s kaytl bir nick deil.
NICK_X_IN_USE
	Nick %s is currently in use.
NICK_X_NOT_IN_USE
	%s nicki u an kullanmda deil.
NICK_X_NOT_ON_CHAN
	%s su anda %s kanalinda degil.
NICK_X_FORBIDDEN
	%s nicki kayt edilemez ve kullanlamaz.
NICK_X_FORBIDDEN_OPER
	%s nicki yasaklanmtr. %s:
	%s
NICK_X_ILLEGAL
	Nick %s is an illegal nickname and cannot be used.
NICK_X_TRUNCATED
	Nick %s was truncated to %d characters.
CHAN_X_NOT_REGISTERED
	%s kanal kaytl deil.
CHAN_X_NOT_IN_USE
	%s kanal u an kullanmda deil.
CHAN_X_FORBIDDEN
	%s kanal kayt edilemez ve kullanlamaz.
CHAN_X_FORBIDDEN_OPER
	%s kanal yasaklanmtr. %s:
	%s
CHAN_X_SUSPENDED
	      Suspended: [%s] %s
NICK_IDENTIFY_REQUIRED
	Bu komutu kullanabilmek iin ifrenizi girmelisiniz.
	/msg %s IDENTIFY ifreniz yazarak yeniden deneyiniz.
CHAN_IDENTIFY_REQUIRED
	Bu komutu kullanabilmek iin ifrenizi girmelisiniz.
	/msg %s IDENTIFY %s ifreniz yazarak yeniden deneyiniz.
	
MAIL_DISABLED
	Servislerin mail gnderme zellii devre ddr.
MAIL_INVALID
	%s iin mail adresi geerli deil.
MAIL_X_INVALID
	%s geerli bir mail adresi deil.
MAIL_LATER
	u an mail gnderilemiyor; ltfen az sonra tekrar deneyin.
MAIL_DELAYED
	Ltfen %d saniye bekleyin ve tekrar deneyin.
	
NO_REASON
	Sebep yok
UNKNOWN
	<varolmayan>

# Duration system
DURATION_DAY
	1 gn
DURATION_DAYS
	%d gn
DURATION_HOUR
	1 saat
DURATION_HOURS
	%d saat
DURATION_MINUTE
	1 dakika
DURATION_MINUTES
	%d dakika
DURATION_SECOND
	1 saniye
DURATION_SECONDS
	%d saniye

# Human readable expiration
NO_EXPIRE
	zaman am yok
EXPIRES_SOON
	bir sonraki veritaban gncellemesinde zaman am sresi dolacak
EXPIRES_M
	%d dakika sonra zaman am sresi dolacak
EXPIRES_1M
	%d dakika sonra zaman am sresi dolacak
EXPIRES_HM
	%d saat, %d dakika sonra zaman am sresi dolacak
EXPIRES_H1M
	%d saat, %d dakika sonra zaman am sresi dolacak
EXPIRES_1HM
	%d saat, %d dakika sonra zaman am sresi dolacak
EXPIRES_1H1M
	%d saat, %d dakika sonra zaman am sresi dolacak
EXPIRES_D
	%d gn sonra zaman am sresi dolacak
EXPIRES_1D
	%d gn sonra zaman am sresi dolacak

# Generic Footer message
END_OF_ANY_LIST
	End of %s list.


###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Bu nick bakasna ait. Ltfen baka bir tane sein.
	(Eer bu sizin nickiniz ise, /msg %s IDENTIFY ifreniz yaznz.)
NICK_IS_SECURE
	Bu nick kaytl ve korumaldr. Eer bu sizin nickiniz ise, 
	/msg %s IDENTIFY ifreniz yaznz. Yada, baka bir nick sein.
NICK_MAY_NOT_BE_USED
	Bu nick kullanlamaz.  Ltfen baka bir tane sein.
FORCENICKCHANGE_IN_1_MINUTE
	Eer bir dakika iinde nickinizi deitirmezseniz, Ben deitireceim.
FORCENICKCHANGE_IN_20_SECONDS
	Eer 20 saniye iinde nickinizi deitirmezseniz, Ben deitireceim.
FORCENICKCHANGE_NOW
	Bu nick kaytldr; bunu kullanamazsnz.
FORCENICKCHANGE_CHANGING
	Nickiniz %s olarak deitirildi.

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER ifreniz [emailiniz]
NICK_REGISTER_SYNTAX_EMAIL
	REGISTER ifreniz emailiniz
NICK_REGISTRATION_DISABLED
	Nick kayd geici olarak devre ddr.
NICK_REGISTRATION_FAILED
	Nick kayd baarsz.
NICK_REG_PLEASE_WAIT
	Ltfen %d saniye REGISTER komutunu tekrar kullanmak iin bekleyin.
NICK_CANNOT_BE_REGISTERED
	%s nicki kayt edilemez.
NICK_ALREADY_REGISTERED
	%s nicki zaten kaytl!
NICK_REGISTERED
	%s nicki sizin adnza kayt edildi: %s
NICK_PASSWORD_IS
	Nick ifreniz %s - lerde kullanacanz iin unutmaynz ve kimseye sylemeyiniz.

# GROUP responses
NICK_GROUP_SYNTAX
	GROUP hedef ifre
NICK_GROUP_DISABLED
	Nick gruplama geici olarak devre d.
NICK_GROUP_FAILED
	Nick gruplama baarsz.
NICK_GROUP_PLEASE_WAIT
	GROUP komutunu tekrar kullanmadan nce ltfen %d saniye bekleyin.
NICK_GROUP_CHANGE_DISABLED
	Nickiniz zaten kaytl; nce /msg %s DROP yazn.
NICK_GROUP_SAME
	%s grubunun zaten bir yesisiniz.
NICK_GROUP_TOO_MANY
	%s nickinin grubunda ok fazla nick var; listeleyip birkaini silin.
	Daha fazla bilgi iin /msg %s HELP GLIST ve /msg %s HELP DROP 
	yazin.
NICK_GROUP_JOINED
	%s grubuna dahil edildiniz.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY ifreniz
NICK_IDENTIFY_FAILED
	Tanmlama baarsz.
NICK_IDENTIFY_SUCCEEDED
	ifre kabul edildi.
NICK_IDENTIFY_EMAIL_REQUIRED
	imdi nickiniz iin bir e-mail adresi belirtmelisiniz.
	Bu e-mail adresi ifrenizi unutmanz halinde ifrenizi
	isterken kullanlacaktr.
NICK_IDENTIFY_EMAIL_HOWTO
	Mail adresinizi ayarlamak iin /msg %S SET EMAIL e-mailadresiniz 
	yazn. Gizliliiniz korunacaktr; bu mail adresi herhangi nc 
	ahslara verilmeyecektir.

# LOGOUT responses
NICK_ALREADY_IDENTIFIED
	You are already identified.

# UPDATE responses
NICK_UPDATE_SUCCESS
	Status updated (memos, vhost, chmodes, flags).
	
# LOGOUT responses
NICK_LOGOUT_SYNTAX
	LOGOUT
NICK_LOGOUT_SUCCEEDED
	Nickinizin k yapld.
NICK_LOGOUT_X_SUCCEEDED
	%s nickinin k yapld.

# DROP responses
NICK_LOGOUT_SERVICESADMIN
	Can't logout %s because he's a services administrator.

# DROP responses
NICK_DROP_DISABLED
	Nick kayd silinmesi geici olarak devre ddr.
NICK_DROPPED
	Nickinizin kayd silindi (dropped).
NICK_X_DROPPED
	%s nickinin kayd silindi (dropped).

# SET responses
NICK_SET_SYNTAX
	SET zellik parametre
NICK_SET_SERVADMIN_SYNTAX
	SET [nick] zellik parametre
NICK_SET_DISABLED
	NickServ'n SET komutu geici olarak devre ddr.
NICK_SET_UNKNOWN_OPTION
	Varolmayan SET zellii: %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Varolmayan SET zellii: %s, yada nick kaytl deil.

# SET DISPLAY responses
NICK_SET_OPTION_DISABLED
	Option %s cannot be set on this network.

# SET DISPLAY responses
NICK_SET_DISPLAY_INVALID
	Yeni gsterim nick grubunuzdan bir nick olmaldr!
NICK_SET_DISPLAY_CHANGED
	Yeni gsterim %s.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	ifre deitirilemedi.
NICK_SET_PASSWORD_CHANGED
	ifreniz deitirildi.
NICK_SET_PASSWORD_CHANGED_TO
	Nick ifreniz %s olarak deitirildi.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE numara
NICK_SET_LANGUAGE_UNKNOWN
	Varolmayan dil numaras %d.  Dil listesi iin /msg %s HELP SET LANGUAGE yazn.
NICK_SET_LANGUAGE_CHANGED
	Dil Trke olarak deitirildi.

# SET URL responses
NICK_SET_URL_CHANGED
	URL adresi %s olarak deitirildi.
NICK_SET_URL_UNSET
	URL adresi silindi.

# SET EMAIL responses
NICK_SET_EMAIL_CHANGED
	E-mail adresi %s olarak deitirildi.
NICK_SET_EMAIL_UNSET
	E-mail adresi silindi.
NICK_SET_EMAIL_UNSET_IMPOSSIBLE
	E-mail adresini bu networkte silemezsiniz.

# SET ICQ responses
NICK_SET_ICQ_CHANGED
	ICQ numaras %s olarak deitirildi.
NICK_SET_ICQ_UNSET
	ICQ numaras silindi.
NICK_SET_ICQ_INVALID
	%s geerli bir numara deil.
	
# SET GREET responses
NICK_SET_GREET_CHANGED
	Karlama mesaj %s olarak deitirildi.
NICK_SET_GREET_UNSET
	Karlama mesaj silindi.

# SET PROTECT responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	Kill korumas: AKTF.
NICK_SET_KILL_QUICK
	Kill korumas: zaman limitli olarak AKTF.
NICK_SET_KILL_IMMED
	Annda kill korumas: AKTF.
NICK_SET_KILL_IMMED_DISABLED
	HEMEN seenei bu networkte aktif deil.
NICK_SET_KILL_OFF
	Kill korumas: KAPALI.

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	Gvenlik seenei: AKTF.
NICK_SET_SECURE_OFF
	Gvenlik seenei: KAPALI.

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	zel seenei: AKTF.
NICK_SET_PRIVATE_OFF
	zel seenei: KAPALI.

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	Artk %s INFO da e-mail adresiniz gzkmeyecek.
NICK_SET_HIDE_EMAIL_OFF
	Artk %s INFO da e-mail adresiniz gzkecek.
NICK_SET_HIDE_MASK_ON
	Artk son grndnz user@host masknz %s INFO da gzkmeyecek.
NICK_SET_HIDE_MASK_OFF
	Artk son grndnz user@host masknz %s INFO da gzkecek.
NICK_SET_HIDE_QUIT_ON
	Artk son k mesajnz(/quit) %s INFO da gzkmeyecek.
NICK_SET_HIDE_QUIT_OFF
	Artk son k mesajnz(/quit) %s INFO da gzkecek.

# SET NOEXPIRE responses
NICK_SET_MSG_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_MSG_ON
	Services will now reply to you with messages.
NICK_SET_MSG_OFF
	Services will now reply to you with notices.

# SET NOEXPIRE responses
NICK_SET_NOEXPIRE_SYNTAX
	SET [nick] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	%s nicki zaman amndan karld.
NICK_SET_NOEXPIRE_OFF
	%s nicki zaman amna eklendi.

# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [mask]
NICK_ACCESS_ALREADY_PRESENT
	%s access listenizde zaten var.
NICK_ACCESS_REACHED_LIMIT
	Bir nick iin sadece %d tane access girilebilir.
NICK_ACCESS_ADDED
	%s access listenize eklendi.
NICK_ACCESS_NOT_FOUND
	%s access listenizde bulunamad.
NICK_ACCESS_DELETED
	%s access listenizden silindi.
NICK_ACCESS_LIST
	Access listesi:
NICK_ACCESS_LIST_X
	%s nickinin access listesi:

# INFO responses
NICK_INFO_SYNTAX
	INFO nick [ALL]
NICK_INFO_REALNAME
	   %s                isim: %s
NICK_INFO_SERVICES_OPER
	      %s servis operatrdr.
NICK_INFO_SERVICES_ADMIN
	      %s servis adminidir.
NICK_INFO_ADDRESS
	      Son grld adres: %s
NICK_INFO_ADDRESS_ONLINE
	      Baland adres: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	      %s u an bal.
NICK_INFO_TIME_REGGED
	          Kayt zaman: %s
NICK_INFO_LAST_SEEN
	   Son grld tarih: %s
NICK_INFO_LAST_QUIT
	      Son k mesaj: %s
NICK_INFO_URL
	                   URL: %s
NICK_INFO_EMAIL
	         E-mail adresi: %s
NICK_INFO_VHOST
	                 vhost: %s
NICK_INFO_ICQ
	                 ICQ #: %d
NICK_INFO_GREET
	      Karlama mesaj: %s
NICK_INFO_OPTIONS
	            zellikler: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Kill korumas
NICK_INFO_OPT_SECURE
	Gvenlik
NICK_INFO_OPT_PRIVATE
	zel
NICK_INFO_OPT_MSG
	Message mode
NICK_INFO_OPT_NONE
	YOK
NICK_INFO_NO_EXPIRE
	Bu nick zaman amna uramayacak.
NICK_INFO_FOR_MORE
	Geni bilgi iin, /msg %s INFO %s ALL yazn.

# LIST responses
NICK_LIST_SYNTAX
	LIST model
NICK_LIST_SERVADMIN_SYNTAX
	LIST model [FORBIDDEN] [NOEXPIRE]
NICK_LIST_HEADER
	%s ieren kaytlarn listesi:
NICK_LIST_RESULTS
	Liste sonu - %d/%d .

# GLIST responses
NICK_ALIST_SYNTAX
	ALIST nickname
NICK_ALIST_HEADER
	Channels that you have access on:
	  Num  Channel              Level    Description 
NICK_ALIST_HEADER_X
	Channels that %s has access on:
	  Num  Channel              Level    Description 
NICK_ALIST_XOP_FORMAT
	  %3d %c%-20s %-8s %s
NICK_ALIST_ACCESS_FORMAT
	  %3d %c%-20s %-8d %s
NICK_ALIST_FOOTER
	Liste sonu - %d/%d .

# GLIST responses
NICK_GLIST_HEADER
	Grubunuzdaki nicklerin listesi:
NICK_GLIST_HEADER_X
	%s grubundaki nicklerin listesi:
NICK_GLIST_FOOTER
	Grupta %d nick var.

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER nick [ifre]
NICK_NO_RECOVER_SELF
	Kendizi recover edemezsiniz!
NICK_RECOVERED
	Nickinizi kullanan user kill lendi.
	/msg %s RELEASE %s yazarak bir dakikadan nce nickinizi serbest brakabilirsiniz.

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE nick [ifre]
NICK_RELEASE_NOT_HELD
	%s nicki zaten serbest.
NICK_RELEASED
	Nickiniz serbest brakld.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST nick [ifre]
NICK_NO_GHOST_SELF
	Kendinizi ghost edemezsiniz!
NICK_GHOST_KILLED
	Asl kalan nickiniz kill lendi.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS nick
NICK_GETPASS_UNAVAILABLE
	GETPASS komutu devre d nk ifreleme(encryption) devrede.
NICK_GETPASS_PASSWORD_IS
	%s nickinin ifresi %s.
	
# SENDPASS responses
NICK_GETEMAIL_SYNTAX
	GETEMAIL user@email-host No WildCards!!
NICK_GETEMAIL_EMAILS_ARE
	Emails Match %s to %s.
NICK_GETEMAIL_NOT_USED
	No Emails listed for %s.
	
# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS nick
NICK_SENDPASS_UNAVAILABLE
	SENDPASS komutu devre d nk ifreleme(encryption) devrede.
NICK_SENDPASS_SUBJECT
	Nick ifresi (%s)
NICK_SENDPASS_HEAD
	Selam,
NICK_SENDPASS_LINE_1
	%s nickinizin ifresinin e-mail adresinize yollanmasn istemisiniz.
NICK_SENDPASS_LINE_2
	Nickinizin ifresi %s. Gvenlik nedenlerinden dolay, bu maili aldktan sonra deitirseniz iyi olur.
NICK_SENDPASS_LINE_3
	Eer bu mailin neden size gnderildiini bilmiyorsanz, maili ciddiye almayn.
NICK_SENDPASS_LINE_4
	LTFEN BU MALE CEVAP VERMEYN!
NICK_SENDPASS_LINE_5
	%s ynetimi.
NICK_SENDPASS_OK
	%s nickinin ifresi gnderildi.

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID nick [sebep]
NICK_FORBID_SYNTAX_REASON
	FORBID nick sebep
NICK_FORBID_SUCCEEDED
	%s nickinin Kullanm yasakland.
NICK_FORBID_FAILED
	%s nickinin Kullanm yasaklanamad!

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
NICK_REQUESTED
	This nick has already been requested, please check your e-mail address for the pass code
NICK_REG_RESENT
	Your passcode has been re-sent to %s.
NICK_REG_UNABLE
	Nick NOT registered, please try again later.
NICK_IS_PREREG
	This nick is awaiting an e-mail verification code before completing registration.
NICK_ENTER_REG_CODE
	A passcode has been sent to %s, please type /msg %s confirm <passcode> to complete registration
NICK_CONFIRM_NOT_FOUND
	Registration step 1 may have expired, please use "/msg %s register <password> <email>" first.
NICK_CONFIRM_INVALID
	Invalid passcode has been entered, please check the e-mail again, and retry
NICK_REG_MAIL_SUBJECT
	Nickname Registration (%s)
NICK_REG_MAIL_HEAD
	Hi,
NICK_REG_MAIL_LINE_1
	You have requested to register the following nickname %s.
NICK_REG_MAIL_LINE_2
	Please type " /msg %s confirm %s " to complete registration.
NICK_REG_MAIL_LINE_3
	If you don't know why this mail is sent to you, please ignore it silently.
NICK_REG_MAIL_LINE_4
	PLEASE DON'T ANSWER TO THIS MAIL!
NICK_REG_MAIL_LINE_5
	%s administrators.
NICK_GETPASS_PASSCODE_IS
	Passcode for %s is %s.
NICK_FORCE_REG
	Nickname %s confirmed

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Kanala girite ChanServ tarafndan otomatik op (+o)
CHAN_LEVEL_AUTOVOICE
	Kanala girite ChanServ tarafndan otomatik voice (+v)
CHAN_LEVEL_AUTOHALFOP
	Kanala girite ChanServ tarafndan otomatik yarm op (+h)
CHAN_LEVEL_AUTOPROTECT
	Kanala girite ChanServ tarafndan otomatik koruma (+a)
CHAN_LEVEL_AUTODEOP
	Kanal iinde op olmasn yasaklar.
CHAN_LEVEL_NOJOIN
	RESTRICTED zelliinin aktif olmas halinde kanala giremez.
CHAN_LEVEL_INVITE
	INVITE komutunu kullanmaya izinlidir.
CHAN_LEVEL_AKICK
	AKICK komutunu kullanmaya izinlidir.
CHAN_LEVEL_SET
	SET komutunu (FOUNDER/PASSWORD hari) kullanmaya izinlidir.
CHAN_LEVEL_CLEAR
	CLEAR komutunu kullanmaya izinlidir.
CHAN_LEVEL_UNBAN
	UNBAN komutunu kullanmaya izinlidir.
CHAN_LEVEL_OPDEOP
	OP/DEOP komutlarn kullanmaya izinlidir.
CHAN_LEVEL_ACCESS_LIST
	Kanaln Access listesini grntlemeye izinlidir.
CHAN_LEVEL_ACCESS_CHANGE
	Kanaln Access listesinde deiiklik yapmaya izinlidir.
CHAN_LEVEL_MEMO
	Kanala gelen mesajlari listelemeye/okumaya izinlidir.
CHAN_LEVEL_ASSIGN
	Botun assign/unassign komutlarn kullanmaya izinlidir.
CHAN_LEVEL_BADWORDS
	BADWORDS komutunu kullanmaya izinlidir.
CHAN_LEVEL_NOKICK
	Bot tarafndan kicklenmemeyi salar.
CHAN_LEVEL_FANTASIA
	Kanalda fantazi komutlarn kullanmaya izinlidir. 
CHAN_LEVEL_SAY
	SAY ve ACT komutlarn kullanmaya izinlidir.
CHAN_LEVEL_GREET
	Karlama mesaj alabilir.
CHAN_LEVEL_VOICEME
	Kendini (de)voice etmeye izinlidir.
CHAN_LEVEL_VOICE
	VOICE/DEVOICE komutlarn kullanmaya izinlidir.
CHAN_LEVEL_GETKEY
	GETKEY komutunu kullanmaya izinlidir.
CHAN_LEVEL_OPDEOPME
	Kendini (de)op etmeye izinlidir.
CHAN_LEVEL_HALFOPME
	Kendini (de)halfop etmeye izinlidir.
CHAN_LEVEL_HALFOP
	HALFOP/DEHALFOP komutlarn kullanmaya izinlidir.
CHAN_LEVEL_PROTECTME
	Kendini (de)protect etmeye izinlidir.
CHAN_LEVEL_PROTECT
	PROTECT/DEPROTECT komutlarn kullanmaya izinlidir.
CHAN_LEVEL_KICKME
	Kendini atmaya izinlidir.
CHAN_LEVEL_KICK
	KICK komutunu kullanmaya izinlidir.
CHAN_LEVEL_SIGNKICK
	SIGNKICK LEVEL kullanldnda iaretli atma yaplmaz.
CHAN_LEVEL_BANME
	Kendini banlamaya yetkili
CHAN_LEVEL_BAN
	BAN komutunu kullanmaya yetkili
CHAN_LEVEL_TOPIC
	TOPIC komutunu kullanmaya yetkili
CHAN_LEVEL_INFO
	INFO komutunu ALL seenegiyle kullanmaya yetkili

# Automatic responses
CHAN_IS_REGISTERED
	Bu kanal %s ile kaytldr.
CHAN_NOT_ALLOWED_OP
	%s kanalnda op olmaya yetkiniz yok.
CHAN_MAY_NOT_BE_USED
	Bu kanal kullanlamaz.
CHAN_NOT_ALLOWED_TO_JOIN
	Bu kanalda bulunmanza msaade yok.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER kanalad ifre aklama
CHAN_REGISTER_DISABLED
	Kanal kayd geici olarak devre ddr.
CHAN_REGISTER_NOT_LOCAL
	Local kanallar kayt edilemezler.
CHAN_MUST_REGISTER_NICK
	nce nickinizi kayt etmeniz gerekiyor.  Nick kayt hakknda bilgi iin /msg %s HELP yaznz.
CHAN_MUST_IDENTIFY_NICK
	Ltfen nce %s ile bu komutu kullanarak nickinizi tantn:
	/msg %s IDENTIFY ifreniz
CHAN_MAY_NOT_BE_REGISTERED
	%s kanal kayt edilemez.
CHAN_ALREADY_REGISTERED
	%s kanal zaten kaytl!
CHAN_MUST_BE_CHANOP
	Kanal kayt edebilmeniz iin kayt edilmemi bir kanala ilk girip op olmanz gerekmektedir.
CHAN_REACHED_CHANNEL_LIMIT
	%d kanallk limitinizi doldurdunuz.
CHAN_EXCEEDED_CHANNEL_LIMIT
	%d kanallk limitinizi atnz.
CHAN_REGISTRATION_FAILED
	Kanal kayd baarsz.
CHAN_REGISTERED
	%s kanal bu nicke kayt edildi: %s
CHAN_PASSWORD_IS
	Kanal ifreniz %s - ilerde kullanacanz iin unutmaynz ve kimseye sylemeyiniz.

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY kanalad ifreniz
CHAN_IDENTIFY_FAILED
	Geersiz ifre.
CHAN_IDENTIFY_SUCCEEDED
	ifre kabul edildi - %s kanalnda founder seviyesinde eriim kazandnz.

# LOGOUT responses
CHAN_LOGOUT_SYNTAX
	LOGOUT kanalad nick
CHAN_LOGOUT_SERVADMIN_SYNTAX
	LOGOUT kanalad [nick]
CHAN_LOGOUT_SUCCEEDED
	Kullanc %s artk %s kanal tarafndan tannmyor.
CHAN_LOGOUT_ALL_SUCCEEDED
	Tm tanml kullanclar artk %s kanal tarafndan tannmyor.

# DROP responses
CHAN_DROP_SYNTAX
	DROP kanalad
CHAN_DROP_DISABLED
	Kanal kaydnn silinmesi(DROP) geici olarak devre ddr.
CHAN_DROPPED
	%s kanalnn kayd silinmitir (dropped).

# SET responses
CHAN_SET_SYNTAX
	SET kanalad zellik parametre
CHAN_SET_DISABLED
	Chanserv'n SET komutu geici olarak devre ddr.
CHAN_SET_UNKNOWN_OPTION
	Varolmayan SET zellii: %s.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s ok fazla kanala sahip.
CHAN_FOUNDER_CHANGED
	%s kanalnn founder %s olarak deitirildi.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	%s iin successor %s olarak deitirildi.
CHAN_SUCCESSOR_UNSET
	%s iin successor kaldrld.
CHAN_SUCCESSOR_IS_FOUNDER
	%s %s kanalnda successor olamaz nk zaten o kanaln founder.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	ifre deiimi baarsz.
CHAN_PASSWORD_CHANGED
	%s kanalnn ifresi deitirildi.
CHAN_PASSWORD_CHANGED_TO
	%s kanalnn ifresi %s olarak deitirildi.

# SET DESC responses
CHAN_DESC_CHANGED
	%s kanalnn aklamas %s olarak deitirildi.

# SET URL responses
CHAN_URL_CHANGED
	%s kanalnn URL adresi %s olarak deitirildi.
CHAN_URL_UNSET
	%s kanalnn URL adresi kaldrld.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	%s kanalnn e-mail adresi %s olarak deitirildi.
CHAN_EMAIL_UNSET
	%s kanalnn e-mail adresi kaldrld.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	%s kanalnn giri mesaj deitirildi.
CHAN_ENTRY_MSG_UNSET
	%s kanalnn giri mesaj kaldrld.
	
# SET BANTYPE responses
CHAN_SET_BANTYPE_INVALID
	%s geerli bir ban tipi deil.
CHAN_SET_BANTYPE_CHANGED
	%s kanalnn ban tipi #%d olarak deitirildi.

# SET MLOCK responses
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Varolmayan mod karakteri %c yoksayld.
CHAN_SET_MLOCK_IMPOSSIBLE_CHAR
	%c modunu kitleyemezsiniz, yoksayildi.
CHAN_SET_MLOCK_L_REQUIRED
	+L modunu kullanabilmek iin +l modunuda kullanmalisiniz.
CHAN_SET_MLOCK_K_REQUIRED
	+K modunu kullanabilmek iin +i modunuda kullanmalisiniz.
CHAN_MLOCK_CHANGED
	%s kanalnn mod kilidi %s olarak deitirildi.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET kanalad KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Topic hatrlama zellii AKTF.
CHAN_SET_KEEPTOPIC_OFF
	Topic hatrlama zellii KAPALI.

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET kanalad TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Topic kilidi AKTF.
CHAN_SET_TOPICLOCK_OFF
	Topic kilidi KAPALI.

# SET PEACE responses
CHAN_SET_PEACE_SYNTAX
	SET kanaladi PEACE {ON | OFF}
CHAN_SET_PEACE_ON
	Baris zelligi AKTIF.
CHAN_SET_PEACE_OFF
	Baris zelligi KAPALI.

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET kanalad PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	zel zellii AKTF.
CHAN_SET_PRIVATE_OFF
	zel zellii KAPALI.

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET kanalad SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Secure ops zellii AKTF.
CHAN_SET_SECUREOPS_OFF
	Secure ops zellii KAPALI.
	
# SET SECUREFOUNDER responses
CHAN_SET_SECUREFOUNDER_SYNTAX
	SET kanalad SECUREFOUNDER {ON | OFF}
CHAN_SET_SECUREFOUNDER_ON
	Secure founder zellii AKTF.
CHAN_SET_SECUREFOUNDER_OFF
	Secure founder zellii KAPALI.

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET kanalad RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Restricted access zellii AKTF.
CHAN_SET_RESTRICTED_OFF
	Restricted access zellii KAPALI.

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET kanal SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	Gvenlik zellii AKTF.
CHAN_SET_SECURE_OFF
	Gvenlik zellii KAPALI.

# SET SIGNKICK responses
CHAN_SET_SIGNKICK_SYNTAX
	SET kanalad SIGNKICK {ON | LEVEL | OFF}
CHAN_SET_SIGNKICK_ON
	aretli atma zellii AKTF.
CHAN_SET_SIGNKICK_LEVEL
	aretli atma zellii AKTF, fakat komutu kullanan
	kullancnn seviyesine bal.
CHAN_SET_SIGNKICK_OFF
	aretli atma zellii KAPALI.

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET kanalad OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Oplara-not zellii AKTF.
CHAN_SET_OPNOTICE_OFF
	Oplara-not zellii KAPALI.

# SET XOP responses
CHAN_SET_XOP_SYNTAX
	SET kanaladi XOP {ON | OFF}
CHAN_SET_XOP_ON
	xOP sistemi AKTIF.
CHAN_SET_XOP_OFF
	xOP sistemi KAPALI.

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET kanalad NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	%s kanal zaman amndan karld.
CHAN_SET_NOEXPIRE_OFF
	%s kanal zaman amna eklendi.

# xOP messages
CHAN_XOP_REACHED_LIMIT
	Bir kanala toplam %d AOP/SOP/VOP kayit edilebilir.
CHAN_XOP_LIST_FORMAT
	  %3d  %s
CHAN_XOP_ACCESS
	Bu komutu kullanamazsiniz. Yerine ACCESS komutunu kullanin.
	Daha fazla bilgi iin /msg %s HELP ACCESS yazin.

# AOP messages
CHAN_AOP_SYNTAX
	AOP kanal {ADD|DEL|LIST|CLEAR} [nick | liste-no]
CHAN_AOP_DISABLED
	Kanal AOP listesi degisiklikleri geici olarak devre disidir.
CHAN_AOP_NICKS_ONLY
	Kanal AOP listeleri sadece kayitli nicklerden olusabilir.
CHAN_AOP_ADDED
	%s %s kanalinin AOP listesine eklenmistir.
CHAN_AOP_MOVED
	%s moved to %s AOP list.
CHAN_AOP_NO_SUCH_ENTRY
	(#%d) %s kanalinin AOP listesinde byle bir kayit bulunamadi.
CHAN_AOP_NOT_FOUND
	%s %s kanali AOP listesinde bulunamadi.
CHAN_AOP_NO_MATCH
	%s kanali AOP listesinde uyusan kayit bulunamadi.
CHAN_AOP_DELETED
	%s %s kanali AOP listesinden silindi.
CHAN_AOP_DELETED_ONE
	%s kanalinin AOP listesinden 1 kayit silindi.
CHAN_AOP_DELETED_SEVERAL
	Deleted %d entries from %s AOP list.
CHAN_AOP_LIST_EMPTY
	%s kanalinin AOP listesi bos.
CHAN_AOP_LIST_HEADER
	%s kanali AOP listesi:
	  Num  Nick
CHAN_AOP_CLEAR
	Kanalin AOP listesi temizlendi.

# HOP messages
CHAN_HOP_SYNTAX
	HOP kanaladi {ADD|DEL|LIST|CLEAR} [nick | liste-no]
CHAN_HOP_DISABLED
	Kanal HOP listesi degisiklikleri geici olarak devre disidir.
CHAN_HOP_NICKS_ONLY
	Kanal HOP listeleri sadece kayitli nicklerden olusabilir.
CHAN_HOP_ADDED
	%s %s kanali HOP listesine eklendi.
CHAN_HOP_MOVED
	%s moved to %s HOP list.
CHAN_HOP_NO_SUCH_ENTRY
	(#%d) %s kanali HOP listesinde uyusan kayit bulunamadi.
CHAN_HOP_NOT_FOUND
	%s %s kanali HOP listesinde bulunamadi.
CHAN_HOP_NO_MATCH
	%s kanali HOP listesinde uyusan kayit bulunamadi.
CHAN_HOP_DELETED
	%s %s kanali HOP listesinden silindi.
CHAN_HOP_DELETED_ONE
	%s kanali HOP listesinden 1 kayit silindi.
CHAN_HOP_DELETED_SEVERAL
	Deleted %d entries from %s HOP list.
CHAN_HOP_LIST_EMPTY
	%s kanali HOP listesi bos.
CHAN_HOP_LIST_HEADER
	%s kanali HOP listesi:
	  Num  Nick
CHAN_HOP_CLEAR
	Kanal HOP listesi temizlendi.

# SOP messages
CHAN_SOP_SYNTAX
	SOP kanaladi {ADD|DEL|LIST|CLEAR} [nick | liste-no]
CHAN_SOP_DISABLED
	Kanal SOP listesi degisikligi geici olarak devre disidir.
CHAN_SOP_NICKS_ONLY
	Kanal SOP listesi sadece kayitli nicklerden olusabilir.
CHAN_SOP_ADDED
	%s %s kanali SOP listesine eklendi.
CHAN_SOP_MOVED
	%s moved to %s SOP list.
CHAN_SOP_NO_SUCH_ENTRY
	(#%d) %s kanali SOP listesinde uyusan kayit bulunamadi.
CHAN_SOP_NOT_FOUND
	%s %s kanali SOP listesinde bulunamadi.
CHAN_SOP_NO_MATCH
	%s kanali SOP listesinde uyusan kayit bulunamadi.
CHAN_SOP_DELETED
	%s %s kanali SOP listesinden silindi.
CHAN_SOP_DELETED_ONE
	%s kanali SOP listesinden 1 kayit silindi.
CHAN_SOP_DELETED_SEVERAL
	Deleted %d entries from %s SOP list.
CHAN_SOP_LIST_EMPTY
	%s kanali SOP listesi bos.
CHAN_SOP_LIST_HEADER
	%s kanali SOP listesi:
	  Num  Nick
CHAN_SOP_CLEAR
	Kanal SOP listesi temizlendi.

# VOP messages
CHAN_VOP_SYNTAX
	VOP kanaladi {ADD|DEL|LIST|CLEAR} [nick | liste-no]
CHAN_VOP_DISABLED
	Kanal VOP listesi degisikligi geici olarak devre disidir.
CHAN_VOP_NICKS_ONLY
	Kanal VOP listeleri sadece kayitli nicklerden olusabilir.
CHAN_VOP_ADDED
	%s %s kanali VOP listesine eklendi.
CHAN_VOP_MOVED
	%s moved to %s VOP list.
CHAN_VOP_NO_SUCH_ENTRY
	(#%d) %s kanali VOP listesinde uyusan kayit bulunamadi.
CHAN_VOP_NOT_FOUND
	%s %s kanali VOP listesinde bulunamadi.
CHAN_VOP_NO_MATCH
	%s kanali VOP listesinde uyusan kayit bulunamadi.
CHAN_VOP_DELETED
	%s %s kanali VOP listesinden silindi.
CHAN_VOP_DELETED_ONE
	%s kanali VOP listesinden 1 kayit silindi.
CHAN_VOP_DELETED_SEVERAL
	Silindi %d VOP listesinden kayit %s kanali.
CHAN_VOP_LIST_EMPTY
	%s kanali VOP listesi bos.
CHAN_VOP_LIST_HEADER
	%s kanali VOP listesi:
	  Num  Nick
CHAN_VOP_CLEAR
	Kanal VOP listesi temizlendi.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS kanalad {ADD|DEL|LIST|CLEAR} [nick [seviye] | kayt-listesi]
CHAN_ACCESS_XOP
	Bu komutu kullanamazsiniz. 
	Yerine AOP, SOP veya VOP komutlarini kullanin.
	Daha fazla bilgi iin /msg %s HELP komut yazin.
CHAN_ACCESS_DISABLED
	Kanal access listesinin deitirilmesi geici olarak devre ddr.
CHAN_ACCESS_LEVEL_NONZERO
	Access seviyesi sfrdan farkl bir say olmaldr.
CHAN_ACCESS_LEVEL_RANGE
	Access seviyesi %d ve %d arasnda olmaldr.
CHAN_ACCESS_NICKS_ONLY
	Kanal access listesi sadece kaytl kullanclar iermelidir.
CHAN_ACCESS_REACHED_LIMIT
	Kanalda sadece %d tane access kayd olabilir.
CHAN_ACCESS_LEVEL_UNCHANGED
	%s nickinin access seviyesi %s kanalnda zaten %d.
CHAN_ACCESS_LEVEL_CHANGED
	%s nickinin access seviyesi %s kanalnda %d olarak deitirildi.
CHAN_ACCESS_ADDED
	%s nicki %s kanalinin access listesine %d seviyeden eklendi.
CHAN_ACCESS_NO_SUCH_ENTRY
	(#%d) eklinde bir kayt %s kanalnn access listesinde bulunamad.
CHAN_ACCESS_NOT_FOUND
	%s %s kanalnn access listesinde bulunamad.
CHAN_ACCESS_NO_MATCH
	Uyuan kayt %s kanalnn access listesinde yok.
CHAN_ACCESS_DELETED
	%s %s kanalnn access listesinden silindi.
CHAN_ACCESS_DELETED_ONE
	%s kanalnn access listesinden 1 kayt silindi.
CHAN_ACCESS_DELETED_SEVERAL
	Deleted %d entries from %s access list.
CHAN_ACCESS_LIST_EMPTY
	%s kanalnn access listesi bo.
CHAN_ACCESS_LIST_HEADER
	%s kanal iin access listesi:
	  Sra   Seviye  Nick
CHAN_ACCESS_LIST_FOOTER
	access listenin sonu.
CHAN_ACCESS_LIST_XOP_FORMAT
	  %3d   %s  %s
CHAN_ACCESS_LIST_AXS_FORMAT
	  %3d  %4d  %s
CHAN_ACCESS_CLEAR
	Kanal access listesi temizlendi.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK kanalad {ADD | STICK | UNSTICK | DEL | LIST | VIEW | ENFORCE | CLEAR} [nick-veya-usermask] [sebep]
CHAN_AKICK_DISABLED
	Kanal Akick listesinin deitirilmesi geici olarak devre ddr.
CHAN_AKICK_ALREADY_EXISTS
	%s nicki %s kanalnn akick listesinde zaten var.
CHAN_AKICK_REACHED_LIMIT
	Bir kanaln akick listesinde en fazla %d kii olabilir.
CHAN_AKICK_ADDED
	%s nicki %s kanalnn akick listesine eklendi.
CHAN_AKICK_NO_SUCH_ENTRY
	(#%d) eklinde bir kayt %s kanalnn akick listesinde bulunamad.
CHAN_AKICK_NOT_FOUND
	%s %s kanalnn akick listesinde bulunamad.
CHAN_AKICK_NO_MATCH
	Uyuan kayt %s kanalnn akick listesinde bulunamad.
CHAN_AKICK_STUCK
	%s artik %s kanalinda srekli aktif.
CHAN_AKICK_UNSTUCK
	%s artik %s kanalinda srekli aktif degil.
CHAN_AKICK_DELETED
	%s %s kanalnn akick listesinden silindi.
CHAN_AKICK_DELETED_ONE
	%s kanalnn akick listesinden 1 kayt silindi.
CHAN_AKICK_DELETED_SEVERAL
	Deleted %d entries from %s autokick list.
CHAN_AKICK_LIST_EMPTY
	%s kanalnn akick listesi bo.
CHAN_AKICK_LIST_HEADER
	%s kanalnn akick listesi:
CHAN_AKICK_LIST_FORMAT
	  %3d %s (%s)
CHAN_AKICK_VIEW_FORMAT
	%3d %s (by %s on %s)
	    %s
CHAN_AKICK_VIEW_FORMAT_STUCK
	%3d %s (kalici) (by %s on %s)
	    %s
CHAN_AKICK_ENFORCE_DONE
	 %s iin AKICK uygulamas tamam; %d kullanc iin geerli.
CHAN_AKICK_CLEAR
	Kanal akick listesi temizlendi.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS kanalad {SET | DIS[ABLE] | LIST | RESET} [madde [seviye]]
CHAN_LEVELS_XOP
	Bu modda bu komut kullanilmaz.
CHAN_LEVELS_RANGE
	Level %d ile %d arasnda olmaldr.
CHAN_LEVELS_CHANGED
	%s iin level %s kanalnda %d olarak deitirildi.
CHAN_LEVELS_UNKNOWN
	Varolmayan ayar: %s. Geerli ayar listesi iin /msg %s HELP LEVELS DESC yaznz.
CHAN_LEVELS_DISABLED
	%s %s kanalnda iptal edildi.
CHAN_LEVELS_LIST_HEADER
	%s kanal iin access level ayarlar:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (kapatld)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (sadece founder)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %d
CHAN_LEVELS_RESET
	%s iin access levelleri varsaylanlarla deitirildi.

# INFO responses
CHAN_INFO_SYNTAX
	INFO kanalad [ALL]
CHAN_INFO_HEADER
	%s kanal iin bilgi:
CHAN_INFO_FOUNDER
	        Founder: %s (%s)
CHAN_INFO_NO_FOUNDER
	        Founder: %s
CHAN_INFO_SUCCESSOR
	      Successor: %s (%s)
CHAN_INFO_NO_SUCCESSOR
	      Successor: %s
CHAN_INFO_DESCRIPTION
	       Aklama: %s
CHAN_INFO_ENTRYMSG
	   Giri mesaj: %s
CHAN_INFO_TIME_REGGED
	   Kayt tarihi: %s
CHAN_INFO_LAST_USED
	 Son kullanl: %s
CHAN_INFO_LAST_TOPIC
	      Son topic: %s
CHAN_INFO_TOPIC_SET_BY
	   Topici yazan: %s
CHAN_INFO_URL
	            URL: %s
CHAN_INFO_EMAIL
	  E-mail adresi: %s
CHAN_INFO_BANTYPE
	       Ban tipi: %d
CHAN_INFO_OPTIONS
	     zellikler: %s
CHAN_INFO_OPT_KEEPTOPIC
	Topic hatrlama
CHAN_INFO_OPT_OPNOTICE
	OP Notu
CHAN_INFO_OPT_PEACE
	Baris
CHAN_INFO_OPT_PRIVATE
	zel
CHAN_INFO_OPT_RESTRICTED
	Kisitli Erisim.
CHAN_INFO_OPT_SECURE
	Gvenlik
CHAN_INFO_OPT_SECUREOPS
	Secure Ops
CHAN_INFO_OPT_SECUREFOUNDER
	Secure Founder
CHAN_INFO_OPT_SIGNKICK
	aretli atma
CHAN_INFO_OPT_TOPICLOCK
	Topic kilidi
CHAN_INFO_OPT_XOP
	xOP sistemi
CHAN_INFO_OPT_NONE
	YOK
CHAN_INFO_MODE_LOCK
	     Mod kilidi: %s
CHAN_INFO_NO_EXPIRE
	Bu kanal iin zaman am sz konusu deil.

# LIST responses
CHAN_LIST_SYNTAX
	LIST model
CHAN_LIST_SERVADMIN_SYNTAX
	LIST model [FORBIDDEN] [NOEXPIRE]
CHAN_LIST_HEADER
	%s ile uyuan kayt listesi:
CHAN_LIST_FORMAT
	    %-20s  %s
CHAN_LIST_END
	Liste sonu - %d/%d uyan kayt bulundu.

# CLIST responses
CHAN_INVITE_SYNTAX
	INVITE kanalad

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN kanalad
CHAN_UNBANNED
	%s kanalndaki bannz kaldrld.

# TOPIC responses
CHAN_TOPIC_SYNTAX
	TOPIC kanaladi [konu]

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR kanalad neyi
CHAN_CLEARED_BANS
	%s kanalndaki tm banlar kaldrld.
CHAN_CLEARED_EXCEPTS
	All excepts on channel %s have been removed.
CHAN_CLEARED_MODES
	%s kanalndaki tm modlar resetlendi.
CHAN_CLEARED_OPS
	Mod +o %s kanalnda temizlendi.
CHAN_CLEARED_VOICES
	Mod +v %s kanalnda temizlendi.
CHAN_CLEARED_USERS
	%s kanalndaki tm kullanclar atld.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS kanalad
CHAN_GETPASS_UNAVAILABLE
	GETPASS komutu devre d nk ifreleme(encryption) devrede.
CHAN_GETPASS_PASSWORD_IS
	%s kanalnn ifresi %s.
	
# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS kanalad
CHAN_SENDPASS_UNAVAILABLE
	SENDPASS komutu devre d nk ifreleme(encryption) devrede.
CHAN_SENDPASS_SUBJECT
	Kanal ifresi (%s)
CHAN_SENDPASS_HEAD
	Selam,
CHAN_SENDPASS_LINE_1
	%s kanalnzn ifresinin e-mail adresinize gnderilmesini istemisiniz.
CHAN_SENDPASS_LINE_2
	Kanal ifresi %s. Gvenlik nedenlerinden dolay, ifrenizi bu maili aldktan sonra deitirirseniz iyi olur.
CHAN_SENDPASS_LINE_3
	Eer bu mailin niye size gnderildiini bilmiyorsanz, ltfen ciddiye almayn.
CHAN_SENDPASS_LINE_4
	LTFEN BU MALE CEVAP VERMEYN!
CHAN_SENDPASS_LINE_5
	%s ynetimi.
CHAN_SENDPASS_OK
	%s kanalnn ifresi gnderildi.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID kanalad [sebep]
CHAN_FORBID_SYNTAX_REASON
	FORBID kanalad sebep
CHAN_FORBID_SUCCEEDED
	%s kanalnn Kullanm yasakland.
CHAN_FORBID_FAILED
	%s kanalnn Kullanm yasaklanamad!

# Misc responses
CHAN_FORBID_REASON
	This channel has been forbidden.

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND channel [reason]
CHAN_SUSPEND_SYNTAX_REASON
	SUSPEND channel reason
CHAN_SUSPEND_SUCCEEDED
	Channel %s is now suspended.
CHAN_SUSPEND_FAILED
	Couldn't suspended channel %s!
CHAN_SUSPEND_REASON
	This channel has been suspended.

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND channel
CHAN_UNSUSPEND_ERROR
	No # found in front of channel name.
CHAN_UNSUSPEND_SUCCEEDED
	Channel %s is now released.
CHAN_UNSUSPEND_FAILED
	Couldn't release channel %s!

# Misc responses
CHAN_EXCEPTED
	%s matches an except on %s and cannot be banned until the except have been removed.

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	1 yeni mesajnz var.
MEMO_HAVE_NEW_MEMOS
	%d yeni mesajnz var.
MEMO_TYPE_READ_LAST
	Okumak iin /msg %s READ LAST yazn.
MEMO_TYPE_READ_NUM
	Okumak iin /msg %s READ %d yazn.
MEMO_TYPE_LIST_NEW
	Listelemek iin /msg %s LIST NEW yazn.
MEMO_AT_LIMIT
	Dikkat: Maksimum mesaj saynza ulatnz (%d).  imdiki mesajlarnzdan bir kan silmezseniz yeni mesaj alamayacaksnz.
MEMO_OVER_LIMIT
	Dikkat: Maksimum mesaj saynz atnz (%d).  imdiki mesajlarnzdan bir kan silmezseniz yeni mesaj alamayacaksnz.
MEMO_X_MANY_NOTICE
	There are %d memos on channel %s.
MEMO_X_ONE_NOTICE
	There is %d memo on channel %s.
MEMO_NEW_X_MEMO_ARRIVED
	There is a new memo on channel %s.
	Type /msg %s READ %s %d to read it.
MEMO_NEW_MEMO_ARRIVED
	%s nickinden yeni mesajnz var.
	Okumak iin /msg %s READ %d yazn.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	Hi mesajnz yok.
MEMO_X_HAS_NO_MEMOS
	%s nickinin hi mesaj yok.
MEMO_DOES_NOT_EXIST
	%d numaral mesaj bulunamad!
MEMO_LIST_NOT_FOUND
	Uyuan mesaj bulunamad.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {nick | kanalad} mesaj
MEMO_SEND_DISABLED
	Mesaj yollama geici olarak devre ddr.
MEMO_SEND_PLEASE_WAIT
	Ltfen %d saniye SEND komutunu tekrar kullanmak iin bekleyin.
MEMO_X_GETS_NO_MEMOS
	%s nicki mesaj alamaz.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s nickinin limiti dolduundan daha fazla mesaj alamaz.
MEMO_SENT
	%s nickine mesajnz gnderildi.
	
# CANCEL responses
MEMO_MASS_SENT
	A massmemo has been sent to all registered users.
	
# CANCEL responses
MEMO_CANCEL_SYNTAX
	CANCEL {nick | kanalad}
MEMO_CANCEL_DISABLED
	Mesaj iptal etme geici olarak devre ddr.
MEMO_CANCEL_NONE
	ptal edilecek mesaj yoktu.
MEMO_CANCELLED
	%s nickine gnderilen son mesaj iptal edildi.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [kanalad] [liste | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	Hi yeni mesajnz yok.
MEMO_X_HAS_NO_NEW_MEMOS
	%s nickinin hi yeni mesaj yok.
MEMO_LIST_MEMOS
	%s nicki iin mesajlar.  Okumak iin: /msg %s READ num yazn.
MEMO_LIST_NEW_MEMOS
	%s nicki iin yeni mesajlar.  Okumak iin: /msg %s READ num yazn.
MEMO_LIST_CHAN_MEMOS
	%s kanali iin mesajlar.  Okumak iin: /msg %s READ %s num yazn.
MEMO_LIST_CHAN_NEW_MEMOS
	%s kanali iin yeni mesajlar.  Okumak iin: /msg %s READ %s num yazn.
MEMO_LIST_HEADER
	 Num  Gnderen          Tarih/Zaman
MEMO_LIST_FORMAT
	%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [kanalad] {liste | LAST | NEW}
MEMO_HEADER
	%d nolu mesaj %s nickinden (%s).  Silmek iin: /msg %s DEL %d yazn.
MEMO_CHAN_HEADER
	%d nolu mesaj %s nickinden (%s).  Silmek iin: /msg %s DEL %s %d yazn.
MEMO_TEXT
	%s

# DEL responses
MEMO_DEL_SYNTAX
	DEL [kanalad] {num | liste | ALL}
MEMO_DELETED_NONE
	Hi mesaj silinmedi.
MEMO_DELETED_ONE
	%d nolu mesaj silindi.
MEMO_DELETED_SEVERAL
	%s mesajlar silindi.
MEMO_DELETED_ALL
	Tm mesajlarnz silindi.

# SET responses
MEMO_CHAN_DELETED_ALL
	All memos for channel %s have been deleted.

# SET responses
MEMO_SET_SYNTAX
	SET zellik parametre
MEMO_SET_DISABLED
	MemoServ'n SET komutu geici olarak devre ddr.
MEMO_SET_UNKNOWN_OPTION
	Varolmayan SET zellii: %s.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s sizi yeni mesajlar iin balandnzda veya mesajlar size gnderildii anda uyaracak.
MEMO_SET_NOTIFY_LOGON
	%s sizi yeni mesajlar iin balandnzda veya AWAY modundan dnte uyaracak.
MEMO_SET_NOTIFY_NEW
	%s sizi yeni mesajlar iin size gnderildii anda uyaracak.
MEMO_SET_NOTIFY_OFF
	%s sizi yeni mesajlar iin uyarmayacak.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [kanalad] limit
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [kullanc | kanalad] {limit | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	Mesaj limitinizi belirlemeye izinli deilsiniz.
MEMO_SET_LIMIT_FORBIDDEN
	%s nickinin mesaj limiti deitirelemez.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	Mesaj limitinizi %d saysndan daha fazla yapamazsnz.
MEMO_SET_LIMIT_TOO_HIGH
	%s nickinin mesaj limitini %d saysndan daha fazla yapamazsnz.
MEMO_SET_LIMIT_OVERFLOW
	Mesaj limiti ok fazla; limit %d olarak deitiriliyor.
MEMO_SET_YOUR_LIMIT
	Mesaj limitiniz %d olarak ayarland.
MEMO_SET_YOUR_LIMIT_ZERO
	Limitiniz sfr olduundan artk mesaj alamayacaksnz.
MEMO_UNSET_YOUR_LIMIT
	Mesaj limitiniz kapatld.
MEMO_SET_LIMIT
	%s nickinin mesaj limiti %d olarak ayarland.
MEMO_SET_LIMIT_ZERO
	%s nickinin mesaj limiti 0 olarak ayarland.
MEMO_UNSET_LIMIT
	%s nickinin mesaj limiti kapatld.

# INFO responses
MEMO_INFO_SYNTAX
	INFO [kanalad]
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [nick | kanalad]
MEMO_INFO_NO_MEMOS
	u an hi mesajnz yok.
MEMO_INFO_MEMO
	u an 1 mesajnz var.
MEMO_INFO_MEMO_UNREAD
	u an 1 mesajnz var, ve henz okunmad.
MEMO_INFO_MEMOS
	u an %d mesajnz var.
MEMO_INFO_MEMOS_ONE_UNREAD
	u an %d mesajnz var, 1 tanesi okunmam.
MEMO_INFO_MEMOS_SOME_UNREAD
	u an %d mesajnz var, %d tanesi okunmam.
MEMO_INFO_MEMOS_ALL_UNREAD
	u an %d mesajnz var; hibiri okunmam.
MEMO_INFO_LIMIT
	Mesaj limitiniz %d.
MEMO_INFO_HARD_LIMIT
	Mesaj limitiniz %d, ve deitirilemez.
MEMO_INFO_LIMIT_ZERO
	Mesaj limitiniz 0; hi mesaj alamayacaksnz.
MEMO_INFO_HARD_LIMIT_ZERO
	Mesaj limitiniz 0; hi yeni mesaj alamayacaksnz.  Bu limiti deitiremezsiniz.
MEMO_INFO_NO_LIMIT
	Saklayabileceiniz mesaj saysnda limit yok.
MEMO_INFO_NOTIFY_OFF
	Yeni mesajlar iin uyarlmayacaksnz.
MEMO_INFO_NOTIFY_ON
	Yeni mesajlar iin balandnzda ve size ulatnda uyarlacaksnz.
MEMO_INFO_NOTIFY_RECEIVE
	Yeni mesajlar iin ulatklar anda uyarlacaksnz.
MEMO_INFO_NOTIFY_SIGNON
	Yeni mesajlar iin balandnzda uyarlacaksnz.
MEMO_INFO_X_NO_MEMOS
	%s nickinin u an hi mesaj yok.
MEMO_INFO_X_MEMO
	%s nickinin u an 1 mesaj var.
MEMO_INFO_X_MEMO_UNREAD
	%s nickinin u an 1 mesaj var, ve daha okunmam.
MEMO_INFO_X_MEMOS
	%s nickinin u an %d mesaj var.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s nickinin u an %d mesaj var, 1 tanesi okunmam.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s nickinin u an %d mesaj var, %d tanesi okunmam.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s nickinin u an %d mesaj var; hibiri okunmam.
MEMO_INFO_X_LIMIT
	%s nickinin mesaj limiti %d.
MEMO_INFO_X_HARD_LIMIT
	%s nickinin mesaj limiti %d, ve deitirilemez.
MEMO_INFO_X_NO_LIMIT
	%s nickinin mesaj limiti yok.
MEMO_INFO_X_NOTIFY_OFF
	%s yeni mesajlar iin uyarlmayacak.
MEMO_INFO_X_NOTIFY_ON
	%s yeni mesajlar iin balandnda ve mesajlar ulat anda uyarlacak.
MEMO_INFO_X_NOTIFY_RECEIVE
	%s yeni mesajlar ulat anda uyarlacak.
MEMO_INFO_X_NOTIFY_SIGNON
	%s yeni mesajlar iin balandnda uyarlacak.
	
###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
BOT_DOES_NOT_EXIST
	Bot %s mevcut deil.
BOT_NOT_ASSIGNED
	Bu komutu kullanmadan nce kanala bir bot sokmalsnz.
	Daha fazla bilgi iin /msg %S HELP ASSIGN yazn.
BOT_NOT_ON_CHANNEL
	Bot %s kanalnda deil.
	
# Kick reasons (must be a single line)
BOT_REASON_BADWORD
	%s kelimesinin bu kanalda kullanlmas yasaktr!
BOT_REASON_BADWORD_GENTLE
	Konumalarna dikkat et!
BOT_REASON_BOLD
	Bu kanalda kaln yaz kullanlmas yasaktr!
BOT_REASON_CAPS
	Ltfen byk harf kullanmayn!
BOT_REASON_COLOR
	Ltfen bu kanalda renkli yaz kullanmayn!
BOT_REASON_FLOOD
	Flood yapma!
BOT_REASON_REPEAT
	Kendini tekrar etme!
BOT_REASON_REVERSE
	Ltfen bu kanalda Ctrl+R ile yazlm yaz kullanmayn!
BOT_REASON_UNDERLINE
	Ltfen bu kanalda alt izili yaz kullanmayn!

# !seen replies
BOT_SEEN_BOT
	Beni buldun, %s!
BOT_SEEN_YOU
	Kendinimi aryorsun, %s?
BOT_SEEN_ON_CHANNEL
	%s u anda kanalda!
BOT_SEEN_ON_CHANNEL_AS
	%s u anda kanalda (%s olarak) ! 
BOT_SEEN_ON
	%s %s nce buradayd.
BOT_SEEN_NEVER
	%s diye birini bu kanalda hi grmedim.
BOT_SEEN_UNKNOWN
	%s ahsnn kim olduunu bilmiyorum.
	
# BOT responses
BOT_BOT_SYNTAX
	BOT ADD nick user host gerekismi
	BOT CHANGE eskinick yeninick [user [host [gerekismi]]]
	BOT DEL nick
	BOT LIST
BOT_BOT_ALREADY_EXISTS
	%s nickli bot zaten var.
BOT_BOT_CREATION_FAILED
	Bot yaratma baarsz.
BOT_BOT_READONLY
	Botta deiiklik yapma geici olarak devre d.
BOT_BOT_ADDED
	%s!%s@%s (%s) bot listesine eklendi.
BOT_BOT_ANY_CHANGES
	Eski bilgiler imdikilerle ayn.
BOT_BOT_CHANGED
	%s botu %s!%s@%s (%s) olarak deitirildi.
BOT_BOT_DELETED
	%s botu silindi.
	
# BOTLIST responses
BOT_BOTLIST_HEADER
	Bot listesi:
BOT_BOTLIST_PRIVATE_HEADER
	IRCoplara ayrilmis botlar:
BOT_BOTLIST_FOOTER
	%d bot mevcut.
BOT_BOTLIST_EMPTY
	u an mevcut bot yok.
	Server adminine bir tane yaratmasn syleyin!
	
# ASSIGN responses
BOT_ASSIGN_SYNTAX
	ASSIGN kanalad nick
BOT_ASSIGN_READONLY
	Kanala bot sokma geici olarak devre d.
BOT_ASSIGN_ALREADY
	Bot %s is already assigned to channel %s.
BOT_ASSIGN_ASSIGNED
	%s botu %s kanalna sokuldu.
	
# UNASSIGN responses
BOT_UNASSIGN_SYNTAX
	UNASSIGN kanalad
BOT_UNASSIGN_UNASSIGNED
	%s kanalndan bot karld.
	
# INFO responses
BOT_INFO_SYNTAX
	INFO {kanalad | nick}
BOT_INFO_NOT_FOUND
	%s geerli bir bot yada kanal deil.
BOT_INFO_BOT_HEADER
	%s botunun bilgileri:
BOT_INFO_BOT_MASK
	               Mask : %s@%s
BOT_INFO_BOT_REALNAME
	        Gerek ismi : %s
BOT_INFO_BOT_CREATED
	          Yaratl : %s
BOT_INFO_BOT_USAGE
	Kullanlan kanallar : %d kanalda
BOT_INFO_BOT_OPTIONS
	    Ayarlar : %s
BOT_INFO_OPT_PRIVATE
	zel
BOT_INFO_CHAN_HEADER
	%s kanalnn bilgileri:
BOT_INFO_CHAN_BOT
	           Botun nicki : %s
BOT_INFO_CHAN_BOT_NONE
	           Botun nicki : u an yok.
BOT_INFO_CHAN_KICK_BADWORDS
	          Kfrde atma : %s
BOT_INFO_CHAN_KICK_BADWORDS_BAN
	          Kfrde atma : %s (%d tanede ban)
BOT_INFO_CHAN_KICK_BOLDS
	     Kaln yazda atma : %s
BOT_INFO_CHAN_KICK_BOLDS_BAN
	     Kaln yazda atma : %s (%d tanede ban)
BOT_INFO_CHAN_KICK_CAPS_ON
	     Byk yazda atma : %s (minimum %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_BAN
	     Byk yazda atma : %s (%d tanede ban; minimum %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_OFF
	     Byk yazda atma : %s
BOT_INFO_CHAN_KICK_COLORS
	    Renkli yazda atma : %s
BOT_INFO_CHAN_KICK_COLORS_BAN
	    Renkli yazda atma : %s (%d tanede ban)
BOT_INFO_CHAN_KICK_FLOOD_ON
	          Floodda atma : %s (%d sra %ds)
BOT_INFO_CHAN_KICK_FLOOD_BAN
	          Floodda atma : %s (%d tanede ban; %d sra %ds)
BOT_INFO_CHAN_KICK_FLOOD_OFF
	          Floodda atma : %s
BOT_INFO_CHAN_KICK_REPEAT_ON
	         Tekrarda atma : %s (%d kez)
BOT_INFO_CHAN_KICK_REPEAT_BAN
	         Tekrarda atma : %s (%d tanede ban; %d kez)
BOT_INFO_CHAN_KICK_REPEAT_OFF
	         Tekrarda atma : %s
BOT_INFO_CHAN_KICK_REVERSES
	        Ctrl+R de atma : %s
BOT_INFO_CHAN_KICK_REVERSES_BAN
	        Ctrl+R de atma : %s (%d tanede ban)
BOT_INFO_CHAN_KICK_UNDERLINES
	Altizili yazda atma : %s
BOT_INFO_CHAN_KICK_UNDERLINES_BAN
	Altizili yazda atma : %s (%d tanede ban)
BOT_INFO_ACTIVE
	Aktif
BOT_INFO_INACTIVE
	Kapal
BOT_INFO_CHAN_OPTIONS
	         zellikler : %s
BOT_INFO_OPT_DONTKICKOPS
	Oplar koruma
BOT_INFO_OPT_DONTKICKVOICES
	Voicelar koruma
BOT_INFO_OPT_FANTASY
	Fantazi
BOT_INFO_OPT_GREET
	Karlama
BOT_INFO_OPT_NOBOT
	Bot yok
BOT_INFO_OPT_SYMBIOSIS
	Gerek bot
BOT_INFO_OPT_NONE
	YOK
	
# SET responses
BOT_SET_SYNTAX
	SET kanalad zellik ayarlar
BOT_SET_DISABLED
	Bot zellik ayar geici olarak devre d.
BOT_SET_UNKNOWN
	Varolmayan zellik %s.
	Daha fazla bilgi iin /msg %S HELP SET yazn.
	
# SET DONTKICKOPS messages
BOT_SET_DONTKICKOPS_SYNTAX
	SET kanalad DONTKICKOPS {ON|OFF}
BOT_SET_DONTKICKOPS_ON
	Bot %s kanalnda oplar atmayacak .
BOT_SET_DONTKICKOPS_OFF
	Bot %s kanalnda oplarda atacak.
	
# SET DONTKICKVOICES messages
BOT_SET_DONTKICKVOICES_SYNTAX
	SET kanalad DONTKICKVOICES {ON|OFF}
BOT_SET_DONTKICKVOICES_ON
	Bot %s kanalnda voicelar atmayacak.
BOT_SET_DONTKICKVOICES_OFF
	Bot %s kanalnda voicelarda atacak.

# SET FANTASY messages
BOT_SET_FANTASY_SYNTAX
	SET kanalad FANTASY {ON|OFF}
BOT_SET_FANTASY_ON
	Fantazi modu %s kanalnda AKTF.
BOT_SET_FANTASY_OFF
	Fantazi modu %s kanalnda KAPALI.
	
# SET GREET messages
BOT_SET_GREET_SYNTAX
	SET kanalad GREET {ON|OFF}
BOT_SET_GREET_ON
	Karlama modu %s kanalnda AKTF.
BOT_SET_GREET_OFF
	Karlama modu %s kanalnda KAPALI.

# SET NOBOT
BOT_SET_NOBOT_SYNTAX
	SET kanalad NOBOT {ON|OFF}
BOT_SET_NOBOT_ON
	Bot yok modu %s kanal iin AKTF.
BOT_SET_NOBOT_OFF
	Bot yok modu %s kanal iin KAPALI.

# SET PRIVATE
BOT_SET_PRIVATE_SYNTAX
	SET kanaladi PRIVATE {ON|OFF}
BOT_SET_PRIVATE_ON
	%s botunun zel seenegi artik AKTIF.
BOT_SET_PRIVATE_OFF
	%s botunun zel seenegi artik KAPALI.
	
# SET SYMBIOSIS
BOT_SET_SYMBIOSIS_SYNTAX
	SET kanalad SYMBIOSIS {ON|OFF}
BOT_SET_SYMBIOSIS_ON
	Gerek bot modu %s kanalnda AKTF.
BOT_SET_SYMBIOSIS_OFF
	Gerek bot modu %s kanalnda KAPALI.
	
# KICK responses
BOT_KICK_SYNTAX
	KICK kanalad zellik {ON|OFF} [ayarlar]
BOT_KICK_DISABLED
	Atma ayarlar geici olarak devre d.
BOT_KICK_UNKNOWN
	Varolmayan zellik %s.
	Daha fazla bilgi iin /msg %S HELP KICK yazn.
BOT_KICK_BAD_TTB
	%s deeri kullanlamaz.
BOT_KICK_BADWORDS_ON
	Bot imdi kfrlerde atacak. BADWORDS komutunu kullanarak
	listeye kfr ekleyip silebilirsiniz.
BOT_KICK_BADWORDS_ON_BAN
	Bot imdi kfrlerde atacak, ve %d atma sonrasnda 
	ayn kullancy banlayacak. BADWORDS komutunu
	kullanarak kfr ekleyip karabilirsiniz.
BOT_KICK_BADWORDS_OFF
	Bot artk kfrlerde atmayacak.
BOT_KICK_BOLDS_ON
	Bot imdi kaln yazda atacak.
BOT_KICK_BOLDS_ON_BAN
	Bot imdi kaln yazda atacak, ve 
	%d atma sonrasnda ayn kullancy banlayacak.
BOT_KICK_BOLDS_OFF
	Bot artk kaln yazda atmayacak.
BOT_KICK_CAPS_ON
	Bot imdi byk yazda atacak(Tm mesajn en az
	%d karakterini ve %d%% kadarn iermelidir).
BOT_KICK_CAPS_ON_BAN
	Bot imdi byk yazda atacak(Tm mesajn en az
	%d karakterini ve %d%% kadarn iermelidir), ve 
	%d atma sonrasnda ayn kullancy banlayacak.
BOT_KICK_CAPS_OFF
	Bot artk byk yazda atmayacak.
BOT_KICK_COLORS_ON
	Bot imdi renkli yazda atacak.
BOT_KICK_COLORS_ON_BAN
	Bot imdi renkli yazda atacak, ve 
	%d atma sonrasnda ayn kullancy banlayacak.
BOT_KICK_COLORS_OFF
	Bot artk renkli yazda atmayacak.
BOT_KICK_FLOOD_ON
	Bot imdi text floodda atacak(%d sra %d saniyede).
BOT_KICK_FLOOD_ON_BAN
	Bot imdi text floodda atacak(%d sira %d saniyede), ve 
	%d atma sonrasnda ayn kullancy banlayacak.
BOT_KICK_FLOOD_OFF
	Bot artk text floodda atmayacak.
BOT_KICK_REPEAT_ON
	Bot imdi tekrarda atacak(kullanc %d kez
	ayn eyi sylerse).
BOT_KICK_REPEAT_ON_BAN
	Bot imdi tekrarda atacak(kullanc %d kez
	ayn eyi sylerse), ve %d atma sonrasnda
	ayn kullancy banlayacak.
BOT_KICK_REPEAT_OFF
	Bot artk tekrarda atmayacak.
BOT_KICK_REVERSES_ON
	Bot imdi Ctrl+R de atacak.
BOT_KICK_REVERSES_ON_BAN
	Bot imdi Ctrl+R de atacak, ve %d atma sonrasnda 
	ayn kullancy banlayacak.
BOT_KICK_REVERSES_OFF
	Bot artk Ctrl+R de atmayacak.
BOT_KICK_UNDERLINES_ON
	Bot imdi altizili yazda atacak.
BOT_KICK_UNDERLINES_ON_BAN
	Bot imdi altizili yazda atacak, ve %d atma 
	sonrasnda ayn kullancy banlayacak.
BOT_KICK_UNDERLINES_OFF
	Bot artk altizili yazda atmayacak.
	
# BADWORDS messages
BOT_BADWORDS_SYNTAX
	BADWORDS kanalad {ADD|DEL|LIST|CLEAR} [nick | kayt-listesi]
BOT_BADWORDS_DISABLED
	Kanaln kfr listesinde deiiklik yapma geici olarak devre ddr.
BOT_BADWORDS_REACHED_LIMIT
	Bir kanalda sadece %d tane kfr kayd olabilir.
BOT_BADWORDS_ALREADY_EXISTS
	%s zaten %s kanalnn kfr listesinde var.
BOT_BADWORDS_ADDED
	%s %s kanalnn kfr listesine eklendi.
BOT_BADWORDS_NO_SUCH_ENTRY
	(#%d) eklinde bir kayt %s kanalnn kfr listesinde bulunamad.
BOT_BADWORDS_NOT_FOUND
	%s %s kanalnn kfr listesinde bulunamad.
BOT_BADWORDS_NO_MATCH
	Uyuan kayt %s kanalnn kfr listesinde bulunamad.
BOT_BADWORDS_DELETED
	%s %s kanalnn kfr listesinden karld.
BOT_BADWORDS_DELETED_ONE
	%s kanalnn kfr listesinden 1 kayt silindi.
BOT_BADWORDS_DELETED_SEVERAL
	Deleted %d entries from %s bad words list.
BOT_BADWORDS_LIST_EMPTY
	%s kanalnn kfr listesi bo.
BOT_BADWORDS_LIST_HEADER
	%s kanalnn kfr listesi:
	  Say   Kelime                           Tipi
BOT_BADWORDS_LIST_FORMAT
	  %3d   %-30s %s
BOT_BADWORDS_CLEAR
	Kfr listesi imdi bo.

# SAY responses
BOT_SAY_SYNTAX
	SAY kanalad yaz

# ACT responses
BOT_ACT_SYNTAX
	ACT kanalad yaz

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
BOT_EXCEPT
	User matches channel except.

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
BOT_BAD_NICK
	Bot Nicks may only contain valid nick characters.
BOT_BAD_HOST
	Bot Hosts may only contain valid host characters.
BOT_BAD_IDENT
	Bot Idents may only contain valid characters.
###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	Servisler mod deitiremiyor.  Serverin doru ayarlandna emin olun.
OPER_BOUNCY_MODES_U_LINE
	Servisler mod deitiremiyor.  Serverin U:line larnn doru ayarlandna emin olun.

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL mesaj

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Varolmayan STATS zellii: %s.
OPER_STATS_CURRENT_USERS
	u anki kullanc says: %d (%d op)
OPER_STATS_MAX_USERS
	Maximum kullanc says: %d (%s)
# This is ugly, but at least it's language-portable...
# Note that you can include seconds in any of these--my personal preference
# is to only give resolution to the nearest minute when uptime is one hour
# or more, but just add a %d to get seconds as well.
OPER_STATS_UPTIME_DHMS
	Servisler %d gndr alyor, %02d:%02d
OPER_STATS_UPTIME_1DHMS
	Servisler %d gndr alyor, %02d:%02d
OPER_STATS_UPTIME_HMS
	Servisler %d saat, %d dakikadr alyor.
OPER_STATS_UPTIME_HM1S
	Servisler %d saat, %d dakikadr alyor.
OPER_STATS_UPTIME_H1MS
	Servisler %d saat, %d dakikadr alyor.
OPER_STATS_UPTIME_H1M1S
	Servisler %d saat, %d dakikadr alyor.
OPER_STATS_UPTIME_1HMS
	Servisler %d saat, %d dakikadr alyor.
OPER_STATS_UPTIME_1HM1S
	Servisler %d saat, %d dakikadr alyor.
OPER_STATS_UPTIME_1H1MS
	Servisler %d saat, %d dakikadr alyor.
OPER_STATS_UPTIME_1H1M1S
	Servisler %d saat, %d dakikadr alyor.
OPER_STATS_UPTIME_MS
	Servisler %d dakika, %d saniyedir alyor.
OPER_STATS_UPTIME_M1S
	Servisler %d dakika, %d saniyedir alyor.
OPER_STATS_UPTIME_1MS
	Servisler %d dakika, %d saniyedir alyor.
OPER_STATS_UPTIME_1M1S
	Servisler %d dakika, %d saniyedir alyor.
OPER_STATS_BYTES_READ
	Okunan veri  : %5d kB
OPER_STATS_BYTES_WRITTEN
	Yazlan veri : %5d kB
OPER_STATS_USER_MEM
	Kullanc  : %6d kayt, %5d kB
OPER_STATS_CHANNEL_MEM
	Kanal      : %6d kayt, %5d kB
OPER_STATS_GROUPS_MEM
	NS Groups     : %6d records, %5d kB
OPER_STATS_ALIASES_MEM
	NS Aliases    : %6d records, %5d kB
OPER_STATS_CHANSERV_MEM
	ChanServ   : %6d kayt, %5d kB
OPER_STATS_BOTSERV_MEM
	BotServ    : %6d kayt, %5d kB
OPER_STATS_OPERSERV_MEM
	OperServ   : %6d kayt, %5d kB
OPER_STATS_SESSIONS_MEM
	Oturumlar  : %6d kayt, %5d kB
OPER_STATS_PROXY_MEM
	Proxyler   : %6d kayit, %5d kB
OPER_STATS_AKILL_COUNT
	u anki AKILL says: %d
OPER_STATS_AKILL_EXPIRE_DAYS
	Varsaylan AKILL zaman am: %d gn
OPER_STATS_AKILL_EXPIRE_DAY
	Varsaylan AKILL zaman am: 1 gn
OPER_STATS_AKILL_EXPIRE_HOURS
	Varsaylan AKILL zaman am: %d saat
OPER_STATS_AKILL_EXPIRE_HOUR
	Varsaylan AKILL zaman am: 1 saat
OPER_STATS_AKILL_EXPIRE_MINS
	Varsaylan AKILL zaman am: %d dakika
OPER_STATS_AKILL_EXPIRE_MIN
	Varsaylan AKILL zaman am: 1 dakika
OPER_STATS_AKILL_EXPIRE_NONE
	Varsaylan AKILL zaman am: zaman am yok
OPER_STATS_SGLINE_COUNT
	u anki SGLINE says: %d
OPER_STATS_SGLINE_EXPIRE_DAYS
	Varsaylan SGLINE zaman am sresi: %d gn
OPER_STATS_SGLINE_EXPIRE_DAY
	Varsaylan SGLINE zaman am sresi: 1 gn
OPER_STATS_SGLINE_EXPIRE_HOURS
	Varsaylan SGLINE zaman am sresi: %d saat
OPER_STATS_SGLINE_EXPIRE_HOUR
	Varsaylan SGLINE zaman am sresi: 1 saat
OPER_STATS_SGLINE_EXPIRE_MINS
	Varsaylan SGLINE zaman am sresi: %d dakika
OPER_STATS_SGLINE_EXPIRE_MIN
	Varsaylan SGLINE zaman am sresi: 1 dakika
OPER_STATS_SGLINE_EXPIRE_NONE
	Varsaylan SGLINE zaman am sresi: Zaman am yok
OPER_STATS_SQLINE_COUNT
	Su anki SQLINE sayisi: %d
OPER_STATS_SQLINE_EXPIRE_DAYS
	Varsayilan SQLINE zaman asimi sresi: %d gn
OPER_STATS_SQLINE_EXPIRE_DAY
	Varsayilan SQLINE zaman asimi sresi: 1 gn
OPER_STATS_SQLINE_EXPIRE_HOURS
	Varsayilan SQLINE zaman asimi sresi: %d saat
OPER_STATS_SQLINE_EXPIRE_HOUR
	Varsayilan SQLINE zaman asimi sresi: 1 saat
OPER_STATS_SQLINE_EXPIRE_MINS
	Varsayilan SQLINE zaman asimi sresi: %d dakika
OPER_STATS_SQLINE_EXPIRE_MIN
	Varsayilan SQLINE zaman asimi sresi: 1 dakika
OPER_STATS_SQLINE_EXPIRE_NONE
	Varsayilan SQLINE zaman asimi sresi: Zaman asimi yok
OPER_STATS_SZLINE_COUNT
	u anki SZLINE says: %d
OPER_STATS_SZLINE_EXPIRE_DAYS
	Varsaylan SZLINE zaman am sresi: %d gn
OPER_STATS_SZLINE_EXPIRE_DAY
	Varsaylan SZLINE zaman am sresi: 1 gn
OPER_STATS_SZLINE_EXPIRE_HOURS
	Varsaylan SZLINE zaman am sresi: %d saat
OPER_STATS_SZLINE_EXPIRE_HOUR
	Varsaylan SZLINE zaman am sresi: 1 saat
OPER_STATS_SZLINE_EXPIRE_MINS
	Varsaylan SZLINE zaman am sresi: %d dakika
OPER_STATS_SZLINE_EXPIRE_MIN
	Varsaylan SZLINE zaman am sresi: 1 dakika
OPER_STATS_SZLINE_EXPIRE_NONE
	Varsaylan SZLINE zaman am sresi: Zaman am yok
OPER_STATS_RESET
	statistikler resetlendi.

# MODE responses
OPER_MODE_SYNTAX
	MODE kanalad modlar

# CLEARMODES responses
OPER_UMODE_SYNTAX
	UMODE nick modes

# OLINE responses
OPER_UMODE_SUCCESS
	Changed usermodes of %s.
OPER_UMODE_CHANGED
	%s changed your usermodes.

# OLINE responses
OPER_OLINE_SYNTAX
	OLINE nick flags
OPER_OLINE_SUCCESS
	An O:Line with the flags %s has been added for %s.

# CLEARMODES responses
OPER_OLINE_IRCOP
	You are now an IRC Operator.

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES kanalad [ALL]
OPER_CLEARMODES_DONE
	%s kanalnda modlar ve banlar temizlendi.
OPER_CLEARMODES_ALL_DONE
	%s kanalndaki tm modlar temizlendi.


# KICK responses
OPER_KICK_SYNTAX
	KICK kanalad kullanc sebep

# ADMIN responses
OPER_SVSNICK_SYNTAX
	SVSNICK nick newnick 
OPER_SVSNICK_NEWNICK
	The nick %s is now being changed to %s.
	
# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD|DEL|LIST|CLEAR} [nick | kayt-listesi]
OPER_ADMIN_SKELETON
	Servisler iskelet modunda(skeleton); ADMIN komutu devre d.
OPER_ADMIN_EXISTS
	%s zaten Servis adminleri listesinde.
OPER_ADMIN_REACHED_LIMIT
	Sadece %d tane servis admini olabilir.
OPER_ADMIN_ADDED
	%s Servis adminleri listesine eklendi.
OPER_ADMIN_NOT_FOUND
	%s Servisler admin listesinde bulunamad.
OPER_ADMIN_NO_MATCH
	Servis adminleri listesinde uyuan kayt yok.
OPER_ADMIN_DELETED
	%s servis adminleri listesinden silindi.
OPER_ADMIN_DELETED_ONE
	Servis adminleri listesinden 1 kayt silindi.
OPER_ADMIN_DELETED_SEVERAL
	Servis adminleri listesinden %d kayt silindi.
OPER_ADMIN_LIST_EMPTY
	Servis adminleri listesi bo.
OPER_ADMIN_LIST_HEADER
	Servis adminleri listesi:
	  Num   Nick
OPER_ADMIN_LIST_FORMAT
	  %3d   %s
OPER_ADMIN_CLEAR
	Servis adminleri listesi temizlendi.

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD|DEL|LIST|CLEAR} [nick | kayt-listesi]
OPER_OPER_SKELETON
	Servisler iskelet modunda(skeleton); OPER komutu devre d.
OPER_OPER_EXISTS
	%s zaten servis operatrleri listesinde.
OPER_OPER_REACHED_LIMIT
	Sadece %d tane servis operatr olabilir.
OPER_OPER_ADDED
	%s servis operatrleri listesine eklendi.
OPER_OPER_NOT_FOUND
	%s servis operatrleri listesinde bulunamad.
OPER_OPER_NO_MATCH
	Servis operatrleri listesinde uyuan kayt bulunamad.
OPER_OPER_DELETED
	%s servis operatrleri listesinden silindi.
OPER_OPER_DELETED_ONE
	Servis operatrleri listesinden 1 kayt silindi.
OPER_OPER_DELETED_SEVERAL
	Servis operatrleri listesinden %d kayt silindi.
OPER_OPER_LIST_EMPTY
	Servis operatrleri listesi bo.
OPER_OPER_LIST_HEADER
	Servis operatrleri listesi:
	  Num   Nick
OPER_OPER_LIST_FORMAT
	  %3d   %s
OPER_OPER_CLEAR
	Servis operatrleri listesi temizlendi.

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | CLEAR} [[+zamanam] {mask | kayt-no} [sebep]]
OPER_AKILL_EXISTS
	%s zaten AKILL listesinde.
OPER_AKILL_ALREADY_COVERED
	%s zaten %s tarafndan deitirildi.
OPER_AKILL_REACHED_LIMIT
	Sadece %d kii AKILL listesinde olabilir.
OPER_AKILL_NO_NICK
	Hatrlatma: AKILL maskna nick eklenemez; AKILL maskna nick eklemediinizden emin olun.
OPER_AKILL_ADDED
	%s AKILL listesine eklendi.
OPER_AKILL_CHANGED
	%s nickinin zaman am sresi deitirildi.
OPER_AKILL_NOT_FOUND
	%s AKILL listesinde bulunamad.
OPER_AKILL_NO_MATCH
	Uyuan kayt AKILL listesinde bulunamad.
OPER_AKILL_DELETED
	%s AKILL listesinden silindi.
OPER_AKILL_DELETED_ONE
	AKILL listesinden 1 kayt silindi.
OPER_AKILL_DELETED_SEVERAL
	AKILL listesinden %d kayt silindi.
OPER_AKILL_LIST_EMPTY
	AKILL listesi bo.
OPER_AKILL_LIST_HEADER
	u anki AKILL listesi:
	  No    Mask                              Sebep
OPER_AKILL_LIST_FORMAT
	  %3d   %-32s  %s
OPER_AKILL_VIEW_HEADER
	u anki AKILL listesi:
# number, mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_FORMAT
	%3d  %s (%s tarafndan %s tarihinde; %s)
	      %s
OPER_AKILL_CLEAR
	AKILL listesi temizlendi.

# SGLINE responses
OPER_CHANKILL_SYNTAX
	CHANAKILL [+expiry] {#channel} [reason]
# SGLINE responses
OPER_SGLINE_SYNTAX
	SGLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+zamanam] {mask | kayt-sras} [sebep]]
OPER_SGLINE_UNSUPPORTED
	SGLINE bu networkte mevcut deil.
OPER_SGLINE_EXISTS
	%s zaten SGLINE listesinde.
OPER_SGLINE_ALREADY_COVERED
	%s zaten %s tarafndan deitirildi.
OPER_SGLINE_REACHED_LIMIT
	Sadece %d kii SGLINE listesinde olabilir.
OPER_SGLINE_ADDED
	%s SGLINE listesinde eklendi.
OPER_SGLINE_CHANGED
	%s nickinin zaman am sresi deitirildi.
OPER_SGLINE_NOT_FOUND
	%s SGLINE listesinde bulunamad.
OPER_SGLINE_NO_MATCH
	SGLINE listesinde uyuan kayt bulunamad.
OPER_SGLINE_DELETED
	%s SGLINE listesinden silindi.
OPER_SGLINE_DELETED_ONE
	SGLINE listesinden 1 kayt silindi.
OPER_SGLINE_DELETED_SEVERAL
	SGLINE listesinden %d kayt silindi.
OPER_SGLINE_LIST_EMPTY
	SGLINE listesi bo.
OPER_SGLINE_LIST_HEADER
	u anki SGLINE listesi:
	  No   Mask                              Sebep
OPER_SGLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SGLINE_VIEW_HEADER
	u anki SGLINE listesi:
# number, mask, set-by, set-time, expires, reason
OPER_SGLINE_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_SGLINE_CLEAR
	SGLINE listesi temizlendi.

# SQLINE responses
OPER_SQLINE_SYNTAX
	SQLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+zaman asimi] {mask | kayit-sirasi} [sebep]]
OPER_SQLINE_CHANNELS_UNSUPPORTED
	SQLINE kullandiginiz IRCd tarafindan desteklenmiyor, bu yzden kullanmazsiniz.
OPER_SQLINE_EXISTS
	%s zaten SQLINE listesinde mevcut.
OPER_SQLINE_ALREADY_COVERED
	%s zaten %s tarafindan degistirildi.
OPER_SQLINE_REACHED_LIMIT
	Toplam %d SQLINE olabilir.
OPER_SQLINE_ADDED
	%s SQLINE listesine eklendi.
OPER_SQLINE_CHANGED
	%s iin zaman asimi sresi degistirildi.
OPER_SQLINE_NOT_FOUND
	%s SQLINE listesinde bulunamadi.
OPER_SQLINE_NO_MATCH
	SQLINE listesinde uyusan kayit bulunamadi.
OPER_SQLINE_DELETED
	%s SQLINE listesinden silindi.
OPER_SQLINE_DELETED_ONE
	SQLINE listesinden 1 kayit silindi.
OPER_SQLINE_DELETED_SEVERAL
	SQLINE listesinden %d kayit silindi.
OPER_SQLINE_LIST_EMPTY
	SQLINE listesi bos.
OPER_SQLINE_LIST_HEADER
	Mevcut SQLINE listesi:
	  Num   Mask                              Sebep
OPER_SQLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SQLINE_VIEW_HEADER
	Mevcut SQLINE listesi:
# number, mask, set-by, set-time, expires, reason
OPER_SQLINE_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_SQLINE_CLEAR
	SQLINE listesi temizlendi.

# SZLINE responses
OPER_SZLINE_SYNTAX
	SZLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+zamanam] {mask | kayt-sras} [sebep]]
OPER_SZLINE_UNSUPPORTED
	SZLINE bu networkte mevcut deil.
OPER_SZLINE_EXISTS
	%s zaten SZLINE listesinde.
OPER_SZLINE_ALREADY_COVERED
	%s zaten %s tarafndan deitirildi.
OPER_SZLINE_REACHED_LIMIT
	Sadece %d kii SZLINE listesinde olabilir.
OPER_SZLINE_ONLY_IPS
	Hatrlatma: SZLINE listesine sadece IP masklarn ekleyebilirsiniz.
OPER_SZLINE_ADDED
	%s SZLINE listesine eklendi.
OPER_SZLINE_CHANGED
	%s nickinin zaman am sresi deitirildi.
OPER_SZLINE_NOT_FOUND
	%s SZLINE listesinde bulunamad.
OPER_SZLINE_NO_MATCH
	SZLINE listesinde uyuan kayt bulunamad.
OPER_SZLINE_DELETED
	%s SZLINE listesinden silindi.
OPER_SZLINE_DELETED_ONE
	SZLINE listesinden 1 kayt silindi.
OPER_SZLINE_DELETED_SEVERAL
	SZLINE listesinden %d kayt silindi.
OPER_SZLINE_LIST_EMPTY
	SZLINE listesi bo.
OPER_SZLINE_LIST_HEADER
	u anki SZLINE listesi:
	  No   Mask                              Sebep
OPER_SZLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SZLINE_VIEW_HEADER
	u anki SZLINE listesi:
# number, mask, set-by, set-time, expires, reason
OPER_SZLINE_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_SZLINE_CLEAR
	SZLINE listesi temizlendi.

# SET responses
OPER_SET_SYNTAX
	SET zellik ayar
OPER_SET_IGNORE_ON
	Ignore kodu AKTIF.
OPER_SET_IGNORE_OFF
	Ignore kodu KAPALI.
OPER_SET_IGNORE_ERROR
	IGNORE ayar ON veya OFF eklinde olmaldr.
OPER_SET_READONLY_ON
	Servisler imdi read-only modunda.
OPER_SET_READONLY_OFF
	Servisler imdi read-write modunda.
OPER_SET_READONLY_ERROR
	READONLY ayar ON veya OFF eklinde olmaldr.
OPER_SET_LOGCHAN_ON
	Services is now reporting log messages to %s.
OPER_SET_LOGCHAN_OFF
	Services is no longer reporting log messages to a channel.
OPER_SET_LOGCHAN_ERROR
	Setting for LOGCHAN must be ON or OFF and LogChannel must be defined.
OPER_SET_DEBUG_ON
	Servisler imdi debug modunda.
OPER_SET_DEBUG_OFF
	Servisler imdi non-debug modunda.
OPER_SET_DEBUG_LEVEL
	Servisler imdi debug modunda (seviye %d).
OPER_SET_DEBUG_ERROR
	DEBUG ayar ON, OFF, veya pozitif bir say olmaldr.
OPER_SET_NOEXPIRE_ON
	Servisler imdi no expire modunda.
OPER_SET_NOEXPIRE_OFF
	Servisler imdi expire modunda.
OPER_SET_NOEXPIRE_ERROR
	NOEXPIRE ayar ON yada OFF olmaldr.
OPER_SET_UNKNOWN_OPTION
	Varolmayan zellik %s.

# NOOP responses
OPER_NOOP_SYNTAX
	NOOP {SET|REVOKE} server
OPER_NOOP_SET
	%s serverndaki tm O:line lar silindi.
OPER_NOOP_REVOKE
	%s serverndaki tm O:line lar resetlendi.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE serverismi [sebep]

# RAW responses
OPER_JUPE_HOST_ERROR
	Please use a valid server name when juping
	
# RAW responses
OPER_RAW_SYNTAX
	RAW yaz

# UPDATE responses
OPER_UPDATING
	Veritaban gncelleniyor.

# RELOAD responses
OPER_RELOAD
	Servislerin conf dosyas yeniden yklendi.

# RESTART responses
OPER_CANNOT_RESTART
	SERVICES_BIN tanmlanmam; restart edilemiyor.  Yeniden \2configure\2 edin ve RESTART komutunu aktifletirmek iin Servisleri yeniden derleyin.

# LISTIGNORE responses
OPER_IGNORE_SYNTAX
	Syntax: IGNORE {ADD|DEL|LIST|CLEAR} [time] [nick]
OPER_IGNORE_VALID_TIME
	You have to enter a valid number as time.
OPER_IGNORE_TIME_DONE
	%s will now be ignored for %s.
OPER_IGNORE_PERM_DONE
	%s will now permanently be ignored.
OPER_IGNORE_DEL_DONE
	%s will no longer be ignored.
OPER_IGNORE_LIST
	Servisler ignore listesi:
OPER_IGNORE_LIST_NOMATCH
	%s not found on ignore list.
OPER_IGNORE_LIST_EMPTY
	Ignore listesi bo.

# KILLCLONES responses
OPER_IGNORE_LIST_CLEARED
	Ignore list has been cleared.

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES nick
OPER_KILLCLONES_UNKNOWN_NICK
	Kullanc %s bulunamad.
	
# CHANLIST responses
OPER_CHANLIST_HEADER
	Kanal listesi:
	sim              Kullanici Modlari  Konu
OPER_CHANLIST_HEADER_USER
	%s kanal listesi:
	sim              Kullanici Modlari  Konu
OPER_CHANLIST_RECORD
	%-20s  %4d +%-6s %s
OPER_CHANLIST_END
	Kanal listesi sonu.
	
# USERLIST responses
OPER_USERLIST_HEADER
	Kullanc listesi:
	Nick                 Mask
OPER_USERLIST_HEADER_CHAN
	%s kullanc listesi:
	Nick                 Mask
OPER_USERLIST_RECORD
	%-20s %s@%s
OPER_USERLIST_END
	Kullanc listesi sonu.

# CACHE responses
OPER_CACHE_SYNTAX
	CACHE {DEL | LIST} {host | model} [QUEUED | ALL]
OPER_CACHE_DISABLED
	Proxy taramasi devre disi.
OPER_CACHE_NOT_FOUND
	%s cache te bulunamadi.
OPER_CACHE_REMOVED
	%s cache ten ikarildi.
OPER_CACHE_HEADER
	Host                                             Durum
OPER_CACHE_LIST
	%-48s %s
OPER_CACHE_FOOTER
	Liste sonu - %d/%d kayit gsterildi.
OPER_CACHE_QUEUED
	Siraya alindi
OPER_CACHE_PROGRESS
	Islemde
OPER_CACHE_NORMAL
	Normal
OPER_CACHE_WINGATE
	Wingate
OPER_CACHE_SOCKS4
	SOCKS 4
OPER_CACHE_SOCKS5
	SOCKS 5
OPER_CACHE_HTTP
	HTTP proxy

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_SUPER_ADMIN_ON
	You are now a SuperAdmin
OPER_SUPER_ADMIN_OFF
	You are no longer a SuperAdmin
OPER_SUPER_ADMIN_SYNTAX
	Setting for SuperAdmin must be ON or OFF.
OPER_SUPER_ADMIN_WALL_ON
	%s is now a Super-Admin
OPER_SUPER_ADMIN_WALL_OFF
	%s is no longer a Super-Admin

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_SUPER_ADMIN_ONLY
	Only Super-Admins can use this command.

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_STAFF_LIST_HEADER
	On Level Nick

# DefCon Messages

OPER_STAFF_FORMAT
	 %c %s  %s
OPER_STAFF_AFORMAT
	 %c %s  %s [%s]

# DefCon Messages

OPER_DEFCON_SYNTAX
	Syntax: DEFCON [1|2|3|4|5]
OPER_DEFCON_DENIED
	This service is temporarly disabled, please try again later
OPER_DEFCON_NO_CONF
	The Defcon system must be enabled in the services.conf file
OPER_DEFCON_CHANGED
	Services are now at DEFCON %d
OPER_DEFCON_WALL
	%s Changed the DEFCON level to %d
DEFCON_GLOBAL
	The Defcon Level is now at Level: %d

# Modules strings

OPER_MODULE_LOADED
	Module %s loaded
OPER_MODULE_UNLOADED
	Module %s unloaded
OPER_MODULE_LOAD_FAIL
	Unable to load module %s
OPER_MODULE_REMOVE_FAIL
	Unable to remove module %s
OPER_MODULE_LOAD_SYNTAX
	MODLOAD FileName
OPER_MODULE_UNLOAD_SYNTAX
	MODUNLOAD FileName
OPER_MODULE_LIST
	Module: %s
OPER_MODULE_INFO_LIST
	Module: %s Version: %s Author: %s loaded: %s
OPER_MODULE_CMD_LIST
	Providing command: /msg %s %s
OPER_MODULE_MSG_LIST
	Providing IRCD handler for: %s
OPER_MODULE_NO_LIST
	No modules currently loaded
OPER_MODULE_NO_INFO
	No information about module %s is available
OPER_MODULE_INFO_SYNTAX
	MODINFO FileName

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
MODULE_HELP_HEADER
	The following commands have been loaded by a module:

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [parametreler]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+zamanam] mask limit sebep
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {mask | liste}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE num pozisyon
OPER_EXCEPTION_DISABLED
	Session limit koyma devre d.
OPER_EXCEPTION_ALREADY_PRESENT
	Mask %s zaten exception listesinde bulunuyor.
OPER_EXCEPTION_TOO_MANY
	Session-limit exception listesi dolu!
OPER_EXCEPTION_ADDED
	%s iin session limit %d olarak deitirildi.
OPER_EXCEPTION_MOVED
	%s (#%d) iin exception %d pozisyonuyla deitirildi.
OPER_EXCEPTION_NO_SUCH_ENTRY
	(#%d) byle bir kayt yok. session-limit exception listesi.
OPER_EXCEPTION_NOT_FOUND
	%s session-limit exception listesinde bulunamad.
OPER_EXCEPTION_NO_MATCH
	session-limit exception listesinde uyuan kayt bulunamad.
OPER_EXCEPTION_DELETED
	%s session-limit exception listesinden silindi.
OPER_EXCEPTION_DELETED_ONE
	Session-limit exception listesinden 1 kayt silindi.
OPER_EXCEPTION_DELETED_SEVERAL
	Session-limit exception listesinden %d kayt silindi.
OPER_EXCEPTION_LIST_HEADER
	u anki Session Limit Exception listesi:
# mask, limit
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
OPER_EXCEPTION_LIST_COLHEAD
	Say  Limit  Host
# mask, set-by, set-time, expires, limit, reason
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (by %s on %s; %s)
	    Limit: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	Geersiz session limiti. Sfrdan byk yada eit ve %d den az bir geerli tamsay olmaldr.
OPER_EXCEPTION_INVALID_HOSTMASK
	Geersiz hostmask. Sadece gerek hostmasklar exception olarak geerlidir.

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST limit | VIEW host}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST limit
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW host
OPER_SESSION_DISABLED
	Session limit koyma devre d.
OPER_SESSION_INVALID_THRESHOLD
	Geersiz threshold deeri. 1 den byk geerli tamsay olmaldr.
OPER_SESSION_NOT_FOUND
	%s session listesinde bulunamad.
OPER_SESSION_LIST_HEADER
	En az %d sessionl hostlar:
OPER_SESSION_LIST_COLHEAD
	Sessionlar  Host
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	Host %s u anda %d session a sahip ve %d ile limitli.

# EXCEPTION help

OPER_HELP_EXCEPTION
	Kullanm: EXCEPTION ADD [+zamanam] mask limit sebep
	           EXCEPTION DEL {mask | liste}
	           EXCEPTION MOVE num pozisyon
	           EXCEPTION LIST [mask | liste]
	           EXCEPTION VIEW [mask | liste]
	
	Servis adminlerinin, belirli oturum limiti olan hostlarn 
	listesini deitirmesini salar. Shell server gibi baz 
	makinalarn varsaylandan daha fazla kullancy ayn anda
	tamasn salar. Eer bir host session(oturum) limitine
	ulamsa o hosttan balanmaya alan tm kullanclar 
	kill lenir. Kill lenmeden nce, %S'n /NOTICE i ile
	uyarlarak session limiti hakknda yardm verilir. Bu uyarnn
	ierii ayar yapmayla ilgilidir.
	
	EXCEPTION ADD exception(istisna) listesine belirtilen hostmask
	ekler. nick!user@host ve user@host masklarnn geersiz 
	olduunu unutmayn! Sadece box.host.dom ve *.host.dom gibi 
	gerek hostmasklar kullanlabilinir, nk session limitleme 
	nickleri ve username leri hesaba almaz. limit sfrdan byk 
	yada eit bir rakam olmaldr. Bu o host un ayn anda ka oturum
	(session) kaldrabileceini belirler. Sfr deeri o host un
	snrsz oturum limiti olduunu belirtir. Opsiyonel zamanam 
	parametresinin format ile ilgili yardm iin AKILL in 
	yardmna baknz.
	EXCEPTION DEL listesinden belirtilen mask  karr.
	EXCEPTION MOVE exception numarasn(num) pozisyona (position)
	evirir. Aralarndaki exceptionlarn yeri aral doldurmak iin 
	yukar yada aa deitirilecektir.
	EXCEPTION LIST ve EXCEPTION VIEW tm mevcut exceptionlar 
	gsterir; eer opsiyonel olarak mask belirtilmise, liste
	bu masklarla uyuan exceptionlarla snrlandrlr. Aradaki fark
	EXCEPTION VIEW daha gelismis bir komuttur ve exception  ekleyenin 
	nickini, o exceptionn session limitini, sebebi, host mask ve zaman 
	am tarih ve zamann gsterir.
	
	Balanan kullanc, hostuyla uyuan ilk exception kullanr. Byk 
	exception listeleri ve geni olarak uyuan exception masklar 
	servislerin performansn drr. 
	
	Servis adminleri tarafndan kullanlabilir.

OPER_HELP_SESSION
	Kullanm: SESSION LIST threshold
	           SESSION VIEW host
	
	Servis adminlerinin session listesini grntlemesini salar.
	
	SESSION LIST en az threshold sessionlardaki hostlar listeler.
	Threshold(eik) 1 den byk bir say olmaldr. Bu byk 
	ldeki tek session hostlarn yanllkla listelenmelerini 
	nlemek iindir.
	SESSION VIEW belirli bir host hakknda ayrntl bilgileri 
	grntler. Bu o anki session saysn ve session limitinide
	gsterir. host deeri wildcard(ak olarak yazlmaldr) 
	iermemelidir.
	
	Session limitleme ve belirli hostlara ve gruplara nasl session 
	limit koyulaca hakknda yardm iin EXCEPTION yardmna bakn.
	
	Servis adminleri tarafndan kullanlabilir.

###########################################################################
#
# News system messages
#
###########################################################################

OPER_HELP_STAFF
	Syntax: STAFF

	Displays all Services Staff nicks along with level
	and on-line status.

OPER_HELP_DEFCON
	Syntax: DEFCON [1|2|3|4|5]

	The defcon system can be used to implement a pre-defined
	set of restrictions to services useful during an attemtped
	attack on the network.

OPER_HELP_DEFCON_NO_NEW_CHANNELS
	* No new channel registrations
OPER_HELP_DEFCON_NO_NEW_NICKS
	* No new nick registrations
OPER_HELP_DEFCON_NO_MLOCK_CHANGE
	* No MLOCK changes
OPER_HELP_DEFCON_FORCE_CHAN_MODES
	* Force Chan Modes (%s) to be set on all channels
OPER_HELP_DEFCON_REDUCE_SESSION
	* Use the reduced session limit of %d
OPER_HELP_DEFCON_NO_NEW_CLIENTS
	* Kill any NEW clients connecting
OPER_HELP_DEFCON_OPER_ONLY
	* Ignore any non-opers with message
OPER_HELP_DEFCON_SILENT_OPER_ONLY
	* Silently ignore non-opers
OPER_HELP_DEFCON_AKILL_NEW_CLIENTS
	* AKILL any new clients connecting


###########################################################################
#
# News system messages
#
###########################################################################

OPER_HELP_DEFCON_NO_NEW_MEMOS
	* No new memos sent
OPER_HELP_CHANKILL
	Syntax: CHANKILL [+expiry] channel reason

	Puts an AKILL for every nick on the specified channel. It
	uses the entire and complete real ident@host for every nick,
	then enforces the AKILL. 

###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[Balant Haberleri - %s] %s
NEWS_OPER_TEXT
	[Operatr Haberleri - %s] %s
NEWS_RANDOM_TEXT
	[Karisik Haberler - %s] %s

NEWS_LOGON_SYNTAX
	Kullanm: LOGONNEWS {ADD|DEL|LIST} [yaz|num]
NEWS_LOGON_LIST_HEADER
	Balant haberleri:
NEWS_LOGON_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_LOGON_LIST_NONE
	Hi balant haberi yok.
NEWS_LOGON_ADD_SYNTAX
	Kullanm: LOGONNEWS ADD yaz
NEWS_LOGON_ADD_FULL
	Haber listesi dolu!
NEWS_LOGON_ADDED
	Yeni balant haberleri maddesi eklendi (#%d).
NEWS_LOGON_DEL_SYNTAX
	Kullanm: LOGONNEWS DEL {num | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Balant haberleri maddesi #%d bulunamad!
NEWS_LOGON_DELETED
	Balant haberleri maddesi #%d silindi.
NEWS_LOGON_DEL_NONE
	Silebileceiniz balant haberleri maddesi yok!
NEWS_LOGON_DELETED_ALL
	Tm balant haberleri silindi.

NEWS_OPER_SYNTAX
	Kullanm: OPERNEWS {ADD|DEL|LIST} [yaz|num]
NEWS_OPER_LIST_HEADER
	Operatr haberleri:
NEWS_OPER_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_OPER_LIST_NONE
	Hi operatr haberi yok.
NEWS_OPER_ADD_SYNTAX
	Kullanm: OPERNEWS ADD yaz
NEWS_OPER_ADD_FULL
	Haber listesi dolu!
NEWS_OPER_ADDED
	Yeni operatr haberleri maddesi eklendi (#%d).
NEWS_OPER_DEL_SYNTAX
	Kullanm: OPERNEWS DEL {num | ALL}
NEWS_OPER_DEL_NOT_FOUND
	Operatr haberleri maddesi #%d bulunamad!
NEWS_OPER_DELETED
	Operatr haberleri maddesi #%d silindi.
NEWS_OPER_DEL_NONE
	Silebileceiniz operatr haberleri maddesi yok!
NEWS_OPER_DELETED_ALL
	Tm operatr haberleri maddeleri silindi.

NEWS_RANDOM_SYNTAX
	Kullanm: RANDOMNEWS {ADD|DEL|LIST} [yazi|no]
NEWS_RANDOM_LIST_HEADER
	Karisik haberler:
NEWS_RANDOM_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_RANDOM_LIST_NONE
	Hi karisik haber yok.
NEWS_RANDOM_ADD_SYNTAX
	Kullanm: RANDOMNEWS ADD yazi
NEWS_RANDOM_ADD_FULL
	Haber listesi dolu!
NEWS_RANDOM_ADDED
	Yeni karisik haber eklendi (#%d).
NEWS_RANDOM_DEL_SYNTAX
	Kullanm: RANDOMNEWS DEL {no | ALL}
NEWS_RANDOM_DEL_NOT_FOUND
	#%d numarali karisik haber bulunamadi!
NEWS_RANDOM_DELETED
	#%d numarali karisik haber silindi.
NEWS_RANDOM_DEL_NONE
	Silinecek karisik haber yok!
NEWS_RANDOM_DELETED_ALL
	Tm karisik haberler silindi.

NEWS_HELP_LOGON
	Kullanm: LOGONNEWS ADD text
	           LOGONNEWS DEL {num | ALL}
	           LOGONNEWS LIST
	
	Balant haberleri listesini deitirmeye ve grntlemeye
	yarar. Bir kullanc network e baland zaman bu haberler
	onlara gnderilir.(Fakat ten fazla mesaj kullancy 
	floodlamamak iin gnderilmez. Eer ten fazla haber varsa
	bunlardan en gncel olan  tanesi gnderilir.)
	
	BALANTI HABERLER LSTES(LOGONNEWS LIST) herhangi bir IRCop
	tarafndan grntlenebilir. ADD ve DEL komutlar sadece servis
	adminleri tarafndan kullanlr.

NEWS_HELP_OPER
	Kullanm: OPERNEWS ADD yaz
	           OPERNEWS DEL {num | ALL}
	           OPERNEWS LIST
	
	Operatr haberlerinin listesini deitirmeye ve grntlemeye
	yarar. Bir kullanc oper olduu zaman (/OPER komutuyla), bu 
	haberler ona gnderilir. (Fakat ten fazla mesaj kullancy
	floodlamamak iin gnderilmez.  Eer ten fazla mesaj varsa 
	en gncel olan  tanesi gderilir.)
	
	OPERATR HABERLER LSTES(OPERNEWS LIST) herhangi bir IRCop 
	tarafndan	grntlenebilir. ADD ve DEL komutlar sadece 
	Servis adminleri tarafndan kullanlr.

NEWS_HELP_RANDOM
	Kullanimi: RANDOMNEWS ADD yazi
	           RANDOMNEWS DEL {no | ALL}
	           RANDOMNEWS LIST
	
	Karisik haberleri dzenlemenizi saglar. Bir kullanici
	network e baglandigi zaman, karisik haberlerden bir tanesi
	seilerek kullaniciya gnderilir.
	
	RANDOMNEWS LIST herhangi bir IRC operatr tarafindan
	haberleri listelemek iin kullanilabilir. ADD ve DEL
	komutlarini sadece Servis adminlerinin kullanabilir.

###########################################################################
#
# HelpServ help message
#
###########################################################################

HELP_HELP
	%S servisler hakknda bilgi vermek iin tasarlanmtr.
	Yardm konularna dier servislerin HELP komutuyla ulalr.
	
	/msg %s HELP
	     nick kayt hakknda bilgiler ierir.
	
	/msg %s HELP
	     kanal kayd ve kontrol hakknda bilgi ierir.
	
	/msg %s HELP
	     kullanclara internette olmasalar bile mesaj gndermek
	     iin gerekli bilgileri ierir.

HELP_HELP_BOT

	/msg %s HELP
	     kanallara bot sokulmas ve ayarlar hakknda bilgi ierir.

HELP_HELP_HOST

	/msg %s HELP
	     for information on setting up nick vHosts

###########################################################################
#
# NickServ help messages
#
###########################################################################

NICK_HELP
	%S nickinizi "kayt" etmenizi ve dierlerinin nickinizi 
	kullanmalarn engellemeyi salar. Aadaki komutlar nicki
	kayt etmeye ve korumaya izin verir, kullanmak iin, 
	/msg %S komut yazn. Belirli bir komut hakknda daha 
	fazla bilgi iin, /msg %S HELP komut yazn.
	
	    REGISTER   Nickinizi kaydeder
	    GROUP      Bir gruba dahil eder
	    IDENTIFY   ifrenizle nickinizi tantr
	    ACCESS     zinli adreslerin listesini dzenler
	    SET        Ayarlar, kill korumasn ierir
	    DROP       Nickin kaydn siler
	    RECOVER    Nickinizi kullanan birini kill ler
	    RELEASE    RECOVER komutundan sonra nickinizi serbest 
	                  brakr
	    SENDPASS   ifrenizimi unuttunuz? Bunu deneyin
	
	Dier komutlar: GHOST, GLIST, INFO, LIST, LOGOUT, STATUS
	
	NOT: Bu servis kullanclarn kimliklerini tehlikeye 
	atmayacak ekilde tasarlanmtr. Bu nickleri "almay" 
	veya dier kt niyetli hareketleri kolaylatrmay salama
	amal deildir. %S 'n ktye Kullanm ktye 
	kullanlan kiinin nickini kaybetmesiyle sonulanacaktr.

NICK_HELP_EXPIRES
	
	Daha fazla kullanlmayan nicklerin otomatik olarak
	kaydnn silinmesi sz konusudur, mesela kullanlmayan
	nickler %d gn sonra silinirler.

NICK_HELP_REGISTER
	Kullanm: REGISTER ifre [email]
	
	%S 'n veritabanna nickinizi kaydeder. Nickinizi 
	bir kere kayt ettikten sonra nickinizin zelliklerini 
	istediiniz gibi belirlemek iin SET ve ACCESS 
	komutlarn kullanabilirsiniz. Kaytta kullandnz ifrenin
	hatrlanabilecek birey olmasna dikkat edin - ilerde
	nickinizin zelliklerinde deiiklik yaparken ve sunucuda
	kullanabilmek iin ihtiyacnz olacak. (ifrelerin byk
	kk harf hassasiyeti olduunu unutmayn! XR, xir, 
	ve ixir ifreleri birbirinden farkldr.)
	
	ifreleri seme konusunda rehber:
	
	ifreler kolayca tahmin edilebilir olmamaldr.  rnein,
	gerek isminizi ifre olarak kullanmak kt bir fikirdir.
	Nickinizi ifre olarak kullanmak daha kt bir fikirdir :)
	ve zaten %S buna izin vermez. Ayrca ksa ifreler 
	deneme yanlma yntemiyle bulunabilirler, bu yzden ifrenizin
	en az 5 karakter olmasna dikkat edin. Son olarak ifrede
	boluk kullanmamanz gerekir.
	
	email parametresi opsiyoneldir ve nickiniz iin bir 
	email adresi belirler. Fakat baz networklerde bu
	parametrenin kullanlmas zorunlu olabilir.(Unutmayn
	email adresinizi doru olarak vermeniz ilerde ifrenizi 
	unutmanz halinde ok ie yarayacaktr)
	Gizliliinize sayg duyulacak ve mail adresiniz herhangi 
	nc ahslara sylenmeyecektir.

	Bu komut ayrca nickiniz iin yeni bir grup oluturur ki bu
	ilerde gruba kaydedeceiniz nickler iin ayn zellikleri, 
	memo ayarlarn ve ayn kanal ayrcalklarn paylamanz 
	salar. Bu zellik hakknda daha fazla bilgi iin, 
	/msg %S HELP GROUP yazn.


NICK_HELP_GROUP
	Kullanm: GROUP hedef ifre
	
	Bu komut nickinizin hedef gsterilen nickin grubuna katlmasn
	salar. ifre hedef gsterilen nickin ifresidir.
	
	Bir gruba dahil olmak size o gruba dahil olan tm nicklerinizin
	ayarlarn, memolarn, ve kanal ayrcalklarn paylamanz ve 
	daha fazlasn salar!
	 
	Bir grup kullanl olduu srece kalcdr. Bu demektirki eer
	gruba dahil nickleriniz kaydn silerseniz, grupta en az bir nick 
	kalmas kaydiyle yukarda aklanan paylamlar kaybetmezseniz.
	
	Bu komutu nickinizi kaydetmemi olsanz bile kullanabilirsiniz.
	Eer nickiniz zaten kaytl ise, bu komutu kullanmadan nce
	nickinizi tantmanz gerekir, daha fazla bilgi iin
	/msg %S HELP IDENTIFY yazn. Sizin IRC networkunuzda
	bu mmkn olmayabilir.
	
	Bu komutu kaytl olmayan bir nickle kullanmanz nerilir nk
	bu komutu kullanc o nick otomatik olarak kaydedilir. Bunu
	kaytl bir nicklede eer network adminleri buna izin veriyorsa
	kullanabilirsiniz.
	
	Bir seferde sadece bir grupta olabilirsiniz. Grup kartrma
	mmkn deildir.
	
	Not: bir gruptaki tm nickler bir ifreye sahip olurlar.

NICK_HELP_IDENTIFY
	Kullanm: IDENTIFY ifreniz
	
	%S 'e kullandnz nickin gerek sahibinin siz olduunu
	belirtir. ou komut kullanlmadan nce bu komutla 
	tantlmanz gerektirir. ifreniz nickinizi kayt ederken 
	REGISTER komutuyla beraber kullandnzla ayndr.

NICK_HELP_UPDATE
	Syntax: UPDATE

	Updates your current status, i.e. it checks for new memos,
	sets needed chanmodes (ModeonID) and updates your vhost and
	your userflags (lastseentime, etc).
	
NICK_HELP_LOGOUT
	Kullanm: LOGOUT
	
	IDENTIFY komutunun yapt etkiyi tersine evirir,
	yani artk o nickin gerek sahibi olarak tannmamanz
	salar. Fakat sizden nickinizi tekrar identify etmeniz 
	istenmez.

NICK_HELP_DROP
	Kullanm: DROP [nick]
	
	%S 'n veritabanndan nickinizi siler. Silinmi bir nick
	bakas tarafndan kayt edilebilir.

	nick parametresini kullanarak belirttiiniz nicki
	grubunuzdan silebilirsiniz.
	
	Bu komutu kullanmadan nce, ifrenizle kendinizi tantmanz
	gereklidir (Daha fazla bilgi iin /msg %S HELP IDENTIFY 
	yazn).

NICK_HELP_ACCESS
	Kullanm:  ACCESS ADD mask
	        ACCESS DEL mask
	        ACCESS LIST
	
	Nickinizin access litesini grntler ve deiiklikler 
	yapmanz salar. Bu listede belirtilen adresler %S 
	tarafndan nickinizi kullanabilmek iin otomatik olarak 
	tannacak adreslerdir. (bylece identify komutunu 
	kullanmanza gerek kalmaz.) Eer belirtilenden farkl bir 
	adresle balanmsanz %S 'n sizi tanmas iin 
	IDENTIFY komutunu kullanmanz gerekir.
	
	rnekler:
	
	    ACCESS ADD birisi@*.ixir.com
	        Kullanc birisi'ne ixir.com 
	        domaininden herhangi bir makineden 
	        eriim salar.
	
	    ACCESS DEL birisi@*.ixir.com
	        nceki komutun tersini yapar(siler).
	
	    ACCESS LIST
	        Mevcut access listesini grntler.

NICK_HELP_SET
	Kullanm: SET zellik parametre
	
	eitli nick zelliklerini ayarlar.  zellik unlardan biri 
	olabilir:
	
	    DISPLAY    Grubunuzun servislerde nasl grneceini ayarlar
	    PASSWORD   Nickinize ifre belirtir
	    LANGUAGE   Servislerin size hitap edecei 
	                  dili belirler
	    URL        Nickinizle bir URL yi ilikilendirir
	    EMAIL      Nickinizle bir email adresini ilikilendirir
	    ICQ        Nickinizle bir ICQ numarasn iliikilendirir
	    GREET      Nickiniz iin bir karlama mesaj belirler
	    KILL       Korumay aar kapatr
	    SECURE     Nick gvenliini aar kapatr
	    PRIVATE    Nickinizin /msg %S LIST yazldnda grnmesini
	                  engeller
	    HIDE       Nickinizle ilgili baz bilgileri saklar
	
	Bu komutu kullanabilmek iin nce, ifrenizle 
	kendinizi tantmanz gerekir (Daha fazla bilgi iin 
	/msg %S HELP IDENTIFY yazn).
	
	Belirli bir zellik(option) hakknda bilgi almak iin
	/msg %S HELP SET option yazn.

NICK_HELP_SET_DISPLAY
	Kullanm: SET DISPLAY yeni-grnm
	
	Servislerde grubunuzdaki nicklerden hangisinin gzkeceini
	ayarlar. Yeni grnm grubunuzda bulunan nicklerden biri 
	olmaldr.

NICK_HELP_SET_PASSWORD
	Kullanm: SET PASSWORD yeni ifre
	
	Nickinizi tantmak iin kullandnz ifreyi
	deitirir.

NICK_HELP_SET_LANGUAGE
	Kullanm: SET LANGUAGE numara
	
	Servislerin size hitap edecei dili belirlemenizi salar.
	(rnein, bir komut yazdnzda gelecek cevabn dili gibi).
	numara aadaki listede desteklenen dillerden biri olarak 
	belirlenir:

NICK_HELP_SET_URL
	Kullanm: SET URL url
	
	Nickiniz iin bir URL adresi belirtir. Bu URL adresi birisi
	sizin hakknzda bilgi almak iin INFO komutunu 
	kullandnda grnr.

NICK_HELP_SET_EMAIL
	Kullanm: SET EMAIL email adresiniz
	
	Nickiniz iin bir email adresi belirtir. Bu email adresi
	birisi sizin hakknzda bilgi almak iin INFO komutunu 
	kullandnda grnr.

NICK_HELP_SET_ICQ
	Kullanm: SET ICQ icqnumaranz
	
	Nickiniz iin bir ICQ numaras belirtir. Bu ICQ numaras
	birisi sizin hakknzda bilgi almak iin INFO komutunu
	kullandnda grnr.

NICK_HELP_SET_GREET
	Kullanm: SET GREET mesaj
	
	Yazdnz mesaj nickinizin karlama mesaj olarak
	belirler, bu mesaj GREET zellii aktif bir kanala 
	girdiinizde gnderilir, kanaldaki access seviyenize
	baldr.

NICK_HELP_SET_KILL
	Kullanm: SET KILL {ON | QUICK | IMMED | OFF}
	
	Nickiniz iin otomatik koruma zelliini aar ve kapatr.
	Koruma akken eer bir bakas sizin nickinizi kullanmaya 
	kalkarsa, o kiiye nicki deitirmesi iin bir dakika sre 
	verilir, eer deitirmezse %S tarafndan otomatik olarak
	deitirilir.
	
	Eer QUICK parametresini seerseniz, kullancya nickini
	deitirmesi iin 60 saniye yerine sadece 20 saniye verilir.
	Eer IMMED parametresini seerseniz kullancnn nicki
	uyarlmadan hemen deitirilir; ltfen ok gerekmedike
	bu zellii kullanmayn. Hatta network yneticileri bu
	zellii devre d brakm olabilirler.

NICK_HELP_SET_SECURE
	Kullanm: SET SECURE {ON | OFF}
	
	%S'n gvenlik zelliklerini aar ve kapatr. SECURE 
	ayar ile, nickin sahibi olarak tannmanz iin nce ifreyle 
	kendinizi tantmanz gerekir(adresinizin nickin access
	listesinde olup olmamasna bal olarak). Fakat, eer 
	adresiniz nickin access listesindeyse KILL zellii
	kullanlm olsa bile %S sizi otomatik olarak kill
	lemeyecektir.

NICK_HELP_SET_PRIVATE
	Kullanm: SET PRIVATE {ON | OFF}
	
	%S'n zel nick zelliini aar kapatr. PRIVATE ayar
	ile, %S'n LIST komutu kullanldnda nickiniz listede
	gzkmeyecektir.(Buna ramen, nickinizi bilen biri INFO 
	komutunu kullanarak hakknzda bilgi alabilir.)

NICK_HELP_SET_HIDE
	Kullanm: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	Birisi hakknzda bilgi almak iin %S INFO komutunu 
	kullandnda baz bilgilerin burada gzkmemesini salar.
	E-mail adresinizi (EMAIL), son grndnz user@host 
	maskn (USERMASK), ve son k mesajnz (QUIT)
	saklayabilirsiniz. kinici parametre bilginin grnp (OFF)
	grnmeyeceini (ON) belirtmenizi salar.

NICK_HELP_SET_MSG
	Syntax: SET MSG {ON | OFF}
	
	Allows you to choose the way Services are communicating with 
	you. With MSG set, Services will use messages, else they'll 
	use notices.

NICK_HELP_RECOVER
	Kullanm: RECOVER nick [ifre]
	
	Eer birisi nickinizi kullanyorsa ondan nicki geri almanz
	salar; bu komut kill korumas olan bir nicke %S'n
	yaptnn aynsn yapar.
	
	Bu komutu kullandnzda, %S o nicke sahip sahte bir 
	kullancy servera sokar. Bu dier kullancnn serverdan
	kopmasna neden olur. Bu sahte kullanc bir dakika kadar 
	hatta kalr ve dier kullancnn tekrar o nickle balanmasna
	engel olur. Bir dakikadan sonra nickinizi geri alabilirsiniz.
	Bir dakikadan nce nickinizi geri almak iin RELEASE komutunu
	(/msg %S HELP RELEASE) kullanabilirsiniz.
	
	RECOVER komutunu bir nick zerinde kullanabilmek iin o an
	/WHOIS inizdeki adresin o nickin access listesinde olmas, o 
	nickin grubundaki baka bir nickin tantlm olmas yada o 
	nick iin doru ifenin belirtilmi olmas gerekir.

NICK_HELP_RELEASE
	Kullanm: RELEASE nick [ifre]
	
	Otomatik kill korumas veya RECOVER komutunun kullanlmasndan
	kaynaklanan nickin %S tarafndan tutulmas durumunda nicki 
	serbest brakmak iin kullanlr. Varsaylan olarak, nick tutma 
	olay bir dakika sonunda sona erer. Bu komut bunun bir dakikadan 
	nce olmasn salar.
	
	RELEASE komutunu bir nick zerinde kullanabilmek iin o an
	/WHOIS inizdeki adresin o nickin access listesinde olmas, o 
	nickin grubundaki baka bir nickin tantlm olmas yada o 
	nick iin doru ifenin belirtilmi olmas gerekir.

NICK_HELP_GHOST
	Kullanm: GHOST nick [ifre]
	
	Asl kalan nickinizin balantsn koparr. Asl kalan nick 
	aslnda hayalet nicktir fakat IRC server bunun hala hatta
	olduunu sanar. Genellikle bu durum bilgisayarnzn kmesi 
	yada modem balantnzn serverdayken kopmas durumunda 
	gerekleir.
	
	GHOST komutunu bir nick zerinde kullanabilmek iin o an
	/WHOIS inizdeki adresin o nickin access listesinde olmas, 
	o nick iin doru ifrenin belirtilmi olmas yada o nickin
	grubundaki baka bir nickin tantlm olmas gerekir.

NICK_HELP_INFO
	Kullanm: INFO nick [ALL]
	
	Belirtilen nick hakknda o nickin sahibi, son grld adres ve 
	zaman, ve nickin zellikleri gibi bilgiler verir. Eer nick 
	hakknda bilgi alrken o nickin sahibi sizseniz ve tantmsanz 
	ALL parametresini kullandnzda bilgiler gizli olsa bile o 
	nick hakkndaki tm bilgiler grnr.

NICK_HELP_LIST
	Kullanm: LIST model
	
	nick!user@host formatnda, belirtilen modeli ieren
	tm kaytl nickleri listeler. PRIVATE zellii aktif olan
	nickler listelenmez.
	
	rnekler:
	
	    LIST *!aliuser@ixir.com
	        identi aliuser@ixir.com olan tm kaytl nickleri 
	        listeler.
	
	    LIST *Bot*!*@*
	        Bot kelimesini ieren tm kaytl nickleri listeler.
	       (byk kk harf hassasiyeti vardr.)
	
	    LIST *!*@*.ixir.com
	        ixir.com domainine sahip tm kaytl nickleri listeler.

NICK_HELP_ALIST
	Syntax: ALIST [level]
	
	Lists all channels you have access on. Optionally, you can specify
	a level in XOP or ACCESS format. The resulting list will only 
	include channels where you have the given level of access.

	Examples:
	    ALIST Founder
	        Lists all channels where you have Founder
	    access.

	    ALIST AOP
	        Lists all channels where you have AOP access 
	    or greater.

	    ALIST 10
	        Lists all channels where you have level 10 
	    access or greater.
	
	Channels that have the NOEXPIRE option set will be prefixed by 
	an exclamation mark.
	
NICK_HELP_GLIST
	Syntax: GLIST
	
	Lists all nicks in your group.

NICK_HELP_STATUS
	Kullanm: STATUS nick...
	
	Nickin kullanc tarafndan nickin sahibi olarak tantlp 
	tantlmadn gsterir. Cevap u formattadr:
	
	    nick durum-kodu
	
	nick komutta yazlan nick, ve durum-kodu da
	aadakilerden biridir:
	
	    0 - Byle bir kullanc bal deil veya nick 
	           kaytl deil
	    1 - Kullanc nickin sahibi olarak tantlmam
	    2 - Kullanc nickin sahibi olarak access listesinden 
	           tantlm
	    3 - Kullanc nickin sahibi olarak ifreyle tantlm
	
	Her komutta en fazla 16 nick iin cevap verilir; gerisi 
	yoksaylr. Eer bir nick belirtilmemise cevap olarak bir
	hata mesaj gelmez.
	
NICK_HELP_SENDPASS
	Kullanm: SENDPASS nick
	
	Belirtilen nickin ifresini nickin kaytlarnda belirtilmi 
	email adresine gnderir.
	
	Baz networklerde sadece IRC operatrleri kullanabilir.
	
	Eer ifreleme(encryption) aktifse bu komut devre d kalr.

NICK_SERVADMIN_HELP
	
	Aadaki komutlar Servis adminleri kullanabilir:
	
	    GETPASS    Bir nickin ifresini renmek iindir
	                 (Sadece ifreleme(encryption) devre dysa)
	    FORBID     Bir nickin kullanlmasn yasaklar
	
	Servis adminleri herhangi bir nickin tantmasna gerek olmadan 
	kaydn silebilir(drop) ve herhangi bir nickin access listesini 
	grntleyebilir. (/msg %S ACCESS LIST nick).

NICK_SERVADMIN_HELP_LOGOUT
	Kullanm: LOGOUT [nick [REVALIDATE]]
	
	Parametre kullanlmazsa, IDENTIFY komutunun yapt 
	etkiyi tersine evirir, yani artk o nickin gerek sahibi
	olarak tannmamanz salar. Fakat sizden nickinizi tekrar
	identify etmeniz istenmez.
	
	Parametre kullanlrsada aynsn yapar ama buna ek olarak
	REVALIDATE belirtilirse servisler o kiiye nickini yeniden 
	identify etmesini syler. Servis adminlerinin Kullanmyla
	snrldr.

NICK_SERVADMIN_HELP_DROP
	Kullanm: DROP [nick]
	
	Parametreye gerek olmadan, %S veritabanndan nickinizi siler.
	
	Parametreyle, belirtilen bir nicki veritabanndan siler.
	Grubunuzda bulunan herhangi bir nicki zel ayrcalklara
	gerek olmadan silebilirsiniz. Bu ilemler Servis adminleri 
	tarafndan yaplabilir.

NICK_SERVADMIN_HELP_SET
	
	Servis adminleri ayrca NOEXPIRE zelliini ayarlayabilirler, 
	bylece hangi nicklerin zaman asimini urayp kaytlarnn 
	silinmeyeceini belirlerler.
	Ek olarak, Servis adminleri bu format kullanarak 
	SET nick zellik parametre herhangi bir nick iin 
	ifre girmeden ayar yapabilirler.

NICK_SERVADMIN_HELP_SET_NOEXPIRE
	Kullanm: SET [nick] NOEXPIRE {ON | OFF}
	
	Belirtilen nickin zaman asimina urayp uramayacan belirler.
	Bunu ON yapmak o nickin zaman asimina uramasn ve kaydnn 
	silinmesini engeller. Eer bir nick belirtilmezse no-expire
	parametresini komutu kullanann nickine ayarlar.
	
	Sadece Servis adminleri kullanabilir.

NICK_SERVADMIN_HELP_INFO
	
	Servis adminleri ALL parametresini herhangi bir nick iin 
	kullanabilirler.

NICK_SERVADMIN_HELP_LIST
	Kullanm: LIST model [FORBIDDEN] [NOEXPIRE]
	
	Belirtilen modele uyuan tm kaytl nickleri nick!user@host 
	formatnda listeler. PRIVATE zelli aktif olan kullanclar 
	sadece servis adminleri tarafndan grntlenir. NOEXPIRE 
	ayar olan nicklerde servis adminleri iin asl bir ! bulunur.
	
	Eer FORBIDDEN ve NOEXPIRE parametreleri verilmise, Sadece
	yasaklanm(forbidden) ve zaman asimi olmayan(noexpire) 
	nickler listelenir. Eer iki parametrede verilmise iki tip
	nicklerde listelenir. Bu zellikleri sadece Servis adminleri
	kullanabilir.
	
	rnekler:
	
	    LIST *!aliuser@ixir.com
	        identi aliuser@ixir.com olan tm kaytl nickler 
	        listelenir.
	
	    LIST *Bot*!*@*
	        simlerinde Bot yazan tm kaytl nickler listelenir
	        (kk byk harf hassasiyeti vardr).
	
	    LIST * NOEXPIRE
	        Zaman asimi olmayan tm kaytl nickler listelenir.

NICK_SERVADMIN_HELP_ALIST
	Syntax: ALIST [nickname] [level]
	
	With no parameters, lists channels you have access on. With
	one parameter, lists channels that nickname has access 
	on. With two parameters lists channels that nickname has 
	level access or greater on.

	This use limited to Services admins.

NICK_SERVADMIN_HELP_GLIST
	Syntax: GLIST [nickname]
	
	Without a parameter, lists all nicknames that are in
	your group.
	
	With a parameter, lists all nicknames that are in the
	group of the given nick.
	This use limited to Services admins.

NICK_SERVADMIN_HELP_GETPASS
	Kullanm: GETPASS nick
	
	Belirtilen nickin ifresini syler. Unutmaynki bu komutun
	her kullanlnda , kullanlan nick ve komutu kullanan
	kii kaydedilerek WALLOPS/GLOBOPS olarak gnderilir.
	
	Sadece Servis adminleri tarafndan kullanlr.
	
	(Bu komut ifreleme(encryption) aktif olduu zaman devre ddr.)

NICK_SERVADMIN_HELP_GETEMAIL
	Syntax: GETEMAIL user@emailhost

	Returns the matching nicks that used given email. Note that
	you can not use wildcards for either user or emailhost. Whenever
	this command is used, a message including the person who issued
	the command and the email it was used on will be logged.

	Limited to Services admins.

NICK_SERVADMIN_HELP_FORBID
	Kullanm: FORBID nick [sebep]
	
	Belirtilen nickin kullanlmasn ve kayt edilmesini engeller.
	Nick drop edilerek iptal edilebilir.
	
	Baz networklerde, sebep yazlmas gereklidir.
	
	Sadece Servis adminleri tarafndan kullanlr.

###########################################################################
#
# ChanServ help messages
#
###########################################################################

CHAN_HELP
	%S kanallarnz kayt etmenizi ve kontrol etmenizi
	salar. %S kt niyetli kullanclarn kanallar ele 
	geirmelerini(takeover), kanalda kimlerin op olacan sizin
	tarafnzdan beliryerek engeller. Mevcut komutlar aada 
	listelenmitir; onlar kullanmak iin /msg %S komut
	yazn. Belirli bir komut hakknda daha fazla bilgi iin,
	/msg %S HELP komut yazn.
	
	    REGISTER      Kanal kaydeder
	    IDENTIFY      ifreyle sizi kanaln sahibi olarak tanmlar
	    SET           Kanal zelliklerini ve bilgisini ayarlar
	    AOP           AOP listesini dzenler
	    SOP           SOP listesini dzenler
	    ACCESS        Ayrcalkl kullanclar belirler deitirir
	    LEVELS        Access seviyelerini isteinize gre dzenler
	    AKICK         Autokick listesini dzenler
	    DROP          Kanal kaydn siler
	    SENDPASS      Kayp ifrelerinizi syler
	
	Dier komutlar: BAN, CLEAR, DEOP, DEVOICE, GETKEY, INFO, 
	                INVITE, KICK, LIST, LOGOUT, OP, TOPIC, 
	                UNBAN, VOICE, VOP
	                
CHAN_HELP_UNREAL
	
	Bu networkte bu komutlarda mevcuttur:
	    DEHALFOP, DEOWNER, DEPROTECT, HALFOP, HOP, OWNER,
	    PROTECT

CHAN_HELP_ULTIMATE
	
	Bu networkte bu komutlarda mevcuttur:
	    DEHALFOP, HALFOP, HOP

CHAN_HELP_ULTIMATE3
	
	Bu networkte bu komutlarda mevcuttur:
	    DEHALFOP, HALFOP, HOP, ADMIN, DEADMIN

CHAN_HELP_EXPIRES
	
	Unutmayn %d gn kullanlmayan kanallarn
	(kanaln access listesinde olan bir kimse o sre iinde 
	kanala girmezse ) kayd silinir.

CHAN_HELP_REGISTER
	Kullanm: REGISTER kanalad ifre aklama
	
	%S veritabanna belirtilen kanal ekler yani kaydeder.
	Bu komutu kullanabilmek iin kayt etmek istediiniz kanal
	nceden kaytl olmamal ve kanalda op olmalsnz. ifre
	kanal zelliklerinde deiiklikler yapmanz iin ilerde
	lazm olacaktr. Son parametre kanaln genel bir tanmdr
	ve mutlaka belirtilmelidir.
	
	Kanal kayt ettiiniz zaman, kanaln "founder" ' olursunuz.
	Kanal founder kanaln tm zelliklerini deitirme yetkisine 
	sahip olan kiidir; %S kanala girdiiniz zaman size
	otomatik kanal opu hakkn verecektir. Kanal opu hakkn
	bakalarnada vermek iin gerekli bilgiyi ACCESS komutunun
	yardmna bakarak alabilirsiniz (/msg %S HELP ACCESS).
	
	NOT: Bir kanal kaydedebilmek iin, nce nickinizi kaydetmelisiniz.
	Eer kaydetmediyseniz /msg %s HELP yazarak nasl yapacanz
	hakknda bilgi alabilirsiniz.

CHAN_HELP_IDENTIFY
	Kullanm: IDENTIFY kanalad ifre
	
	%S tarafndan kanaln founder olarak tannmanz salar.
	Birok komutu kullanabilmek iin kendinizi kanaln sahibi
	(founder) olarak bu komutu kullanarak tantmanz gerekir.
	ifre kanal kaydederken  kullandnz ifreyle ayndr.

CHAN_HELP_LOGOUT
	Kullanm: LOGOUT kanalad nick
	
	Bu komut belirtilen nickin artk belirtilen kanal iin
	tanmlanmamasn salar.
	
	Eer kanaln founder iseniz istediiniz kii zerinde,
	deilseniz kendi zerinizde bu komutu kullanabilirsiniz.

CHAN_HELP_DROP
	Kullanm: DROP kanalad
	
	Kanaln kaydn siler.  Sadece kanal founder tarafndan
	kullanlabilir ve o kiinin nce IDENTIFY komutunu kullanarak
	kanaln sahibi olduunu belirtmesi gerekir.

CHAN_HELP_SET
	Kullanm: SET kanalad zellik parametre
	
	Kanal foundernn eitli kanal zelliklerini ve dier bilgileri
	ayarlamasn salar.
	
	Mevcut zellikler:
	
	    FOUNDER       Kanal foundern belirler
	    SUCCESSOR     Kanal successorn belirler
	    PASSWORD      Founder ifresini belirler
	    DESC          Kanal aklamasn belirler
	    URL           Kanala bir URL adresini ilikilendirir
	    EMAIL         Kanala bir E-mail adresini ilikilendirir
	    ENTRYMSG      Kanala giren kullanclara gnderilecek mesaj
	                   belirler
	    BANTYPE       Servislerin kanalda ne tip ban koyacan belirler
	    KEEPTOPIC     Kanalda kimse olmasa bile topii hatrlar
	    TOPICLOCK     Topic sadece SET TOPIC komutuyla deitirilir
	    MLOCK         Kanal modlarn kitler yada aar
	    PRIVATE       LIST komutuyla kanal listelenmez
	    RESTRICTED    Kanala izinli giri gerektirir
	    SECURE        %S gvenlik zelliklerini aktifletirir
	    SECUREOPS     Kanal opu durumunun sk kontroln salar
	    SECUREFOUNDER Kanal founder durumunun sk kontroln salar
	    SIGNKICK      KICK komutuyla yaplan atmalar iaretler
	    OPNOTICE      OP/DEOP komutlar kullanldnda mesaj yollar
	    PEACE         kritik komutlarin kullanilmasini engeller
	    XOP           Ayricalik sistemleri arasinda geisi saglar

	
	Belirli bir zellik hakknda daha fazla bilgi iin
	/msg %S HELP zellik yazn.

CHAN_HELP_SET_FOUNDER
	Kullanm: SET kanalad FOUNDER nick
	
	Kanal foundern deitirir.  Yeni nickin kaytl 
	olmas gereklidir.

CHAN_HELP_SET_SUCCESSOR
	Kullanm: SET kanalad SUCCESSOR nick
	
	Kanal successorn belirler, deitirir. Eer bir kanaln
	foundernn nicki zaman amna urayp kayd silinirse
	yada kanal kaytlyken nickin kayd bilerek silinirse(drop)
	successor kanaln yeni founder durumuna gelir. Fakat eer
	successornda ok fazla kaytl kanal varsa(%d) veya kanal
	iin bir successor belirtilmemise kanaln kayd silinir(drop).
	Komutta belirtilen nickin kaytl olmas gereklidir.

CHAN_HELP_SET_PASSWORD
	Kullanm: SET kanalad PASSWORD ifre
	
	Kanal foundernn ifresini deitirir.

CHAN_HELP_SET_DESC
	Kullanm: SET kanalad DESC aklama
	
	LIST ve INFO komutlar kullanldnda gzkecek kanal 
	aklamasn belirler.

CHAN_HELP_SET_URL
	Kullanm: SET kanalad URL [urladresi]
	
	Belirtilen URL adresini kanal ile ilikilendirir. Bu URL 
	adresi birisi kanal hakknda bilgi almak iin INFO 
	komutunu kullandnda gzkr. Eer urladresi parametresi
	belirtilmezse kanal iin nceden belirtilen URL adresi
	silinir.

CHAN_HELP_SET_EMAIL
	Kullanm: SET kanalad EMAIL [emailadresi]
	
	Belirtilen E-mail adresini kanal ile ilikilendirir.Bu E-mail 
	adresi birisi kanal hakknda bilgi almak iin INFO komutunu 
	kullandnda gzkr. Eer emailadresi parametresi
	belirtilmezse kanal iin nceden belirtilen E-mail adresi
	silinir.

CHAN_HELP_SET_ENTRYMSG
	Kullanm: SET kanalad ENTRYMSG [mesaj]
	
	Kanala giren kullanclara notice eklinde gnderilecek
	mesaj belirler.  Eer mesaj parametresi belirtilmezse
	giren kullancya bir mesaj gnderilmez.

CHAN_HELP_SET_BANTYPE
	Kullanm: SET kanalad BANTYPE bantipi
	
	Servislerin birini kanaldan banlarken kullanaca ban 
	tipini belirler.
	
	bantipi 0 ile 3 arasnda bir saydr ve anlamlar udur:
	
	0: *!user@host formatnda ban iin
	1: *!*user@host formatnda ban iin
	2: *!*@host formatnda ban iin
	3: *!*user@*.domain formatnda ban iin

CHAN_HELP_SET_KEEPTOPIC
	Kullanm: SET kanalad KEEPTOPIC {ON | OFF}
	
	Bir kanal iin topic hatrlamay aktifletirir yada kapatr.
	topic hatrlama aktifse kanal kapansa bile kanal topic i
	%S tarafndan hatrlanr ve birisi kanala girdiinde bu
	topic geerli olur.

CHAN_HELP_SET_TOPICLOCK
	Kullanm: SET kanalad TOPICLOCK {ON | OFF}
	
	Bir kanal iin topic kilidini aktifletirir yada kapatr.
	topic kilidi aktifse, %S SET TOPIC komutunun
	dnda kanal topic inin deitirilmesine izin vermez.

CHAN_HELP_SET_MLOCK
	Kullanm: SET kanalad MLOCK modlar
	
	Bir kanal iin mod-kilidini aktifletirir. %S belirlediiniz
	modlarn her zaman ak yada kapal olacan ayarlar.

	+ ile belirtilen modlar aik olarak, - ile belirtilen modlar
	kapali olarak kitlenir.
	
	Dikkat:  Eer ikinci rnekteki gibi bir mod kilidi koyarsanz,
	kanaln RESTRICTED zelliinide aktifletirmeniz gerekir
	(HELP SET RESTRICTED e bakn), yoksa kanal boken ilk
	giren kii kanal key ini(anahtar) grebilir!
	
	rnekler:
	
	    SET #kanalad MLOCK +nt-iklps
	        n ve t modlarn hep ak, i, k, l, p, ve s modlarn hep
	        ak olarak ayarlar. m modu ise istenildii gibi ayarlanabilir
	        ak yada kapal.
	
	    SET #kanalad MLOCK +knst-ilmp anahtar
	        k, n, s, ve t modlar hep ak, ve i, l, m, ve p modlar
	        hep kapal. Ayrca kanal anahtarn belirler ve hep o 
	        anahtar olmasn salar.
	
	    SET #kanalad MLOCK +
	        Mod kilidini kaldrr; ve tm kanal modlarn alp 
	        kapanacak ekilde serbest brakr.

CHAN_HELP_SET_PEACE
	Kullanimi: SET kanaladi PEACE {ON | OFF}
	
	Bir kanalin peace zelligini aar veya kapatir.
	peace zelligi ayarlandiginda, hic kimse seviyesi kendinden
	yksek veya esit olanlari atamaz, banlayamaz veya %S
	seviyesini degistiremez.

CHAN_HELP_SET_PRIVATE
	Kullanm: SET kanalad PRIVATE {ON | OFF}
	
	Bir kanal iin private zelliini aar kapatr. private zellii
	aktifse, /msg %S LIST komutuyla kanal listelenemez.

CHAN_HELP_SET_RESTRICTED
	Kullanm: SET kanalad RESTRICTED {ON | OFF}
	
	Bir kanal iin izinli giri zelliini aar yada kapatr.
	izinli giri zellii aktifse, kanal opu zellii olmayan
	kullanclar(negatif access seviyesi olanlar, secure ops
	zellii aktif olanlar, ve access listesinde olmayan 
	kullanclar) kanaldan atlp banlanrlar.

CHAN_HELP_SET_SECURE
	Kullanm: SET kanalad SECURE {ON | OFF}
	
	Bir kanal iin %S'n gvenlik zelliklerini aar veya 
	kapatr. SECURE zellii aktifse, sadece nicki kaytl
	ve %s ile nickini tantm kullanclar kanalda access 
	alabilirler ve access listesindeki statlerini
	alabilirler.(mesela op olabilirler)

CHAN_HELP_SET_SECUREOPS
	Kullanm: SET kanalad SECUREOPS {ON | OFF}
	
	Bir kanal iin gvenli op zelliini aar veya kapatr.
	gvenli op zellii aktifse, access listesinde olmayan
	kullanclar kanalda op olamazlar.

CHAN_HELP_SET_SECUREFOUNDER
	Kullanm: SET kanalad SECUREFOUNDER {ON | OFF}
	
	Bir kanal iin gvenli founder zelliini aar yada kapatr.
	gvenli founder zellii aktifse, sadece gerek founder 
	kanaln kaydn silebilir, kanal ifresini deitirebilir yada
	kanal foundern ve successor n deitirebilir. Kanal 
	ifresiyle kendilerini %S'e kanal founder olarak tantan 
	ama nicki foundern nicki olmayanlar bu komutlar kullanamazlar.

CHAN_HELP_SET_SIGNKICK
	Kullanm: SET kanalad SIGNKICK {ON | LEVEL | OFF}
	
	Bir kanal iin iaretli atmay aar yada kapatr.
	SIGNKICK ayarland zaman, %S KICK
	komutuyla yaplan atmalarda komutu kullanan kiinin
	nicki atma sebebinde yer alr.
	
	Eer LEVEL parametresini kullanrsanz, seviyesi
	SIGNKICK seviyesine eit yada fazla olanlarn yapt
	atmalarda atann nicki sebepte gzkmez. Daha fazla
	bilgi iin /msg %S HELP LEVELS yazn.

CHAN_HELP_SET_XOP
	Kullanimi: SET kanaladi XOP {ON | OFF}
	
	Bir kanalin xOP sistemini aar veya kapatir. XOP
	ayarlandigi zaman, AOP/SOP/VOP komutlariyla
	yetkileri dzenlemelisiniz, aksi takdirde ACCESS
	komutunu kullanmalisiniz.
	
	Teknik Not: Access sisteminden xOP sisteminde
	getiginizde seviye ayarlariniz degistirilir, bu
	yzden tekrar access sistemine getiginizde ayni
	ayarlari bulamazsiniz! 
	
	Access sisteminden xOP sistemine getiginizde listedeki
	ayricaliklari kontrol edip listenizdeki nicklerin dogru
	xOP ayarlarinda bulundugunu kontrol edin, nk sistemin
	tahmin etmesi her zaman dogru olmayabilir... Eger LEVELS
	komutuyla komut seviye ayarlarini degistirdiyseniz xOP
	sistemini kullanmaniz nerilmez.
	
	Bunlarin disinda xOP sisteminden access sistemine gemek
	bir problem ikarmaz.

CHAN_HELP_SET_OPNOTICE
	Kullanm: SET kanalad OPNOTICE {ON | OFF}
	
	Bir kanal iin op-notu zelliini aar yada kapatr.
	op-notu zellii aktifse, %S kanala bir kullanc 
	zerinde OP veya DEOP komutlarnn kullanldn
	belirten bir mesaj gnderir.

CHAN_HELP_AOP
	Kullanm: AOP kanaladi ADD nick
	           AOP kanaladi DEL {nick | kayit-no | liste}
	           AOP kanaladi LIST [mask | liste]
	           AOP kanaladi CLEAR
	
	Bir kanalin AOP (otoop) listesini dzenler. AOP listesi
	o kanalda kullaniciya otomatik olarak op olma, gerekirse 
	kendi banlarini kaldirma veya davet edilme, giriste karsilama
	mesajlarini grntleme, vs yetkilerini verir.
	
	AOP ADD komutu belirtilen nicki AOP listesine ekler.
	
	AOP DEL komutu belirtilen nicki AOP listesinden siler.  
	Eger kayit numaralari belirtilirse, o numaralara ait nickler
	silinir. (Asagidaki rnegi inceleyin.)
	
	AOP LIST komutu AOP listesini gsterir. Eger bir hostmask
	belirtilmisse, sadece onla uyusan kayitlari gsterir. Eger 
	kayit numaralari belirtilmisse o numaralarla uyusan kayitlari
	gsterir; rnegin:

	   AOP #kanal LIST 2-5,7-9
	      2 den 5 e ve 7 den 9 a kadar olan kayitlari gsterir.
	      
	AOP CLEAR komutu AOP listesindeki tm kayitlari siler.
	
	AOP ADD ve AOP DEL komutlarini kanal SOP lari veya st
	kullanabilir. AOP CLEAR komutunu ise sadece kanal founderi
	kullanabilir. Ayrica, AOP listesindeki herhangi biri AOP LIST 
	komutunu kullanabilir.
	
	Bu komutu kanaliniz iin devre disi birakabilirsiniz. O zaman
	access komutlarini kullanmalisiniz. Access komutlari hakkinda
	bilgi almak iin  /msg %S HELP ACCESS yazin. 
	Access ile xOP arasinda geis yapabilmek iin gerekli bilgilere
	/msg %S HELP SET XOP yazarak ulasabilirsiniz.

CHAN_HELP_HOP
	Kullanm: HOP kanaladi ADD nick
	           HOP kanaladi DEL {nick | kayit-no | liste}
	           HOP kanaladi LIST [mask | liste]
	           HOP kanaladi CLEAR
	
	Bir kanalin HOP (HalfOP) listesini dzenler. HOP
	listesinde bulunan bir kisi kanalda otomatik olarak
	halfop olur.
	
	HOP ADD komutu belirtilen nicki HOP listesine ekler.
	
	HOP DEL komutu belirtilen nicki HOP listesinden siler.
	Eger kayit numaralari listesi belirtilirse, bu kayitlar
	silinir. (Asagidaki rnegi inceleyin.)
	
	HOP LIST komutu HOP listesini gsterir. Eger bir hostmask
	belirtilmisse, o hostmask la uyusan kayitlar gsterilir.
	Eger kayit numaralari listesi belirtilmisse, o numaralardaki
	nickler gsterilir; rnegin:

	   HOP #kanaladi LIST 2-5,7-9
	       2 den 5 e ve 7 den 9 a kadar olan kayitlari gsterir.
	      
	HOP CLEAR komutu HOP listesindeki tm kayitlari temziler.
	
	HOP ADD, HOP DEL ve HOP LIST komutlarini AOP lar ve st
	HOP CLEAR komutunu ise sadece founder kullanabilir.
	
	Bu komutu kanaliniz iin devre disi birakabilirsiniz. O zaman
	access komutlarini kullanmalisiniz. Access komutlari hakkinda
	bilgi almak iin  /msg %S HELP ACCESS yazin. 
	Access ile xOP arasinda geis yapabilmek iin gerekli bilgilere
	/msg %S HELP SET XOP yazarak ulasabilirsiniz.

CHAN_HELP_SOP
	Kullanm: SOP kanaladi ADD nick
	           SOP kanaladi DEL {nick | kayit-no | liste}
	           SOP kanaladi LIST [mask | liste]
	           SOP kanaladi CLEAR
	
	Bir kanalin SOP (SuperOP) listesini dzenler. SOP
	listesindekiler AOP larin sahip oldugu tm yetkilere 
	sahiptir. Ayrica AutoKick ve BadWords listesini
	dzenleyebilirler, kanal memolarini okuyabilirler, vs.
	
	SOP ADD komutu belirtilen nicki SOP listesine ekler.
	
	SOP DEL komutu belirtilen nicki SOP listesinden siler.
	Eger kayit numaralari listesi belirtilmisse, bu kayitlar
	silinir. (Asagidaki rnegi inceleyin.)
	
	SOP LIST komutu SOP listesini grntler. Eger bir
	hostmask belirtilmisse o hostmaskla uyusan kayitlar
	gsterilir. Eger kayit numaralari listesi belirtilmisse
	o numaralardaki nickler gsterilir; rnegin:

	   SOP #kanaladi LIST 2-5,7-9
	      2 den 5 e ve 7 den 9 a kadar olan kayitlar gsterilir.
	      
	SOP CLEAR komutu SOP listesindeki tm kayitlari temizler.
	
	SOP ADD, SOP DEL ve SOP CLEAR komutlarini sadece kanal
	founderi kullanabilir. Ama AOP listesindeki herhangi biri
	SOP LIST komutunu kullanabilir.
	
	Bu komutu kanaliniz iin devre disi birakabilirsiniz. O zaman
	access komutlarini kullanmalisiniz. Access komutlari hakkinda
	bilgi almak iin  /msg %S HELP ACCESS yazin. 
	Access ile xOP arasinda geis yapabilmek iin gerekli bilgilere
	/msg %S HELP SET XOP yazarak ulasabilirsiniz.

CHAN_HELP_VOP
	Kullanm: VOP kanaladi ADD nick
	           VOP kanaladi DEL {nick | kayit-no | liste}
	           VOP kanaladi LIST [mask | liste]
	           VOP kanaladi CLEAR
	
	Bir kanalin VOP (otovoice) listesini dzenler. VOP
	listesindekiler kanalda otomatik olarak voice alirlar.
	
	VOP ADD komutu belirtilen nicki VOP listesine ekler.
	
	VOP DEL komutu belirtilen nicki VOP listesindene siler.
	Eger kayit numaralari listesi belirtilmisse, o kayitlar
	silinir. (Asagidaki rnegi inceleyin.)
	
	VOP LIST komutu VOP listesini grntler. Eger bir
	hostmask belirtilmisse o hostmaskla uyusan kayitlar
	listelenir. Eger kayit numaralari listesi belirtilmisse
	o numaralardaki nickler gsterilir; rnegin:

	   VOP #kanaladi LIST 2-5,7-9
	      2 den 5 e ve 7 den 9 a kadar olan kayitlar gsterilir.
	      
	VOP CLEAR komutu VOP listesindeki tm kayitlari temizler.
	
	VOP ADD, VOP DEL ve VOP LIST komutlarini AOP lar ve st,
	VOP CLEAR komutunu ise sadece founder kullanabilir.
	
	Bu komutu kanaliniz iin devre disi birakabilirsiniz. O zaman
	access komutlarini kullanmalisiniz. Access komutlari hakkinda
	bilgi almak iin  /msg %S HELP ACCESS yazin. 
	Access ile xOP arasinda geis yapabilmek iin gerekli bilgilere
	/msg %S HELP SET XOP yazarak ulasabilirsiniz.

CHAN_HELP_ACCESS
	Kullanm:  ACCESS kanalad ADD nick seviye
	            ACCESS kanalad DEL {nick | kayt-no | liste}
	            ACCESS kanalad LIST [mask | liste]
	            ACCESS kanalad CLEAR
	
	Bir kanal iin access listesi oluturur. Access listesi
	kanalda kimlerin op olacan ve %S komutlarna
	kimlerin eriimi olacan belirtir. Deiik access
	seviyeleri deiik komutlara eriim salar. Ayrntl bilgi
	iin /msg %S HELP ACCESS LEVELS yazn. Access
	listesinde olmayan kullanclarn seviyesi 0 dr.
	
	ACCESS ADD komutu belirtilen nicki belirtilen seviyeden
	access listesine ekler; eer o kii zaten access listesindeyse
	seviyesini belirtilen seviyeyle deitirir. Belirtilen seviye 
	komutu kullanan kiinin seviyesinden az olmaldr, eer 
	belirtilen nick zaten access listesindeyse komutu kullanan 
	kiinin access seviyesi onunkinden byk olmaldr.
	
	ACCESS DEL komutu belirtilen nicki access listesinden siler.
	eer kayt numaras belirtilmise o kayt numaras olan kiinin 
	accessi silinir.(Aadaki LIST iin verilen rnee bakn.)
	
	ACCESS LIST komutu access listesini grntler. Eer * l 
	bir mask belirtilirse o maskla uyuan kiiler listelenir. 
	Eer kayt numaras listesi belirtilirse o kiiler listelenir.
	rnein:
	
	   ACCESS #kanalad LIST 2-5,7-9
	      2'den 5'e ve 7'den 9'a kadar olan access kaytlar
	      listelenir.
	      
	ACCESS CLEAR komutu tm access listesini temizler.

CHAN_HELP_ACCESS_LEVELS
	Kullanc access seviyeleri
	
	Varsaylan olarak, aadaki access seviyeleri tanmlanmtr:
	
	   Founder   %S fonksiyonlarna tam eriim hakk vardr.
	                     kanal girer girmez op olur. Unutmaynki
	                     sadece bir kii founder olma hakkna 
	                     sahiptir. (ACCESS komutuyla verilemez.)
	        10   AKICK komutuna eriimi vardr; otomatik oplanr.
	         5   Otomatik oplanr.
	         3   Otomatik voice lanr.
	         0   Bir zellii yoktur; dier oplar tarafndan
	                     oplanabilir (gvenli-op kapalysa).
	        <0   Kanalda oplanamaz.
	
	Bu seviyeler LEVELS komutu kullanlarak deitirilebilir, veya
	yenileri eklenebilir, bilgi iin /msg %S HELP LEVELS 
	yazn.

CHAN_HELP_AKICK
	Kullanm:  AKICK kanalad ADD mask [sebep]
	            AKICK kanaladi STICK mask
	            AKICK kanaladi UNSTICK mask
	            AKICK kanalad DEL mask
	            AKICK kanalad LIST [mask]
	            AKICK kanalad VIEW [mask]
	            AKICK kanalad ENFORCE
	            AKICK kanalad CLEAR
	
	Bir kanal iin AutoKick listesi oluturur.  Eer Akick 
	listesindeki bir kullanc kanala girmeye alrsa, Bu
	kii %S tarafndan banlanr ve kanaldan atlr.
	
	AKICK ADD komutu belirtilen nicki yada mask Akick
	listesine ekler. Eer komutla beraber birde sebep
	belirtilmise bu sebep kullanc kanaldan atlrken
	kullanlr; eer kullanlmazsa geerli sebep olan
	"You have been banned from the channel" kullanlr.

	AKICK STICK komutu belirtilen maski kalici olarak
	banlar. Eger biri bani kaldirmaya alisirsa, %S
	otomatik olarak yeniden banlar. Bunu kayitli nickler
	iin kullanamazsiniz.
	
	AKICK UNSTICK komutu AKICK STICK komutunun etkilerini
	iptal eder, bylece bani kaldirabilirsiniz.
	
	AKICK DEL komutu belirtilen nicki yada mask Akick
	listesinden siler. Fakat bu komutla nceden Akick 
	listesindeyken banlanm birinin ban manuel olarak
	alana kadar kalkmaz.
	
	AKICK LIST komutu Akick listesinde kimlerin olduunu
	listeler, yada opsiyonel olarak belirtilen maskla uyuan 
	Akick listesindeki kullanclar listeler.
	
	AKICK VIEW komutu AKICK LIST komutunun daha aklayc
	versiyonudur.
	
	AKICK ENFORCE komutu %S'n mevcut akick listesinde bulunan 
	masklara sahip kullanclar kanaldan atmasn salar.
	
	AKICK CLEAR komutu akick listesinde bulunan tm kaytlar
	siler.

CHAN_HELP_LEVELS
	Kullanm:  LEVELS kanalad SET tip seviye
	            LEVELS kanalad {DIS | DISABLE} tip
	            LEVELS kanalad LIST
	            LEVELS kanalad RESET
	
	LEVELS komutu bir kanaldaki access seviyelerinin iyi
	kontroln salar. Bu komutla, %S'n birok
	fonksiyonu iin gereken access seviyelerini
	belirleyebilirsiniz. (SET FOUNDER ve SET PASSWORD
	komutlar ve bu komut sadece kanal founder tarafndan
	kullanlabilir.)
	
	LEVELS SET komutu bir fonksiyon yada fonksiyon gruplar iin
	access seviyelerini deitirmeye yarar. LEVELS DISABLE (veya
	ksaca DIS) otomatik bir zellii kapatr yada founderdan 
	bakasnn kullanmasn engeller. LEVELS LIST komutu 
	fonksiyonlar yada fonksiyon gruplar iin mevcut seviyeleri 
	gsterir. LEVELS RESET komutu seviyeleri varsaylan deerlerine
	geri evirir. (HELP ACCESS LEVELS e bakn).
	
	Seviyeleri ayarlanabilecek fonksiyonlar iin, HELP LEVELS DESC e 
	bakn.

CHAN_HELP_LEVELS_DESC
	Aada seviyeleri deitirilebilecek  fonksiyonlar listelidir.
	Dikkat edilirse AUTODEOP ve NOJOIN deerleri maximum, dierleri
	minimum seviyelerdir.

CHAN_HELP_LEVELS_DESC_FORMAT
	    %-*s  %s

CHAN_HELP_INFO
	Kullanm: INFO kanalad [ALL]
	
	Belirtilen kaytl kanalla ilgili bilgiler sunar. Bu 
	bilgilerin ieriinde kanaln founder, kayt zaman,
	son kullanld zaman, aklamas, ve varsa mod kilidi
	bulunur. Eer kanaln founder olarak kendinizi 
	tantmsanz ve ALL parametresini belirtmiseniz
	giri mesaj ve successor hakkndada bilgi alabilirsiniz.

	Varsayilan olarak, ALL seenegini founderlar kullanabilir.

CHAN_HELP_LIST
	Kullanm: LIST model
	
	Belirtilen modelle uyuan tm kaytl kanallar listeler.
	(PRIVATE zellii aktif olan kanallar listelenmez.)

CHAN_HELP_OP
	Kullanm: OP [#kanalad [nick]]
	
	Belirtilen nicki kanalda oplar. Eer nick belirtilmemise,
	kendinizi oplarsnz. Eer kanal ve nick belirtilmemise,
	bulunduunuz tm kanalda sizi oplar, tabi eer op accessiniz
	ve bu komutu kullanmaya yetkiniz varsa.
	
	Varsaylan olarak, AOP lar ile access seviyesi 5 ve zeri
	olanlar kullanabilir.

CHAN_HELP_DEOP
	Kullanm: DEOP [#kanalad [nick]]
	
	Belirtilen nicki kanalda deoplar. Eer nick belirtilmemise,
	kendinizi deoplarsnz. Eer nick ve kanal belirtilmemise,
	bulunduunuz tm kanallarda sizi deoplar, tabi eer bu komutu 
	kullanmaya yetkiniz varsa.
	
	Varsaylan olarak, AOP lar veya access seviyesi 5 ve zeri
	olanlar kullanabilir.

CHAN_HELP_VOICE
	Kullanm: VOICE [#kanalad [nick]]
	
	Belirtilen nicke kanalda voice verir. Eer nick belirtilmemise,
	size voice verir. Eer kanal ve nick belirtilmemise, size
	bulunduunuz tm kanallarda voice verir, tabi eer accessiniz ve
	bu komutu kullanmaya izniniz varsa.
	
	Varsaylan olarak, AOP lar ile access seviyesi 5 ve zeri olanlar
	kullanabilir, veya VOP lar ile access seviyesi 3 ve yukar olanlar
	kendilerine voice vermek iin kullanabilirler.

CHAN_HELP_DEVOICE
	Kullanm: DEVOICE [#kanalad [nick]]
	
	Belirtilen nicki kanalda devoice eder. Eer nick belirtilmemise,
	sizi devoice eder. Eer kanal ve nick belirtilmemise sizi,
	bulunduunuz tm kanallarda devoice eder, tabi eer accessiniz
	ve bu komutu kullanmaya izniniz varsa.
	
	Varsaylan olarak, AOP lar, access seviyesi 5 ve zeri olanlar
	kullanabilir, veya VOP lar ile access seviyesi 3 ve zeri olanlar
	kendilerini devoice etmek iin kullanabilirler.

CHAN_HELP_HALFOP
	Kullanm: HALFOP [#kanalad [nick]]
	
	Belirtilen nicki kanalda halfop(yarmop) yapar. Eer nick
	belirtilmemise, sizi halfop yapar. Eer nick ve kanal
	belirtilmemise, sizi bulunduunuz tm kanallarda halfop yapar,
	tabi eer bu komutu kullanmaya izniniz varsa.
	
	Varsaylan olarak, AOP lar ile access seviyesi 5 ve zeri
	olanlar kullanabilir, veya HOP lar ile access seviyesi 4 ve
	zeri olanlar kendilerini halfop yapmak iin kullanabilir.

CHAN_HELP_DEHALFOP
	Kullanm: DEHALFOP [#kanalad [nick]]
	
	Belirtilen nickin halfopunu(yarmop) alr. Eer nick
	belirtilmemise, sizin halfopunuz alr. Eer kanal ve nick 
	belirtilmemise, bulunduunuz tm kanallardan halfopunuzu
	alr, tabi eer bu komutu kullanmaya izniniz varsa.
	
	Varsaylan olarak, AOP lar veya 5 ve zeri access seviyesi
	olanlar kullanabilir, ayrica HOP lar veya access seviyesi
	4 ve zeri olanlar kendi halfoplarn alabilirler.

CHAN_HELP_PROTECT
	Kullanm: PROTECT [#kanalad [nick]]
	
	Belirtilen nicki kanalda korur. Eer nick belirtilmezse,
	sizi korur. Eer nick ve kanal belirtilmezse sizi bulunduunuz
	tm kanallarda koruyacaktr, tabi eer bu komutu kullanmaya
	izniniz varsa.
	
	Varsaylan olarak, founder kullanabilir, veya SOP lar ile access
	seviyesi 10 ve zeri olanlar kendilerinde kullanabilirler.

CHAN_HELP_DEPROTECT
	Kullanm: DEPROTECT [#kanalad [nick]]
	
	Belirtilen nickin korumasn kaldrr. Eer nick belirtilmemise,
	sizin korumanz kaldrr. Eer kanal ve nick belirtilmezse, 
	sizin bulunduunuz tm kanallardaki korumalarnz kaldrr, 
	tabi eer bu komutu kullanmaya izniniz varsa.
	
	Varsaylan olarak, founder kullanabilir, veya SOP lar ile
	access seviyesi 10 ve zeri olanlar kendilerinde kullanabilir.

CHAN_HELP_OWNER
	Kullanm: OWNER [#kanaladi]
	
	Belirtilen kanalda owner stats verilir. Eger kanal
	belirtilmemisse bulundugunuz tm kanallarda size owner
	stats verilir. Tabi bu yetkinizin olup olmamasina
	baglidir.
	
	Belirtilen kanal founderlarinin kullanma yetkisi vardir.

CHAN_HELP_DEOWNER
	Kullanm: DEOWNER [#kanaladi]
	
	Belirtilen kanaldaki owner statnz kaldirir. Eger
	kanal belirtilmezse bulundugunuz tm kanallardaki owner
	statnz kaldirir. Tabi bu yetkinizin olup olmamasina
	baglidir.
	
	Belirtilen kanal founderlarinin kullanma yetkisi vardir.

CHAN_HELP_INVITE
	Kullanm: INVITE kanalad
	
	%S'e sizi belirtilen kanala davet etmesini syler.

	Varsaylan olarak AOP lar ile access seviyesi 5 veya
	zeri olanlar kullanabilir.

CHAN_HELP_UNBAN
	Kullanm: UNBAN kanalad
	
	%S'e sizin kanala girmenizi engelleyen tm banlar kaldrmasn
	syler.

	Varsaylan olarak, AOP lar ile 5 ve zeri access seviyesi olanlar
	kullanabilir.

CHAN_HELP_KICK
	Kullanm: KICK [#kanalad [nick [sebep]]]
	
	Belirtilen nicki kanaldan atar. Eer nick belirtilmemise
	sizi atar. Eer kanal ve nick belirtilmemise, sizi 
	bulunduunuz tm kanallardan atar.
	
	Varsaylan olarak, AOP lar ile access seviyesi 5 ve zeri
	olanlar bu komutu kullanabilir.

CHAN_HELP_BAN
	Kullanm: BAN [#kanaladi [nick [sebep]]]
	
	Belirtilen nicki kanaldan banlar. Eger nick belirtilmezse
	sizi banlar. Eger nick ve kanal belirtilmezse sizi bulundugunuz
	tm kanallardan banlar.
	
	Varsayilan olarak, AOP larin veya 5. seviyeden access i olanlarin
	ve stnn kullanma yetkisi vardir.

CHAN_HELP_TOPIC
	Kullanm: TOPIC kanaladi [konu]
	
	%S belirtilen kanala belirtilen konuyu yazar.Eger
	topic belirtilmemisse, bos bir konu yazilir. Bu
	komut SET TOPICLOCK aktif oldugu zaman kullanislidir.
	Daha fazla bilgi iin /msg %S HELP SET TOPICLOCK
	yazin.
	
	Varsayilan olarak, founderin kullanma yetkisi vardir.

CHAN_HELP_CLEAR
	Kullanm: CLEAR kanalad neyi
	
	%S'e belirtilen ayar kaldrmasn syler. neyi
	unlardan biri olmaldr:
	
	     MODES    Kanal modlarn temizler. (r. i,k,l,m,n,p,s,t
	                   modlarn temizler).
	     BANS     Kanaldaki tm banlar kaldrr.
	     EXCEPTS  Clears all excepts on the channel.
	     OPS      Kanal opu statsnde olanlarn (mode +o)
	                  oplarn alr.
	     VOICES   Voice statsnde olanlarn (mode +v) voice larn
	                  alr.
	     USERS    Tm kullanclar kanaldan atar.
	
	Varsaylan olarak, founder tarafindan kullanilabilir.

CHAN_HELP_GETKEY
	Kullanm: GETKEY kanalad
	
	Belirtilen kanaln anahtarn syler. Bu komut botlar
	veya scriptler tarafndan kullanlmak zere tasarlanmtr,
	ve kts u ekildedir:
	
	KEY <kanalad> <anahtar>
	
	Eer bir anahtar yoksa anahtar ksmnda "NO KEY" olacaktr.

CHAN_HELP_SENDPASS
	Kullanm: SENDPASS kanalad
	
	Kanaln ifresini foundern nick kaytlarnda belirtilen
	e-mail adresine gnderir. Bu komut kanal ifresini 
	unutanlarn ok iine yarayacaktr.
	
	Baz networklerde IRC operatrlerinin Kullanmyla 
	snrlandrlm olabilir.
	
	Bu komut ifreleme(encryption) aktifken devre ddr.

CHAN_SERVADMIN_HELP
	
	Aadaki komutlar servis adminleri tarafndan kullanlabilir:
	
	    GETPASS    Bir kanaln founder ifresini ister
	                   (sadece ifreleme(encryption) devre dysa)
	    FORBID     Kanal kullanma kapatr
	    STATUS     Kullancnn kanaldaki access seviyesini syler
	    CLIST      Bir kullancnn founder olduu kanallar listeler
	
	Servis adminleri kanaln kaydn ifreyle tantmadan silebilir,
	ve access, Akick ve seviye ayarlarn grntleyebilirler.

CHAN_SERVADMIN_HELP_LOGOUT
	Kullanm: LOGOUT kanalad [nick]
	
	Bu komut belirtilen nickin artk belirtilen kanalda
	tanmlanmamasn salar.
	
	Eer kanal founder iseniz, istediiniz kiide, deilseniz
	sadece kendinizde bu komutu kullanabilirsiniz.
	
	Eer Servis admini iseniz, kanal founder olmanza gerek
	olmadan istediiniz kiide bu komutu kullanabilirsiniz.
	Hatta nick parametresini bo brakarak o kanalda kendini
	kanala tantm herkesi tanmlanmam yapabilirsiniz.

CHAN_SERVADMIN_HELP_DROP
	Kullanm: DROP kanalad
	
	Belirtilen kanaln kaydn siler. Sadece Servis adminleri
	kanal tantmadan kaydn silebilirler.

CHAN_SERVADMIN_HELP_SET
	
	Servis adminleri NOEXPIRE zelliini ayarlayarak istedikleri
	kanaln zaman amna uramasn engelleyebilirler.
	Ek olarak, Servis adminleri ifreyle kanal tantmaya gerek 
	olmadan bir kanaln tm zelliklerini ayarlayabilirler.

CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	Kullanm: SET kanalad NOEXPIRE {ON | OFF}
	
	Belirtilen kanaln zaman asimina urayp uramayacan 
	belirler. Bunu ON olarak ayarlamak kanaln zaman amna 
	uramasn engelleyecektir.
	
	Servis adminlerinin Kullanmyla snrldr.

CHAN_SERVADMIN_HELP_INFO
	
	Servis adminleri herhangi bir kanal iin ALL parametresini
	kullanabilirler.

CHAN_SERVADMIN_HELP_LIST
	Kullanm: LIST model [FORBIDDEN] [NOEXPIRE]
	
	Belirtilen modelle uyuan tm kaytl kanallar listeler.
	PRIVATE zellii ayarl kanallar sadece Servis adminleri
	tarafndan grntlenir. NOEXPIRE zellii olan kanallarn
	yannda Servis adminleri iin ! iareti bulunur.
	
	Eer FORBIDDEN veya NOEXPIRE zellikleri belirtilmise,
	sadece yasakl(FORBIDDEN) yada zaman amna(NOEXPIRE) 
	uramayacak kanallar listelenir. Eer her iki zellikte 
	belirtilmise, her iki tip kanalda listelenir. Bu komutlar
	Servis adminlerinin Kullanmyla snrldr.

CHAN_SERVADMIN_HELP_GETPASS
	Kullanm: GETPASS kanalad
	
	Belirtilen kanaln ifresini syler. Unutmaynki bu
	komut ne zaman kullanlsa, Komutu kullanann ve komutta
	kullanlan kanaln ad kaydedilir ve WALLOPS/GLOBOPS olarak
	gnderilir.
	
	Servis adminlerinin Kullanmyla snrldr.

CHAN_SERVADMIN_HELP_FORBID
	Kullanm: FORBID kanalad [sebep]
	
	Belirtilen kanaln birisi tarafndan kayt edilmesini veya 
	kullanlmasn nler. Kanal droplanarak iptal edilir.
	
	Baz networklerde sebep gereklidir.
	
	Servis adminlerinin Kullanmyla snrldr.

CHAN_SERVADMIN_HELP_SUSPEND
	Syntax: SUSPEND channel [reason]
	
	Disallows anyone from registering or using the given
	channel.  May be cancelled by using the UNSUSPEND
	command to preserve all previous channel data/settings.
	
	Reason may be required on certain networks.
	
	Limited to Services admins.

CHAN_SERVADMIN_HELP_UNSUSPEND
	Syntax: UNSUSPEND channel
	
	Releases a suspended channel. All data and settings
	are preserved from before the suspension.
	
	Limited to Services admins.

CHAN_SERVADMIN_HELP_STATUS
	Kullanm: STATUS kanalad nick
	
	Belirtilen nickin belirtilen kanaldaki access seviyesini
	syler. Cevabn format u ekildedir:
	
	    STATUS kanalad nick access-seviyesi
	
	Eer bir hata olursa, cevabun format yle olur:
	
	    STATUS ERROR hata-mesaj
	
	Servis adminlerinin Kullanmyla snrldr.

###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP
	%S kullanclarn birbirlerine veya kanallara(*) online 
	olmasalar bile mesaj gndermelerini salar. Mesaj gnderebilmek
	iin gnderenin nicki, gnderilenin nicki veya kanaln kaytl
	olmas gereklidir.
	
	%S'n mevcut komutlar:
	
	    SEND   Nicke veya kanala mesaj gnderir
	    CANCEL Son gnderilen mesaj iptal eder
	    LIST   Mesajlarnz listeler
	    READ   Mesajlar okumanz salar
	    DEL    Mesajlar silmenizi salar
	    SET    Mesajlarla ilgili ayarlar yapar

MEMO_HELP_ADMIN
	    SENDALL  Send a memo to all registered users

MEMO_HELP_OPER
	    STAFF      Send a memo to all opers/admins

MEMO_HELP_FOOTER
	
	Yukardaki herhangi bir komut hakknda yardm iin 
	/msg %S HELP komut yazn.
	
	(*) Varsaylan olarak, kanal mesajlarn o kanalda access
	    seviyesi en az 10 olanlar okuyabilir. Bu %s LEVELS 
	    komutuyla deitirebilir.

MEMO_HELP_SEND
	Kullanm: SEND {nick | kanalad} mesaj
	
	Belirtilen nicke veya kanala yazlan mesaj gnderir.
	Nicke gnderirken, gnderilen kii yeni mesaj olduuna dair
	bir not alr. Mesaj gnderilen nick/kanal kaytl olmaldr.

MEMO_HELP_CANCEL
	Kullanm: CANCEL {nick | kanalad}
	
	Belirtilen kanala yada nicke gnderilen son mesaj iptal eder,
	tabi eer o mesaj siz komutu kullandnz srada okunmamsa.

MEMO_HELP_LIST
	Kullanm: LIST [kanalad] [liste | NEW]
	
	Mevcut mesajlarnz listeler. NEW parametresi sadece yeni
	okunmam mesajlar listeler. Okunmam mesajlar mesaj 
	numarasnn solunda "*" ile iaretlidir. Aadaki rnekte
	olduu gibi belirli numaralarda listeleyebilirsiniz:
	
	   LIST 2-5,7-9
	      2'den 5'e ve 7'den 9'a kadar olan mesajlar listeler.

MEMO_HELP_READ
	Kullanm: READ [kanalad] {num | liste | LAST | NEW}
	
	Belirtilen mesajlar okumanz salar. Eer LAST belirtilmise
	en son gelen mesajnz okursunuz. Eer NEW belirtilmise tm 
	yeni mesajlarn okursunuz. Eer bir numara belirtirseniz (num)
	o numaraya ait mesaj okursunuz. Aadaki rnekteki gibi belirli
	numaralarda okuyabilirsiniz:
	
	   READ 2-5,7-9
	      2'den 5'e ve 7'den 9'a kadar olan mesajlar gsterir.

MEMO_HELP_DEL
	Kullanm: DEL [kanalad] {num | liste | LAST | ALL}
	
	Belirtilen mesajlar siler. Aadaki rnekteki gibi birden
	fazla mesajda silebilirsiniz.
	
	If LAST is given, the last memo will be deleted.
	Eer ALL parametresi belirtilmise, tm mesajlarnz silinir.
	
	rnekler:
	
	   DEL 1
	      lk gelen mesajnz siler.
	
	   DEL 2-5,7-9
	      2'den 5'e ve 7'den 9'a kadar olan mesajlar siler.

MEMO_HELP_SET
	Kullanm: SET zellik parametre
	
	eitli mesaj ayarlarn yapar. zellik aadakilerden 
	biri olabilir:
	
	    NOTIFY      Yeni mesajlarda ne zaman uyarlacanz
	                    belirler (sadece nickler iindir)
	    LIMIT       Alabileceiniz maksimum mesaj saysn
	                    belirler
	
	Belirli bir zellik hakknda daha fazla bilgi iin, 
	/msg %S HELP SET zellik yazn.

MEMO_HELP_SET_NOTIFY
	Kullanm: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	Yeni mesajlarda ne zaman uyarlacanz belirler:
	
	    ON      Yeni mesajlar iin balandnzda, away den 
	               dnte ve size gnderildikleri anda 
	               uyarlrsnz.
	    LOGON   Yeni mesajlar iin balandnzda ve away den
	               dnte uyarlrsnz.
	    NEW     Yeni mesajlar iin sadece size gnderildikleri 
	               anda uyarlrsnz.
	    OFF     Yeni mesajlar iin herhangi bir uyar almazsnz.
	
	ON parametresi LOGON ve NEW 'in kombinasyonudur

MEMO_HELP_SET_LIMIT
	Kullanm: SET LIMIT [kanalad] limit
	
	Sizin alabileceiniz (yada belirtilen kanaln) maksimum mesaj
	saysn belirler. Eer bunu 0 yaparsanz kimse size mesaj 
	gnderemeyecektir. Ayrca bu limiti %d den fazla yapamazsnz.

MEMO_HELP_INFO
	Kullanm: INFO [kanalad]
	
	Sahip olduunuz mesaj says, ka tanesinin okunmad, ve 
	alabileceiniz maksimum mesaj says gibi bilgiler verir.
	Eer kanalad parametresi belirtilirse ayn bilgiyi o kanal
	iin gsterir.

MEMO_SERVADMIN_HELP_SET_LIMIT
	Kullanm: SET LIMIT [kullanc | kanalad] {limit | NONE} [HARD]
	
	Bir kullanccn yada kanaln alabilecei maksimum mesaj
	saysn belirler. Bunu 0 yapmak kullancnn mesaj almasn 
	engeller; NONE yapmaksa kullancnn istedii kadar mesaj
	alp saklamasn salar. Eer kanal veya nick belirtilmezse,
	kendi limitinizi ayarlarsnz.
	
	HARD parametresini eklemek kullancnn bu limiti deitirmesini
	engeller. Bunu eklememekde, kullancnn limiti deitirmesine izin
	verir. (Bir nceki limit ayarnda HARD kullanlm olsa bile).
	
	SET LIMIT komutunun Kullanm Servis adminleriyle snrldr.
	Dier kullanclar limitlerini kaldramaz, %d zeri bir limit 
	belirleyemez, ve hard limitini ayarlayamaz. Sadece gerekli 
	ayrcalklar varsa bir kanaln mesaj limitini ve kendi mesaj
	limitlerini ayarlayabilirler.

MEMO_SERVADMIN_HELP_INFO
	Kullanm: INFO [nick | kanalad]
	
	Parametre kullanlmazsa, sahip olduunuz mesajlar, ka 
	tanesinin okunmam olduunu, ve toplam ka tane mesaj 
	alabileceiniz hakknda bilgiler verir.
	
	Kanalad parametresiyle, ayn bilgiyi belirtilen kanal
	iin verir.
	
	Nick parametresiyle, ayn bilgiyi belirtilen nick iin
	verir. Kullanm Servis adminleriyle snrldr.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_STAFF
	Syntax: STAFF memo-text

	Sends all services staff a memo containing memo-text.
	Note: If you have opers on both the oper list and the
	admin list they will recive the memo twice.  The same
	applies for oper's on the Root list as well as other
	lists.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_SENDALL
	Syntax: SENDALL memo-text

	Sends all registered users a memo containing memo-text.

###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP
	%S commands:
	    GLOBAL      Tm kullanclara mesaj gnderir
	    STATS       Servislerin ve networkun durumunu gsterir
	    OPER LIST   Tm Servis operatrlerini listeler
	    ADMIN LIST  Tm Servis adminlerini listeler
	    STAFF       Display Services staff and online status

OPER_HELP_OPER_CMD
	Sadece Servis operatrleri ve adminleri iin geerli komutlar:
	    MODE        Bir kanaln modlarn deitirir
	    KICK        Bir kullancy kanaldan atar
	    CLEARMODES  Bir kanaln modlarn temizler
	    KILLCLONES  Ayni ip'deki tum kullanicilari kill'ler.
	    AKILL       AKILL listesini dzenler
	    SGLINE      SGLINE listesini dzenler
	    SQLINE      SQLINE listesini dzenler
	    SZLINE      SZLINE listesini dzenler

OPER_HELP_ADMIN_CMD
	Sadece Servis adminleri iin geerli komutlar:
	    CACHE       Proxy detectr tarafindan kullanilan hostname
	                    cache listesini gsterir
	    SESSION     Host session(oturum) larn listesini gsterir
	    EXCEPTION   Session-limit exception listesini dzenler
	    CHANLIST    Tm kanal kaytlarn listeler
	    USERLIST    Tm kullanc kaytlarn listeler
	    OPER        Servis operatr listesini dzenler
	    LOGONNEWS   Balant srasnda kullancnn grecei mesaj 
	                    belirler
	    RANDOMNEWS  Baglanti sirasina kullaniciya gnderilen karisik
	                    mesajlari belirler
	    OPERNEWS    Oper olan kullanclarn grntleyecei mesaj 
	                    belirler
	    NOOP        Geici olarak tm O:line lar kaldrr
	    JUPE        Bir server' "Kullanlmaz" yapar
	    SET         eitli global servis zelliklerini ayarlar
	    UPDATE      Diskteki Servis veritabannn hemen
	                    gncellenmesini salar
	    RELOAD      Servislerin conf dosyasn yeniden ykler
	    QUIT        Servis programn kapatr
	    RESTART     Veritabann kaydeder ve servisleri yeniden 
	                    balatr
	    SHUTDOWN    Servisler programn kayt ederek kapatr

	Sadece Servis super-user(root) lar iin geerli komutlar:
	    ADMIN       Servis adminleri listesini dzenler

OPER_HELP_ROOT_CMD
	Commands available to Serivces Roots only:
	    MODLOAD     Load a module
	    MODUNLOAD   Un-Load a module
	    MODLIST     List loaded modules
	    MODINFO     Info about a loaded module

OPER_HELP_LOGGED
	Not: %S'e gnderilen tm komutlarn kayd tutulur!

OPER_HELP_GLOBAL
	Kullanm: GLOBAL mesaj
	
	IRCoplarn networkteki tm kullanclara mesaj yollamasn
	salar. Mesajlar %s nickinden gnderilir.

OPER_HELP_STATS
	Kullanm: STATS [AKILL | ALL | RESET]
	
	Hibir parametre yokken, mevcut kullanc saysn ve online
	olan IRCoplar(Servisler hari), Servisler balatldndan 
	beri bal olan en fazla kullanc saysn, ve servislerin
	alma sresini gsterir.
	
	AKILL parametresiyle, mevcut AKILL listesini ve o anki 
	varsaylan zaman am sresini gsterir.
	
	ALL parametresi sadece Servis adminleri tarafndan 
	kullanlabilir, ve servislerin kulland hafza(memory) 
	hakknda bilgi verir. Byk networklerde bu komutun kullanlmas
	servisleri ksa bir sre dondurabilir, bu yzden tekrar kullanmaya
	kalkmayn!
	
	RESET parametresi nceki maksimum kullanc saysn o anda
	networkte bulunan kullanc saysyla deitirir.
	
	UPTIME komutu STATS komutunun alternatifi olarak kullanlabilir.

OPER_HELP_OPER
	Kullanm: OPER ADD nick
	           OPER DEL {nick | kayt-num | liste}
	           OPER LIST [mask | liste]
	           OPER CLEAR
	
	Servis adminlerinin Servis operatrleri listesine belirtilen 
	nicki ekleyip karmasn salar. Nicki Servis operatrleri
	listesinde olan ve kendini %s ile tantm olan kullanclar
	Servis operatrleri komutlarn kullanabilir.
	
	OPER ADD komutu belirtilen nicki servis operatrleri listesine
	ekler.
	
	OPER DEL komutu belirtilen nicki servis operatrleri listesinden
	siler. Eer bir kayt numaras listesi verilmise, bu kaytlar
	silinir. (Aadaki LIST ile ilgili rnei inceleyin.)
	
	OPER LIST komutu servis operatrleri listesini grntler.
	Eer yldzl(wildcard) bir mask belirtilirse, sadece o maskla
	uyuan kaytlar listelenir. Eerbir kayt numaras listesi 
	belirtilirse, sadece o kaytlar gsterilir; rnein:
	
	   OPER LIST 2-5,7-9
	      Servis operatrlerinden kayd 2 den 5 e ve 7 den 9 a
	      kadar olanlar listelenir.
	
	OPER CLEAR komutu servis operatrleri listesindeki tm kaytlar
	siler.
	
	Herhangi bir IRC operatr OPER LIST komutunu kullanabilir.
	Dier tm OPER komutlarn Servis adminleri kullanabilir.

OPER_HELP_ADMIN
	Kullanm: ADMIN ADD nick
	           ADMIN DEL {nick | kayt-num | liste}
	           ADMIN LIST [mask | liste]
	           ADMIN CLEAR
	
	Servis root unun Servis adminleri listesine 
	belirtilen nicki ekleyip karmasn salar. Nicki Servis 
	adminleri listesinde olan ve kendini %s ile tantm olan
	kullanc Servis adminlerini komutlarn kullanabilir.
	
	ADMIN ADD komutu servis adminleri listesine belirtilen nicki
	ekler.
	
	ADMIN DEL komutu belirtilen nicki servis adminleri listesinden
	siler. Eer kayt numaralar listesi verilmise, bu kaytlar 
	silinir. (Aadaki LIST rneini inceleyin.)
	
	ADMIN LIST komutu servis adminleri listesini grntler.
	Eer yldzl(wildcard) bir mask belirtilmise, sadece bu
	maskla uyuan kaytlar grntlenir. Eer bir kayt numaras 
	listesi belirtilmise, sadece o kaytlar gsterilir; rnein:
	
	   ADMIN LIST 2-5,7-9
	      Servis adminleri kaytlarndan 2 den 5 e ve 7 den 9 a
	      kadar olanlar listelenir.
	      
	ADMIN CLEAR komutu tm servis adminlerinin kaytlarn siler.

	Herhangi bir IRC operatr ADMIN LIST komutunu kullanabilir.
	Dier tm ADMIN komutlarn Servis rootlar kullanabilir.

OPER_HELP_IGNORE
	Syntax: IGNORE {ADD|DEL|LIST} [time] [nick]

	Allows Services Admins to make Services ignore an user for
	a certain time or until the next restart. The default time
	format is seconds. You can specify it by using units. Valid
	units are: s for seconds, m for minutes, h for hours and
	d for days. Combinations of these units are not permitted. To 
	make Services permanently ignore the user type 0 as time.

OPER_HELP_MODE
	Kullanm: MODE kanalad modlar
	
	Servis operatrlerinin herhangi bir kanaln modlarn
	ayarlamasn salar. Parametreler standart /MODE komutununkiyle
	ayndr.
	
	Servis operatrlerinin Kullanmyla snrldr.

OPER_HELP_UMODE
	Syntax: UMODE user modes
	
	Allows Services admins to set user modes for any user.
	Parameters are the same as for the standard /MODE
	command.
	
	Limited to Services admins.

OPER_HELP_OLINE
	Syntax: OLINE user flags
	
	Allows Services admins to give Operflags to any user.
	Flags have to be prefixed with a "+" or a "-". To
	remove all flags simply type a "-" instead of any flags.

	Limited to Services admins.

OPER_HELP_CLEARMODES
	Kullanm: CLEARMODES kanalad [ALL]
	
	Bir kanaldaki tm modlar (i,k,l,m,n,p,s,t) ve banlar
	temizler. Eer ALL parametresi belirtilmise, tm
	oplar (+o) ve voicelar (+v) temizler.
	
	Servis operatrlerinin Kullanmyla snrldr.

OPER_HELP_KICK
	Kullanm: KICK kanalad kullanc sebep
	
	IRCoplarn herhangi bir kullancy kanaldan atmalarn
	salar. Parametreler standart /KICK komutununkiyle ayndr.
	Kick mesajnda komutu kullanan IRCop un nickide belirtilir.
	rnein:
	
	*** SpamMan has been kicked off channel #my_channel by %S (MJJ (Flood))
	
	Servis operatrlerinin Kullanmyla snrldr.

OPER_HELP_SVSNICK
	Syntax: SVSNICK nick newnick
	
	Forcefully changes a user's nickname from nick to newnick.
	
	Limited to Services admins

OPER_HELP_AKILL
	Kullanm: AKILL ADD [+zamanam] mask sebep
	           AKILL DEL {mask | kayt-no | liste}
	           AKILL LIST [mask | liste]
	           AKILL VIEW [mask | liste]
	           AKILL CLEAR
	
	Servis operatrlerinin AKILL listesini iletmesini salar.
	Eer AKILL listesineki mask la uyuan bir kullanc
	balanmaya alrsa, Servisler o kullancy KILL ler ve,
	destekleyen server tiplerinde, tm serverlarn o maska K-line
	koymasn salar.
	
	AKILL ADD belirtilen user@host maskn AKILL listesine
	belirtilen sebeple(mutlaka belirtilmelidir) birlikte
	ekler. AKILL DEL belirtilen mask eer listedeyse AKILL 
	listesinden karr. AKILL LIST mevcut tm AKILL leri
	gsterir; eer opsiyonel olarak mask belirtilmise, AKILL
	listesi belirtilen maskla uyuanlarla snrlandrlr. 
	
	AKILL VIEW, AKILL LIST in daha aklayc versiyonudur, 
	ve AKILL i ekleyeni, eklenme tarihini, ne zaman sona ereceini,
	user@host maskyla ve sebeple birlikte gsterir.
	
	Opsiyonel olarak, zaman am sresi AKILL ADD komutuyla
	birlikte belirtilebilir. Zaman am sresi user@host maskndan
	nce gelir, ve bir tamsay olarak unlardan birinden nce gelir, 
	d (gn), h (saat), veya m (dakika). 1h30m gibi kombinasyonlar 
	kullanlamaz. Eer birim belirleyici belirtilmemise varsaylan 
	olarak gn kullanlr (yani +30 un anlam 30 gndr). Zaman 
	amna uramayacak bir AKILL eklemek iin +0 kullann. Eer 
	eklenecek mask + ile balarsa zaman am sresi belirtilmelidir. 
	Mevcut varsaylan AKILL zaman am sresi STATS AKILL komutuyla 
	bulunabilir.

	AKILL CLEAR AKILL listesindeki tm kaytlar siler.
	
	sebep sadece IRC operatrleri tarafndan kullanlmak iindir,
	ve kullanclarn KILL mesajlarnda gzkmez.
	
	Servis operatrlerinin Kullanmyla snrldr.

OPER_HELP_SGLINE
	Kullanm: SGLINE ADD [+zamanam] mask:sebep
	         SGLINE DEL {mask | kayt-no | liste}
	           SGLINE LIST [mask | liste]
	           SGLINE VIEW [mask | liste]
	           SGLINE CLEAR
	
	Servis operatrlerinin SGLINE listesi oluturmalarn salar.
	Eer SGLINE listesindeki bir kullanc gerek ismi(realname)
	servera balanmaya alan bir kullancnnkiyle uyuuyorsa
	o kullancnn servera balanmas engellenir.
	
	SGLINE ADD komutu belirtilen realname(gerek isim) mask n
	SGLINE listesine bir sebeple(belirtilmesi zorunludur) 
	birlikte ekler.
	zamanam zaman belirleyici olarak tanmlanr ve unlar birini
	takip etmelidir: d (gn), h (saat), veya m (dakika). 1h30m
	eklindeki kombinasyonlar kullanlamaz. Eer zaman tanmlayc e
	konulmazsa varsaylan olarak gn kabul edilir (yani +30 un manas
	30 gndr). Zaman amna uramayacak bir SGLINE eklemek iin +0
	kullann.  Eklenecek realname mask  + ile balyorsa, o zaman
	zaman am sresi varsaylanla ayn olsa bile belirtilmelidir.
	Mevcut SGLINE varsaylan zaman am sresi STATS AKILL komutuyla
	bulunabilir.
	Not: realname mask boluk ierebileceinden bunla sebep arasnda iki
	nokta stste(:) kullanlmaldr.
	
	SGLINE DEL komutu belirtilen mask(eer listede mevcutsa) SGLINE 
	listesinden siler. eer bir kayt numaralar listesi belirtilmise
	o kaytlar silinir. (Aadaki LIST iin verilmi rnei inceleyin.)
	
	SGLINE LIST komutu SGLINE listesini grntler. Eer bir yldzl
	mask verilmise, sadece o maskla uyuan kaytlar ieren bir liste
	grntlenir.  Eer bir kayt numaralar listesi belirtilmise,
	sadece o kaytlar grntlenir; rnein:
	
	   SGLINE LIST 2-5,7-9
	      2 den 5 e 7 den 9 a kadar olan SGLINE kaytlarn listeler.
	      
	SGLINE VIEW komutu SGLINE LIST komutunun daha aklayc bilgi 
	veren eklidir, ve SGLINE  kimin eklediini, eklendii tarihi, ve
	ne zaman sona ereceini realname ve sebeple birlikte gsterir.
	
	SGLINE CLEAR komutu SGLINE listesindeki tm kaytlar siler.
	
	Servis operatrlerinin Kullanmyla snrldr.

OPER_HELP_SQLINE
	Kullanimi: SQLINE ADD [+zamanasimi] mask sebep
	           SQLINE DEL {mask | kayit-no | liste}
	           SQLINE LIST [mask | liste]
	           SQLINE VIEW [mask | liste]
	           SQLINE CLEAR
	
	Servis adminlerinin SQLINE listesini ynetmelerini saglar.
	Eger SQLINE listesindeki masklardan biriyle uyusan bir nick
	servera baglanmaya alisirsa, servisler buna izin vermezler.
	
	eger maskin ilk karakteri # ise servisler onla uyusan 
	kanallarin kullanilmasina izin vermezler. (destekleyen IRCd
	yazilimlarinda geerlidir).
	
	SQLINE ADD belirtilen maski belirtilen sebeple (mutlaka
	belirtilmelidir) birlikte SQLINE listesine ekler. zaman asimi
	ardinda d (gn), h (saat), veya m (dakika) olan bir sayi
	olmalidir..  1h30m seklindeki kombinasyonlar geersizdir.
	eger son ekleme harfi belirtilmemisse, varsayilan olarak gn
	kullanilir. (yani +30 30 gn demektir). Zaman asimina ugramasini
	istemediginiz bir SQLINE eklemek iin +0 kullanin.  
	Egegr eklenecek maskin basinda + varsa, zaman asimi sresi
	belirtilmelidir, aksi halde zaman asimi sresi varsayilanla ayni
	olacaktir. Mevcut SQLINE varsayilan zaman asimi sresi STATS AKILL
	komutuyla bulunabilir.
	
	SQLINE DEL komutu belirtilen maski SQLINE listesinden siler.
	Eger kayit numaralari listesi belirtilmisse, o kayitlari siler.
	(Asagidaki rnegi inceleyin.)
	
	SQLINE LIST komutu SQLINE listesini gsterir. Egegr bir mask
	belirtilmisse, maskla uyusan kayitlar gsterilir. Egegr kayit
	numaralari listesi belirtilmisse, o numaralara karsilik olan
	kayitlar gsterilir; rnegin:

	   SQLINE LIST 2-5,7-9
	      2 den 5 e ve 7 den 9 a kadar olan SQLINE kayitlari
	      gsterilir.
	      
	SQLINE VIEW komutu SQLINE LIST komutunun daha gelismisidir,
	ve SQLINE kaydini ekleyeni, eklendigi tarihi, sresinin ne zaman
	bitecegini, mask ve sebeple beraber gsterir.
	
	SQLINE CLEAR SQLINE listesindeki tm kayitlari temizler.
	
	Servis operatrlerinin kullanimiyla sinirlidir.

OPER_HELP_SZLINE
	Kullanm: SZLINE ADD [+zamanam] mask sebep
	           SZLINE DEL {mask | kayt-no | liste}
	           SZLINE LIST [mask | liste]
	           SZLINE VIEW [mask | liste]
	           SZLINE CLEAR
	
	Servis operatrlerinin SZLINE listesi oluturmalarn salar.
	Eer SZLINE listesindeki bir IP numarasyla uyuan bir kii
	servera balanmaya alrsa buna izin verilmez. (ve bu IP
	numaras PTR RR olsada olmasada gerekletirilir).
	
	SZLINE ADD komutu belirtilen IP maskn SZLINE listesine
	belirtilen bir sebeple(ki mutlaka belirtilmelidir) birlikte
	ekler. zamanam zaman belirleyici olarak tanmlanr ve 
	unlardan birini takip etmelidir: d (gn), h (saat), veya
	m (dakika). 1h30m eklindeki kombinasyonlar kullanlamaz.
	Eer zaman tanmlayc e belirtilmemise, varsaylan olarak
	gn kullanlr (yani +30 30 gn demektir).  Zaman amna 
	uramayacak bir SZLINE eklemek iin +0 kullann.  Eer
	eklenecek realname mask + ile balyorsa, zaman am sresi
	varsaylanla ayn olsa bile belirtilmelidir. Mevcut SZLINE 
	varsaylan zaman am sresi STATS AKILL komutuyla renilebilir.
	
	SZLINE DEL komutu belirtilen mask eer mevcutsa SZLINE 
	listesinden siler. Eer kayt numaralar listesi belirtilmise,
	bu kaytlar silinir. (LIST iin verilmi aadaki rnei inceleyin.)
	
	SZLINE LIST komutu SZLINE listesini grntler. Eer yldzl bir
	mask belirtilmise, sadece o maskla uyuan kaytlar grntlenir.
	Eer kayt numaralar listesi belirtilmise, sadece o kaytlar 
	gsterilir;  rnein:
	
	   SZLINE LIST 2-5,7-9
	      2 den 5 e 7 den 9 a kadar olan kaytlar grntler.
	      
	SZLINE VIEW komutu SZLINE LIST komutunun daha geni bilgi veren 
	bir eklidir, ve SZLINE  kimin eklediini, eklendii tarihi, ve ne
	zaman sona ereceini, IP mask ve sebeple birlikte grntler.
	
	SZLINE CLEAR komutu SZLINE listesindeki tm kaytlar siler.
	
	Servis operatrlerinin Kullanmyla snrldr.

OPER_HELP_SET
	Kullanm: SET zellik ayar
	
	eitli global servis zelliklerini ayarlar.  zellikler
	aada tanmlanmtr:
	    READONLY   Read-only ve read-write modunu ayarlar
	    LOGCHAN    Report log messages to a channel
	    DEBUG      Debug modunu aktifletirir yada kapatr
	    NOEXPIRE   No expire modunu aktifletirir yada kapatr
	
	Servis adminlerinin Kullanmyla snrldr.

OPER_HELP_SET_READONLY
	Kullanm: SET READONLY {ON | OFF}
	
	Read-only modunu aar yada kapatr. Read-only modunda,
	normal kullanclar herhangi bir servis verisini deitiremezler,
	bunun iinde kanal ve nick access listeleri v.s. vardr.
	Yeterli ayrcalklar olan IRCoplar servislerin AKILL listesini
	deitirebilir, nicklerin ve kanallarn kaydn silebilir yada 
	yasaklayabilir, fakat deiiklikler servisler kapatlmadan yada
	tekrar balatlmadan nce read-only modu kapatlmazsa kaydedilmez.
	
	-readonly komut satr zelliiyle ayndr.

OPER_HELP_SET_LOGCHAN
	Syntax: SET LOGCHAN {ON | OFF}

	With this setting on, Services will send its logs to a specified
	channel as well as the log file. LogChannel must also be defined
	in the Services configuration file for this setting to be of any
	use.

	Note: This can have strong security implications if your log
	channel is not properly secured.

OPER_HELP_SET_DEBUG
	Kullanm: SET DEBUG {ON | OFF | num}
	
	Debug modunu aar yada kapatr. Debug modunda, servislere 
	gnderilen ve alnan tm veriler dier bir ka debug 
	mesajlaryla beraber bir kayt dosyasna yazlr. Eer num 
	parametresi belirtilmise, debug modu num a bal debug 
	seviye ayar ile aktifletirilir.
	
	-debug komut satr zelliiyle ayndr.

OPER_HELP_SET_NOEXPIRE
	Kullanm: SET NOEXPIRE {ON | OFF}
	
	No expire modunu aar yada kapatr. No expire modunda,
	nickler, kanallar, akiller, ve exceptionlar mod kapanana
	kadar zaman amna uramazlar.
	
	-noexpire komut satr zelliiyle ayndr.

OPER_HELP_SET_SUPERADMIN
	Syntax: SET SUPERADMIN {ON | OFF}

	Setting this will grant you extra privlages such as the
	ability to be "founder" on all channel's etc...

	This opion is _NOT_ persistant, and should only be used when
	needed, and set back to OFF when no longer needed.


OPER_HELP_NOOP
	Kullanm: NOOP SET server
	           NOOP REVOKE server
	
	NOOP SET komutu belirtilen serverdaki tm O:line lar
	siler ve tm ircoplar rehash komutunu kullanp komutun
	etkisini yok etmemeleri iin killer.
	
	NOOP REVOKE komutu belirtilen serverdaki tm kaldrlm
	O:line lar yeniden oluturur.
	
	Not: server parametresinin doruluu servisler tarafndan
	kontrol edilmez.
	
	Services adminlerinin Kullanmyla snrldr.

OPER_HELP_JUPE
	Kullanm: JUPE server [sebep]
	
	Servislere bir servern Jupiter yaplmasn syler. -- Bu,
	servislere bir sahte server balayarak, gerek servern o 
	isimden balanmasn engeller. JUPE modu standart SQUIT
	kullanlarak kaldrlabilir. Eer sebep belirtilmise,
	bu server bilgi satrna yazlr; belirtilmezse server bilgi
	satrnda "Jupitered by <nick>" yazs yer alr, ve server 
	jupiter edenin nicki yazlr.
	
	Servis adminlerinin Kullanmyla snrldr.

OPER_HELP_RAW
	Kullanm: RAW yaz
	
	Servislerin bal olduu server a direk bir yaz gnderir.
	Bu komutun kullanm alanlar snrldr, ve yanl kullanlrsa
	networkte ok byk hasara yol aabilir. Tam olarak ne 
	yaptnz bilmiyorsanz BU KOMUTU KULLANMAYIN!
	
	Servis adminlerinin Kullanmyla snrldr.

OPER_HELP_UPDATE
	Kullanm: UPDATE
	
	Komutu gnderir gnderirmez servislerin tm veri taban 
	dosyalarn gncellemelerini salar.
	
	Servis adminlerinin Kullanmyla snrldr.

OPER_HELP_RELOAD
	Kullanm: RELOAD
	
	Servislerin conf dosyasn yeniden yklemesine neden olur.
	Unutmaynki baz direktifler hala servislerin yeniden 
	balatlmasn gerektirir. (Servislerin nickleri, session 
	limitinin aktifletirilmesi, etc.)
	
	Servis adminlerinin Kullanmyla snrldr.

OPER_HELP_QUIT
	Kullanm: QUIT
	
	Servislerin birden kapanmasna neden olur; veritabanlar
	kaydedilmez. Bu komut veritabanlarnn hafzadaki 
	kopyalarna zarar gelmesinden korkuluyorsa ve 
	yedeklenmemilerse kullanlmamaldr. Normal kapatmalar 
	iin, SHUTDOWN komutunu kullann.
	
	Servis adminlerinin Kullanmyla snrldr.

OPER_HELP_SHUTDOWN
	Kulanm: SHUTDOWN
	
	Servislerin tm veritabanlarn kaydederek kapanmasn salar.
	
	Servis adminlerinin Kullanmyla snrldr.

OPER_HELP_RESTART
	Kullanm: RESTART
	
	Servislerin tm veritabanlarn kaydederek yeniden 
	balamasn salar.
	
	Servis adminlerinin Kullanmyla snrldr.	

OPER_HELP_KILLCLONES
	Kullanm: KILLCLONES nick
	
	Hostnameleri ayn olan tm kullanclar kill ler.
	Geici bir AKILL, *@host formatnda, eklenerek
	kullancnn hemen yeniden balanmasna engel olunur.
	Komutu kullanan, hangi hostname in etkilendiini ve
	ka tane kullancnn kill lendiini belirten bir wallop
	gnderilir. Networkten saysz clone lar temizlemek iin
	kullanldr.
	
	Servis operatrlerinin kullanmyla snrldr.

OPER_HELP_CHANLIST
	Kullanm: CHANLIST [{model | nick} [SECRET]]
	
	Networkte o an kullanlan kanallar kaytl olsun olmasn 
	listeler.
	
	Eer model belirtilmise, onla uyuan kanallar listeler. 
	Eer nickname belirtilmise, o kullancnn bulunduu 
	kanallar listeler. Eer SECRET belirtilmise, sadece model
	le uyuan ve +s veya +p modunda olan kanallar listelenir.
	
	Servis adminlerinin Kullanmyla snrldr.

OPER_HELP_USERLIST
	Kullanm: USERLIST [{model | kanalad} [INVISIBLE]]
	
	Networkte o an bulunan tm kullanclar kaytl olsun olmasn 
	listeler.
	
	Eer model belirtilmise, onla uyuan kullanclar listeler
	(nick!user@host formatnda olmaldr). Eer kanalad 
	belirtilmise, sadece o kanalda bulunan kullanclar listeler.
	Eer INVISIBLE belirtilmise, sadece +i modundaki kullanclar 
	listelenir.
	
	Servis adminlerinin Kullanmyla snrldr.

OPER_HELP_CACHE
	Kullanimi: CACHE DEL hostadi
	           CACHE LIST model [QUEUED | ALL]
	
	CACHE DEL komutu belirtilen hostadini cache ten siler.
	sadece hata kontrol iin kullanilir.

	CACHE LIST komutu belirtilen modele uyan tm proxy leri
	listeler. Eger QUEUED zelligi belirtilmisse, siradaki veya
	aktif taramalardaki proxy leri listeler. Eger ALL zelligi
	belirtilmis ise tm cache teki hostadlarini listeler.
	
	Servis adminlerinin kullanimiyla sinirlidir..

###########################################################################
#
# BotServ help messages
#
###########################################################################
	
OPER_HELP_MODLOAD
	Syntax: MODLOAD FileName

	This command loads the module named FileName from the modules
	directory.

	Limited to Services Roots.

OPER_HELP_MODUNLOAD
	Syntax: MODUNLOAD FileName

	This command unloads the module named FileName from the modules
	directory.

	Limited to Services Roots.

OPER_HELP_MODINFO
	Syntax: MODINFO FileName

	This command lists information about the specified loaded module

	Limited to Services Roots.

OPER_HELP_MODLIST
	Syntax: MODLIST

	Lists all currently loaded modules.

	Limited to Services Roots.


###########################################################################
#
# BotServ help messages
#
###########################################################################
	
BOT_HELP
	%S kanalnzda bir botunuzun olmasn salar. Bu
	servis bot konfigrasyonundan anlamayanlar yada
	bota izin vermeyen networkler iin gelitirilmitir.
	Mevcut komutlar aada listelenmitir. Kullanmak iin
	/msg %S command yazn. Belirli bir komut hakknda
	daha fazla bilgi iin, /msg %S HELP komut
	yazn.
	
	BOTLIST            Mevcut botlar listeler
	ASSIGN             Kanala bot sokar
	SET                Bot zelliklerini ayarlar
	KICK               Atma zelliklerini ayarlar
	BADWORDS           Kfr listesi oluturur
	
	Dier komutlar: ACT INFO SAY UNASSIGN
	
	Kanalda en az %d kullanc olduu zaman bot kanala girer.

BOT_HELP_BOTLIST
	Kullanm: BOTLIST
	
	Networkte mevcut olan tm botlar listeler.

BOT_HELP_ASSIGN
	Kullanm: ASSIGN kanalad botunnicki
	
	Belirtilen nickteki botu belirtilen kanala sokar. Bundan 
	sonra botun ayarlarn ihtiyalarnza uygun ekilde 
	yapabilirsiniz.

BOT_HELP_UNASSIGN
	Kullanm: UNASSIGN kanalad
	
	Belirtilen kanaldan botu karr. Bu komutu kullandktan
	sonra bot bir daha kanala girmeyecektir. Fakat yaplm bot
	ayarlar saklanr, bylece istediinz zaman tekrar ayar 
	yapmaya gerek olmadan kanala bot sokabilirsiniz.

BOT_HELP_INFO
	Kullanm: INFO {kanalad | botunnicki}
	
	Bir kanal yada bot hakknda %S bilgisini gsterir. Eer
	parametre kanalsa, aktif atma zellikleri hakknda bilgi
	alrsnz. Eer parametre nickse, bot hakknda yaratlma 
	zaman veya bulunduu kanal says gibi bilgiler alrsnz.

BOT_HELP_SET
	Kullanm: SET kanalad zellik parametre
	
	Bot zelliklerini ayarlar. zellik unlardan biri olabilir:
	
	    DONTKICKOPS      Botun atmasna kar oplar korur
	    DONTKICKVOICES   Botun atmasna kar voice lar korur
	    GREET            Greet mesajn aktifletirir
	    FANTASY          Fantazi komutlarn aktifletirir
	    SYMBIOSIS        Gerek bot gibi davranmasn salar.
	
	Belirli bir komut hakknda daha fazla bilgi iin 
	/msg %S HELP SET zellik yazn.
	
	Not: Bu komuta access eriimi seviye(level) ayaryla salanr.

BOT_HELP_SET_DONTKICKOPS
	Kullanm: SET kanalad DONTKICKOPS {ON|OFF}
	
	Kanalda op korumasn aar yada kapatr.
	Aktifletirildii zaman, oplar bot tarafnda NOKICK
	seviyeleri olmasalar bile atlmazlar.

BOT_HELP_SET_DONTKICKVOICES
	Kullanm: SET kanalad DONTKICKVOICES {ON|OFF}
	
	Kanalda voice korumasn aar yada kapatr.
	Aktifletirildii zaman, voice lar bot tarafndan
	NOKICK seviyeleri olmasalar bile atlmazlar.

BOT_HELP_SET_FANTASY
	Kullanm: SET kanalad FANTASY {ON|OFF}
	
	Kanalda fantazi modunu aar yada kapatr.
	Aktifletirildii zaman, kulanclar kanalda
	!op, !deop, !voice, !devoice, !kick, !kb, 
	!unban, !seen gibi komutlar kullanabilirler. 
	(nasl kullanldklarn renmek iin; onlar 
	nickle ve nicksiz kullann vede bazlarndada sebep 
	belirtin).
	
	Unutmaynki fantazi komutlarn kullanmak
	isteyen kullanclarn FANTASIA ve komutun 
	gerektirdii dier seviyelere yeterli access
	seviyesi olmas gereklidir. (rnein, !op
	komutunu kullanmak iin, kullancnn OPDEOP
	seviyesine yeterli access i olmaldr).

BOT_HELP_SET_GREET
	Kullanm: SET kanalad GREET {ON|OFF}
	
	Kanalda karlama modunu aar yada kapatr.
	Aktifletirildii zaman, bot kanala giren 
	kullanclara bir karlama mesaj gnderir,
	tabi eer bu kiilerin yeterli access leri varsa.

BOT_HELP_SET_SYMBIOSIS
	Kullanm: SET kanalad SYMBIOSIS {ON|OFF}
	
	Kanalda simbiyoz modunu aar yada kapatr.
	Aktifletirildii zaman bot %s'n yapt hereyi
	kendisi yapar. Modelar, kickler, ve giri mesaj gibi.

BOT_HELP_KICK
	Kullanm: KICK kanalad zellik parametre
	
	Botun kick lerini ayarlar. zellik unlardan biri olabilir:
	
	    BOLDS         Kaln yazda atar
	    BADWORDS      Kfrde atar
	    CAPS          Byk yazda atar
	    COLORS        Renkli yazda atar
	    FLOOD         Flood da atar
	    REPEAT        Kendini tekrar edenleri atar
	    REVERSES      Ctrl+r nin kullanlmasnda atar
	    UNDERLINES    Altizgili yazda atar
	
	Belirli bir zellik hakknda daha fazla bilgi iin
	/msg %S HELP KICK zellik yazn.
	
	Not: Bu komuta eriim seviye(level) ayaryla yaplr.

BOT_HELP_KICK_BOLDS
	Kullanm: KICK kanalad BOLDS {ON|OFF} [bas]
	
	Kaln yazda atmay aar yada kapatr. 
	Aktifletirildiinde bu zellik bota kaln yaz
	kullananlar atmasn syler.
	
	bas banlamadan nce kiinin ka kez atlacan 
	belirler. Kaldrmak iin komutta bas  belirtmeyin.

BOT_HELP_KICK_COLORS
	Kullanm: KICK kanalad COLORS {ON|OFF} [bas]
	
	Renkli yazda atmay aar yada kapatr. 
	Aktifletirildiinde bu zellik bota renkli yaz 
	kullananlar atmasn syler.
	
	bas banlamadan nce kiinin ka kez atlacan 
	belirler. Kaldrmak iin komutta bas  belirtmeyin.

BOT_HELP_KICK_REVERSES
	Kullanm: KICK kanalad REVERSES {ON|OFF} [bas]
	
	Ctrl+r nin kullanlmasnda atmay aar yada kapatr. 
	Aktifletirildiinde bu zellik bota Ctrl+r yi 
	kullananlar atmasn syler.
	
	bas banlamadan nce kiinin ka kez atlacan 
	belirler. Kaldrmak iin komutta bas  belirtmeyin.

BOT_HELP_KICK_UNDERLINES
	Kullanm: KICK kanalad UNDERLINES {ON|OFF} [bas]
	
	Altizgili yazda atmay aar yada kapatr.
	Aktifletirildiinde bu zellik bota altizgili
	yazanlar atmasn syler.
	
	bas banlamadan nce kiinin ka kez atlacan 
	belirler. Kaldrmak iin komutta bas  belirtmeyin.

BOT_HELP_KICK_CAPS
	Kullanm: KICK kanalad CAPS {ON|OFF} [bas [min [yzde]]]
	
	Byk yazda atmay aar yada kapatr.
	Aktifletirildiinde bu zellik bota byk yaz
	kullananlar atmasn syler.
	
	Bot belirtilen en az(min) byk harfin toplam yaznn
	yzdesine%% bal olarak atar. (Belirtilmemise,
	varsaylan olarak 10 karakter ve 25%% de atar).
	
	bas banlamadan nce kiinin ka kez atlacan 
	belirler. Kaldrmak iin komutta bas  belirtmeyin.

BOT_HELP_KICK_FLOOD
	Kullanm: KICK kanalad FLOOD {ON|OFF} [bas [sra [sn]]]
	
	Flood da atmay aar yada kapatr. Aktifletirildiinde
	bu zellik bota sn saniyede enaz sra srada flood
	yapanlar atmasn syler. (Belirtilmemise varsaylan
	olarak 10 saniyede 6 sra da atar).
	
	bas banlamadan nce kiinin ka kez atlacan 
	belirler. Kaldrmak iin komutta bas  belirtmeyin.

BOT_HELP_KICK_REPEAT
	Kullanm: KICK #kanalad REPEAT {ON|OFF} [bas [say]]
	
	Tekrar yazlan ayn yazda atmay aar yada kapar.
	Aktifletirildiinde bu zellik bota kendilerini
	say kez tekrar edenleri atmasn syler. (Eer
	say belirtilmemise, varsaylan olarak 3 tr).
	
	bas banlamadan nce kiinin ka kez atlacan 
	belirler. Kaldrmak iin komutta bas  belirtmeyin.

BOT_HELP_KICK_BADWORDS
	Kullanm: KICK #channel BADWORDS {ON|OFF} [bas]
	
	Kfrde atmay aar yada kapatr. Aktifletirildiinde
	bu zellik bota kfr edenleri atmasn syler.
	
	Bir kanal iin kfr belirlemek iin BADWORDS komutunu
	kullanabilirsiniz. Ayrntlar iin  /msg %S HELP BADWORDS
	yazn.
	
	bas banlamadan nce kiinin ka kez atlacan 
	belirler. Kaldrmak iin komutta bas  belirtmeyin.

BOT_HELP_BADWORDS
	Kullanm:  BADWORDS kanalad ADD kelime [SINGLE | START | END]
	            BADWORDS kanalad DEL {kelime | kayt-no | liste}
	            BADWORDS kanalad LIST [mask | liste]
	            BADWORDS kanalad CLEAR
	
	Bir kanal iin kfr listesi dzenler. Kfr listesi
	kfrde atma aktifletirildii zaman hangi kelimelerde
	atlacan belirler. Daha fazla bilgi iin 
	/msg %S HELP KICK BADWORDS yazn.
	
	BADWORDS ADD komutu belirtilen kelimeyi kfr listesine
	ekler. Eer SINGLE parametresi belirtilmise, atma ilemi
	kullanc o kelimenin tamamn sylerse yaplr. Eer START
	parametresi belirtilmise, kullanc o kelimeyle balayan 
	birey sylediinde atlr. Eer END parametresi belirtilmise
	kullanc o kelimeyle biten birey sylediinde atlr.
	Eer bir parametre kullanmazsanz, atma ilemi kullanc o 
	kelimeyi her kullandnda yaplr.
	
	BADWORDS DEL komutu belirtilen kelimeyi kfr listesinden 
	siler. Eer kayt numaras listesi verilirse, o kelimeler
	silinir. (LIST iin aadaki rnei inceleyin) 
	
	BADWORDS LIST komutu kfr listesini grntler. Eer
	bir kfrn bir ksm belirtilmise, o ksma uyan kfrler
	listelenir. Eer bir kayt numaras listesi belirtilmise,
	sadece o kfrler listelenir; rnein:
	
	   BADWORDS #kanalad LIST 2-5,7-9
	      2'den 5'e ve 7'den 9'a kadar olan kfrler 
	      listelenir.
	      
	BADWORDS CLEAR komutu tm kfr listesini temizler.

BOT_HELP_SAY
	Kullanm: SAY kanalad yaz
	
	Botun belirtilen yazy belirtilen kanalda sylemesini salar.

BOT_HELP_ACT
	Kullanm: ACT kanalad yaz
	
	Botun belirtilen yazyla belirtilen kanalda "/me" komutunun 
	yaptn kendi zerinde yapmasn salar.

BOT_SERVADMIN_HELP
	
	Aadaki komut Servis adminleri tarafndan kullanlr:
	
	    BOT              Networkn bot listesini dzenler

BOT_SERVADMIN_HELP_BOT
	Kullanm: BOT ADD nick user host gerekismi
	        BOT CHANGE eskinick yeninick [user [host [gerekismi]]]
	        BOT DEL nick
	        BOT LIST
	
	Servis adminlerinin kullanclarn kanallarnda kullanmas 
	iin botlar yaratmasn, deitirmesini ve silmesini salar.
	
	BOT ADD belirtilen nickte, username, hostname ve gerek 
	isimde bir bot ekler. Doruluk snamas yaplmadnda komutu
	kullanrken ok dikkatli olun.
	BOT CHANGE botun nickini, username ini, hostname ini veya
	gerek ismini silmeye gerek kalmadan deitirmeyi salar.
	BOT DEL belirtilen botu bot listesinden siler.
	BOT LIST komutu BOTLIST ile ayndr ve sadece networkteki
	mevcut botlar listeler.
	
	Not: Eer botun nicki olarak, kaytl bir nick
	kullanrsanz o nickin kayd silinir(drop). Ayrca
	o an bir kuulanc bu nicki kullanyorsa kill lenir.

BOT_SERVADMIN_HELP_SET
	
	Bu zellikleri servis adminlerini kullanabilir:
	
	    NOBOT            Bir kanala bot girmesini engeller.
	    PRIVATE          Botun IRC operatrleri haricinde kanallara
	                        sokulmasini engeller

	                        
BOT_SERVADMIN_HELP_SET_NOBOT
	Kullanm: SET kanalad NOBOT {ON|OFF}
	
	Bu zellik bir kanal bot sokulamaz hale getirir. Eer
	kanala zaten bir bot sokulmusa otomatik olarak o bot
	kanaldan karlr.
	
	Servis adminlerinin Kullanmyla snrldr.

BOT_SERVADMIN_HELP_SET_PRIVATE
	Kullanm: SET botun-nicki PRIVATE {ON|OFF}
	
	Bu zellik IRC Operatrleri disindaki userlarin bu
	botlari kanallara sokmalarini engeller.
	
	Bu komutu Servis Adminleri kullanabilir.
HOST_EMPTY
	The vhost list is empty.
HOST_ENTRY
	#%d Nick:%s, vhost:%s (%s - %s)
HOST_IDENT_ENTRY
	#%d Nick:%s, vhost:%s@%s (%s - %s)
HOST_SET
	vhost for %s set to %s.
HOST_IDENT_SET
	vhost for %s set to %s@%s.
HOST_SETALL
	vhost for group %s set to %s.
HOST_DELALL
	vhosts for group %s have been removed.
HOST_DELALL_SYNTAX
	Syntax: DELALL <nick>.
HOST_IDENT_SETALL
	vhost for group %s set to %s@%s.
HOST_SET_ERROR
	Error! A vhost can only contain A-Z, a-z, 0-9, '.' and '-'.
HOST_SET_IDENT_ERROR
	A vhost ident must be in the format of a valid ident
HOST_SET_TOOLONG
	Error! The vhost is too long, please use a host shorter than %d characters.
HOST_SET_IDENTTOOLONG
	Error! The Ident is too long, please use an ident shorter than %d characters.
HOST_NOREG
	User %s not found in the nickserv db.
HOST_SET_SYNTAX
	Syntax /msg %s set <nick> <hostmask>.
HOST_SETALL_SYNTAX
	Syntax /msg %s setall <nick> <hostmask>.
HOST_DENIED
	Access Denied.
HOST_NOT_ASSIGNED
	Please contact an Operator to get a vhost assigned to this nick.
HOST_ACTIVATED
	Your vhost of %s is now activated.
HOST_IDENT_ACTIVATED
	Your vhost of %s@%s is now activated.
HOST_ID
	Please identify to services first.
HOST_NOT_REGED
	You need to register before a vhost can be assigned to you.
HOST_DEL
	vhost for %s removed.
HOST_DEL_SYNTAX
	Syntax: /msg %s del <nick>.

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_OFF_UNREAL
	Your vhost was removed. To re-enable the standard host cloaking, type /mode %s +x
HOST_NO_VIDENT
	Your IRCD does not support vIdent's, if this is incorrect, please report this as a possible bug

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_GROUP
	All vhost's in the group %s have been set to %s
HOST_IDENT_GROUP
	All vhost's in the group %s have been set to %s@%s

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_LIST_FOOTER
	Displayed all records (Count: %d)
HOST_LIST_RANGE_FOOTER
	Displayed records from %d to %d
HOST_LIST_KEY_FOOTER
	Displayed records matching key %s (Count: %d)

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_HELP
	%S commands:
	    ON          Activates your assigned vhost
	    OFF         Deactivates your assigned vhost

HOST_OPER_HELP
	Commands available to services operators only:
	    SET         Set the vhost of another user
	    SETALL      Set the vhost for all nicks in a group
	    DEL         Delete the vhost of another user
	    LIST        Displays one or more vhost entries.

HOST_ADMIN_HELP
	Commands available to services admins only:

HOST_HELP_ON
	Syntax: ON

	Activates the vhost currently assigned to the nick in use.
	When you use this command any user who performs a /whois
	on you will see the vhost instead of your real IP address.

HOST_HELP_SET
	Syntax: SET <nick> <hostmask>.

	Sets the vhost for the given nick to that of the given
	hostmask.  If your IRCD supports vIdents, then using
	SET <nick> <ident>@<hostmask> set idents for users as 
	well as vhosts.

	Limited to Services operators.

HOST_HELP_DELALL
	Syntax: DELALL <nick>.

	Deletes the vhost for all nick's in the same group as
	that of the given nick.

	Limited to Host Removers.


HOST_HELP_SETALL
	Syntax: SETALL <nick> <hostmask>.

	Sets the vhost for all nicks in the same group as that
	of the given nick.  If your IRCD supports vIdents, then
	using SETALL <nick> <ident>@<hostmask> will set idents
	for users as well as vhosts.

	* NOTE, this will not update the vhost for any nick's
	added to the group after this command was used.

	Limited to Services operators.

HOST_HELP_OFF
	Syntax: OFF

	Deactivates the vhost currently assigned to the nick in use.
	When you use this command any user who performs a /whois
	on you will see your real IP address.

HOST_HELP_DEL
	Syntax: DEL <nick>

	Deletes the vhost assigned to the given nick from the
	database.

	Limited to Services operators.

HOST_HELP_LIST
	Syntax: LIST [<key>|<#X-Y>]

	This command lists registered vhosts to the operator
	if a Key is specified, only entries whos nick or vhost match
	the pattern given in <key> are displayed e.g. Rob* for all
	entries beginning with "Rob"

	If a #X-Y style is used, only entries between the range of X
	and Y will be displayed, e.g. #1-3 will display the first 3
	nick/vhost entries.

	The list uses the value of NSListMax as a hard limit for the
	number of items to display to a operator at any 1 time.

	Limited to Services operators.

HOST_HELP_GROUP
	Syntax: GROUP
	
	This command allows users to set the vhost of thier
	CURRENT nick to be the vhost for all nicks in the same
	group.
