# Catalan Language File.
#
# (C) 2003 Anope Team
# Contact us at info@anope.org
#
# Please read COPYING and README for furhter details.
#
# Based on the original code of Epona by Lara.
# Based on the original code of Services by Andy Church. 
# 
# When translating this file to another language, keep in mind that the
# order of per ameters for sprintf() is fixed in the source code, so your
# messages need to take the same per ameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the per ameters, let me know
# (achurch@dragonfire.net) which message is causing a problem and I'll see
# what I can do.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# config.h).  The %S's do not count as sprintf() per ameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.


###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".
# Translated by AUJAC (Associaci d'Usuaris de Java de Catalunya. http://www.aujac.org)
LANG_NAME
	Catala (Catalan)

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%d %b %H:%M:%S %Y %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %d %b %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%d %b %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	Diu
	Dll
	Dmt
	Dmc
	Dj
	Dv
	Dsb
# %A
STRFTIME_DAYS_LONG
	Diumenge
	Dilluns
	Dimarts
	Dimecres
	Dijous
	Divendres
	Dissabte
# %b
STRFTIME_MONTHS_SHORT
	Gen
	Feb
	Mar
	Abr
	Mai
	Jun
	Jul
	Ago
	Sep
	Oct
	Nov
	Des
# %B
STRFTIME_MONTHS_LONG
	Gener
	Febrer
	Mar
	Abril
	Maig
	Juny
	Juliol
	Agost
	Setembre
	Octubre
	Novembre
	Desembre


# This is used in ChanServ/NickServ INFO displays.
COMMA_SPACE
	, 


# Various error messages.
USER_RECORD_NOT_FOUND
	Error Intern - Impossible processar petici.
UNKNOWN_COMMAND
	Comanda no coneguda %s.
UNKNOWN_COMMAND_HELP
	Comanda no coneguda %s. "/msg %s HELP" per ajuda.
SYNTAX_ERROR
	Sintxis: %s
MORE_INFO
	/msg %s HELP %s per ms informaci.
NO_HELP_AVAILABLE
	No existeix ajuda per %s.
OBSOLETE_COMMAND
	Aquesta comanda esta obsoleta; utilitzi %s en substituci.

BAD_USERHOST_MASK
	La mascara ha de ser de la forma usuari@host.
BAD_EXPIRY_TIME
	Temps d'expiraci invlid.
USERHOST_MASK_TOO_WIDE
	%s La cobertura es mes amplia; Per favor utilitzi una mascara mes especifica.

SERVICE_OFFLINE
	%s esta momentaneament offline.
READ_ONLY_MODE
	Noticia: Els serveis estan en mode read-only; Els canvis no seran guardats!
PASSWORD_INCORRECT
	Clau incorrecta.

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	accs denegat.
PERMISSION_DENIED
	Permis denegat.
RAW_DISABLED
	The RAW option has been disabled. If you must use it, enable the DisableRaw directive in Services configuration.

MORE_OBSCURE_PASSWORD
	Per favor intenti novamente amb una clau mes oculta. Les claus han de ser de com a mnim 5 carcters, no han de ser fcils d'encertar (ex. Nom real o Nick), i no poden contenir el carcter d'espai o tabulaci.
PASSWORD_TRUNCATED
	Noticia:  La clau ha estat retallada a %d caracters.

NICK_NOT_REGISTERED
	El teu nick no esta registrat.
NICK_NOT_REGISTERED_HELP
	El teu nick no esta registrat. Escriu /msg %s HELP per mes informaci al registrat el teu nickname.
NICK_X_NOT_REGISTERED
	El nick %s no esta registrat.
NICK_X_IN_USE
	Nick %s is currently in use.
NICK_X_NOT_IN_USE
	El nick %s no esta en us.
NICK_X_NOT_ON_CHAN
	El nick %s no esta en el canal %s actualment.
NICK_X_FORBIDDEN
	El nick %s no pot ser registrat o utilitzat.
NICK_X_FORBIDDEN_OPER
	El nick %s ha estat prohibit per %s:
	%s
NICK_X_ILLEGAL
	Nick %s is an illegal nickname and cannot be used.
NICK_X_TRUNCATED
	Nick %s was truncated to %d characters.
CHAN_X_NOT_REGISTERED
	El Canal %s no esta registrat.
CHAN_X_NOT_IN_USE
	El Canal %s No existeix.
CHAN_X_FORBIDDEN
	El Canal %s no pot ser registrat o usat.
CHAN_X_FORBIDDEN_OPER
	El Canal %s ha estat prohibit per %s:
	%s
CHAN_X_SUSPENDED
	      Suspended: [%s] %s
NICK_IDENTIFY_REQUIRED
	Autentificaci per clau requerida per aquesta comanda.
	Intenta un altre cop desprs de escriure /msg %s IDENTIFY clau.
CHAN_IDENTIFY_REQUIRED
	Autentificaci per clau requerida per aquesta comanda.
	Intenta de nou desprs d'escriure /msg %s IDENTIFY %s clau.
	
MAIL_DISABLED
	Els serveis han estat configurats per no enviar email
MAIL_INVALID
	E-mail per %s es invalid.
MAIL_X_INVALID
	%s no es un e-mail valid.
MAIL_LATER
	Imposible enviar email ara; per favor intenta en uns instants.
MAIL_DELAYED
	Per favor espera %d segons i intenta un altre cop.
	
NO_REASON
	Sense ra
UNKNOWN
	<desconegut>

# Duration system
DURATION_DAY
	1 dia
DURATION_DAYS
	%d dies
DURATION_HOUR
	1 hora
DURATION_HOURS
	%d hores
DURATION_MINUTE
	1 minut
DURATION_MINUTES
	%d minuts
DURATION_SECOND
	1 segon
DURATION_SECONDS
	%d segons
	
# Human readable expiration
NO_EXPIRE
	no expira
EXPIRES_SOON
	expira amb el prxim update de la base de dades
EXPIRES_M
	expira en %d minuts
EXPIRES_1M
	expira en %d minuts
EXPIRES_HM
	expira en %d hores, %d minuts
EXPIRES_H1M
	expira en %d hores, %d minut
EXPIRES_1HM
	expira en %d hora, %d minuts
EXPIRES_1H1M
	expira en %d hora, %d minut
EXPIRES_D
	expira en %d dies
EXPIRES_1D
	expira en %d dia

# Generic Footer message
END_OF_ANY_LIST
	End of %s list.

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Aquest nick pertany a un altra persona. Per favor escull un altre nick.
	(Si aquest es el teu nick, escriu /msg %s IDENTIFY clau.)
NICK_IS_SECURE
	Aquest nick esta registrat i protegit. Si es el teu
	nick, escriu /msg %s IDENTIFY clau. Si no,
	per favor escull un nick diferent.
NICK_MAY_NOT_BE_USED
	Aquest nickname no pot ser utilitzat. Per favor escull un altre.
FORCENICKCHANGE_IN_1_MINUTE
	Si no canvies el teu nick en un minut, el canviare jo.
FORCENICKCHANGE_IN_20_SECONDS
	Si no canvies el teu nick en 20 segons, el canviare jo.
FORCENICKCHANGE_NOW
	Aquest nick ha estat registrat; No pots utilitzar-lo.
FORCENICKCHANGE_CHANGING
	El teu nickname s'esta canviant a %s

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER clau [email]
NICK_REGISTER_SYNTAX_EMAIL
	REGISTER clau email
NICK_REGISTRATION_DISABLED
	Ho sento, el registre de nicknames esta temporalment deshabilitat.
NICK_REGISTRATION_FAILED
	Ho sento, error en el registre.
NICK_REG_PLEASE_WAIT
	Per favor espera %d segons abans d'utilitzar la comanda REGISTER novament.
NICK_CANNOT_BE_REGISTERED
	El nickname %s no pot ser registrat.
NICK_ALREADY_REGISTERED
	El nickname %s ja esta registrat!

NICK_REGISTERED
	El nickname %s ja esta registrat sota el teu compte: %s
NICK_PASSWORD_IS
	La teva clau es %s - Recordala per un us futur.

# GROUP responses
NICK_GROUP_SYNTAX
	GROUP grup clau
NICK_GROUP_DISABLED
	Ho sento, La agrupaci de nicks esta temporalment inabilitada.
NICK_GROUP_FAILED
	Ho sento, La agrupaci de nicks ha fallat.
NICK_GROUP_PLEASE_WAIT
	Per favor espera %d segons abans d'utilitzar la comanda GROUP novament.
NICK_GROUP_CHANGE_DISABLED
	El teu nick ja esta registrat; escriu /msg %s DROP primer.
NICK_GROUP_SAME
	Ja ets membre del grup de %s.
NICK_GROUP_TOO_MANY
	N'hi ha molts nicks en el grup de %s; lllistals i treu-ne alguns.
	Escriu /msg %s HELP GLIST i /msg %s HELP DROP
	per ms informaci.
NICK_GROUP_JOINED
	Ara ets membre en el grup de %s.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY clau
NICK_IDENTIFY_FAILED
	Ho sento, la identificaci ha fallat.
NICK_IDENTIFY_SUCCEEDED
	Clau aceptada - Has estat reconegut.
NICK_IDENTIFY_EMAIL_REQUIRED
	Ara has de proveir un e-mail pel teu nick.
	Aquest e-mail et permetra recuperar la teva clau en
	cas de que la olvidis.
NICK_IDENTIFY_EMAIL_HOWTO
	Escriu /msg %S SET EMAIL e-mail per provar el teu e-mail.
	Respectems la teva privacitat; Aquest e-mail no sera entregat
	a cap persona.
	
# LOGOUT responses
NICK_ALREADY_IDENTIFIED
	You are already identified.

# UPDATE responses
NICK_UPDATE_SUCCESS
	Status updated (memos, vhost, chmodes, flags).
	
# LOGOUT responses
NICK_LOGOUT_SYNTAX
	LOGOUT
NICK_LOGOUT_SUCCEEDED
	El teu nick ha estat desconnectat.
NICK_LOGOUT_X_SUCCEEDED
	Nick %s ha estat desconnectat.

# DROP responses
NICK_LOGOUT_SERVICESADMIN
	Can't logout %s because he's a services administrator.

# DROP responses
NICK_DROP_DISABLED
	Ho sento, desenregistrament de nickname esta temporalment inhabilitat.
NICK_DROPPED
	El teu nickname ha estat expulsat.
NICK_X_DROPPED
	Nickname %s ha estat expulsat.

# SET responses
NICK_SET_SYNTAX
	SET opcio per ametres
NICK_SET_SERVADMIN_SYNTAX
	SET [nick] opcio per ametres
NICK_SET_DISABLED
	Ho sento, el seteig de Opcis per nicknames esta temporalment inhabilitat.
NICK_SET_UNKNOWN_OPTION
	Opcio SET desconeguda %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Opci SET desconoguda %s, o nickname no esta registrat.
NICK_SET_OPTION_DISABLED
	Opci %s no pot ser establerta en aquesta xarxa.

# SET DISPLAY responses
NICK_SET_DISPLAY_INVALID
	El nou display HA DE SER ser un nickname del teu grup de nicknames!
NICK_SET_DISPLAY_CHANGED
	El nou display es ara %s.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	Ho sento, el canvi de clau no pot ser completat.
NICK_SET_PASSWORD_CHANGED
	Clau canviada.
NICK_SET_PASSWORD_CHANGED_TO
	Clau canviada a %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE numero
NICK_SET_LANGUAGE_UNKNOWN
	Numero de llenguatge %d desconegut. Escriu /msg %s HELP SET LANGUAGE per una lllista de llenguatges.
NICK_SET_LANGUAGE_CHANGED
	Llenguatge canviat a Catal.

# SET URL responses
NICK_SET_URL_CHANGED
	URL canviada a %s.
NICK_SET_URL_UNSET
	URL no establerta.

# SET EMAIL responses
NICK_SET_EMAIL_CHANGED
	Adrea E-mail canviada a %s.
NICK_SET_EMAIL_UNSET
	Adrea E-mail no establerta.
NICK_SET_EMAIL_UNSET_IMPOSSIBLE
	No pots establir la teva adrea e-mail en aquesta xarxa.
	
# SET ICQ responses
NICK_SET_ICQ_CHANGED
	Numero ICQ establert a %s.
NICK_SET_ICQ_UNSET
	Numero ICQ no establert.
NICK_SET_ICQ_INVALID
	%s no es un numero vlid.
	
# SET GREET responses
NICK_SET_GREET_CHANGED
	Missatge de benvinguda canviat a %s.
NICK_SET_GREET_UNSET
	Missatge de benvinguda no establert.

# SET PROTECT responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	Protecci activada.
NICK_SET_KILL_QUICK
	La protecci esta activada, amb demora reduida.
NICK_SET_KILL_IMMED
	La protecci esta activada, sense demora.
NICK_SET_KILL_IMMED_DISABLED
	L'opci IMMED no esta disponible en aquesta xarxa.
NICK_SET_KILL_OFF
	La protecci esta desactivada.

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	L'opci de seguretat esta activada.
NICK_SET_SECURE_OFF
	L'opci de seguretat esta desactivada.

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	L'opci de privacitat esta activada.
NICK_SET_PRIVATE_OFF
	L'opci de privacitat esta desactivada.

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	La teva adrea e-mail no sera mostrada a %s INFO displays.
NICK_SET_HIDE_EMAIL_OFF
	La teva adrea e-mail sera mostrada a %s INFO displays.
NICK_SET_HIDE_MASK_ON
	La teva ultima mascara usuari@host no sera mostrada a %s INFO displays.
NICK_SET_HIDE_MASK_OFF
	La teva ultima mascara usuari@host sera mostrada a %s INFO displays.
NICK_SET_HIDE_QUIT_ON
	El teu ltim missatge quit no sera mostrat a %s INFO displays.
NICK_SET_HIDE_QUIT_OFF
	El teu ltim missatge quit sera mostrat a %s INFO displays.
	
# SET MSG responses
NICK_SET_MSG_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_MSG_ON
	Els serveis et respondran ara amb missatge.
NICK_SET_MSG_OFF
	Els serveis et respondran ara amb noticies.

# SET NOEXPIRE responses
NICK_SET_NOEXPIRE_SYNTAX
	SET [nickname] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	El Nick %s No caducara.
NICK_SET_NOEXPIRE_OFF
	El Nick %s caducara.

# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [mascara]
NICK_ACCESS_ALREADY_PRESENT
	La mascara %s ja esta present a la teva lllista d'accs.
NICK_ACCESS_REACHED_LIMIT
	Ho sento, sols pots tenir %d instncies a la teva lllista d'accs per nickname.
NICK_ACCESS_ADDED
	%s afegit a la teva lllista d'accs.
NICK_ACCESS_NOT_FOUND
	%s no trobat a la teva lllista d'accs.
NICK_ACCESS_DELETED
	%s esborrat de la teva lllista d'accs.
NICK_ACCESS_LIST
	Lllista d'accs:
NICK_ACCESS_LIST_X
	Lllista d'accs per %s:

# INFO responses
NICK_INFO_SYNTAX
	INFO nick [ALL]
NICK_INFO_REALNAME
	%s es %s
NICK_INFO_SERVICES_OPER
	%s es un operador de serveis.
NICK_INFO_SERVICES_ADMIN
	%s es un administrador de serveis.
NICK_INFO_ADDRESS
	Ultima adrea vista: %s
NICK_INFO_ADDRESS_ONLINE
	   Esta en linea desde: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s Esta actualment online.
NICK_INFO_TIME_REGGED
	     Temps registrat: %s
NICK_INFO_LAST_SEEN
	      Ultima vegada vist: %s
NICK_INFO_LAST_QUIT
	   ltim missatge quit: %s
NICK_INFO_URL
	                   URL: %s
NICK_INFO_EMAIL
	      Adrea E-mail: %s
NICK_INFO_VHOST
	            vhost: %s
NICK_INFO_ICQ
	                 ICQ #: %d
NICK_INFO_GREET
	 Missatge de benvinguda: %s
NICK_INFO_OPTIONS
	              Opcis: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Protecci
NICK_INFO_OPT_SECURE
	Segur
NICK_INFO_OPT_PRIVATE
	Privat
NICK_INFO_OPT_MSG
	Mode de missatge
NICK_INFO_OPT_NONE
	Cap
NICK_INFO_NO_EXPIRE
	Aquest nickname no caducara.
NICK_INFO_FOR_MORE
	Per ms informaci, escriu /msg %s INFO %s ALL.

# LIST responses
NICK_LIST_SYNTAX
	LIST patro
NICK_LIST_SERVADMIN_SYNTAX
	LIST patro [FORBIDDEN] [NOEXPIRE]
NICK_LIST_HEADER
	Lllista de resultats concordant %s:
NICK_LIST_RESULTS
	Fi de la lllista - %d/%d resultat(s) mostrat(s).

# GLIST responses
NICK_ALIST_SYNTAX
	ALIST nickname
NICK_ALIST_HEADER
	Channels that you have access on:
	  Num  Channel              Level    Description 
NICK_ALIST_HEADER_X
	Channels that %s has access on:
	  Num  Channel              Level    Description 
NICK_ALIST_XOP_FORMAT
	  %3d %c%-20s %-8s %s
NICK_ALIST_ACCESS_FORMAT
	  %3d %c%-20s %-8d %s
NICK_ALIST_FOOTER
	Fi de la lllista - %d/%d resultat(s) mostrat(s).

# GLIST responses
NICK_GLIST_HEADER
	Lllista de nicknames en el teu grup:
NICK_GLIST_HEADER_X
	Lllista de nicknames en el grup de %s:
NICK_GLIST_FOOTER
	%d nicknames en el grup.

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER nickname [clau]
NICK_NO_RECOVER_SELF
	No pots recuperar-te a tu mateix!
NICK_RECOVERED
	L'usuari demanant el teu nick ha estat expulsat.
	/msg %s RELEASE %s per recuperar-lo abans del minut de time-out.

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE nickname [clau]
NICK_RELEASE_NOT_HELD
	El nick %s no esta sent utilitzat.
NICK_RELEASED
	El teu nick ha estat alliberat pels serveis.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST nickname [clau]
NICK_NO_GHOST_SELF
	No pots fer GHOST a tu mateix!
NICK_GHOST_KILLED
	El ghost amb el teu nick ha estat expulsat.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS nickname
NICK_GETPASS_UNAVAILABLE
	La comanda GETPASS no esta disponible per l'us d'encriptaci.
NICK_GETPASS_PASSWORD_IS
	La clau per %s es %s.
	
# SENDPASS responses
NICK_GETEMAIL_SYNTAX
	GETEMAIL user@email-host No WildCards!!
NICK_GETEMAIL_EMAILS_ARE
	Emails Match %s to %s.
NICK_GETEMAIL_NOT_USED
	No Emails listed for %s.
	
# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS nickname
NICK_SENDPASS_UNAVAILABLE
	La comanda SENDPASS no esta disponible per l'us d'encriptaci.
NICK_SENDPASS_SUBJECT
	Clau pel Nickname (%s)
NICK_SENDPASS_HEAD
	Hola,
NICK_SENDPASS_LINE_1
	El teu has demanat rebre la clau pel nickname %s via e-mail.
NICK_SENDPASS_LINE_2
	La clau es %s. Per raons de seguretat hauries de canviar-la quant rebis aquest mail.
NICK_SENDPASS_LINE_3
	Si no saps per que aquest mail t'ha estat enviat, per favor ignora'l.
NICK_SENDPASS_LINE_4
	Per favor NO RESPONGUIS a aquest EMAIL!
NICK_SENDPASS_LINE_5
	Administradors de %s.
NICK_SENDPASS_OK
	La clau de %s ha estat enviada.

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID nickname [rao]
NICK_FORBID_SYNTAX_REASON
	FORBID nickname rao
NICK_FORBID_SUCCEEDED
	El nick %s esta prohibit.
NICK_FORBID_FAILED
	La prohibici de %s no es possible!

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
NICK_REQUESTED
	This nick has already been requested, please check your e-mail address for the pass code
NICK_REG_RESENT
	Your passcode has been re-sent to %s.
NICK_REG_UNABLE
	Nick NOT registered, please try again later.
NICK_IS_PREREG
	This nick is awaiting an e-mail verification code before completing registration.
NICK_ENTER_REG_CODE
	A passcode has been sent to %s, please type /msg %s confirm <passcode> to complete registration
NICK_CONFIRM_NOT_FOUND
	Registration step 1 may have expired, please use "/msg %s register <password> <email>" first.
NICK_CONFIRM_INVALID
	Invalid passcode has been entered, please check the e-mail again, and retry
NICK_REG_MAIL_SUBJECT
	Nickname Registration (%s)
NICK_REG_MAIL_HEAD
	Hi,
NICK_REG_MAIL_LINE_1
	You have requested to register the following nickname %s.
NICK_REG_MAIL_LINE_2
	Please type " /msg %s confirm %s " to complete registration.
NICK_REG_MAIL_LINE_3
	If you don't know why this mail is sent to you, please ignore it silently.
NICK_REG_MAIL_LINE_4
	PLEASE DON'T ANSWER TO THIS MAIL!
NICK_REG_MAIL_LINE_5
	%s administrators.
NICK_GETPASS_PASSCODE_IS
	Passcode for %s is %s.
NICK_FORCE_REG
	Nickname %s confirmed

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Status automtic d'operador de canal
CHAN_LEVEL_AUTOVOICE
	Mode automtico +v
CHAN_LEVEL_AUTOHALFOP
	Mode automtic +h
CHAN_LEVEL_AUTOPROTECT
	Mode automtic +a
CHAN_LEVEL_AUTODEOP
	Status d'operador de canal inhabilitat
CHAN_LEVEL_NOJOIN
	No es possible entra a un canal si esta RESTRINGIT
CHAN_LEVEL_INVITE
	Abilitat a utilitzar la comanda INVITE
CHAN_LEVEL_AKICK
	Abilitat a utilitzar la comanda AKICK
CHAN_LEVEL_SET
	Abilitat a utilitzar la comanda SET (no FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	Abilitat a utilitzar la comanda CLEAR
CHAN_LEVEL_UNBAN
	Abilitat a utilitzar la comanda UNBAN
CHAN_LEVEL_OPDEOP
	Abilitat a utilitzar la comanda OP/DEOP
CHAN_LEVEL_ACCESS_LIST
	Abilitat a veure la lllista de accs
CHAN_LEVEL_ACCESS_CHANGE
	Abilitat a modificar la lllista de accs
CHAN_LEVEL_MEMO
	Abilitat a llistar/llegir memos del canal
CHAN_LEVEL_ASSIGN
	Abilitat a assignar/deassignar un bot
CHAN_LEVEL_BADWORDS
	Abilitat a utilitzar la comanda BADWORDS
CHAN_LEVEL_NOKICK
	Mai expulsat pels kicks del bot
CHAN_LEVEL_FANTASIA
	Abilitat a utilizar comandes de fantasia
CHAN_LEVEL_SAY
	Abilitat a utilitzar la comanda SAY i ACT
CHAN_LEVEL_GREET
	Missatge de benvinguda mostrat
CHAN_LEVEL_VOICEME
	Autorizat a voice/devoice a tu mateix
CHAN_LEVEL_VOICE
	Abilitat a utilitzar La comanda VOICE/DEVOICE
CHAN_LEVEL_GETKEY
	Abilitat a utilitzar La comanda GETKEY
CHAN_LEVEL_OPDEOPME
	Autorizat a op/deop a tu mateix
CHAN_LEVEL_HALFOPME
	Autorizat a halfop/dehalfop a tu mateix
CHAN_LEVEL_HALFOP
	Abilitat a utilitzar la comanda HALFOP/DEHALFOP
CHAN_LEVEL_PROTECTME
	Autorizat a protect/deprotect a tu mateix
CHAN_LEVEL_PROTECT
	Abilitat a utilitzar la comanda PROTECT/DEPROTECT
CHAN_LEVEL_KICKME
	Autoritzat a expulsar-te a tu mateix
CHAN_LEVEL_KICK
	Abilitat a utilitzar la comanda KICK
CHAN_LEVEL_SIGNKICK
	Sense firma de kick quant SIGNKICK LEVEL es utilitzat
CHAN_LEVEL_BANME
	Autoritzat a banegar-te
CHAN_LEVEL_BAN
	Autoritzat a utilitzar la comanda BAN
CHAN_LEVEL_TOPIC
	Autoritzat a utilitzar la comanda TOPIC
CHAN_LEVEL_INFO
	Autoritzar a utilitzar La comanda INFO amb
	l'opci ALL

# Automatic responses
CHAN_IS_REGISTERED
	Aquest canal ha estat registrat amb %s.
CHAN_NOT_ALLOWED_OP
	No estas autoritzat al status d'operador del canal a %s.
CHAN_MAY_NOT_BE_USED
	Aquest canal esta prohibit.
CHAN_NOT_ALLOWED_TO_JOIN
	No estas autoritzat a estar en aquest canal.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER canal clau descripci
CHAN_REGISTER_DISABLED
	Ho sento, el registre de canals esta temporalment inhabilitat.
CHAN_REGISTER_NOT_LOCAL
	Canals locals no poden ser enregistrats.
CHAN_MUST_REGISTER_NICK
	Has de registrar el teu nickname primer. Escriu /msg %s HELP per ms informaci de com registrar nicknames.
CHAN_MUST_IDENTIFY_NICK
	Per favor primer identifica't amb %s, utilitzant la comanda:
	/msg %s IDENTIFY clau
CHAN_MAY_NOT_BE_REGISTERED
	El canal %s no pot ser enregistrat.
CHAN_ALREADY_REGISTERED
	El canal %s ja esta enregistrat!
CHAN_MUST_BE_CHANOP
	Has de ser un operador de canal per registrar el canal.
CHAN_REACHED_CHANNEL_LIMIT
	Ho sento, has arribat al teu lmit de %d canals.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Ho sento, has sobrepassat el teu lmit de %d canals.
CHAN_REGISTRATION_FAILED
	Ho sento, la registraci ha fallat.
CHAN_REGISTERED
	El canal %s esta registrat sota el teu nickname: %s
CHAN_PASSWORD_IS
	La teva clau pel canal es %s - Recorda-la per un us futur.

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY canal clau
CHAN_IDENTIFY_FAILED
	Ho sento, la identificaci ha fallat.
CHAN_IDENTIFY_SUCCEEDED
	Clau aceptada - ara tens nivell de fundador a %s.

# LOGOUT responses
CHAN_LOGOUT_SYNTAX
	LOGOUT canal nickname
CHAN_LOGOUT_SERVADMIN_SYNTAX
	LOGOUT canal [nickname]
CHAN_LOGOUT_SUCCEEDED
	L'usuari %s ha estat desconnectat del canal %s.
CHAN_LOGOUT_ALL_SUCCEEDED
	Tots els usuaris identificats han estat desconnectats del canal %s.

# DROP responses
CHAN_DROP_SYNTAX
	DROP canal
CHAN_DROP_DISABLED
	Ho sento, el desenregistrament de canals esta temporalment desabilitat.
CHAN_DROPPED
	El canal %s ha estat eliminat.

# SET responses
CHAN_SET_SYNTAX
	SET canal opci per ametres
CHAN_SET_DISABLED
	Ho sento, l'establiment d'Opcis de canal esta temporalment deshAbilitat.
CHAN_SET_UNKNOWN_OPTION
	Opci SET %s desconoceguda.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s te masses canals registrats.
CHAN_FOUNDER_CHANGED
	El Fundador de %s cambiat a %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	Sucessor de %s cambiat a %s.
CHAN_SUCCESSOR_UNSET
	Sucessor de %s desabilitat.
CHAN_SUCCESSOR_IS_FOUNDER
	%s no pot ser el sucessor en el canal %s ja que n'es el fundador.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	Ho sento, l'establiment de la clau no ha estat possible.
CHAN_PASSWORD_CHANGED
	Clau per a %s canviada.
CHAN_PASSWORD_CHANGED_TO
	La clau per a %s canviada a %s.

# SET DESC responses
CHAN_DESC_CHANGED
	La descripci de %s canviada a%s.

# SET URL responses
CHAN_URL_CHANGED
	URL per a %s canviada a %s.
CHAN_URL_UNSET
	URL per a %s no establerta.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	Adrea e-mail per a %s canviada a %s.
CHAN_EMAIL_UNSET
	Adrea e-mail per a %s no establerta.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	Missatge d'entrada per a %s canviat.
CHAN_ENTRY_MSG_UNSET
	Missatge d'entrada per a %s no establert.
	
# SET BANTYPE responses
CHAN_SET_BANTYPE_INVALID
	%s no es un tipus de ban valid.
CHAN_SET_BANTYPE_CHANGED
	Tipus de ban pel canal %s es ara #%d.

# SET MLOCK responses
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Carcter de Mode %c desconegut i ignorat.
CHAN_SET_MLOCK_IMPOSSIBLE_CHAR
	Mode %c ignorat per que no pots lockerjar-lo???.
CHAN_SET_MLOCK_L_REQUIRED
	Has d'utilitzar Mode de lock +l tamb pel Mode
	de lock +L.
CHAN_SET_MLOCK_K_REQUIRED
	Has d'utilitzar Mode de lock +i tambe pel Mode
	de lock +K.
CHAN_MLOCK_CHANGED
	Mode de lock en el canal %s canviat a %s.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET canal KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Retenci de topic activat.
CHAN_SET_KEEPTOPIC_OFF
	Retenci de topic desactivada.

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET canal TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Lock de topic activat.
CHAN_SET_TOPICLOCK_OFF
	Lock de topic desactivat.

# SET PEACE responses
CHAN_SET_PEACE_SYNTAX
	SET canal PEACE {ON | OFF}
CHAN_SET_PEACE_ON
	Opci de pau Activada.
CHAN_SET_PEACE_OFF
	Opci de pau desactivada.

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET canal PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Opci de privacitat activada.
CHAN_SET_PRIVATE_OFF
	Opci de privacitat desactivada.

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET canal SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Seguretat d'ops activada.
CHAN_SET_SECUREOPS_OFF
	Seguretat d'ops desactivada.
	
# SET SECUREFOUNDER responses
CHAN_SET_SECUREFOUNDER_SYNTAX
	SET canal SECUREFOUNDER {ON | OFF}
CHAN_SET_SECUREFOUNDER_ON
	Seguretat de fundador activada.
CHAN_SET_SECUREFOUNDER_OFF
	Seguretat de fundador desactivada.

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET canal RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	accs restringiy activat.
CHAN_SET_RESTRICTED_OFF
	accs restringit desactivat.

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET canal SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	Opci de seguretat activada.
CHAN_SET_SECURE_OFF
	Opci de seguretat desactivada.
	
# SET SIGNKICK responses
CHAN_SET_SIGNKICK_SYNTAX
	SET canal SIGNKICK {ON | LEVEL | OFF}
CHAN_SET_SIGNKICK_ON
	Opci de kick signat activada.
CHAN_SET_SIGNKICK_LEVEL
	Opci de kick signat activada, per depen del nivell de 
	l'usuari que utilitzi la comanda.
CHAN_SET_SIGNKICK_OFF
	Opci de kick firmat desactivada.

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET canal OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Opci Op-notice activada.
CHAN_SET_OPNOTICE_OFF
	Opci Op-notice desactivada.

# SET XOP responses
CHAN_SET_XOP_SYNTAX
	SET canal XOP {ON | OFF}
CHAN_SET_XOP_ON
	El sistema de llistes xOP ara Engegat.
CHAN_SET_XOP_OFF
	El sistema de llistes xOP ara Aturat.

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET canal NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	El canal %s no caducara.
CHAN_SET_NOEXPIRE_OFF
	El canal %s caducara.

# xOP messages
CHAN_XOP_REACHED_LIMIT
	Ho sento, sols pots tenir %d instncies de AOP/SOP/VOP
	en un canal.
CHAN_XOP_LIST_FORMAT
	  %3d  %s
CHAN_XOP_ACCESS
	No pots utilitzar aquesta comanda. Utilitza la comanda ACCESS.
	Escriu /msg %s HELP ACCESS per ms informaci.

# AOP messages
CHAN_AOP_SYNTAX
	AOP canal {ADD|DEL|LIST|CLEAR} [nick | instncia]
CHAN_AOP_DISABLED
	Ho sento, la modificaci de la llista AOP de canals esta
	temporalment deshabilitada.
CHAN_AOP_NICKS_ONLY
	La llista de AOP de canals noms pot contenir nicks
	registrats.
CHAN_AOP_ADDED
	%s afegit a la llista AOP de %s.
CHAN_AOP_MOVED
	%s moved to %s AOP list.
CHAN_AOP_NO_SUCH_ENTRY
	No existeix la instncia (#%d) a la llista AOP de %s.
CHAN_AOP_NOT_FOUND
	%s no trobat a la llista AOP de %s.
CHAN_AOP_NO_MATCH
	No existeixen instncies coincidents a la llista AOP de %s.
CHAN_AOP_DELETED
	%s esborrat de la llista AOP de %s.
CHAN_AOP_DELETED_ONE
	1 instncia esborrada de la llista AOP de %s.
CHAN_AOP_DELETED_SEVERAL
	%d instncies esborrades de la llista AOP de %s.
CHAN_AOP_LIST_EMPTY
	La llista AOP de %s esta buida.
CHAN_AOP_LIST_HEADER
	Llista AOP per a %s:
	  Num  Nick
CHAN_AOP_CLEAR
	La llista AOP de canals ha estat netegada.

# HOP messages
CHAN_HOP_SYNTAX
	HOP canal {ADD|DEL|LIST|CLEAR} [nick | llista]
CHAN_HOP_DISABLED
	Ho sento, la modificaci de llistes HOP de canals esta
	temporalment deshabilitada.
CHAN_HOP_NICKS_ONLY
	Llistes HOP de canals sols pot tenir nicks registrats.
CHAN_HOP_ADDED
	%s afegit a la llista HOP de %s.
CHAN_HOP_MOVED
	%s moved to %s HOP list.
CHAN_HOP_NO_SUCH_ENTRY
	No existeix la instncia (#%d) a la llista HOP de %s.
CHAN_HOP_NOT_FOUND
	%s no trobat a la llista HOP de %s.
CHAN_HOP_NO_MATCH
	No existeixen instncies coincidents a la llista HOP de %s.
CHAN_HOP_DELETED
	%s esborrat de la llista HOP de %s.
CHAN_HOP_DELETED_ONE
	1 instncia esborrada de la llista HOP de %s.
CHAN_HOP_DELETED_SEVERAL
	%d instncies esborrades de la llista HOP de %s.
CHAN_HOP_LIST_EMPTY
	La llista HOP de %s esta buida.
CHAN_HOP_LIST_HEADER
	Llista HOP per a %s:
	  Num  Nick
CHAN_HOP_CLEAR
	La llista HOP de canals ha estat netegada.

# SOP messages
CHAN_SOP_SYNTAX
	SOP canal {ADD|DEL|LIST|CLEAR} [nick | llista]
CHAN_SOP_DISABLED
	Ho sento, la modificaci de la llista SOP de canals esta
	temporalment deshabilitada.
CHAN_SOP_NICKS_ONLY
	Llistes SOP de canals sols pot tenir nicks registrats.
CHAN_SOP_ADDED
	%s afegit a la llista SOP de %s.
CHAN_SOP_MOVED
	%s moved to %s SOP list.
CHAN_SOP_NO_SUCH_ENTRY
	No existeix la instncia (#%d) a la llista SOP de %s.
CHAN_SOP_NOT_FOUND
	%s no trobat a la llista SOP de %s.
CHAN_SOP_NO_MATCH
	No existeixen instncies coincidents a la llista SOP de %s.
CHAN_SOP_DELETED
	%s esborrat de la llista SOP de %s.
CHAN_SOP_DELETED_ONE
	1 instncia esborrada de la llista SOP de %s.
CHAN_SOP_DELETED_SEVERAL
	%d instncies esborrades de la llista SOP de %s.
CHAN_SOP_LIST_EMPTY
	La llista SOP de %s esta buida.
CHAN_SOP_LIST_HEADER
	Llista SOP per a %s:
	  Num  Nick
CHAN_SOP_CLEAR
	La llista HOP de canals ha estat netegada.

# VOP messages
CHAN_VOP_SYNTAX
	VOP canal {ADD|DEL|LIST|CLEAR} [nick | llista]
CHAN_VOP_DISABLED
	Ho sento, la modificaci de la llista VOP de canals esta
	temporalment deshabilitada.
CHAN_VOP_NICKS_ONLY
	Llistes VOP de canals sols pot tenir nicks registrats.
CHAN_VOP_ADDED
	%s afegit a la llista VOP de %s.
CHAN_VOP_MOVED
	%s moved to %s VOP list.
CHAN_VOP_NO_SUCH_ENTRY
	No existeix la instncia (#%d) a la llista VOP de %s.
CHAN_VOP_NOT_FOUND
	%s no trobat a la llista VOP de %s.
CHAN_VOP_NO_MATCH
	No existeixen instncies coincidents a la llista VOP de %s.
CHAN_VOP_DELETED
	%s esborrat de la llista VOP de %s.
CHAN_VOP_DELETED_ONE
	1 instncia esborrada de la llista VOP de %s.
CHAN_VOP_DELETED_SEVERAL
	%d instncies esborrades de la llista VOP de %s.
CHAN_VOP_LIST_EMPTY
	La llista VOP de %s esta buida.
CHAN_VOP_LIST_HEADER
	Llista VOP per a %s:
	  Num  Nick
CHAN_VOP_CLEAR
	La llista HOP de canals ha estat netegada.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS canal {ADD|DEL|LIST|CLEAR} [nick [nivell] | llista]
CHAN_ACCESS_XOP
	No pots utilitzar aquest comanda.
	Utilitza les comandes AOP, SOP i VOP.
	Escriu /msg %s HELP comanda per a ms informaci.
CHAN_ACCESS_DISABLED
	Ho sento, la modificaci d'accs a canals esta temporalment inabilitada.
CHAN_ACCESS_LEVEL_NONZERO
	El nivell de accs no pot ser zero.
CHAN_ACCESS_LEVEL_RANGE
	El nivell d'accs ha de ser entre %d i %d inclosos.
CHAN_ACCESS_NICKS_ONLY
	Las llistes de accs a canals sols pot contenir nicks registrats.
CHAN_ACCESS_REACHED_LIMIT
	Ho sento, sols pots tenir %d instncies d'accs en un determinat canal.
CHAN_ACCESS_LEVEL_UNCHANGED
	Nivell d'accs per a %s en %s no cambiada de %d.
CHAN_ACCESS_LEVEL_CHANGED
	Nivell d'accs per a %s en %s cambiada a %d.
CHAN_ACCESS_ADDED
	%s afegit a la llista d'accs de %s amb nivel %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	No existeix (#%d) a la llista d'accs de %s.
CHAN_ACCESS_NOT_FOUND
	%s no trobat a la llista d'accs de %s.
CHAN_ACCESS_NO_MATCH
	No hi ha instncies que concordin a la llista d'accs de %s .
CHAN_ACCESS_DELETED
	%s esborrat de la llista d'accs de %s.
CHAN_ACCESS_DELETED_ONE
	1 instncia esborrada de la llista d'accs de %s.
CHAN_ACCESS_DELETED_SEVERAL
	%d instncies esborrades de la llista d'accs de %s.
CHAN_ACCESS_LIST_EMPTY
	La llista d'accs de %s esta buida.
CHAN_ACCESS_LIST_HEADER
	Llista d'accs per a %s:
	  Num   Niv  Nick
CHAN_ACCESS_LIST_FOOTER
	fi de llista d'accs.
CHAN_ACCESS_LIST_XOP_FORMAT
	  %3d   %s  %s
CHAN_ACCESS_LIST_AXS_FORMAT
	  %3d  %4d  %s
CHAN_ACCESS_CLEAR
	La llista d'accs pel canal ha estat netegada.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK canal {ADD | STICK | UNSTICK | DEL | LIST | VIEW | ENFORCE | CLEAR} [nick-o-mascara] [rao]
CHAN_AKICK_DISABLED
	Ho sento, la modificaci de kicks automtics a canals esta temporalment inabilitada.
CHAN_AKICK_ALREADY_EXISTS
	%s ja esta present a la llista de kick automtic en el canal %s.
CHAN_AKICK_REACHED_LIMIT
	Ho sento, sols pots tenir %d mascaras per a kicks automtics a un canal.
CHAN_AKICK_ADDED
	%s afegit a la llista de kicks automtics en el canal %s.
CHAN_AKICK_NO_SUCH_ENTRY
	La instncia (#%d) no existeix a la llista de kicks automtics en el canal %s.
CHAN_AKICK_NOT_FOUND
	%s no trobat a la llista de kicks automtics en el canal %s.
CHAN_AKICK_NO_MATCH
	No existeixen instncies que concordin a la llista de kicks automtics en el canal %s.
CHAN_AKICK_STUCK
	%s esta ara sempre actiu en el canal %s.
CHAN_AKICK_UNSTUCK
	%s ja no esta sempre actiu en el canal %s.
CHAN_AKICK_DELETED
	%s esborrat de la llista de kicks automtics del canal %s.
CHAN_AKICK_DELETED_ONE
	1 instncia esborrada de la llista de kicks automtics del canal %s.
CHAN_AKICK_DELETED_SEVERAL
	%d instncies esborrades de la llista de kicks automtics del canal %s.
CHAN_AKICK_LIST_EMPTY
	La llista de kicks automtics del canal %s esta buida.
CHAN_AKICK_LIST_HEADER
	Llista de kicks automtics pel canal %s:
CHAN_AKICK_LIST_FORMAT
	  %3d %s (%s)
CHAN_AKICK_VIEW_FORMAT
	%3d %s (per %s en %s)
	    %s
CHAN_AKICK_VIEW_FORMAT_STUCK
	%3d %s (enganxat) (per %s en %s)
	    %s
CHAN_AKICK_ENFORCE_DONE
	AKICK ENFORCE en %s completa; %d usuaris afectats.
CHAN_AKICK_CLEAR
	La llista de kicks automtics ha estat netegada.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS canal {SET | DIS[ABLE] | LIST | RESET} [item [nivell]]
CHAN_LEVELS_XOP
	Aquesta comanda es inservible en aquest mode.
CHAN_LEVELS_RANGE
	El nivell ha d'estar entre %d i %d inclosos.
CHAN_LEVELS_CHANGED
	Nivell per a %s en el canal %s cambiat a %d.
CHAN_LEVELS_UNKNOWN
	Opci %s no coneguda. Escriu /msg %s HELP LEVELS DESC per a una llista de opcins valides.
CHAN_LEVELS_DISABLED
	%s inhabilitat(s) en el canal %s.
CHAN_LEVELS_LIST_HEADER
	Opcions del nivell d'accs pel canal %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (inhabilitat)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (noms el fundador)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %d
CHAN_LEVELS_RESET
	Nivells d'accs per a %s canviats als valors originals.

# INFO responses
CHAN_INFO_SYNTAX
	INFO canal [ALL]
CHAN_INFO_HEADER
	Informaci pel canal %s:
CHAN_INFO_FOUNDER
	          Fundador: %s (%s)
CHAN_INFO_NO_FOUNDER
	          Fundador: %s
CHAN_INFO_SUCCESSOR
	           Successor: %s (%s)
CHAN_INFO_NO_SUCCESSOR
	           Successor: %s
CHAN_INFO_DESCRIPTION
	       Descripci: %s
CHAN_INFO_ENTRYMSG
	Missatge d'entrada: %s
CHAN_INFO_TIME_REGGED
	        Registrat: %s
CHAN_INFO_LAST_USED
	  ltim cop utilitzat: %s
CHAN_INFO_LAST_TOPIC
	      ltim tpic: %s
CHAN_INFO_TOPIC_SET_BY
	 Tpic establert per: %s
CHAN_INFO_URL
	               URL: %s
CHAN_INFO_EMAIL
	  Adrea e-mail: %s
CHAN_INFO_BANTYPE
	       Tipus de ban: %d
CHAN_INFO_OPTIONS
	          Opcions: %s
CHAN_INFO_OPT_KEEPTOPIC
	Retenci de tpic
CHAN_INFO_OPT_OPNOTICE
	Notcia de OP
CHAN_INFO_OPT_PEACE
	Pau
CHAN_INFO_OPT_PRIVATE
	Privat
CHAN_INFO_OPT_RESTRICTED
	accs restringit
CHAN_INFO_OPT_SECURE
	Segur
CHAN_INFO_OPT_SECUREOPS
	Ops Segurs
CHAN_INFO_OPT_SECUREFOUNDER
	Fundador Segur
CHAN_INFO_OPT_SIGNKICK
	Kicks Signats
CHAN_INFO_OPT_TOPICLOCK
	Lock de tpic
CHAN_INFO_OPT_XOP
	Sistema de llistes xOP
CHAN_INFO_OPT_NONE
	Cap
CHAN_INFO_MODE_LOCK
	      Mode de lock: %s
CHAN_INFO_NO_EXPIRE
	Aquest canal no caducara.

# LIST responses
CHAN_LIST_SYNTAX
	LIST patr
CHAN_LIST_SERVADMIN_SYNTAX
	LIST patr [FORBIDDEN] [NOEXPIRE]
CHAN_LIST_HEADER
	Llista de instncies concordant a %s:
CHAN_LIST_FORMAT
	    %-20s  %s
CHAN_LIST_END
	Fi de la llista - %d/%d concordncia(es) mostrada(es).
	
# CLIST responses
CHAN_INVITE_SYNTAX
	INVITE canal

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN canal
CHAN_UNBANNED
	Has estat desbanegat de %s.

# TOPIC responses
CHAN_TOPIC_SYNTAX
	TOPIC canal [tpic]

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR canal Modes-a-netegar
CHAN_CLEARED_BANS
	Tots els bans del canal %s han estat esborrats.
CHAN_CLEARED_EXCEPTS
	Tots els excepts del canal %s han estat esborrats.
CHAN_CLEARED_MODES
	Tots els modes en el canal %s han estat reestablerts.
CHAN_CLEARED_OPS
	Mode +o ha estat reestablert del canal %s.
CHAN_CLEARED_VOICES
	Mode +v ha estat eliminat del canal %s.
CHAN_CLEARED_USERS
	Tots els usuaris han estat kickegats del canal %s.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS canal
CHAN_GETPASS_UNAVAILABLE
	Comanda GETPASS no permessa per que encriptaci esta en s.
CHAN_GETPASS_PASSWORD_IS
	La clau pel canal %s es %s.
	
# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS canal
CHAN_SENDPASS_UNAVAILABLE
	Comanda SENDPASS no permessa per que encriptaci esta en s.
CHAN_SENDPASS_SUBJECT
	Clau del canal (%s)
CHAN_SENDPASS_HEAD
	Hola,
CHAN_SENDPASS_LINE_1
	Has sol.licitat rebre la clau del canal %s per e-mail.
CHAN_SENDPASS_LINE_2
	La clau es %s. Per raons de seguretat hauries de cambiar-la quant rebis aquest mail.
CHAN_SENDPASS_LINE_3
	Si no saps per que has rebut aquest mail, per favor ignora'l.
CHAN_SENDPASS_LINE_4
	Per favor NO RESPONGUIS a aquest email!
CHAN_SENDPASS_LINE_5
	Administradors de %s.
CHAN_SENDPASS_OK
	La clau de %s ha estat enviada.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID canal [ra]
CHAN_FORBID_SYNTAX_REASON
	FORBID canal ra
CHAN_FORBID_SUCCEEDED
	Canal %s ara prohibit.
CHAN_FORBID_FAILED
	Impossible prohibir el canal %s!

# Misc responses
CHAN_FORBID_REASON
	This channel has been forbidden.

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND channel [reason]
CHAN_SUSPEND_SYNTAX_REASON
	SUSPEND channel reason
CHAN_SUSPEND_SUCCEEDED
	Channel %s is now suspended.
CHAN_SUSPEND_FAILED
	Couldn't suspended channel %s!
CHAN_SUSPEND_REASON
	This channel has been suspended.

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND channel
CHAN_UNSUSPEND_ERROR
	No # found in front of channel name.
CHAN_UNSUSPEND_SUCCEEDED
	Channel %s is now released.
CHAN_UNSUSPEND_FAILED
	Couldn't release channel %s!

# Misc responses
CHAN_EXCEPTED
	%s matches an except on %s and cannot be banned until the except have been removed.

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	Tens 1 memo nou.
MEMO_HAVE_NEW_MEMOS
	Tens %d memos nous.
MEMO_TYPE_READ_LAST
	Escriu /msg %s READ LAST per llegir el teu ltim memo.
MEMO_TYPE_READ_NUM
	Escriu /msg %s READ %d per a llegir-lo.
MEMO_TYPE_LIST_NEW
	Escriu /msg %s LIST NEW per a llistar els teus memos.
MEMO_AT_LIMIT
	Advertncia: Has assolit el mxim numero de memos (%d). No podras rebre mes memos fins que esborris alguns dels existents.
MEMO_OVER_LIMIT
	Advertncia: Has sobrepassat el mximo numero de memos (%d). Et resultara impossible rebre ms memos fins que esborris alguns dels existents.
MEMO_X_MANY_NOTICE
	There are %d memos on channel %s.
MEMO_X_ONE_NOTICE
	There is %d memo on channel %s.
MEMO_NEW_X_MEMO_ARRIVED
	There is a new memo on channel %s.
	Type /msg %s READ %s %d to read it.
MEMO_NEW_MEMO_ARRIVED
	Tens un nou memo de %s.
	Escriu /msg %s READ %d per a llegir-lo.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	No tens memos.
MEMO_X_HAS_NO_MEMOS
	%s no te memos.
MEMO_DOES_NOT_EXIST
	El memo %d no existeix!
MEMO_LIST_NOT_FOUND
	No existeixen memos que concordin.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {nick | canal} text
MEMO_SEND_DISABLED
	Ho sento, l'enviament de memos esta temporalment inhabilitat.
MEMO_SEND_PLEASE_WAIT
	Per favor espera %d segons abans d'utilizar la comanda SEND un altre cop.
MEMO_X_GETS_NO_MEMOS
	%s no pot rebre memos.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s actualment te molts memos i no pot rebre'n mes.
MEMO_SENT
	Memo enviat a %s.
	
# CANCEL responses
MEMO_MASS_SENT
	A massmemo has been sent to all registered users.
	
# CANCEL responses
MEMO_CANCEL_SYNTAX
	CANCEL {nick | canal}
MEMO_CANCEL_DISABLED
	Ho sento, la cancel.laci de memos esta temporalment inabilitada.
MEMO_CANCEL_NONE
	Cap memo pot ser cancelat.
MEMO_CANCELLED
	Ultim memo enviat a %s va ser cancel.lat.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [canal] [llista | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	No tens memos nous.
MEMO_X_HAS_NO_NEW_MEMOS
	%s no te memos nous.
MEMO_LIST_MEMOS
	Memos per a %s. per a llegir-los escriu: /msg %s READ numero
MEMO_LIST_NEW_MEMOS
	Nous memos per a %s. per a llegir-los escriu: /msg %s READ numero
MEMO_LIST_CHAN_MEMOS
	Memos per a %s. per a llegir-los escriu: /msg %s READ %s numero
MEMO_LIST_CHAN_NEW_MEMOS
	Nous memos per a %s. Per a llegir-los escriu: /msg %s READ %s numero
MEMO_LIST_HEADER
	 Num  De                Data/Hora
MEMO_LIST_FORMAT
	%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [canal] {llista | LAST | NEW}
MEMO_HEADER
	Memo %d de %s (%s). per a esborrar-lo escriu: /msg %s DEL %d
MEMO_CHAN_HEADER
	Memo %d de %s (%s). per a esborrar-lo escriu: /msg %s DEL %s %d
MEMO_TEXT
	%s

# DEL responses
MEMO_DEL_SYNTAX
	DEL [canal] {numero | llista | ALL}
MEMO_DELETED_NONE
	Cap memo fou esborrat.
MEMO_DELETED_ONE
	Memo %d ha estat esborrat.
MEMO_DELETED_SEVERAL
	Els memos %s han estat esborrats.
MEMO_DELETED_ALL
	Tots els teus memos han estat esborrats.

# SET responses
MEMO_CHAN_DELETED_ALL
	All memos for channel %s have been deleted.

# SET responses
MEMO_SET_SYNTAX
	SET Opci parametres
MEMO_SET_DISABLED
	Ho sento, l'establiment d'opcions per a memos esta temporalment inhabilitat.
MEMO_SET_UNKNOWN_OPTION
	Opci SET %s desconeguda.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s ara et notificara dels teus memos quant et conectis i quant et siguin enviats.
MEMO_SET_NOTIFY_LOGON
	%s ara et notificara dels teus memos quant et conectis o treguis el teu /AWAY.
MEMO_SET_NOTIFY_NEW
	%s ara te notificara dels teus memos quant se t'enviin.
MEMO_SET_NOTIFY_OFF
	%s no t'enviara cap notificaci dels teus memos.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [canal] lmit
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [usuari | canal] {lmit | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	No estas autoritzat a canviar el teu lmit de memos.
MEMO_SET_LIMIT_FORBIDDEN
	El lmit de memos per a %s no pot ser canviat.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	No pots establir el teu lmit de memos a mes de %d.
MEMO_SET_LIMIT_TOO_HIGH
	No pots establir el lmite de memos per %s mes de %d.
MEMO_SET_LIMIT_OVERFLOW
	Lmit de memos molt alt; limitant-lo a %d.
MEMO_SET_YOUR_LIMIT
	El teu lmite de memos ha estat establert a %d.
MEMO_SET_YOUR_LIMIT_ZERO
	No et sera possible rebre ms memos.
MEMO_UNSET_YOUR_LIMIT
	El teu lmit de memos ha estat deshabilitat.
MEMO_SET_LIMIT
	Lmite de memos per a %s establert a %d.
MEMO_SET_LIMIT_ZERO
	Lmit de memos per a %s establert a 0.
MEMO_UNSET_LIMIT
	Lmit de memos per a %s deshabilitat.

# INFO responses
MEMO_INFO_SYNTAX
	INFO [canal]
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [nick | canal]
MEMO_INFO_NO_MEMOS
	No tens memos.
MEMO_INFO_MEMO
	Tens 1 memo.
MEMO_INFO_MEMO_UNREAD
	Tens 1 memo i encara no ha estat llegit.
MEMO_INFO_MEMOS
	Tens %d memos.
MEMO_INFO_MEMOS_ONE_UNREAD
	Tens %d memos, dels quals 1 encara no ha estat llegit.
MEMO_INFO_MEMOS_SOME_UNREAD
	Tens %d memos, dels quals %d encara no han estat llegits.
MEMO_INFO_MEMOS_ALL_UNREAD
	Tens %d memos, cap d'ells llegit.
MEMO_INFO_LIMIT
	El teu lmit de memos es %d.
MEMO_INFO_HARD_LIMIT
	El teu lmit de memos es %d i no pot ser canviat.
MEMO_INFO_LIMIT_ZERO
	El teu lmit de memos es 0; no rebrs nous memos.
MEMO_INFO_HARD_LIMIT_ZERO
	El teu lmit de memos es 0; no rebrs nous memos. No pots cambiar aquest lmit.
MEMO_INFO_NO_LIMIT
	No tens lmit en el numero de memos que pots mantenir.
MEMO_INFO_NOTIFY_OFF
	No sers notificat per memos nous.
MEMO_INFO_NOTIFY_ON
	Sers notificat per nous memos quant et conectis i quant se t'enviin.
MEMO_INFO_NOTIFY_RECEIVE
	Sers notificat quan els memos nous se t'enviin.
MEMO_INFO_NOTIFY_SIGNON
	Sers notificat per memos nous quant et conectis.
MEMO_INFO_X_NO_MEMOS
	%s no te memos.
MEMO_INFO_X_MEMO
	%s te 1 memo.
MEMO_INFO_X_MEMO_UNREAD
	%s actualment te 1 memo i encara no ha estat llegit.
MEMO_INFO_X_MEMOS
	%s actualment te %d memos.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s actualment te %d memos, dels quals 1 encara no ha estat llegit.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s actualment te %d memos, dels quals %d encara no han estat llegits.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s actualment te %d memos, dels quals cap ha estat llegit.
MEMO_INFO_X_LIMIT
	El lmit de memos per a %s es %d.
MEMO_INFO_X_HARD_LIMIT
	El lmit de memos per a %s es %d, i no pot ser canviat.
MEMO_INFO_X_NO_LIMIT
	%s no te lmit per a memos.
MEMO_INFO_X_NOTIFY_OFF
	%s no es notificat per memos nous.
MEMO_INFO_X_NOTIFY_ON
	%s es notificat per memos nous quant es connecta i quant li sn enviats.
MEMO_INFO_X_NOTIFY_RECEIVE
	%s es notificat quant nous memos li sn enviats.
MEMO_INFO_X_NOTIFY_SIGNON
	%s es notificat de nous memos quant es connecta.
	
###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
BOT_DOES_NOT_EXIST
	El bot %s no existeix.
BOT_NOT_ASSIGNED
	Has d'assignar un bot al canal abans de poder utilitzar aquesta comanda.
	Escriu /msg %S HELP ASSIGN per a ms informaci.
BOT_NOT_ON_CHANNEL
	El bot no esta al canal %s.
	
# Kick reasons (must be a single line)
BOT_REASON_BADWORD
	No utilitzis la paraula %s en aquest canal!
BOT_REASON_BADWORD_GENTLE
	Cuida el teu llenguatge!
BOT_REASON_BOLD
	No utilitzis negreta en aquest canal!
BOT_REASON_CAPS
	Desactiva les majuscules!
BOT_REASON_COLOR
	No utilitzis colors en aquest canal!
BOT_REASON_FLOOD
	Para de floodejar!
BOT_REASON_REPEAT
	No repeteixis com l'allioli!
BOT_REASON_REVERSE
	No utilitzis reversos en aquest canal!
BOT_REASON_UNDERLINE
	No utilitzis subratllats en aquest canal!
	
# !seen replies
BOT_SEEN_BOT
	M'has trobat %s!
BOT_SEEN_YOU
	Cercant-te a tu mateix, eh %s?
BOT_SEEN_ON_CHANNEL
	%s esta en el canal en aquests instants!
BOT_SEEN_ON_CHANNEL_AS
	%s esta en el canal en aquests instantes (com %s) ! 
BOT_SEEN_ON
	%s va ser vist aqui fa %s.
BOT_SEEN_NEVER
	Mai he vist a %s en aquest canal.
BOT_SEEN_UNKNOWN
	Mai he visto a %s.
	
# BOT responses
BOT_BOT_SYNTAX
	BOT ADD nick usuari host nom-real
	BOT CHANGE nick-antic nick-nou [usuari [host [nom-real]]]
	BOT DEL nick
	BOT LIST
BOT_BOT_ALREADY_EXISTS
	El bot %s ja existeix.
BOT_BOT_CREATION_FAILED
	Ho sento, la creaci de bot ha fallat
BOT_BOT_READONLY
	Ho sento, la modificaci de bots esta temporalment inabilitada.
BOT_BOT_ADDED
	%s!%s@%s (%s) afegit a la llista de bots.
BOT_BOT_ANY_CHANGES
	La informaci antiga es igual a la nova.
BOT_BOT_CHANGED
	El bot %s ha estat canviat a %s!%s@%s (%s)
BOT_BOT_DELETED
	El bot %s ha estat esborrat.
	
# BOTLIST responses
BOT_BOTLIST_HEADER
	Llista de bots:
BOT_BOTLIST_PRIVATE_HEADER
	Bots reservats a operadors de IRC:
BOT_BOTLIST_FOOTER
	%d bots disponibles.
BOT_BOTLIST_EMPTY
	No hi ha bots disponibles en aquest moment.
	Demana-li a un administrador de serveis que en fagi un!
	
# ASSIGN responses
BOT_ASSIGN_SYNTAX
	ASSIGN canal nick
BOT_ASSIGN_READONLY
	Ho sento, el assignament de bots esta temporalment inhabilitat.
BOT_ASSIGN_ALREADY
	Bot %s is already assigned to channel %s.
BOT_ASSIGN_ASSIGNED
	El bot %s ha estat assignat al canal %s.
	
# UNASSIGN responses
BOT_UNASSIGN_SYNTAX
	UNASSIGN canal
BOT_UNASSIGN_UNASSIGNED
	Ja no hi ha un bot assignat a %s.
	
# INFO responses
BOT_INFO_SYNTAX
	INFO {canal | nick}
BOT_INFO_NOT_FOUND
	%s no s un bot valid o un canal registrat.
BOT_INFO_BOT_HEADER
	Informaci pel bot %s:
BOT_INFO_BOT_MASK
	       Mascara : %s@%s
BOT_INFO_BOT_REALNAME
	  Nom real : %s
BOT_INFO_BOT_CREATED
	    Creat : %s
BOT_INFO_BOT_USAGE
	    Utilitzat a : %d canal(s)
BOT_INFO_BOT_OPTIONS
	    Opcions : %s
BOT_INFO_OPT_PRIVATE
	Privat
BOT_INFO_CHAN_HEADER
	Informaci pel canal %s:
BOT_INFO_CHAN_BOT
	           Nick del bot : %s
BOT_INFO_CHAN_BOT_NONE
	           Nick del bot : Encara no assignat.
BOT_INFO_CHAN_KICK_BADWORDS
	   Kicker per paraules malsonants : %s
BOT_INFO_CHAN_KICK_BADWORDS_BAN
	   Kicker per paraules malsonants : %s (%d kick(s) per a ban)
BOT_INFO_CHAN_KICK_BOLDS
	    Kicker per negretes : %s
BOT_INFO_CHAN_KICK_BOLDS_BAN
	    Kicker per negretes : %s (%d kick(s) per a ban)
BOT_INFO_CHAN_KICK_CAPS_ON
	            Caps kicker : %s (mnim %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_BAN
	  Kicker per majuscules : %s (%d kick(s) per a ban; mnim %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_OFF
	  Kicker per majuscules : %s
BOT_INFO_CHAN_KICK_COLORS
	     Kicker per colors : %s
BOT_INFO_CHAN_KICK_COLORS_BAN
	     Kicker per colors : %s (%d kick(s) per a ban)
BOT_INFO_CHAN_KICK_FLOOD_ON
	       Kicker per flood : %s (%d linees en %ds)
BOT_INFO_CHAN_KICK_FLOOD_BAN
	       Kicker per flood : %s (%d kick(s) per a ban; %d linees en %ds)
BOT_INFO_CHAN_KICK_FLOOD_OFF
	       Kicker per flood : %s
BOT_INFO_CHAN_KICK_REPEAT_ON
	  Kicker per repetici : %s (%d vegades)
BOT_INFO_CHAN_KICK_REPEAT_BAN
	  Kicker per repetici : %s (%d kick(s) per a ban; %d vegades)
BOT_INFO_CHAN_KICK_REPEAT_OFF
	  Kicker per repetici : %s
BOT_INFO_CHAN_KICK_REVERSES
	    Kicker per inversos : %s
BOT_INFO_CHAN_KICK_REVERSES_BAN
	    Kicker per inversos : %s (%d kick(s) per a ban)
BOT_INFO_CHAN_KICK_UNDERLINES
	  Kicker per subrallats : %s
BOT_INFO_CHAN_KICK_UNDERLINES_BAN
	  Kicker per subratllats : %s (%d kick(s) per a ban)
BOT_INFO_ACTIVE
	Activada
BOT_INFO_INACTIVE
	Desactivada
BOT_INFO_CHAN_OPTIONS
	               Opcions : %s
BOT_INFO_OPT_DONTKICKOPS
	Protecci de Ops
BOT_INFO_OPT_DONTKICKVOICES
	Protecci de Voices
BOT_INFO_OPT_FANTASY
	Fantasia
BOT_INFO_OPT_GREET
	Salutaci
BOT_INFO_OPT_NOBOT
	Sense bot
BOT_INFO_OPT_SYMBIOSIS
	Simbiosis
BOT_INFO_OPT_NONE
	Cap
	
# SET responses
BOT_SET_SYNTAX
	SET canal Opci establiments
BOT_SET_DISABLED
	Ho sento, l'establiment d'opcions per a bot esta temporalment inhabilitat
BOT_SET_UNKNOWN
	Opci %s desconeguda.
	Escriu /msg %S HELP SET per a ms informaci.
	
# SET DONTKICKOPS messages
BOT_SET_DONTKICKOPS_SYNTAX
	SET canal DONTKICKOPS {ON|OFF}
BOT_SET_DONTKICKOPS_ON
	Bot no kickejara ops en el canal %s.
BOT_SET_DONTKICKOPS_OFF
	Bot kickejara ops en el canal %s.
	
# SET DONTKICKVOICES messages
BOT_SET_DONTKICKVOICES_SYNTAX
	SET canal DONTKICKVOICES {ON|OFF}
BOT_SET_DONTKICKVOICES_ON
	Bot no kickejara voices en el canal %s.
BOT_SET_DONTKICKVOICES_OFF
	Bot kickejara voices en el canal %s.

# SET FANTASY messages
BOT_SET_FANTASY_SYNTAX
	SET canal FANTASY {ON|OFF}
BOT_SET_FANTASY_ON
	Mode fantasia ara activada en el canal %s.
BOT_SET_FANTASY_OFF
	Mode fantasia ara desactivat en el canal %s.
	
# SET GREET messages
BOT_SET_GREET_SYNTAX
	SET canal GREET {ON|OFF}
BOT_SET_GREET_ON
	Mode salutaci ara activat en el canal %s.
BOT_SET_GREET_OFF
	Mode salutaci ara desactivat en el canal %s.
	
# SET NOBOT
BOT_SET_NOBOT_SYNTAX
	SET canal NOBOT {ON|OFF}
BOT_SET_NOBOT_ON
	Mode no bot ara activat en el canal %s.
BOT_SET_NOBOT_OFF
	Mode no bot ara desactivat en el canal %s.

# SET PRIVATE
BOT_SET_PRIVATE_SYNTAX
	SET canal PRIVATE {ON|OFF}
BOT_SET_PRIVATE_ON
	Mode privado del bot %s esta ara activat.
BOT_SET_PRIVATE_OFF
	Mode privado del bot %s esta ara desactivat.

# SET SYMBIOSIS
BOT_SET_SYMBIOSIS_SYNTAX
	SET canal SYMBIOSIS {ON|OFF}
BOT_SET_SYMBIOSIS_ON
	Mode Simbiosis ara activat en el canal %s.
BOT_SET_SYMBIOSIS_OFF
	Mode Simbiosis ara desactivat en el canal %s.
	
# KICK responses
BOT_KICK_SYNTAX
	KICK canal opci {ON|OFF} [establiments]
BOT_KICK_DISABLED
	Ho sento, la configuraci de kicker esta temporalment inabilitada.
BOT_KICK_UNKNOWN
	Opci %s desconeguda.
	Escriu /msg %S HELP KICK per a ms informaci
BOT_KICK_BAD_TTB
	%s no pot ser pres com vegades a banegar

BOT_KICK_BADWORDS_ON
	El bot ara kickejara paraules malsonants. Utilitza la comanda BADWORDS
	per a afegir o treure paraules.
BOT_KICK_BADWORDS_ON_BAN
	El bot ara kickejara paraules malsonants, i banejara desprs de
	%d kicks al mateix usuari. Utilitza la comanda BADWORDS
	per a afegir o treure paraules.
BOT_KICK_BADWORDS_OFF
	El bot ja no kickejara paraules malsonants. 
BOT_KICK_BOLDS_ON
	El bot ara kickjeara negretes.
BOT_KICK_BOLDS_ON_BAN
	El bot ara kickjeara negretes, i banejara desprs de 
	%d kicks al mateix usuari.
BOT_KICK_BOLDS_OFF
	El bot ja no kickejara negretes.
BOT_KICK_CAPS_ON
	El bot ara kickejara majuscules (han de ser al menys
	%d carcters i %d%% del missatge senser).
BOT_KICK_CAPS_ON_BAN
	El bot ara kickejara majusculas (han de ser al menys
	%d carcters i %d%% del missatge senser), i banegara
	desprs de %d kicks al mateix usuari.
BOT_KICK_CAPS_OFF
	El bot ja no kickejara majuscules.
BOT_KICK_COLORS_ON
	El bot ara kickejara colors.
BOT_KICK_COLORS_ON_BAN
	El bot ara kickejara colors, i banejara desprs de %d 
	kicks al mateix usuari.
BOT_KICK_COLORS_OFF
	El bot ja no kickejara colors.
BOT_KICK_FLOOD_ON
	El bot ara kickejara flood (%d linees en %d segons).
BOT_KICK_FLOOD_ON_BAN
	El bot ara kickejara flood (%d linees in %d segons), i 
	banejara desprs de %d kicks al mateix usuari.
BOT_KICK_FLOOD_OFF
	El bot ja no kickejara flood.
BOT_KICK_REPEAT_ON
	El bot ara kickejara repeticions (usuaris que repeteixin %d vegades
	el mateix).
BOT_KICK_REPEAT_ON_BAN
	El bot ara kickejara repeticions (usuaris que repeteixin %d vegades
	el mateix), i banejara desprs de %d 
	kicks al mateix usuari.
BOT_KICK_REPEAT_OFF
	El bot ja no kickejara repeticions.
BOT_KICK_REVERSES_ON
	El bot ara kickejara reversos.
BOT_KICK_REVERSES_ON_BAN
	El bot ara kickejara reversos, i banejara desprs de %d 
	kicks al mateix usuari.
BOT_KICK_REVERSES_OFF
	El bot ja no kickejara reversos.
BOT_KICK_UNDERLINES_ON
	El bot ara kickejara subratllats.
BOT_KICK_UNDERLINES_ON_BAN
	El bot ara kickejara subratllats, i banejara desprs de %d 
	kicks al mateix usuari.
BOT_KICK_UNDERLINES_OFF
	El bot ja no kickejara subratllats.
	
# BADWORDS messages
BOT_BADWORDS_SYNTAX
	BADWORDS canal {ADD|DEL|LIST|CLEAR} [paraula | llista] [SINGLE|START|END]
BOT_BADWORDS_DISABLED
	Ho sento, la llista de  paraules malsonants per a canals esta temporalment inabilitada.
BOT_BADWORDS_REACHED_LIMIT
	Ho sento, sols pots tenir %d paraules malsonants en un canal.
BOT_BADWORDS_ALREADY_EXISTS
	%s ja existeix a la llista de paraules malsonants de %s.
BOT_BADWORDS_ADDED
	%s afegida a  la llista de paraules malsonants de  %s.
BOT_BADWORDS_NO_SUCH_ENTRY
	No existeix la instncia (#%d) a la llista de paraules malsonants de %s.
BOT_BADWORDS_NOT_FOUND
	%s no trobada a la llista de paraules malsonants de %s.
BOT_BADWORDS_NO_MATCH
	No existeixen paraules que concordin a la llista de paraules malsonants de %s.
BOT_BADWORDS_DELETED
	%s esborrada de la llista de paraules malsonants de %s.
BOT_BADWORDS_DELETED_ONE
	1 paraula esborrada de la llista de paraules malsonants de %s.
BOT_BADWORDS_DELETED_SEVERAL
	%d paraules esborrades de la llista de paraules malsonants de %s.
BOT_BADWORDS_LIST_EMPTY
	La llista de paraules malsonants de %s esta buida.
BOT_BADWORDS_LIST_HEADER
	llista de paraules malsonants per a %s:
	  Num   Paraula                        Tipo
BOT_BADWORDS_LIST_FORMAT
	  %3d   %-30s %s
BOT_BADWORDS_CLEAR
	La llista de paraules malsonants esta ara buida.

# SAY responses
BOT_SAY_SYNTAX
	SAY canal text

# ACT responses
BOT_ACT_SYNTAX
	ACT canal text

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
BOT_EXCEPT
	User matches channel except.

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
BOT_BAD_NICK
	Bot Nicks may only contain valid nick characters.
BOT_BAD_HOST
	Bot Hosts may only contain valid host characters.
BOT_BAD_IDENT
	Bot Idents may only contain valid characters.
###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	Els serveis no han pogut canviar Modes. Estan ben configurats els teus servidors?
OPER_BOUNCY_MODES_U_LINE
	Els serveis no han pogut canviar Modes. Estan les linees U: dels teus servidors configurades correctament?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL missatge

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Opci STATS %s desconeguda.
OPER_STATS_CURRENT_USERS
	Actuals usuaris: %d (%d ops)
OPER_STATS_MAX_USERS
	Mxim  numero d'usuaris: %d (%s)
# This is ugly, but at least it's language-portable...
# Note that you can include seconds in any of these--my personal preference
# is to only give resolution to the nearest minute when uptime is one hour
# or more, but just add a %d to get seconds as well.
OPER_STATS_UPTIME_DHMS
	Serveis amunt %d dies, %02d:%02d
OPER_STATS_UPTIME_1DHMS
	Serveis amunt %d dies, %02d:%02d
OPER_STATS_UPTIME_HMS
	Serveis amunt %d hores, %d minuts
OPER_STATS_UPTIME_HM1S
	Serveis amunt %d hores, %d minuts
OPER_STATS_UPTIME_H1MS
	Serveis amunt %d hores, %d minut
OPER_STATS_UPTIME_H1M1S
	Serveis amunt %d hores, %d minut
OPER_STATS_UPTIME_1HMS
	Serveis amunt %d hora, %d minuts
OPER_STATS_UPTIME_1HM1S
	Serveis amunt %d hora, %d minuts
OPER_STATS_UPTIME_1H1MS
	Serveis amunt %d hora, %d minut
OPER_STATS_UPTIME_1H1M1S
	Serveis amunt %d hora, %d minut
OPER_STATS_UPTIME_MS
	Serveis amunt %d minuts, %d segons
OPER_STATS_UPTIME_M1S
	Serveis amunt %d minuts, %d segon
OPER_STATS_UPTIME_1MS
	Serveis amunt %d minut, %d segons
OPER_STATS_UPTIME_1M1S
	Serveis amunt %d minut, %d segon
OPER_STATS_BYTES_READ
	Bytes llegits   : %5d kB
OPER_STATS_BYTES_WRITTEN
	Bytes escrits : %5d kB
OPER_STATS_USER_MEM
	Usuari      : %6d registres, %5d kB
OPER_STATS_CHANNEL_MEM
	Canal        : %6d registres, %5d kB
OPER_STATS_GROUPS_MEM
	Grups NS    : %6d registres, %5d kB
OPER_STATS_ALIASES_MEM
	Aliases NS   : %6d registres, %5d kB
OPER_STATS_CHANSERV_MEM
	ChanServ     : %6d registres, %5d kB
OPER_STATS_BOTSERV_MEM
	BotServ      : %6d registres, %5d kB
OPER_STATS_OPERSERV_MEM
	OperServ     : %6d registres, %5d kB
OPER_STATS_SESSIONS_MEM
	Sessions     : %6d registres, %5d kB
OPER_STATS_PROXY_MEM
	Proxies      : ^B%6d^B registres, ^B%5d^B kB
OPER_STATS_AKILL_COUNT
	Numero actual de AKILLs: %d
OPER_STATS_AKILL_EXPIRE_DAYS
	Temps d'expiraci per defecte de AKILL: %d dies
OPER_STATS_AKILL_EXPIRE_DAY
	Temps d'expiraci per defecte de AKILL: 1 dia
OPER_STATS_AKILL_EXPIRE_HOURS
	Temps d'expiraci per defecte de AKILL: %d hores
OPER_STATS_AKILL_EXPIRE_HOUR
	Temps d'expiraci per defecte de AKILL: 1 hora
OPER_STATS_AKILL_EXPIRE_MINS
	Temps d'expiraci per defecte de AKILL: %d minuts
OPER_STATS_AKILL_EXPIRE_MIN
	Temps d'expiraci per defecte de AKILL: 1 minut
OPER_STATS_AKILL_EXPIRE_NONE
	Temps d'expiraci per defecte de AKILL: Sense expiraci
OPER_STATS_SGLINE_COUNT
	Numero actual de SGLINEs: %d
OPER_STATS_SGLINE_EXPIRE_DAYS
	Temps d'expiraci per defecte de SGLINE: %d dies
OPER_STATS_SGLINE_EXPIRE_DAY
	Temps d'expiraci per defecte de SGLINE: 1 dia
OPER_STATS_SGLINE_EXPIRE_HOURS
	Temps d'expiraci per defecte de SGLINE: %d hores
OPER_STATS_SGLINE_EXPIRE_HOUR
	Temps d'expiraci per defecte de SGLINE: 1 hora
OPER_STATS_SGLINE_EXPIRE_MINS
	Temps d'expiraci per defecte de SGLINE: %d minuts
OPER_STATS_SGLINE_EXPIRE_MIN
	Temps d'expiraci per defecte de SGLINE: 1 minut
OPER_STATS_SGLINE_EXPIRE_NONE
	Temps d'expiraci per defecte de SGLINE: Sense expiraci
OPER_STATS_SQLINE_COUNT
	Numero actual de SQLINEs: %d
OPER_STATS_SQLINE_EXPIRE_DAYS
	Temps d'expiraci per defecte de SQLINE: %d dies
OPER_STATS_SQLINE_EXPIRE_DAY
	Temps d'expiraci per defecte de SQLINE: 1 dia
OPER_STATS_SQLINE_EXPIRE_HOURS
	Temps d'expiraci per defecte de SQLINE: %d hores
OPER_STATS_SQLINE_EXPIRE_HOUR
	Temps d'expiraci per defecte de SQLINE: 1 hora
OPER_STATS_SQLINE_EXPIRE_MINS
	Temps d'expiraci per defecte de SQLINE: %d minuts
OPER_STATS_SQLINE_EXPIRE_MIN
	Temps d'expiraci per defecte de SQLINE: 1 minut
OPER_STATS_SQLINE_EXPIRE_NONE
	Temps d'expiraci per defecte de SQLINE: Sense expiraci
OPER_STATS_SZLINE_COUNT
	Numero actual de SZLINEs: %d
OPER_STATS_SZLINE_EXPIRE_DAYS
	Temps d'expiraci per defecte de SZLINE: %d dies
OPER_STATS_SZLINE_EXPIRE_DAY
	Temps d'expiraci per defecte de SZLINE: 1 dia
OPER_STATS_SZLINE_EXPIRE_HOURS
	Temps d'expiraci per defecte de SZLINE: %d hores
OPER_STATS_SZLINE_EXPIRE_HOUR
	Temps d'expiraci per defecte de SZLINE: 1 hora
OPER_STATS_SZLINE_EXPIRE_MINS
	Temps d'expiraci per defecte de SZLINE: %d minuts
OPER_STATS_SZLINE_EXPIRE_MIN
	Temps d'expiraci per defecte de SZLINE: 1 minut
OPER_STATS_SZLINE_EXPIRE_NONE
	Temps d'expiraci per defecte de SZLINE: Sense expiraci
OPER_STATS_RESET
	Estadistiques restablertes.

# MODE responses
OPER_MODE_SYNTAX
	MODE canal Modes

# CLEARMODES responses
OPER_UMODE_SYNTAX
	UMODE nick modes

# OLINE responses
OPER_UMODE_SUCCESS
	Changed usermodes of %s.
OPER_UMODE_CHANGED
	%s changed your usermodes.

# OLINE responses
OPER_OLINE_SYNTAX
	OLINE nick flags
OPER_OLINE_SUCCESS
	An O:Line with the flags %s has been added for %s.

# CLEARMODES responses
OPER_OLINE_IRCOP
	You are now an IRC Operator.

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES canal [ALL]
OPER_CLEARMODES_DONE
	Modes binaris i bans netegats del canal %s.
OPER_CLEARMODES_ALL_DONE
	Tots els Modes netegats del canal %s.


# KICK responses
OPER_KICK_SYNTAX
	KICK canal usuari ra
	
# ADMIN responses
OPER_SVSNICK_SYNTAX
	SVSNICK nick newnick 
OPER_SVSNICK_NEWNICK
	The nick %s is now being changed to %s.
	
# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD|DEL|LIST|CLEAR} [nick | llista]
OPER_ADMIN_SKELETON
	Els serveis estan en Mode skeleton; la comanda ADMIN no esta disponible.
OPER_ADMIN_EXISTS
	%s ja esta present a la llista d'administradors de serveis.
OPER_ADMIN_REACHED_LIMIT
	Ho sento, sols pots tenir %d administradors de serveis.
OPER_ADMIN_ADDED
	%s afegit a la llista d'administradors de serveis.
OPER_ADMIN_NOT_FOUND
	%s no trobat a la llista d'administradors de serveis.
OPER_ADMIN_NO_MATCH
	No existeixen instncies similars a la llista d'administradors de serveis.
OPER_ADMIN_DELETED
	%s esborrat de la llista d'administradors de serveis.
OPER_ADMIN_DELETED_ONE
	1 instncia esborrada de la llista d'administradors de serveis.
OPER_ADMIN_DELETED_SEVERAL
	%d instncies esborrades de la llista d'administradors de serveis.
OPER_ADMIN_LIST_EMPTY
	La llista d'administradors de serveis esta buida.
OPER_ADMIN_LIST_HEADER
	Llista d'administradors de serveis:
	  Num   Nick
OPER_ADMIN_LIST_FORMAT
	  %3d   %s
OPER_ADMIN_CLEAR
	La llista d'administradors de serveis ha estat netegada.

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD|DEL|LIST|CLEAR} [nick | llista]
OPER_OPER_SKELETON
	Els serveis estan en Mode skeleton; la comanda OPER no esta disponible.
OPER_OPER_EXISTS
	%s ja existeix a la llista d'operadors de serveis.
OPER_OPER_REACHED_LIMIT
	Ho sento, sols pots tenir %d operadors de serveis.
OPER_OPER_ADDED
	%s afegit a la llista d'operadors de serveis.
OPER_OPER_NOT_FOUND
	%s no trobat a la llista d'operadors de serveis.
OPER_OPER_NO_MATCH
	No existeixen instncies similars a la llista d'operadors de serveis.
OPER_OPER_DELETED
	%s esborrat de la llista d'operadors de serveis.
OPER_OPER_DELETED_ONE
	1 instncia esborrada de la llista d'operadors de serveis.
OPER_OPER_DELETED_SEVERAL
	%d instncies esborrades de la llista d'operadors de serveis.
OPER_OPER_LIST_EMPTY
	La llista d'administradors de serveis esta buida.
OPER_OPER_LIST_HEADER
	Llista d'operadors de serveis:
	  Num   Nick
OPER_OPER_LIST_FORMAT
	  %3d   %s
OPER_OPER_CLEAR
	La llista d'operadors de serveis ha estat netegada.

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | CLEAR} [[+expiraci] {mascara | llista} [ra]]
OPER_AKILL_EXISTS
	%s ja esta present a la llista de AKILLs.
OPER_AKILL_ALREADY_COVERED
	%s ja esta cobert per %s.
OPER_AKILL_REACHED_LIMIT
	Ho sento, sols pots tenir %d AKILLs.
OPER_AKILL_NO_NICK
	Recordatori: Les mascares AKILL no poden contenir nicks; asegura't de no incloure el nick en la teva mascara.
OPER_AKILL_ADDED
	%s afegit a la llista de AKILLs.
OPER_AKILL_CHANGED
	Temps d'expiraci per a %s canviat.
OPER_AKILL_NOT_FOUND
	%s no trobat a la llista de AKILLs.
OPER_AKILL_NO_MATCH
	No existeixen instncies similars a la llista de AKILLs.
OPER_AKILL_DELETED
	%s esborrat de la llista de AKILLs.
OPER_AKILL_DELETED_ONE
	1 instncia esborrada de la llista de AKILLs.
OPER_AKILL_DELETED_SEVERAL
	%d instncies esborrades de la llista de AKILLs.
OPER_AKILL_LIST_EMPTY
	La llista de AKILLS esta buida.
OPER_AKILL_LIST_HEADER
	Llista actual de AKILLs:
	  Num   Mascara                           Ra
OPER_AKILL_LIST_FORMAT
	  %3d   %-32s  %s
OPER_AKILL_VIEW_HEADER
	Llista actual de AKILLs:
# number, mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_FORMAT
	%3d  %s (per %s en %s; %s)
	      %s
OPER_AKILL_CLEAR
	La llista de AKILLs ha estat netegada.
	
# SGLINE responses
OPER_CHANKILL_SYNTAX
	CHANAKILL [+expiry] {#channel} [reason]
# SGLINE responses
OPER_SGLINE_SYNTAX
	SGLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+expiraci] {mascara | llista}[:ra]]
OPER_SGLINE_UNSUPPORTED
	Ho sento, SGLINE no esta disponible en aquesta xarxa.
OPER_SGLINE_EXISTS
	%s ja existeix a la llista de SGLINEs.
OPER_SGLINE_ALREADY_COVERED
	%s ja esta cobert per %s.
OPER_SGLINE_REACHED_LIMIT
	Ho sento, sols pots tenir %d SGLINEs.
OPER_SGLINE_ADDED
	%s afegit a la llista de SGLINEs.
OPER_SGLINE_CHANGED
	Temps d'expiraci per a %s canviat.
OPER_SGLINE_NOT_FOUND
	%s no trobat a a la llista de SGLINEs.
OPER_SGLINE_NO_MATCH
	No existeixen instncies similars a la llista de SGLINEs.
OPER_SGLINE_DELETED
	%s esborrat de la llista de SGLINEs.
OPER_SGLINE_DELETED_ONE
	1 instncia esborrada de la llista de SGLINEs.
OPER_SGLINE_DELETED_SEVERAL
	%d instncies esborrades de la llista de SGLINEs.
OPER_SGLINE_LIST_EMPTY
	La llista de SGLINEs esta buida.
OPER_SGLINE_LIST_HEADER
	Llista actual de SGLINEs:
	  Num   Mascara                           Ra
OPER_SGLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SGLINE_VIEW_HEADER
	Llista actual de SGLINEs:
# number, mask, set-by, set-time, expires, reason
OPER_SGLINE_VIEW_FORMAT
	%3d  %s (per %s en %s; %s)
	      %s
OPER_SGLINE_CLEAR
	La llista de SGLINEs ha estat netegada.

# SQLINE responses
OPER_SQLINE_SYNTAX
	SQLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+expiraci] {mascara | llista} [ra]]
OPER_SQLINE_CHANNELS_UNSUPPORTED
	SQLINEs de canal no estan soportades pel teu IRCd, aix que no les pots utilitzar.
OPER_SQLINE_EXISTS
	%s ja existeix a la llista de SQLINEs.
OPER_SQLINE_ALREADY_COVERED
	%s ja esta cobert per %s.
OPER_SQLINE_REACHED_LIMIT
	Ho sento, sols pots tenir %d SQLINEs.
OPER_SQLINE_ADDED
	%s afegit a la llista de SQLINEs.
OPER_SQLINE_CHANGED
	Temps d'expiraci per a %s canviat.
OPER_SQLINE_NOT_FOUND
	%s no trobat a la llista de SQLINEs
OPER_SQLINE_NO_MATCH
	No existeixen instncies similars a la llista de SQLINEs.
OPER_SQLINE_DELETED
	%s esborrat de la llista de SQLINEs.
OPER_SQLINE_DELETED_ONE
	1 instncia esborrada de la llista de SQLINEs.
OPER_SQLINE_DELETED_SEVERAL
	%d instncies esborrades de la llista de SQLINEs.
OPER_SQLINE_LIST_EMPTY
	La llista de SQLINEs esta buida.
OPER_SQLINE_LIST_HEADER
	Llista actual de SQLINEs:
	  Num   Mascara                           Ra
OPER_SQLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SQLINE_VIEW_HEADER
	Llista actual de SQLINEs:
# number, mask, set-by, set-time, expires, reason
OPER_SQLINE_VIEW_FORMAT
	%3d  %s (per %s en %s; %s)
	      %s
OPER_SQLINE_CLEAR
	La llista de SQLINEs ha estat netegada.

# SZLINE responses
OPER_SZLINE_SYNTAX
	SZLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+expiraci] {mascara | llista} [ra]]
OPER_SZLINE_UNSUPPORTED
	Ho sento, la comanda SZLINE no esta disponible en aquesta xarxa.
OPER_SZLINE_EXISTS
	%s ja existeix a la llista de SZLINEs.
OPER_SZLINE_ALREADY_COVERED
	%s ja esta cobert per %s.
OPER_SZLINE_REACHED_LIMIT
	Ho sento, sols pots tenir %d SZLINEs.
OPER_SZLINE_ONLY_IPS
	Recordatori: Sols pots afegir mascares IP a la llista de SZLINEs.
OPER_SZLINE_ADDED
	%s afegit a la llista de SZLINEs.
OPER_SZLINE_CHANGED
	Temps d'expiraci de %s canviat.
OPER_SZLINE_NOT_FOUND
	%s no trobat a la llista de SZLINEs.
OPER_SZLINE_NO_MATCH
	No existeixen instncies similars a la llista de SZLINEs.
OPER_SZLINE_DELETED
	%s esborrat de la llista de SZLINEs.
OPER_SZLINE_DELETED_ONE
	1 instncia esborrada de la llista de SZLINEs.
OPER_SZLINE_DELETED_SEVERAL
	%d instncies esborrades de la llista de SZLINEs.
OPER_SZLINE_LIST_EMPTY
	La llista de SZLINEs esta buida.
OPER_SZLINE_LIST_HEADER
	Llista actual de SZLINEs:
	  Num   Mascara                           Ra
OPER_SZLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SZLINE_VIEW_HEADER
	Llista actual de SZLINEs:
# number, mask, set-by, set-time, expires, reason
OPER_SZLINE_VIEW_FORMAT
	%3d  %s (per %s a %s; %s)
	      %s
OPER_SZLINE_CLEAR
	La llista de SZLINEs ha estat netegada.

# SET responses
OPER_SET_SYNTAX
	SET Opci estabilment
OPER_SET_IGNORE_ON
	Codi ignore sera utilitzat.
OPER_SET_IGNORE_OFF
	Codi ignore no sera utilitzat.
OPER_SET_IGNORE_ERROR
	L'establiment per a IGNORE ha de ser ON o OFF.
OPER_SET_READONLY_ON
	Serveis ara en Mode noms lectura.
OPER_SET_READONLY_OFF
	Serveis ara en Mode de lectura-escriptura.
OPER_SET_READONLY_ERROR
	L'establiment per a READONLY ha de ser ON o OFF.
OPER_SET_LOGCHAN_ON
	Services is now reporting log messages to %s.
OPER_SET_LOGCHAN_OFF
	Services is no longer reporting log messages to a channel.
OPER_SET_LOGCHAN_ERROR
	Setting for LOGCHAN must be ON or OFF and LogChannel must be defined.
OPER_SET_DEBUG_ON
	Serveis ara en Mode debug.
OPER_SET_DEBUG_OFF
	Serveis ara en Mode no-debug.
OPER_SET_DEBUG_LEVEL
	Serveis ara en Mode debug (nivell %d).
OPER_SET_DEBUG_ERROR
	L'establiment per a DEBUG ha de ser ON, OFF, o un numero positiu.
OPER_SET_NOEXPIRE_ON
	Serveis ara en Mode no expire.
OPER_SET_NOEXPIRE_OFF
	Serveis ara en Mode expire.
OPER_SET_NOEXPIRE_ERROR
	Establiment per a NOEXPIRE ha de ser ON o OFF.
OPER_SET_UNKNOWN_OPTION
	Opci %s desconeguda.

# NOOP responses
OPER_NOOP_SYNTAX
	NOOP {SET|REVOKE} servidor
OPER_NOOP_SET
	Totes les linees O de %s han estat esborrades.
OPER_NOOP_REVOKE
	Totes les linees O de %s han estat esborrades.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE nom-del-servidor [ra]

# RAW responses
OPER_JUPE_HOST_ERROR
	Please use a valid server name when juping
	
# RAW responses
OPER_RAW_SYNTAX
	RAW text

# UPDATE responses
OPER_UPDATING
	Actualitzant les bases de dades.
	
# RELOAD responses
OPER_RELOAD
	L'arxiu de configuraci de serveis ha estat carregat novament.

# RESTART responses
OPER_CANNOT_RESTART
	SERVICES_BIN no definit; impossible arrencar un altre cop. Arranca un altre cop el script \2configure\2  i recompila Services per a incloure la comanda RESTART.

# LISTIGNORE responses
OPER_IGNORE_SYNTAX
	Syntax: IGNORE {ADD|DEL|LIST|CLEAR} [time] [nick]
OPER_IGNORE_VALID_TIME
	You have to enter a valid number as time.
OPER_IGNORE_TIME_DONE
	%s will now be ignored for %s.
OPER_IGNORE_PERM_DONE
	%s will now permanently be ignored.
OPER_IGNORE_DEL_DONE
	%s will no longer be ignored.
OPER_IGNORE_LIST
	Llista ignore de serveis:
OPER_IGNORE_LIST_NOMATCH
	%s not found on ignore list.
OPER_IGNORE_LIST_EMPTY
	La llista ignore esta buida.

# KILLCLONES responses
OPER_IGNORE_LIST_CLEARED
	Ignore list has been cleared.

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES nick
OPER_KILLCLONES_UNKNOWN_NICK
	Impossible trobar a l'usuari %s.
	
# CHANLIST responses
OPER_CHANLIST_HEADER
	Llista de canal:
	Nom                 Modes de Usr. Tpic
OPER_CHANLIST_HEADER_USER
	Llista del canal %s:
	Nom                 Modes de Usr. Tpic
OPER_CHANLIST_RECORD
	%-20s  %4d +%-6s %s
OPER_CHANLIST_END
	Fi de la llista de canals.
	
# USERLIST responses
OPER_USERLIST_HEADER
	Llista d'usuaris:
	Nick                 Mascara
OPER_USERLIST_HEADER_CHAN
	llista d'usuaris de %s:
	Nick                 Mascara
OPER_USERLIST_RECORD
	%-20s %s@%s
OPER_USERLIST_END
	Fi de la llista d'usuaris.

# CACHE responses
OPER_CACHE_SYNTAX
	CACHE {DEL | LIST} {hostname | patr} [QUEUED | ALL]
OPER_CACHE_DISABLED
	Detecci de Proxy deshabilitada.
OPER_CACHE_NOT_FOUND
	%s no trobat al cau.
OPER_CACHE_REMOVED
	%s ha estat esborrat del cau.
OPER_CACHE_HEADER
	Hostname                                         Estatus
OPER_CACHE_LIST
	%-48s %s
OPER_CACHE_FOOTER
	Fi de la llista - %d/%d instncies mostrades.
OPER_CACHE_QUEUED
	Encuat
OPER_CACHE_PROGRESS
	En progrs
OPER_CACHE_NORMAL
	Normal
OPER_CACHE_WINGATE
	Wingate
OPER_CACHE_SOCKS4
	SOCKS 4
OPER_CACHE_SOCKS5
	SOCKS 5
OPER_CACHE_HTTP
	Proxy HTTP

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_SUPER_ADMIN_ON
	You are now a SuperAdmin
OPER_SUPER_ADMIN_OFF
	You are no longer a SuperAdmin
OPER_SUPER_ADMIN_SYNTAX
	Setting for SuperAdmin must be ON or OFF.
OPER_SUPER_ADMIN_WALL_ON
	%s is now a Super-Admin
OPER_SUPER_ADMIN_WALL_OFF
	%s is no longer a Super-Admin

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_SUPER_ADMIN_ONLY
	Only Super-Admins can use this command.

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_STAFF_LIST_HEADER
	On Level Nick

# DefCon Messages

OPER_STAFF_FORMAT
	 %c %s  %s
OPER_STAFF_AFORMAT
	 %c %s  %s [%s]

# DefCon Messages

OPER_DEFCON_SYNTAX
	Syntax: DEFCON [1|2|3|4|5]
OPER_DEFCON_DENIED
	This service is temporarly disabled, please try again later
OPER_DEFCON_NO_CONF
	The Defcon system must be enabled in the services.conf file
OPER_DEFCON_CHANGED
	Services are now at DEFCON %d
OPER_DEFCON_WALL
	%s Changed the DEFCON level to %d
DEFCON_GLOBAL
	The Defcon Level is now at Level: %d

# Module strings

OPER_MODULE_LOADED
	Module %s loaded
OPER_MODULE_UNLOADED
	Module %s unloaded
OPER_MODULE_LOAD_FAIL
	Unable to load module %s
OPER_MODULE_REMOVE_FAIL
	Unable to remove module %s
OPER_MODULE_LOAD_SYNTAX
	MODLOAD FileName
OPER_MODULE_UNLOAD_SYNTAX
	MODUNLOAD FileName
OPER_MODULE_LIST
	Module: %s
OPER_MODULE_INFO_LIST
	Module: %s Version: %s Author: %s loaded: %s
OPER_MODULE_CMD_LIST
	Providing command: /msg %s %s
OPER_MODULE_MSG_LIST
	Providing IRCD handler for: %s
OPER_MODULE_NO_LIST
	No modules currently loaded
OPER_MODULE_NO_INFO
	No information about module %s is available
OPER_MODULE_INFO_SYNTAX
	MODINFO FileName

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
MODULE_HELP_HEADER
	The following commands have been loaded by a module:

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [parametres]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+expiraci] mascara lmit ra
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {mascara | llista}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE numero posici
OPER_EXCEPTION_DISABLED
	Lmits de sessions no disponibles.
OPER_EXCEPTION_ALREADY_PRESENT
	La mascara %s ja esta present a la llista d'excepcions.
OPER_EXCEPTION_TOO_MANY
	La llista d'excepcions al lmit de sessiones esta plena!
OPER_EXCEPTION_ADDED
	Lmit de sessi per a %s establert a %d.
OPER_EXCEPTION_MOVED
	Excepci per a %s (#%d) moguda a la posici %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	La instncia no existeix (#%d)  a la llista d'excepcions al lmit de sessions.
OPER_EXCEPTION_NOT_FOUND
	%s no trobat a a la llista d'excepcions al lmit de sessions.
OPER_EXCEPTION_NO_MATCH
	No existeixen instncies similars a la llista d'excepcions al lmit de sessions.
OPER_EXCEPTION_DELETED
	%s instncies esborrades de la llista d'excepcions al lmit de sessions.
OPER_EXCEPTION_DELETED_ONE
	1 instncia esborrada de la llista d'excepcions al lmit de sessions.
OPER_EXCEPTION_DELETED_SEVERAL
	%d instncies esborrades de la llista d'excepcions al lmit de sessions.
OPER_EXCEPTION_LIST_HEADER
	llista d'excepcions al lmit de sessions actual:
# mask, limit
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
OPER_EXCEPTION_LIST_COLHEAD
	Num  Lmit Host
# mask, set-by, set-time, expires, limit, reason
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (per %s a %s; %s)
	   Lmit: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	Lmit de sessi invlid. Ha de ser un sencer vlido ms gran o igual a zero i mes petit que %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	Mascara invalida. Noms mascares reals son valides ja que excepcions no son comparades a nicks o usernames.

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST lmit | VIEW host}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST lmit
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW host
OPER_SESSION_DISABLED
	El lmit de sessi esta inhabilitat.
OPER_SESSION_INVALID_THRESHOLD
	Valor de umbral invlid. Ha de ser un sencer vlid ms gran a 1.
OPER_SESSION_NOT_FOUND
	%s no trobat a la llista de sessi.
OPER_SESSION_LIST_HEADER
	Hosts amb un mnim de %d sessions:
OPER_SESSION_LIST_COLHEAD
	Sessions  Host
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	El host %s actualment te %d sessions amb un lmit de %d.

# EXCEPTION help

OPER_HELP_EXCEPTION
	Sintaxis: EXCEPTION ADD [+expiraci] mascara lmit ra
	          EXCEPTION DEL {mascara | llista}
	          EXCEPTION MOVE numero posici
	          EXCEPTION LIST [mascara | llista]
	          EXCEPTION VIEW [mascara | llista]
	
	Permet als administradors de serveis manipular la llista
	de hosts que tenen un lmit de sessi especfic - permetent 
	a certes mquines, com servidors de shells, mantenir un nombre ms alt 
	de clients al mateix temps. En quant un host arribi al seu lmit
	de sessions, tots els clients intentant conectarse desde aquest 
	host seran expulsats. Abans de expulsar usuaris, aquests son
	notificats a traves de un /NOTICE del %S amb ajuda sobre
	el lmit de sessi. El contingut d'aquest notice es un establiment
	de configuraci.
	
	EXCEPTION ADD afegeix la mascara de host donada a la llista de
	excepcion. Teniu en compte que les mascares nick!usuari@host
	i usuari@host son invalides. Noms mascares reals com
	irc.aujac.org i *.aujac.org, son permessas ja que el
	lmit de sessions no compta nicks o noms d'usuari.
	Lmit ha de ser un numero mes gran o igual a zero. Aix determina
	quantes sessions el host pot tenir en un cert temps. El valor
	zero significa que el host no te lmits de sessi. Veure la ajuda
	sobre AKILL per a ms detalls sobre el parametre opcional
	expiraci.
	EXCEPTION DEL remou la mascara donada de la llista d'excepcions.
	EXCEPTION MOVE mou l'excepci numero a posici. Les
	excepcions entremig seran mogudes amunt o avall per a omplir l'espai.
	
	EXCEPTION LIST i EXCEPTION VIEW mostra totes les
	excepcions actuals; si la mascara opcional es donada, la llista es
	limitada a les excepcions similars a la mascara. La diferencia
	es que EXCEPTION VIEW es mes verbal, mostrant el nom de la
	persona que va afegir l'excepci, el lmit d'excepci, ra,
	mascara de hosts i la data i hora d'expiraci. 
	
	Pren nota de que un client conectant-se "utilitzara" la primera
	excepci a la que el host s'assembli. Llargues llistes d'excepcions
	i mascares que s'assemblin a moltes mascares possiblement contribueixin
	al mal rendiment dels serveis.
	
	Limitat a administradors de serveis.

OPER_HELP_SESSION
	Sintaxis: SESSION LIST umbral
	          SESSION VIEW host
	
	Permet als administradors de serveis veure la llista de sessions.
	
	SESSION LIST llista hosts amb un mnim de umbral sessions.
	L'umbral ha de ser un numero superior a 1. Aix es per a prevenir
	llistats accidentals del gran nombre de hosts de sessi.
	SESSION VIEW mostra informaci detallada sobre un host 
	especfic - incloent el compte de sessi i el lmit de sessi
	actual.
	El valor host no pot incluir comodins.
	
	Mireu l'ajuda sobre EXCEPTION per a ms informaci sobre
	lmits de sessi i como establir-los per a hosts i grups especfics
	d'ara endavant. 
	
	Limitat a administradors de serveis.

###########################################################################
#
# News system messages
#
###########################################################################

OPER_HELP_STAFF
	Syntax: STAFF

	Displays all Services Staff nicks along with level
	and on-line status.

OPER_HELP_DEFCON
	Syntax: DEFCON [1|2|3|4|5]

	The defcon system can be used to implement a pre-defined
	set of restrictions to services useful during an attemtped
	attack on the network.

OPER_HELP_DEFCON_NO_NEW_CHANNELS
	* No new channel registrations
OPER_HELP_DEFCON_NO_NEW_NICKS
	* No new nick registrations
OPER_HELP_DEFCON_NO_MLOCK_CHANGE
	* No MLOCK changes
OPER_HELP_DEFCON_FORCE_CHAN_MODES
	* Force Chan Modes (%s) to be set on all channels
OPER_HELP_DEFCON_REDUCE_SESSION
	* Use the reduced session limit of %d
OPER_HELP_DEFCON_NO_NEW_CLIENTS
	* Kill any NEW clients connecting
OPER_HELP_DEFCON_OPER_ONLY
	* Ignore any non-opers with message
OPER_HELP_DEFCON_SILENT_OPER_ONLY
	* Silently ignore non-opers
OPER_HELP_DEFCON_AKILL_NEW_CLIENTS
	* AKILL any new clients connecting


###########################################################################
#
# News system messages
#
###########################################################################

OPER_HELP_DEFCON_NO_NEW_MEMOS
	* No new memos sent
OPER_HELP_CHANKILL
	Syntax: CHANKILL [+expiry] channel reason

	Puts an AKILL for every nick on the specified channel. It
	uses the entire and complete real ident@host for every nick,
	then enforces the AKILL. 

###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[Notcies de Logon - %s] %s
NEWS_OPER_TEXT
	[Notcies de Oper - %s] %s
NEWS_RANDOM_TEXT
	[Notcies al Atzar - %s] %s

NEWS_LOGON_SYNTAX
	Sintaxis: LOGONNEWS {ADD|DEL|LIST} [text|numero]
NEWS_LOGON_LIST_HEADER
	Notcies d'entrada:
NEWS_LOGON_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_LOGON_LIST_NONE
	No hi ha notcies de entrada.
NEWS_LOGON_ADD_SYNTAX
	Sintaxis: LOGONNEWS ADD texto
NEWS_LOGON_ADD_FULL
	La llista de notcies esta plena!
NEWS_LOGON_ADDED
	Noves notcies d'entrada afegida (#%d).
NEWS_LOGON_DEL_SYNTAX
	Sintaxis: LOGONNEWS DEL {numero | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Notcia d'entrada #%d no trobada!
NEWS_LOGON_DELETED
	Notcia d'entrada #%d esborrada.
NEWS_LOGON_DEL_NONE
	No hi ha notcies d'entrada per a esborrar!
NEWS_LOGON_DELETED_ALL
	Totes les notcies d'entrada esborrades.

NEWS_OPER_SYNTAX
	Sintaxis: OPERNEWS {ADD|DEL|LIST} [texto|numero]
NEWS_OPER_LIST_HEADER
	notcies de oper:
NEWS_OPER_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_OPER_LIST_NONE
	No hay notcies de oper.
NEWS_OPER_ADD_SYNTAX
	Sintaxis: OPERNEWS ADD texto
NEWS_OPER_ADD_FULL
	La llista de notcies esta plena!
NEWS_OPER_ADDED
	Nueva noticia de oper anadida (#%d).
NEWS_OPER_DEL_SYNTAX
	Sintaxis: OPERNEWS DEL {numero | ALL}
NEWS_OPER_DEL_NOT_FOUND
	Noticia de oper #%d no trobada!
NEWS_OPER_DELETED
	Noticia de oper #%d esborrada.
NEWS_OPER_DEL_NONE
	No hi ha notcies de oper per esborrar!
NEWS_OPER_DELETED_ALL
	Totes les notcies de oper esborrades.

NEWS_RANDOM_SYNTAX
	Sintaxis: RANDOMNEWS {ADD|DEL|LIST} [text|numero]
NEWS_RANDOM_LIST_HEADER
	Notcies al Azar:
NEWS_RANDOM_LIST_ENTRY
	%5d (%s per %s)
	    %s
NEWS_RANDOM_LIST_NONE
	No hi ha notcies al azar.
NEWS_RANDOM_ADD_SYNTAX
	Sintaxis: RANDOMNEWS ADD text
NEWS_RANDOM_ADD_FULL
	La llista de notcies esta plena!
NEWS_RANDOM_ADDED
	Nova noticia a l'atzar afegida (#%d).
NEWS_RANDOM_DEL_SYNTAX
	Sintaxis: RANDOMNEWS DEL {numero | ALL}
NEWS_RANDOM_DEL_NOT_FOUND
	Noticia a l'atzar #%d no trobada!
NEWS_RANDOM_DELETED
	Notcia a l'atzar #%d esborrada.
NEWS_RANDOM_DEL_NONE
	No hi ha notcies a l'atzar per esborrar!
NEWS_RANDOM_DELETED_ALL
	Totes les notcies al azar esborrades.

NEWS_HELP_LOGON
	Sintaxis: LOGONNEWS ADD text
	        LOGONNEWS DEL {numero | ALL}
	        LOGONNEWS LIST
	
	Edita o mostra la llista de notcies d'entrada. Quant un
	usuari es connecta a la xarxa, aquest missatges li seran
	enviats. (De tota manera, no mes de 3 missatges seran enviats
	per evitar floodejar a l'usuari. Si hi ha ms de 3 notcies,
	els 3 ultims li seran enviades.)
	
	LOGONNEWS LIST pot ser utilitzat per qualsevol operador 
	d'IRC per a llistar les notcies actuals. ADD o DEL noms
	pot ser utilitzat per administradors de serveis.

NEWS_HELP_OPER
	Sintaxis: OPERNEWS ADD text
	          OPERNEWS DEL {numero | ALL}
	          OPERNEWS LIST
	
	Edita o mostra la llista de notcies. Quant un usuari es
	transforma en operador (amb la comanda /oper), aquests
	missatges li seran enviats. (De tota manera, no mes de 3 missatges seran 
	enviats per evitar floodejar a l'usuari. Si hi ha ms de 3 notcies,
	els 3 ultims li seran enviades.)
	
	OPERNEWS LIST pot ser utilitzat per qualsevol operador d'IRC
	per llistar les notcies d'operador actuals. ADD i DEL noms
	pot ser utilitzats per administradors de serveis.

NEWS_HELP_RANDOM
	Sintaxis: RANDOMNEWS ADD text
	          RANDOMNEWS DEL {numero | ALL}
	          RANDOMNEWS LIST
	
	Edita o mostra la llista de missatges de noticia a l'atzar.
	Quant un usuari es connecta a la xarxa, un (i noms un) dels
	missatges a l'atzar sera escollit i enviat a ells.
	
	RANDOMNEWS LIST pot ser utilitzat per qualsevol operador 
	d'IRC per llistar la llista de notcies actual. ADD i DEL
	noms pot ser utilitzats per administradors de serveis.

###########################################################################
#
# HelpServ help message
#
###########################################################################

HELP_HELP
	%S es un servei designat per donar informaci sobre
	serveis. Tpics d'ajuda estan disponibles via les
	comandes HELP dels altres clients de serveis:

	/msg %s HELP
	     per mes informaci sobre registrar nicknames

	/msg %s HELP
	     per mes informaci sobre registrar i controlar
	     canals

	/msg %s HELP
	     per ms informaci sobre enviar missatges a usuaris no
	     en linea.

HELP_HELP_BOT

	/msg %s HELP
	     per ms informaci sobre establir un bot en el teu canal

HELP_HELP_HOST

	/msg %s HELP
	     for information on setting up nick vHosts

###########################################################################
#
# NickServ help messages
#
###########################################################################

NICK_HELP
	%S Et permet "registrar" un nickname i
	prevenir a d'altres utilitzar-lo. Les segents comandes
	permeten el registre i manteniment de nicknames;
	per a utilitzar-los, escriu /msg %S comanda.
	per ms informaci sobre una comanda especifica
	escriu /msg %S HELP comanda.
	
	    REGISTER   Registra un nickname
	    GROUP      Ingresa en un grup
	    IDENTIFY   Per identificar-te amb la teva clau
	    ACCESS     Modifica la llista d'adrees autoritzades
	    SET        Estableix proteccions, inclouent kills
	    DROP       Cancela el registre d'un nickname
	    RECOVER    Kickeja un usuari que estigui utilitzant el teu nickname
	    RELEASE    Repren possesi del teu nick desprs de RECOVER
	    SENDPASS   Vas oblidar la teva clau? Intenta aix
	
	Altres comandes: GHOST, GLIST, INFO, LIST, LOGOUT, STATUS
	
	NOTESE: Aquest servei intenta proveir una eina
	pels usuaris d'IRC d'assegurar-se que la seva identitat no esta
	compromessa, NO per facilitar el "robatori" de nicknames
	o un altre acci maliciosa. L'abus de %S resultara, com a
	mnim, en la perdua del nickname esmentat.

NICK_HELP_EXPIRES
	Nicknames en desus estan subjectes a l'expiraci
	automatica, en altres paraules, seran esborrats desprs
	de %d dies.

NICK_HELP_REGISTER
	Sintaxis: REGISTER clau [email]
	
	Registra el teu nickname a la base de dades de %S. Un
	cop registrat, pots utilitzar les comandes SET i ACCESS
	per configurar els parametres del teu nick al teu gust.
	Assegura't de recordar la clau que vas fer servir per
	registrar-te - la necessitaras per fer canvis en el teu nick
	(Tingues en compte que les majuscules importen!  AUJAC,
	Aujac, i aujac sn totes claus diferents!)
	
	Guies per escollir claus:
	
	Las claus no han de ser fcils d'endevinar. Per exemple,
	utilitzar el teu nom real com clau es una mala idea. Utilitzar
	el teu nickname com a clau es una idea pitjor :( i,
	de fet, %S no ho permetria. A mes, claus curtes
	son vulnerables a ser encertades, aixi que hauries d'escollir una
	clau de com a mnim 5 carcters.
	Per ltim, el carcter d'espai no pot ser utilitzat.
	
	El parametre email es opcional i establira l'email pel
	teu nick inmediatament. Com sigui, pot ser que sigui demanat
	en certes xarxes.
	La teva privacitat es respectada; aquest e-mail no sera donat a
	terceres persones.
	
	Aquesta comanda crea un nou grup pel teu nickname
	que et permetra registrar altres nicks desprs compartint
	la mateixa configuraci, memos i privilegis. Per ms
	informaci sobre aquesta caracterstica, escriu /msg %S
	HELP GROUP.
	
NICK_HELP_GROUP
	Sintaxis: GROUP grupo clau
	
	Aquesta comanda fa que el teu nickname s'adhereixi al grup de nicknames
	grup. clau es la de teu nickname.
	
	L'uni a un grup et permetra compartir configuracions,
	memos, i privilegis en canals amb tots els nicknames en un
	grup, i molt ms!
	 
	Un grup existeix sempre i quant sigui servible. Aix
	significa que si un nick del grup es eliminat, no perdrs
	les caracteristiques compartides descrites anteriorment, sempre i
	quant al menys un nick quedi al grup.
	
	Pots utilitzar aquesta comanda encara que no estigui registrar el teu
	nick. Si el teu nick ja esta registrat hauras d'identificar-te
	abans d'utilitzar aquesta comanda. Escriu /msg %S HELP
	IDENTIFY per ms informaci. Potser que no sigui possible
	a la teva xarxa.
	
	Es recomenable utilitzar aquesta comanda amb un nick no registrat ja
	que sera registrat automaticament quant l'utilitzis.
	Pots utilitzar-la amb un nick ja registrat (per canviar de grup) 
	sols si els administradors de la teva xarxa ho permeten.
	
	Pots estar en un sol grup a la vegada. L'uni de
	grups no es possible.
	
	Tingues en compte: tots els nicks en un grup comparteixen la
	mateixa clau.

NICK_HELP_IDENTIFY
	Sintaxis: IDENTIFY clau
	
	Informa a %S que tu ets realment el propietari del teu nick.
	Moltes comandes requereixen que t'identifiquis amb aquesta
	comanda abans d'utilitzar-les. La clau hauria de ser la mateixa
	que va ser enviada amb la comanda REGISTER.
	
NICK_HELP_UPDATE
	Syntax: UPDATE

	Updates your current status, i.e. it checks for new memos,
	sets needed chanmodes (ModeonID) and updates your vhost and
	your userflags (lastseentime, etc).
	
NICK_HELP_LOGOUT
	Sintaxis: LOGOUT
	
	Aquesta comanda inverteix l'efecte de IDENTIFY, o sigui, 
	et fa ja no reconeixible com a propietari del teu nick.
	Tingues en compte que no et sera obligatori identificar-te
	un altre cop.

NICK_HELP_DROP
	Sintaxis: DROP [nickname]
	
	Elimina el teu nickname de la base de dades de %S. Un nick
	que ha estat eliminat esta lliure per que qualsevol persona
	el registri.
	
	Pots eliminar un nick en el teu grupo indicant-lo com a
	parametre nick.
	
	Abans d'utilitzar aquesta comanda has d'identificar-te amb la teva
	clau (/msg %S HELP IDENTIFY per ms informaci).

NICK_HELP_ACCESS
	Sintaxis: ACCESS ADD mascara
	          ACCESS DEL mascara
	          ACCESS LIST
	
	Modifica o mostra la llista d'accs pel teu nick. Aquesta
	s la llista d'adreces que seran automaticament
	reconegudes per %S com autoritzades a utilitzar el nick. Si
	vols utilitzar el nick des d'una adrea diferent,
	has d'enviar una comanda IDENTIFY per fer que %S et
	reconegui.
	
	Exemples:
	
	    ACCESS ADD anyone@*.aujac.org
	        Permet accs a l'usuari anyone des de
	        qualsevol maquina en el domini aujac.org.
	
	    ACCESS DEL anyone@*.aujac.org
	        Anul.la la comanda anterior.
	
	    ACCESS LIST
	        Mostra la llista d'accs actual.

NICK_HELP_SET
	Sintaxis: SET Opci parametres
	
	Estableix varies opcions per a nicknames. Opci pot ser
	una de:
	
	    DISPLAY    Estableix el display del teu grup amb serveis
	    PASSWORD   Estableix la clau del teu nickname
	    LANGUAGE   Estableix el llenguatge amb el que els serveis
	                   t'enviaran missatges
	    URL        Associa una URL amb el teu nickname
	    EMAIL      Associa un E-mail amb el teu nickname
	    ICQ        Associa un numero ICQ amb el teu nickname
	    GREET      Associa un salutaci amb el teu nickname
	    KILL       Activa o desactiva la protecci
	    SECURE     Activa o desactiva la seguretat de nickname
	    PRIVATE    Preveu el teu nickname d'apareixer en un
	                   /msg %S LIST
	    HIDE       Oculta algunes parts de la teva informaci
	    MSG        canvia el metode de comunicaci amb els
	                    serveis
	
	Per utilitzar aquest comanda, has d'identificar-te primer 
	utilitzant la teva clau (/msg %S HELP IDENTIFY
	per mes informaci).
	
	Escriu /msg %S HELP SET opci per mes
	informaci sobre una opci especifica.

NICK_HELP_SET_DISPLAY
	Sintaxis: SET DISPLAY nou-display
	
	canvia el display utilitzat per referir-te al teu grup de
	nicks en serveis. El nou display HA DE SER un nick
	del teu grup.

NICK_HELP_SET_PASSWORD
	Sintaxis: SET PASSWORD nueva-clau
	
	Canvia la clau utilitzada per identificar-te com el
	propietari del nick.

NICK_HELP_SET_LANGUAGE
	Sintaxis: SET LANGUAGE numero
	
	Canvia el llenguatge que serveis utilitza per enviar-te missatges
	(per exemple, al respondre a una comanda que enviis).
	numero ha de ser escollit de la llista de llenguatges
	soportats:
	

NICK_HELP_SET_URL
	Sintaxis: SET URL url
	
	Associa l'URL donada amb el teu nickname. Aquesta URL
	sera mostrada quant algu demani informaci
	sobre el teu nick amb la comanda INFO.

NICK_HELP_SET_EMAIL
	Sintaxis: SET EMAIL direccion
	
	Associa el E-mail donat amb el teu nickname. L'e-mail
	sera mostrat quant algu demani informaci
	sobre el teu nick amb la comanda INFO.
	
NICK_HELP_SET_ICQ
	Sintaxis: SET ICQ numero
	
	Associa el numero ICQ donat amb el teu nickname. Aquest
	numero sera mostrat quant algu soliciti
	informaci sobre el teu nick amb la comanda INFO.
	
NICK_HELP_SET_GREET
	Sintaxis: SET GREET missatge
	
	Fa que el missatge introduit sigui la salutaci pel teu nickname, 
	el que sera mostrat quant entris a un canal amb la
	opci GREET habilitada, sempre i quant tinguis 
	l'accs necessari.

NICK_HELP_SET_KILL
	Sintaxis: SET KILL {ON | QUICK | IMMED | OFF}
	
	Canvia la protecci automtica del teu nick a on o off.
	Amb protecci on, si un altre usuari intenta utilitzar el teu nick,
	tindra un minut per canviar de nick, desprs del qual
	%S canviara el seu nick automaticament.
	
	Si estableixes QUICK, l'usuari tibdr noms 20 segons
	per canviar el nick en comptes dels 60 habituals. Si selecciones
	IMMED, el nick del usuari sera canviat automaticament
	sense ser avisat ni donar-li oportunitat de canviar-lo abans;
	per favor no utilitzis aquesta opci excepte que ho consideris
	necessari. A mes, els administradors de la xarxa poden haber
	deshabilitat aquesta opci.

NICK_HELP_SET_SECURE
	Sintaxis: SET SECURE {ON | OFF}
	
	Canvia les caracteristiques de seguretat de %S pel teu nick a on
	u off. Amb SECURE establert, has d'especificar la teva clau 
	per ser reconegut com propietari del nick, a pesar de que la teva adrea
	estigui a la llista d'accss. D'altra banda, si estas a la llista 
	d'accs, %S no te auto-kickejara no important l'establiment de l'opci
	KILL.

NICK_HELP_SET_PRIVATE
	Sintaxis: SET PRIVATE {ON | OFF}
	
	Fa que %S activi o desactivi l'opci de privacitat del teu
	nick. Amb PRIVATE establert,el teu nickname no apareixera en les
	llistes de nicknames generades amb la comanda LIST de %S.
	(D'altra banda, qualsevol persona que sapigue el teu nick podra comprobar
	la teva informaci utilitzant la comanda INFO.)

NICK_HELP_SET_HIDE
	Sintaxis: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	Permet prevenir que certa informaci sobre el teu nick sigui donada
	quant es sol.licitada mitjanant la comanda %S INFO.
	Pots ocultar la teva adrea e-mail (EMAIL), l'ultima
	mascara usuari@host (USERMASK), i el teu ltim missatge
	quit (QUIT).
	El segon parametre especifica si la informaci ha de ser
	ocultada (OFF) o mostrada (ON).
	
NICK_HELP_SET_MSG
	Sintaxis: SET MSG {ON | OFF}
	
	Et permet escollir la forma en la que els serveis es
	comunicaran amb tu. Amb MSG establert, els serveis
	utilitzaran msgs, de l'altra forma utilitzaran notcies. 

NICK_HELP_RECOVER
	Sintaxis: RECOVER nickname [clau]
	
	Et permet recuperar el teu nickname si alg l'esta
	utilitzant; Aix fa el mateix que %S fa automaticament
	si alg prova d'utilitzar un nick amb protecci de kill.
	
	Quant utilitzes aquesta comanda, %S creara un fals usuari en
	linea amb el mateix nickname de l'usuari que estas tractant
	de recuperar. Aix causa que els serveis IRC desconectin
	a l'altre usuari. L'usuari fals romandra en linea per
	un minut per assegurar que l'altre usuari no es reconecti
	inmediatament; desprs del minut, pots reclamar el teu
	nick. Com alternativa, utilitza la comanda RELEASE
	(/msg %S HELP RELEASE) per recuperar el nick ms aviat.
	
	Per utilitzar la comanda RECOVER per un nick, la teva
	adrea actual mostrada a /WHOIS ha d'estar a la llista
	d'accs d'aquest nick, has d'estar identificat i en el
	grup d'aquest nick, o has de proveir la clau correcta
	per aquest nickname.

NICK_HELP_RELEASE
	Sintaxis: RELEASE nickname [clau]
	
	Especifica a %S a esborrar qualsevol suspensi que tingui el teu nick
	causada per protecci automatica de kill o per s de la comanda
	RECOVER. Per defecte, la suspensi dura un minut;
	Aquesta comanda la finalitza abans.
	
	Per utilitzar la comanda RELEASE per un nick, la teva
	adrea actual mostrada a /WHOIS ha d'estar a la llista
	d'accs d'aquest nick, has d'estar identificat i en el
	grup d'aquest nick, o has de proveir la clau correcta
	per aquest nickname.

NICK_HELP_GHOST
	Sintaxis: GHOST nickname [clau]
	
	Termina una sessi IRC "fantasma" utilitzant el teu nick. Una
	sessi fantasma s una connexi falsa, de tal manera que els
	servidors IRC creuen esta en linea per una ra o altre.
	Tipicament, aix succeix si el teu ordinador es bloqueja o la
	teva connexi a internet es talla mentres estas
	a IRC.
	
	Per utilitzar la comanda GHOST per un nick, la teva
	adrea actual mostrada a /WHOIS ha d'estar a la llista
	d'accs d'aquest nick, has d'estar identificat i en el
	grup d'aquest nick, o has de proveir la clau correcta
	per aquest nickname.

NICK_HELP_INFO
	Sintaxis: INFO nickname [ALL]
	
	Mostra informaci relativa al nick que s'especifiqui,
	tal com el propietari del nick, l'ultima adrea utilitzada
	i temps, i opcions del nick. Si estas identificat amb el
	nick per el qual demanes informaci i utilitzes el parametre
	ALL, podras veure tota la informaci; independentment de
	si esta oculta o no.

NICK_HELP_LIST
	Sintaxis: LIST patr
	
	Llista tots els nicknames que concordin amb el patr
	donat, en el format nick!usuari@host. Nicks amb 
	l'opci PRIVATE establerta no seran mostrats.
	
	Exemples:
	
	    LIST *!cistus@aujac.org
	        Llista tots els nicks registrats per cistus@aujac.org.
	
	    LIST *Bot*!*@*
	        Llista tots els nicks registrats amb Bot en els seus
	        noms (sensible a majuscules i miniscules).
	
	    LIST *!*@*.aujac.org
	        Llista tots els nicks registrats per usuaris amb el
	        domini aujac.org.

NICK_HELP_ALIST
	Syntax: ALIST [level]
	
	Lists all channels you have access on. Optionally, you can specify
	a level in XOP or ACCESS format. The resulting list will only 
	include channels where you have the given level of access.

	Examples:
	    ALIST Founder
	        Lists all channels where you have Founder
	    access.

	    ALIST AOP
	        Lists all channels where you have AOP access 
	    or greater.

	    ALIST 10
	        Lists all channels where you have level 10 
	    access or greater.
	
	Channels that have the NOEXPIRE option set will be prefixed by 
	an exclamation mark.
	
NICK_HELP_GLIST
	Sintaxis: GLIST
	
	Llista tots els nicks en el teu grup.

NICK_HELP_STATUS
	Sintaxis: STATUS nickname...
	
	Retorna informaci sobre si l'usuari que utilitza el nick especificat
	ha estat reconegut com el propietari del nickname.
	La resposta te el segent format:
	
	    nickname codi-del-status
	
	A on nickname es el nickname enviat amb la comanda, i
	codi-del-status es un dels segents:
	
	    0 - Usuari no esta en linea o el nick no esta registrat.
	    1 - Usuari no reconegut com el propietari del nick.
	    2 - Usuari reconegut sols mitjanant la llista d'accs.
	    3 - Usuari reconegut mitjanant autentificaci per clau.
	
	Fins 16 nicknames poden ser enviats amb cada comanda. El
	reste seran ignorats. Cap missatge d'error es generat si
	el nickname no es donat.
	
NICK_HELP_SENDPASS
	Sintaxis: SENDPASS nickname
	
	Envia la clau del nickname donat a l'adrea
	e-mail establerta en el registre del nickname. Aquesta comanda
	es sumament til per recuperar claus perdudes.
	
	Pot ser limitat a operadors d'IRC en certes
	xarxes.
	
	Aquesta comanda no esta disponible quant encriptaci esta habilitada.

NICK_SERVADMIN_HELP
	
	Les segents comandes estan disponibles a administradors
	de serveis:
	
	    GETPASS    Recupera la clau per un nickname
	                   (sols si encriptaci esta deshabilitada)
	    FORBID     Impossibilita que un nickname sigui utilitzat
	
	Administradors de serveis poden tamb eliminar qualsevol
	nickname sense tenir que identificar-se pel nick i poden
	veure la llista d'accs per qualsevol nickname
	(/msg %S ACCESS LIST nick).

NICK_SERVADMIN_HELP_LOGOUT
	Sintaxis: LOGOUT [nickname [REVALIDATE]]
	
	Sense un parametre, desf l'efecte de la comanda IDENTIFY, 
	s a dir, fa que no siguis reconegut com l'autentic propietari del nick
	Tingues en compte, que no seras necessari tornar-te a identificar.
	
	Amb un parametre, fa lo mateix pel nick donat. Si
	a ms a ms especifiques REVALIDATE, els serveis requeriran
	a l'esmentat nick a reidentificar-se. Aquest s esta limitat a
	administradors de serveis.

NICK_SERVADMIN_HELP_DROP
	Sintaxis: DROP [nickname]
	
	Sense un parametre, elimina el teu nickname de la base de dades de
	%S.
	
	Amb un parametre, elimina el nick esmentat de la base de
	dades. Pots eliminar qualsevol nick del teu grup sense
	privilegis especials. Eliminar qualsevol nick esta
	limitat a administradors de serveis.

NICK_SERVADMIN_HELP_SET
	
	Administradors de serveis poden tambe establir
	l'opci NOEXPIRE, amb la qual nicknames poden ser
	previnguts abans de caducar. A ms a ms, administradors de
	serveis poden establir opcions per qualsevol nickname
	sense especificar una clau, utilitzant el format SET
	nickname opci parametres.

NICK_SERVADMIN_HELP_SET_NOEXPIRE
	Sintaxis: SET [nickname] NOEXPIRE {ON | OFF}
	
	Estableix si el nick esmentat caducara o no. Establir-lo a ON
	evita que el nickname caduqui. Si cap nickname es
	especificat, estableix l'opci de no caducitat pel teu nick.
	
	Limitat a administradors de serveis.

NICK_SERVADMIN_HELP_INFO
	
	Administradors de serveis poden utilitzar el parametre
	ALL amb qualsevol nick.

NICK_SERVADMIN_HELP_LIST
	Sintaxis: LIST patr [FORBIDDEN] [NOEXPIRE]
	
	Llista tots els nicknames registrats que concordin amb el
	patr donat, en el format nick!usuari@host. Nicks amb
	L'opci PRIVATE tan sols sera mostrada a administradors
	de serveis. Nicks amb l'opci NOEXPIRE establerta tindran
	un ! avantposat al nickname per a administradors de
	serveis.
	
	Si les opcions FORBIDDEN o NOEXPIRE son especificades, noms nicks
	que, respectivament, estan FORBIDDEN o estan establerts a
	NOEXPIRE seran mostrats. Si totes dues opcions son especificades, tots dos
	tipus de nicks seran mostrats. Aquestes opcions estan
	limitades a administradors de serveis.
	
	Exemples:
	
	    LIST *!cistus@aujac.org
	        Llista tots els nicks registrats per cistus@aujac.org.
	
	    LIST *Bot*!*@*
	        Llista tots els nicks registrats amb Bot en
	        els seus noms. (no sensible a majuscules i minuscules).
	
	    LIST * NOEXPIRE
	        Llista tots els nicks registrats que hagin estat establerts
	        a no caducitat.

NICK_SERVADMIN_HELP_ALIST
	Syntax: ALIST [nickname] [level]
	
	With no parameters, lists channels you have access on. With
	one parameter, lists channels that nickname has access 
	on. With two parameters lists channels that nickname has 
	level access or greater on.

	This use limited to Services admins.

NICK_SERVADMIN_HELP_GLIST
	Sintaxis: GLIST [nickname]
	
	Sense un parametre, llista tots els nicknames en el teu
	grup.
	
	Amb un parametre, llista tots els nicknames que hi ha
	en el grup del nick esmentat.
	El seu s esta limitat a administradors de serveis.

NICK_SERVADMIN_HELP_GETPASS
	Sintaxis: GETPASS nickname
	
	Retorna la clau pel nickname donat. Tingues en compte
	que quant aquesta comanda es utilitzada, un missatge inclouent
	la persona que va executar la comanda i el nickname en el qual
	va ser utilitzat sera establert i enviat com WALLOPS/GLOBOPS.
	
	Limitat a administradors de serveis.
	
	Aquesta comanda no esta disponible si encriptaci esta habilitada.

NICK_SERVADMIN_HELP_GETEMAIL
	Syntax: GETEMAIL user@emailhost

	Returns the matching nicks that used given email. Note that
	you can not use wildcards for either user or emailhost. Whenever
	this command is used, a message including the person who issued
	the command and the email it was used on will be logged.

	Limited to Services admins.

NICK_SERVADMIN_HELP_FORBID
	Sintaxis: FORBID nickname [ra]
	
	Impedeix que un nickname sigui registrat o utilitzat per alg.
	Pot ser cancel.lat eliminat el nick.
	
	En algunes xarxes, la ra es necessaria.
	
	Limitat a administradors de serveis.

###########################################################################
#
# ChanServ help messages
#
###########################################################################

CHAN_HELP
	%S et permet registrar i controlar varis
	aspectes dels canals. Sovint, %S pot prevenir
	a usuaris maliciosos "pendre" canals limitant
	qui esta perms a tenir privilegis d'operador.
	Les comandes disponibles estan llistades a continuaci;
	Per a utilitzar-los, escriu /msg %S comanda.
	Per ms informaci sobre una comanda especifica,
	escriu /msg %S HELP comanda.
	
	    REGISTER   Registra un canal
	    IDENTIFY   T'identifica amb la teva clau
	    SET        Establir opcions i informaci d'un canal
	    AOP        Modifica la llista d'usuaris AOP
	    SOP        Modifica la llista d'usuaris SOP
	    ACCESS     Modifica la llista d'usuaris privilegiats
	    LEVELS     Redefine el significat de nivells d'accs
	    AKICK      Mant la llista d'AutoKick
	    DROP       Cancel.la l'enregistrament d'un canal
	    SENDPASS   Ajuda a recuperar claus perdudes
	
	Altres comandes: BAN, CLEAR, DEOP, DEVOICE, GETKEY, INFO, 
	                INVITE, KICK, LIST, LOGOUT, OP, UNBAN, 
	                VOICE, VOP
	
CHAN_HELP_UNREAL
	
	Aquestes comandes tambe estan disponibles en aquesta xarxa:
	    DEHALFOP, DEOWNER, DEPROTECT, HALFOP, HOP, OWNER,
	    PROTECT

CHAN_HELP_ULTIMATE
	
	Aquestes comandes tambe estan disponibles en aquesta xarxa:
	    DEHALFOP, HALFOP, HOP

CHAN_HELP_ULTIMATE3
	
	Aquestes comandes tambe estan disponibles en aquesta xarxa:
	    DEHALFOP, HALFOP, HOP, ADMIN, DEADMIN

CHAN_HELP_EXPIRES
	
	Tingues en compte que qualsevol canal que no sigui utilitzat durant
	%d dies (al qual cap usuari a la llista d'accs
	del canal entri en aquest periode de temps) sera
	automaticament eliminat.

CHAN_HELP_REGISTER
	Sintaxis: REGISTER canal clau descripci
	
	Registra un canal en la base de dades de %S. Per a
	utilitzar aquesta comanda, has de ser un operador en el
	canal que intentis registrar. La clau es utilitzada amb
	la comanda IDENTIFY per a permetre a altres fer
	canvis en les opcions del canal posteriorment.
	L'ltim parametre, el qual ha de ser incls, s
	una descripci general del propsit del canal.
	
	Quant registres un canal, ets reconegut com el
	"fundador" del canal. El fundador del canal pot
	canviar tots els parametres pel canal;
	%S tamb donar al fundador privilegis d'operador
	automaticamente quant l'usuari entri al canal.
	Esbrina sobre la comanda ACCESS
	(/msg %S HELP ACCESS) Per ms informaci sobre
	com donar aquests privilegis a altres usuaris del canal.
	
	NOTA: Per registrar un canal has d'haver registrat
	el teu nickname primer. Si encara no ho has fet, escriu
	/msg %s HELP per ms informaci de com fer-ho.

CHAN_HELP_IDENTIFY
	Sintaxis: IDENTIFY canal clau
	
	T'identifica amb %S com el fundador del canal especificat.
	Moltes comandes requereixen que utilitzis aquesta comanda abans
	d'utilitzar-los. La clau hauria de ser la mateixa que
	vas enviar amb la comanda REGISTER.
	
CHAN_HELP_LOGOUT
	Sintaxis: LOGOUT canal nickname
	
	Aquest comanda fa que el nickname donat ja no siguis identificat
	en el canal especificat.
	
	Si ets el fundador del canal, pots desconectar a
	qui sigui, d'altra banda tan sols et pots desconnectar
	a tu mateix.

CHAN_HELP_DROP
	Sintaxis: DROP canal
	
	Desenregistra el canal especificat. Noms pot ser utilitzat pel
	fundador del canal, qui ha d'utilitzar primer la comanda
	 IDENTIFY.

CHAN_HELP_SET
	Sintaxis: SET canal opci parametres
	
	Li permet al fundador del canal establir varies opcions
	del canal i altres informacions.
	
	Opcions disponibles:
	
	    FOUNDER       Estableix el fundador d'un canal
	    SUCCESSOR     Estableix el successor d'un canal
	    PASSWORD      Estableix el password del fundador
	    DESC          Estableix la descripci del canal
	    URL           Associa una URL amb el canal
	    EMAIL         Associa un E-mail amb el canal
	    ENTRYMSG      Estableix un missatge a enviar als
	                  usuaris quant entrin al canal
	    BANTYPE       Estableix com els serveis posen bans
	                  en el canal
	    MLOCK         Fixa els Modes de canal on o off
	    KEEPTOPIC     Rete el topic quant el canal no
	                  esta en uso
	    OPNOTICE      Envia una noticia quant les comandes
	                  OP/DEOP son utilitzats
	    PEACE         Regula l's de comandes critiques
	    PRIVATE       Oculta el canal de la comanda LIST
	    RESTRICTED    Restringeix l'accs al canal
	    SECURE        Activa les opcions de seguretat de %S
	    SECUREOPS     Estricte control de l'estatus de chanop
	    SECUREFOUNDER Estricto control de l'estatus de fundador
	                  del canal
	    SIGNKICK      Firma kicks fets amb la comanda KICK
	    TOPICLOCK     El topic sols pot ser canviat amb
	                  TOPIC
	    XOP           Canvia el sistema de privilegis d'usuari
	
	Escriu /msg %S HELP opci per ms informaci
	sobre una opci en particular.

CHAN_HELP_SET_FOUNDER
	Sintaxis: SET canal FOUNDER nick
	
	Canvia el fundador d'un canal. El nou nickname ha de
	ser un d'enregistrat.

CHAN_HELP_SET_SUCCESSOR
	Sintaxis: SET canal SUCCESSOR nick
	
	Canvia el successor d'un canal. Si el nickname fundador
	caduca o es eliminat mentres el canal esta encara registrat,
	el successor es convertira en el nou fundador del canal.
	Per, si el successor ja te molts canals
	registrats (%d), el canal sera eliminat, tal i com
	si no hi hagus un successor. El nou nickname ha de ser un
	d'enregistrat.

CHAN_HELP_SET_PASSWORD
	Sintaxis: SET canal PASSWORD clau
	
	Estableix la clau utilitzada per identificar-se com el
	fundador del canal.

CHAN_HELP_SET_DESC
	Sintaxis: SET canal DESC descripci
	
	Estableix la descripci pel canal, la que es mostrada
	amb les comandes LIST i INFO.

CHAN_HELP_SET_URL
	Sintaxis: SET canal URL [url]
	
	Associa l'URL especificada amb el canal. Aquesta URL sera mostrada
	quant algu sol.liciti informaci sobre el canal amb
	la comanda INFO. Si no s'especifica cap parametre, 
	esborra la URL actual pel canal.

CHAN_HELP_SET_EMAIL
	Sintaxis: SET canal EMAIL [direcci]
	
	Associa l'adrea e-mail especificada amb el canal.
	Aquesta adrea sera mostrada quant algu sol.liciti
	informaci sobre el canal amb la comanda INFO.
	Si cap parametre es establert, borra l'adrea e-mail
	actual pel canal.

CHAN_HELP_SET_ENTRYMSG
	Sintaxis: SET canal ENTRYMSG [missatge]
	
	Especifica el missatge que sera enviat via /notice als
	usuaris quant ingressin al canal. Si cap parametre
	es especificat, cap missatge sera enviat al entrar al canal.
	
CHAN_HELP_SET_BANTYPE
	Sintaxis: SET canal BANTYPE tipus_de_ban
	
	Especifica el tipus de ban que sera utilitzat pels
	serveis quant necessitin banear algu
	del teu canal.
	
	Tipus de ban es un numero entre 0 i 3 que significa:
	
	0: ban de la forma *!usuari@host
	1: ban de la forma *!*usuari@host
	2: ban de la forma *!*@host
	3: ban de la forma *!*usuari@*.domini

CHAN_HELP_SET_KEEPTOPIC
	Sintaxis: SET canal KEEPTOPIC {ON | OFF}
	
	Habilita o deshabilita l'opci de retenci de topic 
	per un canal. Quant la retenci de topic esta
	establerta, el topic pel canal sera recordat 
	%S fins i tot desprs de que l'ltim usuari
	sorti del canal, i sigui restaurat la prxima vegada que
	el canal sigui creat.

CHAN_HELP_SET_TOPICLOCK
	Sintxi: SET canal TOPICLOCK {ON | OFF}
	
	Habilita o deshabilita L'opci de fixaci de topic
	per a un canal. Quan la fixaci de topic est
	establerta, %S no permetr que el topico del canal
	sigui canviat excepte amb la comanda TOPIC.

CHAN_HELP_SET_MLOCK
	Sintxi: SET canal MLOCK Modes
	
	Estableix el parmetre de fixaci de Modes pel canal.
	%S et permet definir certs Modes de canal per a estar
	sempre encesos o apagats o lliures d' estar un dels
	anteriors.
	
	El parmetre Modes s construit de la mateixa forma
	que La comanda /MODE; aix significa, Modes seguits
	per un + estan fixats encesos, i Modes seguits per
	un - estan fixats apagats. tenir en compte que, a
	difrencia de La comanda MODE, cada us de SET MLOCK
	esborrar tots els Modes fixats prviament abans de
	establir els nous!
	
	AdVeuretncia: Si estableixes una clau amb fixaci de Mode, com
	en el segon exemple de ms endevant, haurs tamb d'establir la
	Opci RESTRICTED pel canal (veure HELP SET RESTRICTED),
	o qui sigui que entri al canal quan aquest s buit podr veure la
	clau!
	
	Exemples:
	
	    SET #canal MLOCK +nt-iklps
	        Fora els Modes n i t encesos, i els Modes i, k,
	        l, p i s apagats. El Mode m s deixat lliure per a
	        estar encs o apagat.
	
	    SET #canal MLOCK +knst-ilmp mi-key
	        Fora els Modes k, n, s, i t encesos, i els Modes
	        i, l, m, i p apagats. Tamb fora la clau del canal
	        a ser "mi-clau".
	
	    SET #canal MLOCK +
	        Esborra la fixaci de Modes; tots els Modes del canal
	        sn lliures d'estar encesos o apagats.

CHAN_HELP_SET_PEACE
	Sintxi: SET canal PEACE {ON | OFF}
	
	Habilita o deshabilita l'opci de pau per a un
	canal. Quan pau est establerta, un usuari no
	podra expulsar, banejar o esborrar un estatus de canal
	d'un usuari amb nivelll igual o superior a ell via
	comandes de %S.

CHAN_HELP_SET_PRIVATE
	Sintxi: SET canal PRIVATE {ON | OFF}
	
	Habilita o deshabilita l'opci de privacitat per a un canal.
	Quan privacitat est establerta, un /msg %S LIST no
	inclour el canal en cap llista.

CHAN_HELP_SET_RESTRICTED
	Sintxi: SET canal RESTRICTED {ON | OFF}
	
	Habilita o deshabilita l'opci de accs restringit
	per a un canal. Quan l' accs restringit est
	establert, Els usuaris seran inhabilitats de tenir
	privilegis d'operador de canal. (usuaris amb accs
	negatiu i, si seguretat de ops est establerta,
	usuaris no a la llista de accs) seran 
	kickeajats i banejats del canal.

CHAN_HELP_SET_SECURE
	Sintxi: SET canal SECURE {ON | OFF}
	
	Habilita o deshabilita les caracterstiques de seguretat
	de %S per a un canal. Quan SECURE est
	establert, noms usuaris que haguin registrat els seus nicknames
	amb %s i haguin utilitzat IDENTIFY amb la seva clau els ser
	atorgat accs al canal controlat per la llista de
	accs.

CHAN_HELP_SET_SECUREOPS
	Sintxi: SET canal SECUREOPS {ON | OFF}
	
	Habilita o deshabilita l'opci seguretat de ops per a un
	canal.  Quan seguretat de ops est establerta, usuaris
	que no estaven a la llista d'usuaris no els ser perms 
	obtenir l' estatus d'operador de canal.
	
CHAN_HELP_SET_SECUREFOUNDER
	Sintxi: SET canal SECUREFOUNDER {ON | OFF}
	
	Habilita o deshabilita l'opci seguretat de fundador per a
	un canal. Quan seguretat de fundador est establerta, noms
	el fundador real podr eliminar el canal, canviar la seva clau,
	el seu fundador i el seu sucesor, i no aquells que estiguin identificats
	amb %S.
	
CHAN_HELP_SET_SIGNKICK
	Sintxi: SET canal SIGNKICK {ON | LEVEL | OFF}
	
	Habilita o deshabilita els kicks firmats per a un
	canal. Quan SIGNKICK est establert, kicks
	fets amb la comanda %S KICK tindran el
	nick que ha fet servir la comanda en la ra.
	
	Si uses LEVEL, aquells que tenen nivelll superior o
	igual al nivelll SIGNKICK en el canal no tindran els seus kicks 
	firmats. Veure /msg %S HELP LEVELS per a ms informaci.

CHAN_HELP_SET_XOP
	Sintxi: SET canal XOP {ON | OFF}
	
	Habilita o deshabilita el sistema de llistes xOP per a un canal.
	Quan XOP est establert, has de fer servir les comandes AOP/SOP/VOP
	per a donar privilegis de canal a usuaris. D'altra manera
	has de fer servir la comanda ACCESS.
	
	Nota Tcnica: Quan canvies de llista d'accs a sistema
	de llistes xOP, al teva definici de nivellls d'usuari ser
	canviada, aix que no tindras els mateixos valors si tornes a
	canviar a llista de accs!
	
	Tamb hauries de comprovar si els teus usuaris estan a la llista xOP
	corresponent desprs del canvi, ja que la deducci no s
	sempre perfecta... de fet, no es recomana el fer servir llistes
	xOP si vas canviar la definici de nivellls amb la comanda
	LEVELS.
	
	Canviar de llistes xOP al sistema de llistes d'accs no causa cap
	problema.

CHAN_HELP_SET_OPNOTICE
	Sintxi: SET canal OPNOTICE {ON | OFF}
	
	Habilita o deshabilita l'opci de op-notice per a un canal.
	Quan op-notice est establert, %S enviar una noticia
	a l'usuari del canal quan les comandes OP o DEOP siguin
	utilitzades per a un usuari en el canal.

CHAN_HELP_AOP
	Sintxi: AOP canal ADD nick
	          AOP canal DEL {nick | instancia | llista}
	          AOP canal LIST [mascara | llista]
	          AOP canal CLEAR
	
	Mant la llista OP (AutoOP) per a un canal. La llista
	AOP li dna a l'usuari el dret de ser automticament
	opejat en el teu canal, desbanejat o convidar-se a ell mateix en cas de
	ser necesri, mostrar el missatge de salutaci al entrar, etc.
	
	La comanda AOP ADD agrega al nickname donat a la llista
	AOP.
	
	La comanda AOP DEL esborra el nickname donat de la
	llista AOP. Si una llista de instncies s donada, aquestes
	instncies sn esborrades. (Veure l'exemple per a LIST ms
	endevant.)
	
	La comanda AOP LIST mostra la llista AOP. Si una
	mascara amb comod s donada, noms les instncies
	que concordin amb la mascara sn mostrades. Si una llista de
	instncies s donada, sols aquestes instncies sn mostrades;
	per exemple:
	
	   AOP #canal LIST 2-5,7-9
	      Mostra instncies de AOP enumerades 2 a 5 i
	      7 a 9.
	
	La comanda AOP CLEAR neteja totes les instncies de la
	llista AOP.
	
	Les comandes AOP ADD i AOP DEL est limitats a
	SOPs o superior, mentre que la comanda AOP CLEAR
	sols pot ser utilitzada per el fundador del canal. Tot i aix,
	qualsevol usuari a la llista AOP pot usar la comanda
	AOP LIST.
	
	Aquesta comanda pot haVeure sigut deshabilitada per al teu canal.
	Si aquest s el cas, has de fer servir la llista d'accs. Veure
	/msg %S HELP ACCESS per a informaci sobre la llista
	de accs i /msg %S HELP SET XOP per a saber com canviar
	entre la llista de accs i el sistema de llistes xOP.

CHAN_HELP_HOP
	Sintxi: HOP canal ADD nick
	          HOP canal DEL {nick | instancia | llista}
	          HOP canal LIST [mascara | llista]
	          HOP canal CLEAR
	
	Mant la llista HOP (HalfOP) per a un canal. La llista
	HOP li dna a l'usuari el dret de ser automticament
	halfopejat en el teu canal.
	
	La comanda HOP ADD agrega al nickname donat a la llista
	HOP.
	
	La comanda HOP DEL esborra el nickname donat de la
	llista HOP. Si una llista d'instncies s donada, aquestes
	instncies sn esborrades. (Veure l'exemple per a LIST ms
	endevant.)
	
	La comanda HOP LIST mostra la llista HOP. Si una
	mascara amb comod s donada, noms les instncies
	que concordin amb la mascara sn mostrades. Si una llista de
	instncies s donada, noms aquestes instncies sn mostrades;
	per exemple:
	
	   HOP #canal LIST 2-5,7-9
	      Mostra instncies de HOP enumerades 2 a 5 y
	      7 a 9.
	
	La comanda HOP CLEAR neteja totes les instncies de la
	llista HOP.
	
	Les comandes HOP ADD i HOP DEL estan limitades a
	AOPs o superior, mentre que la comanda HOP CLEAR
	sols pot ser utilitzada per el fundador del canal.
	
	Aquesta comanda pot haber estat deshabilitada per al teu canal.
	Si aquest s el cas, has de fer servir la llista d'accs. Veure
	/msg %S HELP ACCESS per a informaci sobre la llista
	d'accs i /msg %S HELP SET XOP per a saber com canviar
	entre la llista d'accs i el sistema de llistes xOP.

CHAN_HELP_SOP
	Sintxi: SOP canal ADD nick
	          SOP canal DEL {nick | instancia | llista}
	          SOP canal LIST [mascara | llista]
	          SOP canal CLEAR
	
	Mant la llista SOP (SuperOP) per a un canal. La llista
	SOP li dna a l'usuari els drets donats per la llista AOP,
	i agrega aquells necesaris per a utilitzar les llistes de
	AutoKick i BadWords, enviar i llegir memos de canal, etc.
	
	La comanda SOP ADD afegeix el nickname donat a la llista
	SOP.
	
	La comanda SOP DEL esborra el nickname donat de la
	llista SOP. Si una llista d'instncies s dada, aquestes
	instncies sn esborrades. (Veure l'exemple per a LIST ms
	endevant.)
	
	La comanda SOP LIST mostra la llista SOP. Si una
	mascara amb comod s donada, noms les instncies
	coincidents amb la mascara sn mostrades. Si una llista de
	instncies s donada, sols aquestes instncies sn mostrades;
	per exemple:
	
	   SOP #canal LIST 2-5,7-9
	      Mostra instncies de SOP enumerades 2 a 5 i
	      7 a 9.
	
	La comanda SOP CLEAR neteja totes les instncies de la
	llista SOP.
	
	Les comandes SOP ADD, SOP DEL i SOP CLEAR estan
	limitades al fundador del canal. Qualsecol usuari de la
	llista AOP pot fer servir la comanda SOP LIST.
	
	Aquesta comanda pot haber sigut deshabilitada per al teu canal.
	Si aquest s el cas, has de fer servir la llista d'accs. Veure
	/msg %S HELP ACCESS per a informaci sobre la llista
	d'accs i /msg %S HELP SET XOP per a saber com canviar
	entre la llista d'accs i el sistema de llistes xOP.

CHAN_HELP_VOP
	Sintxi: VOP canal ADD nick
	          VOP canal DEL {nick | instancia | llista}
	          VOP canal LIST [mascara | llista]
	          VOP canal CLEAR
	
	Mant la llista VOP (VOicePeople) per a un canal.
	La llista VOP li dona a l'usuari el dret de ser
	automticament donat veu o donar-se veu a si mateix.
	
	La comanda VOP ADD agrega el nickname donat a la llista
	VOP.
	
	La comanda VOP DEL esborra el nickname donat de la
	llista VOP. Si una llista de instncies s donada, aquestes
	instncies sn esborrades. (Veure l'exemple per a LIST ms
	endevant.)
	
	La comanda VOP LIST mostra la llista VOP. Si una
	mascara amb comod s donada, sols les instncies
	concordant amb la mascara sn mostrades. Si una llista de
	instncies s donada, sols aquetes instncies sn mostrades;
	per exemple:
	
	   VOP #canal LIST 2-5,7-9
	      mostra instncies de VOP enumerades 2 a 5 i
	      7 a 9.
	
	La comanda VOP CLEAR neteja totes les instncies de la
	llista VOP.
	
	Les comandes VOP ADD, VOP DEL i VOP LIST estan
	limitades a AOPs o superior, mentre que la comanda
	VOP CLEAR sols pot ser utilitzada per el fundador del
	canal.
	
	Aquesta comanda pot haber sigut deshabilitada per al teu canal.
	Si aquest s el cas, has de fer servir la llista de accs. Veure
	/msg %S HELP ACCESS per a informaci sobre la llista
	d'accs i /msg %S HELP SET XOP per a saber como canviar
	entre la llista d'accs i el sistema de llistes xOP.

CHAN_HELP_ACCESS
	Sintxi: ACCESS canal ADD nick nivell
	          ACCESS canal DEL {nick | indices | llista}
	          ACCESS canal LIST [mascara | llista]
	          ACCESS canal CLEAR
	
	Mant la llista d'accs per a un canal. La llista
	de accs especfica quins usuaris estan permesos a tenir
	l'estatus d'operador de canal o accs a comandes de
	%S en el canal.  Diferents nivellls d'usuaris permeten
	accs a diferents subnivelles de privilegis;
	/msg %S HELP ACCESS LEVELS per a informaci ms
	especfica. Qualsevol nick no present a la llista de
	accs t un nivelll 0.
	
	La comanda ACCESS ADD afegeix el nickname donat a la llista
	d'accs amb el nivelll d'usuari donat; si el nick ja est
	present a la llista, el nivelll d'accs s canviat al
	especificat en la comanda. El nivelll especificat
	ha de ser menys que el de l'usuari que fa la comanda, i si
	el nick ja est a la llista d'accs, l'accs actual
	del nick ha de ser menor que l'accs de l'usuari que fa la
	comanda.
	
	La comanda ACCESS DEL esborra el nick donat de la llista
	d'accs. Si una llista d'instncies s donada, aquestes instncies
	sn esborrades.  (Veure l'exemple per a LIST ms endevant.)
	
	La comanda ACCESS LIST mostra la llista d'accs. Si
	una mascara amb comod s donada, sols aquestes instncies
	concordant amb la mascara sn mostrades. Si una llista de
	instncies s donada, sols aquestes instncies sn mostrades; per
	exemple:

	   ACCESS #canal LIST 2-5,7-9
	      llista instncies d'accs numerades 2 fins 5 i
	      7 fins a 9.
	      
	La comanda ACCESS CLEAR neteja totes les instncies
	de la llista d'accs.

CHAN_HELP_ACCESS_LEVELS
	nivellls d'accs per a usuaris
	
	Per defecte, els segents nivellls d'accs estan definits:
	
	   Fundador   accs complet a les funcions de %S;
	                     Op automtico al entrar al canal. Notis
	                     que sols una persona pot tenir estatus
	                     de fundador (no pot ser donat fent servir la
	                     comanda ACCESS).
	        10   accs a la comanda AKICK; Op automtico.
	         5   Op automtico.
	         3   Voice automtico.
	         0   Cap privilegi especial; pot ser opejat
	                     per altres ops (a menys que seguretat de
	                     ops estigui establerta).
	        <0   No pot ser opejat.
	
	Aquests nivellls poden ser canviats, o afegir-ne de nous,
	fent servir la comanda LEVELS; escriu /msg %S HELP LEVELS
	per a ms informaci.

CHAN_HELP_AKICK
	Sintxi: AKICK canal ADD mascara [ra]
	          AKICK canal STICK mascara
	          AKICK canal UNSTICK mascara
	          AKICK canal DEL mascara
	          AKICK canal LIST [mascara]
	          AKICK canal VIEW [mascara]
	          AKICK canal ENFORCE
	          AKICK canal CLEAR
	
	Mant la llista d'AutoKicks per a un canal. Si
	un usuari de la llista de Autokicks intenta entrar
	al canal, %S banejar l'usuari del canal, desprs el
	kickejar.
	
	La comanda AKICK ADD afegeix el nick o mascara de
	usuari donat a la llista de Autokicks. Si una ra
	es donada amb la comanda, aquesta ra ser utilitzada quan 
	l'usuari sigui kickejat; si no, la ra per defecte s
	"Has sigut banejat del canal".
	
	La comanda AKICK STICK baneja permanent la mascara
	donada en el canal. Si alg intenta treure el ban,
	%S l'establir automticament. No pot ser
	usada per a nicks registrats.
	
	La comanda AKICK UNSTICK cancela l'efecto de la
	comanda AKICK STICK, aix que ser possible esborrar
	el ban del canal.
	
	La comanda AKICK DEL esborra el nick o mascara donats
	de la llista de AutoKicks. Tot i aix, no esborra cap ban
	posat per un AutoKick; aquells han de ser esborrats
	manualment.
	
	La comanda AKICK LIST mostra la llista de AutoKicks,
	o opcionalment sols les instncies de AutoKick 
	que concordin amb la mascara especificada.
	
	La comanda AKICK VIEW s una versi ms detallada
	de la comanda AKICK LIST.
	
	La comanda AKICK ENFORCE fa a %S a forar la
	llista AKICK actual esborrant als usuaris que
	concordin amb la mascara AKICK.
	
	La comanda AKICK CLEAR neteja totes les instncies
	de la llista de akicks.

CHAN_HELP_LEVELS
	Sintxi: LEVELS canal SET tipo nivell
	        LEVELS canal {DIS | DISABLE} tipo
	        LEVELS canal LIST
	        LEVELS canal RESET
	
	La comanda LEVELS permet un control fin sobre el
	significat dels nivellls d'accs numrics per a
	canals. Amb aquesta comanda, pots definir el nivelll d'accs
	requerit per a la majoria de les funcions de %S.
	(Les comandes SET FOUNDER i SET PASSWORD, aix com
	aquesta comanda estan sempre restringidws al fundador del
	canal.)
	
	LEVELS SET permet canviar el nivelll d'accs per a una funci
	o un grup de funcions. LEVELS DISABLE (o DIS abreviat)
	deshabilita una caracterstica automtica o prohibeix accs a una
	funci per a totss excepte el fundador del canal.
	LEVELS LIST mostra els nivellls actuals per a cada funci o
	grup de funcions. LEVELS RESET restableix els nivellls als 
	nivellls per defecte d'un canal acabat de crear (Veure
	HELP ACCESS LEVELS).
	
	Per a una llista de les caractersticas i funcions a les que
	se'ls pot canviar els nivellls, Veure HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	Els segents nombres de caracterstiques/funcions sn
	entesos. Cal tenir en compte que els nivellls per a AUTODEOP
	i NOJOIN sn nivellls mxims, mentre tots els altres
	sn nivellls mnims.

CHAN_HELP_LEVELS_DESC_FORMAT
	    %-*s  %s

CHAN_HELP_INFO
	Sintxi: INFO canal [ALL]
	
	llista informaci sobre el canal registrat donat,
	incloent el seu fundador, temps de registraci, ltim
	cop utilitzat, descripci i fixaci de Modes, si existeixen.
	Si ALL s especificat, el misatge d'entrada i
	sucsesor tamb seran mostrats.
	
	Per defecte, l'opci ALL est limitada a aquells
	amb accs de fundador en el canal.

CHAN_HELP_LIST
	Sintxi: LIST patr
	
	llista tots els canals registrats concordant amb el patr 
	donat (canals amb l'opci PRIVATE establerta no sn
	llistats.)

CHAN_HELP_OP
	Sintxi: OP [#canal [nick]]
	
	Opeja al nick seleccionat en un canal. Si un nick no s
	donat, t'opejar a tu. Si el canal i el nick no sn donats,
	te opejar en tots els canals en els que estiguis,
	sempre i quan tinguis els permisos per a fer-ho.
	
	Per defecte, limitat a AOPs o aquells amb nivelll d'
	accs 5 i major en el canal.

CHAN_HELP_DEOP
	Sintxi: DEOP [#canal [nick]]
	
	Desopeja al nick seleccionado en un canal. Si el nick no s
	donat, et desopejar a tu. Si el canal i el nick no sn donats,
	et desopejar a tu en tots els canals en els que estiguis,
	sempre i quan tinguis els permisos per a fer-ho.
	
	Per defecte, limitat a AOPs o aquells amb nivelll d'
	accs 5 i major en el canal.
	
CHAN_HELP_VOICE
	Sintxi: VOICE [#canal [nick]]
	
	Dna voice al nick seleccionat en un canal. Si el nick no
	s donat, et donar voice a ti. Si el canal i el nick no sn
	donats, et donar voice en tots els canals en els que
	estiguis, sempre i quan tinguis els permisos per a
	fer-ho.
	
	Per defecte, limitat AOPs o aquells amb nivelll d'
	accs 5 i major en el canal, o a VOPs o aquells
	amb nivelll 3 i major per a donar-se voice a si mateixos.

CHAN_HELP_DEVOICE
	Sintxi: DEVOICE [#canal [nick]]
	
	Treu voice al nick seleccionat en un canal. Si el nick no
	s donat, et treur voice a tu. Si el canal i el nick no sn
	donats, et treur voice en tots els canals en els que
	estiguis, sempre i quan tinguis els permisos per a fer-ho.
	
	Per defecte, limitat a AOPs o aquells amb nivelll d'
	accs 5 i major en el canal, o a VOPs o aquells amb
	nivelll 3 i major per a donar-se voice a si mateixos.
	
CHAN_HELP_HALFOP
	Sintxi: HALFOP [#canal [nick]]
	
	Dna Halfop al nick seleccionat en un canal. Si el nick no
	s donat, et donar halfop a tu. Si el canal i el nick no sn
	donats, et donar halfop en tots els canals en els que
	estiguis, sempre i quan tinguis els permisos per a fer-ho.
	
	Per defecte, limitat a AOPs i aquells amb nivelll d'
	accs 5 i major en el canal, o a HOPs o aquells amb nivelll
	4 i major per a donar-se halfop a si mateixos.

CHAN_HELP_DEHALFOP
	Sintxi: DEHALFOP [#canal [nick]]
	
	Treu Halfop al nick seleccionat en un canal. Si el nick no
	s donat, et treur halfop a tu. Si el canal i el nick no sn
	donats, et treur halfop en tots els canals en els que
	estiguis, sempre i quan tinguis els permisos per a fer-ho.
	
	Per defecte, limitat a AOPs i aquells amb nivelll d'
	accs 5 i major en el canal, o a HOPs o aquells amb
	nivelll 4 i major per a treure's halfop a si mateixos.

CHAN_HELP_PROTECT
	Sintxi: PROTECT [#canal [nick]]
	
	Protejeix al nick seleccionat en un canal. Si el nick no s
	donat, et protegir a tu. Si el canal i el nick no sn donats,
	et protejir en tots els canals en els que
	estiguis, sempre i quan tinguis els permisos per a fer-ho..
	
	Per defecte, limitat al fundador, o a SOPs o aquells
	amb nivell 10 i major en el canal per a protejerse a si
	mismos.

CHAN_HELP_DEPROTECT
	Sintxi: DEPROTECT [#canal [nick]]
	
	Desprotejeix al nick seleccionat en un canal. Si el nick no
	s donat, et desprotegir a tu. Si el canal i el nick no sn
	donats, et desprotegir en tots els canals en els que
	estiguis, sempre i quan tinguis els permisos per a fer-ho..
	
	Per defecte, limitat al fundador, o a SOPs o aquells
	amb nivelll 10 i major en el canal per a desprotegir-se a
	si mateixos.

CHAN_HELP_OWNER
	Sintxi: OWNER [#canal]
	
	Et dna l'estatus de propietari del canal. Si el canal no
	s donat, et donar estatus de propietari en tots els canals en els que
	estiguis, sempre i quan tinguis els permisos per a fer-ho.
	
	Limitad a aquells amb nivelll de fundador en el canal.

CHAN_HELP_DEOWNER
	Sintxi: DEOWNER [#canal]
	
	Esborra l'estatus de propietari del canal. Si el canal no
	s donat, esborra l'estatus de propietari en tots els canals en els que
	estiguis, sempre i quan tinguis els permisos per a fer-ho.
	
	Limitat a aquells amb nivelll de fundador en el canal.

CHAN_HELP_INVITE
	Sintxi: INVITE canal
	
	Li diu a %S que et convidi al canal donat.
	
	Per defecte, limitat a AOPs o aquells amb nivell 5
	i major en el canal.

CHAN_HELP_UNBAN
	Sintxi: UNBAN canal
	
	Li diu a %S que esborri tots els bans que no permeten que 
	entris al canal donat.
	
	Per defecte, limitat a AOPs o aquells amb nivell 5
	i major en el canal.

CHAN_HELP_KICK
	Sintxi: KICK [#canal [nick [ra]]]
	
	Kickeja al nick seleccionat en el canal. Si el nick no s
	donat, et kickejara a tu. Si el canal i el nick no sn donats,
	et kickejar en tots els canals en els que
	estiguis, sempre i quan tinguis els permisos per a fer-ho.
	
	Per defecte, limitat a AOPs o aquells amb nivell d'
	accs 5 i major en el canal.

CHAN_HELP_BAN
	Sintxi: BAN [#canal [nick [ra]]]
	
	Baneja un nick seleccionat en un canal. Si el nick no
	s donat, et banejar a ti. Si el canal i el nick no sn donats,
	et banejara en tots els canals en els que
	estiguis, sempre i quan tinguis els permisos per a fer-ho.
	
	Per defecte, limitat a AOPs o aquells amb nivell d'
	accs 5 i major en el canal.

CHAN_HELP_TOPIC
	Sintxi: TOPIC canal [topico]
	
	Fa a %S establir el topic del canal al especificat.
	Si el topic no s donat, un topic buit s establert.
	Aquesta comanda s ms util utilitzada en conjunt a SET
	TOPICLOCK. Veure /msg %S HELP SET TOPICLOCK
	per a ms informaci.
	
	Per defecte, limitat a aquells amb nivell de fundador
	en el canal.

CHAN_HELP_CLEAR
	Sintxi: CLEAR canal que
	
	Li diu a %S que netegi certs parmetres en el canal.
	que pot ser un dels segents:
	
	     MODES    Reestableix totss los Modes en el canal (o sigui,
	                  neteja els Modes i,k,l,m,n,p,s,t).
	     BANS     neteja tots els bans en el canal.
	     EXCEPTS  neteja tots els excepts en el canal.
	     OPS      Esborra estatus d'operador de canal(Mode +o)
	                  de tots els operadors de canal.
	     VOICES   Esborra l'estatus "voice" (Mode +v) de qui
	                  tingui aquest Mode establert.
	     USERS    Explusa (kickea) tots els usuaris del canal.
	
	Per defecte, el nivell d'accs en el canal ha de ser de
	fundador.

CHAN_HELP_GETKEY
	Sintxi: GETKEY canal
	
	Retorna la clau del canal donat. Aquesta s una comanda
	principalment per a ser utilitzada per bots i/o scripts,
	aix que el resultat s de la segent manera:
	
	KEY <canal> <key>
	
	key s "NO KEY" si no hi ha key establerta.
	
CHAN_HELP_SENDPASS
	Sintxi: SENDPASS canal
	
	Envia la clau del canal donat a l'adresa email establerta
	en l'arxiu del nickname del fundador. Aquesta comanda
	s sumament til per a recuperar claus perdudes.
	
	pot ser limitat a  Operadors de IRC en certas xarxes.
	
	Aquesta comanda no s disponible quan l'encriptaci est habilitada.

CHAN_SERVADMIN_HELP
	
	Les segents comandes estan disponibles per a administradors
	de serveis:
	
	    GETPASS    Retorna la clau de fundador per a un canal
	                   (sols si l'encriptaci esta deshabilitada)
	    FORBID     Evita que un canal es faci servir
	    STATUS     Retorna el nivell d'accs actual d'un
	                   usuari en un canal
	    CLIST      llista tots els canals en els que l'usuari
	               sigui fundador
	
	Administradors de serveis tamb poden eliminar un canal
	sense haver d'identificar-se per mitj d'una clau, i poden
	Veure l'accs, AKICK, i parmetres de les llistes de nivells per a
	qualsevol canal.

CHAN_SERVADMIN_HELP_LOGOUT
	Sintxi: LOGOUT canal [nickname]
	
	Aquesta comanda ha fa que el nick seleccionat no sigui identificat
	pel canal donat.
	
	Si tu ets el fundador del canal, pots desconectar a
	qui sigui, sin noms et pots desconectar a
	tu mateix.
	
	Si ets un administrador de serveis, pots
	desconectar a qui sigui d'un canal sense ser el fundador
	del canal. A ms, pots omitir el parmetro nickname;
	aix desconectara a tots els usuaris identificados
	del canal.

CHAN_SERVADMIN_HELP_DROP
	Sintxi: DROP canal
	
	Desregistra el canal donat.  Noms
	administradors de serveis poden eliminar un
	canal per el qual no s'haguin identificado.

CHAN_SERVADMIN_HELP_SET
	
	Administradors de serveis poden tambi establir la
	Opci NOEXPIRE, amb la qual s'evita que els canals
	expirin. A ms, administradors de
	serveis poden establir opcions per a qualsevol canal
	sense haver d'identificarse per clau en el canal.

CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	Sintxi: SET canal NOEXPIRE {ON | OFF}
	
	Estableix si el canal expirar. Establint-lo 
	a ON evita que el canal  expiri.
	
	limitat a administradors de serveis.

CHAN_SERVADMIN_HELP_INFO
	
	Administradors de serveis poden utilitzar el parmetre
	ALL amb qualsevol canal

CHAN_SERVADMIN_HELP_LIST
	Sintxi: LIST patr [FORBIDDEN] [NOEXPIRE]
	
	llista tots els canals registrats concordant amb el patr donat.
	canals amb l'opci PRIVATE establreta sols seran mostrats
	a administradors de serveis. canals amb l'opci NOEXPIRE
	tindran un ! davant del nom del canal per a
	administradors de serveis.
	
	Si les opcions FORBIDDEN o NOEXPIRE son donades, sols canals
	que, respectivament, tenen FORBID o NOEXPIRE establert seran
	mostrats. Si ambdues opcions sn donades, ambds tipus de canals
	seran mostrats. Aquestes opcions estan limitadas a
	administradors de serveis.

CHAN_SERVADMIN_HELP_GETPASS
	Sintxi: GETPASS canal
	
	Retorna la clau pel canal donat. tenir en compte
	que quan aquesta comanda es fa servir, un missatge incloent la
	persona que va executar la comanda i el canal en el que es va fer servir
	seran seguits i enviats com a WALLOPS/GLOBOPS.
	
	limitat a administradors de serveis.

CHAN_SERVADMIN_HELP_FORBID
	Sintxi: FORBID canal [ra]
	
	Prohibeix a qualsevol de registrar o usar el canal
	donat. pot ser cancelat eliminant el canal.
	
	Ra pot ser requerida en certas xarxes.
	
	limitat a administradors de serveis.

CHAN_SERVADMIN_HELP_SUSPEND
	Syntax: SUSPEND channel [reason]
	
	Disallows anyone from registering or using the given
	channel.  May be cancelled by using the UNSUSPEND
	command to preserve all previous channel data/settings.
	
	Reason may be required on certain networks.
	
	Limited to Services admins.

CHAN_SERVADMIN_HELP_UNSUSPEND
	Syntax: UNSUSPEND channel
	
	Releases a suspended channel. All data and settings
	are preserved from before the suspension.
	
	Limited to Services admins.

CHAN_SERVADMIN_HELP_STATUS
	Sintxi: STATUS canal nickname
	
	Retorna el nivell d'accs actual del nick donat
	en el canal donat. La resposta s de la forma:
	
	    STATUS canal nickname nivell-de-accs
	
	Si un error es dna, la resposta ser de la forma:
	
	    STATUS ERROR missatge-de-error
	
	limitat a administradors de serveis.

###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP
	%S s una utilitat que permet a usuaris de IRC
	enviar missatges curts a altres usuaris de IRC, estiguin
	en linea o no, o a canals(*). Ambds el nickname que
	envia i el nickname o canal destinataris han d'estar
	registrats per a enviar un memo.
	
	Les comandes de %S incloen:
	
	    SEND   Envia un memo a un nick o canal
	    CANCEL Cancela l'ltim memo enviat
	    LIST   llista els teus memos
	    READ   Llegeix un o ms memos
	    DEL    Esborra un o ms memos
	    SET    Estableix opcions relacionades a memos
	
MEMO_HELP_ADMIN
	    SENDALL  Send a memo to all registered users

MEMO_HELP_OPER
	    STAFF  Send a memo to all opers/admins

MEMO_HELP_FOOTER
	
	escriu /msg %S HELP comando per a ms ajuda en
	qualsevol de les comandes llistades anteriorment.
	
	(*) Per defecte, qualsevol usuari amb al menys nivell
	    d'accs 10 en un canal pot lleguir els memos del
	    canal. Aix pot ser canviat amb la comanda
	    LEVELS de %s.

MEMO_HELP_SEND
	Sintxi: SEND {nick | canal} text-del-memo
	
	Envia un memo al nick o canal donat, que cont
	text-del-memo. A l'enviar a un nickname, aquest
	rebr noticia de que ell/ella t un nou memo. El nick
	o canal receptors han d'estar registrats.

MEMO_HELP_CANCEL
	Sintxi: CANCEL {nick | canal}
	
	Cancela l'ultim memo enviat al nick o canal donat,
	sempre i quan no hagi sigut llegit al moment en el que
	vas fer servir la comanda.

MEMO_HELP_LIST
	Sintxi: LIST [canal] [llista | NEW]
	
	llista els memos que tens actualment. Amb NEW, llista
	noms els memos nous (no llegits). Memos nous estan
	marcats amb un "*" a l'esquerra del nobre del memo.
	Tamb pots especificar una llista de nombres, com en el
	exemple ms endevant:
	
	   LIST 2-5,7-9
	      llista memos enumerats 2 a 5 i 7 a 9.

MEMO_HELP_READ
	Sintxi: READ [canal] {nombre | llista | LAST | NEW}
	
	T'envia el text dels memos especificats. Si LAST s
	donat, t'envia l'ultim memo rebut. si NEW s donat, t'
	envia tots els teus memos nous. D'altra forma, t'envia el
	memo nombre nombre.  Tamb pots donar una llista de
	nombres, com en el exemple:
	
	   READ 2-5,7-9
	      mostra els memos enumerats 2 a 5 i 7 a 9.

MEMO_HELP_DEL
	Sintxi: DEL [canal] {nombre | llista | LAST | ALL}
	
	Esorra el o els memos especificats. pots donar multiples
	nombres o rangs de nombres en lloc d'un solo, com en el
	exemple.
	
	If LAST is given, the last memo will be deleted.
	Si ALL s donat, esborra tots els teus memos.
	
	exemples:
	
	   DEL 1
	      Esorra el teu primer memo.
	
	   DEL 2-5,7-9
	      Esborra els memos enumerats 2 a 5 i 7 a 9.

MEMO_HELP_SET
	Sintxi: SET Opci parmetros
	
	Estableix varies opcions de memos. Opci pot ser una de:
	
	    NOTIFY      Canvia quan sers notificat sobre de
	                    nous memos (sols per a nicknames)
	    LIMIT       Estableix el mxim nombre de memos que
	                    pots rebre
	
	escriu /msg %S HELP SET Opci per a ms informaci
	sobre una opci especfica.

MEMO_HELP_SET_NOTIFY
	Sintxi: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	Canvia quan se't notificar de nous memos:
	
	    ON      Notificaci de memos quan et conectis,
	               quan treguis  /AWAY, i quan 
	                s'enviin
	    LOGON   Sols seras notificat de memos quan et conectis
	               o quan treguis /AWAY.
	    NEW     Sols seras notificat de memos quan se't 
	               enviin.
	    OFF     No rebrs cap notificaci per memos.
	
	ON s escencialment LOGON i NEW combinats.

MEMO_HELP_SET_LIMIT
	Sintxi: SET LIMIT [canal] lmit
	
	Estableix el mxim nombre de memos que tu (o el canal donat)
	pots  tenir. Si queda a 0, ning podr
	enviar-te memos. A ms, no pots establir el lmit ms
	alt que %d.

MEMO_HELP_INFO
	Sintxi: INFO [canal]
	
	mostra informaci del nombre de memos que tens,
	quants d'ells encar no han sigut llegits, i quants memos
	pots rebre. Amb un parmetre, mostra la mateixa
	informaci pel canal donat.

MEMO_SERVADMIN_HELP_SET_LIMIT
	Sintxi: SET LIMIT [usuari | canal] {lmit | NONE} [HARD]
	
	Estableix el mxim nombre de memos un usuari o canal est
	perms. Establir el lmit a 0 evita a l'usuari
	de rebre memos; posar-lo a NONE permet a l'usuari
	de rebre i guardar els memos que vulgui. Si no dones un
	nickname o canal, el teu propi lmit est establert.
	
	Afegir HARD evita al usuari de canviar el lmit. No
	afegir HARD t l'efect contrari, permetent a l'
	usuari canviar el lmit (encara que un lmit previ hagui sigut establert
	amb HARD).
	
	L'us de la comanda SET LIMIT est limitat a
	administradors de serveis. altres usuaris poden
	noms establir lmits per a ells mateixos o per a un canal en
	el que tinguin certos privilegos, no podenn esborrar el seu
	lmit, no poden establir el lmit ms enll de %d, i no
	poden establir un lmit hard.

MEMO_SERVADMIN_HELP_INFO
	Sintxi: INFO [nick | canal]
	
	Sense un parmetro, mostra informaci del nombre
	de memos que tens, quants d' ells encara no  s'han
	llegit, i el nombre total de memos que pots rebre.
	
	amb un canal de parmetre, mostra la mateixa informaci
	pel canal donat.
	
	amb un nickname de parmetr, mostra la misma
	informaci pel nickname donat. Aquest us est
	limitat a administradors de serveis.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_STAFF
	Syntax: STAFF memo-text

	Sends all services staff a memo containing memo-text.
	Note: If you have opers on both the oper list and the
	admin list they will recive the memo twice.  The same
	applies for oper's on the Root list as well as other
	lists.

###########################################################################
#
# OperServ help messages
#
###########################################################################

MEMO_HELP_SENDALL
	Syntax: SENDALL memo-text

	Sends all registered users a memo containing memo-text.

###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP
	Comandes per a %S:
	    GLOBAL      Envia un missatge a totss els usuaris
	    STATS       mostra estatus dels serveis i la xarxa
	    OPER LIST   Llista tots els operadors de serveis
	    ADMIN LIST  Llista tots els administradors de
	                serveis

OPER_HELP_OPER_CMD
	Comandes disponibles sols per a operadors i administradors
	de serveis:
	    MODE        Canvia els Modes d'un canal
	    KICK        Kickeja un usuari d'un canal
	    CLEARMODES  neteja els Modes d'un canal
	    KILLCLONES  Mata tots els usuaris en un host
	    AKILL       Manipula la llista AKILL
	    SGLINE      Manipula la llista SGLINE
	    SQLINE      Manipula la llista SQLINE
	    SZLINE      Manipula la llista SZLINE

OPER_HELP_ADMIN_CMD
	Comandes disponibles noms a administradors de serveis:
	    OPER        Modifica la llista d'operadors de serveis
	    CHANLIST    Llista tots els records de canal
	    USERLIST    Llista tots els records d'usuaris
	    LOGONNEWS   Defineix missatges per a ser mostrats a usuaris
	                al conectarse
	    RANDOMNEWS  Defineix missatges per a ser mostrats a usuaris
	                al conectarse
	    OPERNEWS    Defineix missatges per a ser mostrats a usuaris
	                al transformar-se en operadors
	    SESSION     Mostra la llista de sessions de host
	    EXCEPTION   Modifica la llista de lmit de sessi
	    CACHE       Llista cau de hostnames utilitzats pel detector
	                de proxys
	    NOOP        Temporalment elimina totes les linees O:
	                d'un servidor remotamente
	    JUPE        "Jupiter" (Mart,Saturn....) un servidor
	    SET         Estableix varies opcions globals dels serveis
	    RELOAD      Recarrega la configuraci dels serveis
	    UPDATE      Fora a la base de dades dels serveis a
	                ser actualitzada a disc inmediatament
	    QUIT        Termina el programa de serveis sense grabar les dades
	    RESTART     Guarda la base de dades dels serveis i
	                reinicia els serveis
	    QUIT        Termina el programa de serveis sense guardar
	                els canvis
	    SHUTDOWN    Termina el programa de serveis guardant els
	                canvios
	
	Comandes disponibles noms pel super-usuari de serveis:
	    ADMIN       Modifica la llista d'administradors de
	                serveis

OPER_HELP_ROOT_CMD
	Commands available to Serivces Roots only:
	    MODLOAD     Load a module
	    MODUNLOAD   Un-Load a module
	    MODLIST     List loaded modules
	    MODINFO     Info about a loaded module

OPER_HELP_LOGGED
	Noticia: Totes les comandes enviades a %S son monitorejades!

OPER_HELP_GLOBAL
	Sintxi: GLOBAL missatge
	
	Permet als IRCops a enviar missatges als usuaris de
	la xarxa. El missatge sera enviat desde el nick %s.

OPER_HELP_STATS
	Sintxi: STATS [AKILL | ALL | RESET]
	
	Sense una opci, mostra el nom actual d'usuaris i
	IRCops en linea (excluient els serveis), el mxim
	nombre d'usuaris desde que els serveis s'han iniciat, i
	el temps que els serveis han estat funcionant.
	
	Amb L'opci AKILL, mostra la mida actual de la
	llista AKILL i l'actual temps d'expiraci per defecte.
	
	L'opci ALL esta sols disponible per administradors de
	serveis, i mostra informaci en el us de memria dels
	serveis. Utilitzar aquesta opci pot congelar els
	serveis per un curt periode de temps en xarxes grans,
	aixi que no es recomana utilitzar sovint.
	
	L'opci RESET estableix el nombre mxim d'usuaris
	al nombre d'usuaris actualment presents en la xarxa.
	
	UPTIME pot ser utilitzat com a sinnim per STATS.

OPER_HELP_OPER
	Sintxi: OPER ADD nick
	          OPER DEL {nick | nom | llista}
	          OPER LIST [mascara | llista]
	          OPER CLEAR
	
	Permet als administradors de serveis afegir o
	eliminar nicknames a la llista d'operadors de
	serveis. Un usuari amb el seu nickname a la llista
	d'operadors de serveis i que ha estat identificat
	amb %s podra accedir a comandes d'operador de
	serveis.
	
	La comanda OPER ADD afegeix el nickname donat a la
	llista d'operadors de serveis.
	
	La comanda OPER DEL elimina el nickname donat de
	la llista d'operadors de serveis. Si una llista de
	instncies es especificada, aquestes instncies son esborrades.
	(Veure l'exemple per a LIST especificat ms endavant.)
	
	La comanda OPER LIST mostra la llista
	d'operadors de serveis. Si s'especifica una mascara, noms
	les instncies que concordin amb la mascara sn
	mostrades. Si s'especifica una llista de noms es , noms aquestes
	instncies son mostrades; per exemple:
	
	   OPER LIST 2-5,7-9
	      Llista instncies d'operadors de serveis
	      enumerades de 2 a 5 i de 7 a 9.
	
	La comanda OPER CLEAR neteja totes les instncies
	de la llista d'operadors de serveis.
	
	Qualsevol operador d'IRC pot utilitzar la forma
	OPER LIST de la comanda. Tots les altres utilitats estan
	limitats als administradors de serveis.

OPER_HELP_ADMIN
	Sintxi: ADMIN ADD nick
	          ADMIN DEL {nick | nom | llista}
	          ADMIN LIST [mascara | llista]
	          ADMIN CLEAR
	
	Permet al root de serveis afegir o eliminar nicknames
	a la llista d'administradors de serveis. Un usuari
	el nickname del qual estigui a la llista d'administradors de
	serveis i que ha estat identificat amb %s podra
	accedir a comandes d'administradors de serveis.
	
	La comanda ADMIN ADD afegeix el nickname especificat a la llista
	d'administradors de serveis.
	
	La comanda ADMIN DEL elimina el nickname especificat de la
	llista d'administradors de serveis. Si una llista
	d'instncies es especificada, aquestes instncies son esborrades.
	(Veure l'exemple per LIST que s'especifica ms endavant.)
	
	La comanda ADMIN LIST mostra la llista
	d'administradors de serveis. Si s'especifica una mascara, noms
	les instncies que concordin amb la mascara sn mostrades;
	per exemple:
	
	   ADMIN LIST 2-5,7-9
	      Llista instncies de la llista d'administradors de
	      serveis enumerades de 2 a 5 i de 7 a 9.
	
	La comanda ADMIN CLEAR neteja totes les instncies de
	la llista d'administradors de serveis.
	
	Qualsevol operador d'IRC pot utilitzar la forma ADMIN LIST
	de la comanda. Tots les altres utilitats estan limitades al
	root de serveis.

OPER_HELP_IGNORE
	Syntax: IGNORE {ADD|DEL|LIST} [time] [nick]

	Allows Services Admins to make Services ignore an user for
	a certain time or until the next restart. The default time
	format is seconds. You can specify it by using units. Valid
	units are: s for seconds, m for minutes, h for hours and
	d for days. Combinations of these units are not permitted. To 
	make Services permanently ignore the user type 0 as time.

OPER_HELP_MODE
	Sintxi: MODE canal Modes
	
	Permet als operadors de serveis establir modes de canal
	per a qualsevol canal. Els parametres son els mateixos que per la
	comando estandart /MODE.
	
	Limitat a operadors de serveis.

OPER_HELP_UMODE
	Syntax: UMODE user modes
	
	Allows Services admins to set user modes for any user.
	Parameters are the same as for the standard /MODE
	command.
	
	Limited to Services admins.

OPER_HELP_OLINE
	Syntax: OLINE user flags
	
	Allows Services admins to give Operflags to any user.
	Flags have to be prefixed with a "+" or a "-". To
	remove all flags simply type a "-" instead of any flags.

	Limited to Services admins.

OPER_HELP_CLEARMODES
	Sintxi: CLEARMODES canal [ALL]
	
	Neteja tots els modes binarios (i,k,l,m,n,p,s,t) i
	bans del canal. Si s'especifica ALL, tambe neteja
	tots els ops i voices (modes +o i +v) del canal.
	
	Limitat a operadors de serveis.

OPER_HELP_KICK
	Sintxi: KICK canal usuari ra
	
	Permet als IRCops kickejar un usuari de qualsevol
	canal. Els parametres son els mateixos que per la comanda
	/KICK. El missatge de kick tindra el nickname del IRCop
	que envia la comanda KICK; per exemple:
	
	*** SpamMan ha estat kickejat del canal #aujac per %S (cistus (Flood))
	
	Limitat a operadors de serveis.

OPER_HELP_SVSNICK
	Syntax: SVSNICK nick newnick
	
	Forcefully changes a user's nickname from nick to newnick.
	
	Limited to Services admins

OPER_HELP_AKILL
	Sintxi: AKILL ADD [+expiraci] mascara ra
	          AKILL DEL {mascara | nom | llista}
	          AKILL LIST [mascara | llista]
	          AKILL VIEW [mascara | llista]
	          AKILL CLEAR
	
	Permet als operadors de serveis manipular la llista de
	AKILLS. Si un usuari coincideix amb una mascara en la
	llista de AKILLS i s'esta intentant connectar, els serveis enviaran
	un KILL a aquest usuari i, en tipus de servidors soportats,
	notificara a tots els servidors que afegeixin un ban (linea K)
	per la mascara de l'usuari.
	
	AKILL ADD afegeix la mascara usuari@host especificada a la llista
	de AKILLS per la ra especificada (que HA DE SER especificada).
	expiraci es especificada com un sencer seguit de
	 d (dies), h (hores), o m (minuts). Combinacions (com
	1h30m) no estan permesses. Si un especificador d'unitats no
	es incls, per defecte seran dies (o sigui +30 noms
	significa 30 dies).  Per afegir un AKILL que no caduqui, utilitza +0.
	Si la mascara a afegir comena amb un +, s'ha d'especificar
	un temps d'expiraci. El temps d'expiraci per defecte actual de AKILLS
	pot ser consultat amb la comanda STATS AKILL.
	
	La comanda AKILL DEL esborra la mascara especificada de la llista
	d'AKILLS si esta present. Si s'especifica una llista de noms,
	aquestes instncies son esborrades.  (Veure l'exemple per LIST 
	especificat ms endavant.)
	
	La comanda AKILL LIST mostra la llista d'AKILLS.  
	Si s'especifica una mascara, noms les instncies coincidents
	amb la mascara sn mostrades. Si s'especifica una llista de noms,
	noms aquestes instncies son mostrades; per exemple:
	
	   AKILL LIST 2-5,7-9
	      Llista les instncies de AKILL enumerades de 2 a 5 i de 7 
	      a 9.
	      
	AKILL VIEW es una versi ms verbal d'AKILL LIST, i 
	mostrara qui va afegir un AKILL, la data en que va ser afegit,
	i quan caducara, aix com tambe la mascara usuari@host
	i la ra.
	
	AKILL CLEAR neteja totes les instncies de la llista d'AKILLS.
	
	Limitat a operadors de serveis.
	
OPER_HELP_SGLINE
	Sintxi: SGLINE ADD [+expiraci] mascara:ra
	         SGLINE DEL {mascara | nom | llista}
	         SGLINE LIST [mascara | llista]
	         SGLINE VIEW [mascara | llista]
	         SGLINE CLEAR
	
	Permet als operadors de serveis manipular la llista
	de SGLINES. Si un usuari amb un nom real concordant
	amb una mascara SGLINE s'intenta connectar, els serveis
	l'impediran aconseguir una sessi d'IRC.
	
	SGLINE ADD afegeix la mascara de nom real especificada a la
	llista de SGLINES per la ra especificada (obligatori). 
	expiraci es especificada com un sencer
	seguit de d (dies), h (hores), o m
	(minuts).  Combinacions (com 1h30m) no estan
	permesses. Si l'especificaci de la unitat no es
	especificada, per defecte sn dies (s a dir +30 noms
	significa 30 dies). Per afegir una SGLINE que no caduqui,
	utilitza +0. Si la mascara de nom real especificada comena amb
	+, el temp d'expiraci ha de ser especificat, encara que sigui
	el mateix que el per defecte. El temps actual d'expiraci
	per defecte per SGLINES pot ser consultat amb la comanda
	STATS AKILL.
	Nota: Ja que la mascara de nom real pot contenir
	espais, el separador entre aquest i la ra es un signe de
	dos punts.
	
	La comanda SGLINE DEL esborra la mascara especificada de la
	llista de SGLINES si esta present. Si s'especifica una llista de
	instncies, aquestes instncies son esborrades. (Veure 
	l'exemple per LIST especificat ms endavant.)
	
	La comanda SGLINE LIST mostra la llista de SGLINES. Si
	s'especifica una mascara, noms les instncies concordant amb
	la mascara sn mostrades. Si s'especifica una llista de instncies,
	noms aquestes instncies son mostrades; per exemple:
	
	   SGLINE LIST 2-5,7-9
	      Llista instncies de SGLINES enumerades de 2 a 5 i de 7 
	      a 9.
	      
	SGLINE VIEW es una versi ms verbal que SGLINE LIST,
	i mostrara qui va fegir la SGLINE, la data en la que va
	ser afegida, i quan caducara, a ms de la mascara de nom real
	i la ra.
	
	SGLINE CLEAR neteja totes les instncies de la llista de
	SGLINES.
	
	Limitat a operadors de serveis.

OPER_HELP_SQLINE
	Sintxi: SQLINE ADD [+expiraci] mascara ra
	         SQLINE DEL {mascara | nom | llista}
	         SQLINE LIST [mascara | llista]
	         SQLINE VIEW [mascara | llista]
	         SQLINE CLEAR
	
	Permet als operadors de serveis manipular la llista
	de SQLINES. Si un usuari amb un nick concordant amb una
	mascara SQLINE s'intenta connectar, els serveis li
	impediran aconseguir una sessi d'IRC.
	
	Si el primer carcter de la mascara es #, els serveis
	evitaran l's dels canals coincidents (a IRCds
	que ho soportin).
	
	SQLINE ADD afegeix la mascara de nom real especificada a la
	llista de SQLINES per la ra especificada (que s'ha d'especficar). 
	expiraci es especificada como un sencer
	seguit de d (dies), h (hores), o m
	(minuts).  Combinacions (com 1h30m) no estan
	permesses. Si l'especificaci de la unitat no es
	especificada, per defecte sn dies (s a dir +30 noms
	significa 30 dies). Per afegir una SQLINE que no caduqui,
	utilitzar +0. Si la mascara de nom real especificada comena amb
	+, el temps d'expiraci ha de ser especificat, encara que sigui
	el mateix que el per defecte. El temps actual d'expiraci
	per defecte per SQLINES pot ser consultat amb la comanda
	STATS AKILL.
	
	La comanda SQLINE DEL esborra la mascara especificada de la
	llista de SQLINES si esta present. Si s'especifica una llista de
	instncies, aquestes instncies son esborrades. (Veure
	l'exemple per LIST especificat ms endavant.)
	
	La comanda SQLINE LIST mostra la llista de SQLINES. Si
	s'especifica una mascara, noms les instncies coincidents amb
	la mascara son mostrades. Si s'especifica una llista de instncies,
	sols esas instncies son mostrades; per exemple:
	
	   SQLINE LIST 2-5,7-9
	      llista instncies de SQLINES enumerades de 2 a 5 i de 7
	      a 9.
	
	SQLINE VIEW es una versi ms verbal que SQLINE LIST,
	i mostrara qui va afegir la SQLINE, la data en la que va
	ser afegida, i quan caducara, a ms de la mascara de nom real
	i la ra.
	
	SQLINE CLEAR neteja totes les instncies de la llista de
	SQLINES.
	
	Limitat a operadors de serveis.

OPER_HELP_SZLINE
	Sintxi: SZLINE ADD [+expiraci] mascara ra
	          SZLINE DEL {mascara | nom | llista}
	          SZLINE LIST [mascara | llista]
	          SZLINE VIEW [mascara | llista]
	          SZLINE CLEAR
	
	Permet als operadors de serveis manipular la
	llista de SZLINES. Si un usuari amb una IP concordant
	amb una mascara de la llista de SZLINES intenta connectar-se,
	els serveis le impediran obtenir una sessi d'IRC
	(s a dir, si la IP te un PTR RR o no).
	
	SZLINE ADD afegeix la mascara IP especificada a la llista de
	SZLINES per la ra especificada (que s'ha d'especificar).
	expiraci es especificada com un sencer seguit
	de d (dias), h (hores), o m (minuts).
	Combinacions (com 1h30m) no estan permesses. Si
	una especificaci d'unitat no es especificada, per
	defecte es dies (s a dir, +30 significa
	30 dies). Per afegir una SZLINE que no caduqui, utilitzar
	+0. Si la mascara a afegir comena amb un
	+, el temps d'expiraci ha de ser especificat, encara
	que sigui el mateix que el per defecte. El temps actual
	d'expiraci per defecte per SZLINES pot ser
	consultat amb la comanda STATS AKILL.
	
	La comanda SZLINE DEL esborra la mascara especificada de la
	llista de SZLINES si esta present. Si s'especifica una llista de
	instncies, aquestes instncies son esborrades. (Veure
	l'exemple per LIST especificat ms endavant.)
	
	La comanda SZLINE LIST mostra la llista de SZLINES.  
	Si s'especifica una mascara, noms aquellas instncies
	coincidents amb la mascara sn mostrades. Si s'especifica una llista
	de instncies, noms aquestes instncies sn mostrades;
	per exemple:
	
	   SZLINE LIST 2-5,7-9
	      Llista instncies SZLINE enumerades de 2 a 5 i de 7 
	      a 9.
	      
	SZLINE VIEW es una versi ms verbal de SZLINE LIST,
	i mostrara qui va afegir una SZLINE, la data en la que
	va ser afegida, i quan caducara, a ms de la mascara IP i
	la ra.
	
	SZLINE CLEAR neteja totes les instncies de la llista
	de SZLINES.
	
	Limitat a operadors de serveis.

OPER_HELP_SET
	Sintxi: SET opci parametres
	
	Estableix varies opcions globals de serveis.
	Noms de opcions actualment definides sn:
	    READONLY   Estableix Mode noms lectura o noms escritura
	    LOGCHAN    Report log messages to a channel
	    DEBUG      Activa o desactiva el Mode debug
	    NOEXPIRE   Activa o desactiva el Mode no expire
	
	Limitat a administradors de serveis.

OPER_HELP_SET_READONLY
	Sintxi: SET READONLY {ON | OFF}
	
	Estableix el mode noms lectura a activat o desactivat. En mode
	noms lectura, els usuaris normals no podran modificar dades
	de serveis, incloent accs a llistes de canals i
	nicknames, etc. IRCops amb suficients privilegis amb
	els serveis podren modificar la llista AKILL de
	serveis i eliminar o prohibir nicknames i canals, per
	cap d'aquests canvios sera guardat excepte que el
	mode noms lectura es desactivi abans de que els serveis
	siguin desactivats o reiniciats.
	
	Aquesta opci es equivalent a l'opci -readonly en
	la linea de comandes.

OPER_HELP_SET_LOGCHAN
	Syntax: SET LOGCHAN {ON | OFF}

	With this setting on, Services will send its logs to a specified
	channel as well as the log file. LogChannel must also be defined
	in the Services configuration file for this setting to be of any
	use.

	Note: This can have strong security implications if your log
	channel is not properly secured.

OPER_HELP_SET_DEBUG
	Sintxi: SET DEBUG {ON | OFF | nom}
	
	Estableix el mode debug a activat o desactivat. En mode debug,
	tota la informaci enviada desde i cap als serveis,
	a ms de un numero de missatges sn escrits a l'arxiu
	de log.  Si s'especifica nom, el mode debug es
	activat, amb el nivell de debug especificat a nom.
	
	Aquesta opci es equivalent a l'opci -debug en
	la linea de comandes.

OPER_HELP_SET_NOEXPIRE
	Sintxi: SET NOEXPIRE {ON | OFF}
	
	Estableix el mode no expire a activat o desactivat. En
	mode no expire, nicks, canals, akills i excepcions
	no caducaran fins que l'opci sigui desactivada.
	
	Aquaquesta opci es equivalent a l'opci -noexpire
	en la linea de comandes.

OPER_HELP_SET_SUPERADMIN
	Syntax: SET SUPERADMIN {ON | OFF}

	Setting this will grant you extra privlages such as the
	ability to be "founder" on all channel's etc...

	This opion is _NOT_ persistant, and should only be used when
	needed, and set back to OFF when no longer needed.


OPER_HELP_NOOP
	Sintxi: NOOP SET servidor
	          NOOP REVOKE servidor
	
	NOOP SET esborra totes les linees O: del
	servidor especificat i killeja a tots els IRCops actuals
	per a prevenir-los de fer rehash en el servidor
	(ja que aix cancel.laria l'efecte).
	
	NOOP REVOKE fa que les linees 0: disponibles novament
	en el servidor especificat.
	
	Nota: El servidor no es testejat pels
	serveis.
	
	Limitat a administradors de serveis.

OPER_HELP_JUPE
	Sintxi: JUPE servidor [ra]
	
	Li diu als serveis que fagin jupiter (saturn, mart,...) a un servidor
	-- s a dir, crear un "servidor" fals conectant als
	serveis el qual preveu al servidor real de
	connectar-se. El jupe pot ser eliminat utilitzant la comanda
	estandart SQUIT. Si una ra es especificada, es afegida
	en el camp d'informaci sobre el servidor; d'altra
	banda, el camp de informaci sobre el servidor tindra
	el text "Juped per <nick>", mostrant el nickname
	de la persona que va jupitejar el servidor.
	
	Limitat a administradors de serveis.

OPER_HELP_RAW
	Sintxi: RAW text
	
	Envia una linea de text directament al servidor al qual
	els serveis estan connectats. Aquesta comanda te un
	us molt limitat i pot malmetre una xarxa si es
	utilitzat de manera imprpia. NO UTILITZIS aquesta COMANDA a
	no ser que estiguis absolutament seguro del que fas!
	    
	Limitat a administradors de serveis.

OPER_HELP_UPDATE
	Sintxi: UPDATE
	
	Fora als serveis a actualitzar tots els arxius de
	la base de dades tan aviat como enviis la comanda.
	
	Limitat a administradors de serveis.

OPER_HELP_RELOAD
	Sintxi: RELOAD
	
	Fora als serveis a recarregar l'arxiu de
	configuraci. Tenir en compe que algunes directives
	necessiten que els serveis es reinicin de nou per tenir
	efecte (tal com nicknames dels serveis, activaci
	de la limitaci de sessions, etc.)
	
	Limitat a administradors de serveis.

OPER_HELP_QUIT
	Sintxi: QUIT
	
	Fora als serveis a parar inmediatament; les bases de
	dades no son guardades. Aquesta comanda no ha de ser utilitzada
	excepte que les cpies en la memria semblin espatllades i no
	hagin de ser guardades. Per parar normalment, utilitza la comanda
	SHUTDOWN.
	
	Limitat a administradors de serveis.

OPER_HELP_SHUTDOWN
	Sintxi: SHUTDOWN
	
	Fora als serveis a guardar totes les bases de
	datos i parar.
	
	Limitat a administradors de serveis.

OPER_HELP_RESTART
	Sintxi: RESTART
	
	Fora als serveis a guardar totes les bases de
	dades i desprs parar i arrancar de nou.
	(es a dir, finalitzar el programa e inmediatament reiniciar
	el programa de nou).
	
	Limitat a administradors de serveis.

OPER_HELP_KILLCLONES
	Sintxi: KILLCLONES nick
	
	Killeja tots els usuaris amb el mateix host a nick.
	Un AKILL temporal, de la forma *@host, es afegit
	per prevenir al client ofensor de reconnectar-se
	inmediatament. Un wallops es tambe enviat indicant
	qui utilitza la comanda, quin host fou afectat i quants
	usuaris van ser killejats. Aquesta comanda s til per
	eliminar multiples clons de la xarxa.
	
	Limitat a operadors de serveis.

OPER_HELP_CHANLIST
	Sintxi: CHANLIST [{patr | nick} [SECRET]]
	
	Llista tots els canals actualment en s en la xarxa IRC,
	estiguin registrats o no.
	
	Si s'especifica patr, llista noms els canals que concordin amb ell. 
	Si s'especifica un nickname, llista noms els canals en els que l'usuari
	hi sigui. Si s'especifica SECRET, llista noms els canals que
	concordin amb patr i que tinguin modes +s o +p.
	
	Limitat a administradors de serveis.

OPER_HELP_USERLIST
	Sintxi: USERLIST [{patr | canal} [INVISIBLE]]
	
	Llista tots els usuaris actualment en linea en la xarxa IRC,
	estiguin registrats o no.
	
	Si s'especifica patr, llista noms els usuaris que concordin
	amb ell (ha de ser amb el format nick!usuari@host). Si s'especifica canal,
	llista noms els  usuaris que estiguin en el canal donat. Si s'especifica
	INVISIBLE, noms els usuaris amb la bandera +i seran
	llistats.
	
	Limitat a administradors de serveis.

OPER_HELP_CACHE
	Sintxi: CACHE DEL hostname
	          CACHE LIST patr [QUEUED | ALL]
	
	La comanda CACHE DEL esborra el host especificat del cau.
	Aix noms esta indicat per a propsits de debug.
	
	La comanda CACHE LIST llista tots els proxies trobats que
	concordin amb el patr especificat. Si s'especifica l'opci QUEUED,
	llistara tots els processos encuats o en progres, i si s'especifica
	l'opci ALL, llistara tots els hostnames a cau.
	
	Limitat a administradors de serveis.

###########################################################################
#
# BotServ help messages
#
###########################################################################
	
OPER_HELP_MODLOAD
	Syntax: MODLOAD FileName

	This command loads the module named FileName from the modules
	directory.

	Limited to Services Roots.

OPER_HELP_MODUNLOAD
	Syntax: MODUNLOAD FileName

	This command unloads the module named FileName from the modules
	directory.

	Limited to Services Roots.

OPER_HELP_MODINFO
	Syntax: MODINFO FileName

	This command lists information about the specified loaded module

	Limited to Services Roots.

OPER_HELP_MODLIST
	Syntax: MODLIST

	Lists all currently loaded modules.

	Limited to Services Roots.


###########################################################################
#
# BotServ help messages
#
###########################################################################
	
BOT_HELP
	%S et permet crear un bot en el teu propi canal.
	Aix ha estat creat per a usuaris que no poden
	tenir un bot en un host o configurar un bot, o per a us en xarxes
	que no permeten bots d'usuaris. Comandes
	disponibles estan llistades ms endavant; per a
	utilitzar-los, escriu /msg %S comanda. per a ms
	informaci sobre un comanda especifica, escriu  
	/msg %S HELP comanda.
	
	BOTLIST            Llista bots disponibles
	ASSIGN             Assigna un bot a un canal
	SET                Configura opcions de bots
	KICK               Configura kickers
	BADWORDS           Mant una llista de paraules malsonants
	
	Altres comandos: ACT INFO SAY UNASSIGN
	
	El bot entrara a un canal quan hi hagin
	%d usuari(s) en ell.
	
BOT_HELP_BOTLIST
	Sintxi: BOTLIST
	
	Llista tots els bots disponibles en aquesta xarxa.
	
BOT_HELP_ASSIGN
	Sintxi: ASSIGN canal nick
	
	Assigna un bot especificat per nick al canal.
	Desprs d'aix pots configurar el bot segons
	les teves necessitats.

BOT_HELP_UNASSIGN
	Sintxi: UNASSIGN canal
	
	Desassigna un bot d'un canal. A l'utilitzar aquesta comanda
	el bot ja no entrara al canal. De totes maneres, la configuraci
	del bot pel canal es enmagatzemada, aix et sera possible
	reassignar un bot sense haver de configurar-lo de nou.

BOT_HELP_INFO
	Sintxi: INFO {canal | nick}
	
	Permet veure la informaci de %S sobre un canal o
	bot. Si el parametre es un canal, rebrs informaci
	aix como kickers activats. Si el parametre es un nick,
	rebrs informaci sobre el bot, aix com temps
	de creaci o nom de canals en els que aquest estigui.

BOT_HELP_SET
	Sintxi: SET canal opci parametres
	
	Configura opcions de bot.  Opci pot ser uno de:
	
	    DONTKICKOPS      Per a protegir ops contra kicks de bots
	    DONTKICKVOICES   Per a protegir voices contra kicks de bots
	    GREET            Habilita missatges de benvinguda
	    FANTASY          Habilita comandoe de fantasia
	    SYMBIOSIS        Permet al bot a actuar como un bot real
	
	Escriu /msg %S HELP SET opci per ms informaci
	sobre una opci especifica.
	
	Nota: L'accs a aquesta comanda esta controlat pel
	nivell SET.
	
BOT_HELP_SET_DONTKICKOPS
	Sintxi: SET canal DONTKICKOPS {ON|OFF}
	
	Habilita o deshabilita el mode de protecci d'ops
	en un canal. En habilitar-lo, ops no seran
	kickejats pel bot, encara que no concideixen amb
	el nivell NOKICK.

BOT_HELP_SET_DONTKICKVOICES
	Sintxi: SET canal DONTKICKVOICES {ON|OFF}
	
	Habilita o deshabilita el mode de protecci de voices
	en un canal. En hbilitarlo, voices no seran
	kickejatos pel bot, encara que no coincideixin amb
	el nivell NOKICK.

BOT_HELP_SET_FANTASY
	Sintxi: SET canal FANTASY {ON|OFF}
	
	Habilita o deshabilita el mode de fantasia
	en un canal. En habilitar-lo, els usuaris podran
	utilitzar les comandes !op, !deop, !voice, !devoice,
	!kick, !kb, !unban, !seen en un canal (investiga
	com utilitzar-los; intenta amb o sense nick per cadasc
	i amb ra per a alguns?).
	
	Cal dir que els usuaris que desitgin utilitzar comandes
	de fantasia HAN DE DISPOSSAR del nivell necessari
	pel nivell FANTASIA i altres depenent
	de la comanda si es requereix (per exemple, per a
	utilitzar !op, l'usuari ha de tenir suficient
	accs pel nivell OPDEOP).

BOT_HELP_SET_GREET
	Sintxi: SET canal GREET {ON|OFF}
	
	Habilita o deshabilita el mode de asludo en
	un canal. En habilitar-lo, el bot mostrara els
	missatges dels usuaris que entrin al canal,
	sempre i quan tinguin el suficient accs
	al canal.

BOT_HELP_SET_SYMBIOSIS
	Sintxi: SET canal SYMBIOSIS {ON|OFF}
	
	Habilita o dehsabilita el mode simbiosis en
	un canal. En habilitar-lo, el bot fara qualsevol
	cosa que normalmente hauria fet %s en els
	canals, tal como modes, KICKS i fins tot els
	missatges d'entrada.

BOT_HELP_KICK
	Sintxi: KICK canal opci parametres
	
	Configura els kickers de bot. opci pot ser una de:
	
	    BOLDS         Estableix si el bot kickejara negretes
	    BADWORDS      Estableix si el bot kickejara paraules malsonants
	    CAPS          Estableix si el bot kickejara majuscules
	    COLORS        Estableix si el bot kickea colors
	    FLOOD         Estableix si el bot kickejara usuaris
	                  que floodejan
	    REPEAT        Estableix si el bot kickejara usuaris
	                  que repeteixen com l'allioli
	    REVERSES      Estableix si el bot kickejara reversos
	    UNDERLINES    Estableix si el bot kickejara subratllats
	
	Escriu /msg %S HELP KICK Opci per ms
	informaci sobre una opci especifica.
	
	Nota: L'accs a aquesta comanda es control.lat pel
	nivell SET.

BOT_HELP_KICK_BOLDS
	Sintxi: KICK canal BOLDS {ON|OFF} [ttb]

	Estableix el kick per negretes a actvitat o desactivat.
	En habilitar-lo, aquesta opci li diu al bot que kickegi
	usuaris que utilitzin negretes.
	
	ttb es el numero de cops que un usuari sera kickejat
	abans de ser banejat. No cal especificar ttb per a deshabilitar
	el sistema de ban un cop activat.

BOT_HELP_KICK_COLORS
	Sintxi: KICK canal COLORS {ON|OFF} [ttb]
	
	Estableix el kick per colors a activat o desactivat.
	En habilitar-lo, aquesta opci li diu al bot que kickegi
	usuaris que utilitzin colors.
	
	ttb es el numero de cops que un usuari sera kickejat
	abans de ser banejat. No cal especificar ttb per a deshabilitar
	el sistema de ban un cop activat.

BOT_HELP_KICK_REVERSES
	Sintxi: KICK canal REVERSES {ON|OFF} [ttb]
	
	Estableix el kick per reversos a activat o desactivat.
	En habilitar-lo, aquesta opci li diu al bot que kickegi
	usuaris que utilitzin reversos.
	
	ttb es el numero de cops que un usuari sera kickejat
	abans de ser banejat. No cal especificar ttb per a deshabilitar
	el sistema de ban un cop activat.

BOT_HELP_KICK_UNDERLINES
	Sintxi: KICK canal UNDERLINES {ON|OFF} [ttb]
	
	Estableix el kick per subratllats a activat o apagat.
	En habilitar-lo, aquesta opci li diu al bot que kickegi
	usuaris que utilitzin subratllats.
	
	ttb es el numero de cops que un usuari sera kickejat
	abans de ser banejat. No cal especificar ttb per a deshabilitar
	el sistema de ban un cop activat.

BOT_HELP_KICK_CAPS
	Sintxi: KICK canal CAPS {ON|OFF} [ttb [min [porcentaje]]]

	Estableix el kick per mayusculas a activat o desactivat.
	En habilitar-lo, aquesta opci le diu al bot que kickegi
	usuaris que estiguin escrivint en majuscules.
	
	El bot kickeja noms si hi ha com a mnim min majuscules
	i que constitueixin com a mnim porcentatge%% del total
	del text (si no s'especifica, per defecte s'estableix a 10
	carcters i 25%%).
	
	ttb es el numero de cops que un usuari sera kickejat
	abans de ser banejat. No cal especificar ttb per a deshabilitar
	el sistema de ban un cop activat.

BOT_HELP_KICK_FLOOD
	Sintxi: KICK canal FLOOD {ON|OFF} [ttb [ln [segs]]]

	Estableix el kick per flood a activat o desactivat.
	En habilitar-lo, aquesta opci li diu al bot que kickegi
	usuaris que estiguin floodejant el canal utilitzant com a mnim
	ln linees en segs segons (si no s'especifica, per
	defecte es establert a 6 linees en 10 segons).
	
	ttb es el numero de cops que un usuari sera kickejat
	abans de ser banejat. No cal especificar ttb per a deshabilitar
	el sistema de ban un cop activat.

BOT_HELP_KICK_REPEAT
	Sintxi: KICK #canal REPEAT {ON|OFF} [ttb [num]]
	
	Estableix el kick per repetici a activat o desactivat.
	En habilitar-lo, aquesta opci li diu al bot que kickegi
	usuaris que estiguin repetint num cops (si num no s'especifica,
	per defecte es establert a 3).
	
	ttb es el numero de cops que un usuari sera kickejat
	abans de ser banejat. No cal especificar ttb per a deshabilitar
	el sistema de ban un cop activat.

BOT_HELP_KICK_BADWORDS
	Sintxi: KICK #canal BADWORDS {ON|OFF} [ttb]
	
	Estableix el kick per paraules malsonants a activat o desactivat.
	En habilitar-lo, aquesta opci li diu al bot que kickegi
	usuaris que utilitzin certes paraules al canal.
	
	Pots definir paraules malsonants pel teu canal utilitzant la comanda
	BADWORDS. Escriu /msg %S HELP BADWORDS per ms informaci.
	
	ttb es el numero de cops que un usuari sera kickejat
	abans de ser banejat. No cal especificar ttb per a deshabilitar
	el sistema de ban un cop activat.

BOT_HELP_BADWORDS
	Sintxi: BADWORDS canal ADD paraula [SINGLE | START | END]
	          BADWORDS canal DEL {paraula | nom | llista}
	          BADWORDS canal LIST [mascara | llista]
	          BADWORDS canal CLEAR
	
	Mante la llista de paraules malsonants per un canal. La llista
	de paraules malsonants determina quines paraules han de donar peu a ser kickejats
	Quan el kick per paraules malsonants esta habilitat. Per ms
	informaci, escriu /msg %S HELP KICK BADWORDS.
	
	La comanda BADWORDS ADD afegeix una paraula a la llista
	de paraules malsonants. Si s'especifica SINGLE, el kick es
	fara noms si l'usuari du la paraula completa. Si s'especifica
	START, el kick es fara noms si l'usuari
	escriu una paraula que comenci amb paraula.
	Si no s'especifica END, el kick es fara noms si
	l'usuari escriu una paraula que finalitzi amb paraula. Si
	no s'especifica res, un kick es far cada vegada que
	paraula sigui escrita per un usuari.
	
	La comanda BADWORDS DEL esborra la paraula esmantada de la
	llista de paraules malsonants. Si s'especifica una llista de noms, aquestes
	instncies son esborrades. (Veure l'exemple per LIST especificat ms
	endavant).
	
	La comanda BADWORDS LIST mostra la llista de bad
	words. Si s'especifica una mascara, noms les instncies
	concordant amb la mascara sn mostrades. Si s'especifica una llista
	de noms, noms aquestes instncies son mostrades;
	per exemple:
	
	   BADWORDS #canal LIST 2-5,7-9
	      Llista paraules malsonants enumerades de 2 a 5 i de 7 a 9.
	      
	La comanda BADWORDS CLEAR neteja totes les instncies
	de la llista de paraules malsonants.

BOT_HELP_SAY
	Sintxi: SAY canal text
	
	Fa que el bot escrigui el text especificat en el canal especificat.

BOT_HELP_ACT
	Sintxi: ACT canal text
	
	Fa que el bot fagi l'equivalent a la comanda "/me"
	en el canal especificat utilitzant el text especificat.

BOT_SERVADMIN_HELP
	
	La segent comanda est disponible per administradors
	de serveis:
	
	    BOT              Mant la llista de bots de la xarxa

BOT_SERVADMIN_HELP_BOT
	Sintaxi: BOT ADD nick usuari host real
	          BOT CHANGE nick-ant nick-nue [usuari [host [real]]]
	          BOT DEL nick
	          BOT LIST
	
	Permet als administradors de serveis crear, modificar
	i esborrar bots que usuaris podran usar en els seus propis
	canals.
	
	BOT ADD afegeix un bot con el nickname, usuari, host
	i nombre reial donats. Ja que no es fan comprovacions 
	d'integritat per aquests parametres, tingues molta cura.
	BOT CHANGE permet cambiar el nickname, usuari, host
	o nom real d'un bot sense tenir que esborrar-lo (i la
	informaci associada a ell).
	BOT DEL esborra el bot donat de la llista de bots.
	BOT LIST es un lies de BOTLIST i noms llista
	tots els bots disponibles en la xarxa.
	
	Nota: Si fas un bot amb un nick ja enregistrat,
	sera eliminat. A ms, si un usuari est actualment
	usant el nick, ser killejat.

BOT_SERVADMIN_HELP_SET
	
	Aquestes opcions estan reservades a administradors de
	Serveis:
	
	    NOBOT            Evita a un bot de ser assignat
	                        a un canal
	    PRIVATE          Evita a un bot de ser assignat
	                     per alg mes que un operador
	                     d'IRC

BOT_SERVADMIN_HELP_SET_NOBOT

	Sintaxi: SET canal NOBOT {ON|OFF}
	
	Aquesta opci fa al canal no sigui assignable. Si un
	bot ja est assignat al canal, es desassignara
	automticament quan habiliteu aquesta opci.
	
	Limitat a administradors de serveis.

BOT_SERVADMIN_HELP_SET_PRIVATE
	Sintaxi: SET nick-del-bot PRIVATE {ON|OFF}
	
	Aquesta opci evita un bot de ser assignat
	a un canal per usuaris que no son operadors
	d'IRC.
	
	Limitat a administradors de serveis.
HOST_EMPTY
	The vhost list is empty.
HOST_ENTRY
	#%d Nick:%s, vhost:%s (%s - %s)
HOST_IDENT_ENTRY
	#%d Nick:%s, vhost:%s@%s (%s - %s)
HOST_SET
	vhost for %s set to %s.
HOST_IDENT_SET
	vhost for %s set to %s@%s.
HOST_SETALL
	vhost for group %s set to %s.
HOST_DELALL
	vhosts for group %s have been removed.
HOST_DELALL_SYNTAX
	Syntax: DELALL <nick>.
HOST_IDENT_SETALL
	vhost for group %s set to %s@%s.
HOST_SET_ERROR
	Error! A vhost can only contain A-Z, a-z, 0-9, '.' and '-'.
HOST_SET_IDENT_ERROR
	A vhost ident must be in the format of a valid ident
HOST_SET_TOOLONG
	Error! The vhost is too long, please use a host shorter than %d characters.
HOST_SET_IDENTTOOLONG
	Error! The Ident is too long, please use an ident shorter than %d characters.
HOST_NOREG
	User %s not found in the nickserv db.
HOST_SET_SYNTAX
	Syntax /msg %s set <nick> <hostmask>.
HOST_SETALL_SYNTAX
	Syntax /msg %s setall <nick> <hostmask>.
HOST_DENIED
	Access Denied.
HOST_NOT_ASSIGNED
	Please contact an Operator to get a vhost assigned to this nick.
HOST_ACTIVATED
	Your vhost of %s is now activated.
HOST_IDENT_ACTIVATED
	Your vhost of %s@%s is now activated.
HOST_ID
	Please identify to services first.
HOST_NOT_REGED
	You need to register before a vhost can be assigned to you.
HOST_DEL
	vhost for %s removed.
HOST_DEL_SYNTAX
	Syntax: /msg %s del <nick>.

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_OFF_UNREAL
	Your vhost was removed. To re-enable the standard host cloaking, type /mode %s +x
HOST_NO_VIDENT
	Your IRCD does not support vIdent's, if this is incorrect, please report this as a possible bug

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_GROUP
	All vhost's in the group %s have been set to %s
HOST_IDENT_GROUP
	All vhost's in the group %s have been set to %s@%s

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_LIST_FOOTER
	Displayed all records (Count: %d)
HOST_LIST_RANGE_FOOTER
	Displayed records from %d to %d
HOST_LIST_KEY_FOOTER
	Displayed records matching key %s (Count: %d)

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_HELP
	%S commands:
	    ON          Activates your assigned vhost
	    OFF         Deactivates your assigned vhost

HOST_OPER_HELP
	Commands available to services operators only:
	    SET         Set the vhost of another user
	    SETALL      Set the vhost for all nicks in a group
	    DEL         Delete the vhost of another user
	    LIST        Displays one or more vhost entries.

HOST_ADMIN_HELP
	Commands available to services admins only:

HOST_HELP_ON
	Syntax: ON

	Activates the vhost currently assigned to the nick in use.
	When you use this command any user who performs a /whois
	on you will see the vhost instead of your real IP address.

HOST_HELP_SET
	Syntax: SET <nick> <hostmask>.

	Sets the vhost for the given nick to that of the given
	hostmask.  If your IRCD supports vIdents, then using
	SET <nick> <ident>@<hostmask> set idents for users as 
	well as vhosts.

	Limited to Services operators.

HOST_HELP_DELALL
	Syntax: DELALL <nick>.

	Deletes the vhost for all nick's in the same group as
	that of the given nick.

	Limited to Host Removers.


HOST_HELP_SETALL
	Syntax: SETALL <nick> <hostmask>.

	Sets the vhost for all nicks in the same group as that
	of the given nick.  If your IRCD supports vIdents, then
	using SETALL <nick> <ident>@<hostmask> will set idents
	for users as well as vhosts.

	* NOTE, this will not update the vhost for any nick's
	added to the group after this command was used.

	Limited to Services operators.

HOST_HELP_OFF
	Syntax: OFF

	Deactivates the vhost currently assigned to the nick in use.
	When you use this command any user who performs a /whois
	on you will see your real IP address.

HOST_HELP_DEL
	Syntax: DEL <nick>

	Deletes the vhost assigned to the given nick from the
	database.

	Limited to Services operators.

HOST_HELP_LIST
	Syntax: LIST [<key>|<#X-Y>]

	This command lists registered vhosts to the operator
	if a Key is specified, only entries whos nick or vhost match
	the pattern given in <key> are displayed e.g. Rob* for all
	entries beginning with "Rob"

	If a #X-Y style is used, only entries between the range of X
	and Y will be displayed, e.g. #1-3 will display the first 3
	nick/vhost entries.

	The list uses the value of NSListMax as a hard limit for the
	number of items to display to a operator at any 1 time.

	Limited to Services operators.

HOST_HELP_GROUP
	Syntax: GROUP
	
	This command allows users to set the vhost of thier
	CURRENT nick to be the vhost for all nicks in the same
	group.
