# Russian language file for Anope 1.5.10.
# 
# (C) 2003 Anope Team
# Contact us at info@anope.org
#
# Please read COPYING and README for furhter details.
#
# Based on the original code of Epona by Lara.
# Based on the original code of Services by Andy Church.
#
# Translated by Oleg Nikolaev aka Isot <isot@complife.ru>
# - Special thanks to Mishgan and Leeho for testing
#
# Translated: 7.12.2003
# Charaster set is cp1251
#
# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, let me know
# (achurch@dragonfire.net) which message is causing a problem and I'll see
# what I can do.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# config.h).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.

###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	 (Russian)

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%b %d %H:%M:%S %Y %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %b %d %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%b %d %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	
	
	
	
	
	
	
# %A
STRFTIME_DAYS_LONG
	
	
	
	
	
	
	
# %b
STRFTIME_MONTHS_SHORT
	
	
	
	
	
	
	
	
	
	
	
	
# %B
STRFTIME_MONTHS_LONG
	
	
	
	
	
	
	
	
	
	
	
	


# This is used in ChanServ/NickServ INFO displays.
COMMA_SPACE
	, 


# Various error messages.
USER_RECORD_NOT_FOUND
	  -   .
UNKNOWN_COMMAND
	  %s.
UNKNOWN_COMMAND_HELP
	  %s. "/msg %s HELP"     .
SYNTAX_ERROR
	: %s
MORE_INFO
	/msg %s HELP %s    .
NO_HELP_AVAILABLE
	   %s.
OBSOLETE_COMMAND
	  ;    %s.

BAD_USERHOST_MASK
	     user@host.
BAD_EXPIRY_TIME
	  .
USERHOST_MASK_TOO_WIDE
	 %s  ;   .

SERVICE_OFFLINE
	%s   .
READ_ONLY_MODE
	:      -;    !
PASSWORD_INCORRECT
	 .

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	 .
PERMISSION_DENIED
	   .
RAW_DISABLED
	 RAW .     ,   DisableRaw    .

MORE_OBSCURE_PASSWORD
	      .        5 ,      ,      (..     ),       .
PASSWORD_TRUNCATED
	:       %d .

NICK_NOT_REGISTERED
	   .
NICK_NOT_REGISTERED_HELP
	   .   /msg %s HELP     ,   .
NICK_X_NOT_REGISTERED
	 %s  .
NICK_X_IN_USE
	 %s  .
NICK_X_NOT_IN_USE
	 %s     .
NICK_X_NOT_ON_CHAN
	%s        %s.
NICK_X_FORBIDDEN
	 %s      .
NICK_X_FORBIDDEN_OPER
	 %s     %s:
	%s
NICK_X_ILLEGAL
	 %s       .
NICK_X_TRUNCATED
	 %s    %d .
CHAN_X_NOT_REGISTERED
	 %s  .
CHAN_X_NOT_IN_USE
	 %s  .
CHAN_X_FORBIDDEN
	 %s      .
CHAN_X_FORBIDDEN_OPER
	 %s    %s:
	%s
CHAN_X_SUSPENDED
	      : [%s] %s
NICK_IDENTIFY_REQUIRED
	      .    , 
	   /msg %s IDENTIFY password.
CHAN_IDENTIFY_REQUIRED
	      .    ,
	   /msg %s IDENTIFY %s password.
	
MAIL_DISABLED
	     .
MAIL_INVALID
	   %s .
MAIL_X_INVALID
	%s     email.
MAIL_LATER
	   email; , , .
MAIL_DELAYED
	  %d   .
	
NO_REASON
	 
UNKNOWN
	<>

# Duration system
DURATION_DAY
	1 
DURATION_DAYS
	%d 
DURATION_HOUR
	1 
DURATION_HOURS
	%d 
DURATION_MINUTE
	1 
DURATION_MINUTES
	%d 
DURATION_SECOND
	1 
DURATION_SECONDS
	%d 
	
# Human readable expiration
NO_EXPIRE
	  
EXPIRES_SOON
	     
EXPIRES_M
	  %d 
EXPIRES_1M
	  %d 
EXPIRES_HM
	  %d , %d 
EXPIRES_H1M
	  %d , %d 
EXPIRES_1HM
	  %d , %d 
EXPIRES_1H1M
	  %d  %d 
EXPIRES_D
	  %d 
EXPIRES_1D
	  %d 

# Generic Footer message
END_OF_ANY_LIST
	  %s.

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	    . , ,  .
	(   ,   /msg %s IDENTIFY password.)
NICK_IS_SECURE
	    .     , 
	 /msg %s IDENTIFY password.    ,
	, ,  .
NICK_MAY_NOT_BE_USED
	     .    .
FORCENICKCHANGE_IN_1_MINUTE
	     ,        .
FORCENICKCHANGE_IN_20_SECONDS
	     ,        20 .
FORCENICKCHANGE_NOW
	   ;     .
FORCENICKCHANGE_CHANGING
	     %s

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER password [email]
NICK_REGISTER_SYNTAX_EMAIL
	REGISTER password email
NICK_REGISTRATION_DISABLED
	,    .
NICK_REGISTRATION_FAILED
	,  .
NICK_REG_PLEASE_WAIT
	  %d      REGISTER.
NICK_CANNOT_BE_REGISTERED
	 %s    .
NICK_ALREADY_REGISTERED
	 %s  !
NICK_REGISTERED
	 %s     : %s
NICK_PASSWORD_IS
	  - %s -       .

# GROUP responses
NICK_GROUP_SYNTAX
	GROUP target password
NICK_GROUP_DISABLED
	,    .
NICK_GROUP_FAILED
	,   .
NICK_GROUP_PLEASE_WAIT
	  %d      GROUP.
NICK_GROUP_CHANGE_DISABLED
	   ;     /msg %s DROP.
NICK_GROUP_SAME
	     %s.
NICK_GROUP_TOO_MANY
	     %s's ;     .
	 /msg %s HELP GLIST  /msg %s HELP DROP 
	   .
NICK_GROUP_JOINED
	     %s.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY password
NICK_IDENTIFY_FAILED
	,    .
NICK_IDENTIFY_SUCCEEDED
	  -     .
NICK_IDENTIFY_EMAIL_REQUIRED
	     e-mail.  e-mail      ,
	   .
NICK_IDENTIFY_EMAIL_HOWTO
	  /msg %S SET EMAIL e-mail   e-mail.   ;
	 e-mail      .
NICK_ALREADY_IDENTIFIED
	  .

# UPDATE responses
NICK_UPDATE_SUCCESS
	  (,  ,   , ).
	
# LOGOUT responses
NICK_LOGOUT_SYNTAX
	LOGOUT
NICK_LOGOUT_SUCCEEDED
	  .
NICK_LOGOUT_X_SUCCEEDED
	 %s  .
NICK_LOGOUT_SERVICESADMIN
	  %s,     .

# DROP responses
NICK_DROP_DISABLED
	,      .
NICK_DROPPED
	      .
NICK_X_DROPPED
	 %s     .

# SET responses
NICK_SET_SYNTAX
	SET option parameters
NICK_SET_SERVADMIN_SYNTAX
	SET [nick] option parameters
NICK_SET_DISABLED
	,     .
NICK_SET_UNKNOWN_OPTION
	 SET  %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	 SET  %s,    .
NICK_SET_OPTION_DISABLED
	 %s       IRC .

# SET DISPLAY responses
NICK_SET_DISPLAY_INVALID
	  ,         !
NICK_SET_DISPLAY_CHANGED
	     %s.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	,   .
NICK_SET_PASSWORD_CHANGED
	 .
NICK_SET_PASSWORD_CHANGED_TO
	   %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE 
NICK_SET_LANGUAGE_UNKNOWN
	   %d.   /msg %s HELP SET LANGUAGE     .
NICK_SET_LANGUAGE_CHANGED
	   .

# SET URL responses
NICK_SET_URL_CHANGED
	URL   %s.
NICK_SET_URL_UNSET
	URL .

# SET EMAIL responses
NICK_SET_EMAIL_CHANGED
	 E-mail   %s.
NICK_SET_EMAIL_UNSET
	 E-mail .
NICK_SET_EMAIL_UNSET_IMPOSSIBLE
	     email   IRC .
	
# SET ICQ responses
NICK_SET_ICQ_CHANGED
	 ICQ : %s.
NICK_SET_ICQ_UNSET
	 ICQ .
NICK_SET_ICQ_INVALID
	%s    .
	
# SET GREET responses
NICK_SET_GREET_CHANGED
	    %s.
NICK_SET_GREET_UNSET
	  .

# SET PROTECT responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	   : .
NICK_SET_KILL_QUICK
	   : ,   .
NICK_SET_KILL_IMMED
	   : ,  .
NICK_SET_KILL_IMMED_DISABLED
	 IMMED    IRC .
NICK_SET_KILL_OFF
	   : .

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	: .
NICK_SET_SECURE_OFF
	: .

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	: .
NICK_SET_PRIVATE_OFF
	: .

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	  email     %s INFO.
NICK_SET_HIDE_EMAIL_OFF
	  email     %s INFO.
NICK_SET_HIDE_MASK_ON
	    user@host     %s INFO.
NICK_SET_HIDE_MASK_OFF
	    user@host     %s INFO.
NICK_SET_HIDE_QUIT_ON
	         %s INFO.
NICK_SET_HIDE_QUIT_OFF
	         %s INFO.
	
# SET MSG responses
NICK_SET_MSG_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_MSG_ON
	      .
NICK_SET_MSG_OFF
	      .

# SET NOEXPIRE responses
NICK_SET_NOEXPIRE_SYNTAX
	SET [nickname] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	 %s   .
NICK_SET_NOEXPIRE_OFF
	 %s  .

# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [mask]
NICK_ACCESS_ALREADY_PRESENT
	 %s      .
NICK_ACCESS_REACHED_LIMIT
	,     %d    .
NICK_ACCESS_ADDED
	%s     .
NICK_ACCESS_NOT_FOUND
	%s      .
NICK_ACCESS_DELETED
	%s    .
NICK_ACCESS_LIST
	 :
NICK_ACCESS_LIST_X
	   %s:

# INFO responses
NICK_INFO_SYNTAX
	INFO nick [ALL]
NICK_INFO_REALNAME
	%s  %s
NICK_INFO_SERVICES_OPER
	%s  .
NICK_INFO_SERVICES_ADMIN
	%s  .
NICK_INFO_ADDRESS
	 :                 %s
NICK_INFO_ADDRESS_ONLINE
	   c :       %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s   .
NICK_INFO_TIME_REGGED
	:                 %s
NICK_INFO_LAST_SEEN
	  :           %s
NICK_INFO_LAST_QUIT
	   :  %s
NICK_INFO_URL
	URL:                             %s
NICK_INFO_EMAIL
	 E-mail:                    %s
NICK_INFO_VHOST
	 :                %s
NICK_INFO_ICQ
	ICQ #:                           %d
NICK_INFO_GREET
	 :           %s
NICK_INFO_OPTIONS
	:                       %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	
NICK_INFO_OPT_SECURE
	
NICK_INFO_OPT_PRIVATE
	
NICK_INFO_OPT_MSG
	  
NICK_INFO_OPT_NONE
	
NICK_INFO_NO_EXPIRE
	    .
NICK_INFO_FOR_MORE
	      /msg %s INFO %s ALL.

# LIST responses
NICK_LIST_SYNTAX
	LIST 
NICK_LIST_SERVADMIN_SYNTAX
	LIST  [FORBIDDEN] [NOEXPIRE] [UNCONFIRMED]
NICK_LIST_HEADER
	,  %s:
NICK_LIST_RESULTS
	  - %d/%d .

# ALIST responses
NICK_ALIST_SYNTAX
	ALIST 
NICK_ALIST_HEADER
	,       :
	                
NICK_ALIST_HEADER_X
	,    %s   :
	                
NICK_ALIST_XOP_FORMAT
	  %3d %c%-20s %-8s %s
NICK_ALIST_ACCESS_FORMAT
	  %3d %c%-20s %-8d %s
NICK_ALIST_FOOTER
	  - %d/%d  .

# GLIST responses
NICK_GLIST_HEADER
	    :
NICK_GLIST_HEADER_X
	    %s:
NICK_GLIST_FOOTER
	%d   .

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER  []
NICK_NO_RECOVER_SELF
	     !
NICK_RECOVERED
	      .  /msg %s RELEASE %s
	  ,     .

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE  []
NICK_RELEASE_NOT_HELD
	 %s   .
NICK_RELEASED
	     .

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST  []
NICK_NO_GHOST_SELF
	     !
NICK_GHOST_KILLED
	    .

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS nickname
NICK_GETPASS_UNAVAILABLE
	 GETPASS     .
NICK_GETPASS_PASSWORD_IS
	 %s - %s.

# GETEMAIL responses
NICK_GETEMAIL_SYNTAX
	GETEMAIL user@email-host     !!
NICK_GETEMAIL_EMAILS_ARE
	Email'   %s: %s.
NICK_GETEMAIL_NOT_USED
	 Email'  %s.

# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS 
NICK_SENDPASS_UNAVAILABLE
	 SENDPASS     .
NICK_SENDPASS_SUBJECT
	   (%s)
NICK_SENDPASS_HEAD
	Hi,
NICK_SENDPASS_LINE_1
	  %s       e-mail.
NICK_SENDPASS_LINE_2
	  %s.   ,      .
NICK_SENDPASS_LINE_3
	     ,   .
NICK_SENDPASS_LINE_4
	     !
NICK_SENDPASS_LINE_5
	 %s.
NICK_SENDPASS_OK
	 %s  .

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID  []
NICK_FORBID_SYNTAX_REASON
	FORBID  
NICK_FORBID_SUCCEEDED
	 %s   .
NICK_FORBID_FAILED
	    %s!

# Nick Registraion responses
NICK_REQUESTED
	    ,    e-mail    
NICK_REG_RESENT
	      %s.
NICK_REG_UNABLE
	  , , , .
NICK_IS_PREREG
	     e-mail   .
NICK_ENTER_REG_CODE
	    %s,    /msg %s confirm <>   
NICK_CONFIRM_NOT_FOUND
	    ,    "/msg %s register <> <email>" .
NICK_CONFIRM_INVALID
	   ,    e-mail ,    
NICK_REG_MAIL_SUBJECT
	  (%s)
NICK_REG_MAIL_HEAD
	Hi,
NICK_REG_MAIL_LINE_1
	      %s.
NICK_REG_MAIL_LINE_2
	   " /msg %s confirm %s "   .
NICK_REG_MAIL_LINE_3
	     ,   .
NICK_REG_MAIL_LINE_4
	     !
NICK_REG_MAIL_LINE_5
	 %s.
NICK_GETPASS_PASSCODE_IS
	 %s - %s.
NICK_FORCE_REG
	 %s  



###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	    
CHAN_LEVEL_AUTOVOICE
	   +v
CHAN_LEVEL_AUTOHALFOP
	   +h
CHAN_LEVEL_AUTOPROTECT
	   +a
CHAN_LEVEL_AUTODEOP
	   
CHAN_LEVEL_NOJOIN
	   :  
CHAN_LEVEL_INVITE
	   INVITE
CHAN_LEVEL_AKICK
	   AKICK
CHAN_LEVEL_SET
	   SET ( FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	   CLEAR
CHAN_LEVEL_UNBAN
	   UNBAN
CHAN_LEVEL_OPDEOP
	   OP/DEOP
CHAN_LEVEL_ACCESS_LIST
	   
CHAN_LEVEL_ACCESS_CHANGE
	   
CHAN_LEVEL_MEMO
	    
CHAN_LEVEL_ASSIGN
	 / 
CHAN_LEVEL_BADWORDS
	   BADWORDS
CHAN_LEVEL_NOKICK
	    
CHAN_LEVEL_FANTASIA
	  fantaisist  BotServ'a
CHAN_LEVEL_SAY
	   SAY  ACT
CHAN_LEVEL_GREET
	  
CHAN_LEVEL_VOICEME
	   (de)voice  
CHAN_LEVEL_VOICE
	   VOICE/DEVOICE
CHAN_LEVEL_GETKEY
	   GETKEY
CHAN_LEVEL_OPDEOPME
	   OP/DEOP  
CHAN_LEVEL_HALFOPME
	   HALFOP/DEHALFOP  
CHAN_LEVEL_HALFOP
	   HALFOP/DEHALFOP
CHAN_LEVEL_PROTECTME
	   PROTECT/DEPROTECT  
CHAN_LEVEL_PROTECT
	   PROTECT/DEPROTECT
CHAN_LEVEL_KICKME
	   KICK  
CHAN_LEVEL_KICK
	  KICK
CHAN_LEVEL_SIGNKICK
	 ,   SIGNKICK LEVEL
CHAN_LEVEL_BANME
	   BAN  
CHAN_LEVEL_BAN
	   BAN
CHAN_LEVEL_TOPIC
	   TOPIC
CHAN_LEVEL_INFO
	   INFO   ALL

# Automatic responses
CHAN_IS_REGISTERED
	    %s.
CHAN_NOT_ALLOWED_OP
	     %s.
CHAN_MAY_NOT_BE_USED
	   .
CHAN_NOT_ALLOWED_TO_JOIN
	      .

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER #  
CHAN_REGISTER_DISABLED
	,    .
CHAN_REGISTER_NOT_LOCAL
	     .
CHAN_MUST_REGISTER_NICK
	     .  /msg %s HELP     ,   .
CHAN_MUST_IDENTIFY_NICK
	    %s,  :
	/msg %s IDENTIFY 
CHAN_MAY_NOT_BE_REGISTERED
	 %s    .
CHAN_ALREADY_REGISTERED
	 %s  !
CHAN_MUST_BE_CHANOP
	     ,   .
CHAN_REACHED_CHANNEL_LIMIT
	,    %d , ,  , .
CHAN_EXCEEDED_CHANNEL_LIMIT
	,     (%d)  .
CHAN_REGISTRATION_FAILED
	,  .
CHAN_REGISTERED
	 %s   : %s
CHAN_PASSWORD_IS
	   -  %s -   !

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY # 
CHAN_IDENTIFY_FAILED
	 .
CHAN_IDENTIFY_SUCCEEDED
	  -      %s - .

# LOGOUT responses
CHAN_LOGOUT_SYNTAX
	LOGOUT # 
CHAN_LOGOUT_SERVADMIN_SYNTAX
	LOGOUT # []
CHAN_LOGOUT_SUCCEEDED
	 %s     %s.
CHAN_LOGOUT_ALL_SUCCEEDED
	       %s.

# DROP responses
CHAN_DROP_SYNTAX
	DROP #
CHAN_DROP_DISABLED
	,    .
CHAN_DROPPED
	 %s  .

# SET responses
CHAN_SET_SYNTAX
	SET #  
CHAN_SET_DISABLED
	,      .
CHAN_SET_UNKNOWN_OPTION
	  SET %s.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	 %s    .
CHAN_FOUNDER_CHANGED
	  %s   %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	  %s   %s.
CHAN_SUCCESSOR_UNSET
	 %s .
CHAN_SUCCESSOR_IS_FOUNDER
	%s      %s,     .

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	,   .
CHAN_PASSWORD_CHANGED
	 %s .
CHAN_PASSWORD_CHANGED_TO
	  %s   %s.

# SET DESC responses
CHAN_DESC_CHANGED
	  %s   %s.

# SET URL responses
CHAN_URL_CHANGED
	URL  %s   %s.
CHAN_URL_UNSET
	URL   %s .

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	 E-mail   %s   %s.
CHAN_EMAIL_UNSET
	 E-mail   %s .

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	     for %s .
CHAN_ENTRY_MSG_UNSET
	     %s .
	
# SET BANTYPE responses
CHAN_SET_BANTYPE_INVALID
	%s     .
CHAN_SET_BANTYPE_CHANGED
	    %s  #%d.

# SET MLOCK responses
CHAN_SET_MLOCK_UNKNOWN_CHAR
	  %c - .
CHAN_SET_MLOCK_IMPOSSIBLE_CHAR
	 %c  ,       .
CHAN_SET_MLOCK_L_REQUIRED
	   +l       +L.
CHAN_SET_MLOCK_K_REQUIRED
	   +i       +K.
CHAN_MLOCK_CHANGED
	    %s   %s.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET # KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	  .
CHAN_SET_KEEPTOPIC_OFF
	  .

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET # TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	  .
CHAN_SET_TOPICLOCK_OFF
	  .

# SET PEACE responses
CHAN_SET_PEACE_SYNTAX
	SET # PEACE {ON | OFF}
CHAN_SET_PEACE_ON
	  .
CHAN_SET_PEACE_OFF
	  .

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET # PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	  .
CHAN_SET_PRIVATE_OFF
	  .

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET # SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	    .
CHAN_SET_SECUREOPS_OFF
	    .
	
# SET SECUREFOUNDER responses
CHAN_SET_SECUREFOUNDER_SYNTAX
	SET # SECUREFOUNDER {ON | OFF}
CHAN_SET_SECUREFOUNDER_ON
	  .
CHAN_SET_SECUREFOUNDER_OFF
	  .

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET # RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	    .
CHAN_SET_RESTRICTED_OFF
	    .

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET # SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	 .
CHAN_SET_SECURE_OFF
	 .
	
# SET SIGNKICK responses
CHAN_SET_SIGNKICK_SYNTAX
	SET # SIGNKICK {ON | LEVEL | OFF}
CHAN_SET_SIGNKICK_ON
	    .
CHAN_SET_SIGNKICK_LEVEL
	    ,     , 
	  .
CHAN_SET_SIGNKICK_OFF
	    .

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET # OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	    OP .
CHAN_SET_OPNOTICE_OFF
	    OP .

# SET XOP responses
CHAN_SET_XOP_SYNTAX
	SET # XOP {ON | OFF}
CHAN_SET_XOP_ON
	   xOP .
CHAN_SET_XOP_OFF
	   xOP .

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET # NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	 %s   .
CHAN_SET_NOEXPIRE_OFF
	 %s  .

# xOP messages
CHAN_XOP_REACHED_LIMIT
	,     %d AOP/SOP/VOP  .
CHAN_XOP_LIST_FORMAT
	  %3d  %s
CHAN_XOP_ACCESS
	     .     ACCESS.
	 /msg %s HELP ACCESS     .

# AOP messages
CHAN_AOP_SYNTAX
	AOP # {ADD|DEL|LIST|CLEAR} [ |  ]
CHAN_AOP_DISABLED
	,   AOP'  .
CHAN_AOP_NICKS_ONLY
	 AOP     .
CHAN_AOP_ADDED
	%s   AOP'  %s.
CHAN_AOP_MOVED
	%s   AOP' %s.
CHAN_AOP_NO_SUCH_ENTRY
	   (#%d)  AOP' %s.
CHAN_AOP_NOT_FOUND
	%s    AOP' %s.
CHAN_AOP_NO_MATCH
	    AOP'  %s.
CHAN_AOP_DELETED
	%s   AOP'  %s.
CHAN_AOP_DELETED_ONE
	 1   AOP'  %s.
CHAN_AOP_DELETED_SEVERAL
	 %d   AOP'  %s.
CHAN_AOP_LIST_EMPTY
	 AOP'  %s .
CHAN_AOP_LIST_HEADER
	 AOP'  %s:
	   
CHAN_AOP_CLEAR
	 AOP'   .

# HOP messages
CHAN_HOP_SYNTAX
	HOP # {ADD|DEL|LIST|CLEAR} [ |  ]
CHAN_HOP_DISABLED
	,   HOP'  .
CHAN_HOP_NICKS_ONLY
	 HOP     .
CHAN_HOP_ADDED
	%s   HOP'  %s.
CHAN_HOP_MOVED
	%s   HOP' %s.
CHAN_HOP_NO_SUCH_ENTRY
	   (#%d)  HOP' %s.
CHAN_HOP_NOT_FOUND
	%s    HOP' %s.
CHAN_HOP_NO_MATCH
	    HOP'  %s.
CHAN_HOP_DELETED
	%s   HOP'  %s.
CHAN_HOP_DELETED_ONE
	 1   HOP'  %s.
CHAN_HOP_DELETED_SEVERAL
	 %d   HOP'  %s.
CHAN_HOP_LIST_EMPTY
	 HOP'  %s .
CHAN_HOP_LIST_HEADER
	 HOP'  %s:
	    
CHAN_HOP_CLEAR
	 HOP'   .

# SOP messages
CHAN_SOP_SYNTAX
	SOP # {ADD|DEL|LIST|CLEAR} [ |  ]
CHAN_SOP_DISABLED
	,   SOP'  .
CHAN_SOP_NICKS_ONLY
	 SOP     .
CHAN_SOP_ADDED
	%s   SOP'  %s.
CHAN_SOP_MOVED
	%s   SOP' %s.
CHAN_SOP_NO_SUCH_ENTRY
	   (#%d)  SOP' %s.
CHAN_SOP_NOT_FOUND
	%s    SOP' %s.
CHAN_SOP_NO_MATCH
	    SOP'  %s.
CHAN_SOP_DELETED
	%s   SOP'  %s.
CHAN_SOP_DELETED_ONE
	 1   SOP'  %s.
CHAN_SOP_DELETED_SEVERAL
	 %d   SOP'  %s.
CHAN_SOP_LIST_EMPTY
	 SOP'  %s .
CHAN_SOP_LIST_HEADER
	 SOP'  %s:
	    
CHAN_SOP_CLEAR
	 SOP'   .

# VOP messages
CHAN_VOP_SYNTAX
	VOP # {ADD|DEL|LIST|CLEAR} [ |  ]
CHAN_VOP_DISABLED
	,   VOP'  .
CHAN_VOP_NICKS_ONLY
	 VOP     .
CHAN_VOP_ADDED
	%s   VOP'  %s.
CHAN_VOP_MOVED
	%s   VOP' %s.
CHAN_VOP_NO_SUCH_ENTRY
	   (#%d)  VOP' %s.
CHAN_VOP_NOT_FOUND
	%s    VOP' %s.
CHAN_VOP_NO_MATCH
	    VOP'  %s.
CHAN_VOP_DELETED
	%s   VOP'  %s.
CHAN_VOP_DELETED_ONE
	 1   VOP'  %s.
CHAN_VOP_DELETED_SEVERAL
	 %d   VOP'  %s.
CHAN_VOP_LIST_EMPTY
	 VOP'  %s .
CHAN_VOP_LIST_HEADER
	 VOP'  %s:
	    
CHAN_VOP_CLEAR
	 VOP'   .

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS # {ADD|DEL|LIST|CLEAR} [ [] |  ]
CHAN_ACCESS_XOP
	     .   AOP, SOP  VOP  .
	 /msg %s HELP   
	  .
CHAN_ACCESS_DISABLED
	,      .
CHAN_ACCESS_LEVEL_NONZERO
	      .
CHAN_ACCESS_LEVEL_RANGE
	     %d  %d .
CHAN_ACCESS_NICKS_ONLY
	       .
CHAN_ACCESS_REACHED_LIMIT
	,         %d .
CHAN_ACCESS_LEVEL_UNCHANGED
	   %s   %s   - %d.
CHAN_ACCESS_LEVEL_CHANGED
	   %s   %s   %d.
CHAN_ACCESS_ADDED
	%s      %s    %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	  (#%d)     %s.
CHAN_ACCESS_NOT_FOUND
	%s       %s.
CHAN_ACCESS_NO_MATCH
	       %s.
CHAN_ACCESS_DELETED
	%s      %s.
CHAN_ACCESS_DELETED_ONE
	 1      %s.
CHAN_ACCESS_DELETED_SEVERAL
	 %d      %s.
CHAN_ACCESS_LIST_EMPTY
	   %s .
CHAN_ACCESS_LIST_HEADER
	   %s:
	  
CHAN_ACCESS_LIST_FOOTER
	  .
CHAN_ACCESS_LIST_XOP_FORMAT
	  %3d   %s  %s
CHAN_ACCESS_LIST_AXS_FORMAT
	  %3d  %4d  %s
CHAN_ACCESS_CLEAR
	   .

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK # {ADD | STICK | UNSTICK | DEL | LIST | VIEW | ENFORCE | CLEAR} [---] []
CHAN_AKICK_DISABLED
	,      .
CHAN_AKICK_ALREADY_EXISTS
	%s       %s.
CHAN_AKICK_REACHED_LIMIT
	,        %d  .
CHAN_AKICK_ADDED
	%s      %s.
CHAN_AKICK_NO_SUCH_ENTRY
	   (#%d)     %s.
CHAN_AKICK_NOT_FOUND
	%s       %s.
CHAN_AKICK_NO_MATCH
	       %s.
CHAN_AKICK_STUCK
	%s      %s.
CHAN_AKICK_UNSTUCK
	%s      %s.
CHAN_AKICK_DELETED
	%s      %s.
CHAN_AKICK_DELETED_ONE
	 1      %s.
CHAN_AKICK_DELETED_SEVERAL
	 %d      %s.
CHAN_AKICK_LIST_EMPTY
	   %s .
CHAN_AKICK_LIST_HEADER
	    %s:
CHAN_AKICK_LIST_FORMAT
	  %3d %s (%s)
CHAN_AKICK_VIEW_FORMAT
	%3d %s (by %s on %s)
	    %s
CHAN_AKICK_VIEW_FORMAT_STUCK
	%3d %s () (by %s on %s)
	    %s
CHAN_AKICK_ENFORCE_DONE
	AKICK ENFORCE   %s ; %d  .
CHAN_AKICK_CLEAR
	    .

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS # {SET | DIS[ABLE] | LIST | RESET} [ []]
CHAN_LEVELS_XOP
	        .
CHAN_LEVELS_RANGE
	     %d  %d .
CHAN_LEVELS_CHANGED
	 %s   %s   %d.
CHAN_LEVELS_UNKNOWN
	  %s.  /msg %s HELP LEVELS DESC     .
CHAN_LEVELS_DISABLED
	%s    %s.
CHAN_LEVELS_LIST_HEADER
	     %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  ()
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (  )
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %d
CHAN_LEVELS_RESET
	    %s     .

# INFO responses
CHAN_INFO_SYNTAX
	INFO # [ALL]
CHAN_INFO_HEADER
	   %s:
CHAN_INFO_FOUNDER
	:                  %s (%s)
CHAN_INFO_NO_FOUNDER
	:                  %s
CHAN_INFO_SUCCESSOR
	:                 %s (%s)
CHAN_INFO_NO_SUCCESSOR
	:                 %s
CHAN_INFO_DESCRIPTION
	:                  %s
CHAN_INFO_ENTRYMSG
	  :       %s
CHAN_INFO_TIME_REGGED
	:           %s
CHAN_INFO_LAST_USED
	  : %s
CHAN_INFO_LAST_TOPIC
	 :           %s
CHAN_INFO_TOPIC_SET_BY
	 :           %s
CHAN_INFO_URL
	URL:                       %s
CHAN_INFO_EMAIL
	 E-mail:              %s
CHAN_INFO_BANTYPE
	 :                  %d
CHAN_INFO_OPTIONS
	:                     %s
CHAN_INFO_OPT_KEEPTOPIC
	 
CHAN_INFO_OPT_OPNOTICE
	OP 
CHAN_INFO_OPT_PEACE
	
CHAN_INFO_OPT_PRIVATE
	
CHAN_INFO_OPT_RESTRICTED
	 
CHAN_INFO_OPT_SECURE
	
CHAN_INFO_OPT_SECUREOPS
	  
CHAN_INFO_OPT_SECUREFOUNDER
	 
CHAN_INFO_OPT_SIGNKICK
	 
CHAN_INFO_OPT_TOPICLOCK
	 
CHAN_INFO_OPT_XOP
	   xOP
CHAN_INFO_OPT_NONE
	
CHAN_INFO_MODE_LOCK
	 : %s
CHAN_INFO_NO_EXPIRE
	    .

# LIST responses
CHAN_LIST_SYNTAX
	LIST 
CHAN_LIST_SERVADMIN_SYNTAX
	LIST  [FORBIDDEN] [SUSPENDED] [NOEXPIRE]
CHAN_LIST_HEADER
	 ,  %s:
CHAN_LIST_FORMAT
	    %-20s  %s
CHAN_LIST_END
	  -  %d/%d .
	
# INVITE responses
CHAN_INVITE_SYNTAX
	INVITE #

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN #
CHAN_UNBANNED
	     %s.

# TOPIC responses
CHAN_TOPIC_SYNTAX
	TOPIC # []

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR # 
CHAN_CLEARED_BANS
	    %s  .
CHAN_CLEARED_EXCEPTS
	      %s  .
CHAN_CLEARED_MODES
	    %s  .
CHAN_CLEARED_OPS
	      %s.
CHAN_CLEARED_VOICES
	      %s.
CHAN_CLEARED_USERS
	      %s.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS #
CHAN_GETPASS_UNAVAILABLE
	 GETPASS    .
CHAN_GETPASS_PASSWORD_IS
	   %s - %s.
	
# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS #
CHAN_SENDPASS_UNAVAILABLE
	 SENDPASS    .
CHAN_SENDPASS_SUBJECT
	  (%s)
CHAN_SENDPASS_HEAD
	Hi,
CHAN_SENDPASS_LINE_1
	  %s       e-mail.
CHAN_SENDPASS_LINE_2
	   %s.   ,      .
CHAN_SENDPASS_LINE_3
	     ,   .
CHAN_SENDPASS_LINE_4
	     !
CHAN_SENDPASS_LINE_5
	 %s.
CHAN_SENDPASS_OK
	  %s  .

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID # []
CHAN_FORBID_SYNTAX_REASON
	FORBID # 
CHAN_FORBID_SUCCEEDED
	 %s    .
CHAN_FORBID_FAILED
	    %s!
CHAN_FORBID_REASON
	    .

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND # []
CHAN_SUSPEND_SYNTAX_REASON
	SUSPEND # 
CHAN_SUSPEND_SUCCEEDED
	 %s .
CHAN_SUSPEND_FAILED
	   %s!
CHAN_SUSPEND_REASON
	   .

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND #
CHAN_UNSUSPEND_ERROR
	 #   .
CHAN_UNSUSPEND_SUCCEEDED
	 %s .
CHAN_UNSUSPEND_FAILED
	   %s!

# Misc responses
CHAN_EXCEPTED
	 %s   %s          .

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	  1  .
MEMO_HAVE_NEW_MEMOS
	  %d  .
MEMO_TYPE_READ_LAST
	 /msg %s READ LAST   .
MEMO_TYPE_READ_NUM
	 /msg %s READ %d   .
MEMO_TYPE_LIST_NEW
	 /msg %s LIST NEW    .
MEMO_AT_LIMIT
	:      !    (%d) .      ,        .
MEMO_OVER_LIMIT
	:      !    (%d) .      ,        .
MEMO_X_MANY_NOTICE
	%d    %s.
MEMO_X_ONE_NOTICE
	%d    %s.
MEMO_NEW_X_MEMO_ARRIVED
	  %s  .
	 /msg %s READ %s %d   .
MEMO_NEW_MEMO_ARRIVED
	     %s.
	 /msg %s READ %d   .

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	   .
MEMO_X_HAS_NO_MEMOS
	 %s  .
MEMO_DOES_NOT_EXIST
	 %d  !
MEMO_LIST_NOT_FOUND
	   .

# SEND responses
MEMO_SEND_SYNTAX
	SEND { | #}  
MEMO_SEND_DISABLED
	,    .
MEMO_SEND_PLEASE_WAIT
	  %d   ,    SEND .
MEMO_X_GETS_NO_MEMOS
	%s    .
MEMO_X_HAS_TOO_MANY_MEMOS
	 %s           .
MEMO_SENT
	  %s.
MEMO_MASS_SENT
	      .

	
# CANCEL responses
MEMO_CANCEL_SYNTAX
	CANCEL { | #}
MEMO_CANCEL_DISABLED
	,    .
MEMO_CANCEL_NONE
	 ,   .
MEMO_CANCELLED
	   %s  .

# LIST responses
MEMO_LIST_SYNTAX
	LIST [#] [list | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	    .
MEMO_X_HAS_NO_NEW_MEMOS
	 %s   .
MEMO_LIST_MEMOS
	  %s.   , : /msg %s READ  
MEMO_LIST_NEW_MEMOS
	   %s.   , : /msg %s READ  
MEMO_LIST_CHAN_MEMOS
	  %s.   , : /msg %s READ %s  
MEMO_LIST_CHAN_NEW_MEMOS
	   %s.    , : /msg %s READ %s  
MEMO_LIST_HEADER
	             /
MEMO_LIST_FORMAT
	%c%3d    %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [#] {list | LAST | NEW}
MEMO_HEADER
	 %d  %s (%s).   ,  : /msg %s DEL %d
MEMO_CHAN_HEADER
	 %d  %s (%s).   ,  : /msg %s DEL %s %d
MEMO_TEXT
	%s

# DEL responses
MEMO_DEL_SYNTAX
	DEL [#] {  | list | ALL}
MEMO_DELETED_NONE
	   .
MEMO_DELETED_ONE
	 %d  .
MEMO_DELETED_SEVERAL
	 %s  .
MEMO_DELETED_ALL
	    .
MEMO_CHAN_DELETED_ALL
	    %s  .

# SET responses
MEMO_SET_SYNTAX
	SET  
MEMO_SET_DISABLED
	,       .
MEMO_SET_UNKNOWN_OPTION
	  SET %s.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s      ,           .
MEMO_SET_NOTIFY_LOGON
	%s      ,           /AWAY.
MEMO_SET_NOTIFY_NEW
	%s      ,     .
MEMO_SET_NOTIFY_OFF
	%s       .

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [#] limit
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [ | #] {limit | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	       .
MEMO_SET_LIMIT_FORBIDDEN
	   %s  .
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	      ,  %d.
MEMO_SET_LIMIT_TOO_HIGH
	       %s   %d.
MEMO_SET_LIMIT_OVERFLOW
	   ;    %d.
MEMO_SET_YOUR_LIMIT
	     %d.
MEMO_SET_YOUR_LIMIT_ZERO
	     .
MEMO_UNSET_YOUR_LIMIT
	    .
MEMO_SET_LIMIT
	   %s   %d.
MEMO_SET_LIMIT_ZERO
	   %s   0.
MEMO_UNSET_LIMIT
	   %s .

# INFO responses
MEMO_INFO_SYNTAX
	INFO [#]
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [ | #]
MEMO_INFO_NO_MEMOS
	      .
MEMO_INFO_MEMO
	      1 .
MEMO_INFO_MEMO_UNREAD
	      1 ,       .
MEMO_INFO_MEMOS
	      %d .
MEMO_INFO_MEMOS_ONE_UNREAD
	      %d ,   1 .
MEMO_INFO_MEMOS_SOME_UNREAD
	      %d ,   %d .
MEMO_INFO_MEMOS_ALL_UNREAD
	      %d ;     .
MEMO_INFO_LIMIT
	    %d.
MEMO_INFO_HARD_LIMIT
	    %d,     .
MEMO_INFO_LIMIT_ZERO
	    0;       .
MEMO_INFO_HARD_LIMIT_ZERO
	    0;       .       .
MEMO_INFO_NO_LIMIT
	       .
MEMO_INFO_NOTIFY_OFF
	      .
MEMO_INFO_NOTIFY_ON
	               .
MEMO_INFO_NOTIFY_RECEIVE
	       .
MEMO_INFO_NOTIFY_SIGNON
	          .
MEMO_INFO_X_NO_MEMOS
	%s    .
MEMO_INFO_X_MEMO
	%s   1 .
MEMO_INFO_X_MEMO_UNREAD
	%s   1 ,     .
MEMO_INFO_X_MEMOS
	%s   %d .
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s   %d , 1    .
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s   %d , %d    .
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s   %d ;    .
MEMO_INFO_X_LIMIT
	   %s  %d.
MEMO_INFO_X_HARD_LIMIT
	   %s  %d,     .
MEMO_INFO_X_NO_LIMIT
	 %s    .
MEMO_INFO_X_NOTIFY_OFF
	%s     .
MEMO_INFO_X_NOTIFY_ON
	%s             .
MEMO_INFO_X_NOTIFY_RECEIVE
	%s        .
MEMO_INFO_X_NOTIFY_SIGNON
	%s        .
	
###########################################################################
#
# BotServ messages
#
###########################################################################
	
# Standard responses
BOT_DOES_NOT_EXIST
	 %s  .
BOT_NOT_ASSIGNED
	       ,    .
	 /msg %S HELP ASSIGN     .
BOT_NOT_ON_CHANNEL
	    %s.
	
# Kick reasons (must be a single line)
BOT_REASON_BADWORD
	   %s   !
BOT_REASON_BADWORD_GENTLE
	   !
BOT_REASON_BOLD
	      !
BOT_REASON_CAPS
	 CapsLOCK!
BOT_REASON_COLOR
	      !
BOT_REASON_FLOOD
	 !
BOT_REASON_REPEAT
	 !
BOT_REASON_REVERSE
	     !
BOT_REASON_UNDERLINE
	     !
	
# !seen replies
BOT_SEEN_BOT
	  , %s!
BOT_SEEN_YOU
	 , %s?
BOT_SEEN_ON_CHANNEL
	%s    !
BOT_SEEN_ON_CHANNEL_AS
	%s     (  %s) ! 
BOT_SEEN_ON
	%s    %s .
BOT_SEEN_NEVER
	    %s  .
BOT_SEEN_UNKNOWN
	     %s.
	
# BOT responses
BOT_BOT_SYNTAX
	BOT ADD     
	BOT CHANGE     [ [ [ ]]]
	BOT DEL 
	BOT LIST
BOT_BOT_ALREADY_EXISTS
	 %s  .
BOT_BOT_CREATION_FAILED
	,   .
BOT_BOT_READONLY
	,     .
BOT_BOT_ADDED
	%s!%s@%s (%s)    .
BOT_BOT_ANY_CHANGES
	   .
BOT_BOT_CHANGED
	 %s    %s!%s@%s (%s)
BOT_BOT_DELETED
	 %s  .
	
# BOTLIST responses
BOT_BOTLIST_HEADER
	 :
BOT_BOTLIST_PRIVATE_HEADER
	,   IRC :
BOT_BOTLIST_FOOTER
	%d  .
BOT_BOTLIST_EMPTY
	   .
	      !
	
# ASSIGN responses
BOT_ASSIGN_SYNTAX
	ASSIGN chan nick
BOT_ASSIGN_READONLY
	,      .
BOT_ASSIGN_ALREADY
	 %s     %s.
BOT_ASSIGN_ASSIGNED
	 %s    %s.
	
# UNASSIGN responses
BOT_UNASSIGN_SYNTAX
	UNASSIGN #
BOT_UNASSIGN_UNASSIGNED
	   %s .
	
# INFO responses
BOT_INFO_SYNTAX
	INFO {# | }
BOT_INFO_NOT_FOUND
	%s      .
BOT_INFO_BOT_HEADER
	   %s:
BOT_INFO_BOT_MASK
	           : %s@%s
BOT_INFO_BOT_REALNAME
	     : %s
BOT_INFO_BOT_CREATED
	          : %s
BOT_INFO_BOT_USAGE
	  : %d channel(s)
BOT_INFO_BOT_OPTIONS
	           : %s
BOT_INFO_OPT_PRIVATE
	
BOT_INFO_CHAN_HEADER
	   %s:
BOT_INFO_CHAN_BOT
	              : %s
BOT_INFO_CHAN_BOT_NONE
	              :   .
BOT_INFO_CHAN_KICK_BADWORDS
	     : %s
BOT_INFO_CHAN_KICK_BADWORDS_BAN
	     : %s (%d   )
BOT_INFO_CHAN_KICK_BOLDS
	     : %s
BOT_INFO_CHAN_KICK_BOLDS_BAN
	     : %s (%d   )
BOT_INFO_CHAN_KICK_CAPS_ON
	      CapsLOCK : %s ( %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_BAN
	      CapsLOCK : %s (%d   ;  %d/%d%%)
BOT_INFO_CHAN_KICK_CAPS_OFF
	      CapsLOCK : %s
BOT_INFO_CHAN_KICK_COLORS
	         : %s
BOT_INFO_CHAN_KICK_COLORS_BAN
	         : %s (%d   )
BOT_INFO_CHAN_KICK_FLOOD_ON
	          : %s (%d   %ds)
BOT_INFO_CHAN_KICK_FLOOD_BAN
	          : %s (%d   ; %d   %ds)
BOT_INFO_CHAN_KICK_FLOOD_OFF
	          : %s
BOT_INFO_CHAN_KICK_REPEAT_ON
	       : %s (%d )
BOT_INFO_CHAN_KICK_REPEAT_BAN
	       : %s (%d   ; %d )
BOT_INFO_CHAN_KICK_REPEAT_OFF
	       : %s
BOT_INFO_CHAN_KICK_REVERSES
	       : %s
BOT_INFO_CHAN_KICK_REVERSES_BAN
	       : %s (%d   )
BOT_INFO_CHAN_KICK_UNDERLINES
	  : %s
BOT_INFO_CHAN_KICK_UNDERLINES_BAN
	  : %s (%d   )
BOT_INFO_ACTIVE
	
BOT_INFO_INACTIVE
	
BOT_INFO_CHAN_OPTIONS
	                : %s
BOT_INFO_OPT_DONTKICKOPS
	 
BOT_INFO_OPT_DONTKICKVOICES
	 
BOT_INFO_OPT_FANTASY
	
BOT_INFO_OPT_GREET
	
BOT_INFO_OPT_NOBOT
	-
BOT_INFO_OPT_SYMBIOSIS
	
BOT_INFO_OPT_NONE
	
	
# SET responses
BOT_SET_SYNTAX
	SET #  
BOT_SET_DISABLED
	,     .
BOT_SET_UNKNOWN
	  %s.
	 /msg %S HELP SET    .
	
# SET DONTKICKOPS messages
BOT_SET_DONTKICKOPS_SYNTAX
	SET # DONTKICKOPS {ON|OFF}
BOT_SET_DONTKICKOPS_ON
	      %s.
BOT_SET_DONTKICKOPS_OFF
	     %s.
	
# SET DONTKICKVOICES messages
BOT_SET_DONTKICKVOICES_SYNTAX
	SET # DONTKICKVOICES {ON|OFF}
BOT_SET_DONTKICKVOICES_ON
	      %s.
BOT_SET_DONTKICKVOICES_OFF
	     %s.

# SET FANTASY messages
BOT_SET_FANTASY_SYNTAX
	SET # FANTASY {ON|OFF}
BOT_SET_FANTASY_ON
	     %s.
BOT_SET_FANTASY_OFF
	     %s.
	
# SET GREET messages
BOT_SET_GREET_SYNTAX
	SET # GREET {ON|OFF}
BOT_SET_GREET_ON
	  on channel %s .
BOT_SET_GREET_OFF
	  on channel %s .
	
# SET NOBOT
BOT_SET_NOBOT_SYNTAX
	SET # NOBOT {ON|OFF}
BOT_SET_NOBOT_ON
	 -    %s.
BOT_SET_NOBOT_OFF
	 -    %s.

# SET PRIVATE
BOT_SET_PRIVATE_SYNTAX
	SET # PRIVATE {ON|OFF}
BOT_SET_PRIVATE_ON
	    %s is now .
BOT_SET_PRIVATE_OFF
	    %s is now .

# SET SYMBIOSIS
BOT_SET_SYMBIOSIS_SYNTAX
	SET # SYMBIOSIS {ON|OFF}
BOT_SET_SYMBIOSIS_ON
	     %s.
BOT_SET_SYMBIOSIS_OFF
	     %s.
	
# KICK responses
BOT_KICK_SYNTAX
	KICK #  {ON|OFF} []
BOT_KICK_DISABLED
	,    .
BOT_KICK_UNKNOWN
	  %s.
	 /msg %S HELP KICK     .
BOT_KICK_BAD_TTB
	%s     .

BOT_KICK_BADWORDS_ON
	     .   BADWORDS
	     .
BOT_KICK_BADWORDS_ON_BAN
	      ,   
	%d   .   BADWORDS
	     .
BOT_KICK_BADWORDS_OFF
	      .
BOT_KICK_BOLDS_ON
	      .
BOT_KICK_BOLDS_ON_BAN
	      ,    
	%d   .
BOT_KICK_BOLDS_OFF
	       .
BOT_KICK_CAPS_ON
	     CapsLOCK (  
	%d         %d%%   ).
BOT_KICK_CAPS_ON_BAN
	     CapsLOCK   
	%d         %d%%   ),  
	 %d   .
BOT_KICK_CAPS_OFF
	      CapsLOCK.
BOT_KICK_COLORS_ON
	      
BOT_KICK_COLORS_ON_BAN
	      ,    %d 
	  .
BOT_KICK_COLORS_OFF
	       
BOT_KICK_FLOOD_ON
	     (%d   %d ).
BOT_KICK_FLOOD_ON_BAN
	     (%d   %d ),   
	 %d   .
BOT_KICK_FLOOD_OFF
	     .
BOT_KICK_REPEAT_ON
	     (   
	%d  ).
BOT_KICK_REPEAT_ON_BAN
	     (   
	%d  ),    %d 
	  .
BOT_KICK_REPEAT_OFF
	     .
BOT_KICK_REVERSES_ON
	    .
BOT_KICK_REVERSES_ON_BAN
	    ,    %d 
	  .
BOT_KICK_REVERSES_OFF
	     .
BOT_KICK_UNDERLINES_ON
	     .
BOT_KICK_UNDERLINES_ON_BAN
	     .,    %d 
	  .
BOT_KICK_UNDERLINES_OFF
	      .
	
# BADWORDS messages
BOT_BADWORDS_SYNTAX
	BADWORDS # {ADD|DEL|LIST|CLEAR} [ |  ] [SINGLE|START|END]
BOT_BADWORDS_DISABLED
	,        .
BOT_BADWORDS_REACHED_LIMIT
	,        %d   .
BOT_BADWORDS_ALREADY_EXISTS
	%s       %s.
BOT_BADWORDS_ADDED
	%s      %s.
BOT_BADWORDS_NO_SUCH_ENTRY
	   (#%d)     %s.
BOT_BADWORDS_NOT_FOUND
	%s       %s.
BOT_BADWORDS_NO_MATCH
	       %s.
BOT_BADWORDS_DELETED
	%s      %s.
BOT_BADWORDS_DELETED_ONE
	 1      %s.
BOT_BADWORDS_DELETED_SEVERAL
	 %d      %s.
BOT_BADWORDS_LIST_EMPTY
	   %s .
BOT_BADWORDS_LIST_HEADER
	   %s:
	                               
BOT_BADWORDS_LIST_FORMAT
	  %3d   %-30s %s
BOT_BADWORDS_CLEAR
	    .

# SAY responses
BOT_SAY_SYNTAX
	SAY # 

# ACT responses
BOT_ACT_SYNTAX
	ACT # 

# Errors
BOT_EXCEPT
	   .
BOT_BAD_NICK
	      .
BOT_BAD_HOST
	        .
BOT_BAD_IDENT
	        .

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	    .  ,     ?
OPER_BOUNCY_MODES_U_LINE
	    .  ,  U:lines  ?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL 

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	  STATS %s.
OPER_STATS_CURRENT_USERS
	: %d (%d )
OPER_STATS_MAX_USERS
	 : %d (%s)
# This is ugly, but at least it's language-portable...
# Note that you can include seconds in any of these--my personal preference
# is to only give resolution to the nearest minute when uptime is one hour
# or more, but just add a %d to get seconds as well.
OPER_STATS_UPTIME_DHMS
	  %d , %02d:%02d
OPER_STATS_UPTIME_1DHMS
	  %d , %02d:%02d
OPER_STATS_UPTIME_HMS
	  %d , %d 
OPER_STATS_UPTIME_HM1S
	  %d , %d 
OPER_STATS_UPTIME_H1MS
	  %d , %d 
OPER_STATS_UPTIME_H1M1S
	  %d , %d 
OPER_STATS_UPTIME_1HMS
	  %d , %d 
OPER_STATS_UPTIME_1HM1S
	  %d , %d 
OPER_STATS_UPTIME_1H1MS
	  %d , %d 
OPER_STATS_UPTIME_1H1M1S
	  %d , %d 
OPER_STATS_UPTIME_MS
	  %d , %d 
OPER_STATS_UPTIME_M1S
	  %d , %d 
OPER_STATS_UPTIME_1MS
	  %d , %d 
OPER_STATS_UPTIME_1M1S
	  %d , %d 
OPER_STATS_BYTES_READ
	                         : %5d kB
OPER_STATS_BYTES_WRITTEN
	                          : %5d kB
OPER_STATS_USER_MEM
	                          : %6d , %5d kB
OPER_STATS_CHANNEL_MEM
	                                : %6d , %5d kB
OPER_STATS_GROUPS_MEM
	                            : %6d , %5d kB
OPER_STATS_ALIASES_MEM
	                          : %6d , %5d kB
OPER_STATS_CHANSERV_MEM
	ChanServ                              : %6d , %5d kB
OPER_STATS_BOTSERV_MEM
	BotServ                               : %6d , %5d kB
OPER_STATS_OPERSERV_MEM
	OperServ                              : %6d , %5d kB
OPER_STATS_SESSIONS_MEM
	                                : %6d , %5d kB
OPER_STATS_PROXY_MEM
	                                : %6d , %5d kB
OPER_STATS_AKILL_COUNT
	 AKILL'                   : %d
OPER_STATS_AKILL_EXPIRE_DAYS
	  AKILL'    : %d 
OPER_STATS_AKILL_EXPIRE_DAY
	  AKILL'    : 1 
OPER_STATS_AKILL_EXPIRE_HOURS
	  AKILL'    : %d 
OPER_STATS_AKILL_EXPIRE_HOUR
	  AKILL'    : 1 
OPER_STATS_AKILL_EXPIRE_MINS
	  AKILL'    : %d 
OPER_STATS_AKILL_EXPIRE_MIN
	  AKILL'    : 1 
OPER_STATS_AKILL_EXPIRE_NONE
	  AKILL'    :  
OPER_STATS_SGLINE_COUNT
	 SGLINEs                    : %d
OPER_STATS_SGLINE_EXPIRE_DAYS
	  SGLINE'   : %d 
OPER_STATS_SGLINE_EXPIRE_DAY
	  SGLINE'   : 1 
OPER_STATS_SGLINE_EXPIRE_HOURS
	  SGLINE'   : %d 
OPER_STATS_SGLINE_EXPIRE_HOUR
	  SGLINE'   : 1 
OPER_STATS_SGLINE_EXPIRE_MINS
	  SGLINE'   : %d 
OPER_STATS_SGLINE_EXPIRE_MIN
	  SGLINE'   : 1 
OPER_STATS_SGLINE_EXPIRE_NONE
	  SGLINE'   :  
OPER_STATS_SQLINE_COUNT
	 SQLINE'                  : %d
OPER_STATS_SQLINE_EXPIRE_DAYS
	  SQGLINE'  : %d 
OPER_STATS_SQLINE_EXPIRE_DAY
	  SQGLINE'  : 1 
OPER_STATS_SQLINE_EXPIRE_HOURS
	  SQGLINE'  : %d 
OPER_STATS_SQLINE_EXPIRE_HOUR
	  SQGLINE'  : 1 
OPER_STATS_SQLINE_EXPIRE_MINS
	  SQGLINE'  : %d 
OPER_STATS_SQLINE_EXPIRE_MIN
	  SQGLINE'  : 1 
OPER_STATS_SQLINE_EXPIRE_NONE
	  SQGLINE'  :  
OPER_STATS_SZLINE_COUNT
	 SZLINE'                  : %d
OPER_STATS_SZLINE_EXPIRE_DAYS
	  SZLINE'   : %d 
OPER_STATS_SZLINE_EXPIRE_DAY
	  SZLINE'   : 1 
OPER_STATS_SZLINE_EXPIRE_HOURS
	  SZLINE'   : %d 
OPER_STATS_SZLINE_EXPIRE_HOUR
	  SZLINE'   : 1 
OPER_STATS_SZLINE_EXPIRE_MINS
	  SZLINE'   : %d 
OPER_STATS_SZLINE_EXPIRE_MIN
	  SZLINE'   : 1 
OPER_STATS_SZLINE_EXPIRE_NONE
	  SZLINE'   :  
OPER_STATS_RESET
	 .

# MODE responses
OPER_MODE_SYNTAX
	MODE # 

# UMODE respondes
OPER_UMODE_SYNTAX
	UMODE  
OPER_UMODE_SUCCESS
	  %s.
OPER_UMODE_CHANGED
	%s    .

# OLINE responses
OPER_OLINE_SYNTAX
	OLINE  
OPER_OLINE_SUCCESS
	 %s    %s.
OPER_OLINE_IRCOP
	  IRC .

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES # [ALL]
OPER_CLEARMODES_DONE
	       %s.
OPER_CLEARMODES_ALL_DONE
	     %s.


# KICK responses
OPER_KICK_SYNTAX
	KICK #  

# SVSNICK responses
OPER_SVSNICK_SYNTAX
	SVSNICK    
OPER_SVSNICK_NEWNICK
	 %s    %s.
	
# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD|DEL|LIST|CLEAR} [ |  ]
OPER_ADMIN_SKELETON
	    skeleton;  ADMIN .
OPER_ADMIN_EXISTS
	%s      .
OPER_ADMIN_REACHED_LIMIT
	,      %d  .
OPER_ADMIN_ADDED
	%s     .
OPER_ADMIN_NOT_FOUND
	%s      .
OPER_ADMIN_NO_MATCH
	      .
OPER_ADMIN_DELETED
	%s     .
OPER_ADMIN_DELETED_ONE
	 1     .
OPER_ADMIN_DELETED_SEVERAL
	 %d     .
OPER_ADMIN_LIST_EMPTY
	   .
OPER_ADMIN_LIST_HEADER
	  :
	    
OPER_ADMIN_LIST_FORMAT
	  %3d   %s
OPER_ADMIN_CLEAR
	   .

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD|DEL|LIST|CLEAR} [ |  ]
OPER_OPER_SKELETON
	    skeleton;  OPER .
OPER_OPER_EXISTS
	%s      .
OPER_OPER_REACHED_LIMIT
	,      %d  .
OPER_OPER_ADDED
	%s     .
OPER_OPER_NOT_FOUND
	%s      .
OPER_OPER_NO_MATCH
	      .
OPER_OPER_DELETED
	%s     .
OPER_OPER_DELETED_ONE
	 1     .
OPER_OPER_DELETED_SEVERAL
	 %d     .
OPER_OPER_LIST_EMPTY
	   .
OPER_OPER_LIST_HEADER
	  :
	    
OPER_OPER_LIST_FORMAT
	  %3d   %s
OPER_OPER_CLEAR
	   .

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | CLEAR} [[+ ] { |  } []]
OPER_AKILL_EXISTS
	%s     AKILL'.
OPER_AKILL_ALREADY_COVERED
	%s   %s.
OPER_AKILL_REACHED_LIMIT
	,     %d AKILL'.
OPER_AKILL_NO_NICK
	:  AKILL'    ; ,         .
OPER_AKILL_ADDED
	%s    AKILL'.
OPER_AKILL_CHANGED
	  %s .
OPER_AKILL_NOT_FOUND
	%s     AKILL'.
OPER_AKILL_NO_MATCH
	     AKILL'.
OPER_AKILL_DELETED
	%s    AKILL'.
OPER_AKILL_DELETED_ONE
	 1    AKILL'.
OPER_AKILL_DELETED_SEVERAL
	 %d    AKILL'.
OPER_AKILL_LIST_EMPTY
	 AKILL' .
OPER_AKILL_LIST_HEADER
	  AKILL':
	                                 
OPER_AKILL_LIST_FORMAT
	  %3d   %-32s  %s
OPER_AKILL_VIEW_HEADER
	  AKILL':
# , ,  ,  ,  , 
OPER_AKILL_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_AKILL_CLEAR
	 AKILL' .
	
# SGLINE responses
OPER_CHANKILL_SYNTAX
	CHANAKILL [+expiry] {#channel} [reason]
# SGLINE responses
OPER_SGLINE_SYNTAX
	SGLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+ ] { |  }[:]]
OPER_SGLINE_UNSUPPORTED
	,  SGLINE    .
OPER_SGLINE_EXISTS
	%s     SGLINE'.
OPER_SGLINE_ALREADY_COVERED
	%s   %s.
OPER_SGLINE_REACHED_LIMIT
	,     %d SGLINE'.
OPER_SGLINE_ADDED
	%s    SGLINE'.
OPER_SGLINE_CHANGED
	  %s .
OPER_SGLINE_NOT_FOUND
	%s     SGLINE'.
OPER_SGLINE_NO_MATCH
	     SGLINE'.
OPER_SGLINE_DELETED
	%s    SGLINE'.
OPER_SGLINE_DELETED_ONE
	 1    SGLINE'.
OPER_SGLINE_DELETED_SEVERAL
	 %d    SGLINE'.
OPER_SGLINE_LIST_EMPTY
	 SGLINE' .
OPER_SGLINE_LIST_HEADER
	  SGLINE':
	                                 
OPER_SGLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SGLINE_VIEW_HEADER
	  SGLINE':
# , ,  ,  ,  , 
OPER_SGLINE_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_SGLINE_CLEAR
	 SGLINE' .

# SQLINE responses
OPER_SQLINE_SYNTAX
	SQLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+ ] { |  } []]
OPER_SQLINE_CHANNELS_UNSUPPORTED
	,  SQLINE    .
OPER_SQLINE_EXISTS
	%s     SQLINE'.
OPER_SQLINE_ALREADY_COVERED
	%s   %s.
OPER_SQLINE_REACHED_LIMIT
	,     %d SQLINE'.
OPER_SQLINE_ADDED
	%s    SQLINE'.
OPER_SQLINE_CHANGED
	  %s .
OPER_SQLINE_NOT_FOUND
	%s     SQLINE'.
OPER_SQLINE_NO_MATCH
	     SQLINE'.
OPER_SQLINE_DELETED
	%s    SQLINE'.
OPER_SQLINE_DELETED_ONE
	 1    SQLINE'.
OPER_SQLINE_DELETED_SEVERAL
	 %d    SQLINE'.
OPER_SQLINE_LIST_EMPTY
	 SQLINE' .
OPER_SQLINE_LIST_HEADER
	  SQLINE':
	                                 
OPER_SQLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SQLINE_VIEW_HEADER
	  SQLINE':
# , ,  ,  ,  , 
OPER_SQLINE_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_SQLINE_CLEAR
	 SQLINE' .

# SZLINE responses
OPER_SZLINE_SYNTAX
	SZLINE {ADD | DEL | LIST | VIEW | CLEAR} [[+ ] { |  } []]
OPER_SZLINE_UNSUPPORTED
	,  SZLINE    .
OPER_SZLINE_EXISTS
	%s     SZLINE'.
OPER_SZLINE_ALREADY_COVERED
	%s   %s.
OPER_SZLINE_REACHED_LIMIT
	,     %d SZLINE'.
OPER_SZLINE_ONLY_IPS
	:     IP    SZLINE'.
OPER_SZLINE_ADDED
	%s    SZLINE'.
OPER_SZLINE_CHANGED
	  %s .
OPER_SZLINE_NOT_FOUND
	%s     SZLINE'.
OPER_SZLINE_NO_MATCH
	     SZLINE'.
OPER_SZLINE_DELETED
	%s    SZLINE'.
OPER_SZLINE_DELETED_ONE
	 1    SZLINE'.
OPER_SZLINE_DELETED_SEVERAL
	 %d    SZLINE'.
OPER_SZLINE_LIST_EMPTY
	 SZLINE' .
OPER_SZLINE_LIST_HEADER
	  SZLINE':
	                                 
OPER_SZLINE_LIST_FORMAT
	  %3d   %-32s  %s
OPER_SZLINE_VIEW_HEADER
	  SZLINE':
# , ,  ,  ,  , 
OPER_SZLINE_VIEW_FORMAT
	%3d  %s (by %s on %s; %s)
	      %s
OPER_SZLINE_CLEAR
	 SZLINE' .

# SET responses
OPER_SET_SYNTAX
	SET  
OPER_SET_IGNORE_ON
	   .
OPER_SET_IGNORE_OFF
	    .
OPER_SET_IGNORE_ERROR
	 IGNORE     ON  OFF.
OPER_SET_READONLY_ON
	     .
OPER_SET_READONLY_OFF
	    -.
OPER_SET_READONLY_ERROR
	 READONLY     ON  OFF.
OPER_SET_LOGCHAN_ON
	       %s.
OPER_SET_LOGCHAN_OFF
	       .
OPER_SET_LOGCHAN_ERROR
	 LOGCHAN     ON  OFF      LogChannel   .
OPER_SET_DEBUG_ON
	    .
OPER_SET_DEBUG_OFF
	      .
OPER_SET_DEBUG_LEVEL
	     ( %d).
OPER_SET_DEBUG_ERROR
	 DEBUG     ON, OFF,   .
OPER_SET_NOEXPIRE_ON
	     .
OPER_SET_NOEXPIRE_OFF
	     .
OPER_SET_NOEXPIRE_ERROR
	 NOEXPIRE     ON  OFF.
OPER_SET_UNKNOWN_OPTION
	  %s.

# NOOP responses
OPER_NOOP_SYNTAX
	NOOP {SET|REVOKE} 
OPER_NOOP_SET
	 O:lines  %s .
OPER_NOOP_REVOKE
	 O:lines  %s .

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE   []
OPER_JUPE_HOST_ERROR
	      .

# RAW responses
OPER_RAW_SYNTAX
	RAW 

# UPDATE responses
OPER_UPDATING
	  .
	
# RELOAD responses
OPER_RELOAD
	     .

# RESTART responses
OPER_CANNOT_RESTART
	SERVICES_BIN  ;  .   \2configure\2   ,    RESTART.

# IGNORE respondes
OPER_IGNORE_SYNTAX
	: IGNORE {ADD|DEL|LIST|CLEAR} [] []
OPER_IGNORE_VALID_TIME
	    .
OPER_IGNORE_TIME_DONE
	 %s      %s.
OPER_IGNORE_PERM_DONE
	 %s   .
OPER_IGNORE_DEL_DONE
	 %s    .
OPER_IGNORE_LIST
	  :
OPER_IGNORE_LIST_NOMATCH
	 %s     .
OPER_IGNORE_LIST_EMPTY
	   .
OPER_IGNORE_LIST_CLEARED
	   .

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES 
OPER_KILLCLONES_UNKNOWN_NICK
	   %s.
	
# CHANLIST responses
OPER_CHANLIST_HEADER
	 :
	              
OPER_CHANLIST_HEADER_USER
	%s  :
	              
OPER_CHANLIST_RECORD
	%-20s  %4d +%-6s %s
OPER_CHANLIST_END
	  .
	
# USERLIST responses
OPER_USERLIST_HEADER
	 :
	                  
OPER_USERLIST_HEADER_CHAN
	%s  :
	                  
OPER_USERLIST_RECORD
	%-20s %s@%s
OPER_USERLIST_END
	  .

# CACHE responses
OPER_CACHE_SYNTAX
	CACHE {DEL | LIST} {  |  } [QUEUED | ALL]
OPER_CACHE_DISABLED
	  .
OPER_CACHE_NOT_FOUND
	%s    .
OPER_CACHE_REMOVED
	%s   .
OPER_CACHE_HEADER
	                                          
OPER_CACHE_LIST
	%-48s %s
OPER_CACHE_FOOTER
	  - %d/%d  .
OPER_CACHE_QUEUED
	
OPER_CACHE_PROGRESS
	
OPER_CACHE_NORMAL
	Normal
OPER_CACHE_WINGATE
	Wingate
OPER_CACHE_SOCKS4
	SOCKS 4
OPER_CACHE_SOCKS5
	SOCKS 5
OPER_CACHE_HTTP
	HTTP 
OPER_SUPER_ADMIN_ON
	  -
OPER_SUPER_ADMIN_OFF
	   
OPER_SUPER_ADMIN_SYNTAX
	 SuperAdmin    ON  OFF (    services.conf)
OPER_SUPER_ADMIN_WALL_ON
	%s  -
OPER_SUPER_ADMIN_WALL_OFF
	%s   -
OPER_SUPER_ADMIN_ONLY
	 -    .
OPER_STAFF_LIST_HEADER
	On Level Nick

# DefCon Messages

OPER_STAFF_FORMAT
	 %c %s  %s
OPER_STAFF_AFORMAT
	 %c %s  %s [%s]

# DefCon Messages

OPER_DEFCON_SYNTAX
	: DEFCON [1|2|3|4|5]
OPER_DEFCON_DENIED
	     Defcon, ,  .
OPER_DEFCON_NO_CONF
	 Defcon      services.conf
OPER_DEFCON_CHANGED
	    DEFCON %d
OPER_DEFCON_WALL
	%s   DEFCON  %d
DEFCON_GLOBAL
	 Defcon  : %d

# Module strings

OPER_MODULE_LOADED
	 %s 
OPER_MODULE_UNLOADED
	 %s 
OPER_MODULE_LOAD_FAIL
	   %s
OPER_MODULE_REMOVE_FAIL
	   %s
OPER_MODULE_LOAD_SYNTAX
	MODLOAD 
OPER_MODULE_UNLOAD_SYNTAX
	MODUNLOAD 
OPER_MODULE_LIST
	: %s
OPER_MODULE_INFO_LIST
	: %s : %s : %s : %s
OPER_MODULE_CMD_LIST
	 : /msg %s %s
OPER_MODULE_MSG_LIST
	 IRCD  : %s
OPER_MODULE_NO_LIST
	    
OPER_MODULE_NO_INFO
	     %s
OPER_MODULE_INFO_SYNTAX
	MODINFO 
MODULE_HELP_HEADER
	    :

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} []
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+ ]   
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL { | list}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE  
OPER_EXCEPTION_DISABLED
	  .
OPER_EXCEPTION_ALREADY_PRESENT
	 %s     .
OPER_EXCEPTION_TOO_MANY
	     !
OPER_EXCEPTION_ADDED
	   %s   %d.
OPER_EXCEPTION_MOVED
	  %s (#%d)    %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	   (#%d)      .
OPER_EXCEPTION_NOT_FOUND
	%s        .
OPER_EXCEPTION_NO_MATCH
	        .
OPER_EXCEPTION_DELETED
	%s       .
OPER_EXCEPTION_DELETED_ONE
	 1       .
OPER_EXCEPTION_DELETED_SEVERAL
	 %d       .
OPER_EXCEPTION_LIST_HEADER
	     :
# , 
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
OPER_EXCEPTION_LIST_COLHEAD
	    
# ,  ,  ,  , , 
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (by %s on %s; %s)
	    : %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	  .            %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	 .        ,        .

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST  | VIEW }
OPER_SESSION_LIST_SYNTAX
	SESSION LIST 
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW 
OPER_SESSION_DISABLED
	  .
OPER_SESSION_INVALID_THRESHOLD
	  .       1.
OPER_SESSION_NOT_FOUND
	%s     .
OPER_SESSION_LIST_HEADER
	    %d  :
OPER_SESSION_LIST_COLHEAD
	  
# , 
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	 %s   %d   %d  .

# EXCEPTION help

OPER_HELP_EXCEPTION
	: EXCEPTION ADD [+ ]   
	           EXCEPTION DEL { | list}
	           EXCEPTION MOVE  
	           EXCEPTION LIST [ | list]
	           EXCEPTION VIEW [ | list]
	
	     ,
	      -   , 
	 -,     , 
	  .        ,
	  ,      
	.   ,   
	/NOTICE  %S,      
	.      .
	
	EXCEPTION ADD      .
	:  !@  @ !
	  ,  box.host.dom  *.host.dom, 
	 ,      
	   .       
	 .       
	 .     0  
	   . . AKILL help    
	    .
	EXCEPTION DEL      .
	EXCEPTION MOVE        .
	      ,   .
	EXCEPTION LIST  EXCEPTION VIEW   
	;   ,    
	     . EXCEPTION VIEW 
	  ,     ,
	   ,  , , 
	,       .
	
	:    ""    ,
	  .      
	    .
	
	      .

OPER_HELP_SESSION
	: SESSION LIST 
	           SESSION VIEW 
	
	     .
	
	SESSION LIST    ,    .
	     1.  
	       
	.
	SESSION VIEW     
	 -       .
	host        (*, ?  ..).
	
	. EXCEPTION help      
	,       
	   .
	
	      .

OPER_HELP_STAFF
	: STAFF

	 ,    (, ..) 
	     .

OPER_HELP_DEFCON
	: DEFCON [1|2|3|4|5]

	 defcon      
	 ,    
	  .

OPER_HELP_DEFCON_NO_NEW_CHANNELS
	*   
OPER_HELP_DEFCON_NO_NEW_NICKS
	*   
OPER_HELP_DEFCON_NO_MLOCK_CHANGE
	*   MLOCK
OPER_HELP_DEFCON_FORCE_CHAN_MODES
	*    (%s)   
OPER_HELP_DEFCON_REDUCE_SESSION
	*     %d
OPER_HELP_DEFCON_NO_NEW_CLIENTS
	*    
OPER_HELP_DEFCON_OPER_ONLY
	*     -
OPER_HELP_DEFCON_SILENT_OPER_ONLY
	*   -
OPER_HELP_DEFCON_AKILL_NEW_CLIENTS
	*  AKILL   
OPER_HELP_DEFCON_NO_NEW_MEMOS
	*   
OPER_HELP_CHANKILL
	: CHANKILL [+] # 

	 AKILL   ,    . 
	   ident@host   ,
	    AKILL. 

###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[ - %s] %s
NEWS_OPER_TEXT
	[   - %s] %s
NEWS_RANDOM_TEXT
	[  - %s] %s

NEWS_LOGON_SYNTAX
	: LOGONNEWS {ADD|DEL|LIST} [|]
NEWS_LOGON_LIST_HEADER
	 :
NEWS_LOGON_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_LOGON_LIST_NONE
	 .
NEWS_LOGON_ADD_SYNTAX
	: LOGONNEWS ADD 
NEWS_LOGON_ADD_FULL
	  !
NEWS_LOGON_ADDED
	   (#%d).
NEWS_LOGON_DEL_SYNTAX
	: LOGONNEWS DEL { | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	   #%d  !
NEWS_LOGON_DELETED
	   #%d .
NEWS_LOGON_DEL_NONE
	 ,  !
NEWS_LOGON_DELETED_ALL
	  .

NEWS_OPER_SYNTAX
	: OPERNEWS {ADD|DEL|LIST} [|]
NEWS_OPER_LIST_HEADER
	   :
NEWS_OPER_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_OPER_LIST_NONE
	   .
NEWS_OPER_ADD_SYNTAX
	: OPERNEWS ADD 
NEWS_OPER_ADD_FULL
	  !
NEWS_OPER_ADDED
	     (#%d).
NEWS_OPER_DEL_SYNTAX
	: OPERNEWS DEL { | ALL}
NEWS_OPER_DEL_NOT_FOUND
	     #%d  !
NEWS_OPER_DELETED
	     #%d .
NEWS_OPER_DEL_NONE
	   ,  !
NEWS_OPER_DELETED_ALL
	    .

NEWS_RANDOM_SYNTAX
	: RANDOMNEWS {ADD|DEL|LIST} [|]
NEWS_RANDOM_LIST_HEADER
	  :
NEWS_RANDOM_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_RANDOM_LIST_NONE
	  .
NEWS_RANDOM_ADD_SYNTAX
	: RANDOMNEWS ADD 
NEWS_RANDOM_ADD_FULL
	  !
NEWS_RANDOM_ADDED
	    (#%d).
NEWS_RANDOM_DEL_SYNTAX
	: RANDOMNEWS DEL { | ALL}
NEWS_RANDOM_DEL_NOT_FOUND
	    #%d  !
NEWS_RANDOM_DELETED
	    #%d .
NEWS_RANDOM_DEL_NONE
	  ,  !
NEWS_RANDOM_DELETED_ALL
	   .

NEWS_HELP_LOGON
	: LOGONNEWS ADD 
	           LOGONNEWS DEL { | ALL}
	           LOGONNEWS LIST
	
	  .  
	  IRC ,    
	. (  ,     
	,    .    
	 ,    
	 .)
	
	 LOGONNEWS LIST     IRC   
	 .  ADD  DEL   
	 .

NEWS_HELP_OPER
	: OPERNEWS ADD 
	           OPERNEWS DEL { | ALL}
	           OPERNEWS LIST
	
	    .  
	 IRC  (  /OPER),  
	  . (  ,     
	,    .    
	 ,    
	 .)
	
	 OPERNEWS LIST     IRC   
	 .  ADD  DEL   
	 .

NEWS_HELP_RANDOM
	: RANDOMNEWS ADD 
	           RANDOMNEWS DEL { | ALL}
	           RANDOMNEWS LIST
	
	   .  
	  IRC ,  (  ) 
	       .
	
	 RANDOMNEWS LIST     IRC   
	 .  ADD  DEL   
	 .

###########################################################################
#
# HelpServ help message
#
###########################################################################

HELP_HELP
	%S     .
	     :

	/msg %s HELP
	   

	/msg %s HELP
	      
	     
	/msg %s HELP
	  ,    ,
	     .

HELP_HELP_BOT

	/msg %s HELP
	  ,       

HELP_HELP_HOST

	/msg %s HELP
	     for information on setting up nick vHosts

###########################################################################
#
# NickServ help messages
#
###########################################################################

NICK_HELP
	%S  ,   ""     
	  -,  .     
	    ;   
	 ,  /msg %S .
	     -
	 : /msg %S HELP .
	
	    REGISTER    
	    GROUP         
	    IDENTIFY       
	    ACCESS       
	    SET         ,   kill'
	    DROP         
	    RECOVER       ,   
	    RELEASE          RECOVER
	    SENDPASS    ?   
	
	 : GHOST, ALIST, GLIST, INFO, LIST, LOGOUT, 
	                STATUS
	
	:     ,   IRC  
	    .
	NickServ     "" ,
	"" (   )    .
	 %S ,  ,    ().
	
NICK_HELP_EXPIRES
	
	      
	    -   ,    
	  %d .

NICK_HELP_REGISTER
	: REGISTER  [email]
	
	      %S.   ,  
	 ,     SET  ACCESS,
	       .
	  ,     !  
	,      . ,   
	  - .
	(:    !  MYPASSWORD, MyPassword,  mypassword -   !)
	  :
	
	     .  ,
	       -  .

	     -      ,
	 %S    .  , 
	      
	,     
	 5 .      
	.      
	 .
	
	 email  . 
	,   ,   
	  .
	   ;  e-mail   
	  .
	
	        ,	      ,   
	     -       ;
	         ,       ,        , 
	      .     
	 /msg %S HELP GROUP.
	
NICK_HELP_GROUP
	: GROUP _ 
	
	         _ 
	 -    .
	
	      ,
	             
	 !
	 
	    ,  .
	   ()     ,   
	      , ,
	     1 .
	
	    ,       
	 .     ,  
	    .  
	/msg %S HELP IDENTIFY     . ,  ,
	    IRC    .
	
	,      
	,         
	 .          ( 
	   )     IRC  
	.
	
	       .  
	.
	
	:       .

NICK_HELP_IDENTIFY
	: IDENTIFY 
	
	 %S     
	.     ,  
	    .   
	  ,     
	  REGISTER.
	
NICK_HELP_UPDATE
	: UPDATE

	   , ..    ,
	     (ModeonID)   
	    (     IRC,  ..).

NICK_HELP_LOGOUT
	: LOGOUT
	
	   ,    IDENTIFY, ..
	     . 
	:   ,     ,  
	 .

NICK_HELP_DROP
	: DROP [nickname]
	
	      %S.     
	     .
	
	       ,        ,
	     ,     .
	
	   :    
	 NickServ (/msg %S HELP IDENTIFY   
	).

NICK_HELP_ACCESS
	: ACCESS ADD mask
	           ACCESS DEL mask
	           ACCESS LIST
	
	        .   
	 ,    
	%S  ,      . 
	      ,  
	  IDENTIFY  %S
	 .
	
	:
	
	    ACCESS ADD anyone@*.bepeg.com
	       anyone   
	      bepeg.com.
	
	    ACCESS DEL anyone@*.bepeg.com
	      .
	
	    ACCESS LIST
	        .

NICK_HELP_SET
	: SET  
	
	   .    :
	
	    DISPLAY       
	    PASSWORD        
	    LANGUAGE    ,    
	                 
	    URL         URL   
	    EMAIL       E-mail   
	    ICQ          ICQ   
	    GREET          
	    KILL             , 
	    SECURE           
	    PRIVATE          
	               /msg %S LIST
	    HIDE           
	    MSG              -   
	
	   ,    
	   (/msg %S HELP IDENTIFY   
	).
	
	 /msg %S HELP SET     
	  .

NICK_HELP_SET_DISPLAY
	: SET DISPLAY __
	
	     .  
	       .

NICK_HELP_SET_PASSWORD
	: SET PASSWORD _
	
	 ,     
	 .

NICK_HELP_SET_LANGUAGE
	: SET LANGUAGE 
	
	 ,      
	 (,      ).
	      
	 :
	

NICK_HELP_SET_URL
	: SET URL url
	
	 URL   .   URL
	 ,  -  
	      INFO.

NICK_HELP_SET_EMAIL
	: SET EMAIL c@email
	
	  E-mail   .  
	 ,  -  
	      INFO.
	
NICK_HELP_SET_ICQ
	: SET ICQ  ICQ
	
	  ICQ   .  
	 ,  -  
	      INFO.
	
NICK_HELP_SET_GREET
	: SET GREET 
	
	    , 
	          GREET;
	,       
	   ,   .

NICK_HELP_SET_KILL
	: SET KILL {ON | QUICK | IMMED | OFF}
	
	     :
	  .      ON,   
	   ,    1   , 
	   ,   %S 
	 .
	
	   QUICK,     20 
	  .    
	IMMED,       
	    ; 
	     . , 
	 IRC     .

NICK_HELP_SET_SECURE
	: SET SECURE {ON | OFF}
	
	      %S  
	.   SECURE,     NickServ
	 ,      ,
	        .
	  ,      , %S
	         
	 KILL.

NICK_HELP_SET_PRIVATE
	: SET PRIVATE {ON | OFF}
	
	 %S     on  off   .
	 PRIVATE ,     
	  %S's LIST.
	(  , ,       
	  ,   INFO.)

NICK_HELP_SET_HIDE
	: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	      , 
	    %S INFO   .
	     email (EMAIL),     
	      (USERMASK)     (QUIT).
	      
	 (OFF)   (ON).
	
NICK_HELP_SET_MSG
	: SET MSG {ON | OFF}
	
	       .
	   MSG,      ,    
	  .

NICK_HELP_RECOVER
	: RECOVER  []
	
	    ,  - 
	 ; %S    
	     .
	
	   , %S  
	  .   IRC  
	    .  
	      ,  ,
	         ;
	       . ,   
	 RELEASE (/msg %S HELP RELEASE)    
	.
	
	   RECOVER,   , 
	  /WHOIS     ,
	   ,    ,
	 ,       
	 .

NICK_HELP_RELEASE
	: RELEASE  []
	
	 %S  ,   ,
	      RECOVER.
	 ,    ;
	     .
	
	   RELEASE  : 
	 ,     /WHOIS     
	  ,        
	 ,       
	 .

NICK_HELP_GHOST
	: GHOST  []
	
	 "" IRC ,   .
	""  -      ,
	  IRC  ,     .
	  ,    ,
	       
	   ,     IRC.
	
	   GHOST  : 
	 ,     /WHOIS     
	  ,        
	 ,       
	 .

NICK_HELP_INFO
	: INFO  [ALL]
	
	   , 
	,     ,     IRC,
	 .     ,  
	        ALL, 
	   ;        
	 .

NICK_HELP_LIST
	: LIST 
	
	    ,  
	 ,   nick!user@host. ,    
	PRIVATE   .
	
	:
	
	    LIST *!joeuser@foo.com
	      ,     joeuser@foo.com.
	
	    LIST *Bot*!*@*
	          Bot  
	     ( ).
	
	    LIST *!*@*.bar.org
	      ,  
	      bar.org.

NICK_HELP_ALIST
	: ALIST [level]
	
	  ,      . ,   
	    XOP  ACCESS.  
	 ,       .

	:
	        ALIST Founder
	          ,    
	         ().

	        ALIST AOP
	          ,     
	         .

	        ALIST 10
	          ,      10
	         .
	
	,   NOEXPIRE     
	  .
	
NICK_HELP_GLIST
	Syntax: GLIST
	
	     .

NICK_HELP_STATUS
	: STATUS ...
	
	    
	     .  
	 :
	
	     -
	
	   ,      , 
	-    :
	
	    0 -          
	    1 -      
	    2 -         
	    3 -        
	
	 16       ;
	  .      , 
	      .
	
NICK_HELP_SENDPASS
	: SENDPASS nickname
	
	     e-mail
	   .     
	   .
	
	       IRC    .
	
	      .

NICK_SERVADMIN_HELP
	
	    :
	
	    GETPASS      
	                 (   )
	    FORBID        
	
	        
	 ,        
	(/msg %S ACCESS LIST ).

NICK_SERVADMIN_HELP_LOGOUT
	: LOGOUT [ [REVALIDATE]]
	
	 ,   IDENTIFY ,
	..      .
	, ,     
	.
	
	 ,      .  
	   REVALIDATE,     
	.      .

NICK_SERVADMIN_HELP_DROP
	: DROP []
	
	 ,    
	  %S.
	
	 ,      .
	          - 
	 .     
	 .

NICK_SERVADMIN_HELP_SET
	
	      NOEXPIRE, 
	   .
	 ,        
	   ,  
	SET   .

NICK_SERVADMIN_HELP_SET_NOEXPIRE
	: SET [] NOEXPIRE {ON | OFF}
	
	      -   .  ,
	  ON    .  
	 ,  -     .
	
	    .

NICK_SERVADMIN_HELP_INFO
	
	     ALL   .

NICK_SERVADMIN_HELP_LIST
	: LIST  [FORBIDDEN] [NOEXPIRE]
	
	     which  
	 ,   nick!user@host. ,    
	PRIVATE     . 
	   NOEXPIRE     ! 
	.
	
	   FORBIDDEN  NOEXPIRE,   
	,    FORBIDden  NOEXPIRE.
	    - 
	   .      
	 .
	
	:
	
	    LIST *!joeuser@foo.com
	       ,    joeuser@foo.com.
	
	    LIST *Bot*!*@*
	       ,     Bot
	    (   ).
	
	    LIST * NOEXPIRE
	           
	    NOEXPIRE.

NICK_SERVADMIN_HELP_ALIST
	: ALIST [] []
	
	    ,    . 
	 ,  ,    nickname.
	    ,   nickname  
	level  .

	      .

NICK_SERVADMIN_HELP_GLIST
	: GLIST []
	
	 ,   
	  .
	
	 ,   ,   
	  .
	      .

NICK_SERVADMIN_HELP_GETPASS
	: GETPASS 
	
	   .   
	  , ,  ,
	    ,     
	       WALLOPS/GLOBOPS.
	
	      .
	
	  ,   .

NICK_SERVADMIN_HELP_GETEMAIL
	: GETEMAIL user@emailhost

	 ,       email. 
	      user   emailhost.  
	   , ,  , 
	   email    .

	      .

NICK_SERVADMIN_HELP_FORBID
	: FORBID  []
	
	    
	      (DROP).
	
	      .
	
	      .

###########################################################################
#
# ChanServ help messages
#
###########################################################################

CHAN_HELP
	%S      
	.  %S  
	  ,  "" , 
	     . 
	  ;    
	/msg %S .      
	,  /msg %S HELP .
	
	    REGISTER    
	    IDENTIFY      
	    SET              
	    AOP          AOP'
	    SOP          SOP'
	    ACCESS        
	    LEVELS        
	    AKICK        
	    DROP            ChanServ
	    SENDPASS      
	
	 : BAN, CLEAR, DEOP, DEVOICE, GETKEY, INFO, 
	                INVITE, KICK, LIST, LOGOUT, OP, TOPIC, 
	                UNBAN, VOICE, VOP

CHAN_HELP_UNREAL
	
	     :
	DEHALFOP, DEOWNER, DEPROTECT, HALFOP, HOP, OWNER,
	PROTECT

CHAN_HELP_ULTIMATE
	
	     :
	DEHALFOP, HALFOP, HOP

CHAN_HELP_ULTIMATE3
	
	      :
	    DEHALFOP, HALFOP, HOP, ADMIN, DEADMIN

CHAN_HELP_EXPIRES
	
	,   ,     %d 
	(..   ,     
	      )   .

CHAN_HELP_REGISTER
	: REGISTER #  
	
	     %S.    
	    ,  
	 .   
	   IDENTIFY,   
	   .
	  (),    ,
	   , ,  .
	
	   ,       
	 "" .    
	   ;
	%S      
	     .
	  ACCESS (/msg %S HELP ACCESS) 
	    ,    
	    .
	
	:   , 
	    .      ,
	/msg %s HELP     ,   .

CHAN_HELP_IDENTIFY
	: IDENTIFY # 
	
	   %S   
	.     ,   
	.     , 
	 ,    REGISTER.
	
CHAN_HELP_LOGOUT
	: LOGOUT # 
	
	      
	  .
	
	   ,     ,
	    .

CHAN_HELP_DROP
	: DROP #
	
	  .     
	 ,      IDENTIFY.

CHAN_HELP_SET
	: SET #  
	
	     
	  .
	
	 :
	
	    FOUNDER         
	    SUCCESSOR       
	    PASSWORD        
	    DESC            
	    URL            URL 
	    EMAIL           E-mail  
	    ENTRYMSG       ,   
	                  ,   
	    BANTYPE            
	    MLOCK              
	    KEEPTOPIC      ,    
	    OPNOTICE          OP/DEOP
	    PEACE            
	    PRIVATE             LIST
	    RESTRICTED       
	    SECURE           %S'  .
	    SECUREOPS         
	    SECUREFOUNDER     
	    SIGNKICK             KICK
	    TOPICLOCK           TOPIC
	    XOP             
	
	 /msg %S HELP      
	  .

CHAN_HELP_SET_FOUNDER
	: SET # FOUNDER 
	
	  .    
	 .

CHAN_HELP_SET_SUCCESSOR
	: SET # SUCCESSOR 
	
	  .    
	  ,   ,
	    .
	  ,    
	   ( %d),   ,
	 ,       .  
	   .

CHAN_HELP_SET_PASSWORD
	: SET # PASSWORD 
	
	 ,   
	    .

CHAN_HELP_SET_DESC
	: SET # DESC 
	
	  ,     
	 LIST  INFO.

CHAN_HELP_SET_URL
	: SET # URL [http://.]
	
	 URL .  URL
	 ,  -    
	   INFO.     ,
	  URL .

CHAN_HELP_SET_EMAIL
	: SET # EMAIL [@]
	
	    .
	   ,  - 
	      INFO.  
	  ,   email
	.

CHAN_HELP_SET_ENTRYMSG
	: SET # ENTRYMSG []
	
	 ,    
	    .     ,
	  .

CHAN_HELP_SET_BANTYPE
	: SET # BANTYPE  
	
	  ,   , 
	-      .
	
	      0  3 :
	
	0:   *!user@host
	1:   *!*user@host
	2:   *!*@host
	3:   *!*user@*.domain

CHAN_HELP_SET_KEEPTOPIC
	: SET # KEEPTOPIC {ON | OFF}
	
	      
	.    ,  
	    %S   , 
	   ,   
	    -  .

CHAN_HELP_SET_TOPICLOCK
	: SET # TOPICLOCK {ON | OFF}
	
	       .
	   , %S  
	     
	TOPIC.

CHAN_HELP_SET_MLOCK
	: SET # MLOCK 
	
	     . %S
	    ,   
	, ,     /.
	
	     
	/MODE; ,   +  
	 ,  ,   -   . :
	  ,     ,   /MODE, 
	SET MLOCK    
	   !
	
	:        ,   
	 ,      RESTRICTED
	  (. HELP SET RESTRICTED),  ,    
	      !
	
	:
	
	    SET # MLOCK +nt-iklps
	       n  t,   i, k, l, p,  s.
	     m    /  .
	
	    SET # MLOCK +knst-ilmp --
	       k, n, s,  t,   i, l, m,  p.
	          
	    "--".
	
	    SET # MLOCK +
	      ;      
	       .

CHAN_HELP_SET_PEACE
	: SET # PEACE {ON | OFF}
	
	      .
	  ,    ,
	          
	    %S.

CHAN_HELP_SET_PRIVATE
	: SET # PRIVATE {ON | OFF}
	
	      .
	  ,  /msg %S LIST  
	   .

CHAN_HELP_SET_RESTRICTED
	: SET # RESTRICTED {ON | OFF}
	
	     
	.    , ,
	       
	(    , , 
	         ) 
	     .

CHAN_HELP_SET_SECURE
	: SET # SECURE {ON | OFF}
	
	     %S 
	.  SECURE ,  
	  , 
	 %s      
	   .

CHAN_HELP_SET_SECUREOPS
	: SET # SECUREOPS {ON | OFF}
	
	      .
	    , ,   
	         .
	
CHAN_HELP_SET_SECUREFOUNDER
	: SET # SECUREFOUNDER {ON | OFF}
	
	      .
	   ,   
	  ,   ,    
	,   ,    %S.
	
CHAN_HELP_SET_SIGNKICK
	: SET # SIGNKICK {ON | LEVEL | OFF}
	
	    
	 .  SIGNKICK ,   
	%S KICK  "" ,    
	  .
	
	   LEVEL, ,       
	 (    ) 
	  . . /msg %S HELP LEVELS     .

CHAN_HELP_SET_XOP
	: SET # XOP {ON | OFF}
	
	      xOP  .
	 XOP ,      AOP/SOP/VOP
	     ,
	  ,     ACCESS.
	
	 :       xOP,
	        ,
	      , 
	    ACCESS! 
	
	,     ,       xOP 
	     ACCESS  xOP,  
	     ... ,   
	  xOP     , 
	 LEVELS.
	
	   xOP   ACCESS 
	  .

CHAN_HELP_SET_OPNOTICE
	: SET # OPNOTICE {ON | OFF}
	
	   -  .
	 - , %S   
	   -   OP  DEOP
	 .

CHAN_HELP_AOP
	: AOP # ADD 
	           AOP # DEL {nick | - | list}
	           AOP # LIST [ | list]
	           AOP # CLEAR
	
	  AOP () . AOP 
	        ,
	   ,   ,  
	   ,   .
	
	 AOP ADD     
	AOP'.
	
	 AOP DEL     
	AOP'.      , 
	  . (.   LIST .)
	
	 AOP LIST   AOP'. 
	  ,     
	 .     ,
	    ; :

	   AOP # LIST 2-5,7-9
	    AOP',   2  5  
	   7  9.
	      
	 AOP CLEAR     
	AOP'.
	
	 AOP ADD  AOP DEL   
	SOP'  ,   AOP CLEAR   
	 .   ,    
	AOP'    AOP LIST.
	
	       , 
	       (access list). . 
	/msg %S HELP ACCESS       ,
	 /msg %S HELP SET XOP      
	    xOP.

CHAN_HELP_HOP
	: HOP # ADD 
	           HOP # DEL { |   | list}
	           HOP # LIST [ | list]
	           HOP # CLEAR
	
	  HOP () .  HOP 
	 ,     
	 .
	
	 HOP ADD     
	HOP'.
	
	 HOP DEL     
	HOP'.      , 
	  . (.   LIST .)
	
	 HOP LIST   HOP'. 
	  ,     
	 .     ,
	    ; :

	   HOP # LIST 2-5,7-9
	     HOP'    2  5  
	   7  9.
	      
	 HOP CLEAR     
	HOP'.
	
	 HOP ADD  HOP DEL   
	AOP'  ,   HOP CLEAR   
	 .
	
	       , 
	       (access list). . 
	/msg %S HELP ACCESS       ,
	 /msg %S HELP SET XOP      
	    xOP.

CHAN_HELP_SOP
	: SOP # ADD 
	           SOP # DEL { |   | list}
	           SOP # LIST [ | list]
	           SOP # CLEAR
	
	  SOP () .  SOP'
	 ,      AOP',   
	      , 
	    ,   .
	
	 SOP ADD     
	SOP'.
	
	 SOP DEL     
	SOP'.      , 
	  . (.   LIST .)
	
	 SOP LIST   SOP'. 
	  ,     
	 .     ,
	    ; :

	   SOP # LIST 2-5,7-9
	     AOP'     2  5  
	   7  9.
	      
	 SOP CLEAR     
	SOP'.
	
	 SOP ADD, SOP DEL  SOP CLEAR   
	  .   ,    
	AOP'    SOP LIST.
	
	       , 
	       (access list). . 
	/msg %S HELP ACCESS       ,
	 /msg %S HELP SET XOP      
	    xOP.

CHAN_HELP_VOP
	: VOP # ADD 
	           VOP # DEL { |   | list}
	           VOP # LIST [ | list]
	           VOP # CLEAR
	
	  VOP () .  
	 VOP  ,    
	   .
	
	 VOP ADD     
	VOP'.
	
	 VOP DEL     
	VOP'.      , 
	  . (.   LIST .)
	
	 VOP LIST   VOP'. 
	  ,     
	 .     ,
	    ; :

	   VOP # LIST 2-5,7-9
	     VOP'     2  5  
	   7  9.
	      
	 VOP CLEAR     
	VOP'.
	
	 VOP ADD  VOP DEL   
	AOP'  ,   VOP CLEAR   
	 .
	
	       , 
	       (access list). . 
	/msg %S HELP ACCESS       ,
	 /msg %S HELP SET XOP      
	    xOP.

CHAN_HELP_ACCESS
	: ACCESS # ADD  
	           ACCESS # DEL { |   | list}
	           ACCESS # LIST [ | list]
	           ACCESS # CLEAR
	
	   .  
	      ,
	    %S  .   
	        
	; /msg %S HELP ACCESS LEVELS   
	 . ,      
	     0.
	
	 ACCESS ADD    
	     ;    
	   ,      
	  .  
	     ,   , 
	      , 
	      ,   
	,   .
	
	 ACCESS DEL    
	 .    ,  
	 . (.    LIST .)
	
	 ACCESS LIST   . 
	  ,     
	 .    ,  ,
	   ; :

	   ACCESS # LIST 2-5,7-9
	          2  5  
	   7  9.
	      
	 ACCESS CLEAR    
	 .

CHAN_HELP_ACCESS_LEVELS
	  
	
	 ,     :
	
	   Founder       %S;  
	                          . ,
	                           
	                      (     
	                     ACCESS).
	        10      AKICK; .
	         5   .
	         3   .
	         0     ;    
	                      (     ).
	        <0        .
	
	    ,    , 
	 LEVELS;  /msg %S HELP LEVELS   
	.

CHAN_HELP_AKICK
	: AKICK # ADD  []
	           AKICK # STICK 
	           AKICK # UNSTICK 
	           AKICK # DEL 
	           AKICK # LIST []
	           AKICK # VIEW []
	           AKICK # ENFORCE
	           AKICK # CLEAR
	
	   .  ,
	       ,
	%S    ,   
	.
	
	 AKICK ADD    
	  .   ,
	   ,   
	;    ,     : "You have been
	banned from the channel".
	
	 AKICK STICK     
	 .  -    , %S
	   .    
	  .
	
	 AKICK UNSTICK  ,  
	AKICK STICK,      
	 .
	
	 AKICK DEL     
	  .   ,    
	 ;    
	.
	
	 AKICK LIST    , 
	    
	.
	
	 AKICK VIEW     
	AKICK LIST.
	
	 AKICK ENFORCE  %S 
	       , 
	 .
	
	 AKICK CLEAR   
	  .

CHAN_HELP_LEVELS
	: LEVELS # SET  
	           LEVELS # {DIS | DISABLE} 
	           LEVELS # LIST
	           LEVELS # RESET
	
	 LEVELS    
	,    .  
	,     ,   
	 %S'. ( SET FOUNDER  SET PASSWORD,
	   ,   
	 .)
	
	LEVELS SET        .
	LEVELS DISABLE ( DIS -   ;)
	      
	,   .
	LEVELS LIST        
	 . LEVELS RESET    
	     (.
	HELP ACCESS LEVELS).
	
	   ,      ,
	. HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	  . :
	        ,
	       .

CHAN_HELP_LEVELS_DESC_FORMAT
	    %-*s  %s

CHAN_HELP_INFO
	: INFO # [ALL]
	
	    ,
	  ,  ,   
	 , ,  ,     .  
	  ALL,      
	.
	
	 ,  ALL   
	 .

CHAN_HELP_LIST
	: LIST 
	
	       .
	(    PRIVATE   .)

CHAN_HELP_OP
	: OP [# []]
	
	        .    ,
	    .      ,
	     ,     
	  .
	
	 ,    AOP'      5
	 .

CHAN_HELP_DEOP
	: DEOP [# []]
	
	         .    ,
	    .   ,    ,  ,
	     ,      
	 .
	
	 ,    AOP'      5
	 .
	
CHAN_HELP_VOICE
	: VOICE [# []]
	
	      .    ,
	  .      ,
	     ,     
	  .
	
	 ,    AOP'      5
	 .    VOP' (      3)
	    .

CHAN_HELP_DEVOICE
	: DEVOICE [# []]
	
	       .    ,
	   .      ,
	      ,     
	  .
	
	 ,    AOP'      5
	 .    VOP' (      3)
	    .
	
CHAN_HELP_HALFOP
	: HALFOP [# []]
	
	        .    ,
	    .      ,
	     ,     
	  .
	
	 ,    AOP'      5
	 .    HOP' (      4)
	    .

CHAN_HELP_DEHALFOP
	: DEHALFOP [# []]
	
	         .    ,
	    .   ,    ,  ,
	     ,      
	 .
	
	 ,    AOP'      5
	 .    HOP' (      4)
	     .
	
CHAN_HELP_PROTECT
	: PROTECT [# []]
	
	       .    ,
	   .      ,
	      ,     
	  .
	
	      . SOP'    
	 10         .

CHAN_HELP_DEPROTECT
	: DEPROTECT [# []]
	
	       .    ,
	   .      ,
	      ,     
	  .
	
	      . SOP'    
	 10         .

CHAN_HELP_OWNER
	: OWNER [#]
	
	    .    ,
	      ,    
	   .
	
	      .

CHAN_HELP_DEOWNER
	: DEOWNER [#]
	
	     .    ,
	       ,    
	   .
	
	      .

CHAN_HELP_INVITE
	: INVITE 
	
	 %S     .  
	
	 ,     AOP'      5
	 .

CHAN_HELP_UNBAN
	: UNBAN 
	
	 %S      ,  
	   .  
	
	 ,     AOP'      5
	 .
	
CHAN_HELP_KICK
	: KICK [# [ []]]
	
	     .    ,
	 .      ,
	    ,       
	.
	
	 ,     AOP'      5
	 .

CHAN_HELP_BAN
	: BAN [# [ []]]
	
	     .    ,
	 .      ,
	    ,      
	 .
	
	 ,     AOP'      5
	 .

CHAN_HELP_TOPIC
	: TOPIC # []
	
	 %S     
	.    ,    
	.         
	 SET TOPICLOCK.  /msg %S HELP SET TOPICLOCK
	   .
	
	 ,    
	 . 

CHAN_HELP_CLEAR
	: CLEAR # _
	
	 %S      .  _
	   :
	
	     MODES        (.. 
	               i,k,l,m,n,p,s,t).
	     BANS         .
	     EXCEPTS        .
	     OPS         ( +o) 
	                .
	     VOICES    "" ( +v)  , 
	                  .
	     USERS     ()    .
	
	 ,    
	 . 
	
CHAN_HELP_GETKEY
	: GETKEY #
	
	   (  ) .  
	   / ,  
	 :
	
	KEY <#> < >
	
	     "NO KEY"  -    .
	
CHAN_HELP_SENDPASS
	: SENDPASS #
	
	     e-mail,
	    .    
	   .
	
	        IRC .
	
	     .

CHAN_SERVADMIN_HELP
	
	     :
	
	    GETPASS       
	               (   )
	    FORBID       
	    SUSPEND        
	                  .
	    UNSUSPEND     .
	    STATUS          
	                 .
	
	       
	   ,    ,  ,
	     .
	
CHAN_SERVADMIN_HELP_LOGOUT
	: LOGOUT # []
	
	    
	  .
	
	   ,    ,
	 ,  .
	
	   ,   
	     -  
	 . ,     ;
	       .

CHAN_SERVADMIN_HELP_DROP
	: DROP #
	
	  .   
	  ,    ChanServ  .

CHAN_SERVADMIN_HELP_SET
	
	      NOEXPIRE,
	  ,     .
	,      
	       .

CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	: SET # NOEXPIRE {ON | OFF}
	
	   .   
	  ON    .
	
	     .

CHAN_SERVADMIN_HELP_INFO
	
	     ALL   .

CHAN_SERVADMIN_HELP_LIST
	: LIST  [FORBIDDEN] [SUSPENDED] [NOEXPIRE]
	
	      .
	   PRIVATE   
	 .    NOEXPIRE 
	   !   .
	
	   FORBIDDEN, SUSPENDED  NOEXPIRE 
	      FORBID, SUSPEND 
	NOEXPIRE .     ,
	    .    
	  .

CHAN_SERVADMIN_HELP_GETPASS
	: GETPASS #
	
	   .  
	  , ,  ,
	    ,     ,
	      WALLOPS/GLOBOPS.
	
	      .

CHAN_SERVADMIN_HELP_FORBID
	: FORBID # []
	
	     .
	   .
	
	      .
	
	      .

CHAN_SERVADMIN_HELP_SUSPEND
	: SUSPEND # []
	
	     .
	    UNSUSPEND, 
	     .
	
	      .
	
	      .

CHAN_SERVADMIN_HELP_UNSUSPEND
	: UNSUSPEND #
	
	  .    
	   .
	
	      .

CHAN_SERVADMIN_HELP_STATUS
	: STATUS # 
	
	      
	 .    :
	
	    STATUS #   
	
	  ,   :
	
	    STATUS ERROR   
	
	    .

###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP
	%S   ,   IRC 
	   ,       ,
	  (*).  ,  
	      
	,   .

	%S's  :

	    SEND        
	    CANCEL     
	    LIST     
	    READ    
	    DEL     
	    SET       
	    INFO       

MEMO_HELP_ADMIN
	    SENDALL      

MEMO_HELP_OPER
	    STAFF     / 

MEMO_HELP_FOOTER
	
	 /msg %S HELP     
	.

	(*)  ,        
	      10   ,  .   
	       %s LEVELS.

MEMO_HELP_SEND
	: SEND { | #}  
	
	      #, 
	 .   ,    
	    . ,     ,
	    NickServ  ChanServ .
	
MEMO_HELP_CANCEL
	: CANCEL { | #}
	
	  ,      ,
	    .

MEMO_HELP_LIST
	: LIST [#] [list | NEW]
	
	   .   NEW,  
	 () .        "*"
	   .     
	,  :

	   LIST 2-5,7-9
	      2  5   7  9.

MEMO_HELP_READ
	: READ [#] { | list | LAST | NEW}
	
	   .    LAST, 
	    .   
	NEW,      . ,
	     .     
	,  :
	
	   READ 2-5,7-9
	      2  5   7  9.

MEMO_HELP_DEL
	: DEL [#] { | list | LAST | ALL}
	
	  .   
	      ,  
	  ,     .
	
	   LAST,    .
	   ALL,     .
	
	:
	
	   DEL 1
	       1.
	
	   DEL 2-5,7-9
	      2  5   7  9.

MEMO_HELP_SET
	: SET  
	
	     .     :
	
	    NOTIFY         
	                   (  )
	    LIMIT           , 
	                  
	
	 /msg %S HELP SET      
	  .

MEMO_HELP_SET_NOTIFY
	: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	      :
	
	    ON               ,
	                  /AWAY,    -  
	            .
	    LOGON             ,
	                   /AWAY.
	    NEW             ,
	              .
	    OFF            .
	
	 , ON   LOGON  NEW.

MEMO_HELP_SET_LIMIT
	: SET LIMIT [#] limit
	
	      ( )
	 .      0, 
	    . ,     
	,  %d.

MEMO_HELP_INFO
	: INFO [#]
	
	      , 
	  ,      
	.  ,    
	  .

MEMO_SERVADMIN_HELP_SET_LIMIT
	: SET LIMIT [ | #] {limit | NONE} [HARD]
	
	      ( )
	 .    0   
	  ;   NONE 
	     ,   . 
	     ,     
	.
	
	 HARD     . 
	HARD   -   , ..  
	  (       
	HARD).
	
	  SET LIMIT    
	.        
	  ,       ,  
	  ,      %d,   
	  HARD.

MEMO_SERVADMIN_HELP_INFO
	: INFO [ | #]
	
	 ,      ,
	   ,   
	   .
	
	  ,    
	  .
	
	  ,    
	  .      
	.

MEMO_HELP_STAFF
	: STAFF  

	  /  ,   .
	:    ,   ,  
	,     .  
	        
	      .

MEMO_HELP_SENDALL
	: SENDALL  

	     .

###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP
	%S commands:
	    GLOBAL         
	    STATS           
	    OPER LIST     
	    ADMIN LIST    
	    STAFF              -

OPER_HELP_OPER_CMD
	,       :
	    MODE           
	    KICK           
	    CLEARMODES     
	    KILLCLONES       
	    AKILL         AKILL'
	    SGLINE        SGLINE'
	    SQLINE        SQLINE'
	    SZLINE        SZLINE'

OPER_HELP_ADMIN_CMD
	,    :
	    OPER           
	    SVSNICK       
	    CHANLIST       
	    USERLIST       
	    LOGONNEWS        
	    RANDOMNEWS    
	                       
	    OPERNEWS     ,   /oper
	    SESSION        
	    EXCEPTION        
	    CACHE         ,   
	    NOOP           O:  
	                    
	    JUPE        "" 
	    IGNORE         
	    UMODE         
	    OLINE         IRC    ( 
	                    UnrealIRCd)
	    SET            
	    RELOAD         
	    UPDATE         
	                        
	    RESTART          
	    QUIT             
	    SHUTDOWN         
	    DEFCON        DefCon
	    CHANKILL         

	,    :
	    ADMIN          

OPER_HELP_ROOT_CMD
	,    :
	    MODLOAD      
	    MODUNLOAD    
	    MODLIST       
	    MODINFO        

OPER_HELP_LOGGED
	:   %S'   !

OPER_HELP_GLOBAL
	: GLOBAL 
	
	 IRC      IRC .
	      %s.

OPER_HELP_STATS
	: STATS [AKILL | ALL | RESET]
	
	 ,     
	IRC    ( ),   
	     ,  
	  .
	
	  AKILL,     AKILL'
	   AKILL'  .
	
	 ALL     , 
	     . 
	         
	 ,      !
	
	 RESET     
	   .
	
	UPTIME    STATS.

OPER_HELP_OPER
	: OPER ADD 
	           OPER DEL { |   | list}
	           OPER LIST [ | list]
	           OPER CLEAR
	
	    
	 . ,  
	    ,  
	%s      .
	
	 OPER ADD     
	 .
	
	 OPER DEL     
	 .    , 
	   . (.    LIST .)
	
	 OPER LIST    .
	   ,   
	  .    ,
	    ; :

	   OPER LIST 2-5,7-9
	          2 
	   5   7  9.
	      
	 OPER CLEAR     
	 .
	
	 IRC     OPER LIST.
	       .

OPER_HELP_ADMIN
	: ADMIN ADD 
	           ADMIN DEL { |   | list}
	           ADMIN LIST [ | list]
	           ADMIN CLEAR
	
	      
	   . ,  
	       
	%s      .
	
	 ADMIN ADD     
	 .
	
	 ADMIN DEL     
	 .   () (),
	   . (.    LIST .)
	
	 ADMIN LIST    .  
	   ,     
	 .    , 
	   ; :

	   ADMIN LIST 2-5,7-9
	             2 
	      5   7  9.
	      
	 ADMIN CLEAR     
	 .
	
	 IRC     ADMIN LIST.
	     .

OPER_HELP_IGNORE
	: IGNORE {ADD|DEL|LIST|CLEAR} [] []

	       
	      .     
	 - .       , :
	s , m , h  
	d .      .  
	  ,     0.

OPER_HELP_MODE
	: MODE # 
	
	       
	.     ,    
	 /MODE.
	
	      .

OPER_HELP_UMODE
	: UMODE  
	
	        .
	    ,    
	 /MODE.
	
	      .

OPER_HELP_OLINE
	: OLINE  
	
	     IRC   .
	     "+"  "-". 
	  ,  "-"   .

	      .

OPER_HELP_CLEARMODES
	: CLEARMODES # [ALL]
	
	    (i,k,l,m,n,p,s,t)    
	.    ALL,       ,
	 ( +o  +v)  .
	
	      .

OPER_HELP_KICK
	: KICK #  
	
	 IRC      .
	    ,      /KICK.
	     IRC ,  
	   , :
	
	*** SpamMan has been kicked off channel #my_channel by %S (Alcan (Flood))
	
	      .

OPER_HELP_SVSNICK
	: SVSNICK   
	
	    .
	
	      .

OPER_HELP_AKILL
	: AKILL ADD [+ ]  
	           AKILL DEL { |   | list}
	           AKILL LIST [ | list]
	           AKILL VIEW [ | list]
	           AKILL CLEAR
	
	     AKILL'. 
	,    AKILL'  , 
	   KILL, ,   IRC   ,
	    IRC  K-line 
	  .
	
	AKILL ADD    user@host/ip   AKILL'
	   (    ).
	  -   ,     : d 
	(), h (),  m ().  ( ,  
	1h30m)  .     ,
	      "" (  +30   30 
	).    AKILL,     +0. 
	  to  ,   +,  
	   .   AKILL'
	    
	STATS AKILL.
	
	 AKILL DEL     
	AKILL'.    ,
	   . (.    LIST 
	.)
	
	 AKILL LIST    AKILL'.  
	   ,      
	.    , ,
	   ; :

	   AKILL LIST 2-5,7-9
	    AKILL'     2  5   7 
	    9.
	      
	AKILL VIEW    ,  AKILL LIST, 
	    AKILL,   AKILL', 
	 ,       user@host/ip   AKILL'.
	
	AKILL CLEAR      AKILL'.
	
	      .
	
OPER_HELP_SGLINE
	: SGLINE ADD [+ ] :
	    	   SGLINE DEL { |   | list}
	           SGLINE LIST [ | list]
	           SGLINE VIEW [ | list]
	           SGLINE CLEAR
	
	     SGLINE'. 
	   ,    SGLINE'
	,     
	.
	
	SGLINE ADD       SGLINE'
	   (    ).
	  -   ,     : d 
	(), h (),  m ().  ( ,  
	1h30m)  .     ,
	      "" (  +30   30 
	).    SGLINE,     +0. 
	  to  ,   +,  
	   .   SGLINE'
	    
	STATS AKILL.
	:        ,
	       .
	
	 SGLINE DEL     
	SGLINE'.    ,
	   . (.    LIST 
	.)
	
	 SGLINE LIST    SGLINE'.  
	   ,      
	.    , ,
	   ; :

	   SGLINE LIST 2-5,7-9
	    SGLINE'     2  5   7 
	    9.
	      
	SGLINE VIEW    ,  SGLINE LIST, 
	    SGLINE,   SGLINE', 
	 ,          SGLINE'.
	
	SGLINE CLEAR      SGLINE'.
	
	      .

OPER_HELP_SQLINE
	: SQLINE ADD [+ ] :
	    	   SQLINE DEL { |   | list}
	           SQLINE LIST [ | list]
	           SQLINE VIEW [ | list]
	           SQLINE CLEAR
	
	     SQLINE'. 
	  ,    SQLINE' 
	,     
	.
	
	    #,   
	     ( IRC , 
	 ).
	
	SQLINE ADD      SQLINE'
	   (    ).
	  -   ,     : d 
	(), h (),  m ().  ( ,  
	1h30m)  .     ,
	      "" (  +30   30 
	).    SQLINE,     +0. 
	  to  ,   +,  
	   .   SQLINE'
	    
	STATS AKILL.
	
	 SQLINE DEL     
	SGLINE'.    ,
	   . (.    LIST 
	.)
	
	 SQLINE LIST    SQLINE'.  
	   ,      
	.    , ,
	   ; :

	   SQLINE LIST 2-5,7-9
	    SQLINE'     2  5   7 
	    9.
	      
	SQLINE VIEW    ,  SQLINE LIST, 
	    SQLINE,   SQLINE', 
	 ,          SQLINE'.
	
	SQLINE CLEAR      SQLINE'.
	
	      .

OPER_HELP_SZLINE
	: SZLINE ADD [+ ]  
	           SZLINE DEL { |   | list}
	           SZLINE LIST [ | list]
	           SZLINE VIEW [ | list]
	           SZLINE CLEAR
	
	     SZLINE'. 
	  IP ,    SZLINE'  
	,     
	 (,     IP  PTR RR  ).
	
	SZLINE ADD  IP    SZLINE'
	   (    ).
	  -   ,     : d 
	(), h (),  m ().  ( ,  
	1h30m)  .     ,
	      "" (  +30   30 
	).    SGLINE,     +0. 
	  to  ,   +,  
	   .   SZLINE'
	    
	STATS AKILL.
	
	 SZLINE DEL     
	SZLINE'.    ,
	   . (.    LIST 
	.)
	
	 SZLINE LIST    SZLINE'.  
	   ,      
	.    , ,
	   ; :

	   SZLINE LIST 2-5,7-9
	    SZLINE'     2  5   7 
	    9.
	      
	SZLINE VIEW    ,  SZLINE LIST, 
	    SZLINE,   SZLINE', 
	 ,          SZLINE'.
	
	SZLINE CLEAR      SZLINE'.
	
	      .

OPER_HELP_SET
	: SET  

	    . 
	:
	    READONLY     -  -
	    LOGCHAN        
	    DEBUG      /  
	    NOEXPIRE   /  -
	    SUPERADMIN /  

	      .

OPER_HELP_SET_READONLY
	: SET READONLY {ON | OFF}
	
	    -.   -
	      ,
	      ,   . IRC 
	       
	AKILL'      
	,         
	-        
	  .
	
	      
	-readonly.

OPER_HELP_SET_LOGCHAN
	: SET LOGCHAN {ON | OFF}

	  LOHCHAN,         ,    
	  .      
	       
	.

	:   ,   
	      .

OPER_HELP_SET_DEBUG
	: SET DEBUG {ON | OFF | }
	
	/  .   , ,  
	  IRC ,      () 
	   .   ,
	     ,  
	.

	      
	-debug.

OPER_HELP_SET_NOEXPIRE
	: SET NOEXPIRE {ON | OFF}

	/  -.    ,
	, AKILL'     ,  
	  .

	      
	-noexpire.

OPER_HELP_SET_SUPERADMIN
	: SET SUPERADMIN {ON | OFF}

	       -   
	""     ...

	   ,      
	,    OFF      .


OPER_HELP_NOOP
	: NOOP SET 
	           NOOP REVOKE 

	NOOP SET   O:lines  
	    IRC ,   ,
	       (  
	   ).

	NOOP REVOKE     O:lines 
	   .

	:     
	.
	
	      .

OPER_HELP_JUPE
	: JUPE  []
	
	  --  
	 ""   , 
	         . 
	  ,   SQUIT.   ,
	    ,   ;
	  ,      
	"Juped by <>",    , 
	  .
	
	      .

OPER_HELP_RAW
	: RAW 
	
	     IRC ,  
	 .     
	,        
	 .     
	   ,   !
	
	      .

OPER_HELP_UPDATE
	: UPDATE
	
	      
	 .
	
	      .
	
OPER_HELP_RELOAD
	: RELOAD
	
	    . :
	    .
	(    , 
	 ,  ..)
	
	      .

OPER_HELP_QUIT
	: QUIT
	
	     ;  
	  .       
	    ,   
	   .     
	 SHUTDOWN.
	
	      .

OPER_HELP_SHUTDOWN
	: SHUTDOWN
	
	        .
	
	      .

OPER_HELP_RESTART
	: RESTART
	
	       
	(..         ).
	
	      .

OPER_HELP_KILLCLONES
	: KILLCLONES 
	
	  ,    ,    .
	  AKILL,   *@host,  
	   .
	       wallop,
	        .
	    ,  
	  IRC .
	
	      .
	
OPER_HELP_CHANLIST
	: CHANLIST [{  | } [SECRET]]
	
	        IRC , 
	   .
	
	   ,    ,    .   ,
	   ,     .    SECRET,
	        
	  +s  +p.
	
	      .

OPER_HELP_USERLIST
	: USERLIST [{  | #} [INVISIBLE]]
	
	  ,      IRC ,  
	     .
	
	   ,       (  
	  nick!user@host).   #,   ,
	   .    INVISIBLE  
	  ,     +i.
	
	      .

OPER_HELP_CACHE
	: CACHE DEL 
	           CACHE LIST   [QUEUED | ALL]
	
	 CACHE DEL    
	.      .

	 CACHE LIST     ,  
	  .    QUEUED,   
	 ,     ALL,
	     .
	
	      .

OPER_HELP_MODLOAD
	: MODLOAD 

	      
	 .

	      .

OPER_HELP_MODUNLOAD
	: MODUNLOAD 

	      
	 .

	      .

OPER_HELP_MODINFO
	: MODINFO 

	      

	      .

OPER_HELP_MODLIST
	: MODLIST

	   

	      .


###########################################################################
#
# BotServ help messages
#
###########################################################################
	
BOT_HELP
	%S       .
	   ,      
	 ,     
	  IRC .    ;
	  ,  /msg %S .   
	     ,  /msg 
	%S HELP .
	
	BOTLIST                
	ASSIGN                
	SET                  
	KICK                      
	BADWORDS              
	
	 : ACT INFO SAY UNASSIGN
	
	     ,    
	  %d .
	
BOT_HELP_BOTLIST
	: BOTLIST
	
	     .
	
BOT_HELP_ASSIGN
	: ASSIGN # 
	
	       . 
	     ,  
	.  
	
BOT_HELP_UNASSIGN
	: UNASSIGN #
	
	    .    
	      .   , 
	     ,    
	     ,    
	.
	
BOT_HELP_INFO
	: INFO {# | }
	
	    %S     .
	  #,      
	  .   ,
	    ,    
	      .
	
BOT_HELP_SET
	: SET #  
	
	  .  :
	
	    DONTKICKOPS        
	    DONTKICKVOICES     
	    GREET              
	    FANTASY            
	    SYMBIOSIS          // ,  ChanServ
	
	 /msg %S HELP SET     
	  .
	
	:        
	level SET.
	
BOT_HELP_SET_DONTKICKOPS
	: SET # DONTKICKOPS {ON|OFF}
	
	        .
	 ,     
	        NOKICK.
	
BOT_HELP_SET_DONTKICKVOICES
	: SET # DONTKICKVOICES {ON|OFF}
	
	       .
	 ,     
	        NOKICK.
	
BOT_HELP_SET_FANTASY
	: SET # FANTASY {ON|OFF}
	
	      .
	 ,   
	 !op, !deop, !voice, !devoice,
	!kick, !kb, !unban, !seen   ( ,
	  (), 
	  (  !kick, !kb)).
	
	:    ,
	     
	     ,
	    (,   
	!op,        
	OP/DEOP).

BOT_HELP_SET_GREET
	: SET # GREET {ON|OFF}
	
	      .
	 ,     
	 ,     
	  .

BOT_HELP_SET_SYMBIOSIS
	: SET # SYMBIOSIS {ON|OFF}
	
	      .
	 ,     
	   %s,    ,
	,  .

BOT_HELP_KICK
	: KICK #  
	
	       .  :
	
	    BOLDS                
	    BADWORDS            
	    CAPS                CapsLOCK
	    COLORS              
	    FLOOD              
	    REPEAT            
	                       
	    REVERSES           
	    UNDERLINES          
	
	 /msg %S HELP KICK     
	   .
	
	:        
	level SET.

BOT_HELP_KICK_BOLDS
	: KICK # BOLDS {ON|OFF} [ttb]

	       .
	  - .

	ttb   ,  
	  .     ttb,
	    .

BOT_HELP_KICK_COLORS
	: KICK # COLORS {ON|OFF} [ttb]

	      .
	  - .

	ttb   ,  
	  .     ttb,
	    .

BOT_HELP_KICK_REVERSES
	: KICK # REVERSES {ON|OFF} [ttb]

	     .
	  - .

	ttb   ,  
	  .     ttb,
	    .

BOT_HELP_KICK_UNDERLINES
	: KICK # UNDERLINES {ON|OFF} [ttb]

	      .
	  - .

	ttb   ,  
	  .     ttb,
	    .

BOT_HELP_KICK_CAPS
	: KICK # CAPS {ON|OFF} [ttb [ []]]

	      CapsLOCK.
	  -    ,   
	 .

	  ,      ,
	   %%   
	 (  ,     10 
	 25%%).

	ttb   ,  
	  .     ttb,
	    .

BOT_HELP_KICK_FLOOD
	: KICK # FLOOD {ON|OFF} [ttb [ []]]

	     .  ,
	     ,
	         
	(  ,    6   10 ).
	
	ttb   ,  
	  .     ttb,
	    .

BOT_HELP_KICK_REPEAT
	: KICK # REPEAT {ON|OFF} [ttb [ ]]

	     .  ,
	   ,      
	    (  ,   
	 3).

	ttb   ,  
	  .     ttb,
	    .

BOT_HELP_KICK_BADWORDS
	: KICK # BADWORDS {ON|OFF} [ttb]

	      .  ,
	   ,   
	 .

	      , 
	 BADWORDS.  /msg %S HELP BADWORDS 
	   .

	ttb   ,  
	  .     ttb,
	    .
	
BOT_HELP_BADWORDS
	: BADWORDS # ADD  [SINGLE | START | END]
	           BADWORDS # DEL { |   | list}
	           BADWORDS # LIST [ | list]
	           BADWORDS # CLEAR
	
	     .   
	       ,
	     .     ,
	 /msg %S HELP KICK BADWORDS.
	
	 BADWORDS ADD     
	 .    SINGLE,  
	,      .    START,
	  ,   , 
	 .    END,    ,
	   ,  
	.         ,  
	      .
	
	 BADWORDS DEL       .
	   ,  
	 . (.    LIST .)
	
	 BADWORDS LIST     .  
	 ,      
	.    ,   
	 ; :

	   BADWORDS #channel LIST 2-5,7-9
	          2  5  
	   7  9.
	      
	 BADWORDS CLEAR    
	 .

BOT_HELP_SAY
	: SAY # 
	
	       .

BOT_HELP_ACT
	: ACT # 
	
	   ,   "/me"
	  ,   .

BOT_SERVADMIN_HELP
	
	     :
	
	    BOT               

BOT_SERVADMIN_HELP_BOT
	: BOT ADD     
	           BOT CHANGE     [ [ [ ]]]
	           BOT DEL 
	           BOT LIST
	
	   ,   
	,       
	  .
	
	BOT ADD     , ,
	   .     
	 ,   !
	BOT CHANGE   , , 
	       ( 
	 ).
	BOT DEL      .  
	BOT LIST  BOTLIST  
	    .
	
	:      ,  - ,
	   .  ,  -   
	   ,   .

BOT_SERVADMIN_HELP_SET
	
	,     :
	
	    NOBOT              
	                      - 
	    PRIVATE             -, 
	                     IRC 

BOT_SERVADMIN_HELP_SET_NOBOT
	: SET # NOBOT {ON|OFF}
	
	      .  
	   ,      
	    .
	
	      .

BOT_SERVADMIN_HELP_SET_PRIVATE
	: SET   PRIVATE {ON|OFF}
	
	        .
	     IRC .
	
	      .

###########################################################################
#
# HostServ messages
#
###########################################################################
HOST_EMPTY
	   .
HOST_ENTRY
	#%d :%s,  :%s (%s - %s)
HOST_IDENT_ENTRY
	#%d :%s,  :%s@%s (%s - %s)
HOST_SET
	   %s   %s.
HOST_IDENT_SET
	  %s   %s@%s.
HOST_SETALL
	    %s   %s.
HOST_DELALL
	    %s  .
HOST_DELALL_SYNTAX
	: DELALL <>.
HOST_IDENT_SETALL
	    %s   %s@%s.
HOST_SET_ERROR
	         .
HOST_SET_IDENT_ERROR
	       .
HOST_SET_TOOLONG
	!    ,      %d .
HOST_SET_IDENTTOOLONG
	!   ,      %d .
HOST_NOREG
	 %s      NickServ.
HOST_SET_SYNTAX
	: /msg %s set <> <>.
HOST_SETALL_SYNTAX
	 /msg %s setall <> <>.
HOST_DENIED
	 .
HOST_NOT_ASSIGNED
	   IRC ,    .
HOST_ACTIVATED
	   %s .
HOST_IDENT_ACTIVATED
	   %s@%s .
HOST_ID
	, ,   .
HOST_NOT_REGED
	    ,      .
HOST_DEL
	   %s .
HOST_DEL_SYNTAX
	: /msg %s del <>.
HOST_OFF_UNREAL
	   .      ,  /mode %s +x
HOST_NO_VIDENT
	 IRC     ,    ,    ,      .
HOST_GROUP
	     %s    %s
HOST_IDENT_GROUP
	     %s    %s@%s
HOST_LIST_FOOTER
	   (Count: %d)
HOST_LIST_RANGE_FOOTER
	   %d  %d
HOST_LIST_KEY_FOOTER
	 ,   %s (: %d)

###########################################################################
#
# HostServ Help messages
#
###########################################################################
HOST_HELP
	%S commands:
	    ON              
	    OFF           
	    GROUP                 

HOST_OPER_HELP
	,     (setter/removers):
	    SET            
	    SETALL             
	    DEL            
	    DELALL             

HOST_ADMIN_HELP
	,    :
	    LIST           .

HOST_HELP_ON
	: ON

	  ,   .
	      ,  /whois
	        IP .

HOST_HELP_SET
	: SET <> <>.

	       
	.   IRC    ,  
	SET <> <>@<>    
	  .

	      (setters).

HOST_HELP_DELALL
	: DELALL <>.

	       
	 .

	      (removers).

HOST_HELP_SETALL
	: SETALL <> <>.

	       
	 .   IRC    ,  
	 SETALL <> <>@<>    
	  .

	* ,        
	,       .

	      (setters).

HOST_HELP_OFF
	: OFF

	  ,   .
	      ,  /whois
	     IP .

HOST_HELP_DEL
	: DEL <>

	  ,    
	 .

	      .

HOST_HELP_LIST
	: LIST [<>|<#X-Y>]

	      .
	  ,      , 
	  , .. Rob*   ,
	  "Rob"

	   #X-Y,     X
	 Y, .. #1-3   3
	 / .

	      NSListMax
	   .

	      .

HOST_HELP_GROUP
	: GROUP
	
	        
	    
	.
