/*
 * @(#)About.h 1.00 29 May 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_ABOUT_H
#define ANTHEM_ABOUT_H

#include <kaboutapplication.h>

/**
 * The AboutWindow displays information about the Anthem application, it is
 * shown via the @ref SongWindow's help menu.
 *
 * It shows information about the TSE3 library as required by the library
 * documentation.
 *
 * @short   About this program window
 * @author  Pete Goodliffe
 * @version 1.0
 */
class AboutWindow : public KAboutApplication
{
        Q_OBJECT

    public:

        /**
         * Creates an about window.
         */
        AboutWindow(QWidget *parent);

        virtual ~AboutWindow() {};

    protected slots:

        void openURL(const QString &url);

    private:

};

#endif
