/*
 * @(#)Demidify.h 1.00 30 Mar 2001
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_DEMIDIFY_H
#define ANTHEM_DEMIDIFY_H

#include <kdialogbase.h>

#include "tse3/Notifier.h"
#include "tse3/app/Application.h"
#include "tse3/listen/app/TrackSelection.h"

/**
 * The DemidifyWindow provides access to the @ref TSE3::Util::Demidify class.
 *
 * @short   Demidify dialog
 * @author  Pete Goodliffe
 * @version 1.0
 */
class DemidifyWindow : public KDialogBase,
                       public TSE3::Listener<TSE3::App::TrackSelectionListener>
{
        Q_OBJECT

    public:

        DemidifyWindow(TSE3::Song *song, QWidget *parent);

    public slots:

        void accept();
        void done(int reason);

    private:

        TSE3::Song                *song;
};

#endif
