/*
 * @(#)MiscWindows.cpp 1.00 7 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define QT_ALTERNATE_QTSMANIP

#include "dialogues/MiscWindows.h"

#include "gadgets/ZoomWidget.h"
#include "gadgets/MidiSchedulerWidgets.h"
#include "tse3/kdeui/ClockWidget.h"

#include "Application.h"

#include <qlayout.h>
#include <qframe.h>
#include <qlabel.h>
#include <qslider.h>

#include <kdialogbase.h>

#include "tse3/kdeui/FlagComboBox.h"

#include "tse3/MidiScheduler.h"
#include "tse3/FlagTrack.h"

/******************************************************************************
 * ZoomWindow class
 *****************************************************************************/

ZoomWindow::ZoomWindow(Zoomable *callback, QWidget *parent)
: QPopupMenu(parent, "ZoomWindow")//, WType_Popup|WRepaintNoErase)
{
    // I've put this in a nasty frame rather than just inserting the
    // ZoomWidget because that way I get some spacing.
    // To be fair, it's nasty to insert a QFrame into a QPopup menu, but
    // it's the only way I could get my own way!
    QFrame *frame = new QFrame(this);
    QVBoxLayout *layout
        = new QVBoxLayout(frame, KDialogBase::spacingHint(), -1);
    zoomWidget = new ZoomWidget(callback, frame, "ZoomWidget");
    layout->addWidget(zoomWidget);
    insertItem(frame);
}


void ZoomWindow::leaveEvent(QEvent *event)
{
//    hide();
}


/******************************************************************************
 * ClockWindow class
 *****************************************************************************/

ClockWindow::ClockWindow(QWidget *parent)
: KDialog(parent)
{
    QFont font = this->font();
    font.setWeight(QFont::Bold);
    font.setItalic(true);
    font.setPointSize(32); // better way of caluclating this?
    font.setStyleHint(QFont::Serif);
    setFont(font);

    QVBoxLayout *layout = new QVBoxLayout(this);
    QFrame *frame = new QFrame(this);
    frame->setFrameStyle(QFrame::Panel|QFrame::Sunken);
    layout->addWidget(frame);

    QVBoxLayout *flayout = new QVBoxLayout(frame, frame->frameWidth());
    MidiSchedulerTimeWidget *mstw
        = new MidiSchedulerTimeWidget(frame,
                                      Application::application()->scheduler());
    mstw->setBackgroundColor(QColor(0xff, 0xff, 0xff));
    flayout->add(mstw);
    setCaption("Studio clock");
}


/******************************************************************************
 * GotoWindow class
 *****************************************************************************/

GotoWindow::GotoWindow(QWidget *parent, TSE3::Song *song)
: KDialogBase(Plain, "Go to", Close|Ok, Ok, parent, "GoTo", false, true),
  song(song)
{
    QGridLayout *gl
        = new QGridLayout(plainPage(), 3, 2, 0, KDialogBase::spacingHint());

    QLabel *label = new QLabel("Go to", plainPage());
    gl->addWidget(label, 0, 0);
    clockWidget = new ClockWidget(plainPage(), false);
    gl->addWidget(clockWidget, 0, 1);

    slider = new QSlider(QSlider::Horizontal, plainPage());
    gl->addWidget(slider, 1, 1);

    label = new QLabel("Flag", plainPage());
    gl->addWidget(label, 2, 0);
    flagCombo = new FlagComboBox(song->flagTrack(), plainPage());
    gl->addWidget(flagCombo, 2, 1);

    // TODO Add bar/beat option

    // TODO add start/end/left marker/right marker.play marker

    connect(clockWidget, SIGNAL(valueChanged(int)),
            SLOT(clockWidgetValueChanged(int)));
    connect(slider, SIGNAL(valueChanged(int)),
            SLOT(sliderValueChanged(int)));
    connect(flagCombo, SIGNAL(activated(int)),
            SLOT(flagComboActvated(int)));

    if (song)
    {
        TSE3::Listener<TSE3::FlagTrackListener>::attachTo(song->flagTrack());
        TSE3::Listener<TSE3::SongListener>::attachTo(song);
    }
}


void GotoWindow::changeSong(TSE3::Song *s)
{
    if (song)
    {
        TSE3::Listener<TSE3::SongListener>::detachFrom(song);
        TSE3::Listener<TSE3::FlagTrackListener>::detachFrom(song->flagTrack());
    }
    song = s;
    TSE3::Listener<TSE3::SongListener>::attachTo(song);
    TSE3::Listener<TSE3::FlagTrackListener>::attachTo(song->flagTrack());
    updateSlider();
    flagCombo->setFlagTrack(s->flagTrack());
}


void GotoWindow::show()
{
    updateSlider();
    KDialogBase::show();
}


void GotoWindow::updateSlider()
{
    TSE3::Clock lastClock = song ? song->lastClock() : TSE3::Clock(0);
    slider->setMaxValue(lastClock);
}


void GotoWindow::accept()
{
    Application::application()->scheduler()->moveTo(clockWidget->value());
    done(Accepted);
}


void GotoWindow::clockWidgetValueChanged(int v)
{
    slider->setValue(v);
    flagCombo->setTime(v);
}


void GotoWindow::sliderValueChanged(int v)
{
    clockWidget->setValue(v);
    flagCombo->setTime(v);
}


void GotoWindow::flagComboActvated(int index)
{
    clockWidget->setValue((*song->flagTrack())[index].time);
}


void GotoWindow::EventTrack_EventAltered(TSE3::EventTrack<TSE3::Flag> *, size_t)
{
}


void GotoWindow::EventTrack_EventInserted(TSE3::EventTrack<TSE3::Flag> *, size_t)
{
}


void GotoWindow::EventTrack_EventErased(TSE3::EventTrack<TSE3::Flag> *, size_t)
{
}


void GotoWindow::Notifier_Deleted(TSE3::EventTrack<TSE3::Flag> *)
{
}


void GotoWindow::Notifier_Deleted(TSE3::Song *)
{
    song = 0;
}

