/*
 * @(#)MiscWindows.h 1.00 7 Jun 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_MISCWINDOWS_H
#define ANTHEM_MISCWINDOWS_H

#include "misc/Interfaces.h"

#include <qpopupmenu.h>
#include <kdialog.h>
#include <kdialogbase.h>

#include "tse3/Notifier.h"
#include "tse3/listen/FlagTrack.h"
#include "tse3/listen/Song.h"

class FlagComboBox;
class QSlider;

class ZoomWidget;
class ClockWidget;
class PortWidget;
class ChannelWidget;

namespace TSE3
{
    class MidiScheduler;
}

/**
 * This window holds a @ref ZoomWidget. It cunningly closes itself once the
 * mouse pointer moves outside the window.
 *
 * @sect Admin
 *
 * Is this class really needed any longer?
 *
 * @short   ZoomWidget window.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class ZoomWindow : public QPopupMenu
{
        Q_OBJECT

    public:

        ZoomWindow(Zoomable *callback, QWidget *parent);

    protected:

        virtual void leaveEvent(QEvent *event);

    private:

        ZoomWidget *zoomWidget;
};


/**
 * This window shows a large studio clock. It displays the current time of the
 * specified @ref TSE3:MidiScheduler. It uses the @ref MidiSchedulerTimeWidget
 * for this.
 *
 * When I have a a millisecond time widget this will be provided too.
 *
 * @short   Large studio clock widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class ClockWindow : public KDialog
{
        Q_OBJECT;

    public:

        ClockWindow(QWidget *parent);
};

/**
 * This window allows the user to enter a time to jump to.
 *
 * @short   Go to time window
 * @author  Pete Goodliffe
 * @version 1.0
 */
class GotoWindow : public KDialogBase,
                   public TSE3::Listener<TSE3::FlagTrackListener>,
                   public TSE3::Listener<TSE3::SongListener>
{
        Q_OBJECT;

    public:

        GotoWindow(QWidget *parent, TSE3::Song *song);

        /**
         * @reimplemented
         *
         * Updates @ref TSE3::Song length in the slider before showing.
         */
        virtual void show();

        /**
         * Changes which @ref TSE3::Song this window views.
         *
         * This can only be called safely by the @ref SongWindow.
         */
        void changeSong(TSE3::Song *song);

        /**
         * @reimplemented
         */
        virtual void EventTrack_EventAltered(TSE3::EventTrack<TSE3::Flag> *,
                                             size_t);

        /**
         * @reimplemented
         */
        virtual void EventTrack_EventInserted(TSE3::EventTrack<TSE3::Flag> *,
                                             size_t);

        /**
         * @reimplemented
         */
        virtual void EventTrack_EventErased(TSE3::EventTrack<TSE3::Flag> *,
                                            size_t);

        /**
         * @reimplemented
         */
        virtual void Notifier_Deleted(TSE3::EventTrack<TSE3::Flag> *);

        /**
         * @reimplemented
         */
        virtual void Notifier_Deleted(TSE3::Song *);

    public slots:

        void accept();

    private slots:

        void clockWidgetValueChanged(int);
        void sliderValueChanged(int);
        void flagComboActvated(int);

    private:

        /**
         * Updates the flags combo box.
         */
        void updateCombo();
        void updateSlider();

        TSE3::Song   *song;
        ClockWidget  *clockWidget;
        FlagComboBox *flagCombo;
        QSlider      *slider;
};


#endif
