/*
 * @(#)NewPhrase.h 1.00 27 April 2002
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_NEWFLAG_H
#define ANTHEM_NEWFLAG_H

#include <kdialogbase.h>

#include "tse3/Midi.h"
#include "tse3/Notifier.h"
#include "tse3/listen/FlagTrack.h"

class QLineEdit;

class ClockWidget;

namespace TSE3
{
    class Song;
}

/**
 * A dialog that offers you the chance to add a new flag.
 *
 * @short   New Phrase name selection window
 * @author  Pete Goodliffe
 * @version 1.0
 */
class NewFlagWindow : public KDialogBase,
                      public TSE3::Listener<TSE3::FlagTrackListener>
{
        Q_OBJECT

    public:

        NewFlagWindow(QWidget      *parent,
                      TSE3::Song   *song,
                      TSE3::Clock   clock);

        virtual void Notifier_Deleted(TSE3::FlagTrack *flagTrack);

    protected slots:

        void accept();

    private:

        TSE3::Song  *song;
        QLineEdit   *name;
        ClockWidget *clock;
};

#endif
