/*
 * @(#)NewTrack.cpp 1.00 7 Jan 2002
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "dialogues/NewTrack.h"

#include <qlabel.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qlayout.h>

#include "Application.h"

#include "tse3/app/TrackSelection.h"
#include "tse3/cmd/CommandGroup.h"
#include "tse3/cmd/CommandHistory.h"
#include "tse3/cmd/Song.h"

namespace
{
    const char *IS_SELECTION = "current selection";
    const char *NO_SELECTION = "other tracks";
}

NewTrackWindow:: NewTrackWindow(TSE3::App::TrackSelection *ts, TSE3::Song *song,
                                QWidget *parent)
: KDialogBase(Plain, "Insert tracks", Cancel|Ok, Ok, parent,
              "NewTrackWindow", false, true),
  song(song), trackSelection(ts)
{
    attachTo(ts);

    QGridLayout *gl = new QGridLayout(plainPage(), 2, 3, spacingHint());

    QLabel *label = new QLabel("Insert", plainPage());
    label->setMinimumSize(label->sizeHint());
    label->setAlignment(AlignRight|AlignVCenter);
    gl->addWidget(label, 0, 0);

    number = new QSpinBox(1, 20, 1, plainPage());
    gl->addWidget(number, 0, 1);

    label = new QLabel("tracks", plainPage());
    label->setMinimumSize(label->sizeHint());
    label->setAlignment(AlignVCenter);
    gl->addWidget(label, 0, 2);

    where = new QComboBox(plainPage());
    where->insertItem("After");
    where->insertItem("Before");
    gl->addWidget(where, 1, 1);

    wherelabel = new QLabel(IS_SELECTION, plainPage());
    wherelabel->setAlignment(AlignVCenter);
    gl->addWidget(wherelabel, 1, 2);

    updateWidgets();

    show();
}


void NewTrackWindow::accept()
{
    TSE3::Cmd::CommandGroup *cmdg = new TSE3::Cmd::CommandGroup();
    for (int n = 0; n < number->value(); n++)
    {
        size_t index = where->currentItem() ? 0 : song->size();
        if (trackSelection->size())
        {
            index = where->currentItem()
                  ? song->index(trackSelection->front())
                  : song->index(trackSelection->back()) + 1;
        }
        TSE3::Cmd::Song_InsertTrack *cmd
            = new TSE3::Cmd::Song_InsertTrack(song, index);
        cmdg->add(cmd);
    }
    cmdg->execute();
    Application::application()->history(song)->add(cmdg);
    done(Accepted);
}


void NewTrackWindow::done(int reason)
{
    delayedDestruct();
}


void NewTrackWindow::TrackSelection_Selected(TSE3::App::TrackSelection *,
                                             TSE3::Track *, bool selected)
{
    updateWidgets();
}


void NewTrackWindow::updateWidgets()
{
    if (trackSelection->size())
    {
        wherelabel->setText(IS_SELECTION);
    }
    else
    {
        wherelabel->setText(NO_SELECTION);
    }
    wherelabel->setMinimumSize(wherelabel->sizeHint());
}

