/*
 * @(#)Panic.cpp 1.00 5 July 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "dialogues/Panic.h"

#include "settings/Panic.h"
#include "Application.h"

#include "tse3/Panic.h"
#include "tse3/MidiScheduler.h"

#include "misc/kde2-compat.h"
#include <qlayout.h>

/******************************************************************************
 * PanicWindow class
 *****************************************************************************/

PanicWindow::PanicWindow(QWidget *parent)
: KDialogBase(Plain, "Send Panic", Close|User1, User1,
              parent, "PanicWindow", false, true, KGuiItem("Send")),
  panic(new TSE3::Panic)
{
    QVBoxLayout *layout = new QVBoxLayout(plainPage(), 0, spacingHint());
    pwidget = new PanicWidget(panic, plainPage());
    layout->add(pwidget);
    connect(this, SIGNAL(user1Clicked()), SLOT(send()));
}


PanicWindow::~PanicWindow()
{
    delete panic;
}


void PanicWindow::send()
{
    // Set the values in the window
    pwidget->accept();

    // Send the data
    TSE3::PlayableIterator *p = panic->iterator(0);
    while (p->more())
    {
        Application::application()->scheduler()->tx((**p).data);
        ++(*p);
    }
    delete p;
}
