/*
 * @(#)Part.h 1.00 30 May 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_PART_H
#define ANTHEM_PART_H

#include <kdialogbase.h>

#include "tse3/Notifier.h"
#include "tse3/listen/Part.h"

class PartWidget;
class MidiFilterWidget;
class MidiParamsWidget;
class DisplayParamsWidget;

namespace TSE3
{
    class Song;

    namespace Cmd
    {
        class CommandHistory;
    }
}


/**
 * The PartWindow alows the user to alter a @ref Part's settings.
 *
 * @short   Part settings window
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PartWindow : public KDialogBase,
                   public TSE3::Listener<TSE3::PartListener>
{
        Q_OBJECT

    public:

        /**
         * Creates a Part settings window for the given @ref TSE3::Part.
         * you must specify the @ref TSE3::Song it is contained in
         * (to create the @ref PhaseSelectWidget)
         */
        PartWindow(QWidget *parent, TSE3::Part *part, TSE3::Song *song,
                   TSE3::Cmd::CommandHistory *history);

        /**
         * Dtor - the @ref Part is not deleted.
         */
        virtual ~PartWindow();

        /**
         * Updates the values before showing the window.
         */
        virtual void show();

        /**
         * @reimplemented
         */
        virtual void Notifier_Deleted(TSE3::Part *part);

        /**
         * @reimplemented
         */
        virtual void Part_Reparented(TSE3::Part *part);

    public slots:

        /**
         * @reimplemented
         */
        void accept();

        /**
         * @reimplemented
         */
        void done(int reason);

        /**
         * @reimplemented
         */
        void slotApply();

    signals:

        void closed();

    protected:

    private:

        /**
         * Updates all the widgets in the window to reflect the current
         * state of the @ref Part.
         */
        void updateWidgets();

        /**
         * Sets the widget values into the Part.
         */
        void setValues();

        // TSE3 objects
        TSE3::Part                *part;
        TSE3::Cmd::CommandHistory *history;

        // UI objects

        QFrame *partTab;
        QFrame *filterTab;
        QFrame *paramsTab;
        QFrame *displayParamsTab;

        PartWidget          *pwidget;
        MidiFilterWidget    *mfwidget;
        MidiParamsWidget    *mpwidget;
        DisplayParamsWidget *dpwidget;
};

#endif
