/*
 * @(#)Phrase.cpp 1.00 22 May 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "dialogues/Phrase.h"

#include "settings/Phrase.h"
#include "settings/DisplayParams.h"

#include <qlayout.h>

#include "tse3/cmd/CommandHistory.h"
#include "tse3/cmd/Phrase.h"

/******************************************************************************
 * PhraseWindow class
 *****************************************************************************/

PhraseWindow::PhraseWindow(QWidget *parent, TSE3::Phrase *phrase,
                           TSE3::Cmd::CommandHistory *history)
: KDialogBase(Tabbed, "Phrase Settings", Cancel|Ok|Apply, Ok, parent,
              "PhraseWindow", false, true),
  phrase(phrase), history(history)
{
    /**************************************************************************
     * Set up tabs
     *************************************************************************/

    phraseTab         = addPage(QString("General"));
    dparamsTab        = addPage(QString("Display params"));

    /**************************************************************************
     * Phrase tab
     *************************************************************************/

    {
        QVBoxLayout *layout = new QVBoxLayout(phraseTab, spacingHint());
        pwidget = new PhraseWidget(phrase, phraseTab);
        layout->add(pwidget);
    }

    /**************************************************************************
     * DisplayParams tab
     *************************************************************************/

    {
        QVBoxLayout *layout = new QVBoxLayout(dparamsTab, spacingHint());
        dpwidget = new DisplayParamsWidget(phrase->displayParams(), false,
                                           dparamsTab);
        layout->add(dpwidget);
    }

    /**************************************************************************
     * All done
     *************************************************************************/

    show();
}


PhraseWindow::~PhraseWindow()
{
}


void PhraseWindow::show()
{
    updateWidgets();
    KDialogBase::show();
}


void PhraseWindow::setValues()
{
    TSE3::DisplayParams dp;

    dpwidget->setValues(dp);

    TSE3::Cmd::Phrase_SetInfo *command
        = new TSE3::Cmd::Phrase_SetInfo(phrase, pwidget->title().latin1(), dp);
    command->execute();
    history->add(command);
}


void PhraseWindow::accept()
{
    setValues();
    done(Accepted);
}


void PhraseWindow::done(int reason)
{
    delayedDestruct();
}


void PhraseWindow::slotApply()
{
    setValues();
    updateWidgets();
}


void PhraseWindow::updateWidgets()
{
    pwidget->updateWidgets();
    dpwidget->updateWidgets();
}


void PhraseWindow::Notifier_Deleted(TSE3::Phrase *phrase)
{
    delayedDestruct();
}

