/*
 * @(#)SongInfo.h 1.00 22 May 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_SONGINFO_H
#define ANTHEM_SONGINFO_H

#include <kdialogbase.h>

#include "tse3/Notifier.h"
#include "tse3/listen/Song.h"

class QLineEdit;

/**
 * The SongInfoWindow alows the user to alter the basic @ref Song information,
 * such as the title, author etc.
 *
 * @short   Song information window.
 * @author  Pete Goodliffe
 * @version 1.0
 */
class SongInfoWindow : public KDialogBase,
                       public TSE3::Listener<TSE3::SongListener>
{
        Q_OBJECT

    public:

        /**
         * Creates a song info window for the given song.
         */
        SongInfoWindow(QWidget *parent, TSE3::Song *song = 0);
        virtual ~SongInfoWindow() {};

        /**
         * @reimplemented
         */
        void Song_InfoAltered(TSE3::Song *src);

    public slots:

        void accept();
        void done(int reason);

    signals:

        void closed();

    protected:

    private:

        /**
         * Updates the QLineEdits.
         */
        void updateWidgets();

        // TSE3 objects
        TSE3::Song *song;

        // UI objects
        QLineEdit *titleEdit;
        QLineEdit *authorEdit;
        QLineEdit *copyrightEdit;
        QLineEdit *dateEdit;
};

#endif
