/*
 * @(#)Splash.cpp 1.00 9 November 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "dialogues/Splash.h"

#include <kapp.h>
#include <kstddirs.h>
#include <kdialogbase.h>
#include <kiconloader.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qtimer.h>

namespace
{
    const int SPLASH_DISPLAY_MSECS = 1000;
    const int SPLASH_BORDER        = 10;
}

SplashScreen::SplashScreen()
: QWidget(0, "SplashScreen",
          WStyle_Customize | WStyle_NoBorderEx | WStyle_StaysOnTop),
  canDisappear(false), timeout(false)
{
    QPixmap back = UserIcon("splash");
    setBackgroundPixmap(back);

    // Window size and position
    int width  = back.width();
    int height = back.height();
    setGeometry((QApplication::desktop()->width()-width)/2,
                (QApplication::desktop()->height()-height)/2,
                width, height);
    show();

}


void SplashScreen::disappear()
{
    // Disappear timer
    QTimer *timer = new QTimer(this);
    timer->start(SPLASH_DISPLAY_MSECS, false);
    connect(timer, SIGNAL(timeout()), SLOT(slotTimeout()));
}


void SplashScreen::slotTimeout()
{
    delete this;
}
