/*
 * @(#)TSE3Progress.cpp 1.00 14 November 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "dialogues/TSE3Progress.h"

#include "Application.h"

#include <iostream>


TSE3ProgressDialog::TSE3ProgressDialog(const QString &labelText,
                                       const QString &cancelText,
                                       QWidget *creator,
                                       const char *name, bool modal,
                                       WFlags f)
: QProgressDialog(labelText, cancelText, 100, creator, name, modal, f),
  min(0), max(100)
{
    setMinimumDuration(500);
    setCaption(Application::application()->name());
}


void TSE3ProgressDialog::progressRange(int newmin, int newmax)
{
    min = newmin;
    max = newmax;
    setTotalSteps(max-min);
}


void TSE3ProgressDialog::progress(int value)
{
    setProgress(value - min);
    qApp->processEvents();
    if (wasCancelled())
    {
        std::cout << "TODO: TSE3ProgressDialog wasCancelled()\n";
    }
}
