/*
 * @(#)ARecentFilesAction.h 1.00 31 January 2001
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_GADGETS_ARECENTFILESACTION_H
#define ANTHEM_GADGETS_ARECENTFILESACTION_H

#include <qguardedptr.h>
#include <vector>

class QWidget;
class KURL;
class KConfig;
class KRecentFilesAction;

/**
 * This QObject manages the @ref KRecentFilesAction objects that are used
 * by each @ref SongWindow.
 *
 * They all need to be linked somehow, otherwise they suck. For example, if
 * you have several different ones for each @ref SongWindow they won't update
 * to reflect each other's status. And which one gets saved into the
 * prefences file when the app shots down?
 *
 * I did have a spell of just using one global recent files object. That
 * was quite funny - every window connects to it, so you load a file in
 * one window and every window loads it!
 *
 * This class works around this naffness. It's a shame the KDE action doesn't
 * sort this out in the first place, but never mind...
 *
 * @short   Anthem KRecentFilesAction manager
 * @author  Pete Goodliffe
 * @version 1.0
 */
class ARecentFilesAction : public QObject
{
        Q_OBJECT

    public:

        /**
         * We'll only really every create one of these, and it will be
         * owned by the @ref Application class.
         */
        ARecentFilesAction(QObject *parent);

        /**
         * Creates a new @ref KRecentFilesAction to be used in a
         * @ref SongWindow.
         *
         * This object is remembered (although you can delete it safely)
         * and used to update all actions with @ref addURL().
         */
        KRecentFilesAction *create(QObject *parent);

        /**
         * Adds this URL to all @ref KRecentFilesAction objects that have
         * been created.
         */
        void addURL(const KURL &url);

        /**
         * As for @ref KRecentFilesAction
         */
        void loadEntries(KConfig *config, QString groupname = QString::null);

        /**
         * As for @ref KRecentFilesAction
         */
        void saveEntries(KConfig *config, QString groupname = QString::null);

    private:

        /**
         * This removes all destroyed object pointers from the ptrs list.
         *
         * It's good to call this before doing anything with the list to
         * strip out the dead wood.
         */
        void tidyList();

        KRecentFilesAction                            *recentFilesAction;
        std::vector<QGuardedPtr<KRecentFilesAction> >  ptrs;
};

#endif
