/*
 * @(#)ControlWidget.h 1.00 30 June 2001
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_GADGETS_CONTROL_H
#define ANTHEM_GADGETS_CONTROL_H

#include <qwidget.h>
#include <qpopupmenu.h>

class QLabel;
class QPushButton;

class KListView;

/**
 * This widget provides a facility for chosing a control change value. It uses
 * the @ref TSE3::Ins::Destination and @ref TSE3::Ins::Instrument objects
 * to provide a menu of named controllers.
 *
 * @short   MIDI voice choice widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class ControlWidget : public QWidget
{
        Q_OBJECT

    public:

        /**
         * Creates a ControlWidget which is initially set to the
         * given values.
         *
         * You can specify a channel/port which is used for the initial
         * name lookup.
         */
        ControlWidget(int control,
                      int channel = 1, int port = -1,
                      QWidget *parent = 0, const char *name = 0);

        /**
         * Returns the currently selected control change value.
         */
        int control();

        /**
         * Sets the current program value.
         */
        void setControl(int c);

        /**
         * Converts a data set to a text name.
         */
        static QString toTextName(int control, int channel, int port);

    public slots:

        void slotControlSelected(int control);

    private:

        void updateWidgets();

        QLabel      *name;
        QLabel      *number;
        QPushButton *byNumber;

        int          _control;
};


#endif
