/*
 * @(#)FilteredKListView.h 1.00 22 May 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_GADGETS_FILTEREDKLISTVIEW_H
#define ANTHEM_GADGETS_FILTEREDKLISTVIEW_H

#include <klistview.h>

/**
 * A little internal widget class that looks and smells mostly like a
 * KListView. The main difference is that it provides it's own selection
 * model.
 *
 * I hate having to do this, but I want to filter a request for
 * selection and pass it on to the TrackSelection object to handle the
 * selection model (for example). I don't necessarily want the standard
 * selection behvaiour. And I want to be able to keep a behind-the-scenes
 * copy of the current selection.
 *
 * If only there were some generic way of doing this... Reinventing the
 * wheel was something Qt is supposed to protect you from. Sigh.
 *
 * Used only by the @ref TrackList widget, and now by the @ref ListEditor too.
 *
 * @internal
 */
class FilteredKListView : public KListView
{
        Q_OBJECT

    public:

        FilteredKListView(QWidget *parent, const char *name = 0);

        /**
         * Does what @ref KListView::setSelected would, but doesn't
         * emit a signal. You can't use the other method, anyway - this
         * class uses NoSelection mode which doesn't allow you to select
         * anyway.
         */
        void setSelectedWithoutSignal(QListViewItem *item, bool sel);

        /**
         * Returns the index of the @ref QListViewItem in the list.
         * (i.e. use it to get a @ref Track reference within a @ref Song).
         *
         * If the @ref QListViewItem is not in the list, then the index
         * of one past the max index is returned.
         */
        size_t indexOf(QListViewItem *trackItem) const;

        /**
         * Returns the QListViewItem with the given index. If there is no
         * item with this index, returns zero.
         */
        QListViewItem *itemWithIndex(size_t index) const;

    signals:

        /**
         * The list view wants to have an item selected. The item has
         * not been selected, though.
         */
        void wantToSelect(QListViewItem *, bool add);

        /**
         * The list view wants to have an item deselected. The item has
         * not been selected, though.
         */
        void wantToClear(QListViewItem *);

    protected:

        virtual void contentsMousePressEvent(QMouseEvent *e);

    private:

        void clearSelection(QListViewItem *except = 0);

        int lastClickIndex;
};

#endif
