/*
 * @(#)Gadgets.h 1.00 15 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_GADGETS_H
#define ANTHEM_GADGETS_H

#include <kdialog.h>

#include "tse3/listen/Transport.h"

class VuWidget;

/**
 * The VuWindow provides a dialogue with bars that show MIDI activity.
 *
 * @short   Vu bar window
 * @author  Pete Goodliffe
 * @version 1.0
 */
class VuWindow : public KDialog,
                 public TSE3::TransportCallback
{
        Q_OBJECT

    public:

        /**
         * Creates a VuWindow window.
         *
         * The default setup only shows @ref MidiCommand_NoteOn commands.
         */
        VuWindow();
        virtual ~VuWindow();

        /*
         * Implementation of the TransportCallback interface
         */
        virtual void Transport_MidiIn(TSE3::MidiCommand c);
        virtual void Transport_MidiOut(TSE3::MidiCommand c);

        /**
         * Returns whether all commands are shown (true) or just
         * MidiComand_NoteOns (false).
         */
        bool allCommands();

        enum VuStatus
        {
            In,
            Out,
            Both
        };

        /**
         * Returns whether the VuWindow shows only incoming MidiCommands,
         * outgoing MidiCommands or both.
         */
        static int status();

        /**
         * Sets what the VuWindow shows.
         *
         * You pass a @ref VuStatus value.
         */
        static void setStatus(int status);

    public slots:

        /**
         * Sets whether to show every @ref MidiCOmmand or just the
         * @ref MidiCommand_NoteOn ones.
         */
        void setAllCommands(bool allCommands);

    protected:

        virtual void showEvent(QShowEvent *e);
        virtual void hideEvent(QHideEvent *e);

    protected slots:

        void slotTimeout();

    private:

        size_t     noPorts;
        bool       _allCommands;
        VuWidget **vuwidgets;
        QTimer    *timer;

        static int _status;
};

/**
 * The KeyboardWindow provides a dialogue with an "on screen keyboard"
 * that can be used to enter MIDI commands into the system.
 *
 * @short   On screen keyboard window
 * @author  Pete Goodliffe
 * @version 1.0
 */
class KeyboardWindow : public KDialog
{
        Q_OBJECT

    public:

        /**
         * Creates a KeyboardWindow window.
         */
        KeyboardWindow();
        virtual ~KeyboardWindow();

    protected slots:

        void slotClicked(int key);
        void slotReleased();

    private:

        int lastKeyClicked;
};

#endif
