/*
 * @(#)gadgets/MidiParamsSpinBox.cpp 1.00 4 April 20001
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "gadgets/MidiParamsSpinBox.h"

#include <kdialogbase.h>

#include "tse3/MidiParams.h"

namespace
{
    const char *SPIN_OFF  = "Off";
    const char *SPIN_NONE = "None";
}

/******************************************************************************
 * MidiParamsSpinBox widget class
 *****************************************************************************/

QString MidiParamsSpinBox::valueToText(int v)
{
    QString s;
    switch (v)
    {
        case TSE3::MidiParams::off:
        {
            s = SPIN_OFF;
            break;
        }
        case TSE3::MidiParams::forceNone:
        {
            s = SPIN_NONE;
            break;
        }
        default:
        {
            s.sprintf("%i", v);
            break;
        }
    }
    return s;
}


QString MidiParamsSpinBox::mapValueToText(int v)
{
    return valueToText(v);
}


int MidiParamsSpinBox::mapTextToValue(bool *ok)
{
    QString s = text();
    if (s == SPIN_OFF)
    {
        return TSE3::MidiParams::off;
    }
    else if (s == SPIN_NONE)
    {
        return TSE3::MidiParams::forceNone;
    }
    return s.toInt();
}

