/*
 * @(#)gadgets/MidiParamsSpinBox.h 1.00 4 April 2001
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_GADGETS_MIDIPARAMSSPINBOX_H
#define ANTHEM_GADGETS_MIDIPARAMSSPINBOX_H

#include <qspinbox.h>

/**
 * This is a special kind of spin box that handles values in the
 * MidiParams TSE3 class.
 *
 * @short   TSE3 MidiParams spin box
 * @author  Pete Goodliffe
 * @version 1.0
 */
class MidiParamsSpinBox : public QSpinBox
{
    public:
        MidiParamsSpinBox(QWidget *parent, const char *name = 0,
                          int maxVal = 127)
            : QSpinBox(-2, maxVal, 1, parent, name)
            {
                setWrapping(true);
            }
        virtual QString mapValueToText(int v);
        virtual int mapTextToValue(bool *ok);

        static QString valueToText(int v);
};

#endif

