/*
 * @(#)MidiSchedulerWidgets.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_MIDISCHEDULERWIDGETS_H
#define ANTHEM_MIDISCHEDULERWIDGETS_H

#include <qframe.h>
#include <qslider.h>

#include "tse3/listen/Song.h"
#include "tse3/Notifier.h"

class QTimer;
class QLabel;

class ClockDisplayWidget;

namespace TSE3
{
    class MidiScheduler;

    namespace Util
    {
        class Snap;
    }
}

/**
 * This widget provides a self updating time display for a
 * @ref TSE3::MidiScheduler.
 *
 * @short   On screen clock
 * @author  Pete Goodliffe
 * @version 1.0
 */
class MidiSchedulerTimeWidget : public QFrame
{
        Q_OBJECT;

    public:

        MidiSchedulerTimeWidget(QWidget *parent,
                                TSE3::MidiScheduler *scheduler);

        //void setBackgroundColor(const QColor &background);

    private slots:

        void update();

    private:

        TSE3::MidiScheduler *scheduler;
        QTimer              *timer;
        ClockDisplayWidget  *display;
};

/**
 * This widget provides a slider that updates with a  @ref TSE3::MidiScheduler.
 * It motiors a specific Song for it's size.
 *
 * @short   Song position indicator
 * @author  Pete Goodliffe
 * @version 1.0
 */
class MidiSchedulerTimeSlider : public QSlider,
                                public TSE3::Listener<TSE3::SongListener>
{
        Q_OBJECT;

    public:

        MidiSchedulerTimeSlider(QWidget             *parent,
                                TSE3::MidiScheduler *scheduler,
                                TSE3::Song          *song,
                                TSE3::Util::Snap    *snap = 0);

        virtual void Notifier_Deleted(TSE3::Song *song);

        /**
         * Changes the Song we're working with.
         */
        void setSong(TSE3::Song *song);

    private slots:

        void slotSliderMoved(int value);
        void update();

    private:

        TSE3::MidiScheduler *scheduler;
        TSE3::Song          *song;
        TSE3::Util::Snap    *snap;
        QTimer              *timer;
        bool                 sliderMoved;
};

/**
 * This widget provides information on the setup of a
 * @ref TSE3::MidiScheduler.
 *
 * @short   MidiScheduler information widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class MidiSchedulerInfoWidget : public QFrame
{
        Q_OBJECT;

    public:

        MidiSchedulerInfoWidget(QWidget *parent,
                                TSE3::MidiScheduler *scheduler);
};

#endif
