/*
 * @(#)PhraseSelectWidget.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_GADGETS_PHRASESELECTWIDGET_H
#define ANTHEM_GADGETS_PHRASESELECTWIDGET_H

#include <qcombobox.h>

class QPushButton;

namespace TSE3
{
    class PhraseList;
    class Phrase;
    class Song;
}

/**
 * This widget provides a button that can be used to choose a Phrase
 * from a @ref TSE3::PhraseList.
 *
 * @short   Phrase name selection widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PhraseSelectWidget : public QComboBox
{
        Q_OBJECT

    public:

        /**
         * Creates a PhraseSelectWidget containing an entry for each
         * @ref TSE3::Phrase in the specified @ref TSE3::PhraseList.
         *
         * @param phraseList @ref PhraseList to produce list from
         * @param phrase     @ref TSE3::Phase to be initially selected
         *                   (or zero for default)
         * @param allowNone  Whether you are allowed to select no Phrase.
         */
        PhraseSelectWidget(TSE3::PhraseList *phraseList, bool allowNone,
                           TSE3::Phrase *phrase,
                           QWidget *parent, const char *name = 0);

        /**
         * Returns a pointer to the currently selected @ref TSE3::Phrase
         * or zero if none is selected.
         */
        TSE3::Phrase *phrase();

        /**
         * Sets the currently selected @ref TSE3::Phrase.
         */
        void setPhrase(TSE3::Phrase *phrase);

    signals:

        void phraseSelected(TSE3::Phrase *phrase);

    private slots:

        void slotActivated(int);

    private:

        TSE3::PhraseList *phraseList;
        bool              allowNone;
};

/**
 * Like a @ref PhraseSelectWidget, but with an edit Phrase button too.
 *
 * @short   Phrase name selection widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class PhraseSelectEditWidget : public QWidget
{
        Q_OBJECT

    public:

        /**
         * As for @ref PhraseSelectWidget.
         *
         * You also have to specify the @ref TSE3::Song, though - since this
         * is needed by the @ref PhraseEditor ctor.
         */
        PhraseSelectEditWidget(TSE3::PhraseList *phraseList, bool allowNone,
                               TSE3::Phrase *phrase, TSE3::Song *song,
                               QWidget *parent, const char *name = 0);


        /**
         * Returns a pointer to the currently selected @ref TSE3::Phrase
         * or zero if none is selected.
         */
        TSE3::Phrase *phrase();

        /**
         * Sets the currently selected @ref TSE3::Phrase.
         */
        void setPhrase(TSE3::Phrase *phrase);

    signals:

        void phraseSelected(TSE3::Phrase *phrase);

    private slots:

        void slotPhrase(TSE3::Phrase *);
        void slotButton();

    private:

        void updateWidgets();

        TSE3::Song         *song;
        PhraseSelectWidget *select;
        QPushButton        *button;
};

#endif
