/*
 * @(#)SystemTrayWidget.cpp 1.00 15 January 2001
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#include "gadgets/SystemTrayWidget.h"

#include "Application.h"

#include <qlabel.h>
#include <qtimer.h>
#include <qlayout.h>
#include <qvbox.h>
#include <kpopupmenu.h>
#include <kled.h>
#include <kiconloader.h>

#include "tse3/Transport.h"

namespace
{
    const int MSECS = 100;
}


SystemTrayWidget::SystemTrayWidget()
: KSystemTray()
{
    QHBoxLayout *hbox = new QHBoxLayout(this, 0, 0);

    status    = new QLabel(this);
    QVBox *vb = new QVBox(this);
    in        = new KLed(Qt::red,  KLed::Off, KLed::Flat, KLed::Circular, vb);
    out       = new KLed(Qt::green, KLed::Off, KLed::Flat, KLed::Circular, vb);
    inTimer   = new QTimer(this);
    outTimer  = new QTimer(this);

    connect(inTimer, SIGNAL(timeout()), SLOT(slotTimeoutIn()));
    connect(outTimer, SIGNAL(timeout()), SLOT(slotTimeoutOut()));

    hbox->addWidget(status);
    hbox->addWidget(vb);

    transport = Application::application()->transport();
    updateStatus();
    attachTo(transport);
    transport->attachCallback(this);

    KPopupMenu *menu = contextMenu();
    menu->setName(Application::application()->appName().c_str());
}


SystemTrayWidget::~SystemTrayWidget()
{
    transport->detachCallback(this);
}


void SystemTrayWidget::Transport_MidiIn(TSE3::MidiCommand)
{
    in->on();
    inTimer->start(MSECS, true);
}


void SystemTrayWidget::Transport_MidiOut(TSE3::MidiCommand)
{
    out->on();
    outTimer->start(MSECS, true);
}


void SystemTrayWidget::Transport_Status(TSE3::Transport *, int)
{
    updateStatus();
}


void SystemTrayWidget::slotTimeoutIn()
{
    in->off();
}


void SystemTrayWidget::slotTimeoutOut()
{
    out->off();
}


void SystemTrayWidget::updateStatus()
{
    switch (transport->status())
    {
        case TSE3::Transport::Resting:
        {
            status->setPixmap(UserIcon("a_stop"));
            break;
        }
        case TSE3::Transport::SynchroPlaying:
        case TSE3::Transport::Playing:
        {
            status->setPixmap(UserIcon("a_play"));
            break;
        }
        case TSE3::Transport::SynchroRecording:
        case TSE3::Transport::Recording:
        {
            status->setPixmap(UserIcon("a_record"));
            break;
        }
    }
}
