/*
 * @(#)SystemTrayWidget.h 1.00 15 January 2001
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_GADGETS_SYSTEMTRAYWIDGET_H
#define ANTHEM_GADGETS_SYSTEMTRAYWIDGET_H

#include <ksystemtray.h>

#include "tse3/Notifier.h"
#include "tse3/listen/Transport.h"

class KLed;
class QLabel;
class QTimer;

/**
 * A widget that sits in the system tray and provides status on the current
 * mode.
 *
 * @short   System tray status icon
 * @author  Pete Goodliffe
 * @version 1.0
 */
class SystemTrayWidget : public KSystemTray,
                         public TSE3::TransportCallback,
                         public TSE3::Listener<TSE3::TransportListener>
{
        Q_OBJECT

    public:

        /**
         * For expected operation the SystemTrayWidget has no parent.
         */
        SystemTrayWidget();
        ~SystemTrayWidget();

        /**
         * @reimplemented
         */
        virtual void Transport_MidiIn(TSE3::MidiCommand c);

        /**
         * @reimplemented
         */
        virtual void Transport_MidiOut(TSE3::MidiCommand c);

        /**
         * @reimplemented
         */
        virtual void Transport_Status(TSE3::Transport *, int status);

    protected slots:

        void slotTimeoutIn();
        void slotTimeoutOut();

    private:

        void updateStatus();

        TSE3::Transport *transport;
        QLabel          *status;
        KLed            *in;
        KLed            *out;
        QTimer          *inTimer;
        QTimer          *outTimer;
};

#endif
