/*
 * @(#)ZoomWidget.h 1.00 1 June 2000
 *
 * Copyright (c) Pete Goodliffe 2000 (pete@cthree.org)
 *
 * This file is part of anthem - the TSE3 sequencer.
 *
 * This program is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have recieved a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 0211-1307, USA.
 */

#ifndef ANTHEM_GADGETS_ZOOMWIDGET_H
#define ANTHEM_GADGETS_ZOOMWIDGET_H

#include <qwidget.h>

class QSlider;
class Zoomable;

/**
 * A widget that provides zooming facilities. It uses a @ref Zoomable
 * interface callback class to send zoom event details to.
 *
 * @short   Zoom selection choice widget
 * @author  Pete Goodliffe
 * @version 1.0
 */
class ZoomWidget : public QWidget
{
        Q_OBJECT

    public:

        /**
         * Creates a ZoomWidget. You must provide the @ref Zoomable
         * callback class to recieve zoom events.
         */
        ZoomWidget(Zoomable *callback,
                   QWidget *parent = 0, const char *name = 0);

    protected:

        virtual void showEvent(QShowEvent *event);

    protected slots:

        void zoomInHorizontal();
        void zoomOutHorizontal();
        void zoomInVertical();
        void zoomOutVertical();
        void horizontalChanged(int pc);
        void verticalChanged(int pc);

    private:

        Zoomable *callback;
        QSlider  *hori;
        QSlider  *vert;
};

#endif
